/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.IcebergContentFileStore;
import org.apache.impala.catalog.IcebergFileDescriptor;
import org.apache.impala.catalog.IcebergTable;
import org.apache.impala.catalog.PrunablePartition;
import org.apache.impala.catalog.Table;
import org.apache.impala.fb.FbFileDesc;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class IcebergContentFileStoreTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private CatalogServiceCatalog catalog_;

    @Before
    public void init() {
        this.catalog_ = CatalogServiceTestCatalog.create();
    }

    @After
    public void cleanUp() {
        this.catalog_.close();
    }

    private FbFileDesc createFbFileDesc() {
        FlatBufferBuilder fbb = new FlatBufferBuilder(1);
        fbb.finish(FbFileDesc.createFbFileDesc((FlatBufferBuilder)fbb, (int)0, (long)10L, (byte)0, (long)10000L, (int)0, (boolean)false, (int)0, (boolean)false));
        ByteBuffer bb = fbb.dataBuffer().slice();
        ByteBuffer compressedBb = ByteBuffer.allocate(bb.capacity());
        compressedBb.put(bb);
        return FbFileDesc.getRootAsFbFileDesc((ByteBuffer)((ByteBuffer)compressedBb.flip()));
    }

    @Test
    public void testEncodeDecode() throws Exception {
        IcebergTable iceTbl = this.loadIcebergTable("functional_parquet", "iceberg_v2_partitioned_position_deletes_orc");
        Assert.assertTrue((iceTbl.getContentFileStore().getNumFiles() > 0L ? 1 : 0) != 0);
        for (IcebergFileDescriptor fileDesc : iceTbl.getContentFileStore().getAllFiles()) {
            IcebergFileDescriptor serdeFileDesc;
            Assert.assertTrue((fileDesc != (serdeFileDesc = IcebergContentFileStore.decode((IcebergContentFileStore.EncodedFileDescriptor)IcebergContentFileStore.encode((IcebergFileDescriptor)fileDesc))) ? 1 : 0) != 0);
            Assert.assertEquals((Object)serdeFileDesc, (Object)fileDesc);
        }
    }

    @Test
    public void testFileDescriptorsAreShared() throws Exception {
        IcebergTable iceTbl = this.loadIcebergTable("functional_parquet", "iceberg_v2_partitioned_position_deletes");
        Assert.assertTrue((iceTbl.getContentFileStore().getNumFiles() > 0L ? 1 : 0) != 0);
        HashMap<String, FileDescriptor> fileDescsByPath = new HashMap<String, FileDescriptor>();
        for (FileDescriptor fileDesc : iceTbl.getContentFileStore().getAllFiles()) {
            fileDescsByPath.put(fileDesc.getRelativePath(), fileDesc);
        }
        Assert.assertTrue((boolean)(iceTbl.getFeFsTable() instanceof HdfsTable));
        HdfsTable hdfsTable = (HdfsTable)iceTbl.getFeFsTable();
        for (PrunablePartition partition : hdfsTable.getPartitions()) {
            Assert.assertTrue((boolean)(partition instanceof HdfsPartition));
            HdfsPartition hdfsPartition = (HdfsPartition)partition;
            for (FileDescriptor hdfsFileDesc : hdfsPartition.getFileDescriptors()) {
                FileDescriptor iceFileDesc = (FileDescriptor)fileDescsByPath.get(hdfsFileDesc.getRelativePath());
                Assert.assertNotNull((Object)iceFileDesc);
                Assert.assertNotSame((Object)iceFileDesc, (Object)hdfsFileDesc);
                Assert.assertEquals((Object)iceFileDesc.getFbFileDescriptor().getByteBuffer().array(), (Object)hdfsFileDesc.getFbFileDescriptor().getByteBuffer().array());
            }
        }
    }

    private IcebergTable loadIcebergTable(String dbName, String tblName) throws Exception {
        Table tbl = this.catalog_.getOrLoadTable(dbName, tblName, "test", null);
        Assert.assertTrue((boolean)(tbl instanceof IcebergTable));
        IcebergTable iceTbl = (IcebergTable)tbl;
        Assert.assertNotNull((Object)iceTbl.getContentFileStore());
        return iceTbl;
    }
}

