/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.HdfsStorageDescriptor;
import org.apache.impala.catalog.HiveStorageDescriptorFactory;
import org.apache.impala.catalog.RowFormat;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.THdfsFileFormat;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HdfsStorageDescriptorTest {
    @BeforeClass
    public static void setup() {
        FeSupport.loadLibrary();
    }

    @Test
    public void delimitersInCorrectOrder() {
        ImmutableList DELIMITER_KEYS = ImmutableList.of((Object)"line.delim", (Object)"field.delim", (Object)"collection.delim", (Object)"mapkey.delim", (Object)"escape.delim", (Object)"quote.delim");
        Assert.assertEquals((Object)DELIMITER_KEYS, (Object)HdfsStorageDescriptor.DELIMITER_KEYS);
    }

    @Test
    public void testParquetFileFormat() throws DatabaseNotFoundException, HdfsStorageDescriptor.InvalidStorageDescriptorException {
        String[] parquetSerDe = new String[]{"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", "parquet.hive.serde.ParquetHiveSerDe"};
        String[] inputFormats = new String[]{"com.cloudera.impala.hive.serde.ParquetInputFormat", "parquet.hive.DeprecatedParquetInputFormat", "parquet.hive.MapredParquetInputFormat", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat"};
        String[] outputFormats = new String[]{"com.cloudera.impala.hive.serde.ParquetOutputFormat", "parquet.hive.DeprecatedParquetOutputFormat", "parquet.hive.MapredParquetOutputFormat", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat"};
        for (String serDe : parquetSerDe) {
            SerDeInfo serDeInfo = new SerDeInfo();
            serDeInfo.setSerializationLib(serDe);
            serDeInfo.setParameters(new HashMap());
            for (String inputFormat : inputFormats) {
                for (String outputFormat : outputFormats) {
                    StorageDescriptor sd = new StorageDescriptor();
                    sd.setSerdeInfo(serDeInfo);
                    sd.setInputFormat(inputFormat);
                    sd.setOutputFormat(outputFormat);
                    Assert.assertNotNull((Object)HdfsStorageDescriptor.fromStorageDescriptor((String)"fakeTblName", (StorageDescriptor)sd));
                }
            }
        }
    }

    @Test
    public void testDelimiters() throws HdfsStorageDescriptor.InvalidStorageDescriptorException {
        StorageDescriptor sd = HiveStorageDescriptorFactory.createSd((THdfsFileFormat)THdfsFileFormat.TEXT, (RowFormat)RowFormat.DEFAULT_ROW_FORMAT);
        sd.setParameters(new HashMap());
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("field.delim", "-2");
        Assert.assertNotNull((Object)HdfsStorageDescriptor.fromStorageDescriptor((String)"fakeTbl", (StorageDescriptor)sd));
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("field.delim", "-128");
        Assert.assertNotNull((Object)HdfsStorageDescriptor.fromStorageDescriptor((String)"fakeTbl", (StorageDescriptor)sd));
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("field.delim", "127");
        Assert.assertNotNull((Object)HdfsStorageDescriptor.fromStorageDescriptor((String)"fakeTbl", (StorageDescriptor)sd));
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("line.delim", "\u0001");
        Assert.assertNotNull((Object)HdfsStorageDescriptor.fromStorageDescriptor((String)"fakeTbl", (StorageDescriptor)sd));
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("field.delim", "|");
        Assert.assertNotNull((Object)HdfsStorageDescriptor.fromStorageDescriptor((String)"fakeTbl", (StorageDescriptor)sd));
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("field.delim", "\t");
        Assert.assertNotNull((Object)HdfsStorageDescriptor.fromStorageDescriptor((String)"fakeTbl", (StorageDescriptor)sd));
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("field.delim", "ab");
        try {
            HdfsStorageDescriptor.fromStorageDescriptor((String)"fake", (StorageDescriptor)sd);
            Assert.fail();
        }
        catch (HdfsStorageDescriptor.InvalidStorageDescriptorException e) {
            Assert.assertEquals((Object)"Invalid delimiter: 'ab'. Delimiter must be specified as a single character or as a decimal value in the range [-128:127]", (Object)e.getMessage());
        }
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("field.delim", "128");
        try {
            HdfsStorageDescriptor.fromStorageDescriptor((String)"fake", (StorageDescriptor)sd);
            Assert.fail();
        }
        catch (HdfsStorageDescriptor.InvalidStorageDescriptorException e) {
            Assert.assertEquals((Object)"Invalid delimiter: '128'. Delimiter must be specified as a single character or as a decimal value in the range [-128:127]", (Object)e.getMessage());
        }
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("field.delim", "\n8");
        try {
            HdfsStorageDescriptor.fromStorageDescriptor((String)"fake", (StorageDescriptor)sd);
            Assert.fail();
        }
        catch (HdfsStorageDescriptor.InvalidStorageDescriptorException e) {
            Assert.assertEquals((Object)"Invalid delimiter: '\n8'. Delimiter must be specified as a single character or as a decimal value in the range [-128:127]", (Object)e.getMessage());
        }
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("line.delim", "-129");
        try {
            HdfsStorageDescriptor.fromStorageDescriptor((String)"fake", (StorageDescriptor)sd);
            Assert.fail();
        }
        catch (HdfsStorageDescriptor.InvalidStorageDescriptorException e) {
            Assert.assertEquals((Object)"Invalid delimiter: '-129'. Delimiter must be specified as a single character or as a decimal value in the range [-128:127]", (Object)e.getMessage());
        }
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("line.delim", "\u1111");
        try {
            HdfsStorageDescriptor.fromStorageDescriptor((String)"fake", (StorageDescriptor)sd);
            Assert.fail();
        }
        catch (HdfsStorageDescriptor.InvalidStorageDescriptorException e) {
            Assert.assertEquals((Object)"Invalid delimiter: '\u1111'. Delimiter must be specified as a single character or as a decimal value in the range [-128:127]", (Object)e.getMessage());
        }
        sd.getSerdeInfo().setParameters(new HashMap());
        sd.getSerdeInfo().putToParameters("field.delim", "\u0001");
        Assert.assertNotNull((Object)HdfsStorageDescriptor.fromStorageDescriptor((String)"fakeTbl", (StorageDescriptor)sd));
    }
}

