/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.FileMetadataLoader;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.Type;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.util.ListMap;
import org.junit.Assert;
import org.junit.Test;

public class HdfsPartitionTest {
    private List<LiteralExpr> valuesNull_ = new ArrayList<LiteralExpr>();
    private List<LiteralExpr> valuesDecimal_ = new ArrayList<LiteralExpr>();
    private List<LiteralExpr> valuesDecimal1_ = new ArrayList<LiteralExpr>();
    private List<LiteralExpr> valuesDecimal2_ = new ArrayList<LiteralExpr>();
    private List<LiteralExpr> valuesMixed_ = new ArrayList<LiteralExpr>();
    private List<LiteralExpr> valuesMixed1_ = new ArrayList<LiteralExpr>();
    private List<LiteralExpr> valuesMixed2_ = new ArrayList<LiteralExpr>();

    public HdfsPartitionTest() {
        this.valuesNull_.add((LiteralExpr)NullLiteral.create((Type)Type.BIGINT));
        this.valuesDecimal_.add((LiteralExpr)NumericLiteral.create((long)1L));
        this.valuesDecimal1_.add((LiteralExpr)NumericLiteral.create((long)3L));
        this.valuesDecimal2_.add((LiteralExpr)NumericLiteral.create((long)5L));
        this.valuesMixed_.add((LiteralExpr)NumericLiteral.create((long)3L));
        this.valuesMixed_.add((LiteralExpr)NullLiteral.create((Type)Type.BIGINT));
        this.valuesMixed1_.add((LiteralExpr)NumericLiteral.create((long)1L));
        this.valuesMixed1_.add((LiteralExpr)NullLiteral.create((Type)Type.STRING));
        this.valuesMixed1_.add((LiteralExpr)new BoolLiteral(true));
        this.valuesMixed2_.add((LiteralExpr)NumericLiteral.create((long)1L));
        this.valuesMixed2_.add((LiteralExpr)new StringLiteral("Large"));
        this.valuesMixed2_.add((LiteralExpr)new BoolLiteral(false));
    }

    @Test
    public void testCompare() {
        ArrayList<List<LiteralExpr>> allLists = new ArrayList<List<LiteralExpr>>();
        allLists.add(this.valuesNull_);
        allLists.add(this.valuesDecimal_);
        allLists.add(this.valuesDecimal1_);
        allLists.add(this.valuesDecimal2_);
        allLists.add(this.valuesMixed_);
        allLists.add(this.valuesMixed1_);
        allLists.add(this.valuesMixed2_);
        for (List list : allLists) {
            this.verifyReflexive(list);
            for (List list2 : allLists) {
                this.verifySymmetric(list, list2);
                for (List list3 : allLists) {
                    this.verifyTransitive(list, list2, list3);
                }
            }
        }
        ArrayList<LiteralExpr> valuesTest = new ArrayList<LiteralExpr>();
        valuesTest.add((LiteralExpr)NumericLiteral.create((long)3L));
        this.verifyAntiSymmetric(this.valuesDecimal1_, valuesTest, this.valuesNull_);
        valuesTest.add((LiteralExpr)NullLiteral.create((Type)Type.BIGINT));
        this.verifyAntiSymmetric(this.valuesMixed_, valuesTest, this.valuesDecimal_);
    }

    private void verifySymmetric(List<LiteralExpr> o1, List<LiteralExpr> o2) {
        Assert.assertTrue((Integer.signum(HdfsPartition.comparePartitionKeyValues(o1, o2)) == -Integer.signum(HdfsPartition.comparePartitionKeyValues(o2, o1)) ? 1 : 0) != 0);
    }

    private void verifyTransitive(List<LiteralExpr> o1, List<LiteralExpr> o2, List<LiteralExpr> o3) {
        if (HdfsPartition.comparePartitionKeyValues(o1, o2) > 0 && HdfsPartition.comparePartitionKeyValues(o2, o3) > 0) {
            Assert.assertTrue((HdfsPartition.comparePartitionKeyValues(o1, o3) > 0 ? 1 : 0) != 0);
        }
    }

    private void verifyReflexive(List<LiteralExpr> o1) {
        Assert.assertTrue((HdfsPartition.comparePartitionKeyValues(o1, o1) == 0 ? 1 : 0) != 0);
    }

    private void verifyAntiSymmetric(List<LiteralExpr> o1, List<LiteralExpr> o2, List<LiteralExpr> o3) {
        if (HdfsPartition.comparePartitionKeyValues(o1, o2) == 0) {
            Assert.assertTrue((Integer.signum(HdfsPartition.comparePartitionKeyValues(o1, o3)) == Integer.signum(HdfsPartition.comparePartitionKeyValues(o2, o3)) ? 1 : 0) != 0);
        }
    }

    private static List<TNetworkAddress> getAllReplicaAddresses(FileDescriptor fd, ListMap<TNetworkAddress> hostIndex) {
        ArrayList<TNetworkAddress> ret = new ArrayList<TNetworkAddress>();
        for (int i = 0; i < fd.getNumFileBlocks(); ++i) {
            for (int j = 0; j < fd.getFbFileBlock(i).replicaHostIdxsLength(); ++j) {
                int idx = fd.getFbFileBlock(i).replicaHostIdxs(j);
                ret.add((TNetworkAddress)hostIndex.getEntry(idx));
            }
        }
        return ret;
    }

    @Test
    public void testCloneWithNewHostIndex() throws Exception {
        String p = "hdfs://localhost:20500/test-warehouse/schemas";
        ListMap origIndex = new ListMap();
        FileMetadataLoader fml = new FileMetadataLoader(p, false, Collections.emptyList(), origIndex, null, null);
        fml.load();
        List fileDescriptors = fml.getLoadedFds();
        Assert.assertTrue((!fileDescriptors.isEmpty() ? 1 : 0) != 0);
        FileDescriptor fd = (FileDescriptor)fileDescriptors.get(0);
        List<TNetworkAddress> origAddresses = HdfsPartitionTest.getAllReplicaAddresses(fd, (ListMap<TNetworkAddress>)origIndex);
        ListMap newIndex = new ListMap();
        newIndex.populate(Lists.reverse((List)origIndex.getList()));
        FileDescriptor cloned = fd.cloneWithNewHostIndex(origIndex.getList(), newIndex);
        List<TNetworkAddress> newAddresses = HdfsPartitionTest.getAllReplicaAddresses(cloned, (ListMap<TNetworkAddress>)newIndex);
        Assert.assertEquals(origAddresses, newAddresses);
    }

    static {
        FeSupport.loadLibrary();
    }
}

