/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.FileMetadataLoader;
import org.apache.impala.catalog.HdfsFileFormat;
import org.apache.impala.catalog.IcebergFileDescriptor;
import org.apache.impala.catalog.IcebergFileMetadataLoader;
import org.apache.impala.catalog.iceberg.GroupedContentFiles;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.thrift.TIcebergPartition;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.ListMap;
import org.junit.Assert;
import org.junit.Test;

public class FileMetadataLoaderTest {
    @Test
    public void testRecursiveLoading() throws IOException, CatalogException {
        ListMap hostIndex = new ListMap();
        String tablePath = "hdfs://localhost:20500/test-warehouse/alltypes/";
        FileMetadataLoader fml = new FileMetadataLoader(tablePath, true, Collections.emptyList(), hostIndex, null, null);
        fml.load();
        Assert.assertEquals((long)24L, (long)fml.getStats().loadedFiles);
        Assert.assertEquals((long)24L, (long)fml.getLoadedFds().size());
        ArrayList relPaths = new ArrayList(Collections2.transform((Collection)fml.getLoadedFds(), FileDescriptor::getRelativePath));
        Collections.sort(relPaths);
        Assert.assertEquals((Object)"year=2009/month=1/090101.txt", relPaths.get(0));
        Assert.assertEquals((Object)"year=2010/month=9/100901.txt", relPaths.get(23));
        FileMetadataLoader refreshFml = new FileMetadataLoader(tablePath, true, (Iterable)fml.getLoadedFds(), hostIndex, null, null);
        refreshFml.load();
        Assert.assertEquals((long)24L, (long)refreshFml.getStats().skippedFiles);
        Assert.assertEquals((long)0L, (long)refreshFml.getStats().loadedFiles);
        Assert.assertEquals((Object)fml.getLoadedFds(), (Object)refreshFml.getLoadedFds());
        FileDescriptor fd = (FileDescriptor)fml.getLoadedFds().get(0);
        Path filePath = new Path(tablePath, fd.getRelativePath());
        FileSystem fs = filePath.getFileSystem(new Configuration());
        fs.setTimes(filePath, fd.getModificationTime() + 1L, -1L);
        refreshFml = new FileMetadataLoader(tablePath, true, (Iterable)fml.getLoadedFds(), hostIndex, null, null);
        refreshFml.load();
        Assert.assertEquals((long)1L, (long)refreshFml.getStats().loadedFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRecursiveLoadingWithoutBlockLocations() throws IOException, CatalogException {
        try {
            Configuration customConf = new Configuration();
            customConf.set("impala.preload-block-locations-for-scheduling.authority.localhost:20500", "false");
            FileSystemUtil.setConfiguration((Configuration)customConf);
            ListMap hostIndex = new ListMap();
            String tablePath = "hdfs://localhost:20500/test-warehouse/alltypes/";
            FileMetadataLoader fml = new FileMetadataLoader(tablePath, true, Collections.emptyList(), hostIndex, null, null);
            fml.load();
            List fileDescs = fml.getLoadedFds();
            for (FileDescriptor fd : fileDescs) {
                Assert.assertEquals((long)0L, (long)fd.getNumFileBlocks());
            }
        }
        finally {
            FileSystemUtil.setConfiguration((Configuration)new Configuration());
        }
    }

    @Test
    public void testHudiParquetLoading() throws IOException, CatalogException {
        ListMap hostIndex = new ListMap();
        String tablePath = "hdfs://localhost:20500/test-warehouse/hudi_parquet/";
        FileMetadataLoader fml = new FileMetadataLoader(tablePath, true, Collections.emptyList(), hostIndex, null, null, HdfsFileFormat.HUDI_PARQUET);
        fml.load();
        Assert.assertEquals((long)3L, (long)fml.getStats().loadedFiles);
        Assert.assertEquals((long)3L, (long)fml.getLoadedFds().size());
        ArrayList relPaths = new ArrayList(Collections2.transform((Collection)fml.getLoadedFds(), FileDescriptor::getRelativePath));
        Collections.sort(relPaths);
        Assert.assertEquals((Object)"year=2015/month=03/day=16/5f541af5-ca07-4329-ad8c-40fa9b353f35-0_2-103-391_20200210090618.parquet", relPaths.get(0));
        Assert.assertEquals((Object)"year=2015/month=03/day=17/675e035d-c146-4658-9404-fe590e296d80-0_0-103-389_20200210090618.parquet", relPaths.get(1));
        Assert.assertEquals((Object)"year=2016/month=03/day=15/940359ee-cc79-4974-8a2a-5d133a81a3fd-0_1-103-390_20200210090618.parquet", relPaths.get(2));
    }

    @Test
    public void testIcebergLoading() throws IOException, CatalogException {
        CatalogServiceTestCatalog catalog = CatalogServiceTestCatalog.create();
        IcebergFileMetadataLoader fml1 = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_partitioned", Collections.emptyList(), Collections.emptyList(), true);
        fml1.load();
        Assert.assertEquals((long)20L, (long)fml1.getStats().loadedFiles);
        Assert.assertEquals((long)0L, (long)fml1.getStats().skippedFiles);
        Assert.assertEquals((long)20L, (long)fml1.getLoadedFds().size());
        ArrayList relPaths = new ArrayList(Collections2.transform((Collection)fml1.getLoadedFds(), FileDescriptor::getRelativePath));
        Collections.sort(relPaths);
        Assert.assertEquals((Object)"data/event_time_hour=2020-01-01-08/action=view/00001-1-b975a171-0911-47c2-90c8-300f23c28772-00000.parquet", relPaths.get(0));
        IcebergFileMetadataLoader fml2 = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_non_partitioned", Collections.emptyList(), Collections.emptyList(), true);
        fml2.load();
        Assert.assertEquals((long)20L, (long)fml2.getStats().loadedFiles);
        Assert.assertEquals((long)0L, (long)fml2.getStats().skippedFiles);
        Assert.assertEquals((long)20L, (long)fml2.getLoadedFds().size());
        relPaths = new ArrayList(Collections2.transform((Collection)fml2.getLoadedFds(), FileDescriptor::getRelativePath));
        Collections.sort(relPaths);
        Assert.assertEquals((Object)"data/00001-1-5dbd44ad-18bc-40f2-9dd6-aeb2cc23457c-00000.parquet", relPaths.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIcebergLoadingWithoutBlockLocations() throws IOException, CatalogException {
        try {
            Configuration customConf = new Configuration();
            customConf.set("impala.preload-block-locations-for-scheduling.scheme.hdfs", "false");
            FileSystemUtil.setConfiguration((Configuration)customConf);
            CatalogServiceTestCatalog catalog = CatalogServiceTestCatalog.create();
            IcebergFileMetadataLoader fml = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_partitioned", Collections.emptyList(), Collections.emptyList(), true);
            fml.load();
            List fileDescs = fml.getLoadedIcebergFds();
            for (IcebergFileDescriptor fd : fileDescs) {
                Assert.assertEquals((long)0L, (long)fd.getNumFileBlocks());
            }
        }
        finally {
            FileSystemUtil.setConfiguration((Configuration)new Configuration());
        }
    }

    @Test
    public void testIcebergRefresh() throws IOException, CatalogException {
        CatalogServiceTestCatalog catalog = CatalogServiceTestCatalog.create();
        IcebergFileMetadataLoader fml1 = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_partitioned", Collections.emptyList(), Collections.emptyList(), true);
        fml1.load();
        IcebergFileMetadataLoader fml1Refresh = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_partitioned", fml1.getLoadedIcebergFds(), fml1.getIcebergPartitionList(), true);
        fml1Refresh.load();
        Assert.assertEquals((long)0L, (long)fml1Refresh.getStats().loadedFiles);
        Assert.assertEquals((long)20L, (long)fml1Refresh.getStats().skippedFiles);
        Assert.assertEquals((long)20L, (long)fml1Refresh.getLoadedFds().size());
        ArrayList relPaths = new ArrayList(Collections2.transform((Collection)fml1Refresh.getLoadedFds(), FileDescriptor::getRelativePath));
        Collections.sort(relPaths);
        Assert.assertEquals((Object)"data/event_time_hour=2020-01-01-08/action=view/00001-1-b975a171-0911-47c2-90c8-300f23c28772-00000.parquet", relPaths.get(0));
        IcebergFileMetadataLoader fml2 = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_non_partitioned", Collections.emptyList(), Collections.emptyList(), true);
        fml2.load();
        IcebergFileMetadataLoader fml2Refresh = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_non_partitioned", fml2.getLoadedIcebergFds(), fml1.getIcebergPartitionList(), true);
        fml2Refresh.load();
        Assert.assertEquals((long)0L, (long)fml2Refresh.getStats().loadedFiles);
        Assert.assertEquals((long)20L, (long)fml2Refresh.getStats().skippedFiles);
        Assert.assertEquals((long)20L, (long)fml2Refresh.getLoadedFds().size());
        relPaths = new ArrayList(Collections2.transform((Collection)fml2Refresh.getLoadedFds(), FileDescriptor::getRelativePath));
        Collections.sort(relPaths);
        Assert.assertEquals((Object)"data/00001-1-5dbd44ad-18bc-40f2-9dd6-aeb2cc23457c-00000.parquet", relPaths.get(0));
    }

    @Test
    public void testIcebergPartialRefresh() throws IOException, CatalogException {
        CatalogServiceTestCatalog catalog = CatalogServiceTestCatalog.create();
        IcebergFileMetadataLoader fml1 = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_partitioned", Collections.emptyList(), Collections.emptyList(), true);
        fml1.load();
        IcebergFileMetadataLoader fml1Refresh = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_partitioned", fml1.getLoadedIcebergFds().subList(0, 10), fml1.getIcebergPartitionList(), true);
        fml1Refresh.load();
        Assert.assertEquals((long)10L, (long)fml1Refresh.getStats().loadedFiles);
        Assert.assertEquals((long)10L, (long)fml1Refresh.getStats().skippedFiles);
        Assert.assertEquals((long)20L, (long)fml1Refresh.getLoadedFds().size());
        IcebergFileMetadataLoader fml2 = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_non_partitioned", Collections.emptyList(), Collections.emptyList(), true);
        fml2.load();
        IcebergFileMetadataLoader fml2Refresh = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_non_partitioned", fml2.getLoadedIcebergFds().subList(0, 10), fml1.getIcebergPartitionList(), true);
        fml2Refresh.load();
        Assert.assertEquals((long)10L, (long)fml2Refresh.getStats().loadedFiles);
        Assert.assertEquals((long)10L, (long)fml2Refresh.getStats().skippedFiles);
        Assert.assertEquals((long)20L, (long)fml2Refresh.getLoadedFds().size());
    }

    @Test
    public void testIcebergMultipleStorageLocations() throws IOException, CatalogException {
        CatalogServiceTestCatalog catalog = CatalogServiceTestCatalog.create();
        BackendConfig.INSTANCE.setIcebergAllowDatafileInTableLocationOnly(false);
        IcebergFileMetadataLoader fml1 = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_multiple_storage_locations", Collections.emptyList(), Collections.emptyList(), false);
        fml1.load();
        IcebergFileMetadataLoader fml1Refresh1 = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_multiple_storage_locations", fml1.getLoadedIcebergFds().subList(0, 1), fml1.getIcebergPartitionList(), false);
        fml1Refresh1.load();
        Assert.assertEquals((long)5L, (long)fml1Refresh1.getStats().loadedFiles);
        Assert.assertEquals((long)1L, (long)fml1Refresh1.getStats().skippedFiles);
        Assert.assertEquals((long)6L, (long)fml1Refresh1.getLoadedFds().size());
        IcebergFileMetadataLoader fml1Refresh5 = this.getLoaderForIcebergTable(catalog, "functional_parquet", "iceberg_multiple_storage_locations", fml1.getLoadedIcebergFds().subList(0, 5), fml1.getIcebergPartitionList(), false);
        fml1Refresh5.load();
        Assert.assertEquals((long)1L, (long)fml1Refresh5.getStats().loadedFiles);
        Assert.assertEquals((long)5L, (long)fml1Refresh5.getStats().skippedFiles);
        Assert.assertEquals((long)6L, (long)fml1Refresh5.getLoadedFds().size());
    }

    private IcebergFileMetadataLoader getLoaderForIcebergTable(CatalogServiceCatalog catalog, String dbName, String tblName, List<IcebergFileDescriptor> oldFds, List<TIcebergPartition> oldPartitions, boolean requiresDataFilesInTableLocation) throws CatalogException {
        ListMap hostIndex = new ListMap();
        FeIcebergTable iceT = (FeIcebergTable)catalog.getOrLoadTable(dbName, tblName, "test", null);
        Path location = new Path(iceT.getLocation());
        GroupedContentFiles iceFiles = IcebergUtil.getIcebergFiles((FeIcebergTable)iceT, Collections.emptyList(), null);
        return new IcebergFileMetadataLoader(iceT.getIcebergApiTable(), oldFds, hostIndex, iceFiles, oldPartitions, requiresDataFilesInTableLocation);
    }

    private FileMetadataLoader getLoaderForAcidTable(String validWriteIdString, String path, HdfsFileFormat format) throws IOException, CatalogException {
        ListMap hostIndex = new ListMap();
        ValidWriteIdList writeIds = MetastoreShim.getValidWriteIdListFromString((String)validWriteIdString);
        FileMetadataLoader fml = new FileMetadataLoader(path, true, Collections.emptyList(), hostIndex, (ValidTxnList)new ValidReadTxnList(""), writeIds, format);
        fml.load();
        return fml;
    }

    @Test
    public void testAcidMinorCompactionLoading() throws IOException, CatalogException {
        FileMetadataLoader fml = this.getLoaderForAcidTable("functional_orc_def.complextypestbl_minor_compacted:10:10::", "hdfs://localhost:20500/test-warehouse/managed/functional_orc_def.db/complextypestbl_minor_compacted_orc_def/", HdfsFileFormat.ORC);
        Assert.assertEquals((long)1L, (long)fml.getStats().loadedFiles);
        Assert.assertEquals((long)8L, (long)fml.getStats().filesSupersededByAcidState);
        fml = this.getLoaderForAcidTable("functional_parquet.insert_only_minor_compacted:6:6::", "hdfs://localhost:20500/test-warehouse/managed/functional_parquet.db/insert_only_minor_compacted_parquet/", HdfsFileFormat.PARQUET);
        Assert.assertEquals((long)3L, (long)fml.getStats().loadedFiles);
        Assert.assertEquals((long)2L, (long)fml.getStats().filesSupersededByAcidState);
    }

    @Test
    public void testLoadMissingDirectory() throws IOException, CatalogException {
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
        while (unmodifiableIterator.hasNext()) {
            boolean recursive = (Boolean)unmodifiableIterator.next();
            ListMap hostIndex = new ListMap();
            String tablePath = "hdfs://localhost:20500/test-warehouse/does-not-exist/";
            FileMetadataLoader fml = new FileMetadataLoader(tablePath, recursive, Collections.emptyList(), hostIndex, null, null);
            fml.load();
            Assert.assertEquals((long)0L, (long)fml.getLoadedFds().size());
        }
    }

    @Test
    public void testSkipHiddenDirectories() throws IOException, CatalogException {
        Path sourcePath = new Path("hdfs://localhost:20500/test-warehouse/alltypes/");
        String tmpTestPathStr = "hdfs://localhost:20500/tmp/test-filemetadata-loader";
        Path tmpTestPath = new Path(tmpTestPathStr);
        Configuration conf = new Configuration();
        FileSystem dstFs = tmpTestPath.getFileSystem(conf);
        FileSystem srcFs = sourcePath.getFileSystem(conf);
        FileUtil.copy((FileSystem)srcFs, (Path)sourcePath, (FileSystem)dstFs, (Path)tmpTestPath, (boolean)false, (boolean)true, (Configuration)conf);
        dstFs.deleteOnExit(tmpTestPath);
        Path hiveStaging = new Path(tmpTestPath, ".hive-staging_hive_2019-06-13_1234");
        dstFs.mkdirs(hiveStaging);
        Path manifestDir = new Path(tmpTestPath, "_tmp.base_0000007");
        dstFs.mkdirs(manifestDir);
        dstFs.createNewFile(new Path(manifestDir, "000000_0.manifest"));
        dstFs.createNewFile(new Path(hiveStaging, "tmp-stats"));
        dstFs.createNewFile(new Path(hiveStaging, ".hidden-tmp-stats"));
        FileMetadataLoader fml = new FileMetadataLoader(tmpTestPathStr, true, Collections.emptyList(), new ListMap(), null, null);
        fml.load();
        Assert.assertEquals((long)24L, (long)fml.getStats().loadedFiles);
        Assert.assertEquals((long)24L, (long)fml.getLoadedFds().size());
    }
}

