/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobalStorageStatistics;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.hdfs.DFSOpsCountStatistics;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogObject;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.HBaseColumn;
import org.apache.impala.catalog.HBaseTable;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.IncompleteTable;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.PartitionStatsUtil;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.Principal;
import org.apache.impala.catalog.Role;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.User;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.Reference;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TGetPartitionStatsRequest;
import org.apache.impala.thrift.TPartitionKeyValue;
import org.apache.impala.thrift.TPartitionStats;
import org.apache.impala.thrift.TPrincipalType;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TPrivilegeLevel;
import org.apache.impala.thrift.TPrivilegeScope;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.NoOpEventSequence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class CatalogTest {
    private CatalogServiceCatalog catalog_;
    private static final String LIST_LOCATED_STATUS = DFSOpsCountStatistics.OpType.LIST_LOCATED_STATUS.getSymbol();
    private static final String LIST_STATUS = DFSOpsCountStatistics.OpType.LIST_STATUS.getSymbol();
    private static final String GET_FILE_STATUS = DFSOpsCountStatistics.OpType.GET_FILE_STATUS.getSymbol();
    private static final String GET_FILE_BLOCK_LOCS = DFSOpsCountStatistics.OpType.GET_FILE_BLOCK_LOCATIONS.getSymbol();

    @Before
    public void init() {
        this.catalog_ = CatalogServiceTestCatalog.create();
    }

    @After
    public void cleanUp() {
        this.catalog_.close();
    }

    public static void checkTableCols(FeDb db, String tblName, int numClusteringCols, String[] colNames, Type[] colTypes) throws TableLoadingException {
        FeTable tbl = db.getTable(tblName);
        Assert.assertEquals((Object)tbl.getName(), (Object)tblName);
        Assert.assertEquals((long)tbl.getNumClusteringCols(), (long)numClusteringCols);
        List cols = tbl.getColumns();
        Assert.assertEquals((long)colNames.length, (long)colTypes.length);
        Assert.assertEquals((long)cols.size(), (long)colNames.length);
        Iterator it = cols.iterator();
        int i = 0;
        while (it.hasNext()) {
            Column col = (Column)it.next();
            Assert.assertEquals((Object)col.getName(), (Object)colNames[i]);
            Assert.assertTrue((boolean)col.getType().equals((Object)colTypes[i]));
            ++i;
        }
    }

    private void checkHBaseTableCols(Db db, String hiveTableName, String hbaseTableName, String[] hiveColNames, String[] colFamilies, String[] colQualifiers, Type[] colTypes) throws TableLoadingException {
        CatalogTest.checkTableCols((FeDb)db, hiveTableName, 1, hiveColNames, colTypes);
        HBaseTable tbl = (HBaseTable)db.getTable(hiveTableName);
        Assert.assertEquals((Object)tbl.getHBaseTableName(), (Object)hbaseTableName);
        List cols = tbl.getColumns();
        Assert.assertEquals((long)colFamilies.length, (long)colTypes.length);
        Assert.assertEquals((long)colQualifiers.length, (long)colTypes.length);
        Iterator it = cols.iterator();
        int i = 0;
        while (it.hasNext()) {
            HBaseColumn col = (HBaseColumn)it.next();
            Assert.assertEquals((Object)col.getColumnFamily(), (Object)colFamilies[i]);
            Assert.assertEquals((Object)col.getColumnQualifier(), (Object)colQualifiers[i]);
            ++i;
        }
    }

    @Test
    public void TestColSchema() throws CatalogException {
        Db functionalDb = this.catalog_.getDb("functional");
        Assert.assertNotNull((Object)functionalDb);
        Assert.assertEquals((Object)functionalDb.getName(), (Object)"functional");
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "alltypes", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "alltypes_view", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "alltypes_view_sub", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "alltypessmall", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "alltypeserror", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "alltypeserrornonulls", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "alltypesagg", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "alltypesaggnonulls", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "alltypesnopart", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "alltypesinsert", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "complex_view", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "testtbl", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "dimtbl", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "jointbl", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "liketbl", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "greptiny", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "rankingssmall", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "uservisitssmall", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "view_view", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "date_tbl", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "binary_tbl", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional", "StringPartitionKey", "test", null));
        Assert.assertNull((Object)this.catalog_.getOrLoadTable("functional", "nonexistenttable", "test", null));
        Db testDb = this.catalog_.getDb("functional_seq");
        Assert.assertNotNull((Object)testDb);
        Assert.assertEquals((Object)testDb.getName(), (Object)"functional_seq");
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional_seq", "alltypes", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable("functional_seq", "testtbl", "test", null));
        Db hbaseDb = this.catalog_.getDb("functional_hbase");
        Assert.assertNotNull((Object)hbaseDb);
        Assert.assertEquals((Object)hbaseDb.getName(), (Object)"functional_hbase");
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable(hbaseDb.getName(), "alltypessmallbinary", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable(hbaseDb.getName(), "alltypessmall", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable(hbaseDb.getName(), "hbasealltypeserror", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable(hbaseDb.getName(), "hbasealltypeserrornonulls", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable(hbaseDb.getName(), "alltypesagg", "test", null));
        Assert.assertNotNull((Object)this.catalog_.getOrLoadTable(hbaseDb.getName(), "stringids", "test", null));
        CatalogTest.checkTableCols((FeDb)functionalDb, "alltypes", 2, new String[]{"year", "month", "id", "bool_col", "tinyint_col", "smallint_col", "int_col", "bigint_col", "float_col", "double_col", "date_string_col", "string_col", "timestamp_col"}, new Type[]{Type.INT, Type.INT, Type.INT, Type.BOOLEAN, Type.TINYINT, Type.SMALLINT, Type.INT, Type.BIGINT, Type.FLOAT, Type.DOUBLE, Type.STRING, Type.STRING, Type.TIMESTAMP});
        CatalogTest.checkTableCols((FeDb)functionalDb, "testtbl", 0, new String[]{"id", "name", "zip"}, new Type[]{Type.BIGINT, Type.STRING, Type.INT});
        CatalogTest.checkTableCols((FeDb)testDb, "testtbl", 0, new String[]{"id", "name", "zip"}, new Type[]{Type.BIGINT, Type.STRING, Type.INT});
        CatalogTest.checkTableCols((FeDb)functionalDb, "liketbl", 0, new String[]{"str_col", "match_like_col", "no_match_like_col", "match_regex_col", "no_match_regex_col"}, new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.STRING});
        CatalogTest.checkTableCols((FeDb)functionalDb, "dimtbl", 0, new String[]{"id", "name", "zip"}, new Type[]{Type.BIGINT, Type.STRING, Type.INT});
        CatalogTest.checkTableCols((FeDb)functionalDb, "jointbl", 0, new String[]{"test_id", "test_name", "test_zip", "alltypes_id"}, new Type[]{Type.BIGINT, Type.STRING, Type.INT, Type.INT});
        this.checkHBaseTableCols(hbaseDb, "alltypessmall", "functional_hbase.alltypessmall", new String[]{"id", "bigint_col", "bool_col", "date_string_col", "double_col", "float_col", "int_col", "month", "smallint_col", "string_col", "timestamp_col", "tinyint_col", "year"}, new String[]{":key", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d"}, new String[]{null, "bigint_col", "bool_col", "date_string_col", "double_col", "float_col", "int_col", "month", "smallint_col", "string_col", "timestamp_col", "tinyint_col", "year"}, new Type[]{Type.INT, Type.BIGINT, Type.BOOLEAN, Type.STRING, Type.DOUBLE, Type.FLOAT, Type.INT, Type.INT, Type.SMALLINT, Type.STRING, Type.TIMESTAMP, Type.TINYINT, Type.INT});
        this.checkHBaseTableCols(hbaseDb, "hbasealltypeserror", "functional_hbase.hbasealltypeserror", new String[]{"id", "bigint_col", "bool_col", "date_string_col", "double_col", "float_col", "int_col", "smallint_col", "string_col", "timestamp_col", "tinyint_col"}, new String[]{":key", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d"}, new String[]{null, "bigint_col", "bool_col", "date_string_col", "double_col", "float_col", "int_col", "smallint_col", "string_col", "timestamp_col", "tinyint_col"}, new Type[]{Type.INT, Type.BIGINT, Type.BOOLEAN, Type.STRING, Type.DOUBLE, Type.FLOAT, Type.INT, Type.SMALLINT, Type.STRING, Type.TIMESTAMP, Type.TINYINT});
        this.checkHBaseTableCols(hbaseDb, "hbasealltypeserrornonulls", "functional_hbase.hbasealltypeserrornonulls", new String[]{"id", "bigint_col", "bool_col", "date_string_col", "double_col", "float_col", "int_col", "smallint_col", "string_col", "timestamp_col", "tinyint_col"}, new String[]{":key", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d"}, new String[]{null, "bigint_col", "bool_col", "date_string_col", "double_col", "float_col", "int_col", "smallint_col", "string_col", "timestamp_col", "tinyint_col"}, new Type[]{Type.INT, Type.BIGINT, Type.BOOLEAN, Type.STRING, Type.DOUBLE, Type.FLOAT, Type.INT, Type.SMALLINT, Type.STRING, Type.TIMESTAMP, Type.TINYINT});
        this.checkHBaseTableCols(hbaseDb, "alltypesagg", "functional_hbase.alltypesagg", new String[]{"id", "bigint_col", "bool_col", "date_string_col", "day", "double_col", "float_col", "int_col", "month", "smallint_col", "string_col", "timestamp_col", "tinyint_col", "year"}, new String[]{":key", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d"}, new String[]{null, "bigint_col", "bool_col", "date_string_col", "day", "double_col", "float_col", "int_col", "month", "smallint_col", "string_col", "timestamp_col", "tinyint_col", "year"}, new Type[]{Type.INT, Type.BIGINT, Type.BOOLEAN, Type.STRING, Type.INT, Type.DOUBLE, Type.FLOAT, Type.INT, Type.INT, Type.SMALLINT, Type.STRING, Type.TIMESTAMP, Type.TINYINT, Type.INT});
        this.checkHBaseTableCols(hbaseDb, "stringids", "functional_hbase.alltypesagg", new String[]{"id", "bigint_col", "bool_col", "date_string_col", "day", "double_col", "float_col", "int_col", "month", "smallint_col", "string_col", "timestamp_col", "tinyint_col", "year"}, new String[]{":key", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d", "d"}, new String[]{null, "bigint_col", "bool_col", "date_string_col", "day", "double_col", "float_col", "int_col", "month", "smallint_col", "string_col", "timestamp_col", "tinyint_col", "year"}, new Type[]{Type.STRING, Type.BIGINT, Type.BOOLEAN, Type.STRING, Type.INT, Type.DOUBLE, Type.FLOAT, Type.INT, Type.INT, Type.SMALLINT, Type.STRING, Type.TIMESTAMP, Type.TINYINT, Type.INT});
        CatalogTest.checkTableCols((FeDb)functionalDb, "greptiny", 0, new String[]{"field"}, new Type[]{Type.STRING});
        CatalogTest.checkTableCols((FeDb)functionalDb, "rankingssmall", 0, new String[]{"pagerank", "pageurl", "avgduration"}, new Type[]{Type.INT, Type.STRING, Type.INT});
        CatalogTest.checkTableCols((FeDb)functionalDb, "uservisitssmall", 0, new String[]{"sourceip", "desturl", "visitdate", "adrevenue", "useragent", "ccode", "lcode", "skeyword", "avgtimeonsite"}, new Type[]{Type.STRING, Type.STRING, Type.STRING, Type.FLOAT, Type.STRING, Type.STRING, Type.STRING, Type.STRING, Type.INT});
        CatalogTest.checkTableCols((FeDb)functionalDb, "date_tbl", 1, new String[]{"date_part", "id_col", "date_col"}, new Type[]{Type.DATE, Type.INT, Type.DATE});
        CatalogTest.checkTableCols((FeDb)functionalDb, "binary_tbl", 0, new String[]{"id", "string_col", "binary_col"}, new Type[]{Type.INT, Type.STRING, Type.BINARY});
        Assert.assertEquals((Object)this.catalog_.getOrLoadTable("functional", "alltypes", "test", null), (Object)this.catalog_.getOrLoadTable("functional", "AllTypes", "test", null));
    }

    @Test
    public void testNumberOfGetFileStatusCalls() throws CatalogException, IOException {
        GlobalStorageStatistics stats = FileSystem.getGlobalStorageStatistics();
        stats.reset();
        this.catalog_.invalidateTable(new TTableName("functional", "alltypes"), new Reference(), new Reference(), (EventSequence)NoOpEventSequence.INSTANCE);
        HdfsTable table = (HdfsTable)this.catalog_.getOrLoadTable("functional", "alltypes", "test", null);
        StorageStatistics opsCounts = stats.get("DFSOpsCountStatistics");
        boolean isMinimalTopicMode = BackendConfig.INSTANCE.isMinimalTopicMode();
        long expectedCalls = table.getPartitionIds().size() + (isMinimalTopicMode ? 0 : 2);
        long seenCalls = opsCounts.getLong(LIST_LOCATED_STATUS) + opsCounts.getLong(LIST_STATUS);
        Assert.assertEquals((long)expectedCalls, (long)seenCalls);
        long expectedGetFileStatus = isMinimalTopicMode ? 0L : 1L;
        Assert.assertEquals((long)expectedGetFileStatus, (long)opsCounts.getLong(GET_FILE_STATUS));
        Assert.assertEquals((long)0L, (long)opsCounts.getLong(GET_FILE_BLOCK_LOCS));
        stats.reset();
        this.catalog_.reloadTable((Table)table, "test", (EventSequence)NoOpEventSequence.INSTANCE);
        Assert.assertEquals((long)expectedGetFileStatus, (long)opsCounts.getLong(GET_FILE_STATUS));
        seenCalls = opsCounts.getLong(LIST_LOCATED_STATUS) + opsCounts.getLong(LIST_STATUS);
        Assert.assertEquals((long)table.getPartitionIds().size(), (long)seenCalls);
        Assert.assertEquals((long)0L, (long)opsCounts.getLong(GET_FILE_BLOCK_LOCS));
        stats.reset();
        ImmutableList partitionSpec = ImmutableList.of((Object)new TPartitionKeyValue("year", "2010"), (Object)new TPartitionKeyValue("month", "10"));
        this.catalog_.reloadPartition((Table)table, (List)partitionSpec, new Reference((Object)false), CatalogObject.ThriftObjectType.NONE, "test", (EventSequence)NoOpEventSequence.INSTANCE);
        Assert.assertEquals((long)0L, (long)opsCounts.getLong(GET_FILE_BLOCK_LOCS));
        stats.reset();
        HdfsTable unpartTable = (HdfsTable)this.catalog_.getOrLoadTable("functional", "alltypesaggmultifilesnopart", "test", null);
        Assert.assertEquals((long)0L, (long)opsCounts.getLong(GET_FILE_BLOCK_LOCS));
        stats.reset();
        this.catalog_.reloadTable((Table)unpartTable, "test", (EventSequence)NoOpEventSequence.INSTANCE);
        Assert.assertEquals((long)0L, (long)opsCounts.getLong(GET_FILE_BLOCK_LOCS));
        HdfsPartition.Builder partBuilder = new HdfsPartition.Builder(table.getPartitionFromThriftPartitionSpec((List)partitionSpec));
        partBuilder.setFileDescriptors(new ArrayList());
        table.updatePartition(partBuilder);
        stats.reset();
        this.catalog_.reloadPartition((Table)table, (List)partitionSpec, new Reference((Object)false), CatalogObject.ThriftObjectType.NONE, "test", (EventSequence)NoOpEventSequence.INSTANCE);
        Assert.assertEquals((long)0L, (long)opsCounts.getLong(GET_FILE_BLOCK_LOCS));
        seenCalls = opsCounts.getLong(LIST_LOCATED_STATUS) + opsCounts.getLong(LIST_STATUS);
        Assert.assertEquals((long)1L, (long)seenCalls);
    }

    @Test
    public void TestPartitions() throws CatalogException {
        HdfsTable table = (HdfsTable)this.catalog_.getOrLoadTable("functional", "AllTypes", "test", null);
        CatalogTest.checkAllTypesPartitioning((FeFsTable)table);
    }

    @Test
    public void testGetSqlConstraints() throws Exception {
        FeFsTable t = (FeFsTable)this.catalog_.getOrLoadTable("functional", "parent_table", "test", null);
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)(t instanceof FeFsTable));
        List primaryKeys = t.getSqlConstraints().getPrimaryKeys();
        List foreignKeys = t.getSqlConstraints().getForeignKeys();
        Assert.assertEquals((long)2L, (long)primaryKeys.size());
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        for (SQLPrimaryKey pk : primaryKeys) {
            Assert.assertEquals((Object)"functional", (Object)pk.getTable_db());
            Assert.assertEquals((Object)"parent_table", (Object)pk.getTable_name());
        }
        Assert.assertEquals((Object)"id", (Object)((SQLPrimaryKey)primaryKeys.get(0)).getColumn_name());
        Assert.assertEquals((Object)"year", (Object)((SQLPrimaryKey)primaryKeys.get(1)).getColumn_name());
        this.catalog_.getOrLoadTable("functional", "parent_table_2", "test", null);
        t = (FeFsTable)this.catalog_.getOrLoadTable("functional", "child_table", "test", null);
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)(t instanceof FeFsTable));
        primaryKeys = t.getSqlConstraints().getPrimaryKeys();
        foreignKeys = t.getSqlConstraints().getForeignKeys();
        Assert.assertEquals((long)1L, (long)primaryKeys.size());
        Assert.assertEquals((long)3L, (long)foreignKeys.size());
        Assert.assertEquals((Object)"functional", (Object)((SQLPrimaryKey)primaryKeys.get(0)).getTable_db());
        Assert.assertEquals((Object)"child_table", (Object)((SQLPrimaryKey)primaryKeys.get(0)).getTable_name());
        for (SQLForeignKey fk : foreignKeys) {
            Assert.assertEquals((Object)"functional", (Object)fk.getFktable_db());
            Assert.assertEquals((Object)"child_table", (Object)fk.getFktable_name());
            Assert.assertEquals((Object)"functional", (Object)fk.getPktable_db());
        }
        Assert.assertEquals((Object)"parent_table", (Object)((SQLForeignKey)foreignKeys.get(0)).getPktable_name());
        Assert.assertEquals((Object)"parent_table", (Object)((SQLForeignKey)foreignKeys.get(1)).getPktable_name());
        Assert.assertEquals((Object)"parent_table_2", (Object)((SQLForeignKey)foreignKeys.get(2)).getPktable_name());
        Assert.assertEquals((Object)"id", (Object)((SQLForeignKey)foreignKeys.get(0)).getPkcolumn_name());
        Assert.assertEquals((Object)"year", (Object)((SQLForeignKey)foreignKeys.get(1)).getPkcolumn_name());
        Assert.assertEquals((Object)"a", (Object)((SQLForeignKey)foreignKeys.get(2)).getPkcolumn_name());
        Assert.assertEquals((Object)((SQLForeignKey)foreignKeys.get(0)).getFk_name(), (Object)((SQLForeignKey)foreignKeys.get(1)).getFk_name());
        t = (FeFsTable)this.catalog_.getOrLoadTable("functional", "alltypes", "test", null);
        Assert.assertNotNull((Object)t);
        Assert.assertTrue((boolean)(t instanceof FeFsTable));
        primaryKeys = t.getSqlConstraints().getPrimaryKeys();
        foreignKeys = t.getSqlConstraints().getForeignKeys();
        Assert.assertNotNull((Object)primaryKeys);
        Assert.assertNotNull((Object)foreignKeys);
        Assert.assertEquals((long)0L, (long)primaryKeys.size());
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
    }

    public static void checkAllTypesPartitioning(FeFsTable table) {
        Assert.assertEquals((long)24L, (long)table.getPartitionIds().size());
        Assert.assertEquals((long)24L, (long)table.getPartitions().size());
        Collection partitions = table.loadAllPartitions();
        Assert.assertEquals((long)24L, (long)partitions.size());
        Set uniqueSds = Collections.newSetFromMap(new IdentityHashMap());
        HashSet<Long> months = new HashSet<Long>();
        for (FeFsPartition p : partitions) {
            Assert.assertEquals((long)2L, (long)p.getPartitionValues().size());
            LiteralExpr key1Expr = (LiteralExpr)p.getPartitionValues().get(0);
            Assert.assertTrue((boolean)(key1Expr instanceof NumericLiteral));
            long key1 = ((NumericLiteral)key1Expr).getLongValue();
            Assert.assertTrue((key1 == 2009L || key1 == 2010L ? 1 : 0) != 0);
            LiteralExpr key2Expr = (LiteralExpr)p.getPartitionValues().get(1);
            Assert.assertTrue((boolean)(key2Expr instanceof NumericLiteral));
            long key2 = ((NumericLiteral)key2Expr).getLongValue();
            Assert.assertTrue((key2 >= 1L && key2 <= 12L ? 1 : 0) != 0);
            months.add(key1 * 100L + key2);
            Assert.assertEquals((long)p.getFileDescriptors().size(), (long)1L);
            uniqueSds.add(p.getInputFormatDescriptor());
        }
        Assert.assertEquals((long)months.size(), (long)24L);
        Assert.assertEquals((long)1L, (long)uniqueSds.size());
    }

    @Test
    public void testStats() throws CatalogException {
        HdfsTable table = (HdfsTable)this.catalog_.getOrLoadTable("functional", "AllTypesAgg", "test", null);
        Column idCol = table.getColumn("id");
        Assert.assertEquals((double)idCol.getStats().getAvgSerializedSize(), (double)PrimitiveType.INT.getSlotSize(), (double)1.0E-4);
        Assert.assertEquals((long)idCol.getStats().getMaxSize(), (long)PrimitiveType.INT.getSlotSize());
        Assert.assertFalse((boolean)idCol.getStats().hasNulls());
        Column boolCol = table.getColumn("bool_col");
        Assert.assertEquals((double)boolCol.getStats().getAvgSerializedSize(), (double)PrimitiveType.BOOLEAN.getSlotSize(), (double)1.0E-4);
        Assert.assertEquals((long)boolCol.getStats().getMaxSize(), (long)PrimitiveType.BOOLEAN.getSlotSize());
        Assert.assertFalse((boolean)boolCol.getStats().hasNulls());
        Column tinyintCol = table.getColumn("tinyint_col");
        Assert.assertEquals((double)tinyintCol.getStats().getAvgSerializedSize(), (double)PrimitiveType.TINYINT.getSlotSize(), (double)1.0E-4);
        Assert.assertEquals((long)tinyintCol.getStats().getMaxSize(), (long)PrimitiveType.TINYINT.getSlotSize());
        Assert.assertTrue((boolean)tinyintCol.getStats().hasNulls());
        Column smallintCol = table.getColumn("smallint_col");
        Assert.assertEquals((double)smallintCol.getStats().getAvgSerializedSize(), (double)PrimitiveType.SMALLINT.getSlotSize(), (double)1.0E-4);
        Assert.assertEquals((long)smallintCol.getStats().getMaxSize(), (long)PrimitiveType.SMALLINT.getSlotSize());
        Assert.assertTrue((boolean)smallintCol.getStats().hasNulls());
        Column intCol = table.getColumn("int_col");
        Assert.assertEquals((double)intCol.getStats().getAvgSerializedSize(), (double)PrimitiveType.INT.getSlotSize(), (double)1.0E-4);
        Assert.assertEquals((long)intCol.getStats().getMaxSize(), (long)PrimitiveType.INT.getSlotSize());
        Assert.assertTrue((boolean)intCol.getStats().hasNulls());
        Column bigintCol = table.getColumn("bigint_col");
        Assert.assertEquals((double)bigintCol.getStats().getAvgSerializedSize(), (double)PrimitiveType.BIGINT.getSlotSize(), (double)1.0E-4);
        Assert.assertEquals((long)bigintCol.getStats().getMaxSize(), (long)PrimitiveType.BIGINT.getSlotSize());
        Assert.assertTrue((boolean)bigintCol.getStats().hasNulls());
        Column floatCol = table.getColumn("float_col");
        Assert.assertEquals((double)floatCol.getStats().getAvgSerializedSize(), (double)PrimitiveType.FLOAT.getSlotSize(), (double)1.0E-4);
        Assert.assertEquals((long)floatCol.getStats().getMaxSize(), (long)PrimitiveType.FLOAT.getSlotSize());
        Assert.assertTrue((boolean)floatCol.getStats().hasNulls());
        Column doubleCol = table.getColumn("double_col");
        Assert.assertEquals((double)doubleCol.getStats().getAvgSerializedSize(), (double)PrimitiveType.DOUBLE.getSlotSize(), (double)1.0E-4);
        Assert.assertEquals((long)doubleCol.getStats().getMaxSize(), (long)PrimitiveType.DOUBLE.getSlotSize());
        Assert.assertTrue((boolean)doubleCol.getStats().hasNulls());
        Column timestampCol = table.getColumn("timestamp_col");
        Assert.assertEquals((double)timestampCol.getStats().getAvgSerializedSize(), (double)PrimitiveType.TIMESTAMP.getSlotSize(), (double)1.0E-4);
        Assert.assertEquals((long)timestampCol.getStats().getMaxSize(), (long)PrimitiveType.TIMESTAMP.getSlotSize());
        Assert.assertFalse((boolean)timestampCol.getStats().hasNulls());
        Column stringCol = table.getColumn("string_col");
        Assert.assertTrue((stringCol.getStats().getAvgSerializedSize() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((stringCol.getStats().getMaxSize() > 0L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)stringCol.getStats().hasNulls());
        HdfsTable dateTable = (HdfsTable)this.catalog_.getOrLoadTable("functional", "date_tbl", "test", null);
        Column dateCol = dateTable.getColumn("date_col");
        Assert.assertEquals((double)dateCol.getStats().getAvgSerializedSize(), (double)PrimitiveType.DATE.getSlotSize(), (double)1.0E-4);
        Assert.assertEquals((long)dateCol.getStats().getMaxSize(), (long)PrimitiveType.DATE.getSlotSize());
        Assert.assertTrue((boolean)dateCol.getStats().hasNulls());
        HdfsTable binaryTable = (HdfsTable)this.catalog_.getOrLoadTable("functional", "binary_tbl", "test", null);
        Column binaryCol = binaryTable.getColumn("binary_col");
        Assert.assertTrue((binaryCol.getStats().getAvgSerializedSize() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((binaryCol.getStats().getMaxSize() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)binaryCol.getStats().hasNulls());
        Assert.assertFalse((boolean)binaryCol.getStats().hasNumDistinctValues());
    }

    @Test
    public void testColStatsColTypeMismatch() throws Exception {
        HdfsTable table = (HdfsTable)this.catalog_.getOrLoadTable("functional", "alltypesagg", "test", null);
        try (MetaStoreClientPool.MetaStoreClient client = this.catalog_.getMetaStoreClient();){
            ColumnStatisticsData stringColStatsData = ((ColumnStatisticsObj)MetastoreShim.getTableColumnStatistics((IMetaStoreClient)client.getHiveClient(), (String)"functional", (String)"alltypesagg", (List)Lists.newArrayList((Object[])new String[]{"string_col"})).get(0)).getStatsData();
            Assert.assertTrue((!table.getColumn("int_col").updateStats(stringColStatsData) ? 1 : 0) != 0);
            this.assertStatsUnknown(table.getColumn("int_col"));
            Assert.assertTrue((!table.getColumn("double_col").updateStats(stringColStatsData) ? 1 : 0) != 0);
            this.assertStatsUnknown(table.getColumn("double_col"));
            Assert.assertTrue((!table.getColumn("bool_col").updateStats(stringColStatsData) ? 1 : 0) != 0);
            this.assertStatsUnknown(table.getColumn("bool_col"));
            ColumnStatisticsData bigIntCol = ((ColumnStatisticsObj)MetastoreShim.getTableColumnStatistics((IMetaStoreClient)client.getHiveClient(), (String)"functional", (String)"alltypes", (List)Lists.newArrayList((Object[])new String[]{"bigint_col"})).get(0)).getStatsData();
            Assert.assertTrue((!table.getColumn("string_col").updateStats(bigIntCol) ? 1 : 0) != 0);
            this.assertStatsUnknown(table.getColumn("string_col"));
            Assert.assertTrue((boolean)table.getColumn("string_col").updateStats(stringColStatsData));
            Assert.assertEquals((long)963L, (long)table.getColumn("string_col").getStats().getNumDistinctValues());
        }
    }

    private void assertStatsUnknown(Column column) {
        Assert.assertEquals((long)-1L, (long)column.getStats().getNumDistinctValues());
        Assert.assertEquals((long)-1L, (long)column.getStats().getNumNulls());
        Assert.assertEquals((long)-1L, (long)column.getStats().getNumTrues());
        Assert.assertEquals((long)-1L, (long)column.getStats().getNumFalses());
        double expectedSize = column.getType().isFixedLengthType() ? (double)column.getType().getSlotSize() : -1.0;
        Assert.assertEquals((double)expectedSize, (double)column.getStats().getAvgSerializedSize(), (double)1.0E-4);
        Assert.assertEquals((double)expectedSize, (double)column.getStats().getMaxSize(), (double)1.0E-4);
    }

    private Map<String, ByteBuffer> getPartitionStatistics(String dbName, String tableName) throws CatalogException {
        TGetPartitionStatsRequest req = new TGetPartitionStatsRequest();
        req.setTable_name(new TTableName(dbName, tableName));
        return this.catalog_.getPartitionStats(req);
    }

    private void expectStatistics(String dbName, String tableName, int expCount) throws CatalogException {
        Map<String, ByteBuffer> result = this.getPartitionStatistics(dbName, tableName);
        Assert.assertEquals((long)expCount, (long)result.size());
        for (Map.Entry<String, ByteBuffer> e : result.entrySet()) {
            ByteBuffer compressedBuffer = e.getValue();
            byte[] compressedBytes = new byte[compressedBuffer.remaining()];
            compressedBuffer.get(compressedBytes);
            try {
                TPartitionStats stats = PartitionStatsUtil.partStatsFromCompressedBytes((byte[])compressedBytes, null);
                Assert.assertNotNull((Object)stats);
                Assert.assertTrue((!stats.isSetIntermediate_col_stats() ? 1 : 0) != 0);
            }
            catch (ImpalaException ex) {
                throw new CatalogException("Error deserializing partition stats.", (Throwable)ex);
            }
        }
    }

    private void expectStatisticsException(String dbName, String tableName, String msgPrefix) {
        try {
            this.getPartitionStatistics(dbName, tableName);
            Assert.fail((String)"Expected exception.");
        }
        catch (Exception e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().startsWith(msgPrefix));
        }
    }

    @Test
    public void testPullIncrementalStats() throws CatalogException {
        this.catalog_.getOrLoadTable("functional", "alltypesagg", "test", null);
        this.expectStatistics("functional", "alltypesagg", 11);
        Reference tblWasRemoved = new Reference();
        Reference dbWasAdded = new Reference();
        this.catalog_.invalidateTable(new TTableName("functional", "alltypesagg"), tblWasRemoved, dbWasAdded, (EventSequence)NoOpEventSequence.INSTANCE);
        this.expectStatistics("functional", "alltypesagg", 11);
        this.expectStatistics("functional", "table_no_newline", 0);
        this.expectStatistics("functional", "dimtbl", 0);
        this.expectStatisticsException("functional", "doesnotexist", "Requested partition statistics for table that does not exist");
        this.expectStatisticsException("functional", "bad_serde", "No statistics available for incompletely loaded table");
    }

    @Test
    public void testInternalHBaseTable() throws CatalogException {
        HBaseTable table = (HBaseTable)this.catalog_.getOrLoadTable("functional_hbase", "internal_hbase_table", "test", null);
        Assert.assertNotNull((String)"functional_hbase.internal_hbase_table was not found", (Object)table);
    }

    @Test
    public void testDatabaseDoesNotExist() {
        Db nonExistentDb = this.catalog_.getDb("doesnotexist");
        Assert.assertNull((Object)nonExistentDb);
    }

    @Test
    public void testCreateTableMetadata() throws CatalogException {
        Table table = this.catalog_.getOrLoadTable("functional", "alltypes", "test", null);
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)table.getMetaStoreTable().getOwner());
        Assert.assertEquals((Object)TableType.EXTERNAL_TABLE.toString(), (Object)table.getMetaStoreTable().getTableType());
    }

    @Test
    public void testCreateTableMetadataHive3() throws CatalogException {
        Assume.assumeTrue((TestUtils.getHiveMajorVersion() > 2 ? 1 : 0) != 0);
        Table table = this.catalog_.getOrLoadTable("functional", "alltypesinsert", "test", null);
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)table.getMetaStoreTable().getOwner());
        Assert.assertEquals((Object)TableType.EXTERNAL_TABLE.toString(), (Object)table.getMetaStoreTable().getTableType());
        table = this.catalog_.getOrLoadTable("functional", "insert_only_transactional_table", "test", null);
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)table.getMetaStoreTable().getOwner());
        Assert.assertEquals((Object)TableType.MANAGED_TABLE.toString(), (Object)table.getMetaStoreTable().getTableType());
    }

    @Test
    public void testCreateTableMetadataHive2() throws CatalogException {
        Assume.assumeTrue((TestUtils.getHiveMajorVersion() <= 2 ? 1 : 0) != 0);
        Table table = this.catalog_.getOrLoadTable("functional", "alltypesinsert", "test", null);
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)table.getMetaStoreTable().getOwner());
        Assert.assertEquals((Object)TableType.MANAGED_TABLE.toString(), (Object)table.getMetaStoreTable().getTableType());
    }

    @Test
    public void testLoadingUnsupportedTblTypesOnHive2() throws CatalogException {
        Assume.assumeTrue((String)"Skipping this test since it is only supported when running against Hive-2", (TestUtils.getHiveMajorVersion() == 2 ? 1 : 0) != 0);
        Table table = this.catalog_.getOrLoadTable("functional", "hive_index_tbl", "test", null);
        Assert.assertTrue((boolean)(table instanceof IncompleteTable));
        IncompleteTable incompleteTable = (IncompleteTable)table;
        Assert.assertTrue((boolean)(incompleteTable.getCause() instanceof TableLoadingException));
        Assert.assertEquals((Object)"Unsupported table type 'INDEX_TABLE' for: functional.hive_index_tbl", (Object)incompleteTable.getCause().getMessage());
    }

    @Test
    public void testLoadingUnsupportedTableTypes() throws CatalogException {
        Table table = this.catalog_.getOrLoadTable("functional", "bad_serde", "test", null);
        Assert.assertTrue((boolean)(table instanceof IncompleteTable));
        IncompleteTable incompleteTable = (IncompleteTable)table;
        Assert.assertTrue((boolean)(incompleteTable.getCause() instanceof TableLoadingException));
        Assert.assertEquals((Object)"Impala does not support tables of this type. REASON: SerDe library 'org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe' is not supported.", (Object)incompleteTable.getCause().getCause().getMessage());
        table = this.catalog_.getOrLoadTable("functional_rc", "rcfile_lazy_binary_serde", "test", null);
        Assert.assertTrue((boolean)(table instanceof IncompleteTable));
        incompleteTable = (IncompleteTable)table;
        Assert.assertTrue((boolean)(incompleteTable.getCause() instanceof TableLoadingException));
        Assert.assertEquals((Object)"Impala does not support tables of this type. REASON: SerDe library 'org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe' is not supported.", (Object)incompleteTable.getCause().getCause().getMessage());
    }

    private List<String> getFunctionSignatures(String db) throws DatabaseNotFoundException {
        List fns = this.catalog_.getFunctions(db);
        ArrayList<String> names = new ArrayList<String>();
        for (Function fn : fns) {
            names.add(fn.signatureString());
        }
        return names;
    }

    @Test
    public void TestUdf() throws CatalogException {
        List<String> fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)0L);
        ArrayList args1 = new ArrayList();
        ArrayList args2 = Lists.newArrayList((Object[])new Type[]{Type.INT});
        ArrayList args3 = Lists.newArrayList((Object[])new Type[]{Type.TINYINT});
        this.catalog_.removeFunction(new Function(new FunctionName("default", "Foo"), args1, (Type)Type.INVALID, false));
        fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)0L);
        ScalarFunction udf1 = ScalarFunction.createForTesting((String)"default", (String)"Foo", args1, (Type)Type.INVALID, (String)"/Foo", (String)"Foo.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE);
        this.catalog_.addFunction((Function)udf1);
        fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)1L);
        Assert.assertTrue((boolean)fnNames.contains("foo()"));
        ScalarFunction udf2 = ScalarFunction.createForTesting((String)"default", (String)"Foo", (List)args2, (Type)Type.INVALID, (String)"/Foo", (String)"Foo.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE);
        this.catalog_.addFunction((Function)udf2);
        fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)2L);
        Assert.assertTrue((boolean)fnNames.contains("foo()"));
        Assert.assertTrue((boolean)fnNames.contains("foo(INT)"));
        ScalarFunction udf3 = ScalarFunction.createForTesting((String)"default", (String)"Bar", (List)args2, (Type)Type.INVALID, (String)"/Foo", (String)"Foo.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE);
        this.catalog_.addFunction((Function)udf3);
        fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)3L);
        Assert.assertTrue((boolean)fnNames.contains("foo()"));
        Assert.assertTrue((boolean)fnNames.contains("foo(INT)"));
        Assert.assertTrue((boolean)fnNames.contains("bar(INT)"));
        this.catalog_.removeFunction(Function.createFunction((String)"default", (String)"Foo", args1, (Type)Type.INVALID, (boolean)false, (TFunctionBinaryType)TFunctionBinaryType.NATIVE));
        fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)2L);
        Assert.assertTrue((boolean)fnNames.contains("foo(INT)"));
        Assert.assertTrue((boolean)fnNames.contains("bar(INT)"));
        this.catalog_.removeFunction(Function.createFunction((String)"default", (String)"Foo", args1, (Type)Type.INVALID, (boolean)false, (TFunctionBinaryType)TFunctionBinaryType.NATIVE));
        fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)2L);
        Assert.assertTrue((boolean)fnNames.contains("foo(INT)"));
        Assert.assertTrue((boolean)fnNames.contains("bar(INT)"));
        this.catalog_.removeFunction(Function.createFunction((String)"default", (String)"Bar", args1, (Type)Type.INVALID, (boolean)false, (TFunctionBinaryType)TFunctionBinaryType.NATIVE));
        fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)2L);
        Assert.assertTrue((boolean)fnNames.contains("foo(INT)"));
        Assert.assertTrue((boolean)fnNames.contains("bar(INT)"));
        this.catalog_.removeFunction(Function.createFunction((String)"default", (String)"Bar", (List)args3, (Type)Type.INVALID, (boolean)false, (TFunctionBinaryType)TFunctionBinaryType.NATIVE));
        fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)2L);
        Assert.assertTrue((boolean)fnNames.contains("foo(INT)"));
        Assert.assertTrue((boolean)fnNames.contains("bar(INT)"));
        this.catalog_.removeFunction(Function.createFunction((String)"default", (String)"Bar", (List)args2, (Type)Type.INVALID, (boolean)false, (TFunctionBinaryType)TFunctionBinaryType.NATIVE));
        fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)1L);
        Assert.assertTrue((boolean)fnNames.contains("foo(INT)"));
        this.catalog_.removeFunction(Function.createFunction((String)"default", (String)"Foo", (List)args2, (Type)Type.INVALID, (boolean)false, (TFunctionBinaryType)TFunctionBinaryType.NATIVE));
        fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)0L);
        HashMap<String, String> dbParams = new HashMap<String, String>();
        String badFnKey = "impala_registered_function_badFn";
        String badFnVal = Base64.getEncoder().encodeToString("badFn".getBytes());
        String dbName = "corrupt_udf_test";
        dbParams.put(badFnKey, badFnVal);
        Db db = this.catalog_.getDb(dbName);
        Assert.assertEquals((Object)db, null);
        db = new Db(dbName, new Database(dbName, "", "", dbParams));
        this.catalog_.addDb(db);
        db = this.catalog_.getDb(dbName);
        Assert.assertTrue((db != null ? 1 : 0) != 0);
        fnNames = this.getFunctionSignatures(dbName);
        Assert.assertEquals((long)fnNames.size(), (long)0L);
        ScalarFunction largeUdf = ScalarFunction.createForTesting((String)"default", (String)Strings.repeat((String)"Foo", (int)5000), (List)args2, (Type)Type.INVALID, (String)"/Foo", (String)"Foo.class", null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE);
        Assert.assertTrue((!this.catalog_.addFunction((Function)largeUdf) ? 1 : 0) != 0);
        fnNames = this.getFunctionSignatures("default");
        Assert.assertEquals((long)fnNames.size(), (long)0L);
    }

    @Test
    public void testAuthorizationCatalog() throws CatalogException {
        String name;
        int i;
        AuthorizationPolicy authPolicy = this.catalog_.getAuthPolicy();
        User user = this.catalog_.addUser("user1");
        TPrivilege userPrivilege = new TPrivilege();
        userPrivilege.setPrincipal_type(TPrincipalType.USER);
        userPrivilege.setPrincipal_id(user.getId());
        userPrivilege.setCreate_time_ms(-1L);
        userPrivilege.setServer_name("server1");
        userPrivilege.setScope(TPrivilegeScope.SERVER);
        userPrivilege.setPrivilege_level(TPrivilegeLevel.ALL);
        this.catalog_.addUserPrivilege("user1", userPrivilege);
        Assert.assertSame((Object)user, (Object)authPolicy.getPrincipal("user1", TPrincipalType.USER));
        Assert.assertNull((Object)authPolicy.getPrincipal("user2", TPrincipalType.USER));
        Assert.assertNull((Object)authPolicy.getPrincipal("user1", TPrincipalType.ROLE));
        user = this.catalog_.addUser("user1");
        Assert.assertSame((Object)user, (Object)authPolicy.getPrincipal("user1", TPrincipalType.USER));
        Assert.assertSame((Object)user, (Object)this.catalog_.removeUser("user1"));
        Assert.assertNull((Object)authPolicy.getPrincipal("user1", TPrincipalType.USER));
        Role role = this.catalog_.addRole("role1", (Set)Sets.newHashSet((Object[])new String[]{"group1", "group2"}));
        TPrivilege rolePrivilege = new TPrivilege();
        rolePrivilege.setPrincipal_type(TPrincipalType.ROLE);
        rolePrivilege.setPrincipal_id(role.getId());
        rolePrivilege.setCreate_time_ms(-1L);
        rolePrivilege.setServer_name("server1");
        rolePrivilege.setScope(TPrivilegeScope.SERVER);
        rolePrivilege.setPrivilege_level(TPrivilegeLevel.ALL);
        this.catalog_.addRolePrivilege("role1", rolePrivilege);
        Assert.assertSame((Object)role, (Object)this.catalog_.getAuthPolicy().getPrincipal("role1", TPrincipalType.ROLE));
        Assert.assertNull((Object)this.catalog_.getAuthPolicy().getPrincipal("role1", TPrincipalType.USER));
        Assert.assertNull((Object)this.catalog_.getAuthPolicy().getPrincipal("role2", TPrincipalType.ROLE));
        role = this.catalog_.addRole("role1", new HashSet());
        Assert.assertSame((Object)role, (Object)authPolicy.getPrincipal("role1", TPrincipalType.ROLE));
        Assert.assertSame((Object)role, (Object)this.catalog_.removeRole("role1"));
        Assert.assertNull((Object)authPolicy.getPrincipal("role1", TPrincipalType.ROLE));
        int size = 10;
        String prefix = "foo";
        for (i = 0; i < size; ++i) {
            name = prefix + i;
            this.catalog_.addUser(name);
            this.catalog_.addRole(name, new HashSet());
        }
        for (i = 0; i < size; ++i) {
            name = prefix + i;
            Principal u = authPolicy.getPrincipal(name, TPrincipalType.USER);
            Principal r = authPolicy.getPrincipal(name, TPrincipalType.ROLE);
            Assert.assertEquals((Object)name, (Object)u.getName());
            Assert.assertEquals((Object)name, (Object)r.getName());
            Assert.assertNotEquals((long)u.getId(), (long)r.getId());
        }
        List allUsers = authPolicy.getAllUsers();
        Set allUserNames = authPolicy.getAllUserNames();
        Assert.assertEquals((long)allUsers.size(), (long)allUserNames.size());
        for (Principal principal : allUsers) {
            Assert.assertTrue((boolean)allUserNames.contains(principal.getName()));
        }
        List allRoles = authPolicy.getAllRoles();
        Set allRoleNames = authPolicy.getAllRoleNames();
        Assert.assertEquals((long)allRoles.size(), (long)allRoleNames.size());
        for (Principal principal : allRoles) {
            Assert.assertTrue((boolean)allRoleNames.contains(principal.getName()));
        }
    }
}

