/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FileDescriptor;
import org.apache.impala.catalog.HBaseTable;
import org.apache.impala.catalog.HdfsPartition;
import org.apache.impala.catalog.HdfsTable;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.SqlCastException;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TAccessLevel;
import org.apache.impala.thrift.THBaseTable;
import org.apache.impala.thrift.THdfsPartition;
import org.apache.impala.thrift.THdfsTable;
import org.apache.impala.thrift.TTable;
import org.apache.impala.thrift.TTableType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class CatalogObjectToFromThriftTest {
    private static CatalogServiceCatalog catalog_;

    @BeforeClass
    public static void setUp() throws Exception {
        catalog_ = CatalogServiceTestCatalog.create();
    }

    @AfterClass
    public static void cleanUp() {
        catalog_.close();
    }

    @Test
    public void TestPartitionedTable() throws CatalogException {
        String[] dbNames;
        for (String dbName : dbNames = new String[]{"functional", "functional_avro", "functional_parquet", "functional_seq"}) {
            Table table = catalog_.getOrLoadTable(dbName, "alltypes", "test", null);
            Assert.assertEquals((long)24L, (long)((HdfsTable)table).getPartitions().size());
            Assert.assertEquals((long)24L, (long)((HdfsTable)table).getPartitionIds().size());
            TTable thriftTable = this.getThriftTable(table);
            Assert.assertEquals((Object)thriftTable.tbl_name, (Object)"alltypes");
            Assert.assertEquals((Object)thriftTable.db_name, (Object)dbName);
            Assert.assertTrue((boolean)thriftTable.isSetTable_type());
            Assert.assertEquals((long)thriftTable.getClustering_columns().size(), (long)2L);
            Assert.assertEquals((Object)thriftTable.getTable_type(), (Object)TTableType.HDFS_TABLE);
            THdfsTable hdfsTable = thriftTable.getHdfs_table();
            Assert.assertTrue((hdfsTable.hdfsBaseDir != null ? 1 : 0) != 0);
            Assert.assertEquals((long)24L, (long)hdfsTable.getPartitions().size());
            Assert.assertFalse((boolean)hdfsTable.getPartitions().containsKey(-1L));
            Assert.assertTrue((boolean)hdfsTable.isSetPrototype_partition());
            Assert.assertEquals((long)-1L, (long)hdfsTable.getPrototype_partition().id);
            Assert.assertNull((Object)hdfsTable.getPrototype_partition().location);
            for (Map.Entry kv : hdfsTable.getPartitions().entrySet()) {
                Assert.assertEquals((long)((THdfsPartition)kv.getValue()).getPartitionKeyExprs().size(), (long)2L);
            }
            Table newTable = Table.fromThrift((Db)catalog_.getDb(dbName), (TTable)thriftTable, (boolean)true);
            Assert.assertTrue((boolean)(newTable instanceof HdfsTable));
            Assert.assertEquals((Object)newTable.name_, (Object)thriftTable.tbl_name);
            Assert.assertEquals((long)newTable.numClusteringCols_, (long)2L);
            if (dbName.equals("functional")) {
                Assert.assertEquals((long)7300L, (long)newTable.getNumRows());
            }
            HdfsTable newHdfsTable = (HdfsTable)newTable;
            Assert.assertEquals((long)newHdfsTable.getPartitions().size(), (long)24L);
            Assert.assertEquals((long)newHdfsTable.getPartitionIds().size(), (long)24L);
            Collection parts = newHdfsTable.loadAllPartitions();
            for (FeFsPartition hdfsPart : parts) {
                Assert.assertEquals((long)hdfsPart.getFileDescriptors().size(), (long)1L);
                Assert.assertTrue((((FileDescriptor)hdfsPart.getFileDescriptors().get(0)).getNumFileBlocks() > 0 ? 1 : 0) != 0);
                if (!BackendConfig.INSTANCE.isMinimalTopicMode() && dbName.equals("functional_seq") && (hdfsPart.getPartitionName().equals("year=2009/month=1") || hdfsPart.getPartitionName().equals("year=2009/month=3"))) {
                    Assert.assertEquals((Object)TAccessLevel.READ_ONLY, (Object)hdfsPart.getAccessLevel());
                    continue;
                }
                Assert.assertEquals((Object)TAccessLevel.READ_WRITE, (Object)hdfsPart.getAccessLevel());
            }
            Assert.assertNotNull((Object)newHdfsTable.prototypePartition_);
            Assert.assertEquals((Object)((HdfsTable)table).prototypePartition_.getParameters(), (Object)newHdfsTable.prototypePartition_.getParameters());
        }
    }

    @Test
    public void TestMismatchedAvroAndTableSchemas() throws CatalogException {
        Table table = catalog_.getOrLoadTable("functional_avro_snap", "schema_resolution_test", "test", null);
        TTable thriftTable = this.getThriftTable(table);
        Assert.assertEquals((Object)thriftTable.tbl_name, (Object)"schema_resolution_test");
        Assert.assertTrue((boolean)thriftTable.isSetTable_type());
        Assert.assertEquals((long)thriftTable.getColumns().size(), (long)9L);
        Assert.assertEquals((long)thriftTable.getClustering_columns().size(), (long)0L);
        Assert.assertEquals((Object)thriftTable.getTable_type(), (Object)TTableType.HDFS_TABLE);
        Table newTable = Table.fromThrift((Db)catalog_.getDb("functional_avro_snap"), (TTable)thriftTable, (boolean)true);
        Assert.assertEquals((long)newTable.getColumns().size(), (long)9L);
        Assert.assertEquals((long)newTable.getMetaStoreTable().getSd().getCols().size(), (long)2L);
    }

    @Test
    public void TestHBaseTables() throws CatalogException {
        String dbName = "functional_hbase";
        Table table = catalog_.getOrLoadTable(dbName, "alltypes", "test", null);
        TTable thriftTable = this.getThriftTable(table);
        Assert.assertEquals((Object)thriftTable.tbl_name, (Object)"alltypes");
        Assert.assertEquals((Object)thriftTable.db_name, (Object)dbName);
        Assert.assertTrue((boolean)thriftTable.isSetTable_type());
        Assert.assertEquals((long)thriftTable.getClustering_columns().size(), (long)1L);
        Assert.assertEquals((Object)thriftTable.getTable_type(), (Object)TTableType.HBASE_TABLE);
        THBaseTable hbaseTable = thriftTable.getHbase_table();
        Assert.assertEquals((long)hbaseTable.getFamilies().size(), (long)13L);
        Assert.assertEquals((long)hbaseTable.getQualifiers().size(), (long)13L);
        Assert.assertEquals((long)hbaseTable.getBinary_encoded().size(), (long)13L);
        Iterator iterator = hbaseTable.getBinary_encoded().iterator();
        while (iterator.hasNext()) {
            boolean isBinaryEncoded = (Boolean)iterator.next();
            Assert.assertTrue((!isBinaryEncoded ? 1 : 0) != 0);
        }
        Table newTable = Table.fromThrift((Db)catalog_.getDb(dbName), (TTable)thriftTable, (boolean)true);
        Assert.assertTrue((boolean)(newTable instanceof HBaseTable));
        HBaseTable newHBaseTable = (HBaseTable)newTable;
        Assert.assertEquals((long)newHBaseTable.getColumns().size(), (long)13L);
        Assert.assertEquals((Object)newHBaseTable.getColumn("double_col").getType(), (Object)Type.DOUBLE);
        Assert.assertEquals((long)newHBaseTable.getNumClusteringCols(), (long)1L);
    }

    @Test
    public void TestHBaseTableWithBinaryEncodedCols() throws CatalogException {
        String dbName = "functional_hbase";
        Table table = catalog_.getOrLoadTable(dbName, "alltypessmallbinary", "test", null);
        TTable thriftTable = this.getThriftTable(table);
        Assert.assertEquals((Object)thriftTable.tbl_name, (Object)"alltypessmallbinary");
        Assert.assertEquals((Object)thriftTable.db_name, (Object)dbName);
        Assert.assertTrue((boolean)thriftTable.isSetTable_type());
        Assert.assertEquals((long)thriftTable.getClustering_columns().size(), (long)1L);
        Assert.assertEquals((Object)thriftTable.getTable_type(), (Object)TTableType.HBASE_TABLE);
        THBaseTable hbaseTable = thriftTable.getHbase_table();
        Assert.assertEquals((long)hbaseTable.getFamilies().size(), (long)13L);
        Assert.assertEquals((long)hbaseTable.getQualifiers().size(), (long)13L);
        Assert.assertEquals((long)hbaseTable.getBinary_encoded().size(), (long)13L);
        int numBinaryEncodedCols = 0;
        Iterator iterator = hbaseTable.getBinary_encoded().iterator();
        while (iterator.hasNext()) {
            boolean isBinaryEncoded = (Boolean)iterator.next();
            if (!isBinaryEncoded) continue;
            ++numBinaryEncodedCols;
        }
        Assert.assertEquals((long)numBinaryEncodedCols, (long)10L);
        Table newTable = Table.fromThrift((Db)catalog_.getDb(dbName), (TTable)thriftTable, (boolean)true);
        Assert.assertTrue((boolean)(newTable instanceof HBaseTable));
        HBaseTable newHBaseTable = (HBaseTable)newTable;
        Assert.assertEquals((long)newHBaseTable.getColumns().size(), (long)13L);
        Assert.assertEquals((Object)newHBaseTable.getColumn("double_col").getType(), (Object)Type.DOUBLE);
        Assert.assertEquals((long)newHBaseTable.getNumClusteringCols(), (long)1L);
    }

    @Test
    public void TestTableLoadingErrorsForHive2() throws ImpalaException {
        Assume.assumeTrue((String)"Skipping this test since it is only supported when running against Hive-2", (TestUtils.getHiveMajorVersion() == 2 ? 1 : 0) != 0);
        Table table = catalog_.getOrLoadTable("functional", "hive_index_tbl", "test", null);
        Assert.assertNotNull((Object)table);
        TTable thriftTable = this.getThriftTable(table);
        Assert.assertEquals((Object)thriftTable.tbl_name, (Object)"hive_index_tbl");
        Assert.assertEquals((Object)thriftTable.db_name, (Object)"functional");
    }

    @Test
    public void TestTableLoadingErrors() throws ImpalaException {
        Table table = catalog_.getOrLoadTable("functional", "alltypes", "test", null);
        HdfsTable hdfsTable = (HdfsTable)table;
        long id = (Long)Iterables.getFirst((Iterable)hdfsTable.getPartitionIds(), (Object)-1L);
        HdfsPartition part = (HdfsPartition)hdfsTable.loadPartition(id);
        Assert.assertNotNull((Object)part);
        try {
            new HdfsPartition.Builder(hdfsTable).setMsPartition(part.toHmsPartition()).setPartitionKeyValues((List)Lists.newArrayList((Object[])new LiteralExpr[]{LiteralExpr.createFromUnescapedStr((String)"11.1", (Type)ScalarType.createDecimalType((int)1, (int)0)), LiteralExpr.createFromUnescapedStr((String)"11.1", (Type)ScalarType.createDecimalType((int)1, (int)0))})).setAccessLevel(TAccessLevel.READ_WRITE);
            Assert.fail((String)"Expected metadata to be malformed.");
        }
        catch (SqlCastException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Value 11.1 cannot be cast to type DECIMAL(1,0)"));
        }
    }

    @Test
    public void TestView() throws CatalogException {
        Table table = catalog_.getOrLoadTable("functional", "view_view", "test", null);
        TTable thriftTable = this.getThriftTable(table);
        Assert.assertEquals((Object)thriftTable.tbl_name, (Object)"view_view");
        Assert.assertEquals((Object)thriftTable.db_name, (Object)"functional");
        Assert.assertFalse((boolean)thriftTable.isSetHdfs_table());
        Assert.assertFalse((boolean)thriftTable.isSetHbase_table());
        Assert.assertTrue((boolean)thriftTable.isSetMetastore_table());
    }

    private TTable getThriftTable(Table table) {
        TTable thriftTable = null;
        table.takeReadLock();
        try {
            thriftTable = table.toThrift();
        }
        finally {
            table.releaseReadLock();
        }
        return thriftTable;
    }
}

