/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.catalog;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.impala.catalog.Db;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.testutil.ImpaladTestCatalog;
import org.apache.impala.thrift.TAlterDbParams;
import org.apache.impala.thrift.TAlterDbSetOwnerParams;
import org.apache.impala.thrift.TAlterDbType;
import org.apache.impala.thrift.TCreateDbParams;
import org.apache.impala.thrift.TDdlExecRequest;
import org.apache.impala.thrift.TDdlQueryOptions;
import org.apache.impala.thrift.TDdlType;
import org.apache.impala.thrift.TDropDbParams;
import org.apache.impala.thrift.TOwnerType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AlterDatabaseTest {
    private static final String TEST_OWNER_1 = "user_1";
    private static final PrincipalType TEST_TYPE_1 = PrincipalType.USER;
    private static final String TEST_OWNER_2 = "user_2";
    private static final PrincipalType TEST_TYPE_2 = PrincipalType.ROLE;
    private static ImpaladTestCatalog catalog_;
    private static CatalogOpExecutor catalogOpExecutor_;
    private static final String TEST_ALTER_DB = "testAlterdb";
    private static final int NUM_READERS = 10;
    private static final int NUM_WRITERS = 1;
    private final CyclicBarrier barrier_ = new CyclicBarrier(11);
    private final AtomicBoolean toggler_ = new AtomicBoolean(false);

    @BeforeClass
    public static void setUpTest() throws ImpalaException {
        CatalogServiceTestCatalog testSrcCatalog = CatalogServiceTestCatalog.create();
        catalog_ = new ImpaladTestCatalog(testSrcCatalog);
        catalogOpExecutor_ = testSrcCatalog.getCatalogOpExecutor();
    }

    @After
    public void cleanUp() throws ImpalaException {
        catalogOpExecutor_.execDdlRequest(AlterDatabaseTest.dropDbRequest());
    }

    @Before
    public void setUpDatabase() throws ImpalaException {
        catalogOpExecutor_.execDdlRequest(AlterDatabaseTest.dropDbRequest());
        catalogOpExecutor_.execDdlRequest(AlterDatabaseTest.createDbRequest());
        Db db = catalog_.getDb(TEST_ALTER_DB);
        Assert.assertNotNull((Object)db);
        catalogOpExecutor_.execDdlRequest(this.getNextDdlRequest());
        Assert.assertNotNull((Object)catalog_.getDb(TEST_ALTER_DB));
        String owner = db.getMetaStoreDb().getOwnerName();
        Assert.assertTrue((owner.equals(TEST_OWNER_1) || owner.equals(TEST_OWNER_2) ? 1 : 0) != 0);
    }

    private static TDdlExecRequest dropDbRequest() {
        TDdlExecRequest request = new TDdlExecRequest();
        request.setQuery_options(new TDdlQueryOptions());
        request.setDdl_type(TDdlType.DROP_DATABASE);
        TDropDbParams dropDbParams = new TDropDbParams();
        dropDbParams.setDb(TEST_ALTER_DB);
        dropDbParams.setIf_exists(true);
        dropDbParams.setCascade(true);
        request.setDrop_db_params(dropDbParams);
        return request;
    }

    private static TDdlExecRequest createDbRequest() {
        TDdlExecRequest request = new TDdlExecRequest();
        request.setQuery_options(new TDdlQueryOptions());
        request.setDdl_type(TDdlType.CREATE_DATABASE);
        TCreateDbParams createDbParams = new TCreateDbParams();
        createDbParams.setDb(TEST_ALTER_DB);
        createDbParams.setComment("test comment");
        createDbParams.setOwner(TEST_OWNER_1);
        request.setCreate_db_params(createDbParams);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentAlterDbOps() throws Exception {
        int i;
        ExecutorService threadPool = Executors.newFixedThreadPool(11);
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>(11);
        for (i = 0; i < 1; ++i) {
            results.add(threadPool.submit(new SetOwnerTask()));
        }
        for (i = 0; i < 10; ++i) {
            results.add(threadPool.submit(new ValidateDbOwnerTask()));
        }
        try {
            for (Future future : results) {
                future.get(100L, TimeUnit.SECONDS);
            }
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    private TDdlExecRequest getNextDdlRequest() {
        TAlterDbSetOwnerParams alterDbSetOwnerParams = new TAlterDbSetOwnerParams();
        if (this.toggler_.get()) {
            alterDbSetOwnerParams.setOwner_name(TEST_OWNER_1);
            alterDbSetOwnerParams.setOwner_type(TOwnerType.findByValue((int)0));
            Assert.assertTrue((boolean)this.toggler_.compareAndSet(true, false));
        } else {
            alterDbSetOwnerParams.setOwner_name(TEST_OWNER_2);
            alterDbSetOwnerParams.setOwner_type(TOwnerType.findByValue((int)1));
            Assert.assertTrue((boolean)this.toggler_.compareAndSet(false, true));
        }
        TAlterDbParams alterDbParams = new TAlterDbParams();
        alterDbParams.setDb(TEST_ALTER_DB);
        alterDbParams.setAlter_type(TAlterDbType.SET_OWNER);
        alterDbParams.setSet_owner_params(alterDbSetOwnerParams);
        TDdlExecRequest request = new TDdlExecRequest();
        request.setQuery_options(new TDdlQueryOptions());
        request.setDdl_type(TDdlType.ALTER_DATABASE);
        request.setAlter_db_params(alterDbParams);
        return request;
    }

    private void validateOwner(Database msDb) {
        Assert.assertNotNull((Object)msDb.getOwnerName());
        Assert.assertNotNull((Object)msDb.getOwnerType());
        if (TEST_OWNER_1.equals(msDb.getOwnerName())) {
            Assert.assertEquals((String)("Owner user_1 should have the type " + TEST_TYPE_1), (Object)msDb.getOwnerType(), (Object)TEST_TYPE_1);
        } else if (TEST_OWNER_2.equals(msDb.getOwnerName())) {
            Assert.assertEquals((String)("Owner user_2 should have the type " + TEST_TYPE_2), (Object)msDb.getOwnerType(), (Object)TEST_TYPE_2);
        } else {
            Assert.fail((String)("Unknown owner for the database " + msDb.getOwnerName()));
        }
    }

    private class SetOwnerTask
    implements Callable<Void> {
        private SetOwnerTask() {
        }

        @Override
        public Void call() throws Exception {
            AlterDatabaseTest.this.barrier_.await();
            for (int i = 0; i < 100; ++i) {
                catalogOpExecutor_.execDdlRequest(AlterDatabaseTest.this.getNextDdlRequest());
            }
            return null;
        }
    }

    private class ValidateDbOwnerTask
    implements Callable<Void> {
        private ValidateDbOwnerTask() {
        }

        @Override
        public Void call() throws Exception {
            AlterDatabaseTest.this.barrier_.await();
            for (int i = 0; i < 100; ++i) {
                Db testDb = catalog_.getDb(AlterDatabaseTest.TEST_ALTER_DB);
                AlterDatabaseTest.this.validateOwner(testDb.getMetaStoreDb());
            }
            return null;
        }
    }
}

