/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization.ranger;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationContext;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.AuthorizationPolicy;
import org.apache.impala.authorization.AuthorizationProvider;
import org.apache.impala.authorization.AuthorizationTestBase;
import org.apache.impala.authorization.ranger.RangerAuthorizationChecker;
import org.apache.impala.authorization.ranger.RangerAuthorizationContext;
import org.apache.impala.authorization.ranger.RangerAuthorizationFactory;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TPrivilegeLevel;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.junit.Assert;
import org.junit.Test;

public class RangerAuditLogTest
extends AuthorizationTestBase {
    private static RangerAuthorizationCheckerSpy authzChecker_ = null;

    public RangerAuditLogTest() throws ImpalaException {
        super(AuthorizationProvider.RANGER);
    }

    @Test
    public void testAuditLogSuccess() throws ImpalaException {
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@database", "create", "test_db", 1, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"create database test_db", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "create database test_db", new TPrivilege[][]{this.onServer(TPrivilegeLevel.CREATE)});
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "create", "functional/test_tbl", 1, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"create table functional.test_tbl(i int)", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "create table functional.test_tbl(i int)", new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)});
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)2L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@udf", "create", "functional/f()", 1, (AuthzAuditEvent)events.get(0));
            RangerAuditLogTest.assertEventEquals("@url", "all", "hdfs://localhost:20500/test-warehouse/libTestUdfs.so", 1, (AuthzAuditEvent)events.get(1));
            Assert.assertEquals((Object)"create function functional.f() returns int location 'hdfs://localhost:20500/test-warehouse/libTestUdfs.so' symbol='NoArgs'", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "create function functional.f() returns int location 'hdfs://localhost:20500/test-warehouse/libTestUdfs.so' symbol='NoArgs'", this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onUri("hdfs://localhost:20500/test-warehouse/libTestUdfs.so", TPrivilegeLevel.ALL));
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)2L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "create", "functional/new_table", 1, (AuthzAuditEvent)events.get(0));
            RangerAuditLogTest.assertEventEquals("@url", "all", "hdfs://localhost:20500/test-warehouse/new_table", 1, (AuthzAuditEvent)events.get(1));
            Assert.assertEquals((Object)"create table functional.new_table(i int) location 'hdfs://localhost:20500/test-warehouse/new_table'", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "create table functional.new_table(i int) location 'hdfs://localhost:20500/test-warehouse/new_table'", this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.ALL));
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)2L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypes", 1, (AuthzAuditEvent)events.get(0));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/id,string_col", 1, (AuthzAuditEvent)events.get(1));
            Assert.assertEquals((Object)"select id, string_col from functional.alltypes", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "select id, string_col from functional.alltypes", new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)});
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)13L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/id", 1, (AuthzAuditEvent)events.get(0));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/bool_col", 1, (AuthzAuditEvent)events.get(1));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/tinyint_col", 1, (AuthzAuditEvent)events.get(2));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/smallint_col", 1, (AuthzAuditEvent)events.get(3));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/int_col", 1, (AuthzAuditEvent)events.get(4));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/bigint_col", 1, (AuthzAuditEvent)events.get(5));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/float_col", 1, (AuthzAuditEvent)events.get(6));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/double_col", 1, (AuthzAuditEvent)events.get(7));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/date_string_col", 1, (AuthzAuditEvent)events.get(8));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/string_col", 1, (AuthzAuditEvent)events.get(9));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/timestamp_col", 1, (AuthzAuditEvent)events.get(10));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/year", 1, (AuthzAuditEvent)events.get(11));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/month", 1, (AuthzAuditEvent)events.get(12));
            Assert.assertEquals((Object)"select * from functional.alltypes", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "select * from functional.alltypes", this.onColumn("functional", "alltypes", "id", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "bool_col", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "tinyint_col", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "smallint_col", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "int_col", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "bigint_col", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "float_col", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "double_col", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "date_string_col", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "string_col", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "timestamp_col", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "year", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "month", TPrivilegeLevel.SELECT));
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)2L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/id", 1, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"select id, string_col from functional.alltypes", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/string_col", 1, (AuthzAuditEvent)events.get(1));
            Assert.assertEquals((Object)"select id, string_col from functional.alltypes", (Object)((AuthzAuditEvent)events.get(1)).getRequestData());
        }, "select id, string_col from functional.alltypes", this.onColumn("functional", "alltypes", "id", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "string_col", TPrivilegeLevel.SELECT));
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)3L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@udf", "refresh", "*/*", 1, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"invalidate metadata", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
            RangerAuditLogTest.assertEventEquals("@url", "refresh", "*", 1, (AuthzAuditEvent)events.get(1));
            Assert.assertEquals((Object)"invalidate metadata", (Object)((AuthzAuditEvent)events.get(1)).getRequestData());
            RangerAuditLogTest.assertEventEquals("@column", "refresh", "*/*/*", 1, (AuthzAuditEvent)events.get(2));
            Assert.assertEquals((Object)"invalidate metadata", (Object)((AuthzAuditEvent)events.get(2)).getRequestData());
        }, "invalidate metadata", new TPrivilege[][]{this.onServer(TPrivilegeLevel.REFRESH)});
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "view_metadata", "functional/alltypes", 1, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"show partitions functional.alltypes", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "show partitions functional.alltypes", new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)});
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)2L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "alter", "functional/alltypes", 1, (AuthzAuditEvent)events.get(0));
            RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypes", 1, (AuthzAuditEvent)events.get(1));
            Assert.assertEquals((Object)"compute stats FUNCTIONAL.ALLTYPES", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "compute stats FUNCTIONAL.ALLTYPES", new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT)});
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "select", "functional/complex_view", 1, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"select count(*) from functional.complex_view", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "select count(*) from functional.complex_view", new TPrivilege[][]{this.onTable("functional", "complex_view", TPrivilegeLevel.SELECT)});
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "select", "functional/complex_view", 1, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"select count(*) from functional.complex_view", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "select count(*) from functional.complex_view", this.onTable("functional", "complex_view", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypesagg", TPrivilegeLevel.SELECT));
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "select", "functional/complex_view", 1, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"select count(*) from functional.complex_view", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "select count(*) from functional.complex_view", this.onTable("functional", "complex_view", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypesagg", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT));
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)2L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypes", 1, (AuthzAuditEvent)events.get(0));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/id", 1, (AuthzAuditEvent)events.get(1));
        }, "select min(id), max(id), avg(id) from functional.alltypes", new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)});
        this.authzOk((List<AuthzAuditEvent> events) -> {
            Assert.assertEquals((long)2L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypes", 1, (AuthzAuditEvent)events.get(0));
            RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/id", 1, (AuthzAuditEvent)events.get(1));
        }, "select min(id) from functional.alltypes union all select max(id) from functional.alltypes", new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)});
        this.authzOk((List<AuthzAuditEvent> events) -> Assert.assertEquals((long)0L, (long)events.size()), "select * from functional.non_existing_tbl", false, (TPrivilege[][])new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)});
    }

    @Test
    public void testAuditLogFailure() throws ImpalaException {
        this.authzError(events -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@database", "create", "test_db", 0, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"create database test_db", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "create database test_db", new TPrivilege[0][]);
        this.authzError(events -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "create", "functional/test_tbl", 0, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"create table functional.test_tbl(i int)", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "create table functional.test_tbl(i int)", new TPrivilege[0][]);
        this.authzError(events -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@udf", "create", "functional/f()", 0, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"create function functional.f() returns int location 'hdfs://localhost:20500/test-warehouse/libTestUdfs.so' symbol='NoArgs'", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "create function functional.f() returns int location 'hdfs://localhost:20500/test-warehouse/libTestUdfs.so' symbol='NoArgs'", new TPrivilege[0][]);
        this.authzError(events -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@url", "all", "hdfs://localhost:20500/test-warehouse/new_table", 0, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"create table functional.new_table(i int) location 'hdfs://localhost:20500/test-warehouse/new_table'", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "create table functional.new_table(i int) location 'hdfs://localhost:20500/test-warehouse/new_table'", new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)});
        this.authzError(events -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypes", 0, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"select id, string_col from functional.alltypes", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "select id, string_col from functional.alltypes", new TPrivilege[0][]);
        this.authzError(events -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "select", "functional/non_existing_tbl", 0, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"select * from functional.non_existing_tbl", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "select * from functional.non_existing_tbl", new TPrivilege[0][]);
        this.authzError(events -> {
            Assert.assertEquals((long)1L, (long)events.size());
            RangerAuditLogTest.assertEventEquals("@table", "view_metadata", "functional/alltypes", 0, (AuthzAuditEvent)events.get(0));
            Assert.assertEquals((Object)"show partitions functional.alltypes", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
        }, "show partitions functional.alltypes", new TPrivilege[0][]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditsForColumnMasking() throws ImpalaException {
        String policyName;
        int i;
        String databaseName = "functional";
        String tableName = "alltypestiny";
        String[] policyNames = new String[]{"col_mask_custom", "col_mask_null", "col_mask_none", "col_mask_redact"};
        String[] columnNames = new String[]{"string_col", "date_string_col", "id", "year"};
        String[] users = new String[]{user_.getShortName(), user_.getShortName(), user_.getShortName(), "non_owner_2"};
        String[] masks = new String[]{"  {\n    \"dataMaskType\": \"CUSTOM\",\n    \"valueExpr\": \"concat({col}, 'xyz')\"\n  }\n", "  {\n    \"dataMaskType\": \"MASK_NULL\"\n  }\n", "  {\n    \"dataMaskType\": \"MASK_NONE\"\n  }\n", "  {\n    \"dataMaskType\": \"MASK\"\n  }\n"};
        long[] policyIds = new long[]{-1L, -1L, -1L, -1L};
        HashSet<Long> columnMaskingPolicyIds = new HashSet<Long>();
        ArrayList<String> policies = new ArrayList<String>();
        for (i = 0; i < masks.length; ++i) {
            String json = String.format("{\n  \"name\": \"%s\",\n  \"policyType\": 1,\n  \"serviceType\": \"%s\",\n  \"service\": \"%s\",\n  \"resources\": {\n    \"database\": {\n      \"values\": [\"%s\"],\n      \"isExcludes\": false,\n      \"isRecursive\": false\n    },\n    \"table\": {\n      \"values\": [\"%s\"],\n      \"isExcludes\": false,\n      \"isRecursive\": false\n    },\n    \"column\": {\n      \"values\": [\"%s\"],\n      \"isExcludes\": false,\n      \"isRecursive\": false\n    }\n  },\n  \"dataMaskPolicyItems\": [\n    {\n      \"accesses\": [\n        {\n          \"type\": \"select\",\n          \"isAllowed\": true\n        }\n      ],\n      \"users\": [\"%s\"],\n      \"dataMaskInfo\":\n%s    }\n  ]\n}", policyNames[i], "hive", "test_impala", databaseName, tableName, columnNames[i], users[i], masks[i]);
            policies.add(json);
        }
        try {
            for (i = 0; i < masks.length; ++i) {
                policyName = policyNames[i];
                String json = (String)policies.get(i);
                policyIds[i] = this.createRangerPolicy(policyName, json);
                Assert.assertNotEquals((String)"Illegal policy id", (long)-1L, (long)policyIds[i]);
                if (i >= 3) continue;
                columnMaskingPolicyIds.add(policyIds[i]);
            }
            this.authzOk((List<AuthzAuditEvent> events) -> {
                Assert.assertEquals((long)3L, (long)events.size());
                Assert.assertEquals((Object)"select id, bool_col, string_col from functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(0));
                RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypestiny/id,bool_col,string_col", 1, (AuthzAuditEvent)events.get(1));
                RangerAuditLogTest.assertEventEquals("@column", "custom", "functional/alltypestiny/string_col", 1, (AuthzAuditEvent)events.get(2));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(2)).getPolicyId(), (long)policyIds[0]);
            }, "select id, bool_col, string_col from functional.alltypestiny", new TPrivilege[][]{this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)});
            this.authzOk((List<AuthzAuditEvent> events) -> {
                Assert.assertEquals((long)4L, (long)events.size());
                Assert.assertEquals((Object)"select * from functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(0));
                RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypestiny/id,bool_col,tinyint_col,smallint_col,int_col,bigint_col,float_col,double_col,date_string_col,string_col,timestamp_col,year,month", 1, (AuthzAuditEvent)events.get(1));
                RangerAuditLogTest.assertEventEquals("@column", "mask_null", "functional/alltypestiny/date_string_col", 1, (AuthzAuditEvent)events.get(2));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(2)).getPolicyId(), (long)policyIds[1]);
                RangerAuditLogTest.assertEventEquals("@column", "custom", "functional/alltypestiny/string_col", 1, (AuthzAuditEvent)events.get(3));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(3)).getPolicyId(), (long)policyIds[0]);
            }, "select * from functional.alltypestiny", new TPrivilege[][]{this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)});
            this.authzOk((List<AuthzAuditEvent> events) -> {
                Assert.assertEquals((long)3L, (long)events.size());
                Assert.assertEquals((Object)"with iv as (select id, bool_col, string_col from functional.alltypestiny) select * from iv", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(0));
                RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypestiny/id,bool_col,string_col", 1, (AuthzAuditEvent)events.get(1));
                RangerAuditLogTest.assertEventEquals("@column", "custom", "functional/alltypestiny/string_col", 1, (AuthzAuditEvent)events.get(2));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(2)).getPolicyId(), (long)policyIds[0]);
            }, "with iv as (select id, bool_col, string_col from functional.alltypestiny) select * from iv", new TPrivilege[][]{this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)});
            this.authzOk((List<AuthzAuditEvent> events) -> {
                Assert.assertEquals((long)3L, (long)events.size());
                Assert.assertEquals((Object)"select id, string_col from functional.alltypestiny a where exists (select id from functional.alltypestiny where id = a.id) order by id;", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(0));
                RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypestiny/id,string_col", 1, (AuthzAuditEvent)events.get(1));
                RangerAuditLogTest.assertEventEquals("@column", "custom", "functional/alltypestiny/string_col", 1, (AuthzAuditEvent)events.get(2));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(2)).getPolicyId(), (long)policyIds[0]);
            }, "select id, string_col from functional.alltypestiny a where exists (select id from functional.alltypestiny where id = a.id) order by id;", new TPrivilege[][]{this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"with iv as (select id, bool_col, string_col from functional.alltypestiny) select * from iv", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
            }, "with iv as (select id, bool_col, string_col from functional.alltypestiny) select * from iv", new TPrivilege[][]{this.onTable("functional", "alltypestiny", new TPrivilegeLevel[0])});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"invalidate metadata functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "refresh", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
                Assert.assertTrue((boolean)columnMaskingPolicyIds.contains(((AuthzAuditEvent)events.get(0)).getPolicyId()));
            }, "invalidate metadata functional.alltypestiny", new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"compute stats functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "alter", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
                Assert.assertTrue((boolean)columnMaskingPolicyIds.contains(((AuthzAuditEvent)events.get(0)).getPolicyId()));
            }, "compute stats functional.alltypestiny", new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"alter table functional.alltypestiny change column id id string", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "alter", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
                Assert.assertTrue((boolean)columnMaskingPolicyIds.contains(((AuthzAuditEvent)events.get(0)).getPolicyId()));
            }, "alter table functional.alltypestiny change column id id string", new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"truncate table functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "insert", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
                Assert.assertTrue((boolean)columnMaskingPolicyIds.contains(((AuthzAuditEvent)events.get(0)).getPolicyId()));
            }, "truncate table functional.alltypestiny", new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"insert into functional.alltypestiny partition(year, month) select * from functional.alltypes", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "insert", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
                Assert.assertTrue((boolean)columnMaskingPolicyIds.contains(((AuthzAuditEvent)events.get(0)).getPolicyId()));
            }, "insert into functional.alltypestiny partition(year, month) select * from functional.alltypes", new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
        }
        finally {
            for (i = 0; i < masks.length; ++i) {
                policyName = policyNames[i];
                this.deleteRangerPolicy(policyName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditsForRowFiltering() throws ImpalaException {
        String policyName;
        int i;
        String databaseName = "functional";
        String[] tableNames = new String[]{"alltypestiny", "alltypes"};
        String[] policyNames = new String[]{"tiny_filter", "all_filter"};
        String[] users = new String[]{user_.getShortName(), "non_owner_2"};
        String[] filters = new String[]{"id=0", "id=1"};
        long[] policyIds = new long[]{-1L, -1L};
        ArrayList<String> policies = new ArrayList<String>();
        for (i = 0; i < filters.length; ++i) {
            String json = String.format("{\n  \"name\": \"%s\",\n  \"policyType\": 2,\n  \"serviceType\": \"%s\",\n  \"service\": \"%s\",\n  \"resources\": {\n    \"database\": {\n      \"values\": [\"%s\"],\n      \"isExcludes\": false,\n      \"isRecursive\": false\n    },\n    \"table\": {\n      \"values\": [\"%s\"],\n      \"isExcludes\": false,\n      \"isRecursive\": false\n    }\n  },\n  \"rowFilterPolicyItems\": [\n    {\n      \"accesses\": [\n        {\n          \"type\": \"select\",\n          \"isAllowed\": true\n        }\n      ],\n      \"users\": [\"%s\"],\n      \"rowFilterInfo\": {\"filterExpr\": \"%s\"}\n    }\n  ]\n}", policyNames[i], "hive", "test_impala", databaseName, tableNames[i], users[i], filters[i]);
            policies.add(json);
        }
        try {
            for (i = 0; i < filters.length; ++i) {
                policyName = policyNames[i];
                String json = (String)policies.get(i);
                policyIds[i] = this.createRangerPolicy(policyName, json);
                Assert.assertNotEquals((String)"Illegal policy id", (long)-1L, (long)policyIds[i]);
            }
            this.authzOk((List<AuthzAuditEvent> events) -> {
                Assert.assertEquals((long)3L, (long)events.size());
                Assert.assertEquals((Object)"select bool_col from functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(0));
                RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypestiny/bool_col,id", 1, (AuthzAuditEvent)events.get(1));
                RangerAuditLogTest.assertEventEquals("@table", "row_filter", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(2));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(2)).getPolicyId(), (long)policyIds[0]);
            }, "select bool_col from functional.alltypestiny", new TPrivilege[][]{this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)});
            this.authzOk((List<AuthzAuditEvent> events) -> {
                Assert.assertEquals((long)3L, (long)events.size());
                Assert.assertEquals((Object)"select 1 from functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(0));
                RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypestiny/id", 1, (AuthzAuditEvent)events.get(1));
                RangerAuditLogTest.assertEventEquals("@table", "row_filter", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(2));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(2)).getPolicyId(), (long)policyIds[0]);
            }, "select 1 from functional.alltypestiny", new TPrivilege[][]{this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)});
            this.authzOk((List<AuthzAuditEvent> events) -> {
                Assert.assertEquals((long)3L, (long)events.size());
                Assert.assertEquals((Object)"select count(*) from functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(0));
                RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypestiny/id", 1, (AuthzAuditEvent)events.get(1));
                RangerAuditLogTest.assertEventEquals("@table", "row_filter", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(2));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(2)).getPolicyId(), (long)policyIds[0]);
            }, "select count(*) from functional.alltypestiny", new TPrivilege[][]{this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)});
            this.authzOk((List<AuthzAuditEvent> events) -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"select count(*) from functional.alltypes", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypes", 1, (AuthzAuditEvent)events.get(0));
            }, "select count(*) from functional.alltypes", new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)});
            this.authzOk((List<AuthzAuditEvent> events) -> {
                Assert.assertEquals((long)3L, (long)events.size());
                Assert.assertEquals((Object)"select * from functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(0));
                RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypestiny/id,bool_col,tinyint_col,smallint_col,int_col,bigint_col,float_col,double_col,date_string_col,string_col,timestamp_col,year,month", 1, (AuthzAuditEvent)events.get(1));
                RangerAuditLogTest.assertEventEquals("@table", "row_filter", "functional/alltypestiny", 1, (AuthzAuditEvent)events.get(2));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(2)).getPolicyId(), (long)policyIds[0]);
            }, "select * from functional.alltypestiny", new TPrivilege[][]{this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)});
            this.authzOk((List<AuthzAuditEvent> events) -> {
                Assert.assertEquals((long)2L, (long)events.size());
                Assert.assertEquals((Object)"select * from functional.alltypes", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypes", 1, (AuthzAuditEvent)events.get(0));
                RangerAuditLogTest.assertEventEquals("@column", "select", "functional/alltypes/id,bool_col,tinyint_col,smallint_col,int_col,bigint_col,float_col,double_col,date_string_col,string_col,timestamp_col,year,month", 1, (AuthzAuditEvent)events.get(1));
            }, "select * from functional.alltypes", new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"select * from functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "select", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
            }, "select * from functional.alltypestiny", new TPrivilege[][]{this.onTable("functional", "alltypestiny", new TPrivilegeLevel[0])});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"invalidate metadata functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "refresh", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(0)).getPolicyId(), (long)policyIds[0]);
            }, "invalidate metadata functional.alltypestiny", new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"compute stats functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "alter", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(0)).getPolicyId(), (long)policyIds[0]);
            }, "compute stats functional.alltypestiny", new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"alter table functional.alltypestiny change column id id string", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "alter", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(0)).getPolicyId(), (long)policyIds[0]);
            }, "alter table functional.alltypestiny change column id id string", new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"truncate table functional.alltypestiny", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "insert", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(0)).getPolicyId(), (long)policyIds[0]);
            }, "truncate table functional.alltypestiny", new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authzError(events -> {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"insert into functional.alltypestiny partition(year, month) select * from functional.alltypes", (Object)((AuthzAuditEvent)events.get(0)).getRequestData());
                RangerAuditLogTest.assertEventEquals("@table", "insert", "functional/alltypestiny", 0, (AuthzAuditEvent)events.get(0));
                Assert.assertEquals((long)((AuthzAuditEvent)events.get(0)).getPolicyId(), (long)policyIds[0]);
            }, "insert into functional.alltypestiny partition(year, month) select * from functional.alltypes", new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
        }
        finally {
            for (i = 0; i < filters.length; ++i) {
                policyName = policyNames[i];
                try {
                    this.deleteRangerPolicy(policyName);
                    continue;
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    private void authzOk(Consumer<List<AuthzAuditEvent>> resultChecker, String stmt, TPrivilege[] ... privileges) throws ImpalaException {
        this.authzOk(resultChecker, stmt, true, privileges);
    }

    private void authzOk(Consumer<List<AuthzAuditEvent>> resultChecker, String stmt, boolean expectAnalysisOk, TPrivilege[] ... privileges) throws ImpalaException {
        this.authorize(stmt).ok(expectAnalysisOk, privileges);
        RangerAuthorizationContext rangerCtx = (RangerAuthorizationContext)authzChecker_.authzCtx_;
        Preconditions.checkNotNull((Object)rangerCtx);
        Preconditions.checkNotNull((Object)rangerCtx.getAuditHandler());
        resultChecker.accept(rangerCtx.getAuditHandler().getAuthzEvents());
    }

    private void authzError(Consumer<List<AuthzAuditEvent>> resultChecker, String stmt, TPrivilege[] ... privileges) throws ImpalaException {
        this.authorize(stmt).error("", privileges);
        RangerAuthorizationContext rangerCtx = (RangerAuthorizationContext)authzChecker_.authzCtx_;
        Preconditions.checkNotNull((Object)rangerCtx);
        Preconditions.checkNotNull((Object)rangerCtx.getAuditHandler());
        resultChecker.accept(rangerCtx.getAuditHandler().getAuthzEvents());
    }

    private static void assertEventEquals(String resourceType, String accessType, String resourcePath, int accessResult, AuthzAuditEvent event) {
        Assert.assertEquals((Object)resourceType, (Object)event.getResourceType());
        Assert.assertEquals((Object)accessType, (Object)event.getAccessType());
        Assert.assertEquals((Object)resourcePath, (Object)event.getResourcePath());
        Assert.assertEquals((long)accessResult, (long)event.getAccessResult());
        Assert.assertEquals((Object)"test-cluster", (Object)event.getClusterName());
        Assert.assertTrue((!event.getClientIP().isEmpty() ? 1 : 0) != 0);
    }

    @Override
    protected List<AuthorizationTestBase.WithPrincipal> buildWithPrincipals() {
        return Collections.singletonList(new AuthorizationTestBase.WithRangerUser(this));
    }

    @Override
    protected AuthorizationFactory createAuthorizationFactory(AuthorizationProvider authzProvider) {
        return new RangerAuthorizationFactory(this.authzConfig_){

            public AuthorizationChecker newAuthorizationChecker(AuthorizationPolicy authzPolicy) {
                if (authzChecker_ == null) {
                    authzChecker_ = new RangerAuthorizationCheckerSpy(RangerAuditLogTest.this.authzConfig_);
                }
                return authzChecker_;
            }
        };
    }

    private static class RangerAuthorizationCheckerSpy
    extends RangerAuthorizationChecker {
        private AuthorizationContext authzCtx_;

        public RangerAuthorizationCheckerSpy(AuthorizationConfig authzConfig) {
            super(authzConfig);
        }

        public void postAuthorize(AuthorizationContext authzCtx, boolean authzOk, boolean analysisOk) {
            super.postAuthorize(authzCtx, authzOk, analysisOk);
            this.authzCtx_ = authzCtx;
        }
    }
}

