/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.NoopAuthorizationFactory;
import org.apache.impala.authorization.ranger.RangerAuthorizationChecker;
import org.apache.impala.authorization.ranger.RangerImpalaPlugin;
import org.apache.impala.authorization.ranger.RangerUtil;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.Role;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.ranger.plugin.model.RangerRole;

public class CatalogServiceTestCatalogWithRanger
extends CatalogServiceTestCatalog {
    private static final String RANGER_ADMIN_USER = "admin";
    private RangerImpalaPlugin rangerImpalaPlugin_;

    protected CatalogServiceTestCatalogWithRanger(boolean loadInBackground, int numLoadingThreads, MetaStoreClientPool metaStoreClientPool) throws ImpalaException {
        super(loadInBackground, numLoadingThreads, metaStoreClientPool);
    }

    public static CatalogServiceTestCatalog create() {
        return CatalogServiceTestCatalogWithRanger.createWithAuth((AuthorizationFactory)new NoopAuthorizationFactory());
    }

    public static CatalogServiceTestCatalog createWithAuth(final AuthorizationFactory factory) {
        return CatalogServiceTestCatalogWithRanger.createWithAuth(factory, new CatalogServiceTestCatalog.BaseTestCatalogSupplier(){

            @Override
            public CatalogServiceTestCatalog get() throws ImpalaException {
                MetaStoreClientPool metaStoreClientPool = new MetaStoreClientPool(0, 0);
                CatalogServiceTestCatalogWithRanger cs = new CatalogServiceTestCatalogWithRanger(false, 16, metaStoreClientPool);
                RangerImpalaPlugin rangerImpalaPlugin = ((RangerAuthorizationChecker)factory.newAuthorizationChecker()).getRangerImpalaPlugin();
                cs.setRangerImpalaPlugin(rangerImpalaPlugin);
                return cs;
            }
        });
    }

    public void setRangerImpalaPlugin(RangerImpalaPlugin rangerImpalaPlugin_) {
        this.rangerImpalaPlugin_ = rangerImpalaPlugin_;
    }

    public Role addRole(String roleName, Set<String> grantGroups) {
        Role authRole = null;
        RangerRole role = new RangerRole();
        role.setName(roleName);
        role.setCreatedByUser(RANGER_ADMIN_USER);
        List roleMemberList = grantGroups.stream().map(s -> new RangerRole.RoleMember(s, s.equals(RANGER_ADMIN_USER))).collect(Collectors.toList());
        role.setGroups(roleMemberList);
        try {
            this.rangerImpalaPlugin_.createRole(role, null);
            this.rangerImpalaPlugin_.refreshPoliciesAndTags();
            authRole = super.addRole(roleName, grantGroups);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return authRole;
    }

    public Role removeRole(String roleName) {
        Role authRole = null;
        try {
            RangerUtil.validateRangerAdmin((RangerImpalaPlugin)this.rangerImpalaPlugin_, (String)RANGER_ADMIN_USER);
            this.rangerImpalaPlugin_.dropRole(RANGER_ADMIN_USER, roleName, null);
            this.rangerImpalaPlugin_.refreshPoliciesAndTags();
            authRole = super.removeRole(roleName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return authRole;
    }
}

