/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationException;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.AuthorizationProvider;
import org.apache.impala.authorization.CatalogServiceTestCatalogWithRanger;
import org.apache.impala.authorization.User;
import org.apache.impala.authorization.ranger.RangerAuthorizationChecker;
import org.apache.impala.authorization.ranger.RangerAuthorizationConfig;
import org.apache.impala.authorization.ranger.RangerAuthorizationFactory;
import org.apache.impala.authorization.ranger.RangerCatalogdAuthorizationManager;
import org.apache.impala.authorization.ranger.RangerImpalaPlugin;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.service.Frontend;
import org.apache.impala.testutil.CatalogServiceTestCatalog;
import org.apache.impala.testutil.ImpaladTestCatalog;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TDescribeOutputStyle;
import org.apache.impala.thrift.TDescribeResult;
import org.apache.impala.thrift.TDescribeTableParams;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TPrivilegeLevel;
import org.apache.impala.thrift.TPrivilegeScope;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TTableName;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthorizationTestBase
extends FrontendTestBase {
    public static final Logger LOG = LoggerFactory.getLogger(AuthorizationTestBase.class);
    protected static final String RANGER_ADMIN_URL = "http://localhost:6080";
    protected static final String RANGER_USER = "admin";
    protected static final String RANGER_PASSWORD = "admin";
    protected static final String SERVER_NAME = "server1";
    protected static final User OWNER_USER = new User(System.getProperty("user.name"));
    protected static final List<String> GROUPS = Collections.singletonList("non_owner");
    protected static final List<String> OWNER_GROUPS = Collections.singletonList(System.getProperty("user.name"));
    protected static final String RANGER_SERVICE_TYPE = "hive";
    protected static final String RANGER_SERVICE_NAME = "test_impala";
    protected static final String RANGER_APP_ID = "impala";
    protected static final User RANGER_ADMIN = new User("admin");
    protected static User user_ = null;
    protected static boolean as_owner_ = false;
    protected final AuthorizationConfig authzConfig_;
    protected final AuthorizationFactory authzFactory_;
    protected final AuthorizationProvider authzProvider_;
    protected final AnalysisContext authzCtx_;
    protected final ImpaladTestCatalog authzCatalog_;
    protected final Frontend authzFrontend_;
    protected final RangerImpalaPlugin rangerImpalaPlugin_;
    protected final RangerRESTClient rangerRestClient_;
    protected final CatalogServiceTestCatalog testCatalog_;

    public AuthorizationTestBase(AuthorizationProvider authzProvider) throws ImpalaException {
        this.authzProvider_ = authzProvider;
        switch (authzProvider) {
            case RANGER: {
                user_ = new User("non_owner");
                this.authzConfig_ = new RangerAuthorizationConfig(RANGER_SERVICE_TYPE, RANGER_APP_ID, SERVER_NAME, null, null, null);
                this.authzFactory_ = this.createAuthorizationFactory(authzProvider);
                this.authzCtx_ = this.createAnalysisCtx(this.authzFactory_, user_.getName());
                this.testCatalog_ = CatalogServiceTestCatalogWithRanger.createWithAuth(this.authzFactory_);
                this.authzCatalog_ = new ImpaladTestCatalog(this.testCatalog_);
                this.authzFrontend_ = new Frontend(this.authzFactory_, (FeCatalog)this.authzCatalog_);
                this.rangerImpalaPlugin_ = ((RangerAuthorizationChecker)this.authzFrontend_.getAuthzChecker()).getRangerImpalaPlugin();
                Assert.assertEquals((Object)"test-cluster", (Object)this.rangerImpalaPlugin_.getClusterName());
                this.rangerRestClient_ = new RangerRESTClient(RANGER_ADMIN_URL, null, (Configuration)this.rangerImpalaPlugin_.getConfig());
                this.rangerRestClient_.setBasicAuthInfo("admin", "admin");
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported authorization provider: %s", authzProvider));
            }
        }
    }

    protected AuthorizationFactory createAuthorizationFactory(AuthorizationProvider authzProvider) {
        return new RangerAuthorizationFactory(this.authzConfig_);
    }

    private static Map<String, String> updateUri(Map<String, String> resources) {
        String uri = resources.get("url");
        if (uri != null && uri.startsWith("/")) {
            uri = "hdfs://localhost:20500" + uri;
            resources.put("url", uri);
        }
        return resources;
    }

    protected DescribeOutput describeOutput(TDescribeOutputStyle style) {
        return new DescribeOutput(style);
    }

    protected List<WithPrincipal> buildWithPrincipals() {
        ArrayList<WithPrincipal> withPrincipals = new ArrayList<WithPrincipal>();
        switch (this.authzProvider_) {
            case RANGER: {
                withPrincipals.add(new WithRangerUser());
                withPrincipals.add(new WithRangerGroup());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported authorization provider: %s", this.authzProvider_));
            }
        }
        return withPrincipals;
    }

    protected AuthzTest authorize(String stmt) {
        return new AuthzTest(stmt);
    }

    protected AuthzTest authorize(AnalysisContext ctx, String stmt) {
        return new AuthzTest(ctx, stmt);
    }

    protected TPrivilege[] onServer(TPrivilegeLevel ... levels) {
        return this.onServer(false, levels);
    }

    protected TPrivilege[] onServer(boolean grantOption, TPrivilegeLevel ... levels) {
        TPrivilege[] privileges = new TPrivilege[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            privileges[i] = new TPrivilege(levels[i], TPrivilegeScope.SERVER, false);
            privileges[i].setServer_name(SERVER_NAME);
            privileges[i].setHas_grant_opt(grantOption);
        }
        return privileges;
    }

    protected TPrivilege[] onDatabase(String db, TPrivilegeLevel ... levels) {
        return this.onDatabase(false, db, levels);
    }

    protected TPrivilege[] onDatabase(boolean grantOption, String db, TPrivilegeLevel ... levels) {
        TPrivilege[] privileges = new TPrivilege[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            privileges[i] = new TPrivilege(levels[i], TPrivilegeScope.DATABASE, false);
            privileges[i].setServer_name(SERVER_NAME);
            privileges[i].setDb_name(db);
            privileges[i].setHas_grant_opt(grantOption);
        }
        return privileges;
    }

    protected TPrivilege[] onTable(String db, String table, TPrivilegeLevel ... levels) {
        return this.onTable(false, db, table, levels);
    }

    protected TPrivilege[] onTable(boolean grantOption, String db, String table, TPrivilegeLevel ... levels) {
        TPrivilege[] privileges = new TPrivilege[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            privileges[i] = new TPrivilege(levels[i], TPrivilegeScope.TABLE, false);
            privileges[i].setServer_name(SERVER_NAME);
            privileges[i].setDb_name(db);
            privileges[i].setTable_name(table);
            privileges[i].setHas_grant_opt(grantOption);
        }
        return privileges;
    }

    protected TPrivilege[] onColumn(String db, String table, String column, TPrivilegeLevel ... levels) {
        return this.onColumn(db, table, new String[]{column}, levels);
    }

    protected TPrivilege[] onColumn(boolean grantOption, String db, String table, String column, TPrivilegeLevel ... levels) {
        return this.onColumn(grantOption, db, table, new String[]{column}, levels);
    }

    protected TPrivilege[] onColumn(String db, String table, String[] columns, TPrivilegeLevel ... levels) {
        return this.onColumn(false, db, table, columns, levels);
    }

    protected TPrivilege[] onColumn(boolean grantOption, String db, String table, String[] columns, TPrivilegeLevel ... levels) {
        int size = columns.length * levels.length;
        TPrivilege[] privileges = new TPrivilege[size];
        int idx = 0;
        for (int i = 0; i < levels.length; ++i) {
            for (String column : columns) {
                privileges[idx] = new TPrivilege(levels[i], TPrivilegeScope.COLUMN, false);
                privileges[idx].setServer_name(SERVER_NAME);
                privileges[idx].setDb_name(db);
                privileges[idx].setTable_name(table);
                privileges[idx].setColumn_name(column);
                privileges[idx].setHas_grant_opt(grantOption);
                ++idx;
            }
        }
        return privileges;
    }

    protected TPrivilege[] onUri(String uri, TPrivilegeLevel ... levels) {
        return this.onUri(false, uri, levels);
    }

    protected TPrivilege[] onUri(boolean grantOption, String uri, TPrivilegeLevel ... levels) {
        TPrivilege[] privileges = new TPrivilege[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            privileges[i] = new TPrivilege(levels[i], TPrivilegeScope.URI, false);
            privileges[i].setServer_name(SERVER_NAME);
            privileges[i].setUri(uri);
            privileges[i].setHas_grant_opt(grantOption);
        }
        return privileges;
    }

    protected TPrivilege[] onStorageHandlerUri(String storageType, String storageUri, TPrivilegeLevel ... levels) {
        return this.onStorageHandlerUri(false, storageType, storageUri, levels);
    }

    protected TPrivilege[] onStorageHandlerUri(boolean grantOption, String storageType, String storageUri, TPrivilegeLevel ... levels) {
        TPrivilege[] privileges = new TPrivilege[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            privileges[i] = new TPrivilege(levels[i], TPrivilegeScope.STORAGEHANDLER_URI, false);
            privileges[i].setServer_name(SERVER_NAME);
            privileges[i].setStorage_type(storageType);
            privileges[i].setStorage_url(storageUri);
            privileges[i].setHas_grant_opt(grantOption);
        }
        return privileges;
    }

    protected TPrivilege[] onUdf(String db, String fn, TPrivilegeLevel ... levels) {
        return this.onUdf(false, db, fn, levels);
    }

    protected TPrivilege[] onUdf(boolean grantOption, String db, String fn, TPrivilegeLevel ... levels) {
        TPrivilege[] privileges = new TPrivilege[levels.length];
        for (int i = 0; i < levels.length; ++i) {
            privileges[i] = new TPrivilege(levels[i], TPrivilegeScope.USER_DEFINED_FN, false);
            privileges[i].setServer_name(SERVER_NAME);
            privileges[i].setDb_name(db);
            privileges[i].setFn_name(fn);
            privileges[i].setHas_grant_opt(grantOption);
        }
        return privileges;
    }

    private void authzOk(String stmt, WithPrincipal withPrincipal) throws ImpalaException {
        this.authzOk(this.authzCtx_, stmt, withPrincipal, true);
    }

    private void authzOk(String stmt, WithPrincipal withPrincipal, boolean expectAnalysisOk) throws ImpalaException {
        this.authzOk(this.authzCtx_, stmt, withPrincipal, expectAnalysisOk);
    }

    private void authzOk(AnalysisContext context, String stmt, WithPrincipal withPrincipal) throws ImpalaException {
        this.authzOk(context, stmt, withPrincipal, true);
    }

    private void authzOk(AnalysisContext context, String stmt, WithPrincipal withPrincipal, boolean expectAnalysisOk) throws ImpalaException {
        block3: {
            try {
                LOG.info("Testing authzOk for {}", (Object)stmt);
                this.parseAndAnalyze(stmt, context, this.authzFrontend_);
            }
            catch (AuthorizationException e) {
                throw new AuthorizationException(String.format("\nPrincipal: %s\nStatement: %s\nError: %s", new Object[]{withPrincipal.getName(), stmt, e.getMessage(), e}));
            }
            catch (AnalysisException e) {
                if (!expectAnalysisOk) break block3;
                throw new AnalysisException(String.format("\nPrincipal: %s\nStatement: %s\nError: %s", new Object[]{withPrincipal.getName(), stmt, e.getMessage(), e}));
            }
        }
    }

    private void authzError(String stmt, String expectedError, WithPrincipal withPrincipal) throws ImpalaException {
        this.authzError(this.authzCtx_, stmt, expectedError, AuthorizationTestBase.startsWith(), withPrincipal);
    }

    private void authzError(AnalysisContext context, String stmt, String expectedError, WithPrincipal withPrincipal) throws ImpalaException {
        this.authzError(context, stmt, expectedError, AuthorizationTestBase.startsWith(), withPrincipal);
    }

    private static Matcher exact() {
        return (actual, expected) -> actual.equals(expected);
    }

    private static Matcher startsWith() {
        return (actual, expected) -> actual.startsWith(expected);
    }

    private void authzError(AnalysisContext ctx, String stmt, String expectedErrorString, Matcher matcher, WithPrincipal withPrincipal) throws ImpalaException {
        Preconditions.checkNotNull((Object)expectedErrorString);
        try {
            LOG.info("Testing authzError for {}", (Object)stmt);
            this.parseAndAnalyze(stmt, ctx, this.authzFrontend_);
        }
        catch (AuthorizationException e) {
            expectedErrorString = String.format(expectedErrorString, ctx.getUser());
            String errorString = e.getMessage();
            Assert.assertTrue((String)("got error:\n" + errorString + "\nexpected:\n" + expectedErrorString), (boolean)matcher.match(errorString, expectedErrorString));
            return;
        }
        Assert.fail((String)String.format("Statement did not result in authorization error.\nPrincipal: %s\nStatement: %s", withPrincipal.getName(), stmt));
    }

    protected long createRangerPolicy(String policyName, String json) {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.rangerRestClient_.getResource("/service/public/v2/api/policy").accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)json);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new RuntimeException(String.format("Unable to create a Ranger policy: %s Response: %s", policyName, response.getEntity(String.class)));
        }
        String content = (String)response.getEntity(String.class);
        JSONParser parser = new JSONParser();
        long policyId = -1L;
        try {
            Object obj = parser.parse(content);
            policyId = (Long)((JSONObject)obj).get((Object)"id");
        }
        catch (ParseException e) {
            LOG.error("Error parsing response content: {}", (Object)content);
        }
        LOG.info("Created ranger policy id={}, {}: {}", new Object[]{policyId, policyName, json});
        return policyId;
    }

    protected void deleteRangerPolicy(String policyName) {
        ClientResponse response = (ClientResponse)this.rangerRestClient_.getResource("/service/public/v2/api/policy").queryParam("servicename", RANGER_SERVICE_NAME).queryParam("policyname", policyName).delete(ClientResponse.class);
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new RuntimeException(String.format("Unable to delete Ranger policy: %s.", policyName));
        }
        LOG.info("Deleted ranger policy {}", (Object)policyName);
    }

    private static List<String> resultToStringList(TDescribeResult result) {
        ArrayList<String> list = new ArrayList<String>();
        for (TResultRow row : result.getResults()) {
            for (TColumnValue col : row.getColVals()) {
                list.add(col.getString_val() == null ? "NULL" : col.getString_val().trim());
            }
        }
        return list;
    }

    protected static String selectError(String object) {
        return "User '%s' does not have privileges to execute 'SELECT' on: " + object;
    }

    protected static String insertError(String object) {
        return "User '%s' does not have privileges to execute 'INSERT' on: " + object;
    }

    protected static String createError(String object) {
        return "User '%s' does not have privileges to execute 'CREATE' on: " + object;
    }

    protected static String rwstorageError(String object) {
        return "User '%s' does not have privileges to execute 'RWSTORAGE' on: " + object;
    }

    protected static String alterError(String object) {
        return "User '%s' does not have privileges to execute 'ALTER' on: " + object;
    }

    protected static String dropError(String object) {
        return "User '%s' does not have privileges to execute 'DROP' on: " + object;
    }

    protected static String accessError(String object) {
        return AuthorizationTestBase.accessError(false, object);
    }

    protected static String accessError(boolean grantOption, String object) {
        return "User '%s' does not have privileges" + (grantOption ? " with 'GRANT OPTION'" : "") + " to access: " + object;
    }

    protected static String refreshError(String object) {
        return "User '%s' does not have privileges to execute 'INVALIDATE METADATA/REFRESH' on: " + object;
    }

    protected static String systemDbError() {
        return "Cannot modify system database.";
    }

    protected static String viewDefError(String object) {
        return "User '%s' does not have privileges to see the definition of view '" + object + "'.";
    }

    protected static String createFunctionError(String object) {
        return "User '%s' does not have privileges to CREATE functions in: " + object;
    }

    protected static String dropFunctionError(String object) {
        return "User '%s' does not have privileges to DROP functions in: " + object;
    }

    protected static String accessFunctionError(String object) {
        return "User '%s' does not have privileges to ANY functions in: " + object;
    }

    protected static String selectFunctionError(String object) {
        return "User '%s' does not have privileges to SELECT functions in: " + object;
    }

    protected static String columnMaskError(String object) {
        return "Column masking is disabled by --enable_column_masking flag. Can't access column " + object + " that has column masking policy.";
    }

    protected static String rowFilterError(String object) {
        return "Row filtering is disabled by --enable_row_filtering flag. Can't access table " + object + " that has row filtering policy.";
    }

    protected static String mvSelectError(String object) {
        return "Materialized view " + object + " references tables with column masking or row filtering policies.";
    }

    protected ScalarFunction addFunction(String db, String fnName, List<Type> argTypes, Type retType, String uriPath, String symbolName) {
        ScalarFunction fn = ScalarFunction.createForTesting((String)db, (String)fnName, argTypes, (Type)retType, (String)uriPath, (String)symbolName, null, null, (TFunctionBinaryType)TFunctionBinaryType.NATIVE);
        this.authzCatalog_.addFunction((Function)fn);
        return fn;
    }

    protected ScalarFunction addFunction(String db, String fnName) {
        return this.addFunction(db, fnName, new ArrayList<Type>(), (Type)Type.INT, "/dummy", "dummy.class");
    }

    protected void removeFunction(ScalarFunction fn) {
        this.authzCatalog_.removeFunction((Function)fn);
    }

    protected TPrivilegeLevel[] join(TPrivilegeLevel[] level1, TPrivilegeLevel ... level2) {
        TPrivilegeLevel[] levels = new TPrivilegeLevel[level1.length + level2.length];
        int index = 0;
        for (TPrivilegeLevel level : level1) {
            levels[index++] = level;
        }
        for (TPrivilegeLevel level : level2) {
            levels[index++] = level;
        }
        return levels;
    }

    protected TPrivilegeLevel[] viewMetadataPrivileges() {
        return new TPrivilegeLevel[]{TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT, TPrivilegeLevel.INSERT, TPrivilegeLevel.REFRESH};
    }

    protected static TPrivilegeLevel[] allExcept(TPrivilegeLevel ... excludedPrivLevels) {
        HashSet excludedSet = Sets.newHashSet((Object[])excludedPrivLevels);
        ArrayList<TPrivilegeLevel> privLevels = new ArrayList<TPrivilegeLevel>();
        for (TPrivilegeLevel level : TPrivilegeLevel.values()) {
            if (excludedSet.contains(level)) continue;
            privLevels.add(level);
        }
        return privLevels.toArray(new TPrivilegeLevel[0]);
    }

    @FunctionalInterface
    private static interface Matcher {
        public boolean match(String var1, String var2);
    }

    protected class AuthzTest {
        private final AnalysisContext context_;
        private final String stmt_;

        public AuthzTest(String stmt) {
            this(null, stmt);
        }

        public AuthzTest(AnalysisContext context, String stmt) {
            Preconditions.checkNotNull((Object)stmt);
            this.context_ = context;
            this.stmt_ = stmt;
        }

        public AuthzTest ok(TPrivilege[] ... privileges) throws ImpalaException {
            this.ok(true, privileges);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AuthzTest ok(boolean expectAnalysisOk, TPrivilege[] ... privileges) throws ImpalaException {
            for (WithPrincipal withPrincipal : AuthorizationTestBase.this.buildWithPrincipals()) {
                try {
                    withPrincipal.init(privileges);
                    if (this.context_ != null) {
                        AuthorizationTestBase.this.authzOk(this.context_, this.stmt_, withPrincipal, expectAnalysisOk);
                        continue;
                    }
                    AuthorizationTestBase.this.authzOk(this.stmt_, withPrincipal, expectAnalysisOk);
                }
                finally {
                    withPrincipal.cleanUp();
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AuthzTest okDescribe(TTableName table, DescribeOutput output, TPrivilege[] ... privileges) throws ImpalaException {
            for (WithPrincipal withPrincipal : AuthorizationTestBase.this.buildWithPrincipals()) {
                try {
                    withPrincipal.init(privileges);
                    if (this.context_ != null) {
                        AuthorizationTestBase.this.authzOk(this.context_, this.stmt_, withPrincipal);
                    } else {
                        AuthorizationTestBase.this.authzOk(this.stmt_, withPrincipal);
                    }
                    output.validate(table);
                }
                finally {
                    withPrincipal.cleanUp();
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AuthzTest error(String expectedError, TPrivilege[] ... privileges) throws ImpalaException {
            for (WithPrincipal withPrincipal : AuthorizationTestBase.this.buildWithPrincipals()) {
                try {
                    withPrincipal.init(privileges);
                    if (this.context_ != null) {
                        AuthorizationTestBase.this.authzError(this.context_, this.stmt_, expectedError, withPrincipal);
                        continue;
                    }
                    AuthorizationTestBase.this.authzError(this.stmt_, expectedError, withPrincipal);
                }
                finally {
                    withPrincipal.cleanUp();
                }
            }
            return this;
        }
    }

    protected class DescribeOutput {
        private String[] excludedStrings_ = new String[0];
        private String[] includedStrings_ = new String[0];
        private final TDescribeOutputStyle outputStyle_;

        public DescribeOutput(TDescribeOutputStyle style) {
            this.outputStyle_ = style;
        }

        public DescribeOutput excludeStrings(String[] excluded) {
            this.excludedStrings_ = excluded;
            return this;
        }

        public DescribeOutput includeStrings(String[] included) {
            this.includedStrings_ = included;
            return this;
        }

        public void validate(TTableName table) throws ImpalaException {
            Preconditions.checkArgument((this.includedStrings_.length != 0 || this.excludedStrings_.length != 0 ? 1 : 0) != 0, (Object)"One or both of included or excluded strings must be defined.");
            TDescribeTableParams testParams = new TDescribeTableParams();
            testParams.setTable_name(table);
            testParams.setOutput_style(this.outputStyle_);
            List result = AuthorizationTestBase.resultToStringList(AuthorizationTestBase.this.authzFrontend_.describeTable(testParams, user_));
            for (String str : this.includedStrings_) {
                Assert.assertTrue((String)String.format("\"%s\" is not in the describe output.\nExpected : %s\n Actual   : %s", str, Arrays.toString(this.includedStrings_), result), (boolean)result.contains(str));
            }
            for (String str : this.excludedStrings_) {
                Assert.assertTrue((String)String.format("\"%s\" should not be in the describe output.", str), (!result.contains(str) ? 1 : 0) != 0);
            }
        }
    }

    public class WithRangerGroup
    extends WithRanger {
        @Override
        protected List<GrantRevokeRequest> buildRequest(List<TPrivilege> privileges) {
            return RangerCatalogdAuthorizationManager.createGrantRevokeRequests((String)RANGER_ADMIN.getName(), (boolean)true, null, as_owner_ ? OWNER_GROUPS : GROUPS, Collections.emptyList(), (String)AuthorizationTestBase.this.rangerImpalaPlugin_.getClusterName(), (String)"127.0.0.1", privileges, null);
        }
    }

    public class WithRangerUser
    extends WithRanger {
        @Override
        protected List<GrantRevokeRequest> buildRequest(List<TPrivilege> privileges) {
            return RangerCatalogdAuthorizationManager.createGrantRevokeRequests((String)RANGER_ADMIN.getName(), (boolean)true, (String)this.getName(), Collections.emptyList(), Collections.emptyList(), (String)AuthorizationTestBase.this.rangerImpalaPlugin_.getClusterName(), (String)"127.0.0.1", privileges, null);
        }
    }

    protected abstract class WithRanger
    implements WithPrincipal {
        private final List<GrantRevokeRequest> grants = new ArrayList<GrantRevokeRequest>();
        private final RangerCatalogdAuthorizationManager authzManager = new RangerCatalogdAuthorizationManager(() -> AuthorizationTestBase.this.rangerImpalaPlugin_, null);

        protected WithRanger() {
        }

        @Override
        public void init(TPrivilege[] ... privileges) throws ImpalaException {
            for (TPrivilege[] privilege : privileges) {
                this.grants.addAll(this.buildRequest(Arrays.asList(privilege)).stream().peek(r -> {
                    r.setResource(AuthorizationTestBase.updateUri(r.getResource()));
                    if (r.getAccessTypes().contains("owner")) {
                        r.getAccessTypes().remove("owner");
                        r.getAccessTypes().add("all");
                    }
                }).collect(Collectors.toList()));
            }
            this.authzManager.grantPrivilege(this.grants, "", "127.0.0.1");
            AuthorizationTestBase.this.rangerImpalaPlugin_.refreshPoliciesAndTags();
        }

        protected abstract List<GrantRevokeRequest> buildRequest(List<TPrivilege> var1);

        @Override
        public void cleanUp() throws ImpalaException {
            this.authzManager.revokePrivilege(this.grants, "", "127.0.0.1");
        }

        @Override
        public String getName() {
            return as_owner_ ? OWNER_USER.getName() : user_.getName();
        }
    }

    protected static interface WithPrincipal {
        public void init(TPrivilege[] ... var1) throws ImpalaException;

        public void cleanUp() throws ImpalaException;

        public String getName();
    }
}

