/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.authorization;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.authorization.AuthorizationProvider;
import org.apache.impala.authorization.AuthorizationTestBase;
import org.apache.impala.authorization.PrivilegeRequest;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TDescribeOutputStyle;
import org.apache.impala.thrift.TPrivilege;
import org.apache.impala.thrift.TPrivilegeLevel;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TTableName;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class AuthorizationStmtTest
extends AuthorizationTestBase {
    public static final Logger LOG = LoggerFactory.getLogger(AuthorizationStmtTest.class);
    private static final String[] ALLTYPES_COLUMNS_WITHOUT_ID = new String[]{"bool_col", "tinyint_col", "smallint_col", "int_col", "bigint_col", "float_col", "double_col", "date_string_col", "string_col", "timestamp_col", "year", "month"};
    private static final String[] ALLTYPES_COLUMNS = (String[])ArrayUtils.addAll((Object[])new String[]{"id"}, (Object[])ALLTYPES_COLUMNS_WITHOUT_ID);

    public AuthorizationStmtTest(AuthorizationProvider authzProvider) throws ImpalaException {
        super(authzProvider);
    }

    @BeforeClass
    public static void setUp() {
        RuntimeEnv.INSTANCE.setTestEnv(true);
    }

    @AfterClass
    public static void cleanUp() {
        RuntimeEnv.INSTANCE.reset();
    }

    @After
    public void closeAuthzCatalog() {
        this.authzCatalog_.close();
    }

    @Parameterized.Parameters
    public static Collection<AuthorizationProvider> data() {
        return Arrays.asList(AuthorizationProvider.RANGER);
    }

    @Test
    public void testPrivilegeRequests() throws ImpalaException {
        HashSet expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes", "functional.alltypes.id", "functional.alltypes.bool_col", "functional.alltypes.tinyint_col", "functional.alltypes.smallint_col", "functional.alltypes.int_col", "functional.alltypes.bigint_col", "functional.alltypes.float_col", "functional.alltypes.double_col", "functional.alltypes.date_string_col", "functional.alltypes.string_col", "functional.alltypes.timestamp_col", "functional.alltypes.year", "functional.alltypes.month"});
        this.verifyPrivilegeReqs("select * from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs("select alltypes.* from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "select * from alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "select alltypes.* from alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs("select a.* from functional.alltypes a", expectedAuthorizables);
        this.verifyPrivilegeReqs("with t as (select * from functional.alltypes) select * from t", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "with t as (select * from alltypes) select * from t", expectedAuthorizables);
        this.verifyPrivilegeReqs("select * from functional.alltypes union all select * from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "select * from alltypes union all select * from alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes.*"});
        this.verifyPrivilegeReqs("describe functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "describe alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes", "functional.alltypes.id"});
        this.verifyPrivilegeReqs("select id from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs("select alltypes.id from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "select alltypes.id from alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "select id from alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs("select alltypes.id from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs("select a.id from functional.alltypes a", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes"});
        this.verifyPrivilegeReqs("insert into functional.alltypes(id) partition(month, year) values(1, 1, 2018)", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "insert into alltypes(id) partition(month, year) values(1, 1, 2018)", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.zipcode_incomes"});
        this.verifyPrivilegeReqs("insert into functional.zipcode_incomes(id) select '123'", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "insert into zipcode_incomes(id) select '123'", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes"});
        this.verifyPrivilegeReqs("truncate table functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "truncate table alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes", "hdfs://localhost:20500/test-warehouse/tpch.lineitem"});
        this.verifyPrivilegeReqs("load data inpath 'hdfs://localhost:20500/test-warehouse/tpch.lineitem' into table functional.alltypes partition(month=10, year=2009)", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "load data inpath 'hdfs://localhost:20500/test-warehouse/tpch.lineitem' into table alltypes partition(month=10, year=2009)", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes"});
        this.verifyPrivilegeReqs("invalidate metadata functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "invalidate metadata alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs("refresh functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "refresh alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.*.*"});
        this.verifyPrivilegeReqs("show tables in functional", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "show tables", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes"});
        this.verifyPrivilegeReqs("show partitions functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "show partitions alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional_kudu.dimtbl"});
        this.verifyPrivilegeReqs("show range partitions functional_kudu.dimtbl", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional_kudu"), "show range partitions dimtbl", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes"});
        this.verifyPrivilegeReqs("show table stats functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "show table stats alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes"});
        this.verifyPrivilegeReqs("show column stats functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "show column stats alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes"});
        this.verifyPrivilegeReqs("show create table functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "show create table functional.alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes_view"});
        this.verifyPrivilegeReqs("show create view functional.alltypes_view", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "show create view functional.alltypes_view", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes"});
        this.verifyPrivilegeReqs("compute stats functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "compute stats alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes"});
        this.verifyPrivilegeReqs("drop stats functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "drop stats alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.new_table"});
        this.verifyPrivilegeReqs("create table functional.new_table(i int)", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "create table new_table(i int)", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.new_view"});
        this.verifyPrivilegeReqs("create view functional.new_view as select 1", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "create view new_view as select 1", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes"});
        this.verifyPrivilegeReqs("drop table functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "drop table alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes_view"});
        this.verifyPrivilegeReqs("drop view functional.alltypes_view", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "drop view alltypes_view", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional_kudu.alltypes", "functional_kudu.alltypes.id", "functional_kudu.alltypes.int_col"});
        this.verifyPrivilegeReqs("update functional_kudu.alltypes set int_col = 1", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional_kudu"), "update alltypes set int_col = 1", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional_kudu.alltypes"});
        this.verifyPrivilegeReqs("upsert into table functional_kudu.alltypes(id, int_col) values(1, 1)", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional_kudu"), "upsert into table alltypes(id, int_col) values(1, 1)", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional_kudu.alltypes", "functional_kudu.alltypes.id"});
        this.verifyPrivilegeReqs("delete from functional_kudu.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional_kudu"), "delete from alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes"});
        this.verifyPrivilegeReqs("alter table functional.alltypes add columns(c1 int)", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "alter table alltypes add columns(c1 int)", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional.alltypes_view"});
        this.verifyPrivilegeReqs("alter view functional.alltypes_view as select 1", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "alter view alltypes_view as select 1", expectedAuthorizables);
    }

    @Test
    public void testCopyTestCasePrivileges() throws ImpalaException {
        HashSet expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional", "functional.alltypes", "functional.alltypes.id", "functional.alltypes.bool_col", "functional.alltypes.tinyint_col", "functional.alltypes.smallint_col", "functional.alltypes.int_col", "functional.alltypes.bigint_col", "functional.alltypes.float_col", "functional.alltypes.double_col", "functional.alltypes.date_string_col", "functional.alltypes.string_col", "functional.alltypes.timestamp_col", "functional.alltypes.year", "functional.alltypes.month", "hdfs://localhost:20500/tmp"});
        this.verifyPrivilegeReqs("copy testcase to '/tmp' select * from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs("copy testcase to '/tmp' select alltypes.* from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "copy testcase to '/tmp'  select * from alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "copy testcase to '/tmp' select alltypes.* from alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs("copy testcase to '/tmp' select a.* from functional.alltypes a", expectedAuthorizables);
        this.verifyPrivilegeReqs("copy testcase to '/tmp' with t as (select * from functional.alltypes) select * from t", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "copy testcase to '/tmp' with t as (select * from alltypes) select * from t", expectedAuthorizables);
        this.verifyPrivilegeReqs("copy testcase to '/tmp' select * from functional.alltypes union all select * from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "copy testcase to '/tmp'select * from alltypes union all select * from alltypes", expectedAuthorizables);
        expectedAuthorizables = Sets.newHashSet((Object[])new String[]{"functional", "functional.alltypes", "functional.alltypes.id", "hdfs://localhost:20500/tmp"});
        this.verifyPrivilegeReqs("copy testcase to '/tmp' select id from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs("copy testcase to '/tmp' select alltypes.id from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "copy testcase to '/tmp' select alltypes.id from alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs(this.createAnalysisCtx("functional"), "copy testcase to '/tmp' select id from alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs("copy testcase to '/tmp' select alltypes.id from functional.alltypes", expectedAuthorizables);
        this.verifyPrivilegeReqs("copy testcase to '/tmp' select a.id from functional.alltypes a", expectedAuthorizables);
        String copyTestCasePrefix = "copy testcase to '/tmp' ";
        for (AuthorizationTestBase.AuthzTest authzTest : new AuthorizationTestBase.AuthzTest[]{this.authorize("copy testcase to '/tmp' with t as (select id from functional.alltypes) select * from t"), this.authorize("copy testcase to '/tmp' select id from functional.alltypes")}) {
            authzTest.ok(this.onUri(false, "/tmp", TPrivilegeLevel.ALL), this.onDatabase("functional", this.viewMetadataPrivileges()), this.onTable("functional", "alltypes", this.viewMetadataPrivileges())).error(AuthorizationStmtTest.accessError("functional"), this.onUri(false, "/tmp", TPrivilegeLevel.ALL), this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges())), this.onTable("functional", "alltypes", this.viewMetadataPrivileges())).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/tmp"), this.onDatabase("functional", this.viewMetadataPrivileges()), this.onTable("functional", "alltypes", this.viewMetadataPrivileges()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelect() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest authzTest : new AuthorizationTestBase.AuthzTest[]{this.authorize("select id from functional.alltypes"), this.authorize("with t as (select id from functional.alltypes) select * from t")}) {
            authzTest.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onColumn("functional", "alltypes", "id", TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        }
        this.authorize("select 1 from functional.alltypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("select id from functional.alltypes_view"), this.authorize("select 2 * v.id from functional.alltypes_view v"), this.authorize("select cast(id as bigint) from functional.alltypes_view")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onColumn("functional", "alltypes_view", "id", TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), new TPrivilege[][]{this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        }
        this.authorize("select 1").ok(new TPrivilege[0][]);
        this.authorize("select a.id from functional.view_view a join functional.alltypesagg b ON (a.id = b.id)").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(this.onTable("functional", "view_view", TPrivilegeLevel.ALL), this.onTable("functional", "alltypesagg", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "view_view", TPrivilegeLevel.OWNER), this.onTable("functional", "alltypesagg", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "view_view", TPrivilegeLevel.ALL), this.onTable("functional", "alltypesagg", TPrivilegeLevel.SELECT)).ok(this.onTable("functional", "view_view", TPrivilegeLevel.OWNER), this.onTable("functional", "alltypesagg", TPrivilegeLevel.SELECT)).ok(this.onTable("functional", "view_view", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypesagg", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "view_view", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypesagg", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "view_view", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypesagg", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.view_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.view_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.view_view"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.view_view"), this.onTable("functional", "view_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)), this.onTable("functional", "alltypesagg", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)));
        this.authorize("select * from functional_seq_snap.subquery_view").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional_seq_snap", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional_seq_snap", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional_seq_snap", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional_seq_snap", "subquery_view", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional_seq_snap", "subquery_view", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional_seq_snap", "subquery_view", TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional_seq_snap.subquery_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional_seq_snap.subquery_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional_seq_snap.subquery_view"), new TPrivilege[][]{this.onDatabase("functional_seq_snap", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional_seq_snap.subquery_view"), new TPrivilege[][]{this.onTable("functional_seq_snap", "subquery_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        ScalarFunction fn = this.addFunction("functional", "f");
        ScalarFunction fn2 = this.addFunction("functional", "f2");
        try {
            this.authorize("select functional.f()").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(this.viewMetadataPrivileges())}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", this.viewMetadataPrivileges())}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(this.onUdf("functional", "f", TPrivilegeLevel.SELECT), this.onDatabase("functional", TPrivilegeLevel.INSERT)).ok(this.onUdf("functional", "f", TPrivilegeLevel.SELECT), this.onDatabase("functional", TPrivilegeLevel.REFRESH)).error(AuthorizationStmtTest.selectFunctionError("functional.f"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectFunctionError("functional.f"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).error(AuthorizationStmtTest.selectFunctionError("functional.f"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[][]{this.onUdf("functional", "f", TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.accessError("functional"), this.onUdf("functional", "f", TPrivilegeLevel.SELECT), this.onServer(AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))).error(AuthorizationStmtTest.accessError("functional"), this.onUdf("functional", "f", TPrivilegeLevel.SELECT), this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))).error(AuthorizationStmtTest.selectFunctionError("functional.f"), this.onDatabase("functional", TPrivilegeLevel.INSERT), this.onUdf("functional", "f2", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectFunctionError("functional.f"), this.onDatabase("functional", TPrivilegeLevel.REFRESH), this.onUdf("functional", "f2", TPrivilegeLevel.SELECT));
        }
        finally {
            this.removeFunction(fn);
            this.removeFunction(fn2);
        }
        this.authorize("select 1 from nodb.alltypes").error(AuthorizationStmtTest.selectError("nodb.alltypes"), new TPrivilege[0][]);
        this.authorize("select 1 from functional.notbl").error(AuthorizationStmtTest.selectError("functional.notbl"), new TPrivilege[0][]);
        this.authorize("with t as (select id from nodb.alltypes) select * from t").error(AuthorizationStmtTest.selectError("nodb.alltypes"), new TPrivilege[0][]);
        this.authorize("with t as (select id from functional.notbl) select * from t").error(AuthorizationStmtTest.selectError("functional.notbl"), new TPrivilege[0][]);
        this.authorize("with t as (select nocol from functional.alltypes) select * from t").error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onColumn("functional", "alltypes", ALLTYPES_COLUMNS, TPrivilegeLevel.SELECT)});
        this.authorize("with t(c1, c2) as (select id from functional.alltypes) select * from t").error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[0][]);
        this.authorize("select a.* from (select * from functional.alltypes) a").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onColumn("functional", "alltypes", ALLTYPES_COLUMNS, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        this.authorize("select count(id), int_col from functional.alltypes where id = 10 group by id, int_col").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onColumn("functional", "alltypes", new String[]{"id", "int_col"}, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        this.authorize("select a.int_struct_col.f1 from functional.allcomplextypes a where a.id = 1").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", new String[]{"id", "int_struct_col"}, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onTable("functional", "allcomplextypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        this.authorize("select key, pos, item.f1, f2 from functional.allcomplextypes t, t.struct_array_col, functional.allcomplextypes.int_map_col").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", new String[]{"struct_array_col", "int_map_col"}, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onTable("functional", "allcomplextypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        this.authorize("select int_array_col, array_array_col from functional.allcomplextypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", new String[]{"int_array_col", "array_array_col"}, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onTable("functional", "allcomplextypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", new String[]{"int_array_col"}, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", new String[]{"array_array_col"}, TPrivilegeLevel.SELECT)});
        this.authorize("select int_map_col, array_map_col, map_map_col from functional.allcomplextypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", new String[]{"int_map_col", "array_map_col", "map_map_col"}, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onTable("functional", "allcomplextypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", new String[]{"int_map_col"}, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", new String[]{"array_map_col"}, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", new String[]{"map_map_col"}, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", new String[]{"int_map_col", "map_map_col"}, TPrivilegeLevel.SELECT)});
        for (AuthorizationTestBase.AuthzTest authzTest : new AuthorizationTestBase.AuthzTest[]{this.authorize("select * from functional.alltypes union all select * from functional.alltypessmall"), this.authorize("select * from functional.alltypes a cross join functional.alltypessmall b")}) {
            authzTest.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.ALL), this.onTable("functional", "alltypessmall", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER), this.onTable("functional", "alltypessmall", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypessmall", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypessmall", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.ALL), this.onTable("functional", "alltypessmall", TPrivilegeLevel.SELECT)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER), this.onTable("functional", "alltypessmall", TPrivilegeLevel.SELECT)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypessmall", TPrivilegeLevel.SELECT)).ok(this.onColumn("functional", "alltypes", ALLTYPES_COLUMNS, TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypessmall", ALLTYPES_COLUMNS, TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)), this.onTable("functional", "alltypessmall", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))).error(AuthorizationStmtTest.selectError("functional.alltypessmall"), new TPrivilege[][]{this.onColumn("functional", "alltypes", ALLTYPES_COLUMNS, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onColumn("functional", "alltypessmall", ALLTYPES_COLUMNS, TPrivilegeLevel.SELECT)});
        }
        this.authorize("select unnest(int_array_col) from functional.allcomplextypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", new String[]{"id", "int_array_col"}, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.allcomplextypes"), new TPrivilege[][]{this.onTable("functional", "allcomplextypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        this.authorize("select id from functional.alltypes_view union all select x from functional.alltypes_view_sub").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALL), this.onTable("functional", "alltypes_view_sub", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "alltypes_view", TPrivilegeLevel.OWNER), this.onTable("functional", "alltypes_view_sub", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "alltypes_view", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypes_view_sub", TPrivilegeLevel.SELECT)).ok(this.onColumn("functional", "alltypes_view", "id", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes_view_sub", "x", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)), this.onTable("functional", "alltypes_view_sub", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypes_view_sub"), this.onTable("functional", "alltypes_view_sub", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)), this.onTable("functional", "alltypes_view", TPrivilegeLevel.SELECT));
        this.authorize("select id from nodb.alltypes union all select id from functional.alltypesagg").error(AuthorizationStmtTest.selectError("nodb.alltypes"), new TPrivilege[0][]);
        this.authorize("select id from functional.notbl union all select id from functional.alltypesagg").error(AuthorizationStmtTest.selectError("functional.notbl"), new TPrivilege[0][]);
    }

    @Test
    public void testInsert() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("insert into functional.zipcode_incomes(id) values('123')"), this.authorize("explain insert into functional.zipcode_incomes(id) values('123')")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.INSERT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.INSERT)}).ok(new TPrivilege[][]{this.onTable("functional", "zipcode_incomes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "zipcode_incomes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "zipcode_incomes", TPrivilegeLevel.INSERT)}).error(AuthorizationStmtTest.insertError("functional.zipcode_incomes"), new TPrivilege[0][]).error(AuthorizationStmtTest.insertError("functional.zipcode_incomes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT))}).error(AuthorizationStmtTest.insertError("functional.zipcode_incomes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT))}).error(AuthorizationStmtTest.insertError("functional.zipcode_incomes"), new TPrivilege[][]{this.onTable("functional", "zipcode_incomes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT))});
        }
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("with t as (select * from functional.alltypestiny) insert into functional.alltypes partition(month, year) select * from t"), this.authorize("insert into functional.alltypes partition(month, year) select * from functional.alltypestiny where id < 100")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT)}).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.ALL), this.onTable("functional", "alltypestiny", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER), this.onTable("functional", "alltypestiny", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT), this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT), this.onColumn("functional", "alltypestiny", ALLTYPES_COLUMNS, TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypestiny"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypestiny"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypestiny"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.insertError("functional.alltypes"), this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT))).error(AuthorizationStmtTest.selectError("functional.alltypestiny"), this.onTable("functional", "alltypestiny", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)), this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT));
        }
        this.authorize("insert into functional.alltypes partition(month, year) select * from functional.alltypes_view where id < 100").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT)}).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.ALL), this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER), this.onTable("functional", "alltypes_view", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT), this.onTable("functional", "alltypes_view", TPrivilegeLevel.SELECT)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT), this.onColumn("functional", "alltypes_view", ALLTYPES_COLUMNS, TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.insertError("functional.alltypes"), this.onTable("functional", "alltypes_view", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT))).error(AuthorizationStmtTest.selectError("functional.alltypes_view"), this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)), this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT));
        this.authorize("insert into functional.alltypes partition(month, year) select b.* from functional.alltypesagg a join (select * from functional.alltypestiny) b on (a.int_col = b.int_col)").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT)}).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.ALL), this.onTable("functional", "alltypesagg", TPrivilegeLevel.ALL), this.onTable("functional", "alltypestiny", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER), this.onTable("functional", "alltypesagg", TPrivilegeLevel.OWNER), this.onTable("functional", "alltypestiny", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT), this.onTable("functional", "alltypesagg", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypesagg"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypesagg"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypesagg"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.insertError("functional.alltypes"), this.onTable("functional", "alltypesagg", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT))).error(AuthorizationStmtTest.selectError("functional.alltypesagg"), this.onTable("functional", "alltypesagg", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)), this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT)).error(AuthorizationStmtTest.selectError("functional.alltypestiny"), this.onTable("functional", "alltypesagg", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypestiny", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)), this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT));
        this.authorize("insert into functional.alltypes_view(id) values(123)").error(AuthorizationStmtTest.insertError("functional.alltypes_view"), new TPrivilege[0][]);
        this.authorize("insert into nodb.alltypes(id) values(1)").error(AuthorizationStmtTest.insertError("nodb.alltypes"), new TPrivilege[0][]);
        this.authorize("insert into functional.notbl(id) values(1)").error(AuthorizationStmtTest.insertError("functional.notbl"), new TPrivilege[0][]);
    }

    @Test
    public void testUseDb() throws ImpalaException {
        AuthorizationTestBase.AuthzTest test = this.authorize("use functional");
        for (TPrivilegeLevel privilege : AuthorizationStmtTest.allExcept(TPrivilegeLevel.RWSTORAGE)) {
            test.ok(new TPrivilege[][]{this.onServer(privilege)}).ok(new TPrivilege[][]{this.onDatabase("functional", privilege)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", privilege)}).ok(new TPrivilege[][]{this.onColumn("functional", "alltypes", "id", privilege)});
        }
        test.error(AuthorizationStmtTest.accessError("functional.*.*"), new TPrivilege[0][]);
        this.authorize("use default").ok(new TPrivilege[0][]);
        this.authorize("use _impala_builtins").ok(new TPrivilege[0][]);
        this.authorize("use nodb").error(AuthorizationStmtTest.accessError("nodb.*.*"), new TPrivilege[0][]);
    }

    @Test
    public void testTruncate() throws ImpalaException {
        this.authorize("truncate table functional.alltypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.INSERT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.INSERT)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT)}).error(AuthorizationStmtTest.insertError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.insertError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT))}).error(AuthorizationStmtTest.insertError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT))}).error(AuthorizationStmtTest.insertError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT))});
        this.authorize("truncate table nodb.alltypes").error(AuthorizationStmtTest.insertError("nodb.alltypes"), new TPrivilege[0][]);
        this.authorize("truncate table functional.notbl").error(AuthorizationStmtTest.insertError("functional.notbl"), new TPrivilege[0][]);
        this.authorize("truncate table functional.alltypes_view").error(AuthorizationStmtTest.insertError("functional.alltypes_view"), new TPrivilege[0][]);
    }

    @Test
    public void testLoad() throws ImpalaException {
        this.authorize("load data inpath 'hdfs://localhost:20500/test-warehouse/tpch.lineitem' into table functional.alltypes partition(month=10, year=2009)").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onDatabase("functional", TPrivilegeLevel.ALL), this.onUri("hdfs://localhost:20500/test-warehouse/tpch.lineitem", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", TPrivilegeLevel.OWNER), this.onUri("hdfs://localhost:20500/test-warehouse/tpch.lineitem", TPrivilegeLevel.OWNER)).ok(this.onDatabase("functional", TPrivilegeLevel.INSERT), this.onUri("hdfs://localhost:20500/test-warehouse/tpch.lineitem", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", TPrivilegeLevel.INSERT), this.onUri("hdfs://localhost:20500/test-warehouse/tpch.lineitem", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.ALL), this.onUri("hdfs://localhost:20500/test-warehouse/tpch.lineitem", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER), this.onUri("hdfs://localhost:20500/test-warehouse/tpch.lineitem", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT), this.onUri("hdfs://localhost:20500/test-warehouse/tpch.lineitem", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT), this.onUri("hdfs://localhost:20500/test-warehouse/tpch.lineitem", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.insertError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/tpch.lineitem"), new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.INSERT)}).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/tpch.lineitem"), new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT)}).error(AuthorizationStmtTest.insertError("functional.alltypes"), new TPrivilege[][]{this.onUri("hdfs://localhost:20500/test-warehouse/tpch.lineitem", TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.insertError("functional.alltypes"), new TPrivilege[][]{this.onUri("hdfs://localhost:20500/test-warehouse/tpch.lineitem", TPrivilegeLevel.OWNER)});
        this.authorize("load data inpath 'hdfs://localhost:20500/test-warehouse/nouri' into table functional.alltypes partition(month=10, year=2009)").error(AuthorizationStmtTest.insertError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/nouri"), new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.INSERT)}).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/nouri"), new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.INSERT)});
        this.authorize("load data inpath 'hdfs://localhost:20500/test-warehouse/tpch.lineitem' into table nodb.alltypes partition(month=10, year=2009)").error(AuthorizationStmtTest.insertError("nodb.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.insertError("nodb.alltypes"), new TPrivilege[][]{this.onUri("hdfs://localhost:20500/test-warehouse/tpch.nouri", TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.insertError("nodb.alltypes"), new TPrivilege[][]{this.onUri("hdfs://localhost:20500/test-warehouse/tpch.nouri", TPrivilegeLevel.OWNER)});
        this.authorize("load data inpath 'hdfs://localhost:20500/test-warehouse/tpch.lineitem' into table functional.notbl partition(month=10, year=2009)").error(AuthorizationStmtTest.insertError("functional.notbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.insertError("functional.notbl"), new TPrivilege[][]{this.onUri("hdfs://localhost:20500/test-warehouse/tpch.nouri", TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.insertError("functional.notbl"), new TPrivilege[][]{this.onUri("hdfs://localhost:20500/test-warehouse/tpch.nouri", TPrivilegeLevel.OWNER)});
        this.authorize("load data inpath 'hdfs://localhost:20500/test-warehouse/tpch.lineitem' into table functional.alltypes_view").error(AuthorizationStmtTest.insertError("functional.alltypes_view"), new TPrivilege[0][]);
    }

    @Test
    public void testResetMetadata() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("invalidate metadata"), this.authorize("refresh authorization")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.REFRESH)}).error(AuthorizationStmtTest.refreshError("server"), new TPrivilege[0][]);
        }
        for (String name : new String[]{"alltypes", "alltypes_view"}) {
            for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("invalidate metadata functional." + (String)name), this.authorize("refresh functional." + (String)name)}) {
                test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.REFRESH)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.REFRESH)}).ok(new TPrivilege[][]{this.onTable("functional", name, TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", name, TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", name, TPrivilegeLevel.REFRESH)}).error(AuthorizationStmtTest.refreshError("functional." + (String)name), new TPrivilege[0][]).error(AuthorizationStmtTest.refreshError("functional." + (String)name), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.REFRESH))}).error(AuthorizationStmtTest.refreshError("functional." + (String)name), new TPrivilege[][]{this.onTable("functional", name, AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.REFRESH))});
            }
        }
        this.authorize("refresh functions functional").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.REFRESH)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.REFRESH)}).error(AuthorizationStmtTest.refreshError("functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.refreshError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.REFRESH))}).error(AuthorizationStmtTest.refreshError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.REFRESH))});
        this.authorize("invalidate metadata nodb").error(AuthorizationStmtTest.refreshError("default.nodb"), new TPrivilege[0][]);
        this.authorize("refresh nodb").error(AuthorizationStmtTest.refreshError("default.nodb"), new TPrivilege[0][]);
        this.authorize("refresh functions nodb").error(AuthorizationStmtTest.refreshError("nodb"), new TPrivilege[0][]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Test
    public void testShow() throws ImpalaException {
        this.authorize("show databases").ok(new TPrivilege[0][]);
        AuthorizationTestBase.AuthzTest test = this.authorize("show tables in functional");
        for (TPrivilegeLevel tPrivilegeLevel : AuthorizationStmtTest.allExcept(TPrivilegeLevel.RWSTORAGE)) {
            test.ok(new TPrivilege[][]{this.onServer(tPrivilegeLevel)}).ok(new TPrivilege[][]{this.onDatabase("functional", tPrivilegeLevel)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", tPrivilegeLevel)});
        }
        test.error(AuthorizationStmtTest.accessError("functional.*.*"), new TPrivilege[0][]);
        test = this.authorize("show metadata tables in functional_parquet.iceberg_query_metadata");
        test.error(AuthorizationStmtTest.accessError("functional_parquet"), new TPrivilege[0][]);
        for (TPrivilegeLevel tPrivilegeLevel : AuthorizationStmtTest.allExcept(TPrivilegeLevel.RWSTORAGE)) {
            test.error(AuthorizationStmtTest.accessError("functional_parquet.iceberg_query_metadata"), new TPrivilege[][]{this.onTable("functional_parquet", "alltypes", tPrivilegeLevel)});
            test.ok(new TPrivilege[][]{this.onTable("functional_parquet", "iceberg_query_metadata", tPrivilegeLevel)});
        }
        test = this.authorize("show views in functional");
        for (TPrivilegeLevel tPrivilegeLevel : AuthorizationStmtTest.allExcept(TPrivilegeLevel.RWSTORAGE)) {
            test.ok(new TPrivilege[][]{this.onServer(tPrivilegeLevel)}).ok(new TPrivilege[][]{this.onDatabase("functional", tPrivilegeLevel)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_views", tPrivilegeLevel)});
        }
        test.error(AuthorizationStmtTest.accessError("functional.*.*"), new TPrivilege[0][]);
        test = this.authorize("show functions in functional");
        for (TPrivilegeLevel tPrivilegeLevel : this.viewMetadataPrivileges()) {
            test.ok(new TPrivilege[][]{this.onServer(tPrivilegeLevel)}).ok(new TPrivilege[][]{this.onDatabase("functional", tPrivilegeLevel)});
        }
        test.error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[0][]);
        this.authorize("show tables in _impala_builtins").ok(new TPrivilege[0][]);
        this.authorize("show views in _impala_builtins").ok(new TPrivilege[0][]);
        this.authorize("show tables in nodb").error(AuthorizationStmtTest.accessError("nodb"), new TPrivilege[0][]);
        this.authorize("show views in nodb").error(AuthorizationStmtTest.accessError("nodb"), new TPrivilege[0][]);
        for (AuthorizationTestBase.AuthzTest authzTest : new AuthorizationTestBase.AuthzTest[]{this.authorize("show partitions functional.alltypes"), this.authorize("show table stats functional.alltypes"), this.authorize("show column stats functional.alltypes")}) {
            for (TPrivilegeLevel privilege : this.viewMetadataPrivileges()) {
                authzTest.ok(new TPrivilege[][]{this.onServer(privilege)}).ok(new TPrivilege[][]{this.onDatabase("functional", privilege)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", privilege)}).error(AuthorizationStmtTest.accessError("functional.alltypes"), new TPrivilege[][]{this.onColumn("functional", "alltypes", "id", TPrivilegeLevel.SELECT)});
            }
            authzTest.error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[0][]);
        }
        for (TPrivilegeLevel tPrivilegeLevel : this.viewMetadataPrivileges()) {
            this.authorize("show range partitions functional_kudu.dimtbl").ok(new TPrivilege[][]{this.onServer(tPrivilegeLevel)}).ok(new TPrivilege[][]{this.onDatabase("functional_kudu", tPrivilegeLevel)}).ok(new TPrivilege[][]{this.onTable("functional_kudu", "dimtbl", tPrivilegeLevel)}).error(AuthorizationStmtTest.accessError("functional_kudu.dimtbl"), new TPrivilege[][]{this.onColumn("functional_kudu", "dimtbl", "id", TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.accessError("functional_kudu"), new TPrivilege[0][]);
        }
        for (AuthorizationTestBase.AuthzTest authzTest : new AuthorizationTestBase.AuthzTest[]{this.authorize("show files in functional.alltypes"), this.authorize("show files in functional.alltypes partition(month=10, year=2010)")}) {
            for (TPrivilegeLevel privilege : this.viewMetadataPrivileges()) {
                authzTest.ok(new TPrivilege[][]{this.onServer(privilege)}).ok(new TPrivilege[][]{this.onDatabase("functional", privilege)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", privilege)});
            }
            authzTest.error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[0][]);
        }
        this.authorize("show current roles").ok(new TPrivilege[0][]);
        this.authorize("show roles").ok(new TPrivilege[0][]);
        this.authorize(String.format("show role grant group `%s`", user_.getName())).ok(new TPrivilege[0][]);
        try {
            this.authzCatalog_.addRole("test_role");
            this.authzCatalog_.addUser("test_user");
            for (String string : new String[]{"role test_role", "user test_user"}) {
                this.authorize(String.format("show grant %s", string)).ok(new TPrivilege[0][]);
                this.authorize(String.format("show grant %s on server", string)).ok(new TPrivilege[0][]);
                this.authorize(String.format("show grant %s on database functional", string)).ok(new TPrivilege[0][]);
                this.authorize(String.format("show grant %s on table functional.alltypes", string)).ok(new TPrivilege[0][]);
                this.authorize(String.format("show grant %s on uri '/test-warehouse'", string)).ok(new TPrivilege[0][]);
            }
        }
        finally {
            this.authzCatalog_.removeRole("test_role");
            this.authzCatalog_.removeUser("test_user");
        }
        test = this.authorize("show create table functional.alltypes");
        for (TPrivilegeLevel tPrivilegeLevel : this.viewMetadataPrivileges()) {
            test.ok(new TPrivilege[][]{this.onServer(tPrivilegeLevel)}).ok(new TPrivilege[][]{this.onDatabase("functional", tPrivilegeLevel)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", tPrivilegeLevel)});
        }
        test.error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[0][]);
        this.authorize("show create table nodb.alltypes").error(AuthorizationStmtTest.accessError("nodb.alltypes"), new TPrivilege[0][]);
        this.authorize("show create table functional.notbl").error(AuthorizationStmtTest.accessError("functional.notbl"), new TPrivilege[0][]);
        test = this.authorize("show create view functional.alltypes_view");
        for (TPrivilegeLevel tPrivilegeLevel : this.viewMetadataPrivileges()) {
            test.ok(new TPrivilege[][]{this.onServer(tPrivilegeLevel, TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", tPrivilegeLevel, TPrivilegeLevel.SELECT)}).ok(this.onTable("functional", "alltypes_view", tPrivilegeLevel), this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT));
        }
        test.error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[0][]);
        this.authorize("show create view nodb.alltypes").error(AuthorizationStmtTest.accessError("nodb.alltypes"), new TPrivilege[0][]);
        this.authorize("show create view functional.notbl").error(AuthorizationStmtTest.accessError("functional.notbl"), new TPrivilege[0][]);
        this.addTestView((Catalog)this.authzCatalog_, "create view functional.test_view as select count(*) from functional.alltypes");
        test = this.authorize("show create view functional.test_view");
        for (TPrivilegeLevel tPrivilegeLevel : this.viewMetadataPrivileges()) {
            test.ok(new TPrivilege[][]{this.onServer(tPrivilegeLevel, TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", tPrivilegeLevel, TPrivilegeLevel.SELECT)}).ok(this.onTable("functional", "test_view", tPrivilegeLevel), this.onTable("functional", "alltypes", tPrivilegeLevel, TPrivilegeLevel.SELECT));
        }
        test.error(AuthorizationStmtTest.accessError("functional.test_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("functional.test_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).error(AuthorizationStmtTest.accessError("functional.test_view"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).error(AuthorizationStmtTest.accessError("functional.test_view"), this.onTable("functional", "test_view", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges())), this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.viewDefError("functional.test_view"), this.onTable("functional", "test_view", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges())));
        ScalarFunction scalarFunction = this.addFunction("functional", "f");
        try {
            void var5_39;
            test = this.authorize("show create function functional.f");
            TPrivilegeLevel[] tPrivilegeLevelArray = this.viewMetadataPrivileges();
            int n = tPrivilegeLevelArray.length;
            boolean bl = false;
            while (var5_39 < n) {
                TPrivilegeLevel privilege = tPrivilegeLevelArray[var5_39];
                test.ok(new TPrivilege[][]{this.onServer(privilege)}).ok(new TPrivilege[][]{this.onDatabase("functional", privilege)});
                ++var5_39;
            }
            test.error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[0][]);
            this.authorize("show create function nodb.f").error(AuthorizationStmtTest.accessError("nodb"), new TPrivilege[0][]);
            this.authorize("show create function functional.nofn").error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[0][]);
        }
        finally {
            this.removeFunction(scalarFunction);
        }
        this.authorize("show create function _impala_builtins.pi").ok(new TPrivilege[0][]);
        this.authorize("show data sources").ok(new TPrivilege[0][]);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribe() throws ImpalaException {
        void var6_11;
        AuthorizationTestBase.AuthzTest authzTest = this.authorize("describe database functional");
        for (TPrivilegeLevel privilege : this.viewMetadataPrivileges()) {
            authzTest.ok(new TPrivilege[][]{this.onServer(privilege)}).ok(new TPrivilege[][]{this.onDatabase("functional", privilege)});
        }
        authzTest.error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))});
        this.authorize("describe database nodb").error(AuthorizationStmtTest.accessError("nodb"), new TPrivilege[0][]);
        TTableName tableName = new TTableName("functional", "alltypes");
        TDescribeOutputStyle style = TDescribeOutputStyle.MINIMAL;
        authzTest = this.authorize("describe functional.alltypes");
        TPrivilegeLevel[] tPrivilegeLevelArray = this.viewMetadataPrivileges();
        int privilege = tPrivilegeLevelArray.length;
        boolean bl = false;
        while (var6_11 < privilege) {
            TPrivilegeLevel privilege2 = tPrivilegeLevelArray[var6_11];
            authzTest.okDescribe(tableName, this.describeOutput(style).includeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onServer(privilege2)}).okDescribe(tableName, this.describeOutput(style).includeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onDatabase("functional", privilege2)}).okDescribe(tableName, this.describeOutput(style).includeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onTable("functional", "alltypes", privilege2)});
            ++var6_11;
        }
        authzTest.okDescribe(tableName, this.describeOutput(style).includeStrings(new String[]{"id"}).excludeStrings(ALLTYPES_COLUMNS_WITHOUT_ID), new TPrivilege[][]{this.onColumn("functional", "alltypes", "id", TPrivilegeLevel.SELECT)}).okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).error(AuthorizationStmtTest.accessError("functional.alltypes"), new TPrivilege[0][]);
        tableName = new TTableName("functional", "alltypes");
        style = TDescribeOutputStyle.EXTENDED;
        String[] checkStrings = (String[])ArrayUtils.addAll((Object[])ALLTYPES_COLUMNS, (Object[])new String[]{"Location:"});
        authzTest = this.authorize("describe functional.alltypes");
        for (TPrivilegeLevel privilege3 : this.viewMetadataPrivileges()) {
            authzTest.okDescribe(tableName, this.describeOutput(style).includeStrings(checkStrings), new TPrivilege[][]{this.onServer(privilege3)}).okDescribe(tableName, this.describeOutput(style).includeStrings(checkStrings), new TPrivilege[][]{this.onDatabase("functional", privilege3)}).okDescribe(tableName, this.describeOutput(style).includeStrings(checkStrings), new TPrivilege[][]{this.onTable("functional", "alltypes", privilege3)});
        }
        authzTest.okDescribe(tableName, this.describeOutput(style).includeStrings(new String[]{"id"}).excludeStrings((String[])ArrayUtils.addAll((Object[])ALLTYPES_COLUMNS_WITHOUT_ID, (Object[])new String[]{"Location:"})), new TPrivilege[][]{this.onColumn("functional", "alltypes", "id", TPrivilegeLevel.SELECT)}).okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).error(AuthorizationStmtTest.accessError("functional.alltypes"), new TPrivilege[0][]);
        tableName = new TTableName("functional", "alltypes_view");
        style = TDescribeOutputStyle.MINIMAL;
        authzTest = this.authorize("describe functional.alltypes_view");
        for (TPrivilegeLevel privilege3 : this.viewMetadataPrivileges()) {
            authzTest.okDescribe(tableName, this.describeOutput(style).includeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onServer(privilege3)}).okDescribe(tableName, this.describeOutput(style).includeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onDatabase("functional", privilege3)}).okDescribe(tableName, this.describeOutput(style).includeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onTable("functional", "alltypes_view", privilege3)});
        }
        authzTest.okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).error(AuthorizationStmtTest.accessError("functional.alltypes_view"), new TPrivilege[0][]);
        tableName = new TTableName("functional", "alltypes_view");
        style = TDescribeOutputStyle.EXTENDED;
        Object[] viewStrings = new String[]{"View Original Text:", "View Expanded Text:"};
        checkStrings = (String[])ArrayUtils.addAll((Object[])ALLTYPES_COLUMNS, (Object[])viewStrings);
        authzTest = this.authorize("describe functional.alltypes_view");
        for (TPrivilegeLevel tPrivilegeLevel : this.viewMetadataPrivileges()) {
            authzTest.okDescribe(tableName, this.describeOutput(style).includeStrings(checkStrings), new TPrivilege[][]{this.onServer(tPrivilegeLevel)}).okDescribe(tableName, this.describeOutput(style).includeStrings(checkStrings), new TPrivilege[][]{this.onDatabase("functional", tPrivilegeLevel)}).okDescribe(tableName, this.describeOutput(style).includeStrings(checkStrings), new TPrivilege[][]{this.onTable("functional", "alltypes_view", tPrivilegeLevel)});
        }
        authzTest.okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).okDescribe(tableName, this.describeOutput(style).excludeStrings(ALLTYPES_COLUMNS), new TPrivilege[][]{this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).error(AuthorizationStmtTest.accessError("functional.alltypes_view"), new TPrivilege[0][]);
        authzTest = this.authorize("describe functional.allcomplextypes.int_struct_col");
        for (TPrivilegeLevel tPrivilegeLevel : this.viewMetadataPrivileges()) {
            authzTest.ok(new TPrivilege[][]{this.onServer(tPrivilegeLevel)}).ok(new TPrivilege[][]{this.onDatabase("functional", tPrivilegeLevel)}).ok(new TPrivilege[][]{this.onTable("functional", "allcomplextypes", tPrivilegeLevel)});
        }
        authzTest.ok(new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", "int_struct_col", TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.accessError("functional.allcomplextypes"), new TPrivilege[0][]);
        for (AuthorizationTestBase.AuthzTest authzTest2 : new AuthorizationTestBase.AuthzTest[]{this.authorize("describe functional.allcomplextypes.int_struct_col"), this.authorize("describe functional.allcomplextypes.complex_struct_col.f2"), this.authorize("describe functional.allcomplextypes.nested_struct_col.f1")}) {
            authzTest2.error(AuthorizationStmtTest.accessError("functional.allcomplextypes"), new TPrivilege[][]{this.onColumn("functional", "allcomplextypes", "id", TPrivilegeLevel.SELECT)});
        }
    }

    @Test
    public void testStats() throws ImpalaException {
        this.authorize("compute stats functional.alltypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT))});
        this.authorize("compute stats nodb.notbl").error(AuthorizationStmtTest.alterError("nodb.notbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("nodb.notbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.alterError("nodb.notbl"), new TPrivilege[][]{this.onDatabase("nodb", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT))});
        this.authorize("compute stats functional.notbl").error(AuthorizationStmtTest.alterError("functional.notbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.notbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.alterError("functional.notbl"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT))});
        this.authorize("drop stats functional.alltypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALTER)}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
        this.authorize("drop stats nodb.notbl").error(AuthorizationStmtTest.alterError("nodb.notbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("nodb.notbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("nodb.notbl"), new TPrivilege[][]{this.onDatabase("nodb", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
        this.authorize("drop stats functional.notbl").error(AuthorizationStmtTest.alterError("functional.notbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.notbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.notbl"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
    }

    @Test
    public void testCreateDatabase() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("create database newdb"), this.authorize("create database if not exists newdb")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.CREATE)}).error(AuthorizationStmtTest.createError("newdb"), new TPrivilege[0][]).error(AuthorizationStmtTest.createError("newdb"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))});
        }
        String uri = "hdfs://localhost:20500/test-warehouse/new_location";
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("create database newdb location '" + uri + "'"), this.authorize("create database newdb managedlocation '" + uri + "'")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri(uri, TPrivilegeLevel.ALL)).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri(uri, TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.createError("newdb"), new TPrivilege[0][]).error(AuthorizationStmtTest.createError("newdb"), this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE)), this.onUri(uri, TPrivilegeLevel.ALL)).error(AuthorizationStmtTest.createError("newdb"), this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE)), this.onUri(uri, TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.accessError(uri), new TPrivilege[][]{this.onServer(TPrivilegeLevel.CREATE)});
        }
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("create database functional"), this.authorize("create database if not exists functional")}) {
            test.error(AuthorizationStmtTest.createError("functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))});
        }
        this.authorize("create database if not exists _impala_builtins").error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)});
    }

    @Test
    public void testCreateTable() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("create table functional.new_table(i int)"), this.authorize("create external table functional.new_table(i int)")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.CREATE)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))});
        }
        this.authorize("create table functional.new_table like functional.alltypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(this.join(this.viewMetadataPrivileges(), TPrivilegeLevel.CREATE))}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", this.join(this.viewMetadataPrivileges(), TPrivilegeLevel.CREATE))}).ok(this.onDatabase("functional", new TPrivilegeLevel[0]), this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onTable("functional", "alltypes", this.viewMetadataPrivileges())).error(AuthorizationStmtTest.accessError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(this.join(this.viewMetadataPrivileges(), TPrivilegeLevel.CREATE)))}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.createError("functional"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE)), this.onTable("functional", "alltypes", this.viewMetadataPrivileges())).error(AuthorizationStmtTest.accessError("functional.alltypes"), this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges())));
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("create table functional.alltypes(i int)"), this.authorize("create table if not exists functional.alltypes(i int)")}) {
            test.error(AuthorizationStmtTest.createError("functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))});
        }
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("create table functional.new_table as select int_col from functional.alltypes"), this.authorize("explain create table functional.new_table as select int_col from functional.alltypes")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT)}).ok(this.onDatabase("functional", new TPrivilegeLevel[0]), this.onDatabase("functional", TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT), this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)).ok(this.onDatabase("functional", new TPrivilegeLevel[0]), this.onDatabase("functional", TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT), this.onColumn("functional", "alltypes", "int_col", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", new TPrivilegeLevel[0]), this.onDatabase("functional", TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT), this.onColumn("functional", "alltypes", "int_col", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.createError("functional"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT)), this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional"), this.onDatabase("functional", TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT), this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)));
        }
        this.authorize("create table functional.new_table(i int) location 'hdfs://localhost:20500/test-warehouse/new_table'").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.ALL)).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.createError("functional"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE)), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.ALL)).error(AuthorizationStmtTest.createError("functional"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE)), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/new_table"), new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)});
        this.authorize("create external table functional.new_table(i int) location 'hdfs://localhost:20500/test-warehouse/UPPER_CASE/test'").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri("hdfs://localhost:20500/test-warehouse/UPPER_CASE/test", TPrivilegeLevel.ALL)).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri("hdfs://localhost:20500/test-warehouse/UPPER_CASE/test", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/UPPER_CASE/test"), this.onServer(TPrivilegeLevel.CREATE), this.onUri("hdfs://localhost:20500/test-warehouse/upper_case/test", TPrivilegeLevel.ALL)).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/UPPER_CASE/test"), this.onServer(TPrivilegeLevel.CREATE), this.onUri("hdfs://localhost:20500/test-warehouse/upper_case/test", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.createError("functional"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE)), this.onUri("hdfs://localhost:20500/test-warehouse/UPPER_CASE/test", TPrivilegeLevel.ALL)).error(AuthorizationStmtTest.createError("functional"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE)), this.onUri("hdfs://localhost:20500/test-warehouse/UPPER_CASE/test", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/UPPER_CASE/test"), new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)});
        this.authorize("create table functional.new_table like parquet 'hdfs://localhost:20500/test-warehouse/schemas/alltypestiny.parquet'").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri("hdfs://localhost:20500/test-warehouse/schemas/alltypestiny.parquet", TPrivilegeLevel.ALL)).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri("hdfs://localhost:20500/test-warehouse/schemas/alltypestiny.parquet", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/schemas/alltypestiny.parquet"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.createError("functional"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE)), this.onUri("hdfs://localhost:20500/test-warehouse/schemas/alltypestiny.parquet", TPrivilegeLevel.ALL)).error(AuthorizationStmtTest.createError("functional"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE)), this.onUri("hdfs://localhost:20500/test-warehouse/schemas/alltypestiny.parquet", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/schemas/alltypestiny.parquet"), new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)});
        this.authorize("create table if not exists _impala_builtins.new_table(i int)").error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)});
        this.authorize("create external table functional.kudu_tbl stored as kudu tblproperties ('kudu.master_addresses'='127.0.0.1', 'kudu.table_name'='tbl')").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("server1"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError("server1"), this.onDatabase("functional", TPrivilegeLevel.ALL), this.onStorageHandlerUri("kudu", "127.0.0.1/tbl", TPrivilegeLevel.RWSTORAGE)).error(AuthorizationStmtTest.accessError("server1"), this.onDatabase("functional", TPrivilegeLevel.OWNER), this.onStorageHandlerUri("kudu", "127.0.0.1/tbl", TPrivilegeLevel.RWSTORAGE));
        BackendConfig.INSTANCE.getBackendCfg().setKudu_master_hosts("127.0.0.1");
        this.authorize("create external table functional.kudu_tbl stored as kudu tblproperties ('kudu.table_name'='tbl')").ok(this.onDatabase("functional", TPrivilegeLevel.ALL), this.onStorageHandlerUri("kudu", "127.0.0.1/tbl", TPrivilegeLevel.RWSTORAGE)).ok(this.onDatabase("functional", TPrivilegeLevel.OWNER), this.onStorageHandlerUri("kudu", "127.0.0.1/tbl", TPrivilegeLevel.RWSTORAGE)).ok(this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onStorageHandlerUri("kudu", "127.0.0.1/tbl", TPrivilegeLevel.RWSTORAGE)).error(AuthorizationStmtTest.rwstorageError("kudu://127.0.0.1/tbl"), new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.rwstorageError("kudu://127.0.0.1/tbl"), new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).error(AuthorizationStmtTest.rwstorageError("kudu://127.0.0.1/tbl"), new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[0][]);
        this.authorize("create external table functional.kudu_tbl stored as kudu tblproperties ('kudu.table_name'='impala::tpch_kudu.nation')").ok(this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onStorageHandlerUri("*", "*", TPrivilegeLevel.RWSTORAGE)).ok(this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onStorageHandlerUri("kudu", "*", TPrivilegeLevel.RWSTORAGE)).ok(this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onStorageHandlerUri("kudu", "127.0.0.1/impala::tpch_kudu.*", TPrivilegeLevel.RWSTORAGE));
        for (String tableName : new String[]{"alltypes", "alltypestiny", "non_existing"}) {
            this.authorize(String.format("create external table functional.kudu_tbl stored as kudu tblproperties ('kudu.table_name'='impala::functional_kudu.%s')", tableName)).error(AuthorizationStmtTest.rwstorageError(String.format("kudu://127.0.0.1/impala::functional_kudu.%s", tableName)), this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onStorageHandlerUri("kudu", "127.0.0.1/impala::tpch_kudu.*", TPrivilegeLevel.RWSTORAGE));
        }
        this.authorize("create table functional.kudu_tbl (i int, j int, primary key (i)) partition by hash (i) partitions 9 stored as kudu").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))});
        this.authorize("create table functional.kudu_tbl primary key (bigint_col) stored as kudu as select bigint_col, string_col, current_timestamp() as ins_date from functional.alltypes where exists (select 1 from functional.alltypes)").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))});
        this.authorize("create table nodb.new_table(i int)").error(AuthorizationStmtTest.createError("nodb"), new TPrivilege[0][]).error(AuthorizationStmtTest.createError("nodb"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.createError("nodb"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))});
    }

    @Test
    public void testCreateView() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("create view functional.new_view as select int_col from functional.alltypes"), this.authorize("create view functional.new_view(a) as select int_col from functional.alltypes")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.CREATE, TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE, TPrivilegeLevel.SELECT)}).ok(this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)).ok(this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onColumn("functional", "alltypes", "int_col", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onColumn("functional", "alltypes", "int_col", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        }
        this.authorize("create view functional.new_view as select 1").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.CREATE)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))});
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("create view functional.alltypes_view as select int_col from functional.alltypes"), this.authorize("create view if not exists functional.alltypes_view as select int_col from functional.alltypes")}) {
            test.error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.createError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        }
        this.authorize("create view if not exists _impala_builtins.new_view as select 1").error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)});
        this.authorize("create view nodb.new_view as select 1").error(AuthorizationStmtTest.createError("nodb"), new TPrivilege[0][]).error(AuthorizationStmtTest.createError("nodb"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.createError("nodb"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))});
    }

    @Test
    public void testDropDatabase() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("drop database functional"), this.authorize("drop database functional cascade"), this.authorize("drop database functional restrict")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.DROP)}).error(AuthorizationStmtTest.dropError("functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.dropError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))}).error(AuthorizationStmtTest.dropError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))});
        }
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("drop database nodb"), this.authorize("drop database nodb cascade"), this.authorize("drop database nodb restrict")}) {
            test.error(AuthorizationStmtTest.dropError("nodb"), new TPrivilege[0][]).error(AuthorizationStmtTest.dropError("nodb"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))});
        }
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("drop database if exists nodb"), this.authorize("drop database if exists nodb cascade"), this.authorize("drop database if exists nodb restrict")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.CREATE)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.INSERT)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.REFRESH)}).error(AuthorizationStmtTest.accessError("nodb"), new TPrivilege[0][]);
        }
        this.authorize("drop database _impala_builtins").error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)});
    }

    @Test
    public void testDropTable() throws ImpalaException {
        this.authorize("drop table functional.alltypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.DROP)}).error(AuthorizationStmtTest.dropError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.dropError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))}).error(AuthorizationStmtTest.dropError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))}).error(AuthorizationStmtTest.dropError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))});
        this.authorize("drop table nodb.notbl").error(AuthorizationStmtTest.dropError("nodb.notbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.dropError("nodb.notbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))}).error(AuthorizationStmtTest.dropError("nodb.notbl"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))});
        this.authorize("drop table functional.notbl").error(AuthorizationStmtTest.dropError("functional.notbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.dropError("functional.notbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))}).error(AuthorizationStmtTest.dropError("functional.notbl"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))});
        this.authorize("drop table if exists functional.notbl").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.CREATE)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.INSERT)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.REFRESH)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.INSERT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.REFRESH)}).error(AuthorizationStmtTest.accessError("functional.notbl"), new TPrivilege[0][]);
        this.authorize("drop table _impala_builtins.tbl").error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)});
    }

    @Test
    public void testDropView() throws ImpalaException {
        this.authorize("drop view functional.alltypes_view").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.DROP)}).error(AuthorizationStmtTest.dropError("functional.alltypes_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.dropError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))}).error(AuthorizationStmtTest.dropError("functional.alltypes_view"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))}).error(AuthorizationStmtTest.dropError("functional.alltypes_view"), new TPrivilege[][]{this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))});
        this.authorize("drop view nodb.noview").error(AuthorizationStmtTest.dropError("nodb.noview"), new TPrivilege[0][]).error(AuthorizationStmtTest.dropError("nodb.noview"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))}).error(AuthorizationStmtTest.dropError("nodb.noview"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))});
        this.authorize("drop table functional.noview").error(AuthorizationStmtTest.dropError("functional.noview"), new TPrivilege[0][]).error(AuthorizationStmtTest.dropError("functional.noview"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))}).error(AuthorizationStmtTest.dropError("functional.noview"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))});
        this.authorize("drop table if exists functional.noview").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.CREATE)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.INSERT)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.REFRESH)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.INSERT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.REFRESH)}).error(AuthorizationStmtTest.accessError("functional.noview"), new TPrivilege[0][]);
        this.authorize("drop table _impala_builtins.v").error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterTable() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("alter table functional.alltypes add column c1 int"), this.authorize("alter table functional.alltypes add columns(c1 int)"), this.authorize("alter table functional.alltypes replace columns(c1 int)"), this.authorize("alter table functional.alltypes change int_col c1 int"), this.authorize("alter table functional.alltypes drop int_col"), this.authorize("alter table functional.alltypes set fileformat parquet"), this.authorize("alter table functional.alltypes set tblproperties('a'='b')"), this.authorize("alter table functional.alltypes partition(year=2009) set tblproperties('a'='b')"), this.authorize("alter table functional.alltypes set cached in 'testPool'"), this.authorize("alter table functional.alltypes partition(year=2009) set cached in 'testPool'"), this.authorize("alter table functional.alltypes sort by (id)"), this.authorize("alter table functional.alltypes sort by zorder (id, bool_col)"), this.authorize("alter table functional.alltypes set column stats int_col ('numNulls'='1')"), this.authorize("alter table functional.alltypes recover partitions"), this.authorize("alter table functional.alltypes set row format delimited fields terminated by ' '"), this.authorize("alter table functional.alltypes partition(year=2009) set row format delimited fields terminated by ' '"), this.authorize("alter table functional.alltypes add partition(year=1, month=1)"), this.authorize("alter table functional.alltypes drop partition(year=2009, month=1)")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALTER)}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
        }
        try {
            this.authzCatalog_.addRole("foo_owner");
            for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("alter table functional.alltypes set owner user foo_owner"), this.authorize("alter table functional.alltypes set owner role foo_owner")}) {
                test.ok(new TPrivilege[][]{this.onServer(true, TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(true, TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase(true, "functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase(true, "functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable(true, "functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable(true, "functional", "alltypes", TPrivilegeLevel.OWNER)}).error(AuthorizationStmtTest.accessError(true, "functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError(true, "functional.alltypes"), new TPrivilege[][]{this.onServer(true, AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError(true, "functional.alltypes"), new TPrivilege[][]{this.onDatabase(true, "functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError(true, "functional.alltypes"), new TPrivilege[][]{this.onTable(true, "functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))});
                test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.values())});
                test.ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.values())});
                test.ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.values())});
            }
        }
        finally {
            this.authzCatalog_.removeRole("foo_owner");
        }
        boolean exceptionThrown = false;
        try {
            this.parseAndAnalyze("alter table functional.alltypes set owner role foo_owner", this.authzCtx_, frontend_);
        }
        catch (AnalysisException e) {
            exceptionThrown = true;
            Assert.assertEquals((Object)"Role 'foo_owner' does not exist.", (Object)e.getLocalizedMessage());
        }
        Assert.assertTrue((boolean)exceptionThrown);
        this.authorize("alter table functional.alltypes rename to functional_parquet.new_table").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onDatabase("functional", TPrivilegeLevel.ALL), this.onDatabase("functional_parquet", TPrivilegeLevel.CREATE)).ok(this.onDatabase("functional_parquet", TPrivilegeLevel.CREATE), this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", TPrivilegeLevel.OWNER), this.onDatabase("functional_parquet", TPrivilegeLevel.CREATE)).ok(this.onDatabase("functional_parquet", TPrivilegeLevel.CREATE), this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.accessError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.accessError("functional.alltypes"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER)), this.onDatabase("functional_parquet", TPrivilegeLevel.CREATE)).error(AuthorizationStmtTest.createError("functional_parquet"), this.onDatabase("functional", TPrivilegeLevel.ALL), this.onDatabase("functional_parquet", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))).error(AuthorizationStmtTest.accessError("functional.alltypes"), this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))).error(AuthorizationStmtTest.createError("functional_parquet"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE)), this.onTable("functional", "alltypes", TPrivilegeLevel.ALL));
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("alter table functional_kudu.testtbl alter column name drop default"), this.authorize("alter table functional_kudu.testtbl alter column name set default null"), this.authorize("alter table functional_kudu.testtbl add range partition 1 < values < 2"), this.authorize("alter table functional_kudu.testtbl drop range partition 1 < values < 2")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional_kudu", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional_kudu", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional_kudu", TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onTable("functional_kudu", "testtbl", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional_kudu", "testtbl", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional_kudu", "testtbl", TPrivilegeLevel.ALTER)}).error(AuthorizationStmtTest.alterError("functional_kudu.testtbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional_kudu.testtbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional_kudu.testtbl"), new TPrivilege[][]{this.onDatabase("functional_kudu", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional_kudu.testtbl"), new TPrivilege[][]{this.onTable("functional_kudu", "testtbl", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
        }
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("alter table functional.alltypes set location 'hdfs://localhost:20500/test-warehouse/new_table'"), this.authorize("alter table functional.alltypes partition(year=2009, month=1) set location 'hdfs://localhost:20500/test-warehouse/new_table'")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onServer(TPrivilegeLevel.ALTER), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.ALL)).ok(this.onServer(TPrivilegeLevel.ALTER), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.OWNER)).ok(this.onDatabase("functional", TPrivilegeLevel.ALL), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", TPrivilegeLevel.OWNER), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.OWNER)).ok(this.onDatabase("functional", TPrivilegeLevel.ALTER), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", TPrivilegeLevel.ALTER), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.ALL), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.OWNER)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.ALTER), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.ALL)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.ALTER), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.alltypes"), this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER)), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", new TPrivilegeLevel[0])).error(AuthorizationStmtTest.alterError("functional.alltypes"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER)), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", new TPrivilegeLevel[0])).error(AuthorizationStmtTest.alterError("functional.alltypes"), this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER)), this.onUri("hdfs://localhost:20500/test-warehouse/new_table", new TPrivilegeLevel[0])).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/new_table"), new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/new_table"), new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALTER)});
        }
        this.authorize("alter table nodb.alltypes add columns(c1 int)").error(AuthorizationStmtTest.alterError("nodb"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("nodb"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
        this.authorize("alter table functional.notbl add columns(c1 int)").error(AuthorizationStmtTest.alterError("functional.notbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.notbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.notbl"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterView() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("alter view functional.alltypes_view as select int_col from functional.alltypes"), this.authorize("alter view functional.alltypes_view(a) as select int_col from functional.alltypes")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onServer(TPrivilegeLevel.ALTER), this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL, TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT)}).ok(this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALTER), this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))).error(AuthorizationStmtTest.selectError("functional.alltypes"), this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)), this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALTER));
        }
        this.authorize("alter view functional.alltypes_view rename to functional_parquet.new_view").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onDatabase("functional", TPrivilegeLevel.ALL), this.onDatabase("functional_parquet", TPrivilegeLevel.CREATE)).ok(this.onDatabase("functional_parquet", TPrivilegeLevel.CREATE), this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", TPrivilegeLevel.OWNER), this.onDatabase("functional_parquet", TPrivilegeLevel.CREATE)).ok(this.onDatabase("functional_parquet", TPrivilegeLevel.CREATE), this.onTable("functional", "alltypes_view", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.accessError("functional.alltypes_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))}).error(AuthorizationStmtTest.accessError("functional.alltypes_view"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER)), this.onDatabase("functional_parquet", TPrivilegeLevel.CREATE)).error(AuthorizationStmtTest.createError("functional_parquet"), this.onDatabase("functional", TPrivilegeLevel.ALL), this.onDatabase("functional_parquet", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE))).error(AuthorizationStmtTest.accessError("functional.alltypes_view"), this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))).error(AuthorizationStmtTest.createError("functional_parquet"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.CREATE)), this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALL));
        this.authorize("alter view functional.alltypes_view as select 1").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALTER)}).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[][]{this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
        try {
            this.authzCatalog_.addRole("foo_owner");
            for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("alter view functional.alltypes_view set owner user foo_owner"), this.authorize("alter view functional.alltypes_view set owner role foo_owner")}) {
                test.ok(new TPrivilege[][]{this.onServer(true, TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(true, TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase(true, "functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase(true, "functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable(true, "functional", "alltypes_view", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable(true, "functional", "alltypes_view", TPrivilegeLevel.OWNER)}).error(AuthorizationStmtTest.accessError(true, "functional.alltypes_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError(true, "functional.alltypes_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError(true, "functional.alltypes_view"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError(true, "functional.alltypes_view"), new TPrivilege[][]{this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))});
                test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.values())});
                test.ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.values())});
                test.ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.values())});
            }
        }
        finally {
            this.authzCatalog_.removeRole("foo_owner");
        }
        boolean exceptionThrown = false;
        try {
            this.parseAndAnalyze("alter view functional.alltypes_view set owner role foo_owner", this.authzCtx_, frontend_);
        }
        catch (AnalysisException e) {
            exceptionThrown = true;
            Assert.assertEquals((Object)"Role 'foo_owner' does not exist.", (Object)e.getLocalizedMessage());
        }
        Assert.assertTrue((boolean)exceptionThrown);
        this.authorize("alter view nodb.alltypes_view as select 1").error(AuthorizationStmtTest.alterError("nodb"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("nodb"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
        this.authorize("alter view functional.noview as select 1").error(AuthorizationStmtTest.alterError("functional.noview"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.noview"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.noview"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterDatabase() throws ImpalaException {
        try {
            this.authzCatalog_.addRole("foo");
            for (String ownerType : new String[]{"user", "role"}) {
                this.authorize(String.format("alter database functional set owner %s foo", ownerType)).ok(new TPrivilege[][]{this.onServer(true, TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(true, TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase(true, "functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase(true, "functional", TPrivilegeLevel.OWNER)}).error(AuthorizationStmtTest.accessError(true, "functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError(true, "functional"), new TPrivilege[][]{this.onServer(true, AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError(true, "functional"), new TPrivilege[][]{this.onDatabase(true, "functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))});
                this.authorize(String.format("alter database functional set owner %s foo", ownerType)).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.values())}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.values())});
                this.authorize(String.format("alter database nodb set owner %s foo", ownerType)).error(AuthorizationStmtTest.accessError(true, "nodb"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError(true, "nodb"), new TPrivilege[][]{this.onServer(true, AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))});
            }
        }
        finally {
            this.authzCatalog_.removeRole("foo");
        }
        boolean exceptionThrown = false;
        try {
            this.parseAndAnalyze("alter database functional set owner role foo", this.authzCtx_, frontend_);
        }
        catch (AnalysisException e) {
            exceptionThrown = true;
            Assert.assertEquals((Object)"Role 'foo' does not exist.", (Object)e.getLocalizedMessage());
        }
        Assert.assertTrue((boolean)exceptionThrown);
    }

    @Test
    public void testUpdate() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("update functional_kudu.alltypes set int_col = 1"), this.authorize("explain update functional_kudu.alltypes set int_col = 1")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional_kudu", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional_kudu", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional_kudu", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional_kudu", "alltypes", TPrivilegeLevel.OWNER)}).error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))});
        }
        this.authorize("update nodb.alltypes set int_col = 1").error(AuthorizationStmtTest.selectError("nodb"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("nodb"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        this.authorize("update functional_kudu.notbl set int_col = 1").error(AuthorizationStmtTest.selectError("functional_kudu.notbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional_kudu.notbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional_kudu.notbl"), new TPrivilege[][]{this.onDatabase("functional_kudu", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
    }

    @Test
    public void testUpsert() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("upsert into table functional_kudu.testtbl(id, name) values(1, 'a')"), this.authorize("with t1 as (select 1, 'a', 2) upsert into functional_kudu.testtbl select * from t1"), this.authorize("explain upsert into table functional_kudu.testtbl(id, name) values(1, 'a')")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional_kudu", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional_kudu", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional_kudu", "testtbl", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional_kudu", "testtbl", TPrivilegeLevel.OWNER)}).error(AuthorizationStmtTest.accessError("functional_kudu.testtbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("functional_kudu.testtbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError("functional_kudu.testtbl"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError("functional_kudu.testtbl"), new TPrivilege[][]{this.onTable("functional", "testtbl", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))});
        }
        this.authorize("upsert into table functional_kudu.testtbl(id) select int_col from functional.alltypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onDatabase("functional_kudu", TPrivilegeLevel.ALL), this.onDatabase("functional", TPrivilegeLevel.SELECT)).ok(this.onTable("functional_kudu", "testtbl", TPrivilegeLevel.ALL), this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("functional_kudu.testtbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError("functional_kudu.testtbl"), this.onDatabase("functional_kudu", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER)), this.onDatabase("functional", TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypes"), this.onTable("functional_kudu", "testtbl", TPrivilegeLevel.ALL), this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))).error(AuthorizationStmtTest.accessError("functional_kudu.testtbl"), this.onTable("functional_kudu", "testtbl", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER)), this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT));
        this.authorize("upsert into table nodb.testtbl(id, name) values(1, 'a')").error(AuthorizationStmtTest.accessError("nodb.testtbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("nodb.testtbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))});
        this.authorize("upsert into table functional_kudu.notbl(id, name) values(1, 'a')").error(AuthorizationStmtTest.accessError("functional_kudu.notbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("functional_kudu.notbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError("functional_kudu.notbl"), new TPrivilege[][]{this.onDatabase("functional_kudu", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))});
    }

    @Test
    public void testDelete() throws ImpalaException {
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("delete from functional_kudu.alltypes"), this.authorize("explain delete from functional_kudu.alltypes")}) {
            test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional_kudu", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional_kudu", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional_kudu", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional_kudu", "alltypes", TPrivilegeLevel.OWNER)}).error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))});
        }
        this.authorize("delete from nodb.alltypes").error(AuthorizationStmtTest.selectError("nodb"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("nodb"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
        this.authorize("delete from functional_kudu.notbl").error(AuthorizationStmtTest.selectError("functional_kudu.notbl"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectError("functional_kudu.notbl"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))}).error(AuthorizationStmtTest.selectError("functional_kudu.notbl"), new TPrivilege[][]{this.onDatabase("functional_kudu", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.SELECT))});
    }

    @Test
    public void testCommentOn() throws ImpalaException {
        this.authorize("comment on database functional is 'comment'").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).error(AuthorizationStmtTest.alterError("functional"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
        this.authorize("comment on table functional.alltypes is 'comment'").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALTER)}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
        this.authorize("comment on view functional.alltypes_view is 'comment'").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALTER)}).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[][]{this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
        this.authorize("comment on column functional.alltypes.id is 'comment'").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALTER)}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional", "alltypes", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
        this.authorize("comment on column functional.alltypes_view.id is 'comment'").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.ALTER)}).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[0][]).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))}).error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[][]{this.onTable("functional", "alltypes_view", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.ALTER))});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFunction() throws ImpalaException {
        TQueryOptions options;
        this.authorize("create function functional.f() returns int location '/test-warehouse/libTestUdfs.so' symbol='NoArgs'").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.ALL)).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.OWNER)).ok(this.onDatabase("functional", TPrivilegeLevel.ALL), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", TPrivilegeLevel.OWNER), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.OWNER)).ok(this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.createFunctionError("functional.f()"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/libTestUdfs.so"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.createFunctionError("functional.f()"), new TPrivilege[][]{this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.createFunctionError("functional.f()"), new TPrivilege[][]{this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.OWNER)});
        this.authorize("create function functional.sin() returns int location '/test-warehouse/libTestUdfs.so' symbol='NoArgs'").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.ALL)).ok(this.onServer(TPrivilegeLevel.CREATE), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.OWNER)).ok(this.onDatabase("functional", TPrivilegeLevel.ALL), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", TPrivilegeLevel.OWNER), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.OWNER)).ok(this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.ALL)).ok(this.onDatabase("functional", TPrivilegeLevel.CREATE), this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.OWNER)).error(AuthorizationStmtTest.createFunctionError("functional.sin()"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("hdfs://localhost:20500/test-warehouse/libTestUdfs.so"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER))}).error(AuthorizationStmtTest.createFunctionError("functional.sin()"), new TPrivilege[][]{this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.createFunctionError("functional.sin()"), new TPrivilege[][]{this.onUri("/test-warehouse/libTestUdfs.so", TPrivilegeLevel.OWNER)});
        for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("create function _impala_builtins.sin() returns int location '/test-warehouse/libTestUdfs.so' symbol='NoArgs'"), this.authorize("create function _impala_builtins.f() returns int location '/test-warehouse/libTestUdfs.so' symbol='NoArgs'")}) {
            test.error(AuthorizationStmtTest.systemDbError(), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER)});
        }
        ScalarFunction fn = this.addFunction("functional", "f");
        try {
            this.authorize("drop function functional.f()").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.DROP)}).error(AuthorizationStmtTest.dropFunctionError("functional.f()"), new TPrivilege[0][]).error(AuthorizationStmtTest.dropFunctionError("functional.f()"), new TPrivilege[][]{this.onServer(AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.DROP))});
            this.authorize("drop function if exists functional.g()").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.CREATE)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.INSERT)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.REFRESH)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.DROP)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.CREATE)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.INSERT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALTER)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.REFRESH)}).error(AuthorizationStmtTest.accessFunctionError("functional.g()"), new TPrivilege[0][]);
        }
        finally {
            this.removeFunction(fn);
        }
        ArrayList<Type> argTypes = new ArrayList<Type>();
        argTypes.add((Type)Type.STRING);
        fn = this.addFunction("functional", "to_lower", argTypes, (Type)Type.STRING, "/test-warehouse/libTestUdf.so", "_Z7ToLowerPN10impala_udf15FunctionContextERKNS_9StringValE");
        try {
            options = new TQueryOptions();
            options.setEnable_expr_rewrites(true);
            for (AuthorizationTestBase.AuthzTest test : new AuthorizationTestBase.AuthzTest[]{this.authorize("select functional.to_lower('ABCDEF')"), this.authorize(this.createAnalysisCtx(options, this.authzFactory_, user_.getName()), "select functional.to_lower('ABCDEF')")}) {
                test.ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", this.viewMetadataPrivileges())}).error(AuthorizationStmtTest.selectFunctionError("functional.to_lower"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectFunctionError("functional.to_lower"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[][]{this.onUdf("functional", "to_lower", TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.accessError("functional"), this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges())), this.onUdf("functional", "to_lower", TPrivilegeLevel.SELECT));
            }
        }
        finally {
            this.removeFunction(fn);
        }
        fn = this.addFunction("functional", "f");
        try {
            options = new TQueryOptions();
            options.setFallback_db_for_functions("functional");
            this.authorize(this.createAnalysisCtx(options, this.authzFactory_, user_.getName()), "select f()").ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.OWNER)}).ok(new TPrivilege[][]{this.onDatabase("functional", this.viewMetadataPrivileges())}).ok(new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.SELECT)}).ok(this.onDatabase("functional", TPrivilegeLevel.INSERT), this.onUdf("functional", "f", TPrivilegeLevel.SELECT)).ok(this.onDatabase("functional", TPrivilegeLevel.REFRESH), this.onUdf("functional", "f", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectFunctionError("functional.f"), new TPrivilege[0][]).error(AuthorizationStmtTest.selectFunctionError("functional.f"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))}).error(AuthorizationStmtTest.accessError("functional"), new TPrivilege[][]{this.onUdf("functional", "f", TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.accessError("functional"), this.onUdf("functional", "f", TPrivilegeLevel.SELECT), this.onServer(AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges()))).error(AuthorizationStmtTest.accessError("functional"), this.onUdf("functional", "f", TPrivilegeLevel.SELECT), this.onDatabase("functional", AuthorizationStmtTest.allExcept(this.viewMetadataPrivileges())));
        }
        finally {
            this.removeFunction(fn);
        }
    }

    @Test
    public void testShutdown() throws ImpalaException {
        this.authorize(": shutdown()").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.accessError("server"), new TPrivilege[0][]).error(AuthorizationStmtTest.accessError("server"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.REFRESH)}).error(AuthorizationStmtTest.accessError("server"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.accessError("server"), new TPrivilege[][]{this.onDatabase("functional", TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.accessError("server"), new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)});
    }

    private void createColumnMaskingPolicy(String policyName, String dbName, String tblName, String colName, String user, String maskType, String maskExpr) {
        String json = String.format("{\n  \"name\": \"%s\",\n  \"policyType\": 1,\n  \"serviceType\": \"hive\",\n  \"service\": \"test_impala\",\n  \"resources\": {\n    \"database\": {\n      \"values\": [\"%s\"],\n      \"isExcludes\": false,\n      \"isRecursive\": false\n    },\n    \"table\": {\n      \"values\": [\"%s\"],\n      \"isExcludes\": false,\n      \"isRecursive\": false\n    },\n    \"column\": {\n      \"values\": [\"%s\"],\n      \"isExcludes\": false,\n      \"isRecursive\": false\n    }\n  },\n  \"dataMaskPolicyItems\": [\n    {\n      \"accesses\": [\n        {\n          \"type\": \"select\",\n          \"isAllowed\": true\n        }\n      ],\n      \"users\": [\"%s\"],\n      \"dataMaskInfo\": {\n        \"dataMaskType\": \"%s\"\n        %s\n      }\n    }\n  ]\n}", policyName, dbName, tblName, colName, user, maskType, maskExpr == null ? "" : String.format(", \"valueExpr\": \"%s\"", maskExpr));
        this.createRangerPolicy(policyName, json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testColumnMaskDisabled() throws ImpalaException {
        String policyName = "col_mask";
        for (String tableName : new String[]{"alltypes", "alltypes_view"}) {
            BackendConfig.INSTANCE.setColumnMaskingEnabled(false);
            BackendConfig.INSTANCE.setRowFilteringEnabled(false);
            try {
                this.createColumnMaskingPolicy(policyName, "functional", tableName, "string_col", user_.getShortName(), "MASK", null);
                this.rangerImpalaPlugin_.refreshPoliciesAndTags();
                this.authorize("select id from functional.alltypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize("select x from functional.alltypes_view_sub").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize("select string_col from functional_kudu.alltypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("select string_col from functional.%s", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("select substr(string_col, 0, 1) from functional.%s", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("select * from functional.%s", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("select t.string_col from (select * from functional.%s) t", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("with t as (select * from functional.%s) select string_col from t", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("create table t as select * from functional.%s", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("create view v as select * from functional.%s", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("alter view functional.alltypes_view_sub as select * from functional.%s", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("select string_col from functional.%s union select 'hello'", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("update functional_kudu.alltypes set int_col = 1 where string_col in (select string_col from functional.%s)", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("delete functional_kudu.alltypes where string_col in (select string_col from functional.%s)", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("copy testcase to '/tmp' select * from functional.%s", tableName)).error(AuthorizationStmtTest.columnMaskError(String.format("functional.%s.string_col", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            }
            finally {
                this.deleteRangerPolicy(policyName);
                BackendConfig.INSTANCE.setColumnMaskingEnabled(true);
                BackendConfig.INSTANCE.setRowFilteringEnabled(true);
            }
        }
    }

    private void createRowFilteringPolicy(String policyName, String dbName, String tblName, String user, String rowFilter) {
        String json = String.format("{\n  \"name\": \"%s\",\n  \"policyType\": 2,\n  \"serviceType\": \"hive\",\n  \"service\": \"test_impala\",\n  \"resources\": {\n    \"database\": {\n      \"values\": [\"%s\"],\n      \"isExcludes\": false,\n      \"isRecursive\": false\n    },\n    \"table\": {\n      \"values\": [\"%s\"],\n      \"isExcludes\": false,\n      \"isRecursive\": false\n    }\n  },\n  \"rowFilterPolicyItems\": [\n    {\n      \"accesses\": [\n        {\n          \"type\": \"select\",\n          \"isAllowed\": true\n        }\n      ],\n      \"users\": [\"%s\"],\n      \"rowFilterInfo\": {\"filterExpr\": \"%s\"}\n    }\n  ]\n}", policyName, dbName, tblName, user, rowFilter);
        this.createRangerPolicy(policyName, json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowFilterDisabled() throws ImpalaException {
        String policyName = "row_filter";
        for (String tableName : new String[]{"alltypes", "alltypes_view"}) {
            BackendConfig.INSTANCE.setRowFilteringEnabled(false);
            try {
                this.createRowFilteringPolicy(policyName, "functional", tableName, user_.getShortName(), "id = 0");
                this.rangerImpalaPlugin_.refreshPoliciesAndTags();
                this.authorize("select string_col from functional_kudu.alltypes").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize("select x from functional.alltypes_view_sub").ok(new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("select string_col from functional.%s", tableName)).error(AuthorizationStmtTest.rowFilterError(String.format("functional.%s", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("select * from functional.%s", tableName)).error(AuthorizationStmtTest.rowFilterError(String.format("functional.%s", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("select t.string_col from (select * from functional.%s) t", tableName)).error(AuthorizationStmtTest.rowFilterError(String.format("functional.%s", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("with t as (select * from functional.%s) select string_col from t", tableName)).error(AuthorizationStmtTest.rowFilterError(String.format("functional.%s", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("create table t as select * from functional.%s", tableName)).error(AuthorizationStmtTest.rowFilterError(String.format("functional.%s", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("create view v as select * from functional.%s", tableName)).error(AuthorizationStmtTest.rowFilterError(String.format("functional.%s", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("alter view functional.alltypes_view_sub as select * from functional.%s", tableName)).error(AuthorizationStmtTest.rowFilterError(String.format("functional.%s", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("select string_col from functional.%s union select 'hello'", tableName)).error(AuthorizationStmtTest.rowFilterError(String.format("functional.%s", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("update functional_kudu.alltypes set int_col = 1 where string_col in (select string_col from functional.%s)", tableName)).error(AuthorizationStmtTest.rowFilterError(String.format("functional.%s", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("delete functional_kudu.alltypes where string_col in (select string_col from functional.%s)", tableName)).error(AuthorizationStmtTest.rowFilterError(String.format("functional.%s", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
                this.authorize(String.format("copy testcase to '/tmp' select * from functional.%s", tableName)).error(AuthorizationStmtTest.rowFilterError(String.format("functional.%s", tableName)), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            }
            finally {
                this.deleteRangerPolicy(policyName);
                BackendConfig.INSTANCE.setRowFilteringEnabled(true);
            }
        }
    }

    @Test
    public void testUpdateOnMaskedTables() throws Exception {
        try {
            this.createRowFilteringPolicy("alltypes_row_filter", "functional", "alltypes", user_.getShortName(), "id = 0");
            this.createRowFilteringPolicy("alltypes_view_row_filter", "functional", "alltypes_view", user_.getShortName(), "id = 0");
            this.createColumnMaskingPolicy("alltypestiny_id_mask", "functional", "alltypestiny", "id", user_.getShortName(), "CUSTOM", "id + 100");
            this.createColumnMaskingPolicy("kudu_id_mask", "functional_kudu", "alltypes", "id", user_.getShortName(), "MASK_NULL", null);
            this.createColumnMaskingPolicy("alltypessmall_id_unmask", "functional", "alltypessmall", "id", user_.getShortName(), "MASK_NONE", null);
            this.createColumnMaskingPolicy("alltypes_sint_mask", "functional_orc_def", "alltypes", "smallint_col", user_.getShortName(), "MASK_NULL", null);
            this.createColumnMaskingPolicy("mv1_alltypes_jointbl_c2_mask", "functional_orc_def", "mv1_alltypes_jointbl", "c2", user_.getShortName(), "MASK_NULL", null);
            this.rangerImpalaPlugin_.refreshPoliciesAndTags();
            this.authorize("select * from functional.alltypes").ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)});
            this.authorize("select * from functional.alltypes_view").ok(new TPrivilege[][]{this.onTable("functional", "alltypes_view", TPrivilegeLevel.SELECT)});
            this.authorize("select * from functional.alltypestiny").ok(new TPrivilege[][]{this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)});
            this.authorize("select * from functional_orc_def.mv1_alltypes_jointbl").error(AuthorizationStmtTest.mvSelectError("functional_orc_def.mv1_alltypes_jointbl"), new TPrivilege[][]{this.onTable("functional_orc_def", "mv1_alltypes_jointbl", TPrivilegeLevel.SELECT)});
            this.authorize("select c3 from functional_orc_def.mv1_alltypes_jointbl").error(AuthorizationStmtTest.mvSelectError("functional_orc_def.mv1_alltypes_jointbl"), new TPrivilege[][]{this.onTable("functional_orc_def", "mv1_alltypes_jointbl", TPrivilegeLevel.SELECT)});
            this.authorize("insert into functional.alltypes partition(year, month) select * from functional.alltypestiny").error(AuthorizationStmtTest.insertError("functional.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.selectError("functional.alltypestiny"), new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.selectError("functional.alltypestiny"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))});
            this.authorize("truncate table functional.alltypes").error(AuthorizationStmtTest.insertError("functional.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("insert into functional.alltypestiny partition(year, month) select * from functional.alltypessmall").error(AuthorizationStmtTest.insertError("functional.alltypestiny"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.selectError("functional.alltypessmall"), new TPrivilege[][]{this.onTable("functional", "alltypestiny", TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.selectError("functional.alltypessmall"), new TPrivilege[][]{this.onDatabase("functional", AuthorizationStmtTest.allExcept(TPrivilegeLevel.ALL, TPrivilegeLevel.OWNER, TPrivilegeLevel.INSERT, TPrivilegeLevel.SELECT))});
            this.authorize("truncate table functional.alltypestiny").error(AuthorizationStmtTest.insertError("functional.alltypestiny"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("upsert into functional_kudu.alltypes select * from functional.alltypes").error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onTable("functional_kudu", "alltypes", TPrivilegeLevel.ALL)});
            this.authorize("delete from functional_kudu.alltypes").error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("delete from functional_kudu.alltypes").error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("delete from functional_kudu.alltypes where id is not null").error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("delete a from functional_kudu.alltypes a join functional.alltypes b on a.id = b.id").error(AuthorizationStmtTest.accessError("functional_kudu.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("compute stats functional.alltypes").error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("compute incremental stats functional.alltypes").error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("alter table functional.alltypes add columns (new_id int)").error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("alter table functional.alltypes drop partition (year=2009, month=1)").error(AuthorizationStmtTest.alterError("functional.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("alter view functional.alltypes_view as select 1").error(AuthorizationStmtTest.alterError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("alter table functional.alltypestiny add partition (year=1, month=1)").error(AuthorizationStmtTest.alterError("functional.alltypestiny"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("drop table functional.alltypes").error(AuthorizationStmtTest.dropError("functional.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("drop view functional.alltypes_view").error(AuthorizationStmtTest.dropError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("drop table functional.alltypestiny").error(AuthorizationStmtTest.dropError("functional.alltypestiny"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("drop table functional_kudu.alltypes").error(AuthorizationStmtTest.dropError("functional_kudu.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("refresh functional.alltypes").error(AuthorizationStmtTest.refreshError("functional.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("refresh functional.alltypes_view").error(AuthorizationStmtTest.refreshError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("refresh functional.alltypestiny").error(AuthorizationStmtTest.refreshError("functional.alltypestiny"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("invalidate metadata functional.alltypes").error(AuthorizationStmtTest.refreshError("functional.alltypes"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("invalidate metadata functional.alltypes_view").error(AuthorizationStmtTest.refreshError("functional.alltypes_view"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("invalidate metadata functional.alltypestiny").error(AuthorizationStmtTest.refreshError("functional.alltypestiny"), new TPrivilege[][]{this.onServer(TPrivilegeLevel.ALL)});
            this.authorize("insert into functional.alltypessmall partition(year, month) select * from functional.alltypestiny").ok(this.onTable("functional", "alltypessmall", TPrivilegeLevel.INSERT), this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT));
            this.authorize("alter table functional.alltypessmall add partition (year=1, month=1)").ok(new TPrivilege[][]{this.onTable("functional", "alltypessmall", TPrivilegeLevel.ALTER)});
            this.authorize("compute stats functional.alltypessmall").ok(new TPrivilege[][]{this.onTable("functional", "alltypessmall", TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT)});
            this.authorize("compute incremental stats functional.alltypessmall").ok(new TPrivilege[][]{this.onTable("functional", "alltypessmall", TPrivilegeLevel.ALTER, TPrivilegeLevel.SELECT)});
            this.authorize("drop table functional.alltypessmall").ok(new TPrivilege[][]{this.onTable("functional", "alltypessmall", TPrivilegeLevel.DROP)});
            this.authorize("refresh functional.alltypessmall").ok(new TPrivilege[][]{this.onTable("functional", "alltypessmall", TPrivilegeLevel.REFRESH)});
            this.authorize("invalidate metadata functional.alltypessmall").ok(new TPrivilege[][]{this.onTable("functional", "alltypessmall", TPrivilegeLevel.REFRESH)});
        }
        finally {
            this.deleteRangerPolicy("alltypes_row_filter");
            this.deleteRangerPolicy("alltypes_view_row_filter");
            this.deleteRangerPolicy("alltypestiny_id_mask");
            this.deleteRangerPolicy("kudu_id_mask");
            this.deleteRangerPolicy("alltypessmall_id_unmask");
            this.deleteRangerPolicy("alltypes_sint_mask");
            this.deleteRangerPolicy("mv1_alltypes_jointbl_c2_mask");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrivInMaskingExprs() throws Exception {
        try {
            String[] queries;
            this.createRowFilteringPolicy("alltypes_subquery_filter", "functional", "alltypes", user_.getShortName(), "id in (select id from functional.alltypestiny)");
            for (String q : queries = new String[]{"select * from functional.alltypes", "select id from functional.alltypes", "select int_col from functional.alltypes"}) {
                this.authorize(q).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT), this.onTable("functional", "alltypestiny", TPrivilegeLevel.SELECT)).ok(this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypestiny", "id", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypestiny"), new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.alltypestiny"), this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypestiny", "int_col", TPrivilegeLevel.SELECT));
            }
        }
        finally {
            this.deleteRangerPolicy("alltypes_subquery_filter");
        }
        try {
            this.createColumnMaskingPolicy("alltypes_replace_id", "functional", "alltypes", "id", user_.getShortName(), "CUSTOM", "int_col");
            this.createColumnMaskingPolicy("alltypes_nullify_str", "functional", "alltypes", "string_col", user_.getShortName(), "MASK_NULL", null);
            this.authorize("select id from functional.alltypes").ok(new TPrivilege[][]{this.onTable("functional", "alltypes", TPrivilegeLevel.SELECT)}).ok(this.onColumn("functional", "alltypes", "id", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "int_col", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onColumn("functional", "alltypes", "id", TPrivilegeLevel.SELECT)}).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onColumn("functional", "alltypes", "int_col", TPrivilegeLevel.SELECT)});
            this.authorize("select bool_col, string_col from functional.alltypes").ok(this.onColumn("functional", "alltypes", "bool_col", TPrivilegeLevel.SELECT), this.onColumn("functional", "alltypes", "string_col", TPrivilegeLevel.SELECT)).error(AuthorizationStmtTest.selectError("functional.alltypes"), new TPrivilege[][]{this.onColumn("functional", "alltypes", "bool_col", TPrivilegeLevel.SELECT)});
        }
        finally {
            this.deleteRangerPolicy("alltypes_replace_id");
            this.deleteRangerPolicy("alltypes_nullify_str");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRangerObjectOwnership() throws Exception {
        as_owner_ = true;
        TQueryOptions options = new TQueryOptions();
        ImmutableSet testQueries = ImmutableSet.builder().add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "select count(*) from functional.alltypes")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "select id from functional.alltypes")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "select id from functional.alltypes_view")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "show create table functional.alltypes")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "describe functional.alltypes")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "show create table functional.alltypes_view")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "describe functional.alltypes_view")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "describe functional.allcomplextypes.int_struct_col")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "refresh functional.alltypes")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "invalidate metadata functional.alltypes")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "compute stats functional.alltypes")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "drop stats functional.alltypes")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "create table functional.test_tbl(a int)")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "create table functional.test_tbl like functional.alltypes")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "create table functional.test_tbl as select 1")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "create view functional.test_view as select 1")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "alter table functional.alltypes add column c1 int")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "drop table functional.alltypes")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "drop view functional.alltypes_view")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "alter view functional.alltypes_view as select 1")).add((Object)this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "alter database functional set owner user foo")).build();
        for (AuthorizationTestBase.AuthzTest authz : testQueries) {
            authz.ok(new TPrivilege[0][]);
        }
        this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "select count(*) from functional.alltypes").ok(new TPrivilege[0][]);
        this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "select count(*) from functional.alltypes_view").ok(new TPrivilege[0][]);
        try {
            this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "select count(*) from functional.alltypes").ok(new TPrivilege[0][]);
            this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "alter table functional.alltypes add column c1 int").ok(new TPrivilege[0][]);
            this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "drop table functional.alltypes").ok(new TPrivilege[0][]);
            this.authorize(this.createAnalysisCtx(options, this.authzFactory_, OWNER_USER.getName()), "select count(*) from functional.alltypes_view").ok(new TPrivilege[0][]);
        }
        finally {
            as_owner_ = false;
        }
    }

    private void createOwnerPolicy(String policyName, String privilege, String db, String tbl, String col) throws Exception {
        String createOwnerPolicyTemplate = "{\n    \"isAuditEnabled\": true,\n    \"isDenyAllElse\": false,\n    \"isEnabled\": true,\n    \"name\": \"%s\",\n    \"policyItems\": [\n        {\n            \"accesses\": [\n                {\n                    \"isAllowed\": true,\n                    \"type\": \"%s\"\n                }\n            ],\n            \"delegateAdmin\": false,\n            \"users\": [\n                \"{OWNER}\"\n            ]\n        }\n    ],\n    \"policyPriority\": 0,\n    \"policyType\": 0,\n    \"resources\": {\n        \"column\": {\n            \"isExcludes\": false,\n            \"isRecursive\": false,\n           \"values\": [\n               \"%s\"\n           ]\n        },\n        \"database\": {\n            \"isExcludes\": false,\n            \"isRecursive\": false,\n            \"values\": [\n                \"%s\"\n            ]\n        },\n        \"table\": {\n            \"isExcludes\": false,\n            \"isRecursive\": false,\n            \"values\": [\n                \"%s\"\n            ]\n        }\n    },\n    \"service\": \"%s\",\n    \"serviceType\": \"%s\"\n}";
        String policyRequest = String.format("{\n    \"isAuditEnabled\": true,\n    \"isDenyAllElse\": false,\n    \"isEnabled\": true,\n    \"name\": \"%s\",\n    \"policyItems\": [\n        {\n            \"accesses\": [\n                {\n                    \"isAllowed\": true,\n                    \"type\": \"%s\"\n                }\n            ],\n            \"delegateAdmin\": false,\n            \"users\": [\n                \"{OWNER}\"\n            ]\n        }\n    ],\n    \"policyPriority\": 0,\n    \"policyType\": 0,\n    \"resources\": {\n        \"column\": {\n            \"isExcludes\": false,\n            \"isRecursive\": false,\n           \"values\": [\n               \"%s\"\n           ]\n        },\n        \"database\": {\n            \"isExcludes\": false,\n            \"isRecursive\": false,\n            \"values\": [\n                \"%s\"\n            ]\n        },\n        \"table\": {\n            \"isExcludes\": false,\n            \"isRecursive\": false,\n            \"values\": [\n                \"%s\"\n            ]\n        }\n    },\n    \"service\": \"%s\",\n    \"serviceType\": \"%s\"\n}", policyName, privilege, col, db, tbl, "test_impala", "hive");
        try {
            this.createRangerPolicy(policyName, policyRequest);
        }
        catch (RuntimeException e) {
            if (!e.getMessage().contains("Another policy already exists")) {
                throw e;
            }
            LOG.info("Another policy exists for the given resource, deleting it", (Throwable)e);
            Pattern pattern = Pattern.compile("policy-name=\\[(.*?)\\]");
            Matcher m = pattern.matcher(e.getMessage());
            Assert.assertTrue((boolean)m.find());
            LOG.info("Deleting policy: " + m.group(1));
            this.deleteRangerPolicy(m.group(1));
            this.createRangerPolicy(policyName, policyRequest);
        }
    }

    private void verifyPrivilegeReqs(String stmt, Set<String> expectedPrivilegeNames) throws ImpalaException {
        this.verifyPrivilegeReqs(this.createAnalysisCtx(this.authzFactory_), stmt, expectedPrivilegeNames);
    }

    private void verifyPrivilegeReqs(AnalysisContext ctx, String stmt, Set<String> expectedPrivilegeNames) throws ImpalaException {
        AnalysisContext.AnalysisResult analysisResult = this.parseAndAnalyze(stmt, ctx, frontend_);
        HashSet<String> actualPrivilegeNames = new HashSet<String>();
        for (PrivilegeRequest privReq : analysisResult.getAnalyzer().getPrivilegeReqs()) {
            actualPrivilegeNames.add(privReq.getName());
        }
        Assert.assertEquals(expectedPrivilegeNames, actualPrivilegeNames);
    }
}

