/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.impala.analysis.FunctionName;
import org.apache.impala.analysis.HdfsUri;
import org.apache.impala.analysis.ToSqlUtils;
import org.apache.impala.catalog.AggregateFunction;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.FeView;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.ScalarFunction;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.thrift.TFunctionBinaryType;
import org.junit.Assert;
import org.junit.Test;

public class ToSqlUtilsTest
extends FrontendTestBase {
    @Test
    public void testRemoveHiddenProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        for (String kw : ToSqlUtils.HIDDEN_TABLE_PROPERTIES) {
            props.put(kw, kw + "-value");
        }
        props.put("foo", "foo-value");
        ToSqlUtils.removeHiddenTableProperties(props);
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertEquals((Object)"foo-value", props.get("foo"));
    }

    @Test
    public void testRemoveHiddenKuduProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("kudu.table_name", "kudu-value");
        props.put("foo", "foo-value");
        ToSqlUtils.removeHiddenKuduTableProperties(props);
        Assert.assertEquals((long)1L, (long)props.size());
        Assert.assertEquals((Object)"foo-value", props.get("foo"));
    }

    @Test
    public void testGetSortColumns() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "foo-value");
        Assert.assertNull((Object)ToSqlUtils.getSortColumns(props));
        props.put("sort.columns", "");
        List sortCols = ToSqlUtils.getSortColumns(props);
        Assert.assertTrue((boolean)sortCols.isEmpty());
        props.put("sort.columns", "col1");
        sortCols = ToSqlUtils.getSortColumns(props);
        Assert.assertEquals((long)1L, (long)sortCols.size());
        Assert.assertEquals((Object)"col1", sortCols.get(0));
        props.put("sort.columns", " col1 ");
        sortCols = ToSqlUtils.getSortColumns(props);
        Assert.assertEquals((long)1L, (long)sortCols.size());
        Assert.assertEquals((Object)"col1", sortCols.get(0));
        props.put("sort.columns", " col 1 ");
        sortCols = ToSqlUtils.getSortColumns(props);
        Assert.assertEquals((long)1L, (long)sortCols.size());
        Assert.assertEquals((Object)"col 1", sortCols.get(0));
        props.put("sort.columns", ",col1,");
        sortCols = ToSqlUtils.getSortColumns(props);
        Assert.assertEquals((long)1L, (long)sortCols.size());
        Assert.assertEquals((Object)"col1", sortCols.get(0));
        props.put("sort.columns", " , col1 , ");
        sortCols = ToSqlUtils.getSortColumns(props);
        Assert.assertEquals((long)1L, (long)sortCols.size());
        Assert.assertEquals((Object)"col1", sortCols.get(0));
        props.put("sort.columns", "col1,col2");
        sortCols = ToSqlUtils.getSortColumns(props);
        Assert.assertEquals((long)2L, (long)sortCols.size());
        Assert.assertEquals((Object)"col1", sortCols.get(0));
        Assert.assertEquals((Object)"col2", sortCols.get(1));
        props.put("sort.columns", " col1 ,, col2 ");
        sortCols = ToSqlUtils.getSortColumns(props);
        Assert.assertEquals((long)2L, (long)sortCols.size());
        Assert.assertEquals((Object)"col1", sortCols.get(0));
        Assert.assertEquals((Object)"col2", sortCols.get(1));
        props.put("sort.columns", "col1,col2,col3");
        sortCols = ToSqlUtils.getSortColumns(props);
        Assert.assertEquals((long)3L, (long)sortCols.size());
        Assert.assertEquals((Object)"col1", sortCols.get(0));
        Assert.assertEquals((Object)"col2", sortCols.get(1));
        Assert.assertEquals((Object)"col3", sortCols.get(2));
    }

    @Test
    public void testSortOrder() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("foo", "foo-value");
        Assert.assertEquals((Object)"LEXICAL", (Object)ToSqlUtils.getSortingOrder(props));
        props.put("sort.order", "ZORDER");
        Assert.assertEquals((Object)"ZORDER", (Object)ToSqlUtils.getSortingOrder(props));
        props.put("sort.order", "LEXICAL");
        Assert.assertEquals((Object)"LEXICAL", (Object)ToSqlUtils.getSortingOrder(props));
    }

    private FeTable getTable(String dbName, String tableName) {
        Table table = catalog_.getOrLoadTable(dbName, tableName);
        Assert.assertNotNull((Object)table);
        return table;
    }

    private FeView getView(String dbName, String tableName) {
        FeTable table = this.getTable(dbName, tableName);
        Assert.assertTrue((boolean)(table instanceof FeView));
        return (FeView)table;
    }

    @Test
    public void testHiveNeedsQuotes() {
        Assert.assertFalse((boolean)ToSqlUtils.hiveNeedsQuotes((String)"foo"));
        Assert.assertTrue((boolean)ToSqlUtils.hiveNeedsQuotes((String)"+"));
        Assert.assertTrue((boolean)ToSqlUtils.hiveNeedsQuotes((String)"SELECT"));
        Assert.assertTrue((boolean)ToSqlUtils.hiveNeedsQuotes((String)"select"));
        Assert.assertTrue((boolean)ToSqlUtils.hiveNeedsQuotes((String)"sElEcT"));
        Assert.assertTrue((boolean)ToSqlUtils.hiveNeedsQuotes((String)"foo bar"));
        Assert.assertTrue((boolean)ToSqlUtils.hiveNeedsQuotes((String)"a+b"));
        Assert.assertFalse((boolean)ToSqlUtils.hiveNeedsQuotes((String)"123ab"));
        Assert.assertTrue((boolean)ToSqlUtils.hiveNeedsQuotes((String)"123.a"));
    }

    @Test
    public void testImpalaNeedsQuotes() {
        Assert.assertFalse((boolean)ToSqlUtils.impalaNeedsQuotes((String)"foo"));
        Assert.assertTrue((boolean)ToSqlUtils.impalaNeedsQuotes((String)"SELECT"));
        Assert.assertTrue((boolean)ToSqlUtils.impalaNeedsQuotes((String)"select"));
        Assert.assertTrue((boolean)ToSqlUtils.impalaNeedsQuotes((String)"sElEcT"));
        Assert.assertTrue((boolean)ToSqlUtils.impalaNeedsQuotes((String)"123"));
        Assert.assertTrue((boolean)ToSqlUtils.impalaNeedsQuotes((String)"123a"));
        Assert.assertFalse((boolean)ToSqlUtils.impalaNeedsQuotes((String)"a123"));
    }

    @Test
    public void testGetIdentSql() {
        Assert.assertEquals((Object)"`create`", (Object)ToSqlUtils.getIdentSql((String)"create"));
        Assert.assertEquals((Object)"`month`", (Object)ToSqlUtils.getIdentSql((String)"month"));
        Assert.assertEquals((Object)"`kudu`", (Object)ToSqlUtils.getIdentSql((String)"kudu"));
        Assert.assertEquals((Object)"`123`", (Object)ToSqlUtils.getIdentSql((String)"123"));
        Assert.assertEquals((Object)"`123a`", (Object)ToSqlUtils.getIdentSql((String)"123a"));
        Assert.assertEquals((Object)"`a b`", (Object)ToSqlUtils.getIdentSql((String)"a b"));
        Assert.assertEquals((Object)"`+`", (Object)ToSqlUtils.getIdentSql((String)"+"));
        Assert.assertEquals((Object)"foo", (Object)ToSqlUtils.getIdentSql((String)"foo"));
        Assert.assertEquals((Object)"`foo#`", (Object)ToSqlUtils.getIdentSql((String)"foo#"));
        Assert.assertEquals((Object)"`foo#bar`", (Object)ToSqlUtils.getIdentSql((String)"foo#bar"));
        Assert.assertEquals((Object)"`foo--bar`", (Object)ToSqlUtils.getIdentSql((String)"foo--bar"));
        ArrayList in = Lists.newArrayList((Object[])new String[]{"create", "foo"});
        List out = ToSqlUtils.getIdentSqlList((List)in);
        Assert.assertEquals((long)2L, (long)out.size());
        Assert.assertEquals((Object)"`create`", out.get(0));
        Assert.assertEquals((Object)"foo", out.get(1));
        Assert.assertEquals((Object)"`create`.foo", (Object)ToSqlUtils.getPathSql((List)in));
    }

    @Test
    public void tesToIdentSql() {
        Assert.assertEquals((Object)"`create`", (Object)ToSqlUtils.identSql((String)"create"));
        Assert.assertEquals((Object)"foo", (Object)ToSqlUtils.identSql((String)"foo"));
        Assert.assertEquals((Object)"*", (Object)ToSqlUtils.identSql((String)"*"));
        Assert.assertEquals((Object)"foo.`create`.*", (Object)ToSqlUtils.identSql((String)"foo.create.*"));
    }

    @Test
    public void testCreateViewSql() {
        FeView view = this.getView("functional", "view_view");
        String sql = ToSqlUtils.getCreateViewSql((FeView)view);
        String expected = "CREATE VIEW functional.view_view AS\nSELECT * FROM functional.alltypes_view";
        Assert.assertEquals((Object)expected, (Object)sql);
        view = this.getView("functional", "complex_view");
        sql = ToSqlUtils.getCreateViewSql((FeView)view);
        expected = "CREATE VIEW functional.complex_view AS\nSELECT complex_view.`_c0` abc, complex_view.string_col xyz FROM (SELECT count(a.bigint_col), b.string_col FROM functional.alltypesagg a INNER JOIN functional.alltypestiny b ON a.id = b.id WHERE a.bigint_col < 50 GROUP BY b.string_col HAVING count(a.bigint_col) > 1 ORDER BY b.string_col ASC LIMIT 100) complex_view";
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void testScalarFunctionSql() {
        ArrayList args = new ArrayList();
        Function fn = Function.createFunction((String)"mydb", (String)"fn1", args, (Type)Type.INT, (boolean)false, (TFunctionBinaryType)TFunctionBinaryType.JAVA);
        try {
            ToSqlUtils.getCreateFunctionSql((List)Lists.newArrayList((Object[])new Function[]{fn}));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        args = new ArrayList();
        fn = new ScalarFunction(new FunctionName("mydb", "fn1"), args, (Type)Type.INT, false);
        fn.setBinaryType(TFunctionBinaryType.JAVA);
        String sql = ToSqlUtils.getCreateFunctionSql((List)Lists.newArrayList((Object[])new Function[]{fn}));
        String expected = "CREATE FUNCTION mydb.fn1\n";
        Assert.assertEquals((Object)expected, (Object)sql);
        args = new ArrayList();
        fn = new ScalarFunction(new FunctionName("mydb", "fn1"), args, (Type)Type.INT, false);
        fn.setBinaryType(TFunctionBinaryType.JAVA);
        fn.setLocation(new HdfsUri("hdfs://foo:123/fns/myfunc.jar"));
        fn.setSymbolName("MyClass");
        sql = ToSqlUtils.getCreateFunctionSql((List)Lists.newArrayList((Object[])new Function[]{fn}));
        expected = "CREATE FUNCTION mydb.fn1\n LOCATION 'hdfs://foo:123/fns/myfunc.jar'\n SYMBOL='MyClass'\n";
        Assert.assertEquals((Object)expected, (Object)sql);
        args = Lists.newArrayList((Object[])new Type[]{Type.VARCHAR, Type.BOOLEAN});
        fn = new ScalarFunction(new FunctionName("mydb", "fn1"), (List)args, (Type)Type.INT, false);
        fn.setBinaryType(TFunctionBinaryType.JAVA);
        fn.setLocation(new HdfsUri("hdfs://foo:123/fns/myfunc.jar"));
        fn.setSymbolName("MyClass");
        sql = ToSqlUtils.getCreateFunctionSql((List)Lists.newArrayList((Object[])new Function[]{fn}));
        expected = "CREATE FUNCTION mydb.fn1\n LOCATION 'hdfs://foo:123/fns/myfunc.jar'\n SYMBOL='MyClass'\n";
        Assert.assertEquals((Object)expected, (Object)sql);
        args = new ArrayList();
        fn = new ScalarFunction(new FunctionName("mydb", "fn1"), args, (Type)Type.INT, false);
        fn.setBinaryType(TFunctionBinaryType.NATIVE);
        fn.setLocation(new HdfsUri("hdfs://foo:123/fns/myfunc.so"));
        fn.setSymbolName("myClass");
        sql = ToSqlUtils.getCreateFunctionSql((List)Lists.newArrayList((Object[])new Function[]{fn}));
        expected = "CREATE FUNCTION mydb.fn1()\n RETURNS INT\n LOCATION 'hdfs://foo:123/fns/myfunc.so'\n SYMBOL='myClass'\n";
        Assert.assertEquals((Object)expected, (Object)sql);
        args = Lists.newArrayList((Object[])new Type[]{Type.VARCHAR, Type.BOOLEAN});
        fn = new ScalarFunction(new FunctionName("mydb", "fn1"), (List)args, (Type)Type.INT, false);
        fn.setBinaryType(TFunctionBinaryType.NATIVE);
        fn.setLocation(new HdfsUri("hdfs://foo:123/fns/myfunc.so"));
        fn.setSymbolName("myClass");
        sql = ToSqlUtils.getCreateFunctionSql((List)Lists.newArrayList((Object[])new Function[]{fn}));
        expected = "CREATE FUNCTION mydb.fn1(VARCHAR(*), BOOLEAN)\n RETURNS INT\n LOCATION 'hdfs://foo:123/fns/myfunc.so'\n SYMBOL='myClass'\n";
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void testAggFnSql() {
        ArrayList args = Lists.newArrayList((Object[])new Type[]{Type.INT, Type.BOOLEAN});
        AggregateFunction fn = new AggregateFunction(new FunctionName("mydb", "fn1"), (List)args, (Type)Type.BIGINT, false);
        fn.setBinaryType(TFunctionBinaryType.NATIVE);
        fn.setLocation(new HdfsUri("hdfs://foo:123/fns/myfunc.so"));
        fn.setUpdateFnSymbol("Update");
        fn.setInitFnSymbol("Init");
        fn.setMergeFnSymbol("Merge");
        String sql = ToSqlUtils.getCreateFunctionSql((List)Lists.newArrayList((Object[])new Function[]{fn}));
        String expected = "CREATE AGGREGATE FUNCTION mydb.fn1(INT, BOOLEAN)\n RETURNS BIGINT\n LOCATION 'hdfs://foo:123/fns/myfunc.so'\n UPDATE_FN='Update'\n INIT_FN='Init'\n MERGE_FN='Merge'\n";
        Assert.assertEquals((Object)expected, (Object)sql);
        args = Lists.newArrayList((Object[])new Type[]{Type.INT, Type.BOOLEAN});
        fn = new AggregateFunction(new FunctionName("mydb", "fn1"), (List)args, (Type)Type.BIGINT, false);
        fn.setBinaryType(TFunctionBinaryType.NATIVE);
        fn.setLocation(new HdfsUri("hdfs://foo:123/fns/myfunc.so"));
        fn.setUpdateFnSymbol("Update");
        fn.setInitFnSymbol("Init");
        fn.setMergeFnSymbol("Merge");
        fn.setFinalizeFnSymbol("Finalize");
        fn.setSerializeFnSymbol("Serialize");
        fn.setIntermediateType((Type)Type.INT);
        sql = ToSqlUtils.getCreateFunctionSql((List)Lists.newArrayList((Object[])new Function[]{fn}));
        expected = "CREATE AGGREGATE FUNCTION mydb.fn1(INT, BOOLEAN)\n RETURNS BIGINT\n INTERMEDIATE INT\n LOCATION 'hdfs://foo:123/fns/myfunc.so'\n UPDATE_FN='Update'\n INIT_FN='Init'\n MERGE_FN='Merge'\n SERIALIZE_FN='Serialize'\n FINALIZE_FN='Finalize'\n";
        Assert.assertEquals((Object)expected, (Object)sql);
    }

    @Test
    public void testCreateFunctionSql() {
        ScalarFunction fn1 = new ScalarFunction(new FunctionName("mydb", "fn1"), new ArrayList(), (Type)Type.INT, false);
        fn1.setBinaryType(TFunctionBinaryType.JAVA);
        fn1.setLocation(new HdfsUri("hdfs://foo:123/fns/myfunc.jar"));
        fn1.setSymbolName("MyClass");
        ArrayList args = Lists.newArrayList((Object[])new Type[]{Type.VARCHAR, Type.BOOLEAN});
        ScalarFunction fn2 = new ScalarFunction(new FunctionName("mydb", "fn2"), (List)args, (Type)Type.INT, false);
        fn2.setBinaryType(TFunctionBinaryType.NATIVE);
        fn2.setLocation(new HdfsUri("hdfs://foo:123/fns/myfunc.so"));
        fn2.setSymbolName("myClass");
        String sql = ToSqlUtils.getCreateFunctionSql((List)Lists.newArrayList((Object[])new Function[]{fn1, fn2}));
        String expected = "CREATE FUNCTION mydb.fn1\n LOCATION 'hdfs://foo:123/fns/myfunc.jar'\n SYMBOL='MyClass';\nCREATE FUNCTION mydb.fn2(VARCHAR(*), BOOLEAN)\n RETURNS INT\n LOCATION 'hdfs://foo:123/fns/myfunc.so'\n SYMBOL='myClass'\n";
        Assert.assertEquals((Object)expected, (Object)sql);
    }
}

