/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.BinaryPredicate;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.CompoundPredicate;
import org.apache.impala.analysis.CreateTableAsSelectStmt;
import org.apache.impala.analysis.DateLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.InsertStmt;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.ParsedStatement;
import org.apache.impala.analysis.Parser;
import org.apache.impala.analysis.PlanHint;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.SqlScanner;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.analysis.TimestampArithmeticExpr;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.compat.MetastoreShim;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest
extends FrontendTestBase {
    private static final String[] operands_ = new String[]{"i", "5", "true", "NULL", "'a'", "(1.5 * 8)"};

    public <C extends Expr> Object ParsesOk(String selectStmtSql, Class<C> cl) {
        ParsedStatement parseNode = this.ParsesOk(selectStmtSql);
        if (!(parseNode.getTopLevelNode() instanceof SelectStmt)) {
            Assert.fail((String)String.format("Statement parsed ok but it is not a select stmt: %s", selectStmtSql));
        }
        SelectStmt selectStmt = (SelectStmt)parseNode.getTopLevelNode();
        Expr firstExpr = ((SelectListItem)selectStmt.getSelectList().getItems().get(0)).getExpr();
        Assert.assertTrue((String)String.format("Expression is of class '%s'. Expected class '%s'", firstExpr.getClass().getSimpleName(), cl.getSimpleName()), (boolean)firstExpr.getClass().equals(cl));
        return parseNode;
    }

    public void ParserError(String stmt, String expectedErrorString) {
        StatementBase result = null;
        try {
            result = Parser.parse((String)stmt);
        }
        catch (AnalysisException e) {
            if (expectedErrorString != null) {
                String errorString = e.getMessage();
                StringBuilder message = new StringBuilder();
                message.append("Got: ");
                message.append(errorString).append("\nExpected: ").append(expectedErrorString);
                Assert.assertTrue((String)message.toString(), (boolean)errorString.startsWith(expectedErrorString));
            }
            return;
        }
        Assert.fail((String)("Stmt didn't result in parsing error: " + stmt));
    }

    public void ParserError(String stmt) {
        this.ParserError(stmt, null);
    }

    @Test
    public void TestCopyTestCase() {
        this.ParsesOk("copy testcase to 'hdfs:///foo' select * from tbl");
        this.ParsesOk("copy testcase to 'hdfs:///foo' with v as (select 1) select * from v");
        this.ParsesOk("copy testcase to 'hdfs:///foo' select * from t1 union select * from t2");
        this.ParserError("copy testcase to 'hdfs:///foo' alter table foo add partition (p=1)");
        this.ParserError("copy testcase to 'hdfs:///foo' insert into t values (1)");
        this.ParserError("copy testcase to select * from tbl");
        this.ParserError("copy testcase to hdfs:///foo select * from tbl");
        this.ParsesOk("copy testcase from 'hdfs:///foo'");
        this.ParserError("copy testcase from hdfs:///foo");
        this.ParserError("copy testcase");
        this.ParsesOk("select testcase from foo");
    }

    @Test
    public void TestNoFromClause() {
        this.ParsesOk("select 1 + 1, 'two', f(3), a + b");
        this.ParserError("select 1 + 1 'two' f(3) a + b");
        this.ParserError("select a, 2 where a > 2");
        this.ParserError("select a, 2 group by");
        this.ParserError("select a, 2 order by 1");
        this.ParserError("select a, 2 limit 1");
        this.ParserError("select a, 2 order by 1 limit 1");
    }

    @Test
    public void TestSelect() {
        this.ParsesOk("select a from tbl");
        this.ParsesOk("select a, b, c, d from tbl");
        this.ParsesOk("select true, false, NULL from tbl");
        this.ParsesOk("select all a, b, c from tbl");
        this.ParserError("a from tbl");
        this.ParserError("select a b c from tbl");
        this.ParserError("select all from tbl");
    }

    @Test
    public void TestAlias() {
        char[] quotes = new char[]{'\'', '\"', '`', ' '};
        for (int i = 0; i < quotes.length; ++i) {
            char quote = quotes[i];
            this.ParsesOk("select a 'b' from tbl".replace('\'', quote));
            this.ParsesOk("select a as 'b' from tbl".replace('\'', quote));
            this.ParsesOk("select a 'x', b as 'y', c 'z' from tbl".replace('\'', quote));
            this.ParsesOk("select a 'x', b as 'y', sum(x) over () 'z' from tbl".replace('\'', quote));
            this.ParsesOk("select a.b 'x' from tbl".replace('\'', quote));
            this.ParsesOk("select a.b as 'x' from tbl".replace('\'', quote));
            this.ParsesOk("select a.b.c.d 'x' from tbl".replace('\'', quote));
            this.ParsesOk("select a.b.c.d as 'x' from tbl".replace('\'', quote));
            this.ParsesOk("select a from tbl 'b'".replace('\'', quote));
            this.ParsesOk("select a from tbl as 'b'".replace('\'', quote));
            this.ParsesOk("select a from db.tbl 'b'".replace('\'', quote));
            this.ParsesOk("select a from db.tbl as 'b'".replace('\'', quote));
            this.ParsesOk("select a from db.tbl.col 'b'".replace('\'', quote));
            this.ParsesOk("select a from db.tbl.col as 'b'".replace('\'', quote));
            this.ParsesOk("select a from (select * from tbl) 'b'".replace('\'', quote));
            this.ParsesOk("select a from (select * from tbl) as 'b'".replace('\'', quote));
            this.ParsesOk("select a from (select * from tbl b) as 'b'".replace('\'', quote));
            this.ParsesOk("with 't' as (select 1) select * from t".replace('\'', quote));
        }
        this.ParserError("a from tbl");
        this.ParserError("select a as a, b c d from tbl");
    }

    @Test
    public void TestStar() {
        this.ParsesOk("select * from tbl");
        this.ParsesOk("select tbl.* from tbl");
        this.ParsesOk("select db.tbl.* from tbl");
        this.ParsesOk("select db.tbl.struct_col.* from tbl");
        this.ParserError("select * + 5 from tbl");
        this.ParserError("select (*) from tbl");
        this.ParserError("select *.id from tbl");
        this.ParserError("select * from tbl.*");
        this.ParserError("select * from tbl where * = 5");
        this.ParsesOk("select * from tbl where f(*) = 5");
        this.ParserError("select * from tbl where tbl.* = 5");
        this.ParserError("select * from tbl where f(tbl.*) = 5");
    }

    @Test
    public void TestMultilineComment() {
        this.ParserError("/**/");
        this.ParserError("/*****/");
        this.ParserError("/* select 1 */");
        this.ParserError("/*/ select 1");
        this.ParserError("select 1 /*/");
        this.ParsesOk("/**/select 1");
        this.ParsesOk("select/* */1");
        this.ParsesOk("/** */ select 1");
        this.ParsesOk("select 1/* **/");
        this.ParsesOk("/*/*/select 1");
        this.ParsesOk("/*//*/select 1");
        this.ParsesOk("select 1/***/");
        this.ParsesOk("/*****/select 1");
        this.ParsesOk("/**//**/select 1");
        this.ParserError("/**/**/select 1");
        this.ParsesOk("\nselect 1/**/");
        this.ParsesOk("/*\n*/select 1");
        this.ParsesOk("/*\r*/select 1");
        this.ParsesOk("/*\r\n*/select 1");
        this.ParsesOk("/**\n* Doc style\n*/select 1");
        this.ParsesOk("/************\n*\n* Header style\n*\n***********/select 1");
        this.ParsesOk("/* 1 */ select 1 /* 2 */");
        this.ParsesOk("select\n/**/\n1");
        this.ParserError("/**// select 1");
        this.ParserError("/**/*/ select 1");
        this.ParserError("/ **/ select 1");
        this.ParserError("/** / select 1");
        this.ParserError("/\n**/ select 1");
        this.ParserError("/**\n/ select 1");
        this.ParsesOk("/*--*/ select 1");
        this.ParsesOk("/* --foo */ select 1");
        this.ParsesOk("/*\n--foo */ select 1");
        this.ParsesOk("/*\n--foo\n*/ select 1");
        this.ParserError("select 1 /* --bar");
        this.ParserError("select 1 /*--");
        this.ParsesOk("/* select 1; */ select 1");
        this.ParsesOk("/** select 1; */ select 1");
        this.ParsesOk("/* select */ select 1 /* 1 */");
        this.ParsesOk("select 1 /* hint_with_args(() */");
        this.ParserError("select 1 /*+ hint_with_args() */");
        this.ParserError("select 1 /*+ hint_with_args(() */");
        this.ParserError("select 1 /*+ hint_with_args(a) \n");
        this.ParserError("select 1 --+ hint_with_args(a) */\n from t");
    }

    @Test
    public void TestSinglelineComment() {
        this.ParserError("--");
        this.ParserError("--select 1");
        this.ParsesOk("select 1--");
        this.ParsesOk("select 1 --foo");
        this.ParsesOk("select 1 --\ncol_name");
        this.ParsesOk("--foo's \nselect 1 --bar");
        this.ParsesOk("--foo\nselect 1 --bar");
        this.ParsesOk("--foo\r\nselect 1 --bar");
        this.ParsesOk("--/* foo */\n select 1");
        this.ParsesOk("select 1 --/**/");
        this.ParsesOk("-- foo /*\nselect 1");
        this.ParserError("-- baz /*\nselect 1*/");
        this.ParsesOk("select -- blah\n 1");
        this.ParsesOk("select -- select 1\n 1");
        this.ParsesOk("select 1 -- hint_with_args(()");
        this.ParserError("select 1 -- +hint_with_args(()\n");
    }

    private void TestJoinHints(String stmt, String ... expectedHints) {
        SelectStmt selectStmt = (SelectStmt)this.ParsesOk(stmt).getTopLevelNode();
        Preconditions.checkState((selectStmt.getTableRefs().size() > 1 ? 1 : 0) != 0);
        ArrayList actualHints = new ArrayList();
        Assert.assertTrue((boolean)((TableRef)selectStmt.getTableRefs().get(0)).getJoinHints().isEmpty());
        for (int i = 1; i < selectStmt.getTableRefs().size(); ++i) {
            List hints = ((TableRef)selectStmt.getTableRefs().get(i)).getJoinHints();
            for (PlanHint hint : hints) {
                actualHints.add(hint.toString());
            }
        }
        if (actualHints.isEmpty()) {
            actualHints = Lists.newArrayList((Object[])new String[]{null});
        }
        Assert.assertEquals((Object)Lists.newArrayList((Object[])expectedHints), actualHints);
    }

    private void TestTableHints(String stmt, String ... expectedHints) {
        SelectStmt selectStmt = (SelectStmt)this.ParsesOk(stmt).getTopLevelNode();
        Preconditions.checkState((selectStmt.getTableRefs().size() > 0 ? 1 : 0) != 0);
        ArrayList actualHints = new ArrayList();
        for (int i = 0; i < selectStmt.getTableRefs().size(); ++i) {
            List hints = ((TableRef)selectStmt.getTableRefs().get(i)).getTableHints();
            for (PlanHint hint : hints) {
                actualHints.add(hint.toString());
            }
        }
        if (actualHints.isEmpty()) {
            actualHints = Lists.newArrayList((Object[])new String[]{null});
        }
        Assert.assertEquals((Object)Lists.newArrayList((Object[])expectedHints), actualHints);
    }

    private void TestTableAndJoinHints(String stmt, String ... expectedHints) {
        SelectStmt selectStmt = (SelectStmt)this.ParsesOk(stmt).getTopLevelNode();
        Preconditions.checkState((selectStmt.getTableRefs().size() > 0 ? 1 : 0) != 0);
        ArrayList actualHints = new ArrayList();
        for (int i = 0; i < selectStmt.getTableRefs().size(); ++i) {
            List joinHints = ((TableRef)selectStmt.getTableRefs().get(i)).getJoinHints();
            for (PlanHint hint : joinHints) {
                actualHints.add(hint.toString());
            }
            List tableHints = ((TableRef)selectStmt.getTableRefs().get(i)).getTableHints();
            for (PlanHint hint : tableHints) {
                actualHints.add(hint.toString());
            }
        }
        if (actualHints.isEmpty()) {
            actualHints = Lists.newArrayList((Object[])new String[]{null});
        }
        Assert.assertEquals((Object)Lists.newArrayList((Object[])expectedHints), actualHints);
    }

    private void TestSelectListHints(String stmt, String ... expectedHints) {
        SelectStmt selectStmt = (SelectStmt)this.ParsesOk(stmt).getTopLevelNode();
        ArrayList actualHints = new ArrayList();
        List hints = selectStmt.getSelectList().getPlanHints();
        for (PlanHint hint : hints) {
            actualHints.add(hint.toString());
        }
        if (actualHints.isEmpty()) {
            actualHints = Lists.newArrayList((Object[])new String[]{null});
        }
        Assert.assertEquals((Object)Lists.newArrayList((Object[])expectedHints), actualHints);
    }

    private void TestInsertAndCtasHints(String insertPart, String ctasPart, String[] hintStyle, String hints, String ... expectedHints) {
        String hintsPart = hintStyle[0] + hints + hintStyle[1];
        this.TestInsertStmtHints(String.format("insert %%s into %s %%s select * from t", insertPart), hintsPart, expectedHints);
        this.TestInsertStmtHints(String.format("insert %%s overwrite %s %%s select * from t", insertPart), hintsPart, expectedHints);
        this.TestCtasHints(String.format("create %s table %s as select * from t", hintsPart, ctasPart), expectedHints);
    }

    private void TestInsertStmtHints(String pattern, String hint, String ... expectedHints) {
        for (InsertStmt.HintLocation loc : InsertStmt.HintLocation.values()) {
            InsertStmt insertStmt = (InsertStmt)this.ParsesOk(this.InjectInsertHint(pattern, hint, loc)).getTopLevelNode();
            Assert.assertEquals((Object[])expectedHints, (Object[])ParserTest.HintsToStrings(insertStmt.getPlanHints()));
        }
    }

    private void ParserErrorOnInsertStmtHints(String pattern, String hint) {
        for (InsertStmt.HintLocation loc : InsertStmt.HintLocation.values()) {
            this.ParserError(this.InjectInsertHint(pattern, hint, loc));
        }
    }

    private void TestCtasHints(String stmt, String ... expectedHints) {
        CreateTableAsSelectStmt ctasStmt = (CreateTableAsSelectStmt)this.ParsesOk(stmt).getTopLevelNode();
        Assert.assertEquals((Object[])expectedHints, (Object[])ParserTest.HintsToStrings(ctasStmt.getInsertStmt().getPlanHints()));
    }

    private static String[] HintsToStrings(List<PlanHint> hints) {
        if (hints.isEmpty()) {
            return new String[]{null};
        }
        String[] hintAsStrings = new String[hints.size()];
        for (int i = 0; i < hints.size(); ++i) {
            hintAsStrings[i] = hints.get(i).toString();
        }
        return hintAsStrings;
    }

    @Test
    public void TestPlanHints() {
        String[][] commentStyles = new String[][]{{"/*", "*/"}, {"--", "\n"}};
        for (String[] hintStyle : this.hintStyles_) {
            String prefix = hintStyle[0];
            String suffix = hintStyle[1];
            this.ParserError(prefix + suffix, "Syntax error in line 1:\n" + prefix + suffix);
            this.TestJoinHints(String.format("select * from functional.alltypes a join %sbroadcast%s functional.alltypes b", prefix, suffix), "broadcast");
            this.TestJoinHints(String.format("select * from functional.alltypes a join %sbroadcast%s functional.alltypes b using(id)", prefix, suffix), "broadcast");
            this.TestJoinHints(String.format("select * from functional.alltypes a join %sbroadcast%s functional.alltypes b on(a.id = b.id)", prefix, suffix), "broadcast");
            this.TestJoinHints(String.format("select * from functional.alltypes a cross join %sbroadcast%s functional.alltypes b", prefix, suffix), "broadcast");
            this.TestJoinHints(String.format("select * from functional.alltypes a join %sbroadcast,shuffle,foo,bar%s functional.alltypes b using(id)", prefix, suffix), "broadcast", "shuffle", "foo", "bar");
            this.TestJoinHints(String.format("select * from functional.alltypes a join %sbroadcast%s functional.alltypes b using(id) join %sshuffle%s functional.alltypes c using(int_col) join %sbroadcast%s functional.alltypes d using(int_col) join %sshuffle%s functional.alltypes e using(string_col)", prefix, suffix, prefix, suffix, prefix, suffix, prefix, suffix), "broadcast", "shuffle", "broadcast", "shuffle");
            this.ParserError(String.format("select * from functional.alltypes a join %sbroadcast%s functional.alltypes b using(id) join %sshuffle%s functional.alltypes c using(int_col) join %sbroadcast%s functional.alltypes d using(int_col) join %sshuffle%s functional.alltypes e using(string_col)", prefix, suffix, suffix, prefix, prefix, suffix, suffix, prefix));
            this.ParserError(String.format("select * from functional.alltypes a join %sbroadcast%s functional.alltypes b using(id) join %sshuffle%s functional.alltypes c using(int_col) join %sbroadcast%s functional.alltypes d using(int_col) join %sshuffle%s functional.alltypes e using(string_col)", suffix, suffix, suffix, suffix, prefix, "", "", ""));
            this.TestInsertAndCtasHints("t", "t", hintStyle, "noshuffle", "noshuffle");
            this.TestInsertAndCtasHints("t partition(x, y)", "t partitioned by(x, y)", hintStyle, "noshuffle", "noshuffle");
            this.TestInsertAndCtasHints("t(a, b) partition(x, y)", "t partitioned by(x, y)", hintStyle, "shuffle", "shuffle");
            this.TestInsertAndCtasHints("t(a, b) partition(x, y)", "t partitioned by(x, y)", hintStyle, "foo,bar,baz", "foo", "bar", "baz");
            this.TestInsertStmtHints("upsert %s into t %s select * from t", String.format("%sshuffle%s", prefix, suffix), "shuffle");
            this.TestInsertStmtHints("upsert %s into t (x, y) %s select * from t", String.format("%sshuffle%s", prefix, suffix), "shuffle");
            this.TestTableHints(String.format("select * from functional.alltypes %sschedule_disk_local%s", prefix, suffix), "schedule_disk_local");
            this.TestTableHints(String.format("select * from functional.alltypes %sschedule_cache_local,schedule_random_replica%s", prefix, suffix), "schedule_cache_local", "schedule_random_replica");
            this.TestTableHints(String.format("select * from functional.alltypes a %sschedule_cache_local,schedule_random_replica%s", prefix, suffix), "schedule_cache_local", "schedule_random_replica");
            this.TestTableHints(String.format("select * from functional.alltypes a %sschedule_cache_local,schedule_random_replica%s, functional.alltypes b %sschedule_remote%s", prefix, suffix, prefix, suffix), "schedule_cache_local", "schedule_random_replica", "schedule_remote");
            this.TestTableAndJoinHints(String.format("select * from functional.alltypes a %sschedule_cache_local,schedule_random_replica%s join %sbroadcast%s functional.alltypes b %sschedule_remote%s using(id)", prefix, suffix, prefix, suffix, prefix, suffix), "schedule_cache_local", "schedule_random_replica", "broadcast", "schedule_remote");
            this.TestSelectListHints(String.format("select %sfoo,bar,baz%s * from functional.alltypes a", prefix, suffix), "foo", "bar", "baz");
            String localPrefix = prefix;
            String localSuffix = suffix;
            if (prefix == "[") {
                localPrefix = "";
                localSuffix = "";
            }
            this.TestSelectListHints(String.format("select %sstraight_join%s * from functional.alltypes a", localPrefix, localSuffix), "straight_join");
            if (prefix == "[") continue;
            for (String[] commentStyle : commentStyles) {
                String commentPrefix = commentStyle[0];
                String commentSuffix = commentStyle[1];
                String queryTemplate = "$1comment$2 select $1comment$2 $3straight_join$4 $1comment$2 * from $1comment$2 functional.alltypes a join $1comment$2 $3shuffle$4 $1comment$2 functional.alltypes b $1comment$2 on $1comment$2 (a.id = b.id)";
                String query = queryTemplate.replaceAll("\\$1", commentPrefix).replaceAll("\\$2", commentSuffix).replaceAll("\\$3", prefix).replaceAll("\\$4", suffix);
                this.TestSelectListHints(query, "straight_join");
                this.TestJoinHints(query, "shuffle");
            }
            this.TestInsertStmtHints("insert %s into t %s select * from t", String.format("%shint_with_args(a)%s", prefix, suffix), "hint_with_args(a)");
            this.TestInsertStmtHints("insert %s into t %s select * from t", String.format("%sclustered,shuffle,hint_with_args(a)%s", prefix, suffix), "clustered", "shuffle", "hint_with_args(a)");
            this.TestInsertStmtHints("insert %s into t %s select * from t", String.format("%shint_with_args(a,b)%s", prefix, suffix), "hint_with_args(a,b)");
            this.TestInsertStmtHints("insert %s into t %s select * from t", String.format("%shint_with_args(a  , b)%s", prefix, suffix), "hint_with_args(a,b)");
            this.TestInsertStmtHints("insert %s into t %s select * from t", String.format("%shint_with_args(  a  , b , c  , d, e, f    )%s", prefix, suffix), "hint_with_args(a,b,c,d,e,f)");
            this.ParserErrorOnInsertStmtHints("insert %s into t %s select * from t", String.format("%shint_with_args(  a  ,  , ,,, b  )%s", prefix, suffix));
            this.TestInsertAndCtasHints("t", "t", hintStyle, "hint_with_args(a)", "hint_with_args(a)");
            this.TestInsertAndCtasHints("t", "t", hintStyle, "clustered,shuffle,hint_with_args(a)", "clustered", "shuffle", "hint_with_args(a)");
            this.TestInsertAndCtasHints("t", "t", hintStyle, "hint_with_args(a,b)", "hint_with_args(a,b)");
            this.TestInsertAndCtasHints("t", "t", hintStyle, "hint_with_args(a  , b)", "hint_with_args(a,b)");
            this.ParserErrorOnInsertStmtHints("insert %s into t %s select * from t", String.format("%shint_with_args(  a  ,  , ,,, b  )%s", prefix, suffix));
            this.ParserError(String.format("create table t %shint_with_args(  a  ,  , ,,, b  )%s as select * from t", prefix, suffix));
            this.ParserError(String.format("insert %s into t %s select * from t", String.format("%sshuffle%s", prefix, suffix), String.format("%sclustered%s", prefix, suffix)));
            this.ParserError(String.format("upsert %s into t %s select * from t", String.format("%sshuffle%s", prefix, suffix), String.format("%sclustered%s", prefix, suffix)));
        }
        this.TestJoinHints("select * from functional.alltypes a join /* comment */functional.alltypes b using (int_col)", new String[]{null});
        this.TestSelectListHints("select /* comment */ * from functional.alltypes", new String[]{null});
        this.TestInsertStmtHints("insert %s into t(a, b) partition(x, y) %s select 1", "/* comment */", new String[]{null});
        this.TestCtasHints("create /* comment */ table t partitioned by (x, y) as select 1", new String[]{null});
        this.TestSelectListHints("select /* -- +straight_join */ * from functional.alltypes", new String[]{null});
        this.TestSelectListHints("select /* abcdef +straight_join */ * from functional.alltypes", new String[]{null});
        this.TestSelectListHints("select \n-- abcdef +straight_join\n * from functional.alltypes", new String[]{null});
        this.TestSelectListHints("select \n-- /*+straight_join\n * from functional.alltypes", new String[]{null});
        this.TestSelectListHints("select /*\n +straight_join */ * from functional.alltypes", new String[]{null});
        this.TestSelectListHints("select /* +straight_join \n*/ * from functional.alltypes", new String[]{null});
        this.TestSelectListHints("select /* +straight_\njoin */ * from functional.alltypes", new String[]{null});
        this.ParserError("select -- +straight_join * from functional.alltypes");
        this.ParserError("select \n-- +straight_join * from functional.alltypes");
        this.ParserError("select * from functional.alltypes a join + */functional.alltypes b using (int_col)");
        this.ParserError("select * from functional.alltypes a join /* + functional.alltypes b using (int_col)");
        this.TestSelectListHints("select /* +straight_join, ,, */ * from functional.alltypes", "straight_join");
        this.ParserError("select /* /* +straight_join */ */ * from functional.alltypes");
    }

    @Test
    public void TestFromClause() {
        String[] tblRefs;
        for (String tbl : tblRefs = new String[]{"tbl", "db.tbl", "db.tbl.col", "db.tbl.col.fld"}) {
            this.ParsesOk("select * from $TBL src1 left outer join $TBL src2 on   src1.key = src2.key and src1.key < 10 and src2.key > 10 right outer join $TBL src3 on   src2.key = src3.key and src3.key < 10 full outer join $TBL src3 on   src2.key = src3.key and src3.key < 10 left semi join $TBL src3 on   src2.key = src3.key and src3.key < 10 left anti join $TBL src3 on   src2.key = src3.key and src3.key < 10 right semi join $TBL src3 on   src2.key = src3.key and src3.key < 10 right anti join $TBL src3 on   src2.key = src3.key and src3.key < 10 join $TBL src3 on   src2.key = src3.key and src3.key < 10 inner join $TBL src3 on   src2.key = src3.key and src3.key < 10 ".replace("$TBL", tbl));
            this.ParsesOk("select * from $TBL src1 left outer join $TBL src2 using (a, b, c) right outer join $TBL src3 using (d, e, f) full outer join $TBL src4 using (d, e, f) left semi join $TBL src5 using (d, e, f) left anti join $TBL src6 using (d, e, f) right semi join $TBL src7 using (d, e, f) right anti join $TBL src8 using (d, e, f) join $TBL src9 using (d, e, f) inner join $TBL src10 using (d, e, f) ".replace("$TBL", tbl));
            this.ParsesOk("select * from $TBL cross join $TBL".replace("$TBL", tbl));
        }
        this.ParsesOk("select * from src src1 left outer join src src2 on NULL right outer join src src3 on (NULL) full outer join src src3 on NULL left semi join src src3 on (NULL) left anti join src src3 on (NULL) right semi join src src3 on (NULL) right anti join src src3 on (NULL) join src src3 on NULL inner join src src3 on (NULL) where src2.bla = src3.bla order by src1.key, src1.value, src2.key, src2.value, src3.key, src3.value");
        this.ParsesOk("select * from src src1 join src src2 on ('a')");
        this.ParsesOk("select * from src src1 join src src2 on (f(a, b))");
        this.ParserError("select * from src src1 left outer join src src2 on (src1.key = src2.key and)");
        this.ParserError("select * from src src1 join src src2 using (1)");
        this.ParserError("select * from src src1 join src src2 using (f(id))");
        this.ParserError("select * from src src1 join src src2 using id");
        this.ParserError("select * from a cross join b on (a.id = b.id)");
        this.ParserError("select * from a cross join b using (id)");
    }

    @Test
    public void TestTimeTravel() {
        String[] aliases;
        String timeAsOf = "select * from a for system_time as of";
        for (String alias : aliases = new String[]{"", " a_snapshot", " as a_snapshot"}) {
            this.ParsesOk(timeAsOf + " '2021-08-09 15:14:40'" + alias);
            this.ParsesOk(timeAsOf + " days_sub('2021-08-09 15:14:40', 3)" + alias);
            this.ParsesOk(timeAsOf + " now()" + alias);
            this.ParsesOk(timeAsOf + " days_sub(now(), 12)" + alias);
            this.ParsesOk(timeAsOf + " now() - interval 100 days" + alias);
            this.ParsesOk("select * from a for system_version as of 12345" + alias);
            this.ParserError("select * from a for system_version as of -12345" + alias);
            this.ParserError("select * from a for system_version as of \"12345\"" + alias);
            this.ParserError("select * from a for system_version as of 34 + 34" + alias);
            this.ParserError("select * from a for system_version as of b" + alias);
            this.ParserError("select * from a for system_version as of b + 4" + alias);
        }
        this.ParserError("select * from t for system_time as of");
        this.ParserError("select * from t for system_version as of");
    }

    @Test
    public void TestTableSampleClause() {
        String[] tblRefs = new String[]{"tbl", "db.tbl", "db.tbl.col", "db.tbl.col.fld"};
        String[] tblAliases = new String[]{"", "t"};
        String[] tblSampleClauses = new String[]{"", "tablesample system(10)", "tablesample system(100) repeatable(20)"};
        String[] tblHints = new String[]{"", "/* +schedule_remote */", "[schedule_random_replica]"};
        for (String tbl : tblRefs) {
            for (String alias : tblAliases) {
                for (String smp : tblSampleClauses) {
                    for (String hint : tblHints) {
                        this.ParsesOk(String.format("select * from %s %s %s %s", tbl, alias, smp, hint));
                        this.ParsesOk(String.format("select a.* from %s %s %s %s join %s %s %s %s using (id)", tbl, alias, smp, hint, tbl, alias, smp, hint));
                        this.ParsesOk(String.format("select a.* from %s %s %s %s, %s %s %s %s", tbl, alias, smp, hint, tbl, alias, smp, hint));
                        this.ParsesOk(String.format("select * from (select 1 from %s %s) v %s %s", tbl, alias, smp, hint));
                    }
                }
            }
        }
        this.ParserError("select * from t tablesample (10) a");
        this.ParserError("select * from t [schedule_remote] tablesample (10)");
        this.ParserError("select * from t /* +schedule_remote */ tablesample (10)");
        this.ParserError("select * from t tablesample (10)");
        this.ParserError("select * from t tablesample system 10");
        this.ParserError("select * from t tablesample system (10 + 10");
        this.ParserError("select * from t tablesample system (10) repeatable");
        this.ParserError("select * from t tablesample system (10) repeatable (10 + 10)");
        this.ParserError("select * from t tablesample system (-10)");
        this.ParserError("select * from t tablesample system (10) repeatable(-10)");
    }

    @Test
    public void TestWhereClause() {
        this.ParsesOk("select a, b from t where a > 15");
        this.ParsesOk("select a, b from t where true");
        this.ParsesOk("select a, b from t where NULL");
        this.ParsesOk("select a, b from t where case a when b then true else false end");
        this.ParsesOk("select a, b from t where if (a > b, true, false)");
        this.ParsesOk("select a, b from t where bool_col");
        this.ParsesOk("select a, b from t where 10.5");
        this.ParsesOk("select a, b from t where trim('abc')");
        this.ParsesOk("select a, b from t where s + 20");
        this.ParserError("select a, b from t where a > 15 from test");
        this.ParserError("select a, b where a > 15");
        this.ParserError("select where a, b from t");
    }

    @Test
    public void TestGroupBy() {
        this.ParsesOk("select a, b, count(c) from test group by 1, 2");
        this.ParsesOk("select a, b, count(c) from test group by a, b");
        this.ParsesOk("select a, b, count(c) from test group by true, false, NULL");
        this.ParsesOk("select a, b, count(c) from test group by 1, b");
        this.ParserError("select a, b, count(c) from test group 1, 2");
        this.ParserError("select a, b, count(c) from test group by order by a");
    }

    @Test
    public void TestOrderBy() {
        this.ParsesOk("select int_col, string_col, bigint_col, count(*) from alltypes order by string_col, 15.7 * float_col, int_col + bigint_col");
        this.ParsesOk("select int_col, string_col, bigint_col, count(*) from alltypes order by string_col asc, 15.7 * float_col desc, int_col + bigint_col asc");
        this.ParsesOk("select int_col, string_col, bigint_col, count(*) from alltypes order by string_col asc, float_col desc, int_col + bigint_col asc nulls first");
        this.ParsesOk("select int_col, string_col, bigint_col, count(*) from alltypes order by string_col asc, float_col desc, int_col + bigint_col desc nulls last");
        this.ParsesOk("select int_col, string_col, bigint_col, count(*) from alltypes order by string_col asc, float_col desc, int_col + bigint_col nulls first");
        this.ParsesOk("select int_col, string_col, bigint_col, count(*) from alltypes order by string_col asc, float_col desc nulls last, int_col + bigint_col nulls first");
        this.ParsesOk("select int_col from alltypes order by true, false, NULL");
        this.ParserError("select int_col, string_col, bigint_col, count(*) from alltypes order by by string_col asc desc");
        this.ParserError("select int_col, string_col, bigint_col, count(*) from alltypes nulls first");
        this.ParserError("select int_col, string_col, bigint_col, count(*) from alltypes order by string_col nulls");
        this.ParserError("select int_col, string_col, bigint_col, count(*) from alltypes order by string_col nulls first asc");
        this.ParserError("select int_col, string_col, bigint_col, count(*) from alltypes order by string_col nulls first last");
    }

    @Test
    public void TestHaving() {
        this.ParsesOk("select a, b, count(c) from test group by a, b having count(*) > 5");
        this.ParsesOk("select a, b, count(c) from test group by a, b having NULL");
        this.ParsesOk("select a, b, count(c) from test group by a, b having true");
        this.ParsesOk("select a, b, count(c) from test group by a, b having false");
        this.ParsesOk("select count(c) from test group by a having if (a > b, true, false)");
        this.ParsesOk("select count(c) from test group by a having case a when b then true else false end");
        this.ParsesOk("select a, b, count(c) from test group by a, b having 5");
        this.ParserError("select a, b, count(c) from test group by a, b having order by 5");
        this.ParserError("select a, b, count(c) from test having count(*) > 5 group by a, b");
    }

    @Test
    public void TestLimit() {
        this.ParsesOk("select a, b, c from test inner join test2 using(a) limit 10");
        this.ParsesOk("select a, b, c from test inner join test2 using(a) limit 10 + 10");
        this.ParsesOk("select a, b, c from test inner join test2 using(a) limit 'a'");
        this.ParsesOk("select a, b, c from test inner join test2 using(a) limit a");
        this.ParsesOk("select a, b, c from test inner join test2 using(a) limit true");
        this.ParsesOk("select a, b, c from test inner join test2 using(a) limit false");
        this.ParsesOk("select a, b, c from test inner join test2 using(a) limit NULL");
        this.ParserError("select a, b, c from test inner join test2 using(a) limit 10 where a > 10");
    }

    @Test
    public void TestOffset() {
        this.ParsesOk("select a from test order by a limit 10 offset 5");
        this.ParsesOk("select a from test order by a limit 10 offset 0");
        this.ParsesOk("select a from test order by a limit 10 offset 0 + 5 / 2");
        this.ParsesOk("select a from test order by a asc limit 10 offset 5");
        this.ParsesOk("select a from test order by a offset 5");
        this.ParsesOk("select a from test limit 10 offset 5");
        this.ParsesOk("select a from test offset 5");
        this.ParsesOk("select a from (select a from test offset 5) A");
        this.ParsesOk("select a from (select a from test order by a offset 5) A");
        this.ParserError("select a from test order by a limit offset");
        this.ParserError("select a from test order by a limit offset 5");
    }

    @Test
    public void TestSetOperations() {
        String[] setOperators;
        String[] noAllOps;
        String allOp = "union";
        this.ParsesOk(String.format("select a from test %s all select a from test", allOp));
        this.ParsesOk(String.format("select sin() %s all select cos()", allOp));
        this.ParsesOk(String.format("select a from test %s select a from test %s all select a from test %s distinct select a from test", allOp, allOp, allOp));
        this.ParsesOk(String.format("select a from test %s all select a from test %s all select a from test %s all select a from test", allOp, allOp, allOp));
        for (String noAllOp : noAllOps = new String[]{"except", "intersect", "minus"}) {
            this.ParserError(String.format("select a from test %s all select a from test", noAllOp));
            this.ParserError(String.format("select sin() %s all select cos()", noAllOp));
            this.ParserError(String.format("select a from test %s select a from test %s all select a from test %s distinct select a from test", noAllOp, noAllOp, noAllOp));
            this.ParserError(String.format("select a from test %s all select a from test %s all select a from test %s all select a from test", noAllOp, noAllOp, noAllOp));
        }
        for (String op : setOperators = new String[]{"union", "except", "intersect", "minus"}) {
            this.ParsesOk(String.format("select a from test %s select a from test", op));
            this.ParsesOk(String.format("select a from test %s distinct select a from test", op));
            this.ParsesOk(String.format("select a from test %s select a from test %s select a from test %s select a from test", op, op, op));
            this.ParsesOk(String.format("select a from test %s distinct select a from test %s distinct select a from test %s distinct select a from test ", op, op, op));
            this.ParsesOk(String.format("select sin() %s select cos()", op));
            this.ParsesOk(String.format("select sin() %s distinct select cos()", op));
            this.ParsesOk(String.format("(select a from test) %s (select a from test) %s (select a from test) %s (select a from test)", op, op, op));
            this.ParsesOk(String.format("(select a from test) %s (select a from test) %s (select a from test) %s (select a from test) order by a", op, op, op));
            this.ParsesOk(String.format("(select a from test) %s (select a from test) %s (select a from test) %s (select a from test) order by a nulls first", op, op, op));
            this.ParsesOk(String.format("(select a from test) %s (select a from test) %s (select a from test) %s (select a from test) limit 10", op, op, op));
            this.ParsesOk(String.format("(select a from test) %s (select a from test) %s (select a from test) %s (select a from test) order by a limit 10", op, op, op));
            this.ParsesOk(String.format("(select a from test) %s (select a from test) %s (select a from test) %s (select a from test) order by a nulls first limit 10", op, op, op));
            this.ParsesOk(String.format("(select a from test) %s (select a from test) %s (select a from test) %s (select a from test) order by a nulls first offset 10", op, op, op));
            this.ParserError(String.format("select a from test %s (select a from test) %s (select a from test) %s (select a from test) offset 10", op, op, op));
            this.ParsesOk(String.format("(select a from test) %s select a from test %s (select a from test) %s select a from test", op, op, op));
            this.ParsesOk(String.format("select a from test %s (select a from test) %s select a from test %s (select a from test)", op, op, op));
            this.ParsesOk(String.format("(select a from test) %s (select a from test) %s select a from test %s select a from test order by a limit 10", op, op, op));
            this.ParsesOk(String.format("(select a from test) %s (select a from test) %s select a from test %s select a from test order by a offset 10", op, op, op));
            this.ParsesOk(String.format("(select a from test) %s (select a from test) %s select a from test %s select a from test order by a", op, op, op));
            this.ParsesOk(String.format("select a from test %s (select a from test) %s select a from test %s (select a from test order by a limit 10) order by a limit 1", op, op, op));
            this.ParsesOk(String.format("select a from test %s (select a from test) %s select a from test %s (select a from test order by a offset 10) order by a limit 1", op, op, op));
            this.ParsesOk(String.format("select a from test %s (select a from test) %s select a from test %s (select a from test order by a) order by a limit 1", op, op, op));
            this.ParsesOk(String.format("select a from test order by a %s select a from test", op));
            this.ParsesOk(String.format("select a from test order by a offset 5 %s select a from test", op, op));
            this.ParsesOk(String.format("select a from test offset 5 %s select a from test", op));
            this.ParsesOk(String.format("select a from test %s select a from test %s select a from test %s select a from test order by a limit 10 order by a limit 1", op, op, op));
            this.ParsesOk(String.format("select a %s ((select b) %s (select c) order by 1 limit 1)", op, op));
            this.ParsesOk(String.format("select a %s ((select b) %s   ((select c) %s (select d)    order by 1 limit 1)  order by 1 limit 1)", op, op, op));
            this.ParsesOk(String.format("insert into table t select a from test %s select a from test", op));
            this.ParsesOk(String.format("insert into table t select a from test %s select a from test %s select a from test %s select a from test", op, op, op));
            this.ParsesOk(String.format("insert overwrite table t select a from test %s select a from test", op));
            this.ParsesOk(String.format("insert overwrite table t select a from test %s select a from test %s select a from test %s select a from test", op, op, op));
            this.ParsesOk(String.format("upsert into table t select a from test %s select a from test", op));
            this.ParsesOk(String.format("upsert into table t select a from test %s select a from test %s select a from test %s select a from test", op, op, op));
            this.ParserError(String.format("a from test %s select a from test", op));
            this.ParserError(String.format("select a from test %s a from test", op));
            this.ParserError(String.format("select %s from test", op));
            this.ParserError(String.format("select a from %s", op));
        }
    }

    @Test
    public void TestValuesStmt() throws AnalysisException {
        this.ParsesOk("values(1, 'a', abc, 1.0, *)");
        this.ParsesOk("select * from (values(1, 'a', abc, 1.0, *)) as t");
        this.ParsesOk("values(1, 'a', abc, 1.0, *) union all values(1, 'a', abc, 1.0, *)");
        this.ParsesOk("insert into t values(1, 'a', abc, 1.0, *)");
        this.ParsesOk("upsert into t values(1, 'a', abc, 1.0, *)");
        this.ParsesOk("values(1, abc), ('x', cde), (2), (efg, fgh, ghi)");
        this.ParsesOk("select * from (values(1, abc), ('x', cde), (2), (efg, fgh, ghi)) as t");
        this.ParsesOk("values(1, abc), ('x', cde), (2), (efg, fgh, ghi) union all values(1, abc), ('x', cde), (2), (efg, fgh, ghi)");
        this.ParsesOk("insert into t values(1, abc), ('x', cde), (2), (efg, fgh, ghi)");
        this.ParsesOk("upsert into t values(1, abc), ('x', cde), (2), (efg, fgh, ghi)");
        this.ParsesOk("(values(1, abc), ('x', cde), (2), (efg, fgh, ghi))");
        this.ParsesOk("values((1, abc), ('x', cde), (2), (efg, fgh, ghi))");
        this.ParsesOk("(values((1, abc), ('x', cde), (2), (efg, fgh, ghi)))");
        this.ParsesOk("values(1 as x, 2 as y, 3 as z)");
        this.ParsesOk("values(1, 'a') limit 10");
        this.ParsesOk("values(1, 'a') order by 1");
        this.ParsesOk("values(1, 'a') order by 1 limit 10");
        this.ParsesOk("values(1, 'a') order by 1 offset 10");
        this.ParsesOk("values(1, 'a') offset 10");
        this.ParsesOk("values(1, 'a'), (2, 'b') order by 1 limit 10");
        this.ParsesOk("values((1, 'a'), (2, 'b')) order by 1 limit 10");
        this.ParserError("values()");
        this.ParserError("values 1, 'a', abc, 1.0");
        this.ParserError("values(1, 'a') values(1, 'a')");
        this.ParserError("select values(1, 'a')");
        this.ParserError("select * from values(1, 'a', abc, 1.0) as t");
        this.ParserError("values((1, 2, 3), values(1, 2, 3))");
        this.ParserError("values((1, 'a'), (1, 'a') order by 1)");
        this.ParserError("values((1, 'a'), (1, 'a') limit 10)");
    }

    @Test
    public void TestWithClause() throws AnalysisException {
        this.ParsesOk("with t as (select 1 as a) select a from t");
        this.ParsesOk("with t(x) as (select 1 as a) select x from t");
        this.ParsesOk("with t as (select c from tab) select * from t");
        this.ParsesOk("with t(x, y) as (select * from tab) select * from t");
        this.ParsesOk("with t as (values(1, 2, 3), (4, 5, 6)) select * from t");
        this.ParsesOk("with t(x, y, z) as (values(1, 2, 3), (4, 5, 6)) select * from t");
        this.ParsesOk("with t1 as (select 1 as a), t2 as (select 2 as a) select a from t1");
        this.ParsesOk("with t1 as (select c from tab), t2 as (select c from tab)select c from t2");
        this.ParsesOk("with t1(x) as (select c from tab), t2(x) as (select c from tab)select x from t2");
        this.ParsesOk("with t1 as (select 1 as a), t2 as (select 2 as a)select a from t1 union all select a from t2");
        this.ParsesOk("with t1 as (select 1 as a), t2 as (select 2 as a)select a from t1 inner join t2 on t1.a = t2.a");
        this.ParsesOk("select * from (with t as (select 1 as a) select * from t) as a");
        this.ParsesOk("select * from (with t(x) as (select 1 as a) select * from t) as a");
        this.ParsesOk("insert into x with t as (select * from tab) select * from t");
        this.ParsesOk("insert into x with t(x, y) as (select * from tab) select * from t");
        this.ParsesOk("insert into x with t as (values(1, 2, 3)) select * from t");
        this.ParsesOk("insert into x with t(x, y) as (values(1, 2, 3)) select * from t");
        this.ParsesOk("with t as (select 1) insert into x select * from t");
        this.ParsesOk("with t(x) as (select 1) insert into x select * from t");
        this.ParsesOk("upsert into x with t as (select * from tab) select * from t");
        this.ParsesOk("upsert into x with t(x, y) as (select * from tab) select * from t");
        this.ParsesOk("upsert into x with t as (values(1, 2, 3)) select * from t");
        this.ParsesOk("upsert into x with t(x, y) as (values(1, 2, 3)) select * from t");
        this.ParsesOk("with t as (select 1) upsert into x select * from t");
        this.ParsesOk("with t(x) as (select 1) upsert into x select * from t");
        this.ParsesOk("with `t1` as (select 1 a), 't2' as (select 2 a), \"t3\" as (select 3 a)select a from t1 union all select a from t2 union all select a from t3");
        this.ParsesOk("with t as (select 1) (with t as (select 2) select * from t) union all (with t as (select 3) select * from t)");
        this.ParsesOk("with t as (select 1) (with t as (select 2) select * from t) union all (with t as (select 3) select * from t) order by 1 limit 1");
        this.ParsesOk("with t as (select 1) insert into x with t as (select 2) select * from t");
        this.ParsesOk("with t(c1) as (select 1) insert into x with t(c2) as (select 2) select * from t");
        this.ParsesOk("with t as (select 1) upsert into x with t as (select 2) select * from t");
        this.ParsesOk("with t(c1) as (select 1) upsert into x with t(c2) as (select 2) select * from t");
        this.ParserError("with t as () select 1");
        this.ParserError("with t(x) as () select 1");
        this.ParserError("with t() as (select 1 as a) select a from t");
        this.ParserError("select * from (with t as (select 1 as a)) as a");
        this.ParserError("with t as (select 1)");
        this.ParserError("with t as select 1 as a select a from t");
        this.ParserError("with t as select 1 as a union all select a from t");
        this.ParserError("with t1 as (select 1 as a), t2 as select 2 as a select a from t");
        this.ParserError("with t as select 1 as a select a from t");
        this.ParserError("with t c1 as (select 1 as a) select c1 from t");
        this.ParserError("with t as (insert into x select * from tab) select * from t");
        this.ParserError("with t(c1) as (insert into x select * from tab) select * from t");
        this.ParserError("with t as (upsert into x select * from tab) select * from t");
        this.ParserError("with t(c1) as (upsert into x select * from tab) select * from t");
        this.ParserError("select * from t union all with t as (select 2) select * from t");
    }

    @Test
    public void TestNumericLiteralMinMaxValues() {
        this.ParsesOk(String.format("select %s", Byte.toString((byte)-128)));
        this.ParsesOk(String.format("select %s", Byte.toString((byte)127)));
        this.ParsesOk(String.format("select %s", Short.toString((short)Short.MIN_VALUE)));
        this.ParsesOk(String.format("select %s", Short.toString((short)Short.MAX_VALUE)));
        this.ParsesOk(String.format("select %s", Integer.toString(Integer.MIN_VALUE)));
        this.ParsesOk(String.format("select %s", Integer.toString(Integer.MAX_VALUE)));
        this.ParsesOk(String.format("select %s", Long.toString(Long.MIN_VALUE)));
        this.ParsesOk(String.format("select %s", Long.toString(Long.MAX_VALUE)));
        this.ParsesOk(String.format("select %s1", Long.toString(Long.MIN_VALUE)));
        this.ParsesOk(String.format("select %s1", Long.toString(Long.MAX_VALUE)));
        BigInteger minMinusOne = BigInteger.valueOf(Long.MAX_VALUE);
        minMinusOne = minMinusOne.add(BigInteger.ONE);
        this.ParsesOk(String.format("select %s", minMinusOne.toString()));
        BigInteger maxPlusOne = BigInteger.valueOf(Long.MAX_VALUE);
        maxPlusOne = maxPlusOne.add(BigInteger.ONE);
        this.ParsesOk(String.format("select %s", maxPlusOne.toString()));
        this.ParsesOk(String.format("select %s", Float.toString(Float.MIN_VALUE)));
        this.ParsesOk(String.format("select %s", Float.toString(Float.MAX_VALUE)));
        this.ParsesOk(String.format("select -%s", Float.toString(Float.MIN_VALUE)));
        this.ParsesOk(String.format("select -%s", Float.toString(Float.MAX_VALUE)));
        this.ParsesOk(String.format("select %s", Double.toString(Double.MIN_VALUE)));
        this.ParsesOk(String.format("select %s", Double.toString(Double.MAX_VALUE)));
        this.ParsesOk(String.format("select -%s", Double.toString(Double.MIN_VALUE)));
        this.ParsesOk(String.format("select -%s", Double.toString(Double.MAX_VALUE)));
        this.ParserError(String.format("select %s1", Double.toString(Double.MIN_VALUE)));
        this.ParserError(String.format("select %s1", Double.toString(Double.MAX_VALUE)));
    }

    @Test
    public void TestIdentQuoting() {
        this.ParsesOk("select a from `t`");
        this.ParsesOk("select a from default.`t`");
        this.ParsesOk("select a from default.t");
        this.ParsesOk("select a from default.`t`");
        this.ParsesOk("select 01a from default.`01_t`");
        this.ParsesOk("select `a` from default.t");
        this.ParsesOk("select `tbl`.`a` from default.t");
        this.ParsesOk("select `db`.`tbl`.`a` from default.t");
        this.ParsesOk("select `12db`.`tbl`.`12_a` from default.t");
        this.ParsesOk("select `8e6`", SlotRef.class);
        this.ParsesOk("select `4.5e2`", SlotRef.class);
        this.ParsesOk("select `.7e9`", SlotRef.class);
        this.ParsesOk("select `db`.tbl.`a` from default.t");
        this.ParsesOk("select `db.table.a` from default.t");
        this.ParserError("select a from ` `");
        this.ParserError("select a from `    `");
        this.ParserError("select a from ``");
        this.ParsesOk("select a from `a a a    `");
        this.ParsesOk("select a from `    a a a`");
        this.ParsesOk("select a from `    a a a    `");
        this.ParsesOk("select a from `all types`");
        this.ParsesOk("select a from default.`all types`");
        this.ParsesOk("select a from `~!@#$%^&*()-_=+|;:'\",<.>/?`");
        this.ParsesOk("select a from `ab\rabc`");
        this.ParsesOk("select a from `ab\tabc`");
        this.ParsesOk("select a from `ab\fabc`");
        this.ParsesOk("select a from `ab\babc`");
        this.ParsesOk("select a from `ab\nabc`");
        this.ParsesOk("select a from `abc\u0000abc`");
        this.ParsesOk("select a from `abc\u0019abc`");
        this.ParsesOk("select a from `abc\u007fabc`");
        this.ParsesOk("select `select`, `insert`, `upsert` from `table` where `where` = 10");
        this.ParserError("select a from `abcde`abcde`");
        this.ParserError("select a from `abc`abc`");
        this.ParserError("select a from 'default'.'t'");
        this.ParsesOk("select `db`.`tbl`.`a` from `default`.`t` `alias` where `alias`.`col` = 'string' group by `alias`.`col`");
    }

    @Test
    public void TestLiteralExprs() {
        this.ParsesOk("select -1 from t where -1", NumericLiteral.class);
        this.ParsesOk("select - 1 from t where - 1", NumericLiteral.class);
        this.ParsesOk("select a - - 1 from t where a - - 1", ArithmeticExpr.class);
        this.ParsesOk("select a - - - 1 from t where a - - - 1", ArithmeticExpr.class);
        this.ParsesOk("select +1 from t where +1", NumericLiteral.class);
        this.ParsesOk("select + 1 from t where + 1", NumericLiteral.class);
        this.ParsesOk("select a + + 1 from t where a + + 1", ArithmeticExpr.class);
        this.ParsesOk("select a + + + 1 from t where a + + + 1", ArithmeticExpr.class);
        this.ParsesOk("select +1.0 from t where +1.0", NumericLiteral.class);
        this.ParsesOk("select +-1.0 from t where +-1.0", NumericLiteral.class);
        this.ParsesOk("select +1.-0 from t where +1.-0", ArithmeticExpr.class);
        this.ParsesOk("select 8e6 from t where 8e6", NumericLiteral.class);
        this.ParsesOk("select +8e6 from t where +8e6", NumericLiteral.class);
        this.ParsesOk("select 8e+6 from t where 8e+6", NumericLiteral.class);
        this.ParsesOk("select -8e6 from t where -8e6", NumericLiteral.class);
        this.ParsesOk("select 8e-6 from t where 8e-6", NumericLiteral.class);
        this.ParsesOk("select -8e-6 from t where -8e-6", NumericLiteral.class);
        this.ParsesOk("select 4.5e2 from t where 4.5e2", NumericLiteral.class);
        this.ParsesOk("select +4.5e2 from t where +4.5e2", NumericLiteral.class);
        this.ParsesOk("select 4.5e+2 from t where 4.5e+2", NumericLiteral.class);
        this.ParsesOk("select -4.5e2 from t where -4.5e2", NumericLiteral.class);
        this.ParsesOk("select 4.5e-2 from t where 4.5e-2", NumericLiteral.class);
        this.ParsesOk("select -4.5e-2 from t where -4.5e-2", NumericLiteral.class);
        this.ParsesOk("select .7e9 from t where .7e9", NumericLiteral.class);
        this.ParsesOk("select +.7e9 from t where +.7e9", NumericLiteral.class);
        this.ParsesOk("select .7e+9 from t where .7e+9", NumericLiteral.class);
        this.ParsesOk("select -.7e9 from t where -.7e9", NumericLiteral.class);
        this.ParsesOk("select .7e-9 from t where .7e-9", NumericLiteral.class);
        this.ParsesOk("select -.7e-9 from t where -.7e-9", NumericLiteral.class);
        this.ParsesOk("select -+-1 from t where -+-1", NumericLiteral.class);
        this.ParsesOk("select - +- 1 from t where - +- 1", NumericLiteral.class);
        this.ParsesOk("select 1 + -+ 1 from t where 1 + -+ 1", ArithmeticExpr.class);
        this.ParsesOk("select true from t where true", BoolLiteral.class);
        this.ParsesOk("select false from t where false", BoolLiteral.class);
        this.ParsesOk("select date '2011-01-01'", DateLiteral.class);
        this.ParsesOk("select date '2011-1-01'", DateLiteral.class);
        this.ParsesOk("select date '2011-1-1'", DateLiteral.class);
        this.ParserError("select date '2011-001-1'");
        this.ParserError("select date '2011-01-001'");
        this.ParserError("select date '2011-oct-01'");
        this.ParserError("select date '2011-01-0'");
        this.ParserError("select date '2011-01-40'");
        this.ParserError("select date '2011-01-'");
        this.ParserError("select date '2011--01'");
        this.ParserError("select date '2001-02-31'");
        this.ParsesOk("select NULL from t where NULL", NullLiteral.class);
        this.ParserError("select --1");
        this.ParserError("select 1- from t");
        this.ParserError("select 1 + from t");
        this.ParserError("select /1 from t");
        this.ParserError("select *1 from t");
        this.ParserError("select &1 from t");
        this.ParserError("select =1 from t");
        this.ParsesOk("select 'five', 5, 5.0, i + 5 from t", StringLiteral.class);
        this.ParsesOk("select \"\\\"five\\\"\" from t\n", StringLiteral.class);
        this.ParsesOk("select \"'five'\" from t\n", StringLiteral.class);
        this.ParsesOk("select \"'five\" from t\n", StringLiteral.class);
        this.ParserError("select '5 from t");
        this.ParserError("select \"5 from t");
        this.ParserError("select '5 from t");
        this.ParserError("select `5 from t");
        this.ParserError("select \"\"five\"\" from t\n");
        this.ParserError("select 5.0.5 from t");
        this.testStringLiteral("\\0");
        this.testStringLiteral("\\\\");
        this.testStringLiteral("\\b");
        this.testStringLiteral("\\n");
        this.testStringLiteral("\\r");
        this.testStringLiteral("\\t");
        this.testStringLiteral("\\Z");
        this.testStringLiteral("\\%");
        this.testStringLiteral("\\\\%");
        this.testStringLiteral("\\_");
        this.testStringLiteral("\\\\_");
        this.testStringLiteral("\\0\\\\\\b\\n\\r\\t\\Z\\%\\\\%\\_\\\\_");
        this.testStringLiteral("a\\0b\\\\c\\bd\\ne\\rf\\tg\\Zh\\%i\\\\%j\\_k\\\\_l");
        this.testStringLiteral("\\a\\b\\c\\d\\1\\2\\3\\$\\&\\*");
        this.ParserError("select \"\\\" from t", "Syntax error in line 1:\nselect \"\\\" from t\n        ^\nEncountered: Unexpected character");
        this.ParserError("@", "Syntax error in line 1:\n@\n^\nEncountered: Unexpected character");
        this.ParsesOk("SELECT '@'");
    }

    private void testStringLiteral(String s) {
        String singleQuoteQuery = "select '" + s + "' from t";
        String doubleQuoteQuery = "select \"" + s + "\" from t";
        this.ParsesOk(singleQuoteQuery, StringLiteral.class);
        this.ParsesOk(doubleQuoteQuery, StringLiteral.class);
    }

    @Test
    public void TestFunctionCallExprs() {
        this.ParsesOk("select f1(5), f2('five'), f3(5.0, i + 5) from t");
        this.ParsesOk("select f1(true), f2(true and false), f3(null) from t");
        this.ParsesOk("select f1(*)");
        this.ParsesOk("select f1(distinct col)");
        this.ParsesOk("select f1(distinct col, col2)");
        this.ParsesOk("select decode(col, col2, col3)");
        Assert.assertEquals((Object)"SELECT if(col IS DISTINCT FROM col2, col, NULL) FROM t", (Object)this.ParsesOk("select nullif(col, col2) from t").toSql());
        Assert.assertEquals((Object)"SELECT if(col IS DISTINCT FROM col2, col, NULL) FROM t", (Object)this.ParsesOk("select _impala_builtins.nullif(col, col2) from t").toSql());
        this.ParserError("select f( from t");
        this.ParserError("select f(5.0 5.0) from t");
    }

    @Test
    public void TestArithmeticExprs() {
        for (String lop : operands_) {
            for (String rop : operands_) {
                for (ArithmeticExpr.Operator op : ArithmeticExpr.Operator.values()) {
                    String expr = null;
                    switch (op.getPos()) {
                        case BINARY_INFIX: {
                            expr = String.format("%s %s %s", lop, op.toString(), rop);
                            break;
                        }
                        case UNARY_POSTFIX: {
                            expr = String.format("%s %s", lop, op.toString());
                            break;
                        }
                        case UNARY_PREFIX: {
                            expr = String.format("%s %s", op.toString(), lop);
                            break;
                        }
                        default: {
                            Assert.fail((String)("Unknown operator kind: " + op.getPos()));
                        }
                    }
                    this.ParsesOk(String.format("select %s from t where %s", expr, expr));
                }
            }
        }
        this.ParserError("select (i + 5)(1 - i) from t");
        this.ParserError("select %a from t");
        this.ParserError("select *a from t");
        this.ParserError("select /a from t");
        this.ParserError("select &a from t");
        this.ParserError("select |a from t");
        this.ParserError("select ^a from t");
        this.ParserError("select a ~ a from t");
    }

    @Test
    public void TestFactorialPrecedenceAssociativity() {
        SelectStmt stmt = (SelectStmt)this.ParsesOk("SELECT 3 + 3!").getTopLevelNode();
        Expr e = ((SelectListItem)stmt.getSelectList().getItems().get(0)).getExpr();
        Assert.assertTrue((boolean)(e instanceof ArithmeticExpr));
        stmt = (SelectStmt)this.ParsesOk("SELECT 3! = 4").getTopLevelNode();
        e = ((SelectListItem)stmt.getSelectList().getItems().get(0)).getExpr();
        Assert.assertTrue((boolean)(e instanceof BinaryPredicate));
        BinaryPredicate bp = (BinaryPredicate)e;
        Assert.assertEquals((Object)BinaryPredicate.Operator.EQ, (Object)bp.getOp());
        Assert.assertEquals((long)2L, (long)bp.getChildren().size());
        stmt = (SelectStmt)this.ParsesOk("SELECT 3 != 4").getTopLevelNode();
        e = ((SelectListItem)stmt.getSelectList().getItems().get(0)).getExpr();
        Assert.assertTrue((boolean)(e instanceof BinaryPredicate));
        bp = (BinaryPredicate)e;
        Assert.assertEquals((Object)BinaryPredicate.Operator.NE, (Object)bp.getOp());
        Assert.assertEquals((long)2L, (long)bp.getChildren().size());
    }

    @Test
    public void TestTimestampArithmeticExprs() {
        for (TimestampArithmeticExpr.TimeUnit timeUnit : TimestampArithmeticExpr.TimeUnit.values()) {
            this.ParsesOk("select a + interval b " + timeUnit.toString());
            this.ParsesOk("select a - interval b " + timeUnit.toString());
            this.ParsesOk("select NULL + interval NULL " + timeUnit.toString());
            this.ParsesOk("select NULL - interval NULL " + timeUnit.toString());
            this.ParsesOk("select interval b " + timeUnit.toString() + " + a");
            this.ParsesOk("select interval NULL " + timeUnit.toString() + " + NULL");
            this.ParserError("select interval b " + timeUnit.toString() + " - a");
            this.ParsesOk("select date_add(a, interval b " + timeUnit.toString() + ")");
            this.ParsesOk("select date_sub(a, interval b " + timeUnit.toString() + ")");
            this.ParsesOk("select date_add(NULL, interval NULL " + timeUnit.toString() + ")");
            this.ParsesOk("select date_sub(NULL, interval NULL " + timeUnit.toString() + ")");
            this.ParsesOk("select error(a, interval b " + timeUnit.toString() + ")");
            this.ParsesOk("select error(a, interval b error)");
            this.ParserError("select date_add(a, b " + timeUnit.toString() + ")");
            this.ParserError("select date_sub(a, b " + timeUnit.toString() + ")");
            this.ParserError("select date_sub(distinct NULL, interval NULL " + timeUnit.toString() + ")");
            this.ParserError("select date_sub(*, interval NULL " + timeUnit.toString() + ")");
        }
        this.ParsesOk("select a + interval b years + interval c months + interval d days");
        this.ParsesOk("select a - interval b years - interval c months - interval d days");
        this.ParsesOk("select a + interval b years - interval c months + interval d days");
        this.ParsesOk("select interval b years + a + interval c months + interval d days");
        this.ParsesOk("select interval b years + a - interval c months - interval d days");
        this.ParsesOk("select interval b years + a - interval c months + interval d days");
        this.ParserError("select date_sub(a, c, interval b year)");
        this.ParserError("select date_sub(a, interval b year, c)");
    }

    @Test
    public void TestCaseExprs() {
        this.ParsesOk("select case a when '5' then x when '6' then y else z end from t");
        this.ParsesOk("select case when 'a' then x when false then y else z end from t");
        this.ParsesOk("select case when a > 2 then x when false then false else true end from t");
        this.ParsesOk("select case false when a > 2 then x when '6' then false else true end from t");
        this.ParsesOk("select case NULL when NULL then NULL when NULL then NULL else NULL end from t");
        this.ParsesOk("select case when NULL then NULL when NULL then NULL else NULL end from t");
        this.ParserError("select case a when true then x when false then y else z from t");
        this.ParserError("select case a when true when false then y else z end from t");
        this.ParserError("select case a when true, false then y else z end from t");
    }

    @Test
    public void TestCastExprs() {
        this.ParsesOk("select cast(a + 5.0 as string) from t");
        this.ParsesOk("select cast(NULL as string) from t");
        this.ParsesOk("select cast('05-01-2017' as timestamp format 'MM-dd-yyyy')");
        this.ParsesOk("select cast('2017.01.02' as date format 'YYYY-MM-DD')");
        this.ParserError("select cast(a + 5.0 as badtype) from t");
        this.ParserError("select cast(a + 5.0, string) from t");
        this.ParserError("select cast('05-01-2017' as timestamp format 12345)");
        this.ParserError("select cast('05-01-2017' as timestamp format )");
        this.ParserError("select cast('05-01-2017' as timestamp format NULL)");
        this.ParserError("select cast('05-01-2017' as date format NULL)");
    }

    @Test
    public void TestConditionalExprs() {
        this.ParsesOk("select if(TRUE, TRUE, FALSE) from t");
        this.ParsesOk("select if(NULL, NULL, NULL) from t");
        this.ParsesOk("select c1, c2, if(TRUE, TRUE, FALSE) from t");
        this.ParsesOk("select if(1 = 2, c1, c2) from t");
        this.ParsesOk("select if(1 = 2, c1, c2)");
        this.ParserError("select if()");
    }

    @Test
    public void TestAggregateExprs() {
        this.ParsesOk("select count(*), count(a), count(distinct a, b) from t");
        this.ParsesOk("select count(NULL), count(TRUE), count(FALSE), count(distinct TRUE, FALSE, NULL) from t");
        this.ParsesOk("select count(all *) from t");
        this.ParsesOk("select count(all 1) from t");
        this.ParsesOk("select min(a), min(distinct a) from t");
        this.ParsesOk("select max(a), max(distinct a) from t");
        this.ParsesOk("select sum(a), sum(distinct a) from t");
        this.ParsesOk("select avg(a), avg(distinct a) from t");
        this.ParsesOk("select distinct a, b, c from t");
        this.ParsesOk("select distinctpc(a), distinctpc(distinct a) from t");
        this.ParsesOk("select distinctpcsa(a), distinctpcsa(distinct a) from t");
        this.ParsesOk("select ndv(a), ndv(distinct a) from t");
        this.ParsesOk("select group_concat(a) from t");
        this.ParsesOk("select group_concat(a, ', ') from t");
        this.ParsesOk("select group_concat(a, ', ', c) from t");
    }

    @Test
    public void TestAnalyticExprs() {
        this.ParsesOk("select sum(v) over (partition by a, 2*b order by 3*c rows between 2+2 preceding and 2-2 following) from t");
        this.ParsesOk("select sum(v) over (order by 3*c rows between unbounded preceding and unbounded following) from t");
        this.ParsesOk("select sum(v) over (partition by a, 2*b) from t");
        this.ParsesOk("select sum(v) over (partition by a, 2*b order by 3*c range between unbounded preceding and unbounded following) from t");
        this.ParsesOk("select sum(v) over (order by 3*c range between 2 following and 4 following) from t");
        this.ParsesOk("select sum(v) over (partition by a, 2*b) from t");
        this.ParsesOk("select 2 * x, sum(v) over (partition by a, 2*b order by 3*c rows between 2+2 preceding and 2-2 following), rank() over (), y from t");
        this.ParserError("select v over (partition by a, 2*b order by 3*c rows between 2 preceding and 2 following) from t");
        this.ParserError("select sum(v) over (partition a, 2*b order by 3*c rows between unbounded preceding and current row) from t");
        this.ParserError("select sum(v) over (partition by a, 2*b order 3*c rows between 2 preceding and 2 following) from t");
        this.ParserError("select sum(v) over (partition by a, 2*b order by 3*c rows 2 preceding and 2 following) from t");
        this.ParsesOk("select sum(v) over (partition by a, 2*b) from t");
        this.ParserError("select decode(1, 2, 3) over () from t");
    }

    @Test
    public void TestPredicates() {
        ArrayList<String> operations = new ArrayList<String>();
        for (BinaryPredicate.Operator op : BinaryPredicate.Operator.values()) {
            operations.add(op.toString());
        }
        operations.add("like");
        operations.add("ilike");
        operations.add("rlike");
        operations.add("regexp");
        operations.add("iregexp");
        ArrayList<String> boolTestVals = new ArrayList<String>();
        boolTestVals.add("null");
        boolTestVals.add("unknown");
        boolTestVals.add("true");
        boolTestVals.add("false");
        for (String lop : operands_) {
            for (String rop : operands_) {
                for (String op : operations) {
                    String expr = String.format("%s %s %s", lop, op.toString(), rop);
                    this.ParsesOk(String.format("select %s from t where %s", expr, expr));
                }
            }
            for (String val : boolTestVals) {
                String isExpr = String.format("%s is %s", lop, val);
                String isNotExpr = String.format("%s is not %s", lop, val);
                this.ParsesOk(String.format("select %s from t where %s", isExpr, isExpr));
                this.ParsesOk(String.format("select %s from t where %s", isNotExpr, isNotExpr));
            }
            this.ParserError(String.format("select %s is nonsense", lop));
            this.ParserError(String.format("select %s is not nonsense", lop));
        }
    }

    private void testCompoundPredicates(String andStr, String orStr, String notStr) {
        this.ParsesOk("select a, b, c from t where a = 5 " + andStr + " f(b)");
        this.ParsesOk("select a, b, c from t where a = 5 " + orStr + " f(b)");
        this.ParsesOk("select a, b, c from t where (a = 5 " + orStr + " f(b)) " + andStr + " c = 7");
        this.ParsesOk("select a, b, c from t where " + notStr + "a = 5");
        this.ParsesOk("select a, b, c from t where " + notStr + "f(a)");
        this.ParsesOk("select a, b, c from t where (" + notStr + "a = 5 " + orStr + " " + notStr + "f(b)) " + andStr + " " + notStr + "c = 7");
        this.ParsesOk("select a, b, c from t where (" + notStr + "(" + notStr + "a = 5))");
        this.ParsesOk("select a, b, c from t where (" + notStr + "(" + notStr + "f(a)))");
        this.ParsesOk("select a, b, c from t where a = " + notStr + "5");
        this.ParserError("select a, b, c from t where (a = 5 " + orStr + " b = 6) " + andStr + " c = 7)");
        this.ParserError("select a, b, c from t where ((a = 5 " + orStr + " b = 6) " + andStr + " c = 7");
        this.ParserError("select a, b, c from t where a = 5 " + orStr + " " + notStr);
        this.ParserError("select a, b, c from t where " + notStr + "(a = 5) " + orStr + " " + notStr);
    }

    private void testLiteralTruthValues(String andStr, String orStr, String notStr) {
        String[] truthValues;
        for (String l : truthValues = new String[]{"true", "false", "null"}) {
            for (String r : truthValues) {
                String andExpr = String.format("%s %s %s", l, andStr, r);
                String orExpr = String.format("%s %s %s", l, orStr, r);
                this.ParsesOk(String.format("select %s from t where %s", andExpr, andExpr));
                this.ParsesOk(String.format("select %s from t where %s", orExpr, orExpr));
            }
            String notExpr = String.format("%s %s", notStr, l);
            this.ParsesOk(String.format("select %s from t where %s", notExpr, notExpr));
        }
    }

    @Test
    public void TestCompoundPredicates() {
        String[] andStrs = new String[]{"and", "&&"};
        String[] orStrs = new String[]{"or", "||"};
        String[] notStrs = new String[]{"!", "not "};
        for (String andStr : andStrs) {
            for (String orStr : orStrs) {
                for (String notStr : notStrs) {
                    this.testCompoundPredicates(andStr, orStr, notStr);
                    this.testLiteralTruthValues(andStr, orStr, notStr);
                }
            }
        }
        for (String notStr : notStrs) {
            SelectStmt stmt = (SelectStmt)this.ParsesOk(String.format("select %s a != b", notStr)).getTopLevelNode();
            Expr e = ((SelectListItem)stmt.getSelectList().getItems().get(0)).getExpr();
            Assert.assertTrue((boolean)(e instanceof CompoundPredicate));
            CompoundPredicate cp = (CompoundPredicate)e;
            Assert.assertEquals((Object)CompoundPredicate.Operator.NOT, (Object)cp.getOp());
            Assert.assertEquals((long)1L, (long)cp.getChildren().size());
            Assert.assertTrue((boolean)(cp.getChild(0) instanceof BinaryPredicate));
        }
    }

    @Test
    public void TestBetweenPredicate() {
        this.ParsesOk("select a, b, c from t where i between x and y");
        this.ParsesOk("select a, b, c from t where i not between x and y");
        this.ParsesOk("select a, b, c from t where true not between false and NULL");
        this.ParsesOk("select a, b, c from t where 'abc' between 'a' like 'a' and 'b' like 'b'");
        this.ParsesOk("select a, b, c from t where true and false and i between x and y");
        this.ParsesOk("select a, b, c from t where i between x and y and true and false");
        this.ParsesOk("select a, b, c from t where i between x and (y and true) and false");
        this.ParsesOk("select a, b, c from t where i between x and (y and (true and false))");
        this.ParsesOk("select a, b, c from t where true between false and true and 'b' between 'a' and 'c'");
        this.ParsesOk("select a, b, c from t where true between 'b' between 'a' and 'c' and 'bb' between 'aa' and 'cc'");
        this.ParserError("select a, b, c from t where between 5 and 10");
        this.ParserError("select a, b, c from t where i between and 10");
        this.ParserError("select a, b, c from t where i between 5 and");
        this.ParserError("select a, b, c from t where i between");
        this.ParserError("select a, b, c from t where true between 5 or 10 and 20");
    }

    @Test
    public void TestInPredicate() {
        this.ParsesOk("select a, b, c from t where i in (x, y, z)");
        this.ParsesOk("select a, b, c from t where i not in (x, y, z)");
        this.ParsesOk("select a, b, c from t where NULL in (NULL, NULL, NULL)");
        this.ParsesOk("select a, b, c from t where true in (true, false, true)");
        this.ParsesOk("select a, b, c from t where NULL not in (NULL, NULL, NULL)");
        this.ParsesOk("select a, b, c from t where true not in (true, false, true)");
        this.ParserError("select a, b, c from t where in (x, y, z)");
        this.ParserError("select a, b, c from t where i in x, y, z");
        this.ParserError("select a, b, c from t where i in (x, y, z");
        this.ParserError("select a, b, c from t where i in x, y, z)");
        this.ParserError("select a, b, c from t where i in");
        this.ParserError("select a, b, c from t where i in ( )");
    }

    @Test
    public void TestSlotRef() {
        this.ParsesOk("select a from t where b > 5");
        this.ParsesOk("select a.b from a where b > 5");
        this.ParsesOk("select a.b.c from a.b where b > 5");
        this.ParsesOk("select a.b.c.d from a.b where b > 5");
    }

    private void testInsert() {
        for (String qualifier : new String[]{"overwrite", "into"}) {
            for (String optTbl : new String[]{"", "table"}) {
                this.ParsesOk(String.format("insert %s %s t select a from src where b > 5", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t partition (pk1=10) select a from src where b > 5", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t partition (pk1) select a from src where b > 5", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t partition (pk1=10, pk2=20) select a from src where b > 5", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t partition (pk1, pk2) select a from src where b > 5", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t partition (pk1=10, pk2) select a from src where b > 5", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t partition (pk1, pk2=20) select a from src where b > 5", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t partition (pk1=NULL, pk2=NULL) select a from src where b > 5", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t partition (pk1=false, pk2=true) select a from src where b > 5", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t partition (pk1=abc, pk2=(5*8+10)) select a from src where b > 5", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t partition (pk1=f(a), pk2=!true and false) select a from src where b > 5", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t(a,b,c) values(1,2,3)", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t(a,b,c) values(1,2,3,4,5,6)", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t(a,b,c) partition(d) values(1,2,3,4)", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t() select 1 from a", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t() partition(d) ", qualifier, optTbl));
                this.ParsesOk(String.format("insert %s %s t() ", qualifier, optTbl));
                this.ParserError(String.format("insert %s %s t(a b c) select 1 from a", qualifier, optTbl));
                this.ParserError(String.format("insert %s %s t('a') select 1 from a", qualifier, optTbl));
                this.ParserError(String.format("insert %s %s t(a=1, b) select 1 from a", qualifier, optTbl));
            }
        }
    }

    @Test
    public void TestInsert() {
        this.testInsert();
        this.ParserError("insert into table t");
        this.ParserError("insert table t select a from src where b > 5");
        this.ParserError("insert overwrite table select a from src where b > 5");
        this.ParserError("insert into table select a from src where b > 5");
        this.ParserError("insert overwrite table t");
        this.ParserError("insert into table t");
        this.ParserError("insert overwrite table t partition pk1=10 select a from src where b > 5");
        this.ParserError("insert into table t partition pk1=10 select a from src where b > 5");
        this.ParserError("insert overwrite table t partition (pk1=10 pk2=20) select a from src where b > 5");
        this.ParserError("insert into table t partition (pk1=10 pk2=20) select a from src where b > 5");
        this.ParserError("insert [shuffle] into table t partition (pk1=10 pk2=20) select a from src where b > 5");
        this.ParserError("insert into [shuffle] table t partition (pk1=10 pk2=20) select a from src where b > 5");
        this.ParserError("insert into table t [shuffle] partition (pk1=10 pk2=20) select a from src where b > 5");
        this.ParserError("insert into table t partition [shuffle] (pk1=10 pk2=20) select a from src where b > 5");
    }

    @Test
    public void TestUpsert() {
        for (String optTbl : new String[]{"", "table"}) {
            this.ParsesOk(String.format("upsert into %s t select a from src", optTbl));
            this.ParsesOk(String.format("upsert into %s t values (1, 2, 3)", optTbl));
            this.ParsesOk(String.format("upsert into %s t (a,b,c) values(1,2,3)", optTbl));
            this.ParsesOk(String.format("upsert into %s t (a,b,c) values(1,2,3,4,5,6)", optTbl));
            this.ParsesOk(String.format("upsert into %s t () select 1 from a", optTbl));
            this.ParsesOk(String.format("upsert into %s t () ", optTbl));
            this.ParsesOk(String.format("with x as (select a from src where b > 5) upsert into %s t select * from x", optTbl));
            this.ParserError(String.format("upsert into %s t", optTbl));
            this.ParserError(String.format("upsert %s t select a from src where b > 5", optTbl));
            this.ParserError(String.format("upsert into %s select a from src where b > 5", optTbl));
            this.ParserError(String.format("upsert %s t(a b c) select 1 from a", optTbl));
            this.ParserError(String.format("upsert %s t('a') select 1 from a", optTbl));
            this.ParserError(String.format("upsert %s t(a=1, b) select 1 from a", optTbl));
            this.ParserError(String.format("upsert ignore into %s t select a from src", optTbl));
            this.ParserError(String.format("upsert into %s t partition (pk1=10) select a from src", optTbl));
            this.ParserError(String.format("upsert overwrite %s t select 1 from src", optTbl));
        }
    }

    @Test
    public void TestUpdate() {
        this.ParsesOk("update t set x = 3 where a < b");
        this.ParsesOk("update t set x = (3 + length(\"hallo\")) where a < 'adasas'");
        this.ParsesOk("update t set x = 3");
        this.ParsesOk("update t set x=3, x=4 from a.b t where b = 10");
        this.ParserError("update t");
        this.ParserError("update t set x < 3");
        this.ParserError("update t set x");
        this.ParserError("update t set 4 = x");
        this.ParserError("update from t set x = 3");
        this.ParserError("update t where x = 4");
        this.ParserError("update t a set a = 10  where x = 4");
        this.ParserError("update t a from t b where set a = 10 x = 4");
    }

    @Test
    public void TestKuduUpdate() {
        this.ParserError("update (select * from functional_kudu.testtbl) a set name = '10'");
    }

    @Test
    public void TestDelete() {
        this.ParsesOk("delete from t");
        this.ParsesOk("delete a from t a");
        this.ParsesOk("delete a from t a join b on a.id = b.id where true");
        this.ParsesOk("delete a from t a join b where true");
        this.ParsesOk("delete t from t");
        this.ParsesOk("delete t from t where a < b");
        this.ParsesOk("delete a from t a where a < b");
        this.ParsesOk("delete FROM t where a < b");
        this.ParsesOk("delete t where a < b");
        this.ParsesOk("delete t");
        this.ParserError("delete t join f on t.id = f.id");
    }

    @Test
    public void TestOptimize() {
        this.ParsesOk("optimize table t");
        this.ParsesOk("optimize table t (file_size_threshold_mb=10)");
        this.ParsesOk("optimize table t (file_size_threshold_mb=0)");
        this.ParserError("optimize table t file_size_threshold_mb=10");
        this.ParserError("optimize table t file_size_threshold_mb 10");
        this.ParserError("optimize table t (file_size_threshold_mb=-10)");
        this.ParserError("optimize table t (file_size_threshold_mb=0.1)");
        this.ParserError("optimize table t 10");
        this.ParserError("optimize t");
        this.ParserError("optimize table t for system_time as of now()");
        this.ParserError("optimize table t for system_version as of 12345");
    }

    @Test
    public void TestMerge() {
        this.ParsesOk("merge into t using s on t.id = s.id when matched then update set t.a = s.a");
        this.ParsesOk("merge into target t using source s on t.id = s.id when matched then update set t.a = s.a");
        this.ParsesOk("merge into t using s on t.id = s.id when matched then delete");
        this.ParsesOk("merge into t using s on t.id = s.id when not matched then insert (a,b,c) values (a,b,c)");
        this.ParsesOk("merge into t using s on t.id = s.id when matched and t.a > s.b then delete");
        this.ParsesOk("merge into t using s on t.id = s.id when matched and t.a > s.b or t.b < s.c then update set t.a = s.a");
        this.ParsesOk("merge into t using s on t.id = s.id when matched and t.a > s.b or t.b < s.c then update set t.a = s.a when not matched then insert (a,b,c) values (a,b,c)");
        this.ParsesOk("merge into t using s on t.id = s.id when matched and t.a > s.b or t.b < s.c then update set t.a = s.a when not matched then insert (a,b,c) values (a,b,c) when matched then delete");
        this.ParsesOk("merge into t using (select a, b, c, d, id) as s on t.id = s.id when matched and t.a > s.b or t.b < s.c then update set t.a = s.a when matched then update set t.a = s.a when not matched then insert (a,b,c) values (a,b,c)");
        this.ParsesOk("merge into t using (select id from s) s on t.id = s.id when matched then update set t.a = s.a");
        this.ParsesOk("merge into t using s on t.id = s.id when matched then update set t.a = s.a");
        this.ParsesOk("merge into t using s on t.id = s.id when not matched then insert values(a,b,c)");
        this.ParsesOk("merge into t using s on t.id = s.id when not matched by target then insert values(a,b,c)");
        this.ParsesOk("merge into t using s on t.id = s.id when not matched by target and t.a > 10 then insert values(a,b,c)");
        this.ParsesOk("merge into t using s on t.id = s.id when not matched by source then delete");
        this.ParsesOk("merge into t using s on t.id = s.id when not matched by source and funcn(a) > 10 then delete");
        this.ParsesOk("merge into t using s on t.id = s.id when not matched by source then update set b = 12");
        this.ParsesOk("merge into t using s on t.id = s.id when not matched by source and func(b) != func(a) then update set b = 12");
        this.ParsesOk("merge into t using s on t.id = s.id when not matched then insert *");
        this.ParsesOk("merge into t using s on t.id = s.id when not matched and i > 10 then insert *");
        this.ParsesOk("merge into t using s on t.id = s.id when matched then update set *");
        this.ParsesOk("merge into t using s on t.id = s.id when matched and i > 10 then update set *");
        this.ParserError("merge into t using s on t.id = s.id when matched and t.a > s.b then delete from");
        this.ParserError("merge into t using s on t.id = s.id when matched and t.a > s.b then insert (a,b,c) values (a,b,c)");
        this.ParserError("merge into t using s on t.id = s.id when not matched and t.a > s.b then update set a = b");
        this.ParserError("merge into t using s on t.id = s.id when not matched and t.a > s.b then delete");
        this.ParserError("merge into t using s on t.id = s.id when not matched by target then delete");
        this.ParserError("merge into t using s on t.id = s.id when not matched by target and a = 1 then delete");
        this.ParserError("merge into t using s on t.id = s.id when not matched by target then update set b = a");
        this.ParserError("merge into t using s on t.id = s.id when not matched by target and x = y then update set b = a, c = d");
        this.ParserError("merge into t using s on t.id = s.id when not matched by source then insert values (1, 2, 3)");
        this.ParserError("merge into t using s on t.id = s.id when not matched by source and a <> b then insert values (1, 2, 3)");
        this.ParserError("merge into t using s on t.id = s.id when not matched and i > 10 then update *");
        this.ParserError("merge into t using s on t.id = s.id when matched and i > 10 then insert *");
        this.ParserError("merge into target t using (select * from source) s on t.id = s.id when not matched then insert (t.id, t.a, t.b) values(id, a, b)");
        this.ParserError("merge into target t using (select * from source) s on t.id = s.id when not matched then insert (t.id, t.a, t.b) values(id, a, b), (a,b,c)");
    }

    @Test
    public void TestUse() {
        this.ParserError("USE");
        this.ParserError("USE db1 db2");
        this.ParsesOk("USE db1");
    }

    @Test
    public void TestShow() {
        this.ParsesOk("SHOW TABLES");
        this.ParsesOk("SHOW VIEWS");
        this.ParsesOk("SHOW TABLES 'tablename|othername'");
        this.ParsesOk("SHOW VIEWS 'tablename|othername'");
        this.ParsesOk("SHOW TABLES LIKE 'tablename|othername'");
        this.ParsesOk("SHOW VIEWS LIKE 'tablename|othername'");
        this.ParsesOk("SHOW TABLES IN db LIKE 'tablename|othername'");
        this.ParsesOk("SHOW VIEWS IN db LIKE 'tablename|othername'");
        this.ParsesOk("SHOW TABLES ''");
        this.ParsesOk("SHOW VIEWS ''");
        this.ParsesOk("SHOW METADATA TABLES IN tbl");
        this.ParsesOk("SHOW METADATA TABLES IN tbl 'e*'");
        this.ParsesOk("SHOW METADATA TABLES IN tbl LIKE 'e*'");
        this.ParsesOk("SHOW METADATA TABLES IN db.tbl");
        this.ParsesOk("SHOW METADATA TABLES IN db.tbl 'e*'");
        this.ParsesOk("SHOW METADATA TABLES IN db.tbl LIKE 'e*'");
        this.ParsesOk("SHOW DATABASES");
        this.ParsesOk("SHOW SCHEMAS");
        this.ParsesOk("SHOW DATABASES LIKE 'pattern'");
        this.ParsesOk("SHOW SCHEMAS LIKE 'p*ttern'");
        this.ParsesOk("SHOW DATA SOURCES");
        this.ParsesOk("SHOW DATA SOURCES 'pattern'");
        this.ParsesOk("SHOW DATA SOURCES LIKE 'pattern'");
        this.ParsesOk("SHOW DATA SOURCES LIKE 'p*ttern'");
        for (String fnType : new String[]{"", "AGGREGATE", "ANALYTIC"}) {
            this.ParsesOk(String.format("SHOW %s FUNCTIONS", fnType));
            this.ParsesOk(String.format("SHOW %s FUNCTIONS LIKE 'pattern'", fnType));
            this.ParsesOk(String.format("SHOW %s FUNCTIONS LIKE 'p*ttern'", fnType));
            this.ParsesOk(String.format("SHOW %s FUNCTIONS", fnType));
            this.ParsesOk(String.format("SHOW %s FUNCTIONS in DB LIKE 'pattern'", fnType));
            this.ParsesOk(String.format("SHOW %s FUNCTIONS in DB", fnType));
        }
        this.ParsesOk("SHOW TABLE STATS tbl");
        this.ParsesOk("SHOW TABLE STATS db.tbl");
        this.ParsesOk("SHOW TABLE STATS `db`.`tbl`");
        this.ParsesOk("SHOW COLUMN STATS tbl");
        this.ParsesOk("SHOW COLUMN STATS db.tbl");
        this.ParsesOk("SHOW COLUMN STATS `db`.`tbl`");
        this.ParsesOk("SHOW PARTITIONS tbl");
        this.ParsesOk("SHOW PARTITIONS db.tbl");
        this.ParsesOk("SHOW PARTITIONS `db`.`tbl`");
        this.ParsesOk("SHOW RANGE PARTITIONS tbl");
        this.ParsesOk("SHOW RANGE PARTITIONS db.tbl");
        this.ParsesOk("SHOW RANGE PARTITIONS `db`.`tbl`");
        this.ParsesOk("SHOW FILES IN tbl");
        this.ParsesOk("SHOW FILES IN db.tbl");
        this.ParsesOk("SHOW FILES IN `db`.`tbl`");
        this.ParsesOk("SHOW FILES IN db.tbl PARTITION(x='a',y='b')");
        this.ParserError("SHOW");
        this.ParserError("SHOW TABLES tablename");
        this.ParserError("SHOW VIEWS tablename");
        this.ParserError("SHOW TABLES IN db.tbl");
        this.ParserError("SHOW METADATA TABLES IN db.tbl.files");
        this.ParserError("SHOW DATA");
        this.ParserError("SHOW SOURCE");
        this.ParserError("SHOW DATA SOURCE LIKE NotStrLiteral");
        this.ParserError("SHOW UNKNOWN FUNCTIONS");
        this.ParserError("SHOW STATS tbl");
        this.ParserError("SHOW TABLE STATS");
        this.ParserError("SHOW COLUMN STATS");
        this.ParserError("SHOW TABLE STATS 'strlit'");
        this.ParserError("SHOW FILES IN");
        this.ParsesOk("SHOW FILES IN db.tbl PARTITION(p)");
    }

    @Test
    public void TestShowCreateTable() {
        this.ParsesOk("SHOW CREATE TABLE x");
        this.ParsesOk("SHOW CREATE TABLE db.x");
        this.ParserError("SHOW CREATE TABLE");
        this.ParserError("SHOW CREATE TABLE x y z");
    }

    @Test
    public void TestDescribeDb() {
        this.ParserError("DESCRIBE DATABASE");
        this.ParserError("DESCRIBE DATABASE FORMATTED");
        this.ParserError("DESCRIBE DATABASE EXTENDED");
        this.ParsesOk("DESCRIBE DATABASE databasename");
        this.ParsesOk("DESCRIBE DATABASE FORMATTED databasename");
        this.ParsesOk("DESCRIBE DATABASE EXTENDED databasename");
    }

    @Test
    public void TestDescribeTable() {
        this.ParserError("DESCRIBE");
        this.ParserError("DESCRIBE FORMATTED");
        this.ParserError("DESCRIBE EXTENDED");
        this.ParsesOk("DESCRIBE tablename");
        this.ParsesOk("DESCRIBE FORMATTED tablename");
        this.ParsesOk("DESCRIBE EXTENDED tablename");
        this.ParsesOk("DESCRIBE databasename.tablename");
        this.ParsesOk("DESCRIBE FORMATTED databasename.tablename");
        this.ParsesOk("DESCRIBE EXTENDED databasename.tablename");
        this.ParsesOk("DESCRIBE databasename.tablename.field1");
        this.ParsesOk("DESCRIBE databasename.tablename.field1.field2");
        this.ParsesOk("DESCRIBE FORMATTED databasename.tablename.field1");
        this.ParsesOk("DESCRIBE FORMATTED databasename.tablename.field1.field2");
        this.ParsesOk("DESCRIBE EXTENDED databasename.tablename.field1");
        this.ParsesOk("DESCRIBE EXTENDED databasename.tablename.field1.field2");
    }

    @Test
    public void TestDescribeHistory() {
        this.ParsesOk("DESCRIBE HISTORY tablename");
        this.ParsesOk("DESCRIBE HISTORY databasename.tablename");
        this.ParserError("DESCRIBE EXTENDED HISTORY tablename");
        this.ParserError("DESCRIBE FORMATTED HISTORY tablename");
    }

    @Test
    public void TestCreateDatabase() {
        String[] dbKeywords;
        for (String kw : dbKeywords = new String[]{"DATABASE", "SCHEMA"}) {
            this.ParsesOk(String.format("CREATE %s Foo", kw));
            this.ParsesOk(String.format("CREATE %s IF NOT EXISTS Foo", kw));
            this.ParsesOk(String.format("CREATE %s Foo COMMENT 'Some comment'", kw));
            this.ParsesOk(String.format("CREATE %s Foo LOCATION '/hdfs_location'", kw));
            this.ParsesOk(String.format("CREATE %s Foo LOCATION '/hdfs_location'", kw));
            this.ParsesOk(String.format("CREATE %s Foo COMMENT 'comment' LOCATION '/hdfs_location'", kw));
            this.ParserError(String.format("CREATE %s Foo COMMENT mytable", kw));
            this.ParserError(String.format("CREATE %s Foo LOCATION /hdfs_location", kw));
            this.ParserError(String.format("CREATE %s Foo LOCATION '/hdfs/location' COMMENT 'comment'", kw));
            this.ParserError(String.format("CREATE %s Foo COMMENT LOCATION '/hdfs_location'", kw));
            this.ParserError(String.format("CREATE %s Foo LOCATION", kw));
            this.ParserError(String.format("CREATE %s Foo LOCATION 'dfsd' 'dafdsf'", kw));
            this.ParserError(String.format("CREATE Foo", new Object[0]));
            this.ParserError(String.format("CREATE %s 'Foo'", kw));
            this.ParserError(String.format("CREATE %s", kw));
            this.ParserError(String.format("CREATE %s IF EXISTS Foo", kw));
            this.ParserError(String.format("CREATE %sS Foo", kw));
        }
    }

    @Test
    public void TestCreateFunction() {
        this.ParsesOk("CREATE FUNCTION Foo() RETURNS INT LOCATION 'f.jar' SYMBOL='class.Udf'");
        this.ParsesOk("CREATE FUNCTION Foo(INT, INT) RETURNS STRING LOCATION 'f.jar' SYMBOL='class.Udf'");
        this.ParsesOk("CREATE FUNCTION Foo(INT, DOUBLE) RETURNS STRING LOCATION 'f.jar' SYMBOL='class.Udf'");
        this.ParsesOk("CREATE FUNCTION Foo() RETURNS STRING LOCATION 'f.jar' SYMBOL='class.Udf' COMMENT='hi'");
        this.ParsesOk("CREATE FUNCTION IF NOT EXISTS Foo() RETURNS INT LOCATION 'foo.jar' SYMBOL='class.Udf'");
        this.ParsesOk("CREATE FUNCTION foo LOCATION 'f.jar' SYMBOL='class.Udf'");
        this.ParsesOk("CREATE FUNCTION db.foo LOCATION 'f.jar' SYMBOL='class.Udf'");
        this.ParsesOk("CREATE FUNCTION IF NOT EXISTS foo LOCATION 'f.jar' SYMBOL='class.Udf'");
        this.ParsesOk("CREATE FUNCTION IF NOT EXISTS db.foo LOCATION 'f.jar' SYMBOL='class.Udf'");
        this.ParsesOk("CREATE FUNCTION User.Foo() RETURNS INT LOCATION 'a'");
        this.ParsesOk("CREATE FUNCTION `Foo`() RETURNS INT LOCATION 'a'");
        this.ParsesOk("CREATE FUNCTION `Foo.Bar`() RETURNS INT LOCATION 'a'");
        this.ParsesOk("CREATE FUNCTION `Foo`.Bar() RETURNS INT LOCATION 'a'");
        this.ParserError("CREATE FUNCTION User.() RETURNS INT LOCATION 'a'");
        this.ParserError("CREATE FUNCTION User.Foo.() RETURNS INT LOCATION 'a'");
        this.ParserError("CREATE FUNCTION User..Foo() RETURNS INT LOCATION 'a'");
        this.ParserError("CREATE FUNCTION Foo() LOCATION 'a.jar' SYMBOL='class.Udf");
        this.ParsesOk("CREATE FUNCTION A.B.C.D.Foo() RETURNS INT LOCATION 'a'");
        this.ParserError("CREATE FUNCTION FOO() RETURNS INT");
        this.ParserError("CREATE FUNCTION FOO() LOCATION 'foo.jar'");
        this.ParserError("CREATE FUNCTION Foo() RETURNS INT SYMBOL='1' LOCATION 'a'");
        this.ParserError("CREATE FUNCTION Foo() RETURNS INT LOCATION 'a' SYMBOL");
        this.ParserError("CREATE FUNCTION Foo() RETURNS INT LOCATION 'a' SYMBOL='1' SYMBOL='2'");
        this.ParserError("CREATE FUNCTION IF NOT EXISTS db.foo LOCATION 'f.jar' SYMBOL='1' SYMBOL='2'");
        this.ParserError("CREATE FUNCTION Foo RETURNS INT LOCATION 'f.jar'");
        this.ParserError("CREATE FUNCTION Foo(INT,) RETURNS INT LOCATION 'f.jar'");
        this.ParserError("CREATE FUNCTION FOO RETURNS INT LOCATION 'foo.jar'");
        this.ParserError("CREATE FUNCTION Foo(NULL) RETURNS INT LOCATION 'f.jar'");
        this.ParserError("CREATE FUNCTION Foo(NULL, INT) RETURNS INT LOCATION 'f.jar'");
        this.ParserError("CREATE FUNCTION Foo(INT, NULL) RETURNS INT LOCATION 'f.jar'");
        this.ParserError("CREATE FUNCTION Foo() RETURNS NULL LOCATION 'f.jar'");
    }

    @Test
    public void TestVariadicCreateFunctions() {
        String[] fnCreates;
        for (String fnCreate : fnCreates = new String[]{"CREATE FUNCTION ", "CREATE AGGREGATE FUNCTION "}) {
            this.ParsesOk(fnCreate + "Foo(int...) RETURNS INT LOCATION 'f.jar'");
            this.ParsesOk(fnCreate + "Foo(int ...) RETURNS INT LOCATION 'f.jar'");
            this.ParsesOk(fnCreate + "Foo(int, double ...) RETURNS INT LOCATION 'f.jar'");
            this.ParserError(fnCreate + "Foo(...) RETURNS INT LOCATION 'f.jar'");
            this.ParserError(fnCreate + "Foo(int..., double) RETURNS INT LOCATION 'f.jar'");
            this.ParserError(fnCreate + "Foo(int) RETURNS INT... LOCATION 'f.jar'");
            this.ParserError(fnCreate + "Foo(int. . .) RETURNS INT... LOCATION 'f.jar'");
            this.ParserError(fnCreate + "Foo(int, ...) RETURNS INT... LOCATION 'f.jar'");
        }
    }

    @Test
    public void TestCreateAggregate() {
        String loc = " LOCATION 'f.so' UPDATE_FN='class' ";
        String c = "CREATE AGGREGATE FUNCTION Foo() RETURNS INT ";
        this.ParsesOk(c + loc);
        this.ParsesOk(c + "INTERMEDIATE STRING" + loc + "comment='c'");
        this.ParsesOk(c + loc + "comment='abcd'");
        this.ParsesOk(c + loc + "init_fn='InitFnSymbol'");
        this.ParsesOk(c + loc + "init_fn='I' merge_fn='M'");
        this.ParsesOk(c + loc + "merge_fn='M' init_fn='I'");
        this.ParsesOk(c + loc + "merge_fn='M' Init_fn='I' serialize_fn='S' Finalize_fn='F'");
        this.ParsesOk(c + loc + "Init_fn='M' Finalize_fn='I' merge_fn='S' serialize_fn='F'");
        this.ParsesOk(c + loc + "merge_fn='M'");
        this.ParsesOk(c + "INTERMEDIATE CHAR(10)" + loc);
        this.ParserError("CREATE UNKNOWN FUNCTION Foo() RETURNS INT" + loc);
        this.ParserError(c + loc + "init_fn='1' init_fn='1'");
        this.ParserError(c + loc + "unknown='1'");
        this.ParserError(c + "INTERMEDIATE CHAR()" + loc);
        this.ParserError(c + "INTERMEDIATE CHAR(ab)" + loc);
        this.ParserError(c + "INTERMEDIATE CHAR('')" + loc);
        this.ParserError(c + "INTERMEDIATE CHAR('10')" + loc);
        this.ParserError(c + "INTERMEDIATE CHAR(-10)" + loc);
        this.ParsesOk(c + "INTERMEDIATE CHAR(0)" + loc);
        this.ParserError("CREATE UNKNOWN FUNCTION Foo() RETURNS INT" + loc);
        this.ParserError("CREATE AGGREGATE FUNCTION Foo() init_fn='1' RETURNS INT" + loc);
        this.ParserError(c + "init_fn='1'" + loc);
        this.ParsesOk("CREATE AGGREGATE FUNCTION Foo(INT...) RETURNS INT LOCATION 'f.jar'");
    }

    @Test
    public void TestAlterTableAddColumn() {
        for (String keyword : new String[]{"", "IF NOT EXISTS"}) {
            this.ParsesOk(String.format("ALTER TABLE Foo ADD COLUMN %s i int", keyword));
            this.ParsesOk(String.format("ALTER TABLE TestDb.Foo ADD COLUMN %s i int", keyword));
            this.ParserError(String.format("ALTER TestDb.Foo ADD COLUMN %s", keyword));
            this.ParserError(String.format("ALTER Foo ADD COLUMN %s", keyword));
            this.ParserError(String.format("ALTER TABLE TestDb.Foo ADD COLUMN %s (i int)", keyword));
            this.ParserError(String.format("ALTER TABLE Foo ADD COLUMN %s (i int)", keyword));
            this.ParserError(String.format("ALTER Foo %s ADD COLUMN i int", keyword));
            this.ParserError(String.format("ALTER TestDb.Foo %s ADD COLUMN i int", keyword));
        }
    }

    @Test
    public void TestAlterTableAddReplaceColumns() {
        String[] addReplaceKw;
        for (String addReplace : addReplaceKw = new String[]{"ADD", "ADD IF NOT EXISTS", "REPLACE"}) {
            this.ParsesOk(String.format("ALTER TABLE Foo %s COLUMNS (i int, s string)", addReplace));
            this.ParsesOk(String.format("ALTER TABLE TestDb.Foo %s COLUMNS (i int, s string)", addReplace));
            this.ParsesOk(String.format("ALTER TABLE TestDb.Foo %s COLUMNS (i int)", addReplace));
            this.ParsesOk(String.format("ALTER TABLE TestDb.Foo %s COLUMNS (i int comment 'hi')", addReplace));
            this.ParsesOk(String.format("ALTER TABLE Foo %s COLUMNS (i int PRIMARY KEY NOT NULL ENCODING RLE COMPRESSION SNAPPY BLOCK_SIZE 1024 DEFAULT 10, j string NULL ENCODING PLAIN_ENCODING COMPRESSION LZ4 BLOCK_SIZE 10 DEFAULT 'test')", addReplace));
            this.ParserError(String.format("ALTER TABLE TestDb.Foo %s COLUMNS i int", addReplace));
            this.ParserError(String.format("ALTER TABLE TestDb.Foo %s COLUMNS (int i)", addReplace));
            this.ParserError(String.format("ALTER TABLE TestDb.Foo %s COLUMNS (i int COMMENT)", addReplace));
            this.ParserError(String.format("ALTER TestDb.Foo %s COLUMNS (i int)", addReplace));
            this.ParserError(String.format("ALTER TestDb.Foo %s COLUMNS", addReplace));
            this.ParserError(String.format("ALTER TestDb.Foo %s COLUMNS ()", addReplace));
            this.ParserError(String.format("ALTER Foo %s COLUMNS (i int, s string)", addReplace));
            this.ParserError(String.format("ALTER TABLE %s COLUMNS (i int, s string)", addReplace));
        }
    }

    @Test
    public void TestAlterTableAddPartition() {
        String[] ifNotExistsOption;
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (i=1)");
        this.ParsesOk("ALTER TABLE TestDb.Foo ADD IF NOT EXISTS PARTITION (i=1, s='Hello')");
        this.ParsesOk("ALTER TABLE TestDb.Foo ADD PARTITION (i=1, s='Hello') LOCATION '/a/b'");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (i=NULL)");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (i=NULL, j=2, k=NULL)");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (i=abc, j=(5*8+10), k=!true and false)");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (i=1) SET FILEFORMAT PARQUET");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (i=1, s='one') PARTITION (i=2, s='two') PARTITION (i=3, s='three')");
        this.ParsesOk("ALTER TABLE TestDb.Foo ADD PARTITION (i=1, s='one') LOCATION 'a/b' PARTITION (i=2, s='two') LOCATION 'c/d' PARTITION (i=3, s='three') PARTITION (i=4, s='four') LOCATION 'e/f'");
        this.ParsesOk("ALTER TABLE TestDb.Foo ADD IF NOT EXISTS PARTITION (i=1, s='one') PARTITION (i=2, s='two') LOCATION 'c/d'");
        this.ParserError("ALTER TABLE TestDb.Foo ADD PARTITION (i=1, s='one') IF NOT EXISTS PARTITION (i=2, s='two') LOCATION 'c/d'");
        this.ParserError("ALTER TABLE TestDb.Foo ADD PARTITION (i=1, s='Hello') LOCATION a/b");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (j=2) CACHED IN 'pool'");
        this.ParserError("ALTER TABLE Foo ADD PARTITION (j=2) CACHED 'pool'");
        this.ParserError("ALTER TABLE Foo ADD PARTITION (j=2) CACHED IN");
        this.ParserError("ALTER TABLE Foo ADD PARTITION (j=2) CACHED");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (j=2) CACHED IN 'pool' WITH replication = 3");
        this.ParserError("ALTER TABLE Foo ADD PARTITION (j=2) CACHED IN 'pool' with replication = -1");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (j=2) UNCACHED");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (j=2) LOCATION 'a/b' UNCACHED");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (j=2) LOCATION 'a/b' CACHED IN 'pool'");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (j=2) LOCATION 'a/b' CACHED IN 'pool' with replication = 3");
        this.ParserError("ALTER TABLE Foo ADD PARTITION (j=2) CACHED IN 'pool' LOCATION 'a/b'");
        this.ParserError("ALTER TABLE Foo ADD PARTITION (j=2) UNCACHED LOCATION 'a/b'");
        this.ParsesOk("ALTER TABLE Foo ADD PARTITION (j=2) CACHED IN 'pool' PARTITION (j=3) UNCACHED PARTITION (j=4) CACHED IN 'pool' WITH replication = 3 PARTITION (j=5) LOCATION 'a/b' CACHED IN 'pool' PARTITION (j=5) LOCATION 'c/d' CACHED IN 'pool' with replication = 3");
        this.ParserError("ALTER TABLE Foo ADD IF EXISTS PARTITION (i=1, s='Hello')");
        this.ParserError("ALTER TABLE TestDb.Foo ADD (i=1, s='Hello')");
        this.ParserError("ALTER TABLE TestDb.Foo ADD (i=1)");
        this.ParserError("ALTER TABLE Foo (i=1)");
        this.ParserError("ALTER TABLE TestDb.Foo PARTITION (i=1)");
        this.ParserError("ALTER TABLE Foo ADD PARTITION");
        this.ParserError("ALTER TABLE TestDb.Foo ADD PARTITION ()");
        this.ParserError("ALTER Foo ADD PARTITION (i=1)");
        this.ParserError("ALTER TABLE ADD PARTITION (i=1)");
        this.ParserError("ALTER TABLE ADD");
        this.ParserError("ALTER TABLE DROP");
        for (String option : ifNotExistsOption = new String[]{"IF NOT EXISTS", ""}) {
            this.ParsesOk(String.format("ALTER TABLE Foo ADD %s RANGE PARTITION 10 < VALUES < 20", option));
            this.ParsesOk(String.format("ALTER TABLE Foo ADD %s RANGE PARTITION VALUE = 100", option));
            this.ParserError(String.format("ALTER TABLE Foo ADD %s RANGE PARTITION 10 < VALUES <= 20, PARTITION 20 < VALUES <= 30", option));
            this.ParserError(String.format("ALTER TABLE Foo ADD %s (RANGE PARTITION 10 < VALUES <= 20)", option));
        }
    }

    @Test
    public void TestAlterTableSetPartitionSpec() {
        String[] partTransf;
        this.ParserError("ALTER TABLE t SET PARTITION SPEC", "Syntax error in line 1:\nALTER TABLE t SET PARTITION SPEC\n                                ^\nEncountered: EOF\nExpected: (");
        this.ParserError("ALTER TABLE t SET PARTITION SPEC ()", "Syntax error in line 1:\nALTER TABLE t SET PARTITION SPEC ()\n                                  ^\nEncountered: )\nExpected: TRUNCATE, IDENTIFIER");
        this.ParserError("ALTER TABLE t PARTITION (c) SET PARTITION SPEC (c)", "Syntax error in line 1:\nALTER TABLE t PARTITION (c) SET PARTITION SPEC (c)\n                                                 ^\nEncountered: PARTITION\nExpected: SET");
        for (String pt : partTransf = new String[]{"c", "year(c)", "month(c)", "day(c)", "hour(c)", "truncate(5, c)", "bucket(5, c)", "year(c), day(c), truncate(5, c)", "c, month(c), hour(c), bucket(15, c), year(c)"}) {
            this.ParsesOk("alter table t set partition spec (" + pt + ")");
        }
    }

    @Test
    public void TestAlterTableDropColumn() {
        String[] columnKw;
        for (String kw : columnKw = new String[]{"COLUMN", ""}) {
            this.ParsesOk(String.format("ALTER TABLE Foo DROP %s col1", kw));
            this.ParsesOk(String.format("ALTER TABLE TestDb.Foo DROP %s col1", kw));
            this.ParserError(String.format("ALTER TABLE TestDb.Foo DROP %s col1, col2", kw));
            this.ParserError(String.format("ALTER TABLE TestDb.Foo DROP %s", kw));
            this.ParserError(String.format("ALTER TABLE Foo DROP %s 'col1'", kw));
            this.ParserError(String.format("ALTER Foo DROP %s col1", kw));
            this.ParserError(String.format("ALTER TABLE DROP %s col1", kw));
            this.ParserError(String.format("ALTER TABLE DROP %s", kw));
        }
    }

    @Test
    public void TestAlterTableDropPartition() {
        String[] ifExistsOption;
        String[] purgeKw;
        for (String kw : purgeKw = new String[]{"PURGE", ""}) {
            this.ParsesOk(String.format("ALTER TABLE Foo DROP PARTITION (i=1) %s", kw));
            this.ParsesOk(String.format("ALTER TABLE TestDb.Foo DROP IF EXISTS PARTITION (i=1, s='Hello') %s", kw));
            this.ParsesOk(String.format("ALTER TABLE Foo DROP PARTITION (i=NULL) %s", kw));
            this.ParsesOk(String.format("ALTER TABLE Foo DROP PARTITION (i=NULL, j=2, k=NULL) %s", kw));
            this.ParsesOk(String.format("ALTER TABLE Foo DROP PARTITION (i=abc, j=(5*8+10), k=!true and false) %s", kw));
            this.ParserError(String.format("ALTER TABLE Foo DROP IF NOT EXISTS PARTITION (i=1, s='Hello') %s", kw));
            this.ParserError(String.format("ALTER TABLE TestDb.Foo DROP (i=1, s='Hello') %s", kw));
            this.ParserError(String.format("ALTER TABLE TestDb.Foo DROP (i=1) %s", kw));
            this.ParserError(String.format("ALTER TABLE Foo (i=1) %s", kw));
            this.ParserError(String.format("ALTER TABLE TestDb.Foo PARTITION (i=1) %s", kw));
            this.ParserError(String.format("ALTER TABLE Foo DROP PARTITION %s", kw));
            this.ParserError(String.format("ALTER TABLE TestDb.Foo DROP PARTITION () %s", kw));
            this.ParserError(String.format("ALTER Foo DROP PARTITION (i=1) %s", kw));
            this.ParserError(String.format("ALTER TABLE DROP PARTITION (i=1) %s", kw));
        }
        for (String option : ifExistsOption = new String[]{"IF EXISTS", ""}) {
            this.ParsesOk(String.format("ALTER TABLE Foo DROP %s RANGE PARTITION 10 < VALUES < 20", option));
            this.ParsesOk(String.format("ALTER TABLE Foo DROP %s RANGE PARTITION VALUE = 100", option));
            this.ParserError(String.format("ALTER TABLE Foo DROP %s RANGE PARTITION 10 < VALUES <= 20, PARTITION 20 < VALUES <= 30", option));
            this.ParserError(String.format("ALTER TABLE Foo DROP %s (RANGE PARTITION 10 < VALUES <= 20)", option));
            this.ParserError(String.format("ALTER TABLE Foo DROP %s RANGE PARTITION VALUE = 100 PURGE", option));
        }
    }

    @Test
    public void TestAlterTableChangeColumn() {
        String[] columnKw;
        for (String kw : columnKw = new String[]{"COLUMN", ""}) {
            this.ParsesOk(String.format("ALTER TABLE Foo.Bar CHANGE %s c1 c2 int", kw));
            this.ParsesOk(String.format("ALTER TABLE Foo CHANGE %s c1 c2 int comment 'hi'", kw));
            this.ParsesOk(String.format("ALTER TABLE Foo CHANGE %s c1 c2 int comment 'hi' NULL ENCODING PLAIN_ENCODING COMPRESSION LZ4 DEFAULT 10 BLOCK_SIZE 1024", kw));
            this.ParserError(String.format("ALTER TABLE Foo CHANGE %s c1 int c2", kw));
            this.ParserError(String.format("ALTER TABLE Foo CHANGE %s col1 int", kw));
            this.ParserError(String.format("ALTER TABLE Foo CHANGE %s col1", kw));
            this.ParserError(String.format("ALTER TABLE Foo CHANGE %s", kw));
            this.ParserError(String.format("ALTER TABLE CHANGE %s c1 c2 int", kw));
        }
    }

    @Test
    public void TestAlterTableSet() {
        String[] supportedFileFormats;
        for (String format : supportedFileFormats = new String[]{"TEXTFILE", "SEQUENCEFILE", "PARQUET", "PARQUETFILE", "RCFILE", "AVRO"}) {
            this.ParsesOk("ALTER TABLE Foo SET FILEFORMAT " + format);
            this.ParsesOk("ALTER TABLE TestDb.Foo SET FILEFORMAT " + format);
            this.ParsesOk("ALTER TABLE TestDb.Foo PARTITION (a=1) SET FILEFORMAT " + format);
            this.ParsesOk("ALTER TABLE Foo PARTITION (s='str') SET FILEFORMAT " + format);
            this.ParserError("ALTER TABLE TestDb.Foo PARTITION (i=5) SET " + format);
            this.ParserError("ALTER TABLE TestDb.Foo SET " + format);
            this.ParserError("ALTER TABLE TestDb.Foo " + format);
        }
        this.ParserError("ALTER TABLE TestDb.Foo SET FILEFORMAT");
        this.ParsesOk("ALTER TABLE Foo SET LOCATION '/a/b/c'");
        this.ParsesOk("ALTER TABLE TestDb.Foo SET LOCATION '/a/b/c'");
        this.ParsesOk("ALTER TABLE Foo PARTITION (i=1,s='str') SET LOCATION '/a/i=1/s=str'");
        this.ParsesOk("ALTER TABLE Foo PARTITION (s='str') SET LOCATION '/a/i=1/s=str'");
        this.ParserError("ALTER TABLE Foo PARTITION () SET LOCATION '/a'");
        this.ParserError("ALTER TABLE Foo PARTITION () SET FILEFORMAT PARQUETFILE");
        this.ParserError("ALTER TABLE Foo PARTITION (,) SET FILEFORMAT PARQUET");
        this.ParserError("ALTER TABLE Foo PARTITION (a=1) SET FILEFORMAT");
        this.ParserError("ALTER TABLE Foo PARTITION (a=1) SET LOCATION");
        this.ParserError("ALTER TABLE TestDb.Foo SET LOCATION abc");
        this.ParserError("ALTER TABLE TestDb.Foo SET LOCATION");
        this.ParserError("ALTER TABLE TestDb.Foo SET");
        this.ParsesOk("ALTER TABLE Foo SET ROW FORMAT DELIMITED FIELDS TERMINATED BY ','");
        this.ParsesOk("ALTER TABLE Foo SET ROW FORMAT DELIMITED LINES TERMINATED BY '\n'");
        this.ParsesOk("ALTER TABLE Foo SET ROW FORMAT DELIMITED FIELDS TERMINATED BY ',' LINES TERMINATED BY '\n'");
        this.ParsesOk("ALTER TABLE Foo SET ROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '' LINES TERMINATED BY '\n'");
        this.ParsesOk("ALTER TABLE Foo PARTITION (i=1) SET ROW FORMAT DELIMITED FIELDS TERMINATED BY ','");
        this.ParsesOk("ALTER TABLE Foo PARTITION (i=1) SET ROW FORMAT DELIMITED LINES TERMINATED BY '\n'");
        this.ParsesOk("ALTER TABLE Foo PARTITION (i=1) SET ROW FORMAT DELIMITED FIELDS TERMINATED BY ',' LINES TERMINATED BY '\n'");
        this.ParsesOk("ALTER TABLE Foo PARTITION (i=1) SET ROW FORMAT DELIMITED FIELDS TERMINATED BY ',' ESCAPED BY '' LINES TERMINATED BY '\n'");
        this.ParserError("ALTER TABLE Foo SET ROW FORMAT");
        this.ParserError("ALTER TABLE Foo SET ROW FORMAT DELIMITED FIELDS");
        this.ParserError("ALTER TABLE Foo PARTITION () SET ROW FORMAT DELIMITED FIELDS TERMINATED BY ','");
        this.ParserError("ALTER TABLE Foo PARTITION (i=1) SET ROW FORMAT");
        String[] tblPropTypes = new String[]{"TBLPROPERTIES", "SERDEPROPERTIES"};
        String[] partClauses = new String[]{"", "PARTITION(k1=10, k2=20)"};
        for (String propType : tblPropTypes) {
            for (String part : partClauses) {
                this.ParsesOk(String.format("ALTER TABLE Foo %s SET %s ('a'='b')", part, propType));
                this.ParsesOk(String.format("ALTER TABLE Foo %s SET %s ('abc'='123')", part, propType));
                this.ParsesOk(String.format("ALTER TABLE Foo %s SET %s ('abc'='123', 'a'='1')", part, propType));
                this.ParsesOk(String.format("ALTER TABLE Foo %s SET %s ('a'='1', 'b'='2', 'c'='3')", part, propType));
                this.ParserError(String.format("ALTER TABLE Foo %s SET %s ( )", part, propType));
                this.ParserError(String.format("ALTER TABLE Foo %s SET %s ('a', 'b')", part, propType));
                this.ParserError(String.format("ALTER TABLE Foo %s SET %s ('a'='b',)", part, propType));
                this.ParserError(String.format("ALTER TABLE Foo %s SET %s ('a'=b)", part, propType));
                this.ParserError(String.format("ALTER TABLE Foo %s SET %s (a='b')", part, propType));
                this.ParserError(String.format("ALTER TABLE Foo %s SET %s (a=b)", part, propType));
            }
        }
        this.ParsesOk("ALTER TABLE Foo SET COLUMN STATS col ('numDVs'='10')");
        this.ParsesOk("ALTER TABLE Foo SET COLUMN STATS col ('numDVs'='10','maxSize'='20')");
        this.ParsesOk("ALTER TABLE Foo SET COLUMN STATS col ('NUM_TRUES'='10')");
        this.ParsesOk("ALTER TABLE Foo SET COLUMN STATS col ('NUM_FALSES'='20')");
        this.ParsesOk("ALTER TABLE Foo SET COLUMN STATS col ('NUM_TRUES'='10','NUM_FALSES'='20')");
        this.ParsesOk("ALTER TABLE TestDb.Foo SET COLUMN STATS col ('avgSize'='20')");
        this.ParserError("ALTER TABLE SET COLUMN STATS col ('numDVs'='10'");
        this.ParserError("ALTER TABLE Foo SET COLUMN STATS ('numDVs'='10'");
        this.ParserError("ALTER TABLE Foo SET COLUMN STATS col");
        this.ParserError("ALTER TABLE Foo SET COLUMN STATS col ()");
        this.ParserError("ALTER TABLE Foo SET COLUMN STATS col (numDVs='10')");
        this.ParserError("ALTER TABLE Foo SET COLUMN STATS col ('numDVs'=10)");
        this.ParserError("ALTER TABLE Foo PARTITION (p=1) SET COLUMN STATS col ('avgSize'='20')");
        for (String cacheClause : Lists.newArrayList((Object[])new String[]{"UNCACHED", "CACHED in 'pool'", "CACHED in 'pool' with replication = 4"})) {
            this.ParsesOk("ALTER TABLE Foo SET " + cacheClause);
            this.ParsesOk("ALTER TABLE Foo PARTITION(j=0) SET " + cacheClause);
            this.ParserError("ALTER TABLE Foo PARTITION(j=0) " + cacheClause);
        }
    }

    @Test
    public void TestAlterTableSortBy() {
        this.ParsesOk("ALTER TABLE TEST SORT BY (int_col, id)");
        this.ParsesOk("ALTER TABLE TEST SORT BY ()");
        this.ParserError("ALTER TABLE TEST PARTITION (year=2009, month=4) SORT BY (int_col, id)");
    }

    @Test
    public void TestAlterTableZSortBy() {
        this.ParsesOk("ALTER TABLE TEST SORT BY ZORDER (int_col, id)");
        this.ParsesOk("ALTER TABLE TEST SORT BY ZORDER ()");
        this.ParserError("ALTER TABLE TEST PARTITION (year=2009, month=4) SORT BY ZORDER (int_col, id)");
    }

    @Test
    public void TestAlterTableOrViewRename() {
        for (String entity : Lists.newArrayList((Object[])new String[]{"TABLE", "VIEW"})) {
            this.ParsesOk(String.format("ALTER %s TestDb.Foo RENAME TO TestDb.Foo2", entity));
            this.ParsesOk(String.format("ALTER %s Foo RENAME TO TestDb.Foo2", entity));
            this.ParsesOk(String.format("ALTER %s TestDb.Foo RENAME TO Foo2", entity));
            this.ParsesOk(String.format("ALTER %s Foo RENAME TO Foo2", entity));
            this.ParserError(String.format("ALTER %s Foo RENAME TO 'Foo2'", entity));
            this.ParserError(String.format("ALTER %s Foo RENAME Foo2", entity));
            this.ParserError(String.format("ALTER %s Foo RENAME TO", entity));
            this.ParserError(String.format("ALTER %s Foo TO Foo2", entity));
            this.ParserError(String.format("ALTER %s Foo TO Foo2", entity));
        }
    }

    @Test
    public void TestAlterTableRecoverPartitions() {
        this.ParsesOk("ALTER TABLE TestDb.Foo RECOVER PARTITIONS");
        this.ParsesOk("ALTER TABLE Foo RECOVER PARTITIONS");
        this.ParserError("ALTER TABLE Foo RECOVER PARTITIONS ()");
        this.ParserError("ALTER TABLE Foo RECOVER PARTITIONS (i=1)");
        this.ParserError("ALTER TABLE RECOVER");
        this.ParserError("ALTER TABLE RECOVER PARTITIONS");
        this.ParserError("ALTER TABLE Foo RECOVER");
        this.ParserError("ALTER TABLE Foo RECOVER PARTITION");
    }

    @Test
    public void TestAlterTableAlterColumn() {
        for (String column : Lists.newArrayList((Object[])new String[]{"", "COLUMN"})) {
            this.ParsesOk(String.format("ALTER TABLE foo ALTER %s bar SET default 0", column));
            this.ParsesOk(String.format("ALTER TABLE foo ALTER %s bar SET default 0 block_size 0", column));
            this.ParsesOk(String.format("ALTER TABLE foo ALTER %s bar DROP default", column));
            this.ParserError(String.format("ALTER TABLE foo ALTER %s bar", column));
            this.ParserError(String.format("ALTER TABLE foo ALTER %s bar SET default", column));
            this.ParserError(String.format("ALTER TABLE foo ALTER %s bar SET error 0", column));
            this.ParserError(String.format("ALTER TABLE foo ALTER %s bar SET default 0 error 0", column));
            this.ParserError(String.format("ALTER TABLE foo ALTER %s bar DROP comment", column));
        }
    }

    @Test
    public void TestCreateTable() {
        String[] tblPropTypes;
        String[] supportedFileFormats;
        this.ParsesOk("CREATE TABLE Foo (i int)");
        this.ParsesOk("CREATE TABLE Foo.Bar (i int)");
        this.ParsesOk("CREATE TABLE IF NOT EXISTS Foo.Bar (i int)");
        this.ParsesOk("CREATE TABLE Foo.Bar2 LIKE Foo.Bar1");
        this.ParsesOk("CREATE TABLE IF NOT EXISTS Bar2 LIKE Bar1");
        this.ParsesOk("CREATE EXTERNAL TABLE IF NOT EXISTS Bar2 LIKE Bar1");
        this.ParsesOk("CREATE EXTERNAL TABLE IF NOT EXISTS Bar2 LIKE Bar1 LOCATION '/a/b'");
        this.ParsesOk("CREATE TABLE Foo2 LIKE Foo COMMENT 'sdafsdf'");
        this.ParsesOk("CREATE TABLE Foo2 LIKE Foo COMMENT ''");
        this.ParsesOk("CREATE TABLE Foo2 LIKE Foo STORED AS PARQUETFILE");
        this.ParsesOk("CREATE TABLE Foo2 LIKE Foo COMMENT 'tbl' STORED AS PARQUETFILE LOCATION '/a/b'");
        this.ParsesOk("CREATE TABLE Foo2 LIKE Foo STORED AS TEXTFILE LOCATION '/a/b'");
        this.ParsesOk("CREATE TABLE Foo LIKE PARQUET '/user/foo'");
        this.ParsesOk("CREATE TABLE 01_Foo (01_i int, 02_j string)");
        this.ParsesOk("CREATE TABLE Foo (i int, s string)");
        this.ParsesOk("CREATE EXTERNAL TABLE Foo (i int, s string)");
        this.ParsesOk("CREATE EXTERNAL TABLE Foo (i int, s string) LOCATION '/test-warehouse/'");
        this.ParsesOk("CREATE TABLE Foo (i int, s string) COMMENT 'hello' LOCATION '/a/b/'");
        this.ParsesOk("CREATE TABLE Foo (i int, s string) COMMENT 'hello' LOCATION '/a/b/' TBLPROPERTIES ('123'='1234')");
        this.ParsesOk("CREATE TABLE Foo COMMENT 'hello' LOCATION '/a/b/' TBLPROPERTIES ('123'='1234')");
        this.ParsesOk("CREATE TABLE Foo (i int) PARTITIONED BY (j string)");
        this.ParsesOk("CREATE TABLE Foo (i int) PARTITIONED BY (s string, d double)");
        this.ParsesOk("CREATE TABLE Foo (i int, s string) PARTITIONED BY (s string, d double) COMMENT 'hello' LOCATION '/a/b/'");
        this.ParsesOk("CREATE TABLE Foo PARTITIONED BY (s string, d double) COMMENT 'hello' LOCATION '/a/b/'");
        this.ParserError("CREATE TABLE Foo (i int) PARTITIONED BY (int)");
        this.ParserError("CREATE TABLE Foo (i int) PARTITIONED BY ()");
        this.ParserError("CREATE TABLE Foo (i int) PARTITIONED BY");
        this.ParsesOk("CREATE TABLE Foo (i int, j int) SORT BY ()");
        this.ParsesOk("CREATE TABLE Foo (i int) SORT BY (i)");
        this.ParsesOk("CREATE TABLE Foo (i int) SORT BY (j)");
        this.ParsesOk("CREATE TABLE Foo (i int, j int) SORT BY (i,j)");
        this.ParsesOk("CREATE EXTERNAL TABLE Foo (i int, s string) SORT BY (s) LOCATION '/test-warehouse/'");
        this.ParsesOk("CREATE TABLE Foo (i int, s string) SORT BY (s) COMMENT 'hello' LOCATION '/a/b/' TBLPROPERTIES ('123'='1234')");
        this.ParserError("CREATE TABLE Foo (i int, s string) COMMENT 'hello' SORT BY (s) LOCATION '/a/b/' TBLPROPERTIES ('123'='1234')");
        this.ParserError("CREATE TABLE Foo (i int, s string) COMMENT 'hello' LOCATION '/a/b/' SORT BY (s) TBLPROPERTIES ('123'='1234')");
        this.ParserError("CREATE TABLE Foo (i int, s string) COMMENT 'hello' LOCATION '/a/b/' TBLPROPERTIES ('123'='1234') SORT BY (s)");
        this.ParserError("CREATE TABLE Foo (i int, j int) SORT BY");
        this.ParserError("CREATE TABLE Foo (i int, j int) SORT BY (i,)");
        this.ParserError("CREATE TABLE Foo (i int, j int) SORT BY (int)");
        this.ParsesOk("CREATE TABLE Foo SORT BY(bar) LIKE Baz STORED AS TEXTFILE LOCATION '/a/b'");
        this.ParserError("CREATE TABLE SORT BY(bar) Foo LIKE Baz STORED AS TEXTFILE LOCATION '/a/b'");
        this.ParserError("CREATE TABLE Foo LIKE Baz STORED AS TEXTFILE LOCATION '/a/b' SORT BY(bar)");
        this.ParsesOk("CREATE TABLE Foo SORT BY(bar) AS SELECT * FROM BAR");
        this.ParserError("CREATE TABLE Foo AS SELECT * FROM BAR SORT BY(bar)");
        this.ParsesOk("CREATE TABLE Foo LIKE PARQUET '/user/foo' SORT BY (id)");
        this.ParserError("CREATE TABLE Foo SORT BY (id) LIKE PARQUET '/user/foo'");
        this.ParsesOk("CREATE TABLE Foo (i int, j int) SORT BY ZORDER ()");
        this.ParsesOk("CREATE TABLE Foo (i int) SORT BY ZORDER (i)");
        this.ParsesOk("CREATE TABLE Foo (i int) SORT BY ZORDER (j)");
        this.ParsesOk("CREATE TABLE Foo (i int, j int) SORT BY ZORDER (i,j)");
        this.ParsesOk("CREATE EXTERNAL TABLE Foo (i int, s string) SORT BY ZORDER (s) LOCATION '/test-warehouse/'");
        this.ParsesOk("CREATE TABLE Foo (i int, s string) SORT BY ZORDER (s) COMMENT 'hello' LOCATION '/a/b/' TBLPROPERTIES ('123'='1234')");
        this.ParserError("CREATE TABLE Foo (i int, s string) COMMENT 'hello' SORT BY ZORDER (s) LOCATION '/a/b/' TBLPROPERTIES ('123'='1234')");
        this.ParserError("CREATE TABLE Foo (i int, s string) COMMENT 'hello' LOCATION '/a/b/' SORT BY ZORDER (s) TBLPROPERTIES ('123'='1234')");
        this.ParserError("CREATE TABLE Foo (i int, s string) COMMENT 'hello' LOCATION '/a/b/' TBLPROPERTIES ('123'='1234') SORT BY ZORDER (s)");
        this.ParserError("CREATE TABLE Foo (i int, j int) SORT BY ZORDER");
        this.ParserError("CREATE TABLE Foo (i int, j int) SORT BY ZORDER (i,)");
        this.ParserError("CREATE TABLE Foo (i int, j int) SORT BY ZORDER (int)");
        this.ParsesOk("CREATE TABLE Foo SORT BY ZORDER(bar) LIKE Baz STORED AS TEXTFILE LOCATION '/a/b'");
        this.ParserError("CREATE TABLE SORT BY ZORDER(bar) Foo LIKE Baz STORED AS TEXTFILE LOCATION '/a/b'");
        this.ParserError("CREATE TABLE Foo LIKE Baz STORED AS TEXTFILE LOCATION '/a/b' SORT BY ZORDER(bar)");
        this.ParsesOk("CREATE TABLE Foo SORT BY ZORDER(bar) AS SELECT * FROM BAR");
        this.ParserError("CREATE TABLE Foo AS SELECT * FROM BAR SORT BY ZORDER(bar)");
        this.ParsesOk("CREATE TABLE Foo LIKE PARQUET '/user/foo' SORT BY ZORDER (id)");
        this.ParserError("CREATE TABLE Foo SORT BY ZORDER (id) LIKE PARQUET '/user/foo'");
        this.ParsesOk("CREATE TABLE Foo (i int COMMENT 'hello', s string)");
        this.ParsesOk("CREATE TABLE Foo (i int COMMENT 'hello', s string COMMENT 'hi')");
        this.ParsesOk("CREATE TABLE T (i int COMMENT 'hi') PARTITIONED BY (j int COMMENT 'bye')");
        for (String format : supportedFileFormats = new String[]{"TEXTFILE", "SEQUENCEFILE", "PARQUET", "PARQUETFILE", "RCFILE", "AVRO", "PAIMON"}) {
            this.ParsesOk("CREATE TABLE Foo (i int, s string) STORED AS " + format);
            this.ParsesOk("CREATE EXTERNAL TABLE Foo (i int, s string) STORED AS " + format);
            this.ParsesOk(String.format("CREATE TABLE Foo (i int, s string) STORED AS %s LOCATION '/b'", format));
            this.ParsesOk(String.format("CREATE EXTERNAL TABLE Foo (f float) COMMENT 'c' STORED AS %s LOCATION '/b'", format));
            this.ParsesOk(String.format("CREATE EXTERNAL TABLE Foo COMMENT 'c' STORED AS %s LOCATION '/b'", format));
            this.ParserError(String.format("CREATE EXTERNAL TABLE t PRIMARY KEYS (i) STORED AS %s", format));
        }
        this.ParsesOk("CREATE TABLE foo (i INT) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE foo (i INT PRIMARY KEY) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE foo (i INT, j INT, PRIMARY KEY (i, j)) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE foo (i INT, j INT, PRIMARY KEY (j, i)) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE foo (i INT PRIMARY KEY, PRIMARY KEY(i)) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE foo (i INT PRIMARY KEY, j INT PRIMARY KEY) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE foo (i INT NON UNIQUE PRIMARY KEY) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE foo (i INT NON UNIQUE PRIMARY KEY, NON UNIQUE PRIMARY KEY(i)) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE foo (i INT, j INT, NON UNIQUE PRIMARY KEY (i, j)) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE foo (i INT NON UNIQUE PRIMARY KEY, j INT NON UNIQUE PRIMARY KEY) STORED AS KUDU");
        this.ParserError("CREATE TABLE foo (i INT) PRIMARY KEY (i) STORED AS KUDU");
        this.ParserError("CREATE TABLE foo (i INT, PRIMARY KEY) STORED AS KUDU");
        this.ParserError("CREATE TABLE foo (PRIMARY KEY(a), a INT) STORED AS KUDU");
        this.ParserError("CREATE TABLE foo (i INT) NON UNIQUE PRIMARY KEY (i) STORED AS KUDU");
        this.ParserError("CREATE TABLE foo (i INT, NON UNIQUE PRIMARY KEY) STORED AS KUDU");
        this.ParserError("CREATE TABLE foo (NON UNIQUE PRIMARY KEY(a), a INT) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE foo (i INT, j STRING) STORED AS JDBC");
        this.ParsesOk("CREATE TABLE IF NOT EXISTS foo (i INT) COMMENT 'comment' STORED AS JDBC TBLPROPERTIES ('key1'='value1', 'key2'='value2')");
        this.ParserError("CREATE TABLE foo (i INT) PRIMARY KEY (i) STORED AS JDBC");
        this.ParsesOk("CREATE TABLE foo (i INT) STORED BY KUDU");
        this.ParsesOk("CREATE TABLE foo (i INT) STORED BY ICEBERG");
        this.ParsesOk("CREATE TABLE foo (i INT) STORED BY JDBC");
        this.ParserError("CREATE TABLE foo (i INT) STORED BY PARQUET");
        this.ParserError("CREATE TABLE foo (i INT) STORED BY FOOBAR");
        this.ParserError("CREATE TABLE foo (i INT) STORED BY");
        this.ParsesOk("create table foo(id int, year int, primary key (id))");
        this.ParsesOk("create table foo(id int, year int, primary key (id, year))");
        this.ParsesOk("create table foo(id int, year int, primary key (id, year) disable novalidate rely)");
        this.ParsesOk("create table foo(id int, year int, primary key (id, year) novalidate rely)");
        this.ParsesOk("create table foo(id int, year int, primary key (id, year) rely)");
        this.ParserError("create table foo(id int, year string, primary key(id), primary key(year))");
        this.ParsesOk("create table fk(id int, year int, primary key (id, year) disable novalidate rely, foreign key(id) REFERENCES pk(id) DISABLE NOVALIDATE RELY)");
        this.ParsesOk("create table foo(id int, year int, foreign key (id) references pk(id))");
        this.ParsesOk("create table fk(id int, year string, foreign key(year) references pk(year), primary key(id))");
        this.ParsesOk("create table foo(id int, year int, primary key (id, year) enable novalidate rely)");
        this.ParserError("create table foo(id int, year int, primary key (id, year) novalidate disable rely)");
        this.ParserError("create table fk(id int, year int, foreign key(id) REFERENCES pk(id) NOVALIDATE DISABLE RELY)");
        this.ParsesOk("create table fk(id int, year string, primary key(id), foreign key(id) references pk(id), foreign key (year) references pk(year))");
        for (String propType : tblPropTypes = new String[]{"TBLPROPERTIES", "WITH SERDEPROPERTIES"}) {
            this.ParsesOk(String.format("CREATE TABLE Foo (i int) %s ('a'='b', 'c'='d', 'e'='f')", propType));
            this.ParserError(String.format("CREATE TABLE Foo (i int) %s", propType));
            this.ParserError(String.format("CREATE TABLE Foo (i int) %s ()", propType));
            this.ParserError(String.format("CREATE TABLE Foo (i int) %s ('a')", propType));
            this.ParserError(String.format("CREATE TABLE Foo (i int) %s ('a'=)", propType));
            this.ParserError(String.format("CREATE TABLE Foo (i int) %s ('a'=c)", propType));
            this.ParserError(String.format("CREATE TABLE Foo (i int) %s (a='c')", propType));
        }
        this.ParsesOk("CREATE TABLE Foo (i int) WITH SERDEPROPERTIES ('a'='b') TBLPROPERTIES ('c'='d', 'e'='f')");
        this.ParsesOk("CREATE TABLE Foo (i int) STORED BY JDBC TBLPROPERTIES ('c'='d', 'e'='f')");
        this.ParserError("CREATE TABLE Foo (i int) TBLPROPERTIES ('c'='d', 'e'='f') WITH SERDEPROPERTIES ('a'='b')");
        this.ParserError("CREATE TABLE Foo (i int) SERDEPROPERTIES ('a'='b')");
        this.ParserError("CREATE TABLE Foo (i int, s string) STORED AS SEQFILE");
        this.ParserError("CREATE TABLE Foo (i int, s string) STORED TEXTFILE");
        this.ParserError("CREATE TABLE Foo LIKE Bar STORED AS TEXT");
        this.ParserError("CREATE TABLE Foo LIKE Bar COMMENT");
        this.ParserError("CREATE TABLE Foo LIKE Bar STORED TEXTFILE");
        this.ParserError("CREATE TABLE Foo LIKE Bar STORED AS");
        this.ParserError("CREATE TABLE Foo LIKE Bar LOCATION");
        this.ParsesOk("CREATE TABLE T (i int) ROW FORMAT DELIMITED");
        this.ParsesOk("CREATE TABLE T (i int) ROW FORMAT DELIMITED FIELDS TERMINATED BY '|'");
        this.ParsesOk("CREATE TABLE T (i int) ROW FORMAT DELIMITED LINES TERMINATED BY '|'");
        this.ParsesOk("CREATE TABLE T (i int) ROW FORMAT DELIMITED ESCAPED BY ''");
        this.ParsesOk("CREATE TABLE T (i int) ROW FORMAT DELIMITED FIELDS TERMINATED BY '\u0000' ESCAPED BY '\u0003' LINES TERMINATED BY '\u0001'");
        this.ParsesOk("CREATE TABLE T (i int) ROW FORMAT DELIMITED FIELDS TERMINATED BY '\u0000' LINES TERMINATED BY '\u0001' STORED AS TEXTFILE");
        this.ParsesOk("CREATE TABLE T (i int) COMMENT 'hi' ROW FORMAT DELIMITED STORED AS RCFILE");
        this.ParsesOk("CREATE TABLE T (i int) COMMENT 'hello' ROW FORMAT DELIMITED FIELDS TERMINATED BY '\u0000' LINES TERMINATED BY '\u0001' STORED AS TEXTFILE LOCATION '/a'");
        this.ParserError("CREATE TABLE T (i int) ROW FORMAT DELIMITED TERMINATED BY '\u0000'");
        this.ParserError("CREATE TABLE T (i int) ROW FORMAT DELIMITED FIELDS TERMINATED BY");
        this.ParserError("CREATE TABLE T (i int) ROW FORMAT DELIMITED LINES TERMINATED BY");
        this.ParserError("CREATE TABLE T (i int) ROW FORMAT DELIMITED ESCAPED BY");
        this.ParserError("CREATE TABLE T (i int) ROW FORMAT DELIMITED FIELDS TERMINATED '|'");
        this.ParserError("CREATE TABLE T (i int) ROW FORMAT DELIMITED FIELDS TERMINATED BY |");
        this.ParserError("CREATE TABLE T (i int) ROW FORMAT DELIMITED FIELDS BY '\u0000'");
        this.ParserError("CREATE TABLE T (i int) ROW FORMAT DELIMITED LINES BY '\n'");
        this.ParserError("CREATE TABLE T (i int) FIELDS TERMINATED BY '\u0000'");
        this.ParserError("CREATE TABLE T (i int) ROWS TERMINATED BY '\u0000'");
        this.ParserError("CREATE TABLE T (i int) ESCAPED BY '\u0000'");
        this.ParserError("CREATE TABLE Foo (d double) COMMENT 'c' PARTITIONED BY (i int)");
        this.ParserError("CREATE TABLE Foo (d double) STORED AS TEXTFILE COMMENT 'c'");
        this.ParserError("CREATE TABLE Foo (d double) STORED AS TEXTFILE ROW FORMAT DELIMITED");
        this.ParserError("CREATE TABLE Foo (d double) ROW FORMAT DELIMITED COMMENT 'c'");
        this.ParserError("CREATE TABLE Foo (d double) LOCATION 'a' COMMENT 'c'");
        this.ParserError("CREATE TABLE Foo (d double) UNCACHED LOCATION '/a/b'");
        this.ParserError("CREATE TABLE Foo (d double) CACHED IN 'pool' LOCATION '/a/b'");
        this.ParserError("CREATE TABLE Foo (d double) CACHED IN 'pool' REPLICATION = 8 LOCATION '/a/b'");
        this.ParserError("CREATE TABLE Foo (d double) LOCATION 'a' COMMENT 'c' STORED AS RCFILE");
        this.ParserError("CREATE TABLE Foo (d double) LOCATION 'a' STORED AS RCFILE");
        this.ParserError("CREATE TABLE Foo (d double) TBLPROPERTIES('a'='b') LOCATION 'a'");
        this.ParserError("CREATE TABLE Foo (i int) LOCATION 'a' WITH SERDEPROPERTIES('a'='b')");
        this.ParserError("CREATE TABLE Foo (d double) LOCATION a");
        this.ParserError("CREATE TABLE Foo (d double) COMMENT c");
        this.ParserError("CREATE TABLE Foo (d double COMMENT c)");
        this.ParserError("CREATE TABLE Foo (d double COMMENT 'c') PARTITIONED BY (j COMMENT hi)");
        this.ParserError("CREATE TABLE Foo (d double) STORED AS 'TEXTFILE'");
        this.ParsesOk("CREATE TABLE Foo (i int) CACHED IN 'myPool'");
        this.ParsesOk("CREATE TABLE Foo (i int) CACHED IN 'myPool' WITH REPLICATION = 4");
        this.ParsesOk("CREATE TABLE Foo (i int) PARTITIONED BY(j int) CACHED IN 'myPool'");
        this.ParsesOk("CREATE TABLE Foo (i int) PARTITIONED BY(j int) CACHED IN 'myPool' WITH REPLICATION = 4");
        this.ParsesOk("CREATE TABLE Foo (i int) PARTITIONED BY(j int) CACHED IN 'myPool'");
        this.ParsesOk("CREATE TABLE Foo (i int) PARTITIONED BY(j int) LOCATION '/a' CACHED IN 'myPool'");
        this.ParserError("CREATE TABLE Foo (i int) CACHED IN myPool");
        this.ParserError("CREATE TABLE Foo (i int) PARTITIONED BY(j int) CACHED IN");
        this.ParserError("CREATE TABLE Foo (i int) CACHED 'myPool'");
        this.ParserError("CREATE TABLE Foo (i int) IN 'myPool'");
        this.ParserError("CREATE TABLE Foo (i int) PARTITIONED BY(j int) CACHED IN 'myPool' LOCATION '/a'");
        this.ParserError("CREATE TABLE Foo (i int) CACHED IN 'myPool' WITH REPLICATION = -1");
        this.ParserError("CREATE TABLE Foo (i int) CACHED IN 'myPool' WITH REPLICATION = 1.0");
        this.ParserError("CREATE TABLE Foo (i int) CACHED IN 'myPool' WITH REPLICATION = cast(1 as double)");
        this.ParserError("CREATE TABLE IF EXISTS Foo.Bar (i int)");
        this.ParserError("CREATE TABLE Bar LIKE Bar2 (i int)");
        this.ParserError("CREATE IF NOT EXISTS TABLE Foo.Bar (i int)");
        this.ParserError("CREATE TABLE Foo (d double) STORED TEXTFILE");
        this.ParserError("CREATE TABLE Foo (d double) AS TEXTFILE");
        this.ParserError("CREATE TABLE Foo i int");
        this.ParserError("CREATE TABLE Foo (i intt)");
        this.ParserError("CREATE TABLE Foo (int i)");
        this.ParserError("CREATE TABLE Foo (i int,)");
        this.ParserError("CREATE TABLE Foo ()");
        this.ParserError("CREATE TABLE");
        this.ParserError("CREATE EXTERNAL");
        this.ParserError("CREATE");
        this.ParsesOk("CREATE TABLE Foo (i int, s string) PRODUCED BY DATA SOURCE Bar");
        this.ParsesOk("CREATE TABLE Foo (i int, s string) PRODUCED BY DATA SOURCE Bar(\"\")");
        this.ParsesOk("CREATE TABLE Foo (i int) PRODUCED BY DATA SOURCE Bar(\"Foo \\!@#$%^&*()\")");
        this.ParsesOk("CREATE TABLE IF NOT EXISTS Foo (i int) PRODUCED BY DATA SOURCE Bar(\"\")");
        this.ParserError("CREATE TABLE Foo (i int) PRODUCED BY DATA Foo");
        this.ParserError("CREATE TABLE Foo (i int) PRODUCED BY DATA SRC Foo");
        this.ParserError("CREATE TABLE Foo (i int) PRODUCED BY DATA SOURCE Foo.Bar");
        this.ParserError("CREATE TABLE Foo (i int) PRODUCED BY DATA SOURCE Foo()");
        this.ParserError("CREATE EXTERNAL TABLE Foo (i int) PRODUCED BY DATA SOURCE Foo(\"\")");
        this.ParserError("CREATE TABLE Foo (i int) PRODUCED BY DATA SOURCE Foo(\"\") LOCATION 'x'");
        this.ParserError("CREATE TABLE Foo (i int) PRODUCED BY DATA SOURCE Foo(\"\") ROW FORMAT DELIMITED");
        this.ParserError("CREATE TABLE Foo (i int) PARTITIONED BY (j string) PRODUCED BY DATA SOURCE Foo(\"\")");
        this.ParsesOk("CREATE TABLE Foo (i int) PARTITION BY HASH(i) PARTITIONS 4");
        this.ParsesOk("CREATE TABLE Foo (i int) PARTITION BY HASH(i) PARTITIONS 4, HASH(a) PARTITIONS 2");
        this.ParsesOk("CREATE TABLE Foo (i int) PARTITION BY HASH PARTITIONS 4");
        this.ParsesOk("CREATE TABLE Foo (i int, k int) PARTITION BY HASH PARTITIONS 4, HASH(k) PARTITIONS 4");
        this.ParserError("CREATE TABLE Foo (i int) PARTITION BY HASH(i)");
        this.ParserError("CREATE EXTERNAL TABLE Foo PARTITION BY HASH PARTITIONS 4");
        this.ParsesOk("CREATE TABLE Foo (i int) PARTITION BY RANGE (PARTITION VALUE = 10)");
        this.ParsesOk("CREATE TABLE Foo (i int) PARTITION BY RANGE(i) (PARTITION 1 <= VALUES < 10, PARTITION 10 <= VALUES < 20, PARTITION 21 < VALUES <= 30, PARTITION VALUE = 50)");
        this.ParsesOk("CREATE TABLE Foo (a int) PARTITION BY RANGE(a) (PARTITION 10 <= VALUES)");
        this.ParsesOk("CREATE TABLE Foo (a int) PARTITION BY RANGE(a) (PARTITION VALUES < 10)");
        this.ParsesOk("CREATE TABLE Foo (a int) PARTITION BY RANGE (a) (PARTITION VALUE = 10, PARTITION VALUE = 20)");
        this.ParsesOk("CREATE TABLE Foo (a int) PARTITION BY RANGE(a) (PARTITION VALUES <= 10, PARTITION VALUE = 20)");
        this.ParsesOk("CREATE TABLE Foo (a int, b int) PARTITION BY RANGE(a, b) (PARTITION VALUE = (2001, 1), PARTITION VALUE = (2001, 2), PARTITION VALUE = (2002, 1))");
        this.ParsesOk("CREATE TABLE Foo (a int, b string) PARTITION BY HASH (a) PARTITIONS 3, RANGE (a, b) (PARTITION VALUE = (1, 'abc'), PARTITION VALUE = (2, 'def'))");
        this.ParsesOk("CREATE TABLE Foo (a int) PARTITION BY RANGE (a) (PARTITION VALUE = 10), HASH (a) PARTITIONS 3");
        this.ParsesOk("CREATE TABLE Foo (a int) PARTITION BY RANGE (a) (PARTITION VALUE = 1 + 1) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE Foo (a int) PARTITION BY RANGE (a) (PARTITION 1 + 1 < VALUES) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE Foo (a int, b int) PARTITION BY RANGE (a) (PARTITION b < VALUES <= a) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE Foo (a int) PARTITION BY RANGE (a) (PARTITION now() <= VALUES, PARTITION VALUE = add_months(now(), 2)) STORED AS KUDU");
        this.ParserError("CREATE TABLE Foo (a int) PARTITION BY RANGE (a) ()");
        this.ParserError("CREATE TABLE Foo (a int) PARTITION BY HASH (a) PARTITIONS 4, RANGE (a) (PARTITION VALUE = 10), RANGE (a) (PARTITION VALUES < 10)");
        this.ParserError("CREATE TABLE Foo (a int) PARTITION BY RANGE (a) (PARTITION VALUES = 10) STORED AS KUDU");
        this.ParserError("CREATE TABLE Foo (a int) PARTITION BY RANGE (a) (PARTITION 10 < VALUE < 20) STORED AS KUDU");
        String[] encodings = new String[]{"encoding auto_encoding", "encoding plain_encoding", "encoding prefix_encoding", "encoding group_varint", "encoding rle", "encoding dict_encoding", "encoding bit_shuffle", "encoding unknown", ""};
        String[] compression = new String[]{"compression default_compression", "compression no_compression", "compression snappy", "compression lz4", "compression zlib", "compression unknown", ""};
        String[] nullability = new String[]{"not null", "null", ""};
        String[] defaultVal = new String[]{"default 10", ""};
        String[] blockSize = new String[]{"block_size 4096", ""};
        for (String enc : encodings) {
            for (String comp : compression) {
                for (String nul : nullability) {
                    for (String def : defaultVal) {
                        for (String block : blockSize) {
                            this.ParsesOk(String.format("CREATE TABLE Foo (i int PRIMARY KEY %s %s %s %s %s) STORED AS KUDU", nul, enc, comp, def, block));
                            this.ParsesOk(String.format("CREATE TABLE Foo (i int PRIMARY KEY %s %s %s %s %s) STORED AS KUDU", block, nul, enc, comp, def));
                            this.ParsesOk(String.format("CREATE TABLE Foo (i int PRIMARY KEY %s %s %s %s %s) STORED AS KUDU", def, block, nul, enc, comp));
                            this.ParsesOk(String.format("CREATE TABLE Foo (i int PRIMARY KEY %s %s %s %s %s) STORED AS KUDU", comp, def, block, nul, enc));
                            this.ParsesOk(String.format("CREATE TABLE Foo (i int PRIMARY KEY %s %s %s %s %s) STORED AS KUDU", enc, comp, def, block, nul));
                            this.ParsesOk(String.format("CREATE TABLE Foo (i int PRIMARY KEY %s %s %s %s %s) STORED AS KUDU", enc, comp, block, def, nul));
                            this.ParsesOk(String.format("CREATE TABLE Foo (i int NON UNIQUE PRIMARY KEY %s %s %s %s %s) STORED AS KUDU", nul, enc, comp, def, block));
                        }
                    }
                }
            }
        }
        this.ParserError("CREATE TABLE Foo(a int PRIMARY KEY ENCODING RLE ENCODING PLAIN) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE Foo(a int PRIMARY KEY, b int DEFAULT 1+1) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE Foo(a int PRIMARY KEY, b float DEFAULT cast(1.1 as float)) STORED AS KUDU");
        this.ParserError("CREATE TABLE Foo(a int PRIMARY KEY, b int BLOCK_SIZE 1+1) STORED AS KUDU");
        this.ParserError("CREATE TABLE Foo(a int PRIMARY KEY BLOCK_SIZE -1) STORED AS KUDU");
        this.ParsesOk("CREATE TABLE bucketed_test (i int COMMENT 'hello', s string) CLUSTERED BY (i) INTO 24 BUCKETS");
        this.ParsesOk("CREATE TABLE bucketed_test (i int COMMENT 'hello', a int, s string) CLUSTERED BY (i, a) INTO 24 BUCKETS");
        this.ParsesOk("CREATE TABLE bucketed_test (i int COMMENT 'hello', s string) PARTITIONED BY(dt string) CLUSTERED BY (i) INTO 24 BUCKETS");
        this.ParsesOk("CREATE TABLE bucketed_test (i int COMMENT 'hello', s string) CLUSTERED BY (i) SORT BY(s) INTO 24 BUCKETS");
        this.ParsesOk("CREATE TABLE bucketed_test (i int COMMENT 'hello', s string) PARTITIONED BY(dt string) CLUSTERED BY (i) SORT BY (s) INTO 24 BUCKETS");
        this.ParserError("CREATE TABLE bucketed_test (i int COMMENT 'hello', s string) CLUSTERED BY (i)");
        this.ParserError("CREATE TABLE bucketed_test (i int COMMENT 'hello', s string) CLUSTERED INTO 24 BUCKETS ");
        this.ParserError("CREATE TABLE (i int, s string) CLUSTERED INTO 24 BUCKETS");
        this.ParserError("CREATE TABLE bucketed_test (i int COMMENT 'hello', s string) CLUSTERED BY (i) INTO BUCKETS");
        this.ParserError("CREATE TABLE bucketed_test (i int COMMENT 'hello', s string) PARTITIONED BY(dt string) CLUSTERED BY (i) INTO BUCKETS");
        this.ParserError("CREATE TABLE bucketed_test (i int COMMENT 'hello', s string) CLUSTERED BY (i) INTO 12 BUCKETS SORT BY (s)");
    }

    @Test
    public void TestCreateDataSource() {
        this.ParsesOk("CREATE DATA SOURCE foo LOCATION '/foo.jar' CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.ParsesOk("CREATE DATA SOURCE foo LOCATION \"/foo.jar\" CLASS \"com.bar.Foo\" API_VERSION \"V1\"");
        this.ParsesOk("CREATE DATA SOURCE foo LOCATION '/x/foo@hi_^!#.jar' CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.ParsesOk("CREATE DATA SOURCE foo CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.ParserError("CREATE DATA foo LOCATION '/foo.jar' CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.ParserError("CREATE DATA SRC foo.bar LOCATION '/foo.jar' CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.ParserError("CREATE DATA SOURCE foo.bar LOCATION '/x/foo.jar' CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.ParserError("CREATE DATA SOURCE foo LOCATION /x/foo.jar CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.ParserError("CREATE DATA SOURCE foo LOCATION '/x/foo.jar' CLASS com.bar.Foo API_VERSION 'V1'");
        this.ParserError("CREATE DATA SOURCE foo LOCATION '/x/foo.jar' CLASS 'com.bar.Foo' API_VERSION V1");
        this.ParserError("CREATE DATA SOURCE LOCATION '/x/foo.jar' CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.ParserError("CREATE DATA SOURCE foo LOCATION CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.ParserError("CREATE DATA SOURCE foo LOCATION '/foo.jar' API_VERSION 'V1'");
        this.ParserError("CREATE DATA SOURCE foo LOCATION '/foo.jar' CLASS API_VERSION 'V1'");
        this.ParserError("CREATE DATA SOURCE foo LOCATION '/foo.jar' CLASS 'com.bar.Foo'");
        this.ParserError("CREATE DATA SOURCE foo LOCATION '/foo.jar' CLASS 'Foo' API_VERSION");
        this.ParserError("CREATE DATA SOURCE foo CLASS 'com.bar.Foo' LOCATION '/x/foo.jar' API_VERSION 'V1'");
        this.ParserError("CREATE DATA SOURCE foo CLASS 'com.bar.Foo' API_VERSION 'V1' LOCATION '/x/foo.jar' ");
        this.ParserError("CREATE DATA SOURCE foo API_VERSION 'V1' LOCATION '/x/foo.jar' CLASS 'com.bar.Foo'");
    }

    @Test
    public void TestDropDataSource() {
        this.ParsesOk("DROP DATA SOURCE foo");
        this.ParserError("DROP DATA foo");
        this.ParserError("DROP DATA SRC foo");
        this.ParserError("DROP DATA SOURCE foo.bar");
        this.ParserError("DROP DATA SOURCE");
    }

    @Test
    public void TestCreateView() {
        this.ParsesOk("CREATE VIEW Bar AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW Bar COMMENT 'test' AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW Bar (x, y, z) AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW Bar (x, y COMMENT 'foo', z) AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW Bar (x, y, z) COMMENT 'test' AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW IF NOT EXISTS Bar AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW Foo.Bar AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW Foo.Bar COMMENT 'test' AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW Foo.Bar (x, y, z) AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW Foo.Bar (x, y, z COMMENT 'foo') AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW Foo.Bar (x, y, z) COMMENT 'test' AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW IF NOT EXISTS Foo.Bar AS SELECT a, b, c from t");
        this.ParsesOk("CREATE VIEW Bar AS SELECT 1, 2, 3");
        this.ParsesOk("CREATE VIEW Bar AS VALUES(1, 2, 3)");
        this.ParsesOk("CREATE VIEW Bar AS SELECT 1, 2, 3 UNION ALL select 4, 5, 6");
        this.ParsesOk("CREATE VIEW Bar AS WITH t AS (SELECT 1, 2, 3) SELECT * FROM t");
        this.ParsesOk("CREATE VIEW Bar (x, y) AS SELECT 1, 2, 3");
        this.ParsesOk("CREATE VIEW Bar (x, y, z) TBLPROPERTIES ('a' = 'b') AS SELECT 1, 2, 3");
        this.ParsesOk("CREATE VIEW Bar (x, y, z) TBLPROPERTIES ('a' = 'b', 'c' = 'd') AS SELECT 1, 2, 3");
        this.ParsesOk("CREATE VIEW Bar TBLPROPERTIES ('a' = 'b') AS VALUES(1, 2, 3)");
        this.ParsesOk("CREATE VIEW Bar TBLPROPERTIES ('a' = 'b') AS SELECT 1, 2, 3");
        this.ParsesOk("CREATE VIEW Bar TBLPROPERTIES ('a' = 'b', 'c' = 'd') AS SELECT 1, 2, 3");
        this.ParsesOk("CREATE VIEW Foo.Bar COMMENT 'test' TBLPROPERTIES ('a' = 'b') AS SELECT a, b, c from t");
        this.ParserError("CREATE VIEW AS SELECT c FROM t");
        this.ParserError("CREATE VIEW Bar SELECT c FROM t");
        this.ParserError("CREATE VIEW Foo.Bar () AS SELECT c FROM t");
        this.ParserError("CREATE VIEW Foo.Bar (x int) AS SELECT c FROM t");
        this.ParserError("CREATE VIEW Foo.Bar (x int COMMENT 'x') AS SELECT c FROM t");
        this.ParserError("CREATE VIEW Foo.Bar (int COMMENT 'x') AS SELECT c FROM t");
        this.ParserError("CREATE VIEW Foo.Bar (x) AS");
        this.ParserError("CREATE VIEW Foo.Bar (x) AS INSERT INTO t select * from t");
        this.ParserError("CREATE VIEW Foo.Bar (x) AS UPSERT INTO t select * from t");
        this.ParserError("CREATE VIEW Foo.Bar (x) AS CREATE TABLE Wrong (i int)");
        this.ParserError("CREATE VIEW Foo.Bar (x) AS ALTER TABLE Foo COLUMNS (i int, s string)");
        this.ParserError("CREATE VIEW Foo.Bar (x) AS CREATE VIEW Foo.Bar AS SELECT 1");
        this.ParserError("CREATE VIEW Foo.Bar (x) AS ALTER VIEW Foo.Bar AS SELECT 1");
        this.ParserError("CREATE VIEW Bar (x, y, z) TBLPROPERTIES () AS SELECT 1, 2, 3");
        this.ParserError("CREATE VIEW Bar (x, y, z) TBLPROPERTIES (i int) AS SELECT 1, 2, 3");
    }

    @Test
    public void TestAlterView() {
        this.ParsesOk("ALTER VIEW Bar AS SELECT 1, 2, 3");
        this.ParsesOk("ALTER VIEW Bar AS SELECT a, b, c FROM t");
        this.ParsesOk("ALTER VIEW Bar AS VALUES(1, 2, 3)");
        this.ParsesOk("ALTER VIEW Bar AS SELECT 1, 2, 3 UNION ALL select 4, 5, 6");
        this.ParsesOk("ALTER VIEW Bar (x, y, z) AS SELECT a, b, c from t");
        this.ParsesOk("ALTER VIEW Bar (x, y COMMENT 'foo', z) AS SELECT a, b, c from t");
        this.ParsesOk("ALTER VIEW Foo.Bar AS SELECT 1, 2, 3");
        this.ParsesOk("ALTER VIEW Foo.Bar AS SELECT a, b, c FROM t");
        this.ParsesOk("ALTER VIEW Foo.Bar AS VALUES(1, 2, 3)");
        this.ParsesOk("ALTER VIEW Foo.Bar AS SELECT 1, 2, 3 UNION ALL select 4, 5, 6");
        this.ParsesOk("ALTER VIEW Foo.Bar AS WITH t AS (SELECT 1, 2, 3) SELECT * FROM t");
        this.ParsesOk("ALTER VIEW Foo.Bar (x, y, z) AS SELECT a, b, c from t");
        this.ParsesOk("ALTER VIEW Foo.Bar (x, y, z COMMENT 'foo') AS SELECT a, b, c from t");
        this.ParsesOk("ALTER VIEW Bar (x, y) AS SELECT 1, 2, 3");
        this.ParsesOk("ALTER VIEW Foo.Bar SET TBLPROPERTIES ('pro1' = '1', 'pro2' = '2')");
        this.ParsesOk("ALTER VIEW Foo.Bar UNSET TBLPROPERTIES ('pro1', 'pro2')");
        this.ParserError("ALTER TABLE Foo.Bar AS SELECT 1, 2, 3");
        this.ParserError("ALTER VIEW AS SELECT 1, 2, 3");
        this.ParserError("ALTER VIEW Foo.Bar SELECT 1, 2, 3");
        this.ParserError("ALTER VIEW Foo.Bar AS");
        this.ParserError("ALTER VIEW Foo.Bar () AS SELECT c FROM t");
        this.ParserError("ALTER VIEW Foo.Bar (x int) AS SELECT c FROM t");
        this.ParserError("ALTER VIEW Foo.Bar (x int COMMENT 'x') AS SELECT c FROM t");
        this.ParserError("ALTER VIEW Foo.Bar (int COMMENT 'x') AS SELECT c FROM t");
        this.ParserError("ALTER VIEW Foo.Bar AS INSERT INTO t select * from t");
        this.ParserError("ALTER VIEW Foo.Bar AS UPSERT INTO t select * from t");
        this.ParserError("ALTER VIEW Foo.Bar AS CREATE TABLE Wrong (i int)");
        this.ParserError("ALTER VIEW Foo.Bar AS ALTER TABLE Foo COLUMNS (i int, s string)");
        this.ParserError("ALTER VIEW Foo.Bar AS CREATE VIEW Foo.Bar AS SELECT 1, 2, 3");
        this.ParserError("ALTER VIEW Foo.Bar AS ALTER VIEW Foo.Bar AS SELECT 1, 2, 3");
        this.ParserError("ALTER VIEW Foo.Bar SET TBLPROPERTIES ()");
        this.ParserError("ALTER VIEW Foo.Bar SET TBLPROPERTIES (int COMMENT 'x')");
        this.ParserError("ALTER VIEW Foo.Bar UNSET TBLPROPERTIES ()");
        this.ParserError("ALTER VIEW Foo.Bar UNSET TBLPROPERTIES (int COMMENT 'x')");
    }

    @Test
    public void TestCreateTableAsSelect() {
        this.ParsesOk("CREATE TABLE Foo AS SELECT 1, 2, 3");
        this.ParsesOk("CREATE TABLE Foo AS SELECT * from foo.bar");
        this.ParsesOk("CREATE TABLE Foo.Bar AS SELECT int_col, bool_col from tbl limit 10");
        this.ParsesOk("CREATE TABLE Foo.Bar LOCATION '/a/b' AS SELECT * from foo");
        this.ParsesOk("CREATE TABLE IF NOT EXISTS Foo.Bar LOCATION '/a/b' AS SELECT * from foo");
        this.ParsesOk("CREATE TABLE Foo STORED AS PARQUET AS SELECT 1");
        this.ParsesOk("CREATE TABLE Foo ROW FORMAT DELIMITED STORED AS PARQUETFILE AS SELECT 1");
        this.ParsesOk("CREATE TABLE Foo TBLPROPERTIES ('a'='b', 'c'='d') AS SELECT * from bar");
        this.ParsesOk("CREATE TABLE Foo PRIMARY KEY (a, b) AS SELECT * from bar");
        this.ParsesOk("CREATE TABLE Foo PRIMARY KEY (a, b) PARTITION BY HASH PARTITIONS 2 AS SELECT * from bar");
        this.ParsesOk("CREATE TABLE Foo PRIMARY KEY (a, b) PARTITION BY HASH (b) PARTITIONS 2 AS SELECT * from bar");
        this.ParsesOk("CREATE TABLE Foo AS with t1 as (select 1) select * from t1");
        this.ParserError("CREATE TABLE Foo ROW FORMAT DELIMITED STORED AS PARQUET AS SELECT");
        this.ParserError("CREATE TABLE Foo ROW FORMAT DELIMITED STORED AS PARQUET AS WITH");
        this.ParserError("CREATE TABLE Foo ROW FORMAT DELIMITED STORED AS PARQUET AS");
        this.ParserError("CREATE TABLE Foo AS INSERT INTO Foo SELECT 1");
        this.ParserError("CREATE TABLE Foo AS UPSERT INTO Foo SELECT 1");
        this.ParserError("CREATE TABLE Foo(i int) AS SELECT 1");
        this.ParserError("CREATE TABLE Foo PARTITIONED BY(i int) AS SELECT 1");
        this.ParsesOk("CREATE TABLE Foo PARTITIONED BY (a) AS SELECT 1");
        this.ParsesOk("CREATE TABLE Foo PARTITIONED BY (a) ROW FORMAT DELIMITED STORED AS PARQUETFILE AS SELECT 1");
        this.ParsesOk("CREATE TABLE Foo PARTITIONED BY (a) AS SELECT 1, 2");
        this.ParsesOk("CREATE TABLE Foo PARTITIONED BY (a) AS SELECT * from Bar");
        this.ParsesOk("CREATE TABLE Foo PARTITIONED BY (a, b) AS SELECT * from Bar");
        this.ParserError("CREATE TABLE Foo PARTITIONED BY (a=2, b) AS SELECT * from Bar");
        this.ParserError("CREATE TABLE Foo PARTITIONED BY (a, b=2) AS SELECT * from Bar");
        this.ParsesOk("CREATE TABLE Foo PRIMARY KEY (i) PARTITION BY HASH(i) PARTITIONS 4 AS SELECT 1");
        this.ParsesOk("CREATE TABLE Foo PARTITION BY HASH(i) PARTITIONS 4 AS SELECT 1");
        this.ParsesOk("CREATE TABLE Foo PRIMARY KEY (a) PARTITION BY HASH(a) PARTITIONS 4 TBLPROPERTIES ('a'='b', 'c'='d') AS SELECT * from bar");
        this.ParsesOk("CREATE TABLE Foo PRIMARY KEY (a) PARTITION BY RANGE(a) (PARTITION 1 < VALUES < 10, PARTITION 10 <= VALUES < 20, PARTITION VALUE = 30) STORED AS KUDU AS SELECT * FROM Bar");
        this.ParsesOk("CREATE TABLE Foo NON UNIQUE PRIMARY KEY (a) PARTITION BY HASH (a) PARTITIONS 2 STORED AS KUDU AS SELECT * FROM Bar");
        this.ParsesOk("CREATE TABLE Foo PARTITION BY RANGE(a) (PARTITION 1 < VALUES < 10, PARTITION 10 <= VALUES < 20,  PARTITION VALUE = 30) STORED AS KUDU AS SELECT * FROM Bar");
        this.ParsesOk("CREATE TABLE Foo PARTITION BY HASH (a) PARTITIONS 2 STORED AS KUDU AS SELECT * FROM Bar");
    }

    @Test
    public void TestDrop() {
        String[] purgeKw;
        for (String kw : purgeKw = new String[]{"PURGE", ""}) {
            this.ParsesOk(String.format("DROP TABLE Foo %s", kw));
            this.ParsesOk(String.format("DROP TABLE Foo.Bar %s", kw));
            this.ParsesOk(String.format("DROP TABLE IF EXISTS Foo %s", kw));
            this.ParsesOk(String.format("DROP TABLE IF EXISTS Foo.Bar %s", kw));
        }
        this.ParsesOk("DROP VIEW Foo");
        this.ParsesOk("DROP VIEW Foo.Bar");
        this.ParsesOk("DROP VIEW IF EXISTS Foo.Bar");
        this.ParsesOk("DROP DATABASE Foo");
        this.ParsesOk("DROP DATABASE Foo CASCADE");
        this.ParsesOk("DROP DATABASE Foo RESTRICT");
        this.ParsesOk("DROP SCHEMA Foo");
        this.ParsesOk("DROP DATABASE IF EXISTS Foo");
        this.ParsesOk("DROP DATABASE IF EXISTS Foo CASCADE");
        this.ParsesOk("DROP DATABASE IF EXISTS Foo RESTRICT");
        this.ParsesOk("DROP SCHEMA IF EXISTS Foo");
        this.ParsesOk("DROP FUNCTION Foo()");
        this.ParsesOk("DROP AGGREGATE FUNCTION Foo(INT)");
        this.ParsesOk("DROP FUNCTION Foo.Foo(INT)");
        this.ParsesOk("DROP AGGREGATE FUNCTION IF EXISTS Foo()");
        this.ParsesOk("DROP FUNCTION IF EXISTS Foo(INT)");
        this.ParsesOk("DROP FUNCTION IF EXISTS Foo(INT...)");
        this.ParsesOk("DROP FUNCTION Foo");
        this.ParsesOk("DROP FUNCTION IF EXISTS Foo");
        this.ParserError("DROP");
        this.ParserError("DROP Foo");
        this.ParserError("DROP DATABASE Foo.Bar");
        this.ParserError("DROP SCHEMA Foo.Bar");
        this.ParserError("DROP SCHEMA Foo PURGE");
        this.ParserError("DROP DATABASE Foo Bar");
        this.ParserError("DROP DATABASE Foo PURGE");
        this.ParserError("DROP DATABASE CASCADE Foo");
        this.ParserError("DROP DATABASE CASCADE RESTRICT Foo");
        this.ParserError("DROP DATABASE RESTRICT CASCADE Foo");
        this.ParserError("DROP CASCADE DATABASE IF EXISTS Foo");
        this.ParserError("DROP RESTRICT DATABASE IF EXISTS Foo");
        this.ParserError("DROP SCHEMA Foo Bar");
        this.ParserError("DROP TABLE IF Foo");
        this.ParserError("DROP TABLE EXISTS Foo");
        this.ParserError("DROP IF EXISTS TABLE Foo");
        this.ParserError("DROP TBL Foo");
        this.ParserError("DROP VIEW IF Foo");
        this.ParserError("DROP VIEW EXISTS Foo");
        this.ParserError("DROP IF EXISTS VIEW Foo");
        this.ParserError("DROP VIW Foo");
        this.ParserError("DROP VIEW Foo purge");
        this.ParserError("DROP FUNCTION Foo)");
        this.ParserError("DROP FUNCTION Foo(");
        this.ParserError("DROP FUNCTION Foo PURGE");
        this.ParserError("DROP FUNCTION");
        this.ParserError("DROP BLAH FUNCTION");
        this.ParserError("DROP IF EXISTS FUNCTION Foo()");
        this.ParserError("DROP FUNCTION Foo RETURNS INT");
        this.ParserError("DROP FUNCTION Foo(INT) RETURNS INT");
        this.ParserError("DROP FUNCTION Foo.(INT) RETURNS INT");
        this.ParserError("DROP FUNCTION Foo..(INT) RETURNS INT");
        this.ParserError("DROP FUNCTION Foo(NULL) RETURNS INT");
        this.ParserError("DROP FUNCTION Foo(INT) RETURNS NULL");
        this.ParserError("DROP BLAH FUNCTION IF EXISTS Foo.A.Foo(INT)");
        this.ParserError("DROP FUNCTION IF EXISTS Foo(...)");
    }

    @Test
    public void TestTruncateTable() {
        this.ParsesOk("TRUNCATE TABLE Foo");
        this.ParsesOk("TRUNCATE TABLE Foo.Bar");
        this.ParsesOk("TRUNCATE Foo");
        this.ParsesOk("TRUNCATE Foo.Bar");
        this.ParserError("TRUNCATE");
        this.ParserError("TRUNCATE TABLE");
        this.ParserError("TRUNCATE TBL Foo");
        this.ParserError("TRUNCATE VIEW Foo");
        this.ParserError("TRUNCATE DATABASE Foo");
    }

    @Test
    public void TestLoadData() {
        this.ParsesOk("LOAD DATA INPATH '/a/b' INTO TABLE Foo");
        this.ParsesOk("LOAD DATA INPATH '/a/b' INTO TABLE Foo.Bar");
        this.ParsesOk("LOAD DATA INPATH '/a/b' OVERWRITE INTO TABLE Foo.Bar");
        this.ParsesOk("LOAD DATA INPATH '/a/b' INTO TABLE Foo PARTITION(a=1, b='asdf')");
        this.ParsesOk("LOAD DATA INPATH '/a/b' INTO TABLE Foo PARTITION(a=1)");
        this.ParserError("LOAD DATA INPATH '/a/b' INTO Foo PARTITION(a=1)");
        this.ParserError("LOAD DATA INPATH '/a/b' INTO Foo PARTITION(a)");
        this.ParserError("LOAD DATA INPATH '/a/b' INTO Foo PARTITION");
        this.ParserError("LOAD DATA INPATH /a/b/c INTO Foo");
        this.ParserError("LOAD DATA INPATH /a/b/c INTO Foo");
        this.ParserError("LOAD DATA LOCAL INPATH '/a/b' INTO TABLE Foo");
    }

    private void TypeDefsParseOk(String ... typeDefs) {
        for (String typeDefStr : typeDefs) {
            this.ParsesOk(String.format("CREATE TABLE t (i %s)", typeDefStr));
            this.ParsesOk(String.format("SELECT CAST (i AS %s)", typeDefStr));
            this.ParsesOk(String.format("CREATE TABLE t (i MAP<%s, %s>)", typeDefStr, typeDefStr));
            this.ParsesOk(String.format("CREATE TABLE t (i ARRAY<%s>)", typeDefStr));
            this.ParsesOk(String.format("CREATE TABLE t (i STRUCT<f:%s>)", typeDefStr));
        }
    }

    private void TypeDefsError(String ... typeDefs) {
        for (String typeDefStr : typeDefs) {
            this.ParserError(String.format("CREATE TABLE t (i %s)", typeDefStr));
            this.ParserError(String.format("SELECT CAST (i AS %s)", typeDefStr));
        }
    }

    @Test
    public void TestTypes() {
        this.TypeDefsParseOk("BOOLEAN");
        this.TypeDefsParseOk("TINYINT");
        this.TypeDefsParseOk("SMALLINT");
        this.TypeDefsParseOk("INT", "INTEGER");
        this.TypeDefsParseOk("BIGINT");
        this.TypeDefsParseOk("FLOAT");
        this.TypeDefsParseOk("DOUBLE", "REAL");
        this.TypeDefsParseOk("STRING");
        this.TypeDefsParseOk("CHAR(1)", "CHAR(20)");
        this.TypeDefsParseOk("VARCHAR(1)", "VARCHAR(20)");
        this.TypeDefsParseOk("BINARY");
        this.TypeDefsParseOk("DECIMAL");
        this.TypeDefsParseOk("TIMESTAMP");
        this.TypeDefsParseOk("DATE");
        this.TypeDefsParseOk("DECIMAL");
        this.TypeDefsParseOk("DECIMAL(1)");
        this.TypeDefsParseOk("DECIMAL(1, 2)");
        this.TypeDefsParseOk("DECIMAL(2, 1)");
        this.TypeDefsParseOk("DECIMAL(6, 6)");
        this.TypeDefsParseOk("DECIMAL(100, 0)");
        this.TypeDefsParseOk("DECIMAL(0, 0)");
        this.TypeDefsError("DECIMAL()");
        this.TypeDefsError("DECIMAL(a)");
        this.TypeDefsError("DECIMAL(1, a)");
        this.TypeDefsError("DECIMAL(1, 2, 3)");
        this.TypeDefsError("DECIMAL(-1)");
        this.TypeDefsParseOk("ARRAY<BIGINT>");
        this.TypeDefsParseOk("MAP<TINYINT, DOUBLE>");
        this.TypeDefsParseOk("STRUCT<f:TINYINT>");
        this.TypeDefsParseOk("STRUCT<a:TINYINT, b:BIGINT, c:DOUBLE>");
        this.TypeDefsParseOk("STRUCT<a:TINYINT COMMENT 'x', b:BIGINT, c:DOUBLE COMMENT 'y'>");
        for (String keyword : SqlScanner.keywordMap.keySet()) {
            if (!MetastoreShim.validateName((String)keyword)) continue;
            String structType = "STRUCT<" + keyword + ":INT>";
            this.TypeDefsParseOk(structType);
        }
        this.TypeDefsError("CHAR()");
        this.TypeDefsError("CHAR(1, 1)");
        this.TypeDefsError("ARRAY<>");
        this.TypeDefsError("ARRAY BIGINT");
        this.TypeDefsError("MAP<>");
        this.TypeDefsError("MAP<TINYINT>");
        this.TypeDefsError("MAP<TINYINT, BIGINT, DOUBLE>");
        this.TypeDefsError("STRUCT<>");
        this.TypeDefsError("STRUCT<TINYINT>");
        this.TypeDefsError("STRUCT<a TINYINT>");
        this.TypeDefsError("STRUCT<'a':TINYINT>");
    }

    @Test
    public void TestResetMetadata() {
        this.ParsesOk("invalidate metadata");
        this.ParsesOk("invalidate metadata Foo");
        this.ParsesOk("invalidate metadata Foo.S");
        this.ParsesOk("refresh Foo");
        this.ParsesOk("refresh Foo.S");
        this.ParsesOk("refresh Foo partition (col=2)");
        this.ParsesOk("refresh Foo partition (col=2) partition (col=3)");
        this.ParsesOk("refresh Foo.S partition (col=2)");
        this.ParsesOk("refresh Foo.S partition (col1 = 2, col2 = 3)");
        this.ParsesOk("refresh Foo.S partition (col1 = 2, col2 = 3) partition (col1 = 0, col2 = 0) partition (col1 = 1, col2 = 1)");
        this.ParsesOk("refresh functions Foo");
        this.ParsesOk("refresh authorization");
        this.ParserError("invalidate");
        this.ParserError("invalidate metadata Foo.S.S");
        this.ParserError("invalidate metadata partition (col=2)");
        this.ParserError("invalidate metadata Foo.S partition (col=2)");
        this.ParserError("REFRESH Foo.S.S");
        this.ParserError("refresh");
        this.ParserError("refresh Foo.S partition (col1 = 2, col2)");
        this.ParserError("refresh Foo.S partition ()");
        this.ParserError("refresh Foo.S partition (col1 = 0), (col1 = 1)");
        this.ParserError("refresh functions Foo.S");
        this.ParserError("refresh authorization Foo");
    }

    @Test
    public void TestComputeDropStats() {
        String[] prefixes = new String[]{"compute", "drop"};
        String[] okSuffixes = new String[]{"stats bar", "stats `bar`", "stats foo.bar", "stats `foo`.`bar`"};
        String[] okComputeSuffixes = new String[]{"(ab)", "(ab, bc)", "()"};
        String[] errorSuffixes = new String[]{"stats", "`bar`", "stats 'foo'", "stats foo bar"};
        for (String prefix : prefixes) {
            for (String suffix : okSuffixes) {
                this.ParsesOk(prefix + " " + suffix);
            }
            for (String suffix : errorSuffixes) {
                this.ParserError(prefix + " " + suffix);
            }
        }
        for (String suffix : okSuffixes) {
            for (String computeSuffix : okComputeSuffixes) {
                this.ParsesOk("compute " + suffix + " " + computeSuffix);
            }
        }
    }

    @Test
    public void TestGetErrorMsg() {
        this.ParserError("c, b, c from t", "Syntax error in line 1:\nc, b, c from t\n^\nEncountered: IDENTIFIER\nExpected: ALTER, COMMENT, COMPUTE, COPY, CREATE, DELETE, DESCRIBE, DROP, EXPLAIN, GRANT, INSERT, INVALIDATE, KILL, LOAD, MERGE, OPTIMIZE, REFRESH, REVOKE, SELECT, SET, SHOW, TRUNCATE, UNSET, UPDATE, UPSERT, USE, VALUES, WITH\n");
        this.ParserError("select from t", "Syntax error in line 1:\nselect from t\n       ^\nEncountered: FROM\nExpected: ALL, CASE, CAST, DATE, DISTINCT, EXISTS, FALSE, GROUPING, IF, INTERVAL, LEFT, NOT, NULL, REPLACE, RIGHT, STRAIGHT_JOIN, TRUNCATE, TRUE, UNNEST, IDENTIFIER\n\nHint: reserved words have to be escaped when used as an identifier, e.g. `from`");
        this.ParserError("select c, b, c where a = 5", "Syntax error in line 1:\nselect c, b, c where a = 5\n               ^\nEncountered: WHERE\nExpected: AND, AS, BETWEEN, DIV, EXCEPT, FROM, ILIKE, IN, INTERSECT, IREGEXP, IS, LIKE, LIMIT, ||, MINUS, NOT, OR, ORDER, REGEXP, RLIKE, UNION, COMMA, IDENTIFIER\n\nHint: reserved words have to be escaped when used as an identifier, e.g. `where`");
        this.ParserError("select c, b, c from where a = 5", "Syntax error in line 1:\nselect c, b, c from where a = 5\n                    ^\nEncountered: WHERE\nExpected: UNNEST, IDENTIFIER\n\nHint: reserved words have to be escaped when used as an identifier, e.g. `where`");
        this.ParserError("select c, b, c from t where", "Syntax error in line 1:\nselect c, b, c from t where\n                           ^\nEncountered: EOF\nExpected: CASE, CAST, DATE, EXISTS, FALSE, GROUPING, IF, INTERVAL, LEFT, NOT, NULL, REPLACE, RIGHT, STRAIGHT_JOIN, TRUNCATE, TRUE, UNNEST, IDENTIFIER");
        this.ParserError("select c, b, c from t where group by a, b", "Syntax error in line 1:\nselect c, b, c from t where group by a, b\n                            ^\nEncountered: GROUP\nExpected: CASE, CAST, DATE, EXISTS, FALSE, GROUPING, IF, INTERVAL, LEFT, NOT, NULL, REPLACE, RIGHT, STRAIGHT_JOIN, TRUNCATE, TRUE, UNNEST, IDENTIFIER\n\nHint: reserved words have to be escaped when used as an identifier, e.g. `group`");
        this.ParserError("select c, \"b, c from t", "Unmatched string literal in line 1:\nselect c, \"b, c from t\n           ^\n");
        this.ParserError("select c, 'b, c from t", "Unmatched string literal in line 1:\nselect c, 'b, c from t\n           ^\n");
        this.ParserError("select (i + 5)(1 - i) from t", "Syntax error in line 1:\nselect (i + 5)(1 - i) from t\n              ^\nEncountered: (\nExpected:");
        this.ParserError("select (i + 5)\n(1 - i) from t", "Syntax error in line 2:\n(1 - i) from t\n^\nEncountered: (\nExpected");
        this.ParserError("select (i + 5)\n(1 - i)\nfrom t", "Syntax error in line 2:\n(1 - i)\n^\nEncountered: (\nExpected");
        this.ParserError("select c, b, c,c,c,c,c,c,c,c,c,a a a,c,c,c,c,c,c,c,cd,c,d,d,,c, from t", "Syntax error in line 1:\n... b, c,c,c,c,c,c,c,c,c,a a a,c,c,c,c,c,c,c,cd,c,d,d,,c,...\n                             ^\nEncountered: IDENTIFIER\nExpected: CROSS, EXCEPT, FROM, FULL, GROUP, HAVING, INNER, INTERSECT, JOIN, LEFT, LIMIT, MINUS, OFFSET, ON, ORDER, RIGHT, STRAIGHT_JOIN, TABLESAMPLE, UNION, USING, WHERE, COMMA\n");
        this.ParserError("select a a a, b, c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,cd,c,d,d,,c, from t", "Syntax error in line 1:\nselect a a a, b, c,c,c,c,c,c,c,c,c,c,c,...\n           ^\nEncountered: IDENTIFIER\nExpected: CROSS, EXCEPT, FROM, FULL, GROUP, HAVING, INNER, INTERSECT, JOIN, LEFT, LIMIT, MINUS, OFFSET, ON, ORDER, RIGHT, STRAIGHT_JOIN, TABLESAMPLE, UNION, USING, WHERE, COMMA\n");
        this.ParserError("select a, b, c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,cd,c,d,d, ,c, from t", "Syntax error in line 1:\n...c,c,c,c,c,c,c,c,cd,c,d,d, ,c, from t\n                             ^\nEncountered: COMMA\nExpected: CASE, CAST, DATE, EXISTS, FALSE, GROUPING, IF, INTERVAL, LEFT, NOT, NULL, REPLACE, RIGHT, TRUNCATE, TRUE, UNNEST, IDENTIFIER");
        this.ParserError("DROP DATA SRC foo", "Syntax error in line 1:\nDROP DATA SRC foo\n          ^\nEncountered: IDENTIFIER\nExpected: SOURCE\n");
        this.ParserError("SHOW DATA SRCS", "Syntax error in line 1:\nSHOW DATA SRCS\n          ^\nEncountered: IDENTIFIER\nExpected: SOURCES\n");
        this.ParserError("USE ` `", "Syntax error in line 1:\nUSE ` `\n    ^\nEncountered: EMPTY IDENTIFIER\nExpected: IDENTIFIER\n");
        this.ParserError("SET foo", "Syntax error in line 1:\nSET foo\n       ^\nEncountered: EOF\nExpected: =\n");
        this.ParserError("SELECT\n", "Syntax error in line 2:\n\n^\nEncountered: EOF\nExpected: ALL, CASE, CAST, DATE, DISTINCT, EXISTS, FALSE, GROUPING, IF, INTERVAL, LEFT, NOT, NULL, REPLACE, RIGHT, STRAIGHT_JOIN, TRUNCATE, TRUE, UNNEST, IDENTIFIER\n");
        this.ParserError("SELECT\n\n", "Syntax error in line 3:\n\n^\nEncountered: EOF\nExpected: ALL, CASE, CAST, DATE, DISTINCT, EXISTS, FALSE, GROUPING, IF, INTERVAL, LEFT, NOT, NULL, REPLACE, RIGHT, STRAIGHT_JOIN, TRUNCATE, TRUE, UNNEST, IDENTIFIER\n");
    }

    @Test
    public void TestExplain() {
        this.ParsesOk("explain select a from tbl");
        this.ParsesOk("explain insert into tbl select a, b, c, d from tbl");
        this.ParsesOk("explain upsert into tbl select a, b, c, d from tbl");
        this.ParserError("explain");
        this.ParserError("explain explain select a from tbl");
        this.ParserError("explain CREATE TABLE Foo (i int)");
    }

    @Test
    public void TestSubqueries() {
        String[] operators;
        String subquery = "(SELECT count(*) FROM bar)";
        for (String op : operators = new String[]{"=", "!=", "<>", ">", ">=", "<", "<=", "<=>", "IS DISTINCT FROM", "IS NOT DISTINCT FROM"}) {
            this.ParsesOk(String.format("SELECT * FROM foo WHERE a %s %s", op, subquery));
            this.ParsesOk(String.format("SELECT * FROM foo WHERE %s %s a", subquery, op));
        }
        this.ParsesOk("SELECT * FROM foo WHERE a+1 > (SELECT count(a) FROM bar)");
        this.ParsesOk("SELECT * FROM foo WHERE (SELECT count(a) FROM bar) < a+1");
        this.ParsesOk("SELECT * FROM foo WHERE a IN (SELECT a FROM bar)");
        this.ParsesOk("SELECT * FROM foo WHERE a NOT IN (SELECT a FROM bar)");
        this.ParsesOk("SELECT * FROM foo WHERE EXISTS (SELECT a FROM bar WHERE b > 0)");
        this.ParsesOk("SELECT * FROM foo WHERE NOT EXISTS (SELECT a FROM bar WHERE b > 0)");
        this.ParsesOk("SELECT * FROM foo WHERE NOT (EXISTS (SELECT a FROM bar))");
        this.ParsesOk("SELECT * FROM foo WHERE a = (SELECT count(a) FROM bar) AND b != (SELECT count(b) FROM baz) and c IN (SELECT c FROM qux)");
        this.ParsesOk("SELECT * FROM foo WHERE EXISTS (SELECT a FROM bar WHERE b < 0) AND NOT EXISTS (SELECT a FROM baz WHERE b > 0)");
        this.ParsesOk("SELECT * FROM foo WHERE EXISTS (SELECT a from bar) AND NOT EXISTS (SELECT a FROM baz) AND b IN (SELECT b FROM bar) AND c NOT IN (SELECT c FROM qux) AND d = (SELECT max(d) FROM quux)");
        this.ParsesOk("SELECT * FROM foo WHERE EXISTS ((SELECT * FROM bar))");
        this.ParsesOk("SELECT * FROM foo WHERE EXISTS (((SELECT * FROM bar)))");
        this.ParsesOk("SELECT * FROM foo WHERE a IN ((SELECT a FROM bar))");
        this.ParsesOk("SELECT * FROM foo WHERE a = ((SELECT max(a) FROM bar))");
        this.ParsesOk("SELECT * FROM foo WHERE a IN (SELECT a FROM bar WHERE b IN (SELECT b FROM baz))");
        this.ParsesOk("SELECT * FROM foo WHERE EXISTS (SELECT a FROM bar WHERE b NOT IN (SELECT b FROM baz WHERE c < 10 AND d = (SELECT max(d) FROM qux)))");
        for (String op : operators) {
            this.ParsesOk(String.format("SELECT * FROM foo WHERE %s %s %s", subquery, op, subquery));
        }
        this.ParserError("SELECT * FROM foo WHERE a IN SELECT a FROM bar");
        this.ParserError("SELECT * FROM foo WHERE a = SELECT count(*) FROM bar");
        this.ParserError("SELECT * FROM foo WHERE EXISTS SELECT * FROM bar");
        this.ParserError("SELECT * FROM foo WHERE a IN (SELECT a FROM bar");
        this.ParserError("SELECT * FROM foo WHERE a IN SELECT a FROM bar)");
        this.ParserError("SELECT * FROM foo WHERE a IN (SELECT) a FROM bar");
        this.ParserError("SELECT * FROM foo WHERE a EXISTS (SELECT * FROM bar)");
        this.ParserError("SELECT * FROM foo WHERE a NOT EXISTS (SELECT * FROM bar)");
        this.ParserError("SELECT * FROM foo WHERE EXISTS ((SELECT a FROM bar) UNION (SELECT a FROM baz))");
        this.ParsesOk("SELECT a, count(*) FROM foo GROUP BY a HAVING count(*) > (SELECT count(*) FROM bar)");
        this.ParsesOk("SELECT a, count(*) FROM foo GROUP BY a HAVING 10 > (SELECT count(*) FROM bar)");
        this.ParsesOk("SELECT a, b, (SELECT c FROM foo) FROM foo");
        this.ParsesOk("SELECT (SELECT a FROM foo), b, c FROM bar");
        this.ParsesOk("SELECT (SELECT (SELECT a FROM foo) FROM bar) FROM baz");
        this.ParsesOk("SELECT (SELECT a FROM foo)");
        this.ParserError("SELECT SELECT a FROM foo FROM bar");
        this.ParserError("SELECT (SELECT a FROM foo FROM bar");
        this.ParserError("SELECT SELECT a FROM foo) FROM bar");
        this.ParserError("SELECT (SELECT) a FROM foo");
        this.ParsesOk("SELECT a, count(*) FROM foo GROUP BY (SELECT a FROM bar)");
        this.ParsesOk("SELECT a, count(*) FROM foo GROUP BY a, (SELECT b FROM bar)");
        this.ParserError("SELECT a, count(*) FROM foo GROUP BY SELECT a FROM bar");
        this.ParserError("SELECT a, count(*) FROM foo GROUP BY (SELECT) a FROM bar");
        this.ParserError("SELECT a, count(*) FROM foo GROUP BY (SELECT a FROM bar");
        this.ParsesOk("SELECT a, b FROM foo ORDER BY (SELECT a FROM bar)");
        this.ParsesOk("SELECT a, b FROM foo ORDER BY (SELECT a FROM bar) DESC");
        this.ParsesOk("SELECT a, b FROM foo ORDER BY a ASC, (SELECT a FROM bar) DESC");
        this.ParserError("SELECT a, count(*) FROM foo ORDER BY SELECT a FROM bar");
        this.ParserError("SELECT a, count(*) FROM foo ORDER BY (SELECT) a FROM bar DESC");
        this.ParserError("SELECT a, count(*) FROM foo ORDER BY (SELECT a FROM bar ASC");
    }

    @Test
    public void TestRollup() {
        this.ParsesOk("SELECT a FROM foo GROUP BY ROLLUP(a)");
        this.ParsesOk("SELECT a, b FROM foo GROUP BY ROLLUP(a, b)");
        this.ParsesOk("SELECT a FROM foo GROUP BY a WITH ROLLUP");
        this.ParsesOk("SELECT a, b FROM foo GROUP BY a, b WITH ROLLUP");
        this.ParserError("SELECT a, b FROM foo GROUP BY ROLLUP(a, b) WITH ROLLUP");
        this.ParserError("SELECT a, b FROM foo GROUP BY ROLLUP(a, ROLLUP(b, c))");
        this.ParserError("SELECT a, b FROM foo GROUP BY ROLLUP(a, CUBE(b, c))");
        this.ParserError("SELECT a, b FROM foo GROUP BY c, ROLLUP(a, b)");
        this.ParserError("SELECT a, b FROM foo GROUP BY ROLLUP(a, b), c");
        this.ParserError("SELECT a, b FROM foo GROUP BY ROLLUP(a, b), ROLLUP(c)");
        this.ParserError("SELECT a, b FROM foo GROUP BY ROLLUP(a, b), CUBE(c, d)");
        this.ParserError("SELECT count(*) FROM foo GROUP BY ROLLUP()");
        this.ParsesOk("SELECT a, b FROM foo GROUP BY ROLLUP((a), (b))");
    }

    @Test
    public void TestCube() {
        this.ParsesOk("SELECT a FROM foo GROUP BY CUBE(a)");
        this.ParsesOk("SELECT a, b FROM foo GROUP BY CUBE(a, b)");
        this.ParsesOk("SELECT a FROM foo GROUP BY a WITH CUBE");
        this.ParsesOk("SELECT a, b FROM foo GROUP BY a, b WITH CUBE");
        this.ParserError("SELECT a, b FROM foo GROUP BY CUBE(a, b) WITH CUBE");
        this.ParserError("SELECT a, b FROM foo GROUP BY CUBE(a, ROLLUP(b, c))");
        this.ParserError("SELECT a, b FROM foo GROUP BY CUBE(a, CUBE(b, c))");
        this.ParserError("SELECT a, b FROM foo GROUP BY c, CUBE(a, b)");
        this.ParserError("SELECT a, b FROM foo GROUP BY CUBE(a, b), c");
        this.ParserError("SELECT a, b FROM foo GROUP BY CUBE(a, b), CUBE(c)");
        this.ParserError("SELECT count(*) FROM foo GROUP BY CUBE()");
        this.ParsesOk("SELECT a, b FROM foo GROUP BY CUBE((a), (b))");
    }

    @Test
    public void TestGroupingSets() {
        this.ParsesOk("SELECT a FROM foo GROUP BY GROUPING SETS((a, b))");
        this.ParsesOk("SELECT a FROM foo GROUP BY GROUPING SETS((a, b), (a), ())");
        this.ParserError("SELECT a FROM foo GROUP BY GROUPING SETS(ROLLUP(a, b), (a), ())");
        this.ParserError("SELECT a FROM foo GROUP BY GROUPING SETS((a, b), CUBE(a), ())");
        this.ParserError("SELECT a FROM foo GROUP BY GROUPING SETS((a, b), GROUPING SETS ((a, b, c), (b, c)))");
        this.ParserError("SELECT a FROM foo GROUP BY a, b, GROUPING SETS(a, b)");
        this.ParserError("SELECT a FROM foo GROUP BY CUBE(a, b), GROUPING SETS(a, b)");
        this.ParsesOk("SELECT a FROM foo GROUP BY GROUPING SETS(())");
        this.ParserError("SELECT a FROM foo GROUP BY GROUPING SETS()");
        this.ParserError("SELECT a FROM foo GROUP BY GROUPING SETS((), ((a), (b))");
    }

    @Test
    public void TestGroupingKeyword() {
        this.ParsesOk("SELECT a, grouping(a) FROM foo GROUP BY GROUPING SETS((a, b))");
        this.ParsesOk("SELECT a, gRoUpInG(a) FROM foo GROUP BY GROUPING SETS((a, b))");
        this.ParsesOk("SELECT a, `grouping`(a) FROM foo GROUP BY GROUPING SETS((a, b))");
        this.ParsesOk("SELECT a, grouping(a) as `grouping` FROM foo GROUP BY GROUPING SETS((a, b))");
        this.ParserError("SELECT a, grouping(a) as grouping FROM foo GROUP BY GROUPING SETS((a, b))");
    }

    @Test
    public void TestSet() {
        this.ParsesOk("SET foo='bar'");
        this.ParsesOk("SET foo=\"bar\"");
        this.ParsesOk("SET foo=bar");
        this.ParsesOk("SET foo = bar");
        this.ParsesOk("SET foo=1");
        this.ParsesOk("SET foo=true");
        this.ParsesOk("SET foo=false");
        this.ParsesOk("SET foo=1.2");
        this.ParsesOk("SET foo=null");
        this.ParsesOk("SET foo=10g");
        this.ParsesOk("SET `foo`=0");
        this.ParsesOk("SET foo=''");
        this.ParsesOk("SET");
        this.ParserError("SET foo");
        this.ParserError("SET foo=");
        this.ParserError("SET foo=1+2");
        this.ParserError("SET foo = '10");
    }

    @Test
    public void TestCreateDropRole() {
        this.ParsesOk("CREATE ROLE foo");
        this.ParsesOk("DROP ROLE foo");
        this.ParsesOk("DROP ROLE foo");
        this.ParsesOk("CREATE ROLE `role`");
        this.ParsesOk("DROP ROLE  `role`");
        this.ParserError("CREATE ROLE");
        this.ParserError("DROP ROLE");
        this.ParserError("CREATE ROLE 'foo'");
        this.ParserError("DROP ROLE 'foo'");
    }

    @Test
    public void TestGrantRevokeRole() {
        this.ParsesOk("GRANT ROLE foo TO GROUP bar");
        this.ParsesOk("REVOKE ROLE foo FROM GROUP bar");
        this.ParsesOk("GRANT ROLE `foo` TO GROUP `bar`");
        this.ParserError("GRANT ROLE foo TO GROUP");
        this.ParserError("GRANT ROLE foo FROM GROUP bar");
        this.ParserError("REVOKE ROLE foo FROM GROUP");
        this.ParserError("REVOKE ROLE foo TO GROUP bar");
    }

    @Test
    public void TestGrantRevokePrivilege() {
        String[][] grantRevoke = new String[][]{{"GRANT", "TO"}, {"REVOKE", "FROM"}};
        String[] resources = new String[]{"SERVER", "SERVER foo", "DATABASE foo", "TABLE foo", "URI 'foo'"};
        String[] badResources = new String[]{"DATABASE", "TABLE", "URI", "URI foo", "TABLE 'foo'", "SERVER 'foo'", "DATABASE 'foo'"};
        String[] privileges = new String[]{"SELECT", "INSERT", "ALL", "REFRESH", "CREATE", "ALTER", "DROP"};
        String[] badPrivileges = new String[]{"UPDATE", "DELETE", "UPSERT", "FAKE"};
        String[] columnPrivResource = new String[]{"SELECT (a, b) ON TABLE foo", "SELECT () on TABLE foo", "INSERT (a, b) ON TABLE foo", "ALL (a, b) ON TABLE foo"};
        String[] badColumnPrivResource = new String[]{"SELECT (a,) ON TABLE foo", "SELECT (*) ON TABLE foo", "SELECT (a), b ON TABLE foo", "SELECT ((a)) ON TABLE foo", "SELECT (a, b) ON URI foo", "SELECT ON TABLE (a, b) foo"};
        String[] idents = new String[]{"myRole", "GROUP myGroup", "USER user", "ROLE myRole"};
        String[] badIdents = new String[]{"GROUP", "ROLE", "GROUP group", "GROUP role", "USER role", "FOOBAR foobar", ""};
        ParserTest.createPrivSQL(grantRevoke, resources, privileges, idents).forEach(this::ParsesOk);
        ParserTest.createPrivSQL(grantRevoke, resources, privileges, idents).stream().filter(s -> s.contains("GRANT")).map(s -> s + " WITH GRANT OPTION").forEach(this::ParsesOk);
        ParserTest.createPrivSQL(grantRevoke, resources, privileges, idents).stream().filter(s -> s.contains("REVOKE")).map(s -> s.replace("REVOKE", "REVOKE GRANT OPTION FOR")).forEach(this::ParsesOk);
        ParserTest.createColumnPrivSql(grantRevoke, columnPrivResource, idents).forEach(this::ParsesOk);
        ParserTest.createPrivSQL(grantRevoke, badResources, privileges, idents).forEach(this::ParserError);
        ParserTest.createPrivSQL(grantRevoke, resources, badPrivileges, idents).forEach(this::ParserError);
        ParserTest.createPrivSQL(grantRevoke, resources, privileges, badIdents).forEach(this::ParserError);
        ParserTest.createPrivSQL(grantRevoke, resources, privileges, idents).stream().filter(s -> s.contains("GRANT")).map(s -> s + " WITH GRANT").forEach(this::ParserError);
        ParserTest.createPrivSQL(grantRevoke, resources, privileges, idents).stream().filter(s -> s.contains("GRANT")).map(s -> s + " WITH").forEach(this::ParserError);
        ParserTest.createPrivSQL(grantRevoke, resources, privileges, idents).stream().filter(s -> s.contains("REVOKE")).map(s -> s.replace("REVOKE", "REVOKE GRANT OPTION")).forEach(this::ParserError);
        ParserTest.createPrivSQL(grantRevoke, resources, privileges, idents).stream().filter(s -> s.contains("REVOKE")).map(s -> s.replace("REVOKE", "REVOKE GRANT")).forEach(this::ParserError);
    }

    private static List<String> createPrivSQL(String[][] formats, String[] resources, String[] privileges, String[] idents) {
        ArrayList<String> result = new ArrayList<String>();
        for (String[] formatStr : formats) {
            for (String resource : resources) {
                for (String privilege : privileges) {
                    for (String ident : idents) {
                        result.add(String.format("%s %s ON %s %s %s", formatStr[0], privilege, resource, formatStr[1], ident));
                    }
                }
            }
        }
        return result;
    }

    private static List<String> createColumnPrivSql(String[][] formats, String[] privResource, String[] idents) {
        ArrayList<String> result = new ArrayList<String>();
        for (String[] formatStr : formats) {
            for (String pr : privResource) {
                for (String ident : idents) {
                    result.add(String.format("%s %s %s %s", formatStr[0], pr, formatStr[1], ident));
                }
            }
        }
        return result;
    }

    @Test
    public void TestShowRoles() {
        this.ParsesOk("SHOW ROLES");
        this.ParsesOk("SHOW CURRENT ROLES");
        this.ParsesOk("SHOW ROLE GRANT GROUP myGroup");
        this.ParserError("SHOW ROLES blah");
        this.ParserError("SHOW ROLE GRANT GROUP");
        this.ParserError("SHOW CURRENT");
        this.ParserError("SHOW ROLE");
        this.ParserError("SHOW");
    }

    @Test
    public void TestShowGrantPrincipal() {
        for (String type : new String[]{"ROLE", "USER", "GROUP"}) {
            this.ParsesOk(String.format("SHOW GRANT %s foo", type));
            this.ParsesOk(String.format("SHOW GRANT %s foo ON SERVER", type));
            this.ParsesOk(String.format("SHOW GRANT %s foo ON DATABASE foo", type));
            this.ParsesOk(String.format("SHOW GRANT %s foo ON TABLE foo", type));
            this.ParsesOk(String.format("SHOW GRANT %s foo ON TABLE foo.bar", type));
            this.ParsesOk(String.format("SHOW GRANT %s foo ON COLUMN bar.baz", type));
            this.ParsesOk(String.format("SHOW GRANT %s foo ON COLUMN foo.bar.baz", type));
            this.ParsesOk(String.format("SHOW GRANT %s foo ON URI '/abc/123'", type));
            this.ParserError(String.format("SHOW GRANT %s", type));
            this.ParserError(String.format("SHOW GRANT %s foo ON SERVER foo", type));
            this.ParserError(String.format("SHOW GRANT %s foo ON DATABASE", type));
            this.ParserError(String.format("SHOW GRANT %s foo ON TABLE", type));
            this.ParserError(String.format("SHOW GRANT %s foo ON COLUMN", type));
            this.ParserError(String.format("SHOW GRANT %s foo ON URI abc", type));
        }
        this.ParserError("SHOW GRANT FOO bar");
    }

    @Test
    public void TestShowCreateFunction() {
        this.ParsesOk("SHOW CREATE FUNCTION foo");
        this.ParsesOk("SHOW CREATE FUNCTION foo.bar");
        this.ParsesOk("SHOW CREATE AGGREGATE FUNCTION foo");
        this.ParsesOk("SHOW CREATE AGGREGATE FUNCTION foo.bar");
        this.ParserError("SHOW CREATE FUNCTION");
        this.ParserError("SHOW CREATE AGGREGATE FUNCTION");
        this.ParserError("SHOW CREATE ANALYTIC FUNCTION foo");
        this.ParserError("SHOW CREATE AGGREGATE ANALYTIC FUNCTION foo");
    }

    @Test
    public void TestComputeStats() {
        this.ParsesOk("COMPUTE STATS alltypes");
        this.ParsesOk("COMPUTE STATS functional.alltypes");
        this.ParsesOk("COMPUTE STATS alltypes TABLESAMPLE SYSTEM(10)");
        this.ParsesOk("COMPUTE STATS alltypes TABLESAMPLE SYSTEM(10) REPEATABLE(10)");
        this.ParsesOk("COMPUTE STATS functional.alltypes TABLESAMPLE SYSTEM(10) REPEATABLE(10)");
        this.ParserError("COMPUTE functional.alltypes");
        this.ParserError("COMPUTE STATS ON functional.alltypes");
        this.ParserError("COMPUTE STATS");
    }

    @Test
    public void TestComputeIncrementalStats() {
        this.ParsesOk("COMPUTE INCREMENTAL STATS functional.alltypes");
        this.ParsesOk("COMPUTE INCREMENTAL STATS functional.alltypes PARTITION(month=10, year=2010)");
        this.ParsesOk("DROP INCREMENTAL STATS functional.alltypes PARTITION(month=10, year=2010)");
        this.ParsesOk("COMPUTE INCREMENTAL STATS functional.alltypes(tinyint_col, smallint_col)");
        this.ParsesOk("COMPUTE INCREMENTAL STATS functional.alltypes PARTITION(month=10, year=2010)(tinyint_col, smallint_col)");
        this.ParserError("COMPUTE INCREMENTAL STATS");
        this.ParserError("COMPUTE INCREMENTAL functional.alltypes");
        this.ParserError("DROP INCREMENTAL STATS functional.alltypes");
        this.ParserError("COMPUTE INCREMENTAL STATS functional.alltypes TABLESAMPLE SYSTEM(10)");
        this.ParserError("COMPUTE INCREMENTAL STATS functional.alltypes(tinyint_col, smallint_col");
        this.ParserError("COMPUTE INCREMENTAL STATS functional.alltypes PARTITION(month=10, year=2010)tinyint_col, smallint_col)");
    }

    @Test
    public void TestSemiColon() {
        this.ParserError(";", "Syntax error");
        this.ParsesOk("SELECT 1;");
        this.ParsesOk(" SELECT 1 ; ");
        this.ParsesOk("  SELECT  1  ;  ");
        this.ParserError("SELECT 1; SELECT 2;", "Syntax error in line 1:\nSELECT 1; SELECT 2;\n          ^\nEncountered: SELECT\nExpected");
        this.ParsesOk("SELECT 1;;;");
        this.ParsesOk("SELECT 1 FROM functional.alltypestiny WHERE 1 = (SELECT 1);");
        this.ParserError("SELECT 1 FROM functional.alltypestiny WHERE 1 = (SELECT 1;)", "Syntax error");
        this.ParserError("SELECT 1 FROM functional.alltypestiny WHERE 1 = (SELECT 1;);", "Syntax error");
        this.ParsesOk("CREATE TABLE functional.test_table (col INT);");
        this.ParsesOk("DESCRIBE functional.alltypes;");
        this.ParsesOk("SET num_nodes=1;");
    }

    @Test
    public void TestCommentOn() {
        this.ParsesOk("COMMENT ON DATABASE db IS 'comment'");
        this.ParsesOk("COMMENT ON DATABASE db IS ''");
        this.ParsesOk("COMMENT ON DATABASE db IS NULL");
        this.ParserError("COMMENT ON DATABASE IS 'comment'");
        this.ParserError("COMMENT ON DATABASE db IS");
        for (String tbl : new String[]{"db.t", "t"}) {
            this.ParsesOk(String.format("COMMENT ON TABLE %s IS 'comment'", tbl));
            this.ParsesOk(String.format("COMMENT ON TABLE %s IS ''", tbl));
            this.ParsesOk(String.format("COMMENT ON TABLE %s IS NULL", tbl));
            this.ParsesOk(String.format("COMMENT ON VIEW %s IS 'comment'", tbl));
            this.ParsesOk(String.format("COMMENT ON VIEW %s IS ''", tbl));
            this.ParsesOk(String.format("COMMENT ON VIEW %s IS NULL", tbl));
        }
        this.ParserError("COMMENT ON TABLE IS 'comment'");
        this.ParserError("COMMENT ON TABLE tbl IS");
        this.ParserError("COMMENT ON VIEW IS 'comment'");
        this.ParserError("COMMENT ON VIEW tbl IS");
        for (String col : new String[]{"db.tbl.col", "tbl.col"}) {
            this.ParsesOk(String.format("COMMENT ON COLUMN %s IS 'comment'", col));
            this.ParsesOk(String.format("COMMENT ON COLUMN %s IS ''", col));
            this.ParsesOk(String.format("COMMENT ON COLUMN %s IS NULL", col));
        }
        this.ParserError("COMMENT on col IS 'comment'");
        this.ParserError("COMMENT on db.tbl.col IS");
        this.ParserError("COMMENT on tbl.col IS");
    }

    @Test
    public void TestAlterDatabaseSetOwner() {
        for (String valid : new String[]{"foo", "user", "owner"}) {
            this.ParsesOk(String.format("ALTER DATABASE %s SET OWNER USER %s", valid, valid));
            this.ParsesOk(String.format("ALTER DATABASE %s SET OWNER ROLE %s", valid, valid));
        }
        for (String invalid : new String[]{"'foo'", "''", "NULL"}) {
            this.ParserError(String.format("ALTER DATABASE %s SET OWNER ROLE %s", invalid, invalid));
            this.ParserError(String.format("ALTER DATABASE %s SET OWNER USER %s", invalid, invalid));
        }
        this.ParserError("ALTER DATABASE db SET ABC USER foo");
        this.ParserError("ALTER DATABASE db SET ABC ROLE foo");
        this.ParserError("ALTER DATABASE db SET OWNER ABC foo");
        this.ParserError("ALTER DATABASE db SET OWNER USER");
        this.ParserError("ALTER DATABASE SET OWNER foo");
        this.ParserError("ALTER DATABASE SET OWNER USER foo");
        this.ParserError("ALTER DATABASE db SET OWNER ROLE");
        this.ParserError("ALTER DATABASE SET OWNER ROLE foo");
        this.ParserError("ALTER DATABASE SET OWNER");
    }

    @Test
    public void TestAlterTableOrViewSetOwner() {
        for (String type : new String[]{"TABLE", "VIEW"}) {
            for (String valid : new String[]{"foo", "user", "owner"}) {
                this.ParsesOk(String.format("ALTER %s %s SET OWNER USER %s", type, valid, valid));
                this.ParsesOk(String.format("ALTER %s %s SET OWNER ROLE %s", type, valid, valid));
            }
            for (String invalid : new String[]{"'foo'", "''", "NULL"}) {
                this.ParserError(String.format("ALTER %s %s SET OWNER ROLE %s", type, invalid, invalid));
                this.ParserError(String.format("ALTER %s %s SET OWNER USER %s", type, invalid, invalid));
            }
            this.ParserError(String.format("ALTER %s tbl PARTITION(i=1) SET OWNER ROLE foo", type));
            this.ParserError(String.format("ALTER %s tbl SET ABC USER foo", type));
            this.ParserError(String.format("ALTER %s tbl SET ABC ROLE foo", type));
            this.ParserError(String.format("ALTER %s tbl SET OWNER ABC foo", type));
            this.ParserError(String.format("ALTER %s tbl SET OWNER USER", type));
            this.ParserError(String.format("ALTER %s SET OWNER foo", type));
            this.ParserError(String.format("ALTER %s SET OWNER USER foo", type));
            this.ParserError(String.format("ALTER %s tbl SET OWNER ROLE", type));
            this.ParserError(String.format("ALTER %s SET OWNER ROLE foo", type));
            this.ParserError(String.format("ALTER %s SET OWNER", type));
        }
    }

    @Test
    public void TestAdminFns() {
        this.ParsesOk(":foobar()");
        this.ParsesOk(": foobar()");
        this.ParsesOk(":\tfoobar()");
        this.ParsesOk("   :\tfoobar()");
        this.ParsesOk("\n:foobar()");
        this.ParsesOk("\n:foobar(123)");
        this.ParsesOk("\n:foobar(123, 456)");
        this.ParsesOk("\n:foobar('foo', 'bar')");
        this.ParsesOk("\n:foobar('foo', 'bar', 1, -1, 1234, 99, false)");
        this.ParsesOk(": 1a()");
        this.ParserError("foobar()");
        this.ParserError("  foobar()");
        this.ParserError(": 1()");
        this.ParserError(": 'string'()");
        this.ParserError(": a.b()");
        this.ParserError(": shutdown");
        this.ParserError(": shutdown foo");
        this.ParserError(": shutdown() other()");
        this.ParserError(": shutdown(); other()");
        this.ParserError(": shutdown(), other()");
        this.ParserError(": shutdown() :other()");
        this.ParserError(": shutdown() :other()");
        this.ParserError(": shutdown('hostA'); :shutdown('hostB');");
    }

    @Test
    public void TestIdentifier() {
        this.ParsesOk("select * from foo.bar_123");
        this.ParsesOk("select * from foo. bar_123");
        this.ParsesOk("select * from foo .bar_123");
        this.ParsesOk("select * from foo . bar_123");
        this.ParsesOk("select * from foo.123_bar");
        this.ParsesOk("select * from foo. 123_bar");
        this.ParsesOk("select * from foo .123_bar");
        this.ParsesOk("select * from foo . 123_bar");
        this.ParsesOk("select * from 123_foo.bar");
        this.ParsesOk("select * from 123_foo. bar");
        this.ParsesOk("select * from 123_foo .bar");
        this.ParsesOk("select * from 123_foo . bar");
        this.ParsesOk("select * from 123_foo.123_bar");
        this.ParsesOk("select * from 123_foo. 123_bar");
        this.ParsesOk("select * from 123_foo .123_bar");
        this.ParsesOk("select * from 123_foo . 123_bar");
        this.ParserError("select * from foo.4e1");
        this.ParserError("select * from 4e1.bar");
        this.ParserError("select * from .123_bar");
        this.ParserError("select * from . 123_bar");
    }

    @Test
    public void TestLineBreakEnd() {
        this.ParserError("--test\n");
        this.ParserError("--test\n  ");
        this.ParserError("SELECT\n");
        this.ParserError("SELECT\n  ");
        this.ParserError("SHOW\n");
        this.ParserError("SHOW\n  ");
        this.ParserError("INSERT\n");
        this.ParserError("INSERT\n  ");
        this.ParserError("DROP\n");
        this.ParserError("DROP\n  ");
        this.ParserError("  \n");
        this.ParserError("\n  ");
        this.ParserError("\n");
        this.ParserError("SELECT\n\n");
        this.ParserError("SELECT\n\n\n");
        this.ParserError("SELECT\n\n \n");
        this.ParserError("SELECT\n \n\n");
        this.ParserError("SELECT\n\n  ");
        this.ParserError("SELECT  \n\n");
        this.ParsesOk("--test\nSELECT 1\n");
        this.ParsesOk("--test\nSELECT 1\n  ");
    }

    @Test
    public void TestUnreservedKeywords() {
        String[] unreservedKeywords;
        for (String keyword : unreservedKeywords = new String[]{"DEFAULT", "KILL", "QUERY"}) {
            this.ParsesOk(String.format("CREATE TABLE %s (%s INT);", keyword, keyword));
        }
    }
}

