/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import java.math.BigDecimal;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InvalidValueException;
import org.apache.impala.common.SqlCastException;
import org.junit.Assert;
import org.junit.Test;

public class NumericLiteralTest {
    private static final int MAX_BIGINT_PRECISION = 19;
    private static final BigDecimal ABOVE_TINYINT = NumericLiteral.MAX_TINYINT.add(BigDecimal.ONE);
    private static final BigDecimal BELOW_TINYINT = NumericLiteral.MIN_TINYINT.subtract(BigDecimal.ONE);
    private static final BigDecimal ABOVE_SMALLINT = NumericLiteral.MAX_SMALLINT.add(BigDecimal.ONE);
    private static final BigDecimal BELOW_SMALLINT = NumericLiteral.MIN_SMALLINT.subtract(BigDecimal.ONE);
    private static final BigDecimal ABOVE_INT = NumericLiteral.MAX_INT.add(BigDecimal.ONE);
    private static final BigDecimal BELOW_INT = NumericLiteral.MIN_INT.subtract(BigDecimal.ONE);
    private static final BigDecimal ABOVE_BIGINT = NumericLiteral.MAX_BIGINT.add(BigDecimal.ONE);
    private static final BigDecimal BELOW_BIGINT = NumericLiteral.MIN_BIGINT.subtract(BigDecimal.ONE);

    private static String repeat(String str, int n) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    private static String genDecimal(int precision, int scale) {
        if (scale == 0) {
            return NumericLiteralTest.repeat("9", precision);
        }
        return NumericLiteralTest.repeat("9", precision - scale) + "." + NumericLiteralTest.repeat("4", scale);
    }

    @Test
    public void testBasics() throws AnalysisException {
        NumericLiteral n = NumericLiteral.create((long)0L);
        Assert.assertEquals((Object)Type.TINYINT, (Object)n.getType());
        Assert.assertTrue((boolean)n.isAnalyzed());
        Assert.assertEquals((double)1.0, (double)n.getCost(), (double)0.01);
        Assert.assertEquals((double)-1.0, (double)n.getSelectivity(), (double)0.01);
        Assert.assertEquals((Object)"0", (Object)n.getStringValue());
        Assert.assertEquals((Object)"0:TINYINT", (Object)n.toString());
        n.castTo((Type)Type.SMALLINT);
        Assert.assertEquals((Object)Type.SMALLINT, (Object)n.getType());
        Assert.assertEquals((Object)"0:SMALLINT", (Object)n.toString());
    }

    @Test
    public void testConstants() throws InvalidValueException {
        Assert.assertEquals((Object)BigDecimal.valueOf(-128L), (Object)NumericLiteral.MIN_TINYINT);
        Assert.assertEquals((Object)BigDecimal.valueOf(127L), (Object)NumericLiteral.MAX_TINYINT);
        Assert.assertEquals((Object)BigDecimal.valueOf(-32768L), (Object)NumericLiteral.MIN_SMALLINT);
        Assert.assertEquals((Object)BigDecimal.valueOf(32767L), (Object)NumericLiteral.MAX_SMALLINT);
        Assert.assertEquals((Object)BigDecimal.valueOf(Integer.MIN_VALUE), (Object)NumericLiteral.MIN_INT);
        Assert.assertEquals((Object)BigDecimal.valueOf(Integer.MAX_VALUE), (Object)NumericLiteral.MAX_INT);
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.MIN_VALUE), (Object)NumericLiteral.MIN_BIGINT);
        Assert.assertEquals((Object)BigDecimal.valueOf(Long.MAX_VALUE), (Object)NumericLiteral.MAX_BIGINT);
        Assert.assertEquals((Object)BigDecimal.valueOf(-3.4028234663852886E38), (Object)NumericLiteral.MIN_FLOAT);
        Assert.assertEquals((Object)BigDecimal.valueOf(3.4028234663852886E38), (Object)NumericLiteral.MAX_FLOAT);
        Assert.assertEquals((Object)BigDecimal.valueOf(-1.7976931348623157E308), (Object)NumericLiteral.MIN_DOUBLE);
        Assert.assertEquals((Object)BigDecimal.valueOf(Double.MAX_VALUE), (Object)NumericLiteral.MAX_DOUBLE);
    }

    @Test
    public void testInferType() throws SqlCastException {
        Assert.assertEquals((Object)Type.TINYINT, (Object)NumericLiteral.inferType((BigDecimal)BigDecimal.ZERO));
        Assert.assertEquals((Object)Type.TINYINT, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MIN_TINYINT));
        Assert.assertEquals((Object)Type.TINYINT, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MAX_TINYINT));
        Assert.assertEquals((Object)Type.SMALLINT, (Object)NumericLiteral.inferType((BigDecimal)ABOVE_TINYINT));
        Assert.assertEquals((Object)Type.SMALLINT, (Object)NumericLiteral.inferType((BigDecimal)BELOW_TINYINT));
        Assert.assertEquals((Object)Type.SMALLINT, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MIN_SMALLINT));
        Assert.assertEquals((Object)Type.SMALLINT, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MAX_SMALLINT));
        Assert.assertEquals((Object)Type.INT, (Object)NumericLiteral.inferType((BigDecimal)ABOVE_SMALLINT));
        Assert.assertEquals((Object)Type.INT, (Object)NumericLiteral.inferType((BigDecimal)BELOW_SMALLINT));
        Assert.assertEquals((Object)Type.INT, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MIN_INT));
        Assert.assertEquals((Object)Type.INT, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MAX_INT));
        Assert.assertEquals((Object)Type.BIGINT, (Object)NumericLiteral.inferType((BigDecimal)ABOVE_INT));
        Assert.assertEquals((Object)Type.BIGINT, (Object)NumericLiteral.inferType((BigDecimal)BELOW_INT));
        Assert.assertEquals((Object)Type.BIGINT, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MIN_BIGINT));
        Assert.assertEquals((Object)Type.BIGINT, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MAX_BIGINT));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)2, (int)1), (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(2, 1))));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)2, (int)1), (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(2, 1)).negate()));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)19, (int)0), (Object)NumericLiteral.inferType((BigDecimal)ABOVE_BIGINT));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)19, (int)0), (Object)NumericLiteral.inferType((BigDecimal)BELOW_BIGINT));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)19, (int)0), (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(19, 0))));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)19, (int)0), (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(19, 0)).negate()));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)38, (int)0), (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(38, 0))));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)38, (int)0), (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(38, 0)).negate()));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(39, 0))));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(39, 0)).negate()));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MIN_FLOAT));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MAX_FLOAT));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(1.4E-45f)));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(-1.4E-45f)));
        String value = "12345" + NumericLiteralTest.repeat("0", 40);
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(value)));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(value).negate()));
        value = NumericLiteralTest.repeat("9", 10) + NumericLiteralTest.repeat("0", 40);
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(value)));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(value).negate()));
        value = NumericLiteralTest.repeat("9", 30) + NumericLiteralTest.repeat("0", 50);
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(value)));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(value).negate()));
        value = NumericLiteralTest.genDecimal(100, 10);
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(value)));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(value).negate()));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MIN_DOUBLE));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MAX_DOUBLE));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(Double.MIN_VALUE)));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)new BigDecimal(-4.9E-324)));
        try {
            NumericLiteral.inferType((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(309, 0)));
            Assert.fail();
        }
        catch (SqlCastException sqlCastException) {
            // empty catch block
        }
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MAX_DOUBLE.add(BigDecimal.ONE)));
        Assert.assertEquals((Object)Type.DOUBLE, (Object)NumericLiteral.inferType((BigDecimal)NumericLiteral.MAX_DOUBLE.add(BigDecimal.ONE).negate()));
        try {
            NumericLiteral.inferType((BigDecimal)NumericLiteral.MAX_DOUBLE.multiply(BigDecimal.TEN));
            Assert.fail();
        }
        catch (SqlCastException sqlCastException) {
            // empty catch block
        }
        try {
            NumericLiteral.inferType((BigDecimal)NumericLiteral.MAX_DOUBLE.multiply(BigDecimal.TEN).negate());
            Assert.fail();
        }
        catch (SqlCastException sqlCastException) {
            // empty catch block
        }
        value = "." + NumericLiteralTest.repeat("0", 325) + "1";
        try {
            NumericLiteral.inferType((BigDecimal)new BigDecimal(value));
            Assert.fail();
        }
        catch (SqlCastException sqlCastException) {
            // empty catch block
        }
    }

    @Test
    public void testIsOverflow() throws InvalidValueException {
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)BigDecimal.ZERO, (Type)Type.TINYINT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MIN_TINYINT, (Type)Type.TINYINT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MAX_TINYINT, (Type)Type.TINYINT));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)ABOVE_TINYINT, (Type)Type.TINYINT));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)BELOW_TINYINT, (Type)Type.TINYINT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)BigDecimal.ZERO, (Type)Type.SMALLINT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MIN_SMALLINT, (Type)Type.SMALLINT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MAX_SMALLINT, (Type)Type.SMALLINT));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)ABOVE_SMALLINT, (Type)Type.SMALLINT));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)BELOW_SMALLINT, (Type)Type.SMALLINT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)BigDecimal.ZERO, (Type)Type.INT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MIN_INT, (Type)Type.INT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MAX_INT, (Type)Type.INT));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)ABOVE_INT, (Type)Type.INT));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)BELOW_INT, (Type)Type.INT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)BigDecimal.ZERO, (Type)Type.BIGINT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MIN_BIGINT, (Type)Type.BIGINT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MAX_BIGINT, (Type)Type.BIGINT));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)ABOVE_BIGINT, (Type)Type.BIGINT));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)BELOW_BIGINT, (Type)Type.BIGINT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)BigDecimal.ZERO, (Type)Type.FLOAT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MIN_FLOAT, (Type)Type.FLOAT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MAX_FLOAT, (Type)Type.FLOAT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)BigDecimal.valueOf(1.4E-45f), (Type)Type.FLOAT));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MAX_FLOAT.add(BigDecimal.ONE), (Type)Type.FLOAT));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MAX_FLOAT.multiply(BigDecimal.TEN), (Type)Type.FLOAT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)BigDecimal.valueOf(1.4E-45f).divide(BigDecimal.TEN), (Type)Type.FLOAT));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)BigDecimal.ZERO, (Type)Type.DOUBLE));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MIN_DOUBLE, (Type)Type.DOUBLE));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MAX_DOUBLE, (Type)Type.DOUBLE));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)BigDecimal.valueOf(Double.MIN_VALUE), (Type)Type.DOUBLE));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MAX_DOUBLE.add(new BigDecimal("1e300")), (Type)Type.DOUBLE));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)NumericLiteral.MAX_DOUBLE.multiply(BigDecimal.TEN), (Type)Type.DOUBLE));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)BigDecimal.valueOf(Double.MIN_VALUE).divide(BigDecimal.TEN), (Type)Type.DOUBLE));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)BigDecimal.ZERO, (Type)Type.DECIMAL));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(10, 5)), (Type)Type.DECIMAL));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(10, 5)), (Type)Type.DECIMAL));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(38, 0)), (Type)Type.DECIMAL));
        Assert.assertFalse((boolean)NumericLiteral.isOverflow((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(0, 38)), (Type)Type.DECIMAL));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(39, 0)), (Type)Type.DECIMAL));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(39, 1)), (Type)Type.DECIMAL));
        Assert.assertTrue((boolean)NumericLiteral.isOverflow((BigDecimal)new BigDecimal(NumericLiteralTest.genDecimal(0, 39)), (Type)Type.DECIMAL));
    }

    @Test
    public void testSimpleCtor() throws SqlCastException {
        NumericLiteral n = new NumericLiteral(BigDecimal.ZERO);
        Assert.assertEquals((long)0L, (long)n.getLongValue());
        Assert.assertEquals((Object)Type.TINYINT, (Object)n.getType());
        n = new NumericLiteral(NumericLiteral.MAX_TINYINT);
        Assert.assertEquals((long)127L, (long)n.getLongValue());
        Assert.assertEquals((Object)Type.TINYINT, (Object)n.getType());
        n = new NumericLiteral(NumericLiteral.MAX_BIGINT);
        Assert.assertEquals((Object)Type.BIGINT, (Object)n.getType());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)n.getLongValue());
        n = new NumericLiteral(NumericLiteral.MAX_DOUBLE);
        Assert.assertEquals((double)Double.MAX_VALUE, (double)n.getDoubleValue(), (double)1.0);
        Assert.assertEquals((Object)Type.DOUBLE, (Object)n.getType());
        n = new NumericLiteral(new BigDecimal(NumericLiteralTest.genDecimal(35, 0)));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)35, (int)0), (Object)n.getType());
        try {
            new NumericLiteral(NumericLiteral.MAX_DOUBLE.multiply(BigDecimal.TEN));
            Assert.fail();
        }
        catch (SqlCastException sqlCastException) {
            // empty catch block
        }
    }

    @Test
    public void testTypeCtor() throws InvalidValueException, SqlCastException {
        NumericLiteral n = new NumericLiteral(BigDecimal.ZERO);
        Assert.assertEquals((long)0L, (long)n.getLongValue());
        Assert.assertEquals((Object)Type.TINYINT, (Object)n.getType());
        n = new NumericLiteral(NumericLiteral.MAX_TINYINT);
        Assert.assertEquals((long)127L, (long)n.getLongValue());
        Assert.assertEquals((Object)Type.TINYINT, (Object)n.getType());
        n = new NumericLiteral(NumericLiteral.MAX_BIGINT);
        Assert.assertEquals((Object)Type.BIGINT, (Object)n.getType());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)n.getLongValue());
        n = new NumericLiteral(NumericLiteral.MAX_DOUBLE);
        Assert.assertEquals((double)Double.MAX_VALUE, (double)n.getDoubleValue(), (double)1.0);
        Assert.assertEquals((Object)Type.DOUBLE, (Object)n.getType());
        n = new NumericLiteral(new BigDecimal(NumericLiteralTest.genDecimal(35, 0)));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)35, (int)0), (Object)n.getType());
        try {
            new NumericLiteral(NumericLiteral.MAX_DOUBLE.multiply(BigDecimal.TEN));
            Assert.fail();
        }
        catch (SqlCastException sqlCastException) {
            // empty catch block
        }
        try {
            new NumericLiteral(new BigDecimal("123.45"), (Type)ScalarType.createDecimalType((int)3, (int)1));
            Assert.fail();
        }
        catch (SqlCastException sqlCastException) {
            // empty catch block
        }
        try {
            new NumericLiteral(new BigDecimal(Integer.MAX_VALUE), (Type)Type.TINYINT);
            Assert.fail();
        }
        catch (SqlCastException sqlCastException) {
            // empty catch block
        }
        n = new NumericLiteral(new BigDecimal("1.567"), (Type)ScalarType.createDecimalType((int)2, (int)1));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)2, (int)1), (Object)n.getType());
        Assert.assertEquals((Object)"1.6", (Object)n.getValue().toString());
    }

    @Test
    public void testExtremes() throws InvalidValueException, SqlCastException {
        NumericLiteral n = new NumericLiteral(NumericLiteral.MAX_DOUBLE);
        Assert.assertEquals((double)Double.MAX_VALUE, (double)n.getDoubleValue(), (double)1.0);
        n = new NumericLiteral(NumericLiteral.MIN_DOUBLE);
        Assert.assertEquals((double)-1.7976931348623157E308, (double)n.getDoubleValue(), (double)1.0);
    }

    @Test
    public void testCastTo() throws AnalysisException {
        NumericLiteral n = new NumericLiteral(BigDecimal.ZERO);
        Expr result = n.uncheckedCastTo((Type)Type.BIGINT, TypeCompatibility.DEFAULT);
        Assert.assertSame((Object)n, (Object)result);
        Assert.assertEquals((Object)Type.BIGINT, (Object)n.getType());
        result = n.uncheckedCastTo((Type)Type.TINYINT, TypeCompatibility.DEFAULT);
        Assert.assertSame((Object)n, (Object)result);
        Assert.assertEquals((Object)Type.TINYINT, (Object)n.getType());
        result = n.uncheckedCastTo((Type)ScalarType.createDecimalType((int)5, (int)0), TypeCompatibility.DEFAULT);
        Assert.assertSame((Object)n, (Object)result);
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)5, (int)0), (Object)n.getType());
        n = new NumericLiteral(ABOVE_SMALLINT);
        result = n.uncheckedCastTo((Type)Type.BIGINT, TypeCompatibility.DEFAULT);
        Assert.assertSame((Object)n, (Object)result);
        Assert.assertEquals((Object)Type.BIGINT, (Object)n.getType());
        Expr result2 = n.uncheckedCastTo((Type)Type.SMALLINT, TypeCompatibility.DEFAULT);
        Assert.assertTrue((boolean)(result2 instanceof CastExpr));
        Assert.assertEquals((Object)Type.SMALLINT, (Object)result2.getType());
        n = new NumericLiteral(ABOVE_SMALLINT);
        result = n.uncheckedCastTo((Type)Type.BIGINT, TypeCompatibility.DEFAULT);
        Assert.assertSame((Object)n, (Object)result);
        Assert.assertEquals((Object)Type.BIGINT, (Object)n.getType());
        result2 = n.uncheckedCastTo((Type)ScalarType.createDecimalType((int)2, (int)0), TypeCompatibility.DEFAULT);
        Assert.assertTrue((boolean)(result2 instanceof CastExpr));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)2, (int)0), (Object)result2.getType());
        n = new NumericLiteral(new BigDecimal("123.45"));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)5, (int)2), (Object)n.getType());
        result = n.uncheckedCastTo((Type)ScalarType.createDecimalType((int)6, (int)3), TypeCompatibility.DEFAULT);
        Assert.assertSame((Object)n, (Object)result);
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)6, (int)3), (Object)n.getType());
        result = n.uncheckedCastTo((Type)ScalarType.createDecimalType((int)5, (int)2), TypeCompatibility.DEFAULT);
        Assert.assertSame((Object)n, (Object)result);
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)5, (int)2), (Object)n.getType());
        result = n.uncheckedCastTo((Type)ScalarType.createDecimalType((int)4, (int)1), TypeCompatibility.DEFAULT);
        Assert.assertNotSame((Object)n, (Object)result);
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)4, (int)1), (Object)result.getType());
        Assert.assertEquals((Object)"123.5", (Object)((NumericLiteral)result).toSql());
    }

    @Test
    public void testSwapSign() {
        int absValue = 128;
        NumericLiteral n = NumericLiteral.create((long)absValue);
        Assert.assertEquals((Object)Type.SMALLINT, (Object)n.getType());
        Assert.assertEquals((Object)Type.SMALLINT, (Object)n.getExplicitType());
        Assert.assertEquals((long)absValue, (long)n.getIntValue());
        n.swapSign();
        Assert.assertEquals((Object)Type.TINYINT, (Object)n.getType());
        Assert.assertEquals((Object)Type.TINYINT, (Object)n.getExplicitType());
        Assert.assertEquals((long)(-absValue), (long)n.getIntValue());
        n.swapSign();
        Assert.assertEquals((Object)Type.SMALLINT, (Object)n.getType());
        Assert.assertEquals((Object)Type.SMALLINT, (Object)n.getExplicitType());
        Assert.assertEquals((long)absValue, (long)n.getIntValue());
        BigDecimal absValue2 = NumericLiteral.MIN_BIGINT.negate();
        n = NumericLiteral.create((BigDecimal)absValue2);
        ScalarType posType = ScalarType.createDecimalType((int)19);
        Assert.assertEquals((Object)posType, (Object)n.getType());
        Assert.assertEquals((Object)posType, (Object)n.getExplicitType());
        Assert.assertTrue((absValue2.compareTo(n.getValue()) == 0 ? 1 : 0) != 0);
        n.swapSign();
        Assert.assertEquals((Object)Type.BIGINT, (Object)n.getType());
        Assert.assertEquals((Object)Type.BIGINT, (Object)n.getExplicitType());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)n.getLongValue());
        n.swapSign();
        Assert.assertEquals((Object)posType, (Object)n.getType());
        Assert.assertEquals((Object)posType, (Object)n.getExplicitType());
        Assert.assertTrue((absValue2.compareTo(n.getValue()) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConvertValue() throws SqlCastException {
        BigDecimal result = NumericLiteral.convertValue((BigDecimal)BigDecimal.ZERO, (Type)Type.TINYINT);
        Assert.assertSame((Object)result, (Object)BigDecimal.ZERO);
        result = NumericLiteral.convertValue((BigDecimal)BigDecimal.ZERO, (Type)Type.DOUBLE);
        Assert.assertSame((Object)result, (Object)BigDecimal.ZERO);
        result = NumericLiteral.convertValue((BigDecimal)BigDecimal.ZERO, (Type)ScalarType.createDecimalType((int)2, (int)2));
        Assert.assertSame((Object)result, (Object)BigDecimal.ZERO);
        try {
            NumericLiteral.convertValue((BigDecimal)ABOVE_TINYINT, (Type)Type.TINYINT);
            Assert.fail();
        }
        catch (SqlCastException sqlCastException) {
            // empty catch block
        }
        result = NumericLiteral.convertValue((BigDecimal)new BigDecimal("1234.56"), (Type)Type.INT);
        Assert.assertEquals((Object)"1235", (Object)result.toString());
        BigDecimal input = new BigDecimal("1234.56789");
        result = NumericLiteral.convertValue((BigDecimal)input, (Type)ScalarType.createDecimalType((int)7, (int)3));
        Assert.assertEquals((Object)"1234.568", (Object)result.toString());
        result = NumericLiteral.convertValue((BigDecimal)input, (Type)ScalarType.createDecimalType((int)4, (int)0));
        Assert.assertEquals((Object)"1235", (Object)result.toString());
        try {
            NumericLiteral.convertValue((BigDecimal)new BigDecimal("1234.56789"), (Type)ScalarType.createDecimalType((int)3, (int)2));
            Assert.fail();
        }
        catch (SqlCastException sqlCastException) {
            // empty catch block
        }
        input = new BigDecimal("1235.56");
        result = NumericLiteral.convertValue((BigDecimal)input, (Type)ScalarType.createDecimalType((int)6, (int)2));
        Assert.assertSame((Object)input, (Object)result);
        input = new BigDecimal("0.01");
        result = NumericLiteral.convertValue((BigDecimal)input, (Type)ScalarType.createDecimalType((int)2, (int)2));
        Assert.assertSame((Object)input, (Object)result);
    }

    @Test
    public void testCast() throws SqlCastException {
        NumericLiteral n = NumericLiteral.create((long)1000L);
        Assert.assertEquals((Object)Type.SMALLINT, (Object)n.getType());
        Expr result = n.uncheckedCastTo((Type)Type.TINYINT, TypeCompatibility.DEFAULT);
        Assert.assertTrue((boolean)(result instanceof CastExpr));
        Assert.assertEquals((Object)Type.TINYINT, (Object)result.getType());
        result = n.uncheckedCastTo((Type)Type.INT, TypeCompatibility.DEFAULT);
        Assert.assertSame((Object)n, (Object)result);
        Assert.assertEquals((Object)Type.INT, (Object)n.getType());
        n = new NumericLiteral(new BigDecimal("123.45"));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)5, (int)2), (Object)n.getType());
        Assert.assertSame((Object)n, (Object)n.uncheckedCastTo((Type)ScalarType.createDecimalType((int)6, (int)3), TypeCompatibility.DEFAULT));
        Assert.assertEquals((Object)ScalarType.createDecimalType((int)6, (int)3), (Object)n.getType());
        n = new NumericLiteral(new BigDecimal("123.45"));
        ScalarType newType = ScalarType.createDecimalType((int)4, (int)1);
        result = n.uncheckedCastTo((Type)newType, TypeCompatibility.DEFAULT);
        Assert.assertNotSame((Object)result, (Object)n);
        Assert.assertTrue((boolean)(result instanceof NumericLiteral));
        Assert.assertEquals((Object)newType, (Object)result.getType());
        NumericLiteral n2 = (NumericLiteral)result;
        Assert.assertEquals((Object)"123.5", (Object)n2.getValue().toString());
        Expr result2 = n2.uncheckedCastTo((Type)Type.SMALLINT, TypeCompatibility.DEFAULT);
        Assert.assertNotSame((Object)result2, (Object)result);
        Assert.assertEquals((Object)Type.SMALLINT, (Object)result2.getType());
        Assert.assertEquals((Object)"124", (Object)((NumericLiteral)result2).getValue().toString());
    }

    @Test
    public void testEquality() throws SqlCastException {
        NumericLiteral n1 = NumericLiteral.create((long)10L);
        NumericLiteral n2 = NumericLiteral.create((long)10L);
        NumericLiteral n3 = NumericLiteral.create((long)10L, (Type)Type.INT);
        NumericLiteral n4 = NumericLiteral.create((long)11L);
        NumericLiteral n5 = NumericLiteral.create((BigDecimal)new BigDecimal("10.000"), (Type)Type.TINYINT);
        Assert.assertTrue((boolean)n1.localEquals((Expr)n1));
        Assert.assertTrue((boolean)n1.localEquals((Expr)n2));
        Assert.assertFalse((boolean)n1.localEquals((Expr)n3));
        Assert.assertFalse((boolean)n1.localEquals((Expr)n4));
        Assert.assertTrue((boolean)n1.localEquals((Expr)n5));
    }
}

