/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.MergeInsert;
import org.apache.impala.analysis.MergeStmt;
import org.apache.impala.analysis.NullLiteral;
import org.apache.impala.analysis.SelectList;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SlotRef;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TableRef;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.IcebergTable;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.TypeCompatibility;
import org.apache.impala.common.AnalysisException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class MergeInsertTest {
    @Test
    public void testAnalyzeColumnPermutation() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d"});
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING);
        ImmutableMap selectItems = ImmutableMap.of((Object)"a", (Object)Type.SMALLINT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING);
        MergeInsert merge = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            List resultExprs = merge.analyzeColumnPermutation();
            Assert.assertEquals((long)4L, (long)resultExprs.size());
        }
        catch (AnalysisException e) {
            Assert.fail();
        }
    }

    @Test
    public void testForeignColumn() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING);
        ImmutableMap selectItems = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        MergeInsert mergeInsert = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            mergeInsert.analyzeColumnPermutation();
        }
        catch (AnalysisException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Unknown column(s) in column permutation"));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testUnmatchedSelectItem() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d"});
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        ImmutableMap selectItems = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        MergeInsert mergeInsert = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            mergeInsert.analyzeColumnPermutation();
        }
        catch (AnalysisException e) {
            Assert.assertEquals((Object)"Column permutation mentions fewer columns (4) than the VALUES clause returns (5): WHEN MATCHED THEN INSERT (a, b, c, d) VALUES (a, b, c, d, e)", (Object)e.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testUnmatchedColumn() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        ImmutableMap selectItems = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING);
        MergeInsert mergeInsert = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            mergeInsert.analyzeColumnPermutation();
        }
        catch (AnalysisException e) {
            Assert.assertEquals((Object)"Column permutation mentions more columns (5) than the VALUES clause returns (4): WHEN MATCHED THEN INSERT (a, b, c, d, e) VALUES (a, b, c, d)", (Object)e.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testColumnsInRandomOrder() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"e", "d", "c", "a", "b"});
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        ImmutableMap selectItems = ImmutableMap.of((Object)"e", (Object)Type.INT, (Object)"d", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING);
        MergeInsert mergeInsert = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            List exprs = mergeInsert.analyzeColumnPermutation();
            Assert.assertEquals((long)5L, (long)exprs.size());
        }
        catch (AnalysisException e) {
            Assert.fail();
        }
    }

    @Test
    public void testDuplicateColumnInPermutation() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"a", "b", "a", "a", "b"});
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        ImmutableMap selectItems = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        MergeInsert mergeInsert = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            mergeInsert.analyzeColumnPermutation();
        }
        catch (AnalysisException e) {
            Assert.assertEquals((Object)"Duplicate column(s) in column permutation: a, b", (Object)e.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testEmptyColumnPermutation() {
        ArrayList columns = Lists.newArrayList();
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        ImmutableMap selectItems = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        MergeInsert mergeInsert = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            mergeInsert.analyzeColumnPermutation();
        }
        catch (AnalysisException e) {
            Assert.assertEquals((Object)"Column permutation mentions fewer columns (0) than the VALUES clause returns (5): WHEN MATCHED THEN INSERT () VALUES (a, b, c, d, e)", (Object)e.getMessage());
            return;
        }
        Assert.fail();
    }

    @Test
    public void testImplicitCastAfterAnalyze() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        ImmutableMap selectItems = ImmutableMap.of((Object)"a", (Object)Type.SMALLINT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.TINYINT);
        MergeInsert mergeInsert = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            List resultExprs = mergeInsert.analyzeColumnPermutation();
            Assert.assertEquals((Object)Type.INT, (Object)((Expr)resultExprs.get((int)0)).type_);
            Assert.assertEquals((Object)Type.INT, (Object)((Expr)resultExprs.get((int)4)).type_);
        }
        catch (AnalysisException e) {
            Assert.fail();
        }
    }

    @Test
    public void testNeedsExplicitCastAtAnalyze() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        ImmutableMap selectItems = ImmutableMap.of((Object)"a", (Object)Type.SMALLINT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.INT, (Object)"e", (Object)Type.TINYINT);
        MergeInsert mergeInsert = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            mergeInsert.analyzeColumnPermutation();
        }
        catch (AnalysisException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Expression 'd' (type: INT) is not compatible with column 'd' (type: STRING)"));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testAnalyzeSparseSelectList() {
        ArrayList columns = Lists.newArrayList((Object[])new String[]{"a", "c", "e"});
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        ImmutableMap selectItems = ImmutableMap.of((Object)"a", (Object)Type.SMALLINT, (Object)"c", (Object)Type.DOUBLE, (Object)"e", (Object)Type.TINYINT);
        MergeInsert mergeInsert = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            List resultExprs = mergeInsert.analyzeColumnPermutation();
            Assert.assertTrue((boolean)(resultExprs.get(1) instanceof NullLiteral));
            Assert.assertTrue((boolean)(resultExprs.get(3) instanceof NullLiteral));
            Assert.assertEquals((long)5L, (long)resultExprs.size());
        }
        catch (AnalysisException e) {
            Assert.fail();
        }
    }

    @Test
    public void testAnalyzeImplicitMatch() {
        List columns = Collections.EMPTY_LIST;
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.INT);
        ImmutableMap selectItems = ImmutableMap.of((Object)"a", (Object)Type.SMALLINT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.TINYINT);
        MergeInsert mergeInsert = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            List resultExprs = mergeInsert.analyzeColumnPermutation();
            Assert.assertEquals((long)5L, (long)resultExprs.size());
        }
        catch (AnalysisException e) {
            Assert.fail();
        }
    }

    @Test
    public void testAnalyzeImplicitMatchWithUnmatchedSelectItem() {
        List columns = Collections.EMPTY_LIST;
        ImmutableMap columnMap = ImmutableMap.of((Object)"a", (Object)Type.INT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING);
        ImmutableMap selectItems = ImmutableMap.of((Object)"a", (Object)Type.SMALLINT, (Object)"b", (Object)Type.STRING, (Object)"c", (Object)Type.DOUBLE, (Object)"d", (Object)Type.STRING, (Object)"e", (Object)Type.TINYINT);
        MergeInsert mergeInsert = this.prepareMergeInsert((Map<String, Type>)columnMap, columns, (Map<String, Type>)selectItems);
        try {
            mergeInsert.analyzeColumnPermutation();
        }
        catch (AnalysisException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Target table 'test' has fewer columns (4) than the VALUES clause returns (5)"));
            return;
        }
        Assert.fail();
    }

    private Column mockColumnWithName(String name, Type type) {
        Column column = (Column)Mockito.mock(Column.class);
        Mockito.when((Object)column.getName()).thenReturn((Object)name);
        Mockito.when((Object)column.getType()).thenReturn((Object)type);
        return column;
    }

    private MergeInsert prepareMergeInsert(Map<String, Type> columnMap, List<String> columnPermutation, Map<String, Type> selectItems) {
        List columns = columnMap.entrySet().stream().map(entry -> this.mockColumnWithName((String)entry.getKey(), (Type)entry.getValue())).collect(Collectors.toList());
        SelectList selectList = this.prepareSelectList(selectItems);
        MergeStmt mergeStmt = (MergeStmt)Mockito.mock(MergeStmt.class);
        Analyzer analyzer = (Analyzer)Mockito.mock(Analyzer.class);
        FeTable table = (FeTable)Mockito.mock(IcebergTable.class);
        TableName tableName = (TableName)Mockito.mock(TableName.class);
        TableRef tableRef = (TableRef)Mockito.mock(TableRef.class);
        Mockito.when((Object)table.getColumns()).thenReturn(columns);
        Mockito.when((Object)table.getTableName()).thenReturn((Object)tableName);
        Mockito.when((Object)mergeStmt.getTargetTable()).thenReturn((Object)table);
        Mockito.when((Object)mergeStmt.getTargetTableRef()).thenReturn((Object)tableRef);
        Mockito.when((Object)tableName.toString()).thenReturn((Object)"test");
        Mockito.when((Object)analyzer.getPermissiveCompatibilityLevel()).thenReturn((Object)TypeCompatibility.DEFAULT);
        Mockito.when((Object)analyzer.getRegularCompatibilityLevel()).thenReturn((Object)TypeCompatibility.DEFAULT);
        MergeInsert mergeInsert = new MergeInsert(columnPermutation, selectList);
        mergeInsert.setParent(mergeStmt);
        mergeStmt.analyzer_ = analyzer;
        mergeInsert.analyzer_ = analyzer;
        return mergeInsert;
    }

    private SelectList prepareSelectList(Map<String, Type> items) {
        List selectListItems = items.entrySet().stream().map(s -> {
            SlotRef expr = new SlotRef((String)s.getKey());
            expr.type_ = (Type)s.getValue();
            return new SelectListItem((Expr)expr, (String)s.getKey());
        }).collect(Collectors.toList());
        return new SelectList(selectListItems);
    }
}

