/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.ArithmeticExpr;
import org.apache.impala.analysis.CastExpr;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.analysis.NumericLiteral;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.FrontendTestBase;
import org.junit.Assert;
import org.junit.Test;

public class LiteralExprTest
extends FrontendTestBase {
    @Test
    public void TestLiteralExpr() {
        this.testLiteralExprPositive("false", (Type)Type.BOOLEAN);
        this.testLiteralExprPositive("1", (Type)Type.TINYINT);
        this.testLiteralExprPositive("1", (Type)Type.SMALLINT);
        this.testLiteralExprPositive("1", (Type)Type.INT);
        this.testLiteralExprPositive("1", (Type)Type.BIGINT);
        this.testLiteralExprPositive("1.0", (Type)Type.FLOAT);
        this.testLiteralExprPositive("1.0", (Type)Type.DOUBLE);
        this.testLiteralExprPositive("ABC", (Type)Type.STRING);
        this.testLiteralExprPositive("ABC", (Type)Type.BINARY);
        this.testLiteralExprPositive("1.1", (Type)ScalarType.createDecimalType((int)2, (int)1));
        this.testLiteralExprPositive("2001-02-28", (Type)Type.DATE);
        this.testLiteralExprNegative("ABC", (Type)Type.INVALID);
        this.testLiteralExprNegative("ABC", (Type)Type.BOOLEAN);
        this.testLiteralExprNegative("ABC", (Type)Type.TINYINT);
        this.testLiteralExprNegative("ABC", (Type)Type.SMALLINT);
        this.testLiteralExprNegative("ABC", (Type)Type.INT);
        this.testLiteralExprNegative("ABC", (Type)Type.BIGINT);
        this.testLiteralExprNegative("ABC", (Type)Type.FLOAT);
        this.testLiteralExprNegative("ABC", (Type)Type.DOUBLE);
        this.testLiteralExprNegative("ABC", (Type)Type.TIMESTAMP);
        this.testLiteralExprNegative("ABC", (Type)ScalarType.createDecimalType());
        this.testLiteralExprNegative("ABC", (Type)Type.DATE);
        this.testLiteralExprNegative("2001-02-31", (Type)Type.DATE);
        this.testLiteralExprNegative("2010-01-01", (Type)Type.DATETIME);
        this.testLiteralExprNegative("2010-01-01", (Type)Type.TIMESTAMP);
    }

    private void testLiteralExprPositive(String value, Type type) {
        LiteralExpr expr = null;
        try {
            expr = LiteralExpr.createFromUnescapedStr((String)value, (Type)type);
        }
        catch (Exception e) {
            Assert.fail((String)("\nFailed to create LiteralExpr of type: " + type.toString() + " from: " + value + " due to " + e.getMessage() + "\n"));
        }
        if (expr == null) {
            Assert.fail((String)"\nFailed to create LiteralExpr\n");
        }
    }

    private void testLiteralExprNegative(String value, Type type) {
        boolean failure = false;
        LiteralExpr expr = null;
        try {
            expr = LiteralExpr.createFromUnescapedStr((String)value, (Type)type);
        }
        catch (Exception e) {
            failure = true;
        }
        if (expr == null) {
            failure = true;
        }
        if (!failure) {
            Assert.fail((String)("\nUnexpectedly succeeded to create LiteralExpr of type: " + type.toString() + " from: " + value + "\n"));
        }
    }

    private Expr analyze(String query, boolean useDecimalV2, boolean enableRewrite) {
        AnalysisContext ctx = this.createAnalysisCtx();
        ctx.getQueryOptions().setDecimal_v2(useDecimalV2);
        ctx.getQueryOptions().setEnable_expr_rewrites(enableRewrite);
        return ((SelectListItem)((SelectStmt)this.AnalyzesOk(query, ctx)).getSelectList().getItems().get(0)).getExpr();
    }

    @Test
    public void testLiteralCast() {
        for (int i = 0; i < 3; ++i) {
            boolean useDecimalV2 = i > 1;
            boolean enableRewrite = i % 2 == 1;
            String query = "select getBit(-9223372036854775808, 63)";
            Expr expr = this.analyze(query, useDecimalV2, enableRewrite);
            Assert.assertEquals((Object)Type.TINYINT, (Object)expr.getType());
            query = "select cast(10 as double) / cast(0 as double)";
            expr = this.analyze(query, useDecimalV2, enableRewrite);
            Assert.assertEquals((Object)Type.DOUBLE, (Object)expr.getType());
            Assert.assertTrue((boolean)(expr instanceof ArithmeticExpr));
            query = "select cast(" + Double.toString(Double.MAX_VALUE) + " as double)";
            expr = this.analyze(query, useDecimalV2, enableRewrite);
            Assert.assertEquals((Object)Type.DOUBLE, (Object)expr.getType());
            if (enableRewrite) {
                Assert.assertTrue((boolean)(expr instanceof NumericLiteral));
            } else {
                Assert.assertTrue((boolean)(expr instanceof CastExpr));
            }
            query = "select cast(" + Double.toString(Double.MIN_VALUE) + " as double)";
            expr = this.analyze(query, useDecimalV2, enableRewrite);
            Assert.assertEquals((Object)Type.DOUBLE, (Object)expr.getType());
            if (enableRewrite) {
                Assert.assertTrue((boolean)(expr instanceof NumericLiteral));
            } else {
                Assert.assertTrue((boolean)(expr instanceof CastExpr));
            }
            query = "select cast(1.7976931348623157e+308 as double) / cast(2.2250738585072014e-308 as double)";
            expr = this.analyze(query, useDecimalV2, enableRewrite);
            Assert.assertEquals((Object)Type.DOUBLE, (Object)expr.getType());
            Assert.assertTrue((boolean)(expr instanceof ArithmeticExpr));
            query = "select cast(cast(1.7976931348623157e+308 as double) as float)";
            expr = this.analyze(query, useDecimalV2, enableRewrite);
            Assert.assertEquals((Object)Type.FLOAT, (Object)expr.getType());
            Assert.assertTrue((boolean)(expr instanceof CastExpr));
        }
    }
}

