/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FrontendTestBase;
import org.junit.Assert;
import org.junit.Test;

public class ExprSelectivityTest
extends FrontendTestBase {
    public void verifySelectivityStmt(String stmtStr, double expectedSel) throws AnalysisException {
        SelectStmt stmt = (SelectStmt)this.AnalyzesOk(stmtStr);
        Expr selectClause = ((SelectListItem)stmt.getSelectList().getItems().get(0)).getExpr();
        double calculatedSel = selectClause.getSelectivity();
        this.assertEquals(calculatedSel, expectedSel);
    }

    public void verifySel(String predicate, double expectedSel) throws AnalysisException {
        String stmtStr = "select " + predicate + " from functional.alltypes";
        this.verifySelectivityStmt(stmtStr, expectedSel);
    }

    private void assertEquals(double actual, double expected) {
        if (Math.abs(actual - expected) > 1.0E-6) {
            Assert.fail((String)String.format("\nActual: %.7f\nExpected: %.7f\n", actual, expected));
        }
    }

    @Test
    public void TestBasicPredicateSel() throws AnalysisException {
        this.verifySel("id in (1,3,5,7)", 5.48E-4);
        this.verifySel("id not in (1,3,9)", 0.999589);
    }
}

