/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.SelectStmt;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.RuntimeEnv;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExprNdvTest
extends FrontendTestBase {
    @BeforeClass
    public static void setUpClass() throws Exception {
        RuntimeEnv.INSTANCE.setTestEnv(true);
    }

    @AfterClass
    public static void cleanUpClass() {
        RuntimeEnv.INSTANCE.reset();
    }

    public void verifyNdv(String expr, long expectedNdv) throws ImpalaException {
        String stmtStr = "select " + expr + " from functional.alltypes";
        this.verifyNdvStmt(stmtStr, expectedNdv);
    }

    public void verifyNdvTwoTable(String expr, long expectedNdv) throws ImpalaException {
        String stmtStr = "select " + expr + " from functional.alltypes a, functional.tinytable tiny";
        this.verifyNdvStmt(stmtStr, expectedNdv);
    }

    public void verifyNdvStmt(String stmt, long expectedNdv) throws ImpalaException {
        AnalysisContext ctx = this.createAnalysisCtx();
        AnalysisContext.AnalysisResult result = this.parseAndAnalyze(stmt, ctx);
        SelectStmt parsedStmt = (SelectStmt)result.getStmt();
        Expr analyzedExpr = ((SelectListItem)parsedStmt.getSelectList().getItems().get(0)).getExpr();
        long calculatedNdv = analyzedExpr.getNumDistinctValues();
        this.assertEquals(expectedNdv, calculatedNdv);
    }

    private void assertEquals(long expected, long actual) {
        if (actual != expected) {
            Assert.fail((String)String.format("\nActual: %d\nExpected: %d\n", actual, expected));
        }
    }

    @Test
    public void testConsts() throws ImpalaException {
        this.verifyNdv("case when 0 = 1 then 'yes' else 'no' end", 2L);
        this.verifyNdv("10", 1L);
        this.verifyNdv("10 * 3", 1L);
        this.verifyNdv("null", 1L);
    }

    @Test
    public void TestCaseExprBasic() throws ImpalaException {
        this.verifyNdv("case when id = 1 then 'yes' else 'no' end", 2L);
        this.verifyNdv("case when id = 1 then 'yes' when id = 2 then 'maybe' else 'no' end", 3L);
        this.verifyNdv("decode(id, 1, 'yes', 'no')", 2L);
        this.verifyNdv("case when id = 1 then 'yes' when id = 2 then 'yes' else 'yes' end", 1L);
        this.verifyNdv("case when id = 1 then 'yes' end", 2L);
        this.verifyNdv("case when id = 1 then 0 else id end", 7301L);
        this.verifyNdv("case when id = 1 then 0 else int_col end", 11L);
        this.verifyNdv("case when id = 1 then 'foo' else date_string_col end", 737L);
        this.verifyNdv("case when id = 1 then int_col else id end", 7300L);
        this.verifyNdv("case when id = 1 then date_string_col when id = 2 then date_string_col else date_string_col end", 736L);
    }

    @Test
    public void testExprBasic() throws ImpalaException {
        this.verifyNdv("id", 7300L);
        this.verifyNdv("id * 0", 7300L);
        this.verifyNdv("CAST(id AS VARCHAR)", 7300L);
        this.verifyNdv("id + 2", 7300L);
        this.verifyNdv("id * 2", 7300L);
        this.verifyNdv("id + int_col", 7300L);
        this.verifyNdv("id * int_col", 7300L);
        this.verifyNdv("nullValue(id)", 7300L);
    }

    @Test
    public void TestCaseExprMissingStats() throws ImpalaException {
        this.verifyNdvTwoTable("case when a.id = 1 then 'yes' when tiny.a = 'whatever' then 'maybe' else 'no' end", 3L);
        this.verifyNdvTwoTable("case when a.id = 1 then tiny.a else tiny.b end", -1L);
        this.verifyNdvTwoTable("case when a.id = 1 then tiny.a else date_string_col end", -1L);
        this.verifyNdvTwoTable("case when tiny.a = 'whatever' then a.id else 0 end", 7301L);
    }

    @Test
    public void testNulls() throws ImpalaException {
        this.verifyNdvStmt("SELECT id FROM functional.nullrows", 26L);
        this.verifyNdvStmt("SELECT some_nulls FROM functional.nullrows", 6L);
        this.verifyNdvStmt("SELECT null_str FROM functional.nullrows", 1L);
        this.verifyNdvStmt("SELECT blank FROM functional.nullrows", 1L);
        this.verifyNdvStmt("SELECT a FROM functional.nulltable", 1L);
        this.verifyNdvStmt("SELECT c FROM functional.nulltable", 1L);
        this.verifyNdvStmt("SELECT id FROM functional.manynulls", -1L);
        this.verifyNdvStmt("SELECT year FROM functional.alltypestiny", 1L);
        this.verifyNdvStmt("SELECT id FROM functional_kudu.alltypestiny", 8L);
        this.verifyNdvStmt("SELECT year FROM functional_kudu.alltypestiny", 1L);
    }
}

