/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import org.apache.impala.analysis.AnalyzerTest;
import org.junit.Test;

public class AnalyzeUpsertStmtTest
extends AnalyzerTest {
    @Test
    public void TestUpsert() {
        this.AnalyzesOk("upsert into table functional_kudu.testtbl values(1, 'a', 1)");
        this.AnalyzesOk("upsert into table functional_kudu.testtbl(id) values(1)");
        this.AnalyzesOk("upsert into table functional_kudu.testtbl values(1, 'a', 1), (2, 'b', 2), (3, 'c', 3)");
        this.AnalyzesOk("upsert into functional_kudu.testtbl select bigint_col, string_col, int_col from functional.alltypes");
        this.AnalyzesOk("upsert into table functional_kudu.testtbl(id) select bigint_col from functional.alltypes");
        this.AnalyzesOk("upsert into table functional_kudu.testtbl(id, name) select bigint_col, string_col from functional.alltypes");
        this.AnalyzesOk("upsert into table functional_kudu.testtbl(name, zip, id) select string_col, int_col, bigint_col from functional.alltypes");
        this.AnalyzesOk("with t1 as (select 1, 'a', 2) upsert into functional_kudu.testtbl select * from t1");
        this.AnalyzesOk("with t1 as (select * from functional.alltypes) upsert into functional_kudu.testtbl select bigint_col, string_col, int_col from t1");
        this.AnalyzesOk("upsert into functional_kudu.testtbl with t1 as (select * from functional.alltypes) select bigint_col, string_col, int_col from t1");
        this.AnalyzesOk("upsert into functional_kudu.testtbl(id) with t1 as (select * from functional.alltypes) select bigint_col from t1");
        this.AnalyzesOk("with t1 as (select * from functional.alltypestiny) upsert into functional_kudu.testtbl with t2 as (select * from functional.alltypessmall) select bigint_col, string_col, int_col from t1");
        this.AnalyzesOk("upsert into table functional_kudu.testtbl select a.id, string_col, b.month from functional.alltypes a, functional.allcomplextypes b, (select item from b.int_array_col) v1 where a.id = b.id");
        this.AnalyzesOk("upsert into table functional_kudu.testtbl [clustered] select * from functional_kudu.testtbl");
        this.AnalyzesOk("upsert into functional_kudu.testtbl (ID, ZIP) values (0, 0)");
        this.AnalysisError("upsert into functional_kudu.testtbl(zip) values(1)", "All primary key columns must be specified for UPSERTing into Kudu tables. Missing columns are: id");
        this.AnalysisError("upsert into functional_kudu.testtbl select * from functional.alltypes", "Target table 'functional_kudu.testtbl' has fewer columns (3) than the SELECT / VALUES clause returns (13)");
        this.AnalysisError("upsert into functional_kudu.testtbl values(1)", "Target table 'functional_kudu.testtbl' has more columns (3) than the SELECT / VALUES clause returns (1)");
        this.AnalysisError("upsert into functional_kudu.testtbl(id, name, zip) values(1)", "Column permutation mentions more columns (3) than the SELECT / VALUES clause returns (1)");
        this.AnalysisError("upsert into functional_kudu.testtbl values(1, 1, 1)", "Target table 'functional_kudu.testtbl' is incompatible with source expressions.\nExpression '1' (type: TINYINT) is not compatible with column 'name' (type: STRING)");
        this.AnalysisError("upsert into functional_kudu.testtbl(zip, id, name) values('a', 'a', 'a')", "Target table 'functional_kudu.testtbl' is incompatible with source expressions.\nExpression ''a'' (type: STRING) is not compatible with column 'zip' (type: INT)");
        this.AnalysisError("upsert into functional_kudu.testtbl (id, name, invalid) values (1, 'a', 1)", "Unknown column 'invalid' in column permutation");
        this.AnalysisError("upsert into functional_kudu.testtbl (id, name, zip, id) values (1, 'a', 1, 1)", "Duplicate column 'id' in column permutation");
        this.AnalysisError("upsert into functional.alltypes select * from functional.alltypes", "UPSERT is only supported for Kudu tables");
        this.AnalysisError("upsert into UNKNOWNDB.testtbl select * from functional.alltypesnopart", "Database does not exist: UNKNOWNDB");
        this.AnalysisError("with t1 as (select 'a' x) upsert into t1 values('b' x)", "Table does not exist: default.t1");
        this.AnalysisError("upsert into functional.alltypes_view select * from functional.alltypes", "Impala does not support UPSERTing into views: functional.alltypes_view");
        this.AnalysisError("upsert into table functional_kudu.testtbl select a.id, a.string_col, b.month from functional.alltypes a, functional.allcomplextypes b, (select item from b.int_array_col, functional.alltypestiny) v1 where a.id = b.id", "Nested query is illegal because it contains a table reference 'b.int_array_col' correlated with an outer block as well as an uncorrelated one 'functional.alltypestiny':\nSELECT item FROM b.int_array_col, functional.alltypestiny");
    }
}

