/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.ColumnDef;
import org.apache.impala.analysis.ComputeStatsStmt;
import org.apache.impala.analysis.CreateTableStmt;
import org.apache.impala.analysis.DescribeTableStmt;
import org.apache.impala.analysis.ParseNode;
import org.apache.impala.analysis.Path;
import org.apache.impala.analysis.QueryStringBuilder;
import org.apache.impala.analysis.UseStmt;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.ColumnStats;
import org.apache.impala.catalog.DataSource;
import org.apache.impala.catalog.DataSourceTable;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.FrontendTestBase;
import org.apache.impala.common.Pair;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.testutil.TestUtils;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TColumnType;
import org.apache.impala.thrift.TDescribeTableParams;
import org.apache.impala.thrift.TQueryOptions;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class AnalyzeDDLTest
extends FrontendTestBase {
    @Test
    public void TestAlterTableAddDropPartition() throws CatalogException {
        String[] addDrop;
        for (String kw : addDrop = new String[]{"add if not exists", "drop if exists"}) {
            this.AnalyzesOk("alter table functional.alltypes " + kw + " partition(year=2050, month=10)");
            this.AnalyzesOk("alter table functional.alltypes " + kw + " partition(month=10, year=2050)");
            this.AnalyzesOk("alter table functional.insert_string_partitioned " + kw + " partition(s2='1234')");
            this.AnalyzesOk("alter table functional.date_tbl " + kw + " partition(date_part='1874-06-04')");
            this.AnalyzesOk("alter table functional.date_tbl " + kw + " partition(date_part=date '1874-06-04')");
            this.AnalyzesOk("alter table functional.date_tbl " + kw + " partition(date_part='1874-6-04')");
            this.AnalyzesOk("alter table functional.date_tbl " + kw + " partition(date_part=date '1874-6-04')");
            this.AnalyzesOk("alter table functional.date_tbl " + kw + " partition(date_part='1874-6-4')");
            this.AnalyzesOk("alter table functional.date_tbl " + kw + " partition(date_part=date '1874-6-4')");
            this.AnalysisError("alter table functional.alltypesnopart " + kw + " partition (i=1)", "Table is not partitioned: functional.alltypesnopart");
            this.AnalysisError("alter table functional_hbase.alltypesagg " + kw + " partition (i=1)", "Table is not partitioned: functional_hbase.alltypesagg");
            this.AnalyzesOk("alter table functional.insert_string_partitioned " + kw + " partition(s2='')");
            this.AnalyzesOk("alter table functional.alltypes " + kw + " partition(year=-1, month=cast((10+5*4) as INT))");
            this.AnalyzesOk("alter table functional.date_tbl " + kw + " partition(date_part=cast('1874-6-4' as date))");
            this.AnalysisError("alter table db_does_not_exist.alltypes " + kw + " partition (i=1)", "Could not resolve table reference: 'db_does_not_exist.alltypes'");
            this.AnalysisError("alter table functional.table_does_not_exist " + kw + " partition (i=1)", "Could not resolve table reference: 'functional.table_does_not_exist'");
            this.AnalysisError("alter table functional.alltypes_view " + kw + " partition(year=2050, month=10)", "ALTER TABLE not allowed on a view: functional.alltypes_view");
            this.AnalysisError("alter table functional.alltypes_datasource " + kw + " partition(year=2050, month=10)", "ALTER TABLE " + kw.toUpperCase() + " PARTITION not allowed on a table PRODUCED BY DATA SOURCE: functional.alltypes_datasource");
            this.AnalysisError("alter table functional.alltypes_jdbc_datasource " + kw + " partition(year=2050, month=10)", "ALTER TABLE " + kw.toUpperCase() + " PARTITION not allowed on a table STORED BY JDBC: functional.alltypes_jdbc_datasource");
            this.AnalyzesOk("alter table functional.alltypes " + kw + " partition(year=NULL, month=1)");
            this.AnalyzesOk("alter table functional.alltypes " + kw + " partition(year=NULL, month=NULL)");
            this.AnalyzesOk("alter table functional.alltypes " + kw + " partition(year=ascii(null), month=ascii(NULL))");
            this.AnalyzesOk("alter table functional.date_tbl " + kw + " partition(date_part=NULL)");
            this.AnalyzesOk("alter table functional.date_tbl " + kw + " partition(date_part=cast(NULL as date))");
        }
        this.AnalysisError("alter table functional.insert_string_partitioned add partition(s2=1234)", "Value of partition spec (column=s2) has incompatible type: 'SMALLINT'. Expected type: 'STRING'.");
        this.AnalysisError("alter table functional.insert_string_partitioned drop partition(s2=1234)", "operands of type STRING and SMALLINT are not comparable: s2 = 1234");
        this.AnalysisError("alter table functional.date_tbl add partition (date_part=123)", "Value of partition spec (column=date_part) has incompatible type: 'TINYINT'. Expected type: 'DATE'.");
        this.AnalysisError("alter table functional.alltypes add partition(year=100000000000, month=10) ", "Partition key value may result in loss of precision.\nWould need to cast '100000000000' to 'INT' for partition column: year");
        this.AnalysisError("alter table functional.date_tbl add partition (date_part='1874-06-')", "Invalid date literal: '1874-06-'");
        this.AnalysisError("alter table functional.date_tbl add partition (date_part=date '1874-06-')", "Invalid date literal: '1874-06-'");
        this.AnalysisError("alter table functional.alltypes add partition(year=2050, year=2051)", "Duplicate partition key name: year");
        this.AnalysisError("alter table functional.date_tbl add partition (date_part='0001-01-01')", "Partition spec already exists: (date_part=DATE '0001-01-01').");
        this.AnalysisError("alter table functional.date_tbl add partition (date_part=DATE '0001-01-01')", "Partition spec already exists: (date_part=DATE '0001-01-01').");
        this.AnalysisError("alter table functional.date_tbl add partition (date_part='0001-01-1')", "Partition spec already exists: (date_part=DATE '0001-01-01').");
        this.AnalysisError("alter table functional.date_tbl add partition (date_part=date '0001-01-1')", "Partition spec already exists: (date_part=DATE '0001-01-01').");
        this.AnalysisError("alter table functional.date_tbl add partition (date_part='0001-01-1')", "Partition spec already exists: (date_part=DATE '0001-01-01').");
        this.AnalysisError("alter table functional.date_tbl add partition (date_part=date '0001-1-1')", "Partition spec already exists: (date_part=DATE '0001-01-01').");
        this.AnalysisError("alter table functional.date_tbl add partition (date_part=cast('0001-1-01' as date))", "Partition spec already exists: (date_part=CAST('0001-1-01' AS DATE)).");
        this.AnalysisError("alter table functional.alltypes add partition(year=2050, month=int_col) ", "Non-constant expressions are not supported as static partition-key values in 'month=int_col'.");
        this.AnalysisError("alter table functional.alltypes add partition(year=cast(int_col as int), month=12) ", "Non-constant expressions are not supported as static partition-key values in 'year=CAST(int_col AS INT)'.");
        this.AnalysisError("alter table functional.alltypes drop partition(year=2050, int_col=1)", "Partition exprs cannot contain non-partition column(s): int_col = 1.");
        this.AnalysisError("alter table functional.alltypes drop partition(year=2050, month=int_col) ", "Partition exprs cannot contain non-partition column(s): `month` = int_col.");
        this.AnalysisError("alter table functional.alltypes drop partition(year=cast(int_col as int), month=12) ", "Partition exprs cannot contain non-partition column(s): `year` = CAST(int_col AS INT).");
        this.AnalyzesOk("alter table functional.alltypes add partition(year=2050, month=10)");
        this.AnalysisError("alter table functional.alltypes add partition(year=2010, month=10)", "Partition spec already exists: (year=2010, month=10).");
        this.AnalyzesOk("alter table functional.alltypes add if not exists partition(year=2010, month=10)");
        this.AnalyzesOk("alter table functional.alltypes add if not exists partition(year=2010, month=10) location '/test-warehouse/alltypes/year=2010/month=10'");
        this.AnalyzesOk("alter table functional.alltypes drop partition(year=2010, month=10)");
        this.AnalysisError("alter table functional.alltypes drop partition(year=2050, month=10)", "No matching partition(s) found.");
        this.AnalyzesOk("alter table functional.alltypes drop if exists partition(year=2050, month=10)");
        this.AnalysisError("alter table functional.alltypes drop partition(year=NULL, month=1)", "No matching partition(s) found.");
        this.AnalysisError("alter table functional.alltypes drop partition(year=NULL, month is NULL)", "No matching partition(s) found.");
        this.AnalysisError("alter table functional.date_tbl drop partition(date_part=NULL)", "No matching partition(s) found.");
        this.AnalyzesOk("alter table functional.alltypes drop partition(year<2011, month!=10)");
        this.AnalysisError("alter table functional.alltypes drop partition(1=1, month=10)", "Invalid partition expr 1 = 1. A partition spec may not contain constant predicates.");
        this.AnalyzesOk("alter table functional.alltypes drop partition(year>1050, month=10)");
        this.AnalyzesOk("alter table functional.alltypes drop partition(year>1050 and month=10)");
        this.AnalyzesOk("alter table functional.alltypes drop partition(month=10)");
        this.AnalyzesOk("alter table functional.alltypes drop partition(month+2000=year)");
        this.AnalyzesOk("alter table functional.alltypes drop partition(year>9050, month=10)");
        this.AnalyzesOk("alter table functional.alltypes drop if exists partition(year>9050, month=10)");
        this.AnalyzesOk("alter table functional.date_tbl drop if exists partition(date_part > '1874-6-2')");
        this.AnalyzesOk("alter table functional.date_tbl drop if exists partition(date_part > date '1874-6-02')");
        this.AnalysisError("alter table functional.alltypes add partition(year=2050, blah=1)", "Partition column 'blah' not found in table: functional.alltypes");
        this.AnalysisError("alter table functional.alltypes drop partition(year=2050, blah=1)", "Could not resolve column/field reference: 'blah'");
        this.AnalysisError("alter table functional.alltypes add partition(year=2050, int_col=1) ", "Column 'int_col' is not a partition column in table: functional.alltypes");
        this.AnalyzesOk("alter table functional.alltypes add partition(year=2050, month=10) cached in 'testPool'");
        this.AnalyzesOk("alter table functional.alltypes add partition(year=2050, month=10) cached in 'testPool' with replication = 10");
        this.AnalyzesOk("alter table functional.alltypes add partition(year=2050, month=10) uncached");
        this.AnalysisError("alter table functional.alltypes add partition(year=2050, month=10) cached in 'badPool'", "The specified cache pool does not exist: badPool");
        this.AnalysisError("alter table functional.alltypes add partition(year=2050, month=10) location 'file:///test-warehouse/alltypes/year=2010/month=10' cached in 'testPool'", "Location 'file:/test-warehouse/alltypes/year=2010/month=10' cannot be cached. Please retry without caching: ALTER TABLE functional.alltypes ADD PARTITION ... UNCACHED");
        this.AnalyzesOk("alter table functional.alltypes add partition(year=2050, month=10) location '/test-warehouse/alltypes/year=2010/month=10'");
        this.AnalyzesOk("alter table functional.alltypes add partition(year=2050, month=10) location 'hdfs://localhost:20500/test-warehouse/alltypes/year=2010/month=10'");
        this.AnalyzesOk("alter table functional.alltypes add partition(year=2050, month=10) location 's3a://bucket/test-warehouse/alltypes/year=2010/month=10'");
        this.AnalyzesOk("alter table functional.alltypes add partition(year=2050, month=10) location 'file:///test-warehouse/alltypes/year=2010/month=10'");
        this.AnalysisError("alter table functional.alltypes add partition(year=2050, month=10) location 'foofs://bar/test-warehouse/alltypes/year=2010/month=10'", "No FileSystem for scheme: foofs");
        this.AnalysisError("alter table functional.alltypes add partition(year=2050, month=10) location '  '", "URI path cannot be empty.");
        String partitioned = "alter table functional_parquet.iceberg_partitioned drop partition";
        String evolution = "alter table functional_parquet.iceberg_partition_evolution drop partition";
        String nonPartitioned = "alter table functional_parquet.iceberg_non_partitioned drop partition";
        this.AnalysisError(nonPartitioned + "(user = 'Alan')", "Table is not partitioned: functional_parquet.iceberg_non_partitioned");
        this.AnalysisError(partitioned + "(action = 'Foo')", "No matching partition(s) found");
        this.AnalysisError(partitioned + "(user = 'Alan')", "Partition exprs cannot contain non-partition column(s): `user`");
        this.AnalysisError(partitioned + "(user = 'Alan' or user = 'Lisa' and id > 10)", "Partition exprs cannot contain non-partition column(s): `user`");
        this.AnalysisError(partitioned + "(void(action) = 'click')", "VOID transform is not supported for partition selection");
        this.AnalysisError(partitioned + "(day(action) = 'Alan')", "Can't filter column 'action' with transform type: 'DAY'");
        this.AnalysisError(partitioned + "(action = action)", "Invalid partition filtering expression: action = action");
        this.AnalysisError(partitioned + "(action = action and action = 'click' or hour(event_time) > '2020-01-01-01')", "Invalid partition filtering expression: action = action AND action = 'click' OR HOUR(event_time) > 438289");
        this.AnalysisError(partitioned + "(action)", "Invalid partition filtering expression: action");
        this.AnalysisError(partitioned + "(2)", "Invalid partition filtering expression: 2");
        this.AnalysisError(partitioned + "(truncate(action))", "BUCKET and TRUNCATE partition transforms should have a parameter");
        this.AnalysisError(partitioned + "(truncate('string', action))", "Invalid transform parameter value: string");
        this.AnalysisError(partitioned + "(truncate(1, 2, action))", "Invalid partition predicate: truncate(1, 2, action)");
        this.AnalysisError(partitioned + " (action = 'click') purge", "Partition purge is not supported for Iceberg tables");
        this.AnalyzesOk(partitioned + "(hour(event_time) > '2020-01-01-01')");
        this.AnalyzesOk(partitioned + "(hour(event_time) < '2020-02-01-01')");
        this.AnalyzesOk(partitioned + "(hour(event_time) = '2020-01-01-9')");
        this.AnalyzesOk(partitioned + "(hour(event_time) = '2020-01-01-9', action = 'click')");
        this.AnalyzesOk(partitioned + "(action = 'click')");
        this.AnalyzesOk(partitioned + "(action = 'click' or action = 'download')");
        this.AnalyzesOk(partitioned + "(action in ('click', 'download'))");
        this.AnalyzesOk(partitioned + "(hour(event_time) in ('2020-01-01-9', '2020-01-01-1'))");
        this.AnalyzesOk(evolution + "(truncate(4,date_string_col,4) = '1231')");
        this.AnalyzesOk(evolution + "(month = 12)");
    }

    @Test
    public void TestAlterTableAddMultiplePartitions() {
        for (String cl : new String[]{"if not exists", ""}) {
            this.AnalyzesOk("alter table functional.alltypes add " + cl + " partition(year=2050, month=10) partition(year=2050, month=11) partition(year=2050, month=12)");
            this.AnalyzesOk("alter table functional.date_tbl add " + cl + " partition(date_part='1970-11-1') partition(date_part='1971-2-01') partition(date_part=DATE '1972-1-1')");
            this.AnalysisError("alter table functional.alltypes add " + cl + " partition(year=2050, month=10) partition(year=2050, month=11) partition(Month=10, YEAR=2050)", "Duplicate partition spec: (month=10, year=2050)");
            this.AnalysisError("alter table functional.date_tbl add " + cl + " partition(date_part='1970-1-1') partition(date_part='1971-1-03') partition(date_part='1970-01-01')", "Duplicate partition spec: (date_part=DATE '1970-01-01')");
            this.AnalyzesOk("alter table functional.alltypes add " + cl + " partition(year=2050, month=10) location '/test-warehouse/alltypes/y2050m10' cached in 'testPool' partition(year=2050, month=11) location 'hdfs://localhost:20500/test-warehouse/alltypes/y2050m11' cached in 'testPool' with replication = 7 partition(year=2050, month=12) location 'file:///test-warehouse/alltypes/y2050m12' uncached");
            this.AnalysisError("alter table functional.alltypes add " + cl + " partition(year=2050, month=10) location '/test-warehouse/alltypes/y2050m10' cached in 'testPool' partition(year=2050, month=11) location 'hdfs://localhost:20500/test-warehouse/alltypes/y2050m11' cached in 'testPool' with replication = 7 partition(year=2050, month=12) location 'fil:///test-warehouse/alltypes/y2050m12' uncached", "No FileSystem for scheme: fil");
            this.AnalysisError("alter table functional.alltypes add " + cl + " partition(year=2050, month=10) location '/test-warehouse/alltypes/y2050m10' cached in 'testPool' partition(year=2050, month=11) location 'hdfs://localhost:20500/test-warehouse/alltypes/y2050m11' cached in 'nonExistentTestPool' with replication = 7 partition(year=2050, month=12) location 'file:///test-warehouse/alltypes/y2050m12' uncached", "The specified cache pool does not exist: nonExistentTestPool");
        }
        this.AnalysisError("alter table functional.alltypes add partition(year=2050, month=1)partition(year=2010, month=1) partition(year=2050, month=2)", "Partition spec already exists: (year=2010, month=1)");
    }

    @Test
    public void TestAlterTableAddColumn() {
        this.AnalyzesOk("alter table functional.alltypes add column new_col int");
        this.AnalyzesOk("alter table functional.alltypes add column NEW_COL int");
        this.AnalyzesOk("alter table functional.alltypes add column if not exists int_col int");
        this.AnalyzesOk("alter table functional.alltypes add column if not exists INT_COL int");
        this.AnalyzesOk("alter table functional.alltypes add column `???` int");
        this.AnalyzesOk("alter table functional.alltypes_datasource add column c1 string");
        this.AnalyzesOk("alter table functional.alltypes_jdbc_datasource add column c1 string");
        this.AnalysisError("alter table functional.alltypes add column int_col int", "Column already exists: int_col");
        this.AnalysisError("alter table functional.alltypes add column INT_COL int", "Column already exists: int_col");
        this.AnalysisError("alter table functional.alltypes add column year int", "Column name conflicts with existing partition column: year");
        this.AnalysisError("alter table functional.alltypes add column if not exists year int", "Column name conflicts with existing partition column: year");
        this.AnalysisError("alter table functional.alltypes add column YEAR int", "Column name conflicts with existing partition column: year");
        this.AnalysisError("alter table functional.alltypes add column if not exists YEAR int", "Column name conflicts with existing partition column: year");
        this.AnalysisError("alter table db_does_not_exist.alltypes add column i int", "Could not resolve table reference: 'db_does_not_exist.alltypes'");
        this.AnalysisError("alter table functional.table_does_not_exist add column i int", "Could not resolve table reference: 'functional.table_does_not_exist'");
        this.AnalysisError("alter table functional.alltypes_view add column c1 string", "ALTER TABLE not allowed on a view: functional.alltypes_view");
        this.AnalysisError("alter table allcomplextypes.int_array_col add column c1 string", this.createAnalysisCtx("functional"), "ALTER TABLE not allowed on a nested collection: allcomplextypes.int_array_col");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource add column i binary", "Tables stored by JDBC do not support the column type: BINARY");
        this.AnalysisError("alter table functional_hbase.alltypes add column i int", "ALTER TABLE ADD COLUMNS not currently supported on HBase tables.");
        this.AnalysisError("alter table functional_kudu.alltypes add column new_col int primary key", "Cannot add a PRIMARY KEY using an ALTER TABLE ADD COLUMNS statement: new_col INT PRIMARY KEY");
        this.AnalysisError("alter table functional_kudu.alltypes add column new_col int non unique primary key", "Cannot add a NON UNIQUE PRIMARY KEY using an ALTER TABLE ADD COLUMNS statement: new_col INT NON UNIQUE PRIMARY KEY");
        this.AnalysisError("alter table functional_kudu.alltypes add column new_col int not null", "A new non-null column must have a default value: new_col INT NOT NULL");
        this.AnalysisError("alter table functional_kudu.alltypes add column c struct<f1:int>", "Kudu tables do not support complex types: c STRUCT<f1:INT>");
        this.AnalysisError("alter table functional.alltypes add column new_col int not null", "The specified column options are only supported in Kudu tables: new_col INT NOT NULL");
    }

    @Test
    public void TestAlterTableAddColumns() {
        this.AnalyzesOk("alter table functional.alltypes add columns (new_col int)");
        this.AnalyzesOk("alter table functional.alltypes add columns (NEW_COL int)");
        this.AnalyzesOk("alter table functional.alltypes add columns (c1 string comment 'hi')");
        this.AnalyzesOk("alter table functional.alltypes add columns (c struct<f1:int>)");
        this.AnalyzesOk("alter table functional.alltypes add if not exists columns (int_col int)");
        this.AnalyzesOk("alter table functional.alltypes add if not exists columns (INT_COL int)");
        this.AnalyzesOk("alter table functional.alltypes add columns(`\uc2dc\uc2a4???\u092a\u0924\u093eED` int)");
        this.AnalyzesOk("alter table functional.alltypes_datasource add columns (c1 string comment 'hi')");
        this.AnalyzesOk("alter table functional.alltypes_jdbc_datasource add columns (c1 string comment 'hi')");
        this.AnalysisError("alter table functional.alltypes add columns (int_col int)", "Column already exists: int_col");
        this.AnalysisError("alter table functional.alltypes add columns (year int)", "Column name conflicts with existing partition column: year");
        this.AnalysisError("alter table functional.alltypes add if not exists columns (year int)", "Column name conflicts with existing partition column: year");
        this.AnalysisError("alter table functional.alltypes add columns (c1 int, c1 int)", "Duplicate column name: c1");
        this.AnalysisError("alter table functional.alltypes add columns (c1 int, C1 int)", "Duplicate column name: c1");
        this.AnalysisError("alter table functional.alltypes add if not exists columns (c1 int, c1 int)", "Duplicate column name: c1");
        this.AnalysisError("alter table functional.alltypes add if not exists columns (c1 int, C1 int)", "Duplicate column name: c1");
        this.AnalysisError("alter table db_does_not_exist.alltypes add columns (i int)", "Could not resolve table reference: 'db_does_not_exist.alltypes'");
        this.AnalysisError("alter table functional.table_does_not_exist add columns (i int)", "Could not resolve table reference: 'functional.table_does_not_exist'");
        this.AnalysisError("alter table functional.alltypes_view add columns (c1 string comment 'hi')", "ALTER TABLE not allowed on a view: functional.alltypes_view");
        this.AnalysisError("alter table allcomplextypes.int_array_col add columns (c1 string comment 'hi')", this.createAnalysisCtx("functional"), "ALTER TABLE not allowed on a nested collection: allcomplextypes.int_array_col");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource add columns (c1 binary comment 'hi')", "Tables stored by JDBC do not support the column type: BINARY");
        this.AnalysisError("alter table functional_hbase.alltypes add columns (i int)", "ALTER TABLE ADD COLUMNS not currently supported on HBase tables.");
        this.AnalysisError("alter table functional_kudu.alltypes add columns (new_col int primary key)", "Cannot add a PRIMARY KEY using an ALTER TABLE ADD COLUMNS statement: new_col INT PRIMARY KEY");
        this.AnalysisError("alter table functional_kudu.alltypes add columns (new_col int non unique primary key)", "Cannot add a NON UNIQUE PRIMARY KEY using an ALTER TABLE ADD COLUMNS statement: new_col INT NON UNIQUE PRIMARY KEY");
        this.AnalysisError("alter table functional_kudu.alltypes add columns(new_col int not null)", "A new non-null column must have a default value: new_col INT NOT NULL");
        this.AnalysisError("alter table functional_kudu.alltypes add columns (c struct<f1:int>)", "Kudu tables do not support complex types: c STRUCT<f1:INT>");
        this.AnalysisError("alter table functional.alltypes add columns(new_col int not null)", "The specified column options are only supported in Kudu tables: new_col INT NOT NULL");
    }

    @Test
    public void TestAlterTableReplaceColumns() {
        this.AnalyzesOk("alter table functional.alltypes replace columns (c1 int comment 'c', c2 int)");
        this.AnalyzesOk("alter table functional.alltypes replace columns (C1 int comment 'c', C2 int)");
        this.AnalyzesOk("alter table functional.alltypes replace columns (c array<string>)");
        this.AnalyzesOk("alter table functional.alltypes replace columns(`?\ucd5c\uc885\u0939\u093f\u0902\u0926\u0940` int)");
        this.AnalyzesOk("alter table functional.alltypes replace columns (int_col int)");
        this.AnalyzesOk("alter table functional.alltypes replace columns (INT_COL int)");
        this.AnalysisError("alter table functional.alltypes replace columns (year int)", "Column name conflicts with existing partition column: year");
        this.AnalysisError("alter table functional.alltypes replace columns (Year int)", "Column name conflicts with existing partition column: year");
        this.AnalysisError("alter table functional.alltypes replace columns (c1 int, c1 int)", "Duplicate column name: c1");
        this.AnalysisError("alter table functional.alltypes replace columns (c1 int, C1 int)", "Duplicate column name: c1");
        this.AnalysisError("alter table db_does_not_exist.alltypes replace columns (i int)", "Could not resolve table reference: 'db_does_not_exist.alltypes'");
        this.AnalysisError("alter table functional.table_does_not_exist replace columns (i int)", "Could not resolve table reference: 'functional.table_does_not_exist'");
        this.AnalysisError("alter table functional.alltypes_view replace columns (c1 string comment 'hi')", "ALTER TABLE not allowed on a view: functional.alltypes_view");
        this.AnalysisError("alter table allcomplextypes.int_array_col replace columns (c1 string comment 'hi')", this.createAnalysisCtx("functional"), "ALTER TABLE not allowed on a nested collection: allcomplextypes.int_array_col");
        this.AnalysisError("alter table functional.alltypes_datasource replace columns (c1 string comment 'hi')", "ALTER TABLE REPLACE COLUMNS not allowed on a table PRODUCED BY DATA SOURCE: functional.alltypes_datasource");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource replace columns (c1 string comment 'hi')", "ALTER TABLE REPLACE COLUMNS not allowed on a table STORED BY JDBC: functional.alltypes_jdbc_datasource");
        this.AnalysisError("alter table functional_hbase.alltypes replace columns (i int)", "ALTER TABLE REPLACE COLUMNS not currently supported on HBase tables.");
        this.AnalysisError("alter table functional_kudu.alltypes replace columns (i int)", "ALTER TABLE REPLACE COLUMNS is not supported on Kudu tables.");
    }

    @Test
    public void TestAlterTableDropColumn() throws AnalysisException {
        this.AnalyzesOk("alter table functional.alltypes drop column int_col");
        this.AnalyzesOk("alter table functional.alltypes_datasource drop column int_col");
        this.AnalyzesOk("alter table functional.alltypes_jdbc_datasource drop column int_col");
        this.AnalysisError("alter table functional.alltypes drop column no_col", "Column 'no_col' does not exist in table: functional.alltypes");
        this.AnalysisError("alter table functional.alltypes drop column year", "Cannot drop partition column: year");
        this.AnalysisError("alter table functional_seq_snap.bad_seq_snap drop column field", "Cannot drop column 'field' from functional_seq_snap.bad_seq_snap. Tables must contain at least 1 column.");
        this.AnalysisError("alter table db_does_not_exist.alltypes drop column col1", "Could not resolve table reference: 'db_does_not_exist.alltypes'");
        this.AnalysisError("alter table functional.table_does_not_exist drop column col1", "Could not resolve table reference: 'functional.table_does_not_exist'");
        this.AnalysisError("alter table functional.alltypes_view drop column int_col", "ALTER TABLE not allowed on a view: functional.alltypes_view");
        this.AnalysisError("alter table allcomplextypes.int_array_col drop column int_col", this.createAnalysisCtx("functional"), "ALTER TABLE not allowed on a nested collection: allcomplextypes.int_array_col");
        this.AnalysisError("alter table functional_hbase.alltypes drop column int_col", "ALTER TABLE DROP COLUMN not currently supported on HBase tables.");
    }

    @Test
    public void TestAlterTableChangeColumn() throws AnalysisException {
        this.AnalyzesOk("alter table functional.alltypes change column int_col int_col2 int");
        this.AnalyzesOk("alter table functional.alltypes change column int_col c2 string");
        this.AnalyzesOk("alter table functional.alltypes change column int_col c2 map<int, string>");
        this.AnalyzesOk("alter table functional.alltypes change column int_col int_col tinyint");
        this.AnalyzesOk("alter table functional.alltypes change int_col int_col int comment 'c'");
        this.AnalyzesOk("alter table functional.alltypes change column int_col `\u6c49\u5b57` int");
        this.AnalyzesOk("alter table functional.alltypes_datasource change column int_col int_col2 int");
        this.AnalyzesOk("alter table functional.alltypes_jdbc_datasource change column int_col int_col2 int");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource change column int_col bin_col binary", "Tables stored by JDBC do not support the column type: BINARY");
        this.AnalysisError("alter table functional.alltypes change column no_col c1 int", "Column 'no_col' does not exist in table: functional.alltypes");
        this.AnalysisError("alter table functional.alltypes change column year year int", "Cannot modify partition column: year");
        this.AnalysisError("alter table functional.alltypes change column int_col Tinyint_col int", "Column already exists: tinyint_col");
        this.AnalysisError("alter table db_does_not_exist.alltypes change c1 c2 int", "Could not resolve table reference: 'db_does_not_exist.alltypes'");
        this.AnalysisError("alter table functional.table_does_not_exist change c1 c2 double", "Could not resolve table reference: 'functional.table_does_not_exist'");
        this.AnalysisError("alter table functional.alltypes_view change column int_col int_col2 int", "ALTER TABLE not allowed on a view: functional.alltypes_view");
        this.AnalysisError("alter table allcomplextypes.int_array_col change column int_col int_col2 int", this.createAnalysisCtx("functional"), "ALTER TABLE not allowed on a nested collection: allcomplextypes.int_array_col");
        this.AnalysisError("alter table functional_hbase.alltypes CHANGE COLUMN int_col i int", "ALTER TABLE CHANGE/ALTER COLUMN not currently supported on HBase tables.");
    }

    @Test
    public void TestAlterTableSetRowFormat() throws AnalysisException {
        String[] unsupportedFileFormatDbs;
        this.AnalyzesOk("alter table functional.alltypes set row format delimited fields terminated by ' '");
        this.AnalyzesOk("alter table functional.alltypes partition (year=2010) set row format delimited fields terminated by ' '");
        this.AnalyzesOk("alter table functional_seq.alltypes set row format delimited fields terminated by ' '");
        this.AnalysisError("alter table functional.alltypesnopart PARTITION (month=1) set row format delimited fields terminated by ' '", "Table is not partitioned: functional.alltypesnopart");
        for (String format : unsupportedFileFormatDbs = new String[]{"functional_parquet", "functional_rc", "functional_avro"}) {
            this.AnalysisError("alter table " + format + ".alltypes set row format delimited fields terminated by ' '", "ALTER TABLE SET ROW FORMAT is only supported on TEXT or SEQUENCE file formats");
        }
        this.AnalysisError("alter table functional_kudu.alltypes set row format delimited fields terminated by ' '", "ALTER TABLE SET ROW FORMAT is only supported on HDFS tables");
        this.AnalysisError("alter table functional.alltypesmixedformat partition(year=2009) set row format delimited fields terminated by ' '", "ALTER TABLE SET ROW FORMAT is only supported on TEXT or SEQUENCE file formats");
        this.AnalyzesOk("alter table functional.alltypesmixedformat partition(year=2009,month=1) set row format delimited fields terminated by ' '");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource set row format delimited fields terminated by ' '", "ALTER TABLE SET ROW FORMAT not allowed on a table STORED BY JDBC: functional.alltypes_jdbc_datasource");
    }

    @Test
    public void TestAlterTableSet() throws AnalysisException {
        String[] unsupportedFileFormats;
        String[] unsupportedFileFormatDbs;
        this.AnalyzesOk("alter table functional.alltypes set fileformat sequencefile");
        this.AnalyzesOk("alter table functional.alltypes set location '/a/b'");
        this.AnalyzesOk("alter table functional.alltypes set tblproperties('a'='1')");
        this.AnalyzesOk("alter table functional.alltypes set serdeproperties('a'='2')");
        this.AnalyzesOk("alter table functional.alltypes unset serdeproperties('a', 'b')");
        this.AnalyzesOk("alter table functional.alltypes unset serdeproperties if exists('a', 'b')");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (Year=2010, month=11) set location '/a/b'");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (month=11, year=2010) set fileformat parquetfile");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (month<=11, year=2010) set fileformat parquetfile");
        this.AnalyzesOk("alter table functional.stringpartitionkey PARTITION (string_col='partition1') set fileformat parquet");
        this.AnalyzesOk("alter table functional.stringpartitionkey PARTITION (string_col='partition1') set location '/a/b/c'");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (year=2010, month=11) set tblproperties('a'='1')");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (year<=2010, month=11) set tblproperties('a'='1')");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (year=2010, month=11) unset tblproperties('a')");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (year=2010, month=11) unset tblproperties if exists ('a')");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (year=2010, month=11) set serdeproperties ('a'='2')");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (year<=2010, month=11) set serdeproperties ('a'='2')");
        this.AnalyzesOk("alter table functional.alltypes_datasource set tblproperties ('a'='2')");
        this.AnalyzesOk("alter table functional.alltypes_jdbc_datasource set tblproperties ('a'='2')");
        this.AnalyzesOk("alter table functional.alltypes_datasource unset tblproperties if exists ('a')");
        this.AnalyzesOk("alter table functional.alltypes_jdbc_datasource unset tblproperties if exists ('a')");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource set serdeproperties ('a'='2')", "ALTER TABLE SET SERDEPROPERTIES is not supported for DataSource table");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource PARTITION (year=2010) set tblproperties ('a'='2')", "Table is not partitioned: functional.alltypes_jdbc_datasource");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource set tblproperties ('__IMPALA_DATA_SOURCE_NAME'='test')", "Changing the '__IMPALA_DATA_SOURCE_NAME' table property is not supported for DataSource table.");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource unset serdeproperties ('a')", "ALTER TABLE UNSET SERDEPROPERTIES is not supported for DataSource table");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource PARTITION (year=2010) unset tblproperties ('a')", "Partition is not supported for DataSource table.");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource unset tblproperties ('__IMPALA_DATA_SOURCE_NAME')", "Unsetting the '__IMPALA_DATA_SOURCE_NAME' table property is not supported for DataSource table.");
        this.AnalyzesOk("alter table functional.alltypes_jdbc_datasource unset tblproperties ('driver.url')");
        this.AnalyzesOk("alter table functional.alltypes set tblproperties('sort.columns'='id')");
        this.AnalyzesOk("alter table functional.alltypes set tblproperties('sort.columns'='INT_COL,id')");
        this.AnalyzesOk("alter table functional.alltypes set tblproperties('sort.columns'='bool_col,int_col,id')");
        this.AnalyzesOk("alter table functional.alltypes set tblproperties('sort.columns'='')");
        this.AnalysisError("alter table functional.alltypes set tblproperties('sort.columns'='id,int_col,id')", "Duplicate column in SORT BY list: id");
        this.AnalysisError("alter table functional.alltypes set tblproperties('sort.columns'='ID, foo')", "Could not find SORT BY column 'foo' in table.");
        this.AnalyzesOk("alter table functional.alltypesagg partition(year=2009, month=1) set location 'hdfs://localhost:20500/test-warehouse/new_table'");
        this.AnalyzesOk("alter table functional.alltypesagg partition(year=2009, month=1) set fileformat parquet");
        this.AnalyzesOk("alter table functional.alltypesagg partition(year=2009, month=1) set tblproperties ('key'='value')");
        this.AnalyzesOk("alter table functional.alltypesagg partition(year=2009, month=1) set serdeproperties ('key'='value')");
        this.AnalyzesOk("alter table functional.alltypesagg partition(year=2009, month=1) set row format delimited fields terminated by '|'");
        String long_property_key = "";
        for (int i = 0; i < 256; ++i) {
            long_property_key = long_property_key + 'k';
        }
        String long_property_value = "";
        for (int i = 0; i < 4000; ++i) {
            long_property_value = long_property_value + 'v';
        }
        this.AnalyzesOk("alter table functional.alltypes set serdeproperties ('" + long_property_key + "'='" + long_property_value + "') ");
        this.AnalyzesOk("alter table functional.alltypes set tblproperties ('" + long_property_key + "'='" + long_property_value + "') ");
        long_property_key = long_property_key + 'X';
        long_property_value = long_property_value + 'X';
        this.AnalysisError("alter table functional.alltypes set tblproperties ('" + long_property_key + "'='value')", "Property key length must be <= 256: 257");
        this.AnalysisError("alter table functional.alltypes unset tblproperties ('" + long_property_key + "')", "Property key length must be <= 256: 257");
        this.AnalysisError("alter table functional.alltypes set tblproperties ('key'='" + long_property_value + "')", "Property value length must be <= 4000: 4001");
        this.AnalysisError("alter table functional.alltypes set serdeproperties ('" + long_property_key + "'='value')", "Property key length must be <= 256: 257");
        this.AnalysisError("alter table functional.alltypes unset serdeproperties ('" + long_property_key + "')", "Property key length must be <= 256: 257");
        this.AnalysisError("alter table functional.alltypes set serdeproperties ('key'='" + long_property_value + "')", "Property value length must be <= 4000: 4001");
        this.AnalysisError("alter table functional.alltypes set tblproperties('storage_handler'='1')", "Changing the 'storage_handler' table property is not supported to protect against metadata corruption.");
        this.AnalysisError("alter table functional.alltypes unset tblproperties('storage_handler')", "Changing the 'storage_handler' table property is not supported to protect against metadata corruption.");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (year=cast(100*20+10 as INT), month=cast(2+9 as INT)) set fileformat sequencefile");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (year=cast(100*20+10 as INT), month=cast(2+9 as INT)) set location '/a/b'");
        this.AnalyzesOk("alter table functional.alltypes PARTITION (Year*2=Year+2010, month=11) set fileformat sequencefile");
        this.AnalysisError("alter table functional.alltypes PARTITION (int_col=3) set fileformat sequencefile", "Partition exprs cannot contain non-partition column(s): int_col = 3.");
        this.AnalysisError("alter table functional.alltypes PARTITION (year!=20) set location '/a/b'", "Partition expr in set location statements can only match one partition. Too many matched partitions year=2009/month=1,year=2009/month=2,year=2009/month=3");
        this.AnalysisError("alter table functional.alltypes PARTITION (year=2014, month=11) set location '/a/b'", "No matching partition(s) found.");
        this.AnalysisError("alter table functional.alltypes PARTITION (year=2014, month=11) set tblproperties('a'='1')", "No matching partition(s) found.");
        this.AnalysisError("alter table functional.alltypes PARTITION (month=11, year=2014) set fileformat sequencefile", "No matching partition(s) found.");
        this.AnalysisError("alter table functional.alltypesnopart PARTITION (month=1) set fileformat sequencefile", "Table is not partitioned: functional.alltypesnopart");
        this.AnalysisError("alter table functional.alltypesnopart PARTITION (month=1) set location '/a/b/c'", "Table is not partitioned: functional.alltypesnopart");
        this.AnalysisError("alter table functional.stringpartitionkey PARTITION (string_col='partition2') set location '/a/b'", "No matching partition(s) found.");
        this.AnalysisError("alter table functional.stringpartitionkey PARTITION (string_col='partition2') set fileformat sequencefile", "No matching partition(s) found.");
        this.AnalysisError("alter table functional.alltypes PARTITION (year=cast(10*20+10 as INT), month=cast(5*3 as INT)) set location '/a/b'", "No matching partition(s) found.");
        this.AnalysisError("alter table functional.alltypes PARTITION (year=cast(10*20+10 as INT), month=cast(5*3 as INT)) set fileformat sequencefile", "No matching partition(s) found.");
        this.AnalysisError("alter table db_does_not_exist.alltypes set fileformat sequencefile", "Could not resolve table reference: 'db_does_not_exist.alltypes'");
        this.AnalysisError("alter table functional.table_does_not_exist set fileformat rcfile", "Could not resolve table reference: 'functional.table_does_not_exist'");
        this.AnalysisError("alter table db_does_not_exist.alltypes set location '/a/b'", "Could not resolve table reference: 'db_does_not_exist.alltypes'");
        this.AnalysisError("alter table functional.table_does_not_exist set location '/a/b'", "Could not resolve table reference: 'functional.table_does_not_exist'");
        this.AnalysisError("alter table functional.no_tbl partition(i=1) set location '/a/b'", "Could not resolve table reference: 'functional.no_tbl'");
        this.AnalysisError("alter table no_db.alltypes partition(i=1) set fileformat textfile", "Could not resolve table reference: 'no_db.alltypes'");
        this.AnalyzesOk("alter table functional.alltypes set location 'hdfs://localhost:20500/test-warehouse/a/b'");
        this.AnalyzesOk("alter table functional.alltypes set location 's3a://bucket/test-warehouse/a/b'");
        this.AnalyzesOk("alter table functional.alltypes set location 'file:///test-warehouse/a/b'");
        this.AnalysisError("alter table functional.alltypes_datasource set location 'file:///test-warehouse/a/b'", "ALTER TABLE SET LOCATION not allowed on a table PRODUCED BY DATA SOURCE: functional.alltypes_datasource");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource set location 'file:///test-warehouse/a/b'", "ALTER TABLE SET LOCATION not allowed on a table STORED BY JDBC: functional.alltypes_jdbc_datasource");
        this.AnalysisError("alter table functional.alltypes set location 'test/warehouse'", "URI path must be absolute: test/warehouse");
        this.AnalysisError("alter table functional.alltypes set location 'blah:///warehouse/'", "No FileSystem for scheme: blah");
        this.AnalysisError("alter table functional.alltypes set location ''", "URI path cannot be empty.");
        this.AnalysisError("alter table functional.alltypes set location '      '", "URI path cannot be empty.");
        this.AnalysisError("alter table functional.alltypes_view set fileformat sequencefile", "ALTER TABLE not allowed on a view: functional.alltypes_view");
        this.AnalysisError("alter table allcomplextypes.int_array_col set fileformat sequencefile", this.createAnalysisCtx("functional"), "ALTER TABLE not allowed on a nested collection: allcomplextypes.int_array_col");
        this.AnalysisError("alter table functional.alltypes_datasource set fileformat parquet", "ALTER TABLE SET FILEFORMAT not allowed on a table PRODUCED BY DATA SOURCE: functional.alltypes_datasource");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource set fileformat parquet", "ALTER TABLE SET FILEFORMAT not allowed on a table STORED BY JDBC: functional.alltypes_jdbc_datasource");
        this.AnalysisError("alter table functional_hbase.alltypes set tblproperties('a'='b')", "ALTER TABLE SET not currently supported on HBase tables.");
        this.AnalyzesOk("alter table functional.alltypes set serdeproperties('serialization.encoding'='GBK')");
        this.AnalyzesOk("alter table functional.text_dollar_hash_pipe set serdeproperties('serialization.encoding'='GBK')");
        this.AnalyzesOk("alter table functional.alltypes partition(year=2010, month=12) set serdeproperties('serialization.encoding'='GBK')");
        String tmpTableName = QueryStringBuilder.createTmpTableName((String)"functional", (String)"tmp_table");
        this.AnalyzesOk("create table " + tmpTableName + " (id int) with serdeproperties('serialization.encoding'='GBK')");
        for (String format : unsupportedFileFormatDbs = new String[]{"functional_parquet", "functional_rc", "functional_avro"}) {
            this.AnalysisError("alter table " + format + ".alltypes set serdeproperties('serialization.encoding'='GBK')", "Property 'serialization.encoding' is only supported on TEXT file format");
        }
        for (String format : unsupportedFileFormats = new String[]{"parquet", "rcfile", "avro", "iceberg", "paimon"}) {
            this.AnalysisError("create table " + tmpTableName + " (id int) with serdeproperties('serialization.encoding'='GBK') stored as " + format, "Property 'serialization.encoding' is only supported on TEXT file format");
        }
        this.AnalysisError("alter table functional_kudu.alltypes set serdeproperties( 'serialization.encoding'='GBK')", "Property 'serialization.encoding' is only supported on HDFS tables");
        this.AnalysisError("alter table functional.alltypesmixedformat partition(year=2009) set serdeproperties('serialization.encoding'='GBK')", "Property 'serialization.encoding' is only supported on TEXT file format");
        this.AnalysisError("create table " + tmpTableName + " (id int, primary key (id)) with serdeproperties('serialization.encoding'='GBK') stored as kudu tblproperties('kudu.master_addresses'='localhost')", "Property 'serialization.encoding' is only supported on TEXT file format");
        this.AnalysisError("alter table functional.alltypes set serdeproperties('serialization.encoding'='UTF-16')", "Property 'serialization.encoding' only supports encodings in which line delimiter is compatible with ASCII.");
        this.AnalysisError("alter table functional.alltypes partition(year=2010, month=12) set serdeproperties('serialization.encoding'='UTF-16')", "Property 'serialization.encoding' only supports encodings in which line delimiter is compatible with ASCII.");
        this.AnalysisError("alter table functional.alltypes set serdeproperties('serialization.encoding'='NonexistentEncoding')", "Unsupported encoding: NonexistentEncoding.");
        this.AnalysisError("create table " + tmpTableName + " (id int) with serdeproperties('serialization.encoding'='UTF-16')", "Property 'serialization.encoding' only supports encodings in which line delimiter is compatible with ASCII.");
        this.AnalysisError("create table " + tmpTableName + " (id int) with serdeproperties('serialization.encoding'='NonexistentEncoding')", "Unsupported encoding: NonexistentEncoding.");
    }

    @Test
    public void TestAlterTableSetCached() {
        this.AnalyzesOk("alter table functional.alltypesnopart set cached in 'testPool'");
        this.AnalyzesOk("alter table functional.alltypes set cached in 'testPool'");
        this.AnalyzesOk("alter table functional.alltypes partition(year=2010, month=12) set cached in 'testPool'");
        this.AnalyzesOk("alter table functional.alltypes partition(year<=2010, month<=12) set cached in 'testPool'");
        this.AnalyzesOk("alter table functional.alltypes set cached in 'testPool' with replication = 10");
        this.AnalyzesOk("alter table functional.alltypes partition(year=2010, month=12) set cached in 'testPool' with replication = 4");
        this.AnalysisError("alter table functional.alltypes set cached in 'testPool' with replication = 0", "Cache replication factor must be between 0 and Short.MAX_VALUE");
        this.AnalysisError("alter table functional.alltypes set cached in 'testPool' with replication = 90000", "Cache replication factor must be between 0 and Short.MAX_VALUE");
        this.AnalysisError("alter table functional_hbase.alltypesnopart set cached in 'testPool'", "ALTER TABLE SET not currently supported on HBase tables.");
        this.AnalysisError("alter table functional.view_view set cached in 'testPool'", "ALTER TABLE not allowed on a view: functional.view_view");
        this.AnalysisError("alter table allcomplextypes.int_array_col set cached in 'testPool'", this.createAnalysisCtx("functional"), "ALTER TABLE not allowed on a nested collection: allcomplextypes.int_array_col");
        this.AnalysisError("alter table functional.alltypes set cached in 'badPool'", "The specified cache pool does not exist: badPool");
        this.AnalysisError("alter table functional.alltypes partition(year=2010, month=12) set cached in 'badPool'", "The specified cache pool does not exist: badPool");
        this.AnalyzesOk("alter table functional.alltypes set uncached");
        this.AnalyzesOk("alter table functional.alltypes partition(year=2010, month=12) set uncached");
        this.AnalyzesOk("alter table functional.alltypestiny set cached in 'testPool'");
        this.AnalyzesOk("alter table functional.alltypestiny partition(year=2009, month=1) set cached in 'testPool'");
        this.AnalysisError("alter table functional.alltypestiny set location '/tmp/tiny'", "Target table is cached, please uncache before changing the location using: ALTER TABLE functional.alltypestiny SET UNCACHED");
        this.AnalysisError("alter table functional.alltypestiny partition (year=2009,month=1) set location '/test-warehouse/new_location'", "Target partition is cached, please uncache before changing the location using: ALTER TABLE functional.alltypestiny PARTITION (`year` = 2009, `month` = 1) SET UNCACHED");
        this.AnalysisError("alter table baddb.alltypestiny set cached in 'testPool'", "Could not resolve table reference: 'baddb.alltypestiny'");
        this.AnalysisError("alter table functional.badtbl set cached in 'testPool'", "Could not resolve table reference: 'functional.badtbl'");
        this.AnalysisError("alter table functional.alltypestiny partition(year=9999, month=1) set cached in 'testPool'", "No matching partition(s) found.");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource set cached in 'testPool'", "ALTER TABLE SET CACHED not allowed on a table STORED BY JDBC: functional.alltypes_jdbc_datasource");
    }

    @Test
    public void TestAlterTableSetColumnStats() {
        ArrayList<String> testKeyValues = new ArrayList<String>();
        for (Object statsKey : ColumnStats.StatsKey.values()) {
            testKeyValues.add(String.format("'%s'='10'", statsKey));
        }
        for (String kv : testKeyValues) {
            this.AnalyzesOk(String.format("alter table functional.alltypes set column stats string_col (%s)", kv));
            this.AnalyzesOk(String.format("alter table functional.alltypes set column stats string_col (%s)", kv.toLowerCase()));
            this.AnalyzesOk(String.format("alter table functional.alltypes set column stats string_col (%s)", kv.toUpperCase()));
        }
        this.AnalyzesOk(String.format("alter table functional.alltypes set column stats string_col (%s)", Joiner.on((String)",").join(testKeyValues)));
        for (Object statsKey : ColumnStats.StatsKey.values()) {
            this.AnalyzesOk(String.format("alter table functional.alltypes set column stats string_col ('%s'='-1')", statsKey));
        }
        this.AnalyzesOk("alter table functional.alltypes set column stats int_col ('numDVs'='2','numDVs'='3')");
        for (Type t : Type.getSupportedTypes()) {
            if (t.isNull()) continue;
            Preconditions.checkState((boolean)t.isScalarType());
            String typeStr = t.getPrimitiveType().toString();
            if (t.getPrimitiveType() == PrimitiveType.CHAR || t.getPrimitiveType() == PrimitiveType.VARCHAR) {
                typeStr = typeStr + "(60)";
            }
            String tblName = "t_" + t.getPrimitiveType();
            this.addTestTable(String.format("create table %s (c %s)", tblName, typeStr));
            this.AnalyzesOk(String.format("alter table %s set column stats c ('%s'='100','%s'='10')", tblName, ColumnStats.StatsKey.NUM_DISTINCT_VALUES, ColumnStats.StatsKey.NUM_NULLS));
            this.AnalyzesOk(String.format("alter table %s set column stats c ('%s'='-1','%s'='-1')", tblName, ColumnStats.StatsKey.NUM_DISTINCT_VALUES, ColumnStats.StatsKey.NUM_NULLS));
        }
        this.AnalyzesOk("alter table functional_hbase.alltypes set column stats int_col ('numNulls'='2')");
        this.AnalyzesOk("alter table functional.alltypes_datasource set column stats int_col ('numDVs'='2')");
        this.AnalyzesOk("alter table functional_kudu.testtbl set column stats name ('numNulls'='2')");
        this.AnalysisError("alter table bad_tbl set column stats int_col ('numNulls'='2')", "Could not resolve table reference: 'bad_tbl'");
        this.AnalysisError("alter table functional.alltypes set column stats bad_col ('numNulls'='2')", "Column 'bad_col' does not exist in table: functional.alltypes");
        this.AnalysisError("alter table functional.alltypes_view set column stats int_col ('numNulls'='2')", "ALTER TABLE not allowed on a view: functional.alltypes_view");
        this.AnalysisError("alter table allcomplextypes.int_array_col set column stats int_col ('numNulls'='2')", this.createAnalysisCtx("functional"), "ALTER TABLE not allowed on a nested collection: allcomplextypes.int_array_col");
        this.AnalysisError("alter table functional.alltypes set column stats month ('numDVs'='10')", "Updating the stats of a partition column is not allowed: month");
        this.AnalysisError("alter table functional.alltypes set column stats int_col ('maxSize'='10')", "Cannot update the 'maxSize' stats of column 'int_col' with type 'INT'.\nChanging 'maxSize' is only allowed for variable-length columns.");
        this.AnalysisError("alter table functional.alltypes set column stats int_col ('avgSize'='10')", "Cannot update the 'avgSize' stats of column 'int_col' with type 'INT'.\nChanging 'avgSize' is only allowed for variable-length columns.");
        this.AnalysisError("alter table functional.allcomplextypes set column stats int_array_col ('numNulls'='10')", "Statistics for column 'int_array_col' are not supported because it has type 'ARRAY<INT>'.");
        this.AnalysisError("alter table functional.allcomplextypes set column stats int_map_col ('numDVs'='10')", "Statistics for column 'int_map_col' are not supported because it has type 'MAP<STRING,INT>'.");
        this.AnalysisError("alter table functional.allcomplextypes set column stats int_struct_col ('numDVs'='10')", "Statistics for column 'int_struct_col' are not supported because it has type 'STRUCT<f1:INT,f2:INT>'.");
        this.AnalysisError("alter table functional.alltypes set column stats int_col ('badKey'='10')", "Invalid column stats key: badKey");
        this.AnalysisError("alter table functional.alltypes set column stats int_col ('numDVs'='10',''='10')", "Invalid column stats key: ");
        this.AnalysisError("alter table functional.alltypes set column stats int_col ('numDVs'='bad')", "Invalid stats value 'bad' for column stats key: numDVs");
        this.AnalysisError("alter table functional.alltypes set column stats int_col ('numDVs'='-10')", "Invalid stats value '-10' for column stats key: numDVs");
        this.AnalysisError("alter table functional.alltypes set column stats string_col ('avgSize'='bad')", "Invalid stats value 'bad' for column stats key: avgSize");
        this.AnalysisError("alter table functional.alltypes set column stats string_col ('avgSize'='-1.5')", "Invalid stats value '-1.5' for column stats key: avgSize");
        this.AnalysisError("alter table functional.alltypes set column stats string_col ('avgSize'='-0.5')", "Invalid stats value '-0.5' for column stats key: avgSize");
        this.AnalysisError("alter table functional.alltypes set column stats string_col ('avgSize'='NaN')", "Invalid stats value 'NaN' for column stats key: avgSize");
        this.AnalysisError("alter table functional.alltypes set column stats string_col ('avgSize'='inf')", "Invalid stats value 'inf' for column stats key: avgSize");
    }

    @Test
    public void TestAlterTableUnSetAvroProperties() {
        for (String propertyType : Lists.newArrayList((Object[])new String[]{"tblproperties", "serdeproperties"})) {
            this.AnalysisError(String.format("alter table functional.alltypes unset %s ('avro.schema.url')", propertyType), "Unsetting the 'avro.schema.url' table property is not supported for Avro table.");
            this.AnalysisError(String.format("alter table functional.alltypes unset %s ('avro.schema.literal')", propertyType), "Unsetting the 'avro.schema.literal' table property is not supported for Avro table.");
        }
    }

    @Test
    public void TestAlterTableSetAvroProperties() {
        for (String propertyType : Lists.newArrayList((Object[])new String[]{"tblproperties", "serdeproperties"})) {
            this.AnalyzesOk(String.format("alter table functional.alltypes set %s('avro.schema.url'='hdfs:///test-warehouse/avro_schemas/functional/alltypes.json')", propertyType));
            this.AnalysisError(String.format("alter table functional.alltypes set %s ('avro.schema.url'='')", propertyType), "Invalid avro.schema.url: . Can not create a Path from an empty string");
            this.AnalysisError(String.format("alter table functional.alltypes set %s ('avro.schema.url'='hdfs://invalid*host/schema.avsc')", propertyType), "Failed to read Avro schema at: hdfs://invalid*host/schema.avsc. Incomplete HDFS URI, no host: hdfs://invalid*host/schema.avsc");
            this.AnalysisError(String.format("alter table functional.alltypes set %s('avro.schema.url'='schema.avsc')", propertyType), "Invalid avro.schema.url: schema.avsc. Path does not exist.");
            this.AnalysisError(String.format("alter table functional.alltypes set %s ('avro.schema.url'='foo://bar/schema.avsc')", propertyType), "Failed to read Avro schema at: foo://bar/schema.avsc. No FileSystem for scheme: foo");
            this.AnalyzesOk(String.format("alter table functional.alltypes set %s('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\": \"string1\", \"type\": \"string\"}] }')", propertyType));
            this.AnalysisError(String.format("alter table functional.alltypes set %s ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": {\"name\": \"string1\", \"type\": \"string\"}]}')", propertyType), "Error parsing Avro schema for table 'functional.alltypes': com.fasterxml.jackson.core.JsonParseException: Unexpected close marker ']': expected '}'");
            this.AnalysisError(String.format("alter table functional.alltypes set %s ('avro.schema.literal'='')", propertyType), "Avro schema is null or empty: functional.alltypes");
            this.AnalysisError(String.format("alter table functional.alltypes set %s ('avro.schema.literal'='{\"name\": \"my_record\"}')", propertyType), "Error parsing Avro schema for table 'functional.alltypes': No type: {\"name\":\"my_record\"}");
            this.AnalysisError(String.format("alter table functional.alltypes set %s ('avro.schema.literal'='{\"name\":\"my_record\", \"type\": \"record\"}')", propertyType), "Error parsing Avro schema for table 'functional.alltypes': Record has no fields: {\"name\":\"my_record\",\"type\":\"record\"}");
            this.AnalysisError(String.format("alter table functional.alltypes set %s ('avro.schema.literal'='{\"type\":\"record\", \"fields\":[ {\"name\":\"fff\",\"type\":\"int\"} ] }')", propertyType), "Error parsing Avro schema for table 'functional.alltypes': No name in schema: {\"type\":\"record\",\"fields\":[{\"name\":\"fff\",\"type\":\"int\"}]}");
            this.AnalysisError(String.format("alter table functional.alltypes set %s ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\": \"string1\", \"type\": \"string\"},{\"name\": \"union1\", \"type\": [\"float\", \"boolean\"]}]}')", propertyType), "Unsupported type 'union' of column 'union1'");
            this.AnalysisError(String.format("alter table functional.alltypes set %s ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": {\"name\": \"string1\", \"type\": \"string\"}]}', 'avro.schema.url'='')", propertyType), "Error parsing Avro schema for table 'functional.alltypes': com.fasterxml.jackson.core.JsonParseException: Unexpected close marker ']': expected '}'");
            this.AnalyzesOk(String.format("alter table functional.alltypes set %s ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\": \"string1\", \"type\": \"string\"}] }', 'avro.schema.url'='')", propertyType));
            this.AnalysisError(String.format("alter table functional.alltypes set %s ('avro.schema.literal'='', 'avro.schema.url'='hdfs:///test-warehouse/avro_schemas/functional/alltypes.json')", propertyType), "Avro schema is null or empty: functional.alltypes");
        }
    }

    @Test
    public void TestAlterTableRename() throws AnalysisException {
        this.AnalyzesOk("alter table functional.alltypes rename to new_alltypes");
        this.AnalyzesOk("alter table functional.alltypes rename to functional.new_alltypes");
        this.AnalysisError("alter table functional.alltypes rename to functional.alltypes", "Table already exists: functional.alltypes");
        this.AnalysisError("alter table functional.alltypes rename to functional.alltypesagg", "Table already exists: functional.alltypesagg");
        this.AnalysisError("alter table functional.table_does_not_exist rename to new_table", "Table does not exist: functional.table_does_not_exist");
        this.AnalysisError("alter table db_does_not_exist.alltypes rename to new_table", "Database does not exist: db_does_not_exist");
        this.AnalysisError("alter table functional.alltypes rename to `???`.new_table", "Invalid database name: ???");
        this.AnalysisError("alter table functional.alltypes rename to functional.`%^&`", "Invalid table/view name: %^&");
        this.AnalysisError("alter table functional.alltypes rename to db_does_not_exist.new_table", "Database does not exist: db_does_not_exist");
        this.AnalysisError("alter table functional.alltypes_view rename to new_alltypes", "ALTER TABLE not allowed on a view: functional.alltypes_view");
        this.AnalysisError("alter table allcomplextypes.int_array_col rename to new_alltypes", this.createAnalysisCtx("functional"), "Database does not exist: allcomplextypes");
        this.AnalyzesOk("alter table functional_hbase.alltypes rename to new_alltypes");
        this.AnalyzesOk("alter table functional.alltypes_datasource rename to new_datasrc_tbl");
        this.AnalyzesOk("alter table functional.alltypes_jdbc_datasource rename to new_jdbc_datasrc_tbl");
    }

    @Test
    public void TestAlterTableRecoverPartitions() throws CatalogException {
        this.AnalyzesOk("alter table functional.alltypes recover partitions");
        this.AnalysisError("alter table baddb.alltypes recover partitions", "Could not resolve table reference: 'baddb.alltypes'");
        this.AnalysisError("alter table functional.badtbl recover partitions", "Could not resolve table reference: 'functional.badtbl'");
        this.AnalysisError("alter table functional.alltypesnopart recover partitions", "Table is not partitioned: functional.alltypesnopart");
        this.AnalysisError("alter table functional.view_view recover partitions", "ALTER TABLE not allowed on a view: functional.view_view");
        this.AnalysisError("alter table allcomplextypes.int_array_col recover partitions", this.createAnalysisCtx("functional"), "ALTER TABLE not allowed on a nested collection: allcomplextypes.int_array_col");
        this.AnalysisError("alter table functional_hbase.alltypes recover partitions", "ALTER TABLE RECOVER PARTITIONS must target an HDFS table: functional_hbase.alltypes");
    }

    @Test
    public void TestAlterTableSortBy() {
        this.AnalyzesOk("alter table functional.alltypes sort by (id)");
        this.AnalyzesOk("alter table functional.alltypes sort by (int_col,id)");
        this.AnalyzesOk("alter table functional.alltypes sort by (bool_col,int_col,id)");
        this.AnalyzesOk("alter table functional.alltypes sort by ()");
        this.AnalysisError("alter table functional.alltypes sort by (id,int_col,id)", "Duplicate column in SORT BY list: id");
        this.AnalysisError("alter table functional.alltypes sort by (id, foo)", "Could not find SORT BY column 'foo' in table.");
        this.AnalysisError("alter table functional_hbase.alltypes sort by (id, foo)", "ALTER TABLE SORT BY not supported on HBase tables.");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource sort by (id)", "ALTER TABLE SORT BY not allowed on a table STORED BY JDBC: functional.alltypes_jdbc_datasource");
    }

    @Test
    public void TestAlterTableSortByZOrder() {
        this.AnalyzesOk("alter table functional.alltypes sort by zorder (int_col,id)");
        this.AnalyzesOk("alter table functional.alltypes sort by zorder (bool_col,int_col,id)");
        this.AnalyzesOk("alter table functional.alltypes sort by zorder (timestamp_col, string_col)");
        this.AnalyzesOk("alter table functional.alltypes sort by zorder ()");
        this.AnalysisError("alter table functional.alltypes sort by zorder (id)", "SORT BY ZORDER with 1 column is equivalent to SORT BY. Please, use the latter, if that was your intention.");
        this.AnalysisError("alter table functional.alltypes sort by zorder (id,int_col,id)", "Duplicate column in SORT BY list: id");
        this.AnalysisError("alter table functional.alltypes sort by zorder (id, foo)", "Could not find SORT BY column 'foo' in table.");
        this.AnalysisError("alter table functional_hbase.alltypes sort by zorder (id, foo)", "ALTER TABLE SORT BY not supported on HBase tables.");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource sort by zorder (id)", "ALTER TABLE SORT BY not allowed on a table STORED BY JDBC: functional.alltypes_jdbc_datasource");
    }

    @Test
    public void TestAlterBucketedTable() throws AnalysisException {
        this.AnalyzesOk("alter table functional.bucketed_table rename to bucketed_table_test");
        this.AnalyzesOk("drop table functional.bucketed_table");
        this.AnalysisError("alter table functional.bucketed_table add columns (a int)", "functional.bucketed_table is a bucketed table. Only read operations are supported on such tables.");
        this.AnalysisError("alter table functional.bucketed_table change col1 default bigint", "functional.bucketed_table is a bucketed table. Only read operations are supported on such tables.");
        this.AnalysisError("alter table functional.bucketed_table replace columns (a int)", "functional.bucketed_table is a bucketed table. Only read operations are supported on such tables.");
        this.AnalysisError("alter table functional.bucketed_table drop col1", "functional.bucketed_table is a bucketed table. Only read operations are supported on such tables.");
    }

    @Test
    public void TestAlterView() {
        this.AnalyzesOk("alter view functional.alltypes_view as select * from functional.alltypesagg");
        this.AnalyzesOk("alter view functional.alltypes_view as select * from functional.alltypes_view_sub");
        this.AnalyzesOk("alter view functional.alltypes_view (a, b) as select int_col, string_col from functional.alltypes");
        this.AnalyzesOk("alter view functional.alltypes_view (a, b) as select int_col x, string_col y from functional.alltypes");
        this.AnalyzesOk("alter view functional.alltypes_view as select trim('abc'), 17 * 7");
        this.AnalyzesOk("alter view functional.alltypes_view (aaa, bbb) as select * from functional.complex_view");
        this.AnalyzesOk("alter view functional.complex_view (abc, xyz) as select year, month from functional.alltypes_view");
        this.AnalyzesOk("alter view functional.alltypes_view (cnt) as select count(distinct x.int_col) from functional.alltypessmall x inner join functional.alltypessmall y on (x.id = y.id) group by x.bigint_col");
        this.AnalysisError("alter view functional.alltypes as select * from functional.alltypesagg", "ALTER VIEW not allowed on a table: functional.alltypes");
        this.AnalysisError("alter view functional_hbase.alltypesagg as select * from functional.alltypesagg", "ALTER VIEW not allowed on a table: functional_hbase.alltypesagg");
        this.AnalysisError("alter view baddb.alltypes_view as select * from functional.alltypesagg", "Database does not exist: baddb");
        this.AnalysisError("alter view functional.badview as select * from functional.alltypesagg", "Table does not exist: functional.badview");
        this.AnalysisError("alter view functional.alltypes_view as select * from baddb.alltypesagg", "Could not resolve table reference: 'baddb.alltypesagg'");
        this.AnalysisError("alter view functional.alltypes_view as select * from functional.badtable", "Could not resolve table reference: 'functional.badtable'");
        this.AnalysisError("alter view functional.alltypes_view as select * from functional.alltypessmall a inner join functional.alltypessmall b on a.id = b.id", "Duplicate column name: id");
        this.AnalyzesOk("alter view functional.alltypes_view as select 'abc' as `\u315b\u315c`");
        this.AnalyzesOk("alter view functional.alltypes_view as select * from functional.alltypestiny where id in (select id from functional.alltypessmall where int_col = 1)");
        this.AnalysisError("alter view functional.alltypes_view (a) as select int_col, string_col from functional.alltypes", "Column-definition list has fewer columns (1) than the view-definition query statement returns (2).");
        this.AnalysisError("alter view functional.alltypes_view (a, b, c) as select int_col from functional.alltypes", "Column-definition list has more columns (3) than the view-definition query statement returns (1).");
        this.AnalysisError("alter view functional.alltypes_view as select * from functional.alltypessmall a inner join functional.alltypessmall b on a.id = b.id", "Duplicate column name: id");
        this.AnalysisError("alter view functional.alltypes_view (a, b, a) as select int_col, int_col, int_col from functional.alltypes", "Duplicate column name: a");
        this.AnalysisError("alter view functional.alltypes_view as select * from functional.alltypes_view", "Self-reference not allowed on view: functional.alltypes_view");
        this.AnalysisError("alter view functional.alltypes_view (a, b, c) as select smallint_col, int_col, bigint_col from functional.alltypes_view", "Self-reference not allowed on view: functional.alltypes_view");
        this.AnalysisError("alter view functional.alltypes_view as select * from functional.alltypes union all select * from functional.alltypes_view", "Self-reference not allowed on view: functional.alltypes_view");
        this.AnalysisError("alter view functional.alltypes_view as select * from functional.alltypes union distinct select * from functional.alltypes_view", "Self-reference not allowed on view: functional.alltypes_view");
        this.AnalysisError("alter view functional.alltypes_view as select * from functional.view_view", "Self-reference not allowed on view: functional.alltypes_view");
        this.AnalysisError("alter view functional.alltypes_view (a, b) as select smallint_col, int_col from functional.view_view", "Self-reference not allowed on view: functional.alltypes_view");
        this.AnalysisError("alter view functional.alltypes_view as select * from functional.alltypes where id > (select sum(tinyint_col) from functional.alltypes_view)", "Self-reference not allowed on view: functional.alltypes_view");
        this.AnalysisError("alter view functional.alltypes_view as with temp_view(col_a, col_b, col_c) as (select tinyint_col, int_col, bigint_col from functional.alltypes_view) select * from temp_view", "Self-reference not allowed on view: functional.alltypes_view");
        this.AnalysisError("alter view functional.alltypes_view as with temp_view(col_a, col_b, col_c) as (select tinyint_col, int_col, bigint_col from functional.alltypes_view) select * from functional.alltypes", "Self-reference not allowed on view: functional.alltypes_view");
        this.AnalysisError("alter view functional.alltypes_view as with temp_view(col_a, col_b, col_c) as (select tinyint_col, int_col, bigint_col from functional.alltypes_view) select * from temp_view union all select tinyint_col, int_col, bigint_col from functional.alltypes", "Self-reference not allowed on view: functional.alltypes_view");
        this.AnalysisError("alter view functional.alltypes_view as with temp_view(col_a, col_b, col_c) as (select tinyint_col, int_col, bigint_col from functional.alltypes_view) select * from temp_view union distinct select tinyint_col, int_col, bigint_col from functional.alltypes", "Self-reference not allowed on view: functional.alltypes_view");
        this.AnalyzesOk("alter view functional.alltypes_view as select cast(null as int) as new_col");
        this.AnalyzesOk("alter view functional.alltypes_view as select cast(null as int) as null_col, 1 as one_col");
        this.AnalysisError("alter view functional.alltypes_view as select null as new_col", "Unable to infer the column type for column 'new_col'. Use cast() to explicitly specify the column type for column 'new_col'.");
    }

    @Test
    public void TestAlterViewSetTblProperties() throws AnalysisException {
        this.AnalyzesOk("ALTER VIEW functional.alltypes_view SET TBLPROPERTIES  ('pro1' = 'test1', 'pro2' = 'test2')");
        this.AnalyzesOk("ALTER VIEW functional.alltypes_view UNSET TBLPROPERTIES  ('pro1', 'pro2')");
        this.AnalysisError("ALTER VIEW Foo.Bar SET TBLPROPERTIES  ('pro1' = 'test1', 'pro2' = 'test2')", "Database does not exist: Foo");
        this.AnalysisError("ALTER VIEW Foo.Bar UNSET TBLPROPERTIES ('pro1', 'pro2')", "Database does not exist: Foo");
        this.AnalysisError("alter view functional_orc_def.mv1_alltypes_jointbl set TBLPROPERTIES('a' = 'a')", "ALTER VIEW not allowed on a materialized view: functional_orc_def.mv1_alltypes_jointbl");
        this.AnalysisError("alter view functional.alltypes set TBLPROPERTIES('a' = 'a')", "ALTER VIEW not allowed on a table: functional.alltypes");
        this.AnalysisError("alter view functional_orc_def.mv1_alltypes_jointbl unset TBLPROPERTIES('a')", "ALTER VIEW not allowed on a materialized view: functional_orc_def.mv1_alltypes_jointbl");
        this.AnalysisError("alter view functional.alltypes unset TBLPROPERTIES('a')", "ALTER VIEW not allowed on a table: functional.alltypes");
    }

    @Test
    public void TestAlterViewRename() throws AnalysisException {
        this.AnalyzesOk("alter view functional.alltypes_view rename to new_view");
        this.AnalyzesOk("alter view functional.alltypes_view rename to functional.new_view");
        this.AnalysisError("alter view functional.alltypes_view rename to functional.alltypes", "Table already exists: functional.alltypes");
        this.AnalysisError("alter view functional.alltypes_view rename to functional.alltypesagg", "Table already exists: functional.alltypesagg");
        this.AnalysisError("alter view functional.view_does_not_exist rename to new_view", "Table does not exist: functional.view_does_not_exist");
        this.AnalysisError("alter view db_does_not_exist.alltypes_view rename to new_view", "Database does not exist: db_does_not_exist");
        this.AnalysisError("alter view functional.alltypes_view rename to db_does_not_exist.new_view", "Database does not exist: db_does_not_exist");
        this.AnalysisError("alter view functional.alltypes_view rename to `???`.new_view", "Invalid database name: ???");
        this.AnalysisError("alter view functional.alltypes_view rename to functional.`%^&`", "Invalid table/view name: %^&");
        this.AnalysisError("alter view functional.alltypes rename to new_alltypes", "ALTER VIEW not allowed on a table: functional.alltypes");
    }

    @Test
    public void TestAlterTableAlterColumn() throws AnalysisException {
        this.AnalyzesOk("alter table functional_kudu.alltypes alter int_col set default 0");
        this.AnalyzesOk("alter table functional_kudu.alltypes alter int_col set compression LZ4 encoding RLE");
        this.AnalyzesOk("alter table functional.alltypes alter int_col set comment 'a'");
        this.AnalyzesOk("alter table functional_kudu.alltypes alter int_col drop default");
        this.AnalyzesOk("alter table functional_kudu.alltypes alter int_col set comment 'a'");
        this.AnalysisError("alter table functional_kudu.alltypes alter id set default 0", "Cannot set default value for primary key column 'id'");
        this.AnalysisError("alter table functional_kudu.alltypes alter id drop default", "Cannot drop default value for primary key column 'id'");
        this.AnalysisError("alter table functional_kudu.alltypes alter int_col set default 'a'", "Default value 'a' (type: STRING) is not compatible with column 'int_col' (type: INT)");
        this.AnalysisError("alter table functional_kudu.alltypes alter int_col set encoding rle compression error", "Unsupported compression algorithm 'ERROR'");
        this.AnalysisError("alter table functional_kudu.alltypes alter int_col set primary key", "Altering a column to be a primary key is not supported.");
        this.AnalysisError("alter table functional_kudu.alltypes alter int_col set not null", "Altering the nullability of a column is not supported.");
        this.AnalysisError("alter table functional.alltypes alter int_col set compression lz4", "Unsupported column options for non-Kudu table: 'int_col INT COMPRESSION LZ4'");
        this.AnalysisError("alter table functional.alltypes alter int_col drop default", "Unsupported column option for non-Kudu table: DROP DEFAULT");
        this.AnalysisError("alter table functional.alltypes_datasource alter int_col drop default", "Unsupported column option for non-Kudu table: DROP DEFAULT");
        this.AnalysisError("alter table functional.alltypes_jdbc_datasource alter int_col drop default", "Unsupported column option for non-Kudu table: DROP DEFAULT");
    }

    ComputeStatsStmt checkComputeStatsStmt(String stmt) throws AnalysisException {
        return this.checkComputeStatsStmt(stmt, this.createAnalysisCtx());
    }

    ComputeStatsStmt checkComputeStatsStmt(String stmt, AnalysisContext ctx) throws AnalysisException {
        return this.checkComputeStatsStmt(stmt, ctx, null);
    }

    ComputeStatsStmt checkComputeStatsStmt(String stmt, AnalysisContext ctx, String expectedWarning) throws AnalysisException {
        ParseNode parseNode = this.AnalyzesOk(stmt, ctx, expectedWarning);
        Assert.assertTrue((boolean)(parseNode instanceof ComputeStatsStmt));
        ComputeStatsStmt parsedStmt = (ComputeStatsStmt)parseNode;
        this.AnalyzesOk(parsedStmt.getTblStatsQuery());
        String colsQuery = parsedStmt.getColStatsQuery();
        if (colsQuery != null) {
            this.AnalyzesOk(colsQuery);
        }
        return parsedStmt;
    }

    void checkComputeStatsStmt(String stmt, List<String> expColNames) throws AnalysisException {
        ComputeStatsStmt parsedStmt = this.checkComputeStatsStmt(stmt);
        Set actCols = parsedStmt.getValidatedColumnWhitelist();
        if (expColNames == null) {
            Assert.assertTrue((String)"Expected no whitelist.", (actCols == null ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)"Expected whitelist.", (actCols != null ? 1 : 0) != 0);
        HashSet<String> actColSet = new HashSet<String>();
        for (Column col : actCols) {
            actColSet.add(col.getName());
        }
        HashSet expColSet = Sets.newHashSet(expColNames);
        Assert.assertEquals(actColSet, (Object)expColSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TestComputeStats() throws AnalysisException {
        this.checkComputeStatsStmt("compute stats functional.alltypes");
        this.checkComputeStatsStmt("compute stats functional_hbase.alltypes");
        this.checkComputeStatsStmt("compute stats functional.allcomplextypes");
        this.checkComputeStatsStmt("compute stats functional.alltypes (int_col, double_col)", Lists.newArrayList((Object[])new String[]{"int_col", "double_col"}));
        this.checkComputeStatsStmt("compute stats functional.alltypes (int_col, double_col, int_col)", Lists.newArrayList((Object[])new String[]{"int_col", "double_col"}));
        this.checkComputeStatsStmt("compute stats functional.alltypes ()", new ArrayList<String>());
        this.AnalysisError("compute stats functional.alltypes(int_col, bogus_col, double_col)", "bogus_col not found in table:");
        this.AnalysisError("compute stats functional.allcomplextypes(id, map_map_col)", "COMPUTE STATS not supported for column");
        this.AnalysisError("compute stats functional.stringpartitionkey(string_col)", "COMPUTE STATS not supported for partitioning");
        this.checkComputeStatsStmt("compute stats functional_hbase.testtbl(id)", Lists.newArrayList((Object[])new String[]{"id"}));
        this.AnalysisError("compute stats tbl_does_not_exist", "Could not resolve table reference: 'tbl_does_not_exist'");
        this.AnalysisError("compute stats functional.alltypes_view", "COMPUTE STATS not supported for view: functional.alltypes_view");
        this.AnalyzesOk("compute stats functional_avro_snap.alltypes");
        this.AnalyzesOk("compute stats functional_avro_snap.alltypes_type_mismatch");
        this.AnalyzesOk("compute stats functional_avro_snap.alltypes_missing_coldef");
        this.AnalyzesOk("compute stats functional_avro_snap.alltypes_extra_coldef");
        this.AnalyzesOk("compute stats functional_avro_snap.alltypes_no_coldef");
        this.AnalysisError("compute stats functional_avro_snap.schema_resolution_test", "Cannot COMPUTE STATS on Avro table 'schema_resolution_test' because its column definitions do not match those in the Avro schema.\nDefinition of column 'col1' of type 'string' does not match the Avro-schema column 'boolean1' of type 'BOOLEAN' at position '0'.\nPlease re-create the table with column definitions, e.g., using the result of 'SHOW CREATE TABLE'");
        TBackendGflags gflags = BackendConfig.INSTANCE.getBackendCfg();
        boolean origEnableStatsExtrapolation = gflags.isEnable_stats_extrapolation();
        try {
            this.addTestDb("extrap_config", null);
            this.addTestTable("create table extrap_config.tbl_prop_unset (i int)");
            this.addTestTable("create table extrap_config.tbl_prop_false (i int) tblproperties('impala.enable.stats.extrapolation'='false')");
            this.addTestTable("create table extrap_config.tbl_prop_true (i int) tblproperties('impala.enable.stats.extrapolation'='true')");
            String stmt = "compute stats %s tablesample system (10)";
            String err = "COMPUTE STATS TABLESAMPLE requires stats extrapolation";
            gflags.setEnable_stats_extrapolation(false);
            this.AnalysisError(String.format(stmt, "extrap_config.tbl_prop_unset"), err);
            this.AnalysisError(String.format(stmt, "extrap_config.tbl_prop_false"), err);
            this.AnalyzesOk(String.format(stmt, "extrap_config.tbl_prop_true"));
            gflags.setEnable_stats_extrapolation(true);
            this.AnalyzesOk(String.format(stmt, "extrap_config.tbl_prop_unset"));
            this.AnalysisError(String.format(stmt, "extrap_config.tbl_prop_false"), err);
            this.AnalyzesOk(String.format(stmt, "extrap_config.tbl_prop_true"));
            gflags.setEnable_stats_extrapolation(true);
            this.checkComputeStatsStmt("compute stats functional.alltypes tablesample system (10)");
            this.checkComputeStatsStmt("compute stats functional.alltypes tablesample system (55) repeatable(1)");
            this.AnalysisError("compute stats functional.alltypes tablesample system (101)", "Invalid percent of bytes value '101'. The percent of bytes to sample must be between 0 and 100.");
            this.AnalysisError("compute stats functional_kudu.alltypes tablesample system (1)", "TABLESAMPLE is only supported on file-based tables.");
            this.AnalysisError("compute stats functional_hbase.alltypes tablesample system (2)", "TABLESAMPLE is only supported on file-based tables.");
            this.AnalysisError("compute stats functional.alltypes_datasource tablesample system (3)", "TABLESAMPLE is only supported on file-based tables.");
            gflags.setEnable_stats_extrapolation(true);
            this.checkComputeStatsStmt("compute stats functional.alltypes (int_col, double_col) tablesample system (55) repeatable(1)", Lists.newArrayList((Object[])new String[]{"int_col", "double_col"}));
            this.AnalysisError("compute stats functional.alltypes tablesample system (101)", "Invalid percent of bytes value '101'. The percent of bytes to sample must be between 0 and 100.");
            this.AnalysisError("compute stats functional_kudu.alltypes tablesample system (1)", "TABLESAMPLE is only supported on file-based tables.");
            this.AnalysisError("compute stats functional_hbase.alltypes tablesample system (2)", "TABLESAMPLE is only supported on file-based tables.");
            this.AnalysisError("compute stats functional.alltypes_datasource tablesample system (3)", "TABLESAMPLE is only supported on file-based tables.");
            TQueryOptions queryOpts = new TQueryOptions();
            Preconditions.checkState((queryOpts.compute_stats_min_sample_size == 0x40000000L ? 1 : 0) != 0);
            ComputeStatsStmt noSamplingStmt = this.checkComputeStatsStmt("compute stats functional.alltypes tablesample system (10) repeatable(1)", this.createAnalysisCtx(queryOpts), "Ignoring TABLESAMPLE because the effective sampling rate is 100%");
            Assert.assertTrue((noSamplingStmt.getEffectiveSamplingPerc() == 1.0 ? 1 : 0) != 0);
            String tblStatsQuery = noSamplingStmt.getTblStatsQuery().toUpperCase();
            Assert.assertTrue((!tblStatsQuery.contains("TABLESAMPLE") ? 1 : 0) != 0);
            Assert.assertTrue((!tblStatsQuery.contains("SAMPLED_NDV") ? 1 : 0) != 0);
            String colStatsQuery = noSamplingStmt.getColStatsQuery().toUpperCase();
            Assert.assertTrue((!colStatsQuery.contains("TABLESAMPLE") ? 1 : 0) != 0);
            Assert.assertTrue((!colStatsQuery.contains("SAMPLED_NDV") ? 1 : 0) != 0);
            queryOpts.setCompute_stats_min_sample_size(0L);
            this.checkComputeStatsStmt("compute stats functional.alltypes tablesample system (10)", this.createAnalysisCtx(queryOpts));
            this.checkComputeStatsStmt("compute stats functional.alltypes tablesample system (55) repeatable(1)", this.createAnalysisCtx(queryOpts));
            queryOpts.setCompute_stats_min_sample_size(0L);
            ComputeStatsStmt baselineStmt = this.checkComputeStatsStmt("compute stats functional.alltypes tablesample system (1) repeatable(1)", this.createAnalysisCtx(queryOpts));
            Assert.assertTrue((baselineStmt.getEffectiveSamplingPerc() > 0.03 ? 1 : 0) != 0);
            Assert.assertTrue((baselineStmt.getEffectiveSamplingPerc() < 0.05 ? 1 : 0) != 0);
            queryOpts.setCompute_stats_min_sample_size(102400L);
            ComputeStatsStmt adjustedStmt = this.checkComputeStatsStmt("compute stats functional.alltypes tablesample system (1) repeatable(1)", this.createAnalysisCtx(queryOpts));
            Assert.assertTrue((adjustedStmt.getEffectiveSamplingPerc() >= 0.16666666666666666 ? 1 : 0) != 0);
            Assert.assertTrue((adjustedStmt.getEffectiveSamplingPerc() <= 0.25 ? 1 : 0) != 0);
        }
        finally {
            gflags.setEnable_stats_extrapolation(origEnableStatsExtrapolation);
        }
    }

    @Test
    public void TestComputeIncrementalStats() throws AnalysisException {
        this.checkComputeStatsStmt("compute incremental stats functional.alltypes");
        this.checkComputeStatsStmt("compute incremental stats functional.alltypes partition(year=2010, month=10)");
        this.checkComputeStatsStmt("compute incremental stats functional.alltypes partition(year<=2010)");
        this.AnalysisError("compute incremental stats functional.alltypes partition(year=9999, month=10)", "No matching partition(s) found.");
        this.AnalysisError("compute incremental stats functional.alltypes partition(year=2010, month)", "Partition expr requires return type 'BOOLEAN'. Actual type is 'INT'.");
        this.checkComputeStatsStmt("compute incremental stats functional.alltypesagg partition(year=2010, month=1, day is NULL)");
        this.AnalysisError("compute incremental stats functional_hbase.alltypes partition(year=2010, month=1)", "COMPUTE INCREMENTAL STATS ... PARTITION not supported for non-filesystem-based table functional_hbase.alltypes");
        this.AnalysisError("compute incremental stats functional_parquet.iceberg_partitioned partition(year=2010, month=1)", "COMPUTE INCREMENTAL STATS ... PARTITION not supported for Iceberg table functional_parquet.iceberg_partitioned");
        this.AnalysisError("compute incremental stats functional.view_view", "COMPUTE STATS not supported for view: functional.view_view");
        this.checkComputeStatsStmt("compute incremental stats functional.alltypes (tinyint_col, smallint_col)");
        this.checkComputeStatsStmt("compute incremental stats functional.alltypes partition(year=2010, month=10)(tinyint_col, smallint_col)");
        this.checkComputeStatsStmt("compute incremental stats functional.alltypes partition(year<=2010)(tinyint_col, smallint_col)");
        long bytes = BackendConfig.INSTANCE.getBackendCfg().getInc_stats_size_limit_bytes();
        long statsBytes = 62399L;
        BackendConfig.INSTANCE.getBackendCfg().setInc_stats_size_limit_bytes(statsBytes);
        this.AnalysisError("compute incremental stats functional.alltypes", "Incremental stats size estimate exceeds " + PrintUtils.printBytes((long)statsBytes) + ". Please try COMPUTE STATS instead.");
        this.checkComputeStatsStmt("compute incremental stats functional.alltypes partition(year=2010, month=10)");
        statsBytes = 31199L;
        BackendConfig.INSTANCE.getBackendCfg().setInc_stats_size_limit_bytes(statsBytes);
        this.AnalysisError("compute incremental stats functional.alltypes partition(year=2009)", "Incremental stats size estimate exceeds " + PrintUtils.printBytes((long)statsBytes) + ". Please try COMPUTE STATS instead.");
        this.checkComputeStatsStmt("compute incremental stats functional.alltypes partition(year=2009, month<12)");
        BackendConfig.INSTANCE.getBackendCfg().setInc_stats_size_limit_bytes(bytes);
    }

    @Test
    public void TestDropIncrementalStats() throws AnalysisException {
        this.AnalyzesOk("drop incremental stats functional.alltypes partition(year=2010, month=10)");
        this.AnalyzesOk("drop incremental stats functional.alltypes partition(year<=2010, month=10)");
        this.AnalysisError("drop incremental stats functional.alltypes partition(year=9999, month=10)", "No matching partition(s) found.");
        this.AnalysisError("drop incremental stats functional_hbase.alltypes partition(year=2010, month=1)", "DROP INCREMENTAL STATS ... PARTITION not supported for non-filesystem-based table functional_hbase.alltypes");
        this.AnalysisError("drop incremental stats functional_parquet.iceberg_partitioned partition(year=2010, month=1)", "DROP INCREMENTAL STATS ... PARTITION not supported for Iceberg table functional_parquet.iceberg_partitioned");
    }

    @Test
    public void TestDropStats() throws AnalysisException {
        this.AnalyzesOk("drop stats functional.alltypes");
        this.AnalysisError("drop stats tbl_does_not_exist", "Could not resolve table reference: 'tbl_does_not_exist'");
        this.AnalysisError("drop stats no_db.no_tbl", "Could not resolve table reference: 'no_db.no_tbl'");
        this.AnalysisError("drop stats functional.alltypes partition(year=2010, month=10)", "Syntax error");
        this.AnalysisError("drop stats functional.alltypes partition(year, month)", "Syntax error");
    }

    @Test
    public void TestDrop() throws AnalysisException {
        this.AnalyzesOk("drop database functional");
        this.AnalyzesOk("drop database functional cascade");
        this.AnalyzesOk("drop database functional restrict");
        this.AnalyzesOk("drop table functional.alltypes");
        this.AnalyzesOk("drop view functional.alltypes_view");
        this.AnalysisError("drop database db_does_not_exist", "Database does not exist: db_does_not_exist");
        this.AnalysisError("drop database db_does_not_exist cascade", "Database does not exist: db_does_not_exist");
        this.AnalysisError("drop database db_does_not_exist restrict", "Database does not exist: db_does_not_exist");
        this.AnalysisError("drop table db_does_not_exist.alltypes", "Database does not exist: db_does_not_exist");
        this.AnalysisError("drop view db_does_not_exist.alltypes_view", "Database does not exist: db_does_not_exist");
        this.AnalysisError("drop database `???`", "Database does not exist: ???");
        this.AnalysisError("drop database `???` cascade", "Database does not exist: ???");
        this.AnalysisError("drop database `???` restrict", "Database does not exist: ???");
        this.AnalysisError("drop table functional.`%^&`", "Table does not exist: functional.%^&");
        this.AnalysisError("drop view functional.`@#$%`", "Table does not exist: functional.@#$%");
        this.AnalysisError("drop table functional.badtable", "Table does not exist: functional.badtable");
        this.AnalysisError("drop view functional.badview", "Table does not exist: functional.badview");
        this.AnalyzesOk("drop database if exists db_does_not_exist");
        this.AnalyzesOk("drop database if exists db_does_not_exist cascade");
        this.AnalyzesOk("drop database if exists db_does_not_exist restrict");
        this.AnalyzesOk("drop table if exists db_does_not_exist.alltypes");
        this.AnalyzesOk("drop view if exists db_does_not_exist.alltypes");
        this.AnalyzesOk("drop table if exists functional.notbl");
        this.AnalyzesOk("drop view if exists functional.notbl");
        this.AnalysisError("drop table functional.alltypes_view", "DROP TABLE not allowed on a view: functional.alltypes_view");
        this.AnalysisError("drop view functional.alltypes", "DROP VIEW not allowed on a table: functional.alltypes");
        this.AnalyzesOk("drop table functional.unsupported_binary_partition");
    }

    @Test
    public void TestTruncate() throws AnalysisException {
        this.AnalyzesOk("truncate table functional.alltypes");
        this.AnalyzesOk("truncate table if exists functional.alltypes");
        this.AnalyzesOk("truncate functional.alltypes");
        this.AnalyzesOk("truncate if exists functional.alltypes");
        this.AnalysisError("truncate table db_does_not_exist.alltypes", "Database does not exist: db_does_not_exist");
        this.AnalyzesOk("truncate table if exists db_does_not_exist.alltypes");
        this.AnalysisError("truncate table functional.`%^&`", "Table does not exist: functional.%^&");
        this.AnalysisError("truncate table functional.badtable", "Table does not exist: functional.badtable");
        this.AnalyzesOk("truncate if exists functional.badtable");
        this.AnalysisError("truncate table functional.alltypes_view", "TRUNCATE TABLE not supported on non-HDFS table: functional.alltypes_view");
    }

    @Test
    public void TestCreateDataSource() {
        String DATA_SOURCE_NAME = "TestDataSource1";
        DataSource DATA_SOURCE = new DataSource("TestDataSource1", "/foo.jar", "foo.Bar", "V1");
        catalog_.addDataSource(DATA_SOURCE);
        this.AnalyzesOk("CREATE DATA SOURCE IF NOT EXISTS TestDataSource1 LOCATION '/foo.jar' CLASS 'foo.Bar' API_VERSION 'V1'");
        this.AnalyzesOk("CREATE DATA SOURCE IF NOT EXISTS " + "TestDataSource1".toLowerCase() + " LOCATION '/foo.jar' CLASS 'foo.Bar' API_VERSION 'V1'");
        this.AnalyzesOk("CREATE DATA SOURCE IF NOT EXISTS TestDataSource1 LOCATION 'hdfs://localhost:20500/foo.jar' CLASS 'foo.Bar' API_VERSION 'V1'");
        this.AnalyzesOk("CREATE DATA SOURCE foo LOCATION '/' CLASS '' API_VERSION 'v1'");
        this.AnalyzesOk("CREATE DATA SOURCE foo LOCATION '/foo.jar' CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.AnalyzesOk("CREATE DATA SOURCE foo LOCATION '/FOO.jar' CLASS 'COM.BAR.FOO' API_VERSION 'v1'");
        this.AnalyzesOk("CREATE DATA SOURCE foo LOCATION \"/foo.jar\" CLASS \"com.bar.Foo\" API_VERSION \"V1\"");
        this.AnalyzesOk("CREATE DATA SOURCE foo LOCATION '/x/foo@hi_^!#.jar' CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.AnalyzesOk("CREATE DATA SOURCE foo LOCATION 'hdfs://localhost:20500/a/b/foo.jar' CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.AnalyzesOk("CREATE DATA SOURCE foo LOCATION 's3a://bucket/a/b/foo.jar' CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.AnalyzesOk("CREATE DATA SOURCE foo CLASS 'com.bar.Foo' API_VERSION 'V1'");
        this.AnalysisError("CREATE DATA SOURCE foo LOCATION 'blah://localhost:20500/foo.jar' CLASS 'com.bar.Foo' API_VERSION 'V1'", "No FileSystem for scheme: blah");
        this.AnalysisError("CREATE DATA SOURCE TestDataSource1 LOCATION '/foo.jar' CLASS 'foo.Bar' API_VERSION 'V1'", "Data source already exists: " + "TestDataSource1".toLowerCase());
        this.AnalysisError("CREATE DATA SOURCE foo LOCATION '/foo.jar' CLASS 'foo.Bar' API_VERSION 'V2'", "Invalid API version: 'V2'");
    }

    @Test
    public void TestCreateDb() throws AnalysisException {
        this.AnalyzesOk("create database some_new_database");
        this.AnalysisError("create database functional", "Database already exists: functional");
        this.AnalyzesOk("create database if not exists functional");
        this.AnalysisError("create database `%^&`", "Invalid database name: %^&");
        this.AnalyzesOk("create database new_db location '/test-warehouse/new_db'");
        this.AnalyzesOk("create database new_db location 'hdfs://localhost:50200/test-warehouse/new_db'");
        this.AnalyzesOk("create database new_db location 's3a://bucket/test-warehouse/new_db'");
        this.AnalysisError("create database new_db location 'blah://bucket/test-warehouse/new_db'", "No FileSystem for scheme: blah");
        this.AnalyzesOk("create database new_db managedlocation '/test-warehouse/new_db'");
        this.AnalyzesOk("create database new_db location '/test-warehouse/new_db' managedlocation '/test-warehouse/new_db'");
        this.AnalysisError("create database new_db managedlocation 'blah://bucket/test-warehouse/new_db'", "No FileSystem for scheme: blah");
    }

    @Test
    public void TestCreateTableLikeFile() throws AnalysisException {
        this.AnalyzesOk("create table if not exists newtbl_DNE like parquet '/test-warehouse/schemas/alltypestiny.parquet'");
        this.AnalyzesOk("create table newtbl_DNE like parquet '/test-warehouse/schemas/zipcode_incomes.parquet'");
        this.AnalyzesOk("create table default.newtbl_DNE like parquet '/test-warehouse/schemas/zipcode_incomes.parquet'");
        this.AnalyzesOk("create table newtbl_DNE like parquet '/test-warehouse/schemas/zipcode_incomes.parquet' stored as parquet");
        this.AnalyzesOk("create external table newtbl_DNE like parquet '/test-warehouse/schemas/zipcode_incomes.parquet' sort by (id,zip) stored as parquet");
        this.AnalyzesOk("create external table newtbl_DNE like parquet '/test-warehouse/schemas/decimal.parquet' sort by zorder (d32, d11) stored as parquet");
        this.AnalyzesOk("create table newtbl_DNE like parquet '/test-warehouse/schemas/zipcode_incomes.parquet' sort by (id,zip)");
        this.AnalyzesOk("create table newtbl_DNE like parquet '/test-warehouse/schemas/decimal.parquet' sort by zorder (d32, d11)");
        this.AnalyzesOk("create table if not exists functional.zipcode_incomes like parquet '/test-warehouse/schemas/zipcode_incomes.parquet'");
        this.AnalyzesOk("create table if not exists newtbl_DNE like parquet '/test-warehouse/schemas/zipcode_incomes.parquet'");
        this.AnalyzesOk("create table if not exists newtbl_DNE like parquet '/test-warehouse/schemas/decimal.parquet'");
        this.AnalyzesOk("create table if not exists newtbl_DNE like parquet' /test-warehouse/schemas/enum/enum.parquet'");
        this.AnalysisError("create table functional.zipcode_incomes like parquet '/test-warehouse/schemas/zipcode_incomes.parquet'", "Table already exists: functional.zipcode_incomes");
        this.AnalysisError("create table database_DNE.newtbl_DNE like parquet '/test-warehouse/schemas/zipcode_incomes.parquet'", "Database does not exist: database_DNE");
        this.AnalysisError("create table if not exists functional.zipcode_incomes like parquet '/test-warehouse'", "Cannot infer schema, path is not a file: hdfs://localhost:20500/test-warehouse");
        this.AnalysisError("create table newtbl_DNE like parquet 'foobar'", "URI path must be absolute: foobar");
        this.AnalysisError("create table newtbl_DNE like parquet '/not/a/file/path'", "Cannot infer schema, path does not exist: hdfs://localhost:20500/not/a/file/path");
        this.AnalysisError("create table if not exists functional.zipcode_incomes like parquet 'file:///tmp/foobar'", "Cannot infer schema, path does not exist: file:/tmp/foobar");
        this.AnalysisError("create table database_DNE.newtbl_DNE like parquet '/test-warehouse/zipcode_incomes_rc/000000_0'", "File is not a parquet file: hdfs://localhost:20500/test-warehouse/zipcode_incomes_rc/000000_0");
        this.AnalysisError("create table if not exists functional.zipcode_incomes like parquet '/test-warehouse/schemas/malformed_decimal_tiny.parquet'", "Unsupported parquet type FIXED_LEN_BYTE_ARRAY for field c1");
        this.AnalysisError("create table newtbl_kudu like parquet '/test-warehouse/schemas/alltypestiny.parquet' stored as kudu", "CREATE TABLE LIKE FILE statement is not supported for Kudu tables.");
        this.AnalysisError("create table newtbl_jdbc like parquet '/test-warehouse/schemas/alltypestiny.parquet' stored as JDBC", "CREATE TABLE LIKE FILE statement is not supported for JDBC tables.");
    }

    @Test
    public void TestCreateTableLikeFileOrc() throws AnalysisException {
        Assume.assumeTrue((String)"Skipping this test; CREATE TABLE LIKE ORC is only supported when running against Hive-3 or greater", (TestUtils.getHiveMajorVersion() >= 3 ? 1 : 0) != 0);
        this.AnalysisError("create table database_DNE.newtbl_DNE like ORC '/test-warehouse/schemas/alltypestiny.parquet'", "Failed to open file as an ORC file: org.apache.orc.FileFormatException: Malformed ORC file hdfs://localhost:20500/test-warehouse/schemas/alltypestiny.parquet. Invalid postscript.");
        this.AnalyzesOk("create table if not exists newtbl_DNE like orc '/test-warehouse/schemas/alltypes_non_acid.orc'");
        this.AnalyzesOk("create table if not exists newtbl_DNE like orc '/test-warehouse/complextypestbl_non_transactional_orc_def/nullable.orc'");
        this.AnalysisError("create table if not exists functional.zipcode_incomes like ORC '/test-warehouse'", "Cannot infer schema, path is not a file: hdfs://localhost:20500/test-warehouse");
        this.AnalysisError("create table newtbl_DNE like ORC 'foobar'", "URI path must be absolute: foobar");
        this.AnalysisError("create table newtbl_DNE like ORC '/not/a/file/path'", "Cannot infer schema, path does not exist: hdfs://localhost:20500/not/a/file/path");
        this.AnalysisError("create table if not exists functional.zipcode_incomes like ORC 'file:///tmp/foobar'", "Cannot infer schema, path does not exist: file:/tmp/foobar");
    }

    @Test
    public void TestCreateTableLikeFileOrcWithHive2() throws AnalysisException {
        Assume.assumeTrue((TestUtils.getHiveMajorVersion() < 3 ? 1 : 0) != 0);
        this.AnalysisError("create table if not exists newtbl_DNE like orc '/test-warehouse/alltypestiny_orc_def/year=2009/month=1/000000_0'", "Creating table like ORC file is unsupported for Hive with version < 3");
    }

    @Test
    public void TestCreateTableAsSelect() throws AnalysisException {
        this.AnalyzesOk("create table newtbl as select 1+2, 'abc'");
        this.AnalyzesOk("create table newtbl stored as textfile as select * from functional.jointbl");
        this.AnalyzesOk("create table newtbl stored as parquetfile as select * from functional.alltypes");
        this.AnalyzesOk("create table newtbl stored as parquet as select * from functional.alltypes");
        this.AnalyzesOk("create table newtbl as select int_col from functional.alltypes");
        this.AnalyzesOk("create table functional.newtbl as select count(*) as CNT from functional.alltypes");
        this.AnalyzesOk("create table functional.tbl as select a.* from functional.alltypes a join functional.alltypes b on (a.int_col=b.int_col) limit 1000");
        this.AnalyzesOk("create table functional.ctas_tbl partitioned by (year) as with tmp as (select a.timestamp_col, a.year from functional.alltypes a left join functional.alltypes b on b.timestamp_col between a.timestamp_col and a.timestamp_col) select a.timestamp_col, a.year from tmp a");
        this.AnalyzesOk("create table functional.newtbl cached in 'testPool' as select count(*) as CNT from functional.alltypes");
        this.AnalyzesOk("create table functional.newtbl uncached as select count(*) as CNT from functional.alltypes");
        this.AnalysisError("create table functional.alltypes as select 1", "Table already exists: functional.alltypes");
        this.AnalyzesOk("create table if not exists functional.alltypes as select 1");
        this.AnalysisError("create table db_does_not_exist.new_table as select 1", "Database does not exist: db_does_not_exist");
        this.AnalysisError("create table newtbl as select * from tbl_does_not_exist", "Could not resolve table reference: 'tbl_does_not_exist'");
        this.AnalysisError("create table newtbl as select 1 as c1, 2 as c1", "Duplicate column name: c1");
        this.AnalysisError("create table foo stored as sequencefile as select 1", "CREATE TABLE AS SELECT does not support the (SEQUENCEFILE) file format. Supported formats are: (PARQUET, TEXTFILE, KUDU, ICEBERG)");
        this.AnalysisError("create table foo stored as RCFILE as select 1", "CREATE TABLE AS SELECT does not support the (RCFILE) file format. Supported formats are: (PARQUET, TEXTFILE, KUDU, ICEBERG)");
        this.AnalysisError("create table foo stored as PAIMON as select 1", "CREATE TABLE AS SELECT does not support the (PAIMON) file format. Supported formats are: (PARQUET, TEXTFILE, KUDU, ICEBERG)");
        this.AnalyzesOk("create table test_with as with with_1 as (select 1 as int_col from functional.alltypes as t1 right join (select 1 as int_col from functional.alltypestiny as t1) as t2 on t2.int_col = t1.int_col) select * from with_1 limit 10");
        this.AnalyzesOk("create table test as select id, item from functional.allcomplextypes b, (select item from b.int_array_col) v1");
        this.AnalyzesOk("create table test as with w as (select id, item from functional.allcomplextypes b, (select item from b.int_array_col) v1) select * from w");
        this.AnalysisError("create table test as select id, item from functional.allcomplextypes b, (select item from b.int_array_col, functional.alltypes) v1", "Nested query is illegal because it contains a table reference 'b.int_array_col' correlated with an outer block as well as an uncorrelated one 'functional.alltypes':\nSELECT item FROM b.int_array_col, functional.alltypes");
        this.AnalysisError("create table test as with w as (select id, item from functional.allcomplextypes b, (select item from b.int_array_col, functional.alltypes) v1) select * from w", "Nested query is illegal because it contains a table reference 'b.int_array_col' correlated with an outer block as well as an uncorrelated one 'functional.alltypes':\nSELECT item FROM b.int_array_col, functional.alltypes");
        this.AnalyzesOk("create table p partitioned by (int_col) as select double_col, int_col from functional.alltypes");
        this.AnalyzesOk("create table p partitioned by (int_col) as select sum(double_col), int_col from functional.alltypes group by int_col");
        this.AnalysisError("create table p partitioned by (int_col, tinyint_col) as select int_col, tinyint_col from functional.alltypes", "Number of partition columns (2) must be smaller than the number of columns in the select statement (2).");
        this.AnalysisError("create table p partitioned by (int_col) as select double_col, int_col, tinyint_col from functional.alltypes", "Partition column name mismatch: int_col != tinyint_col");
        this.AnalysisError("create table p partitioned by (tinyint_col, int_col) as select double_col, int_col, tinyint_col from functional.alltypes", "Partition column name mismatch: tinyint_col != int_col");
        BackendConfig.INSTANCE.getBackendCfg().setKudu_master_hosts("127.0.0.1");
        this.AnalyzesOk("create table t primary key (id) partition by hash (id) partitions 3 stored as kudu as select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col from functional.alltypestiny");
        this.AnalyzesOk("create table t non unique primary key (id) partition by hash (id) partitions 3 stored as kudu as select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col from functional.alltypestiny");
        this.AnalyzesOk("create table t primary key (id) partition by range (id) (partition values < 10, partition 20 <= values < 30, partition value = 50) stored as kudu as select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col from functional.alltypestiny");
        this.AnalyzesOk("create table t primary key (id) partition by hash (id) partitions 3, range (id) (partition values < 10, partition 10 <= values < 20, partition value = 30) stored as kudu as select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col from functional.alltypestiny");
        this.AnalyzesOk("create table t primary key(id) stored as kudu as select id, bool_col from functional.alltypestiny", "Unpartitioned Kudu tables are inefficient for large data sizes.");
        this.AnalyzesOk("create table t primary key(id) stored as kudu as select id, bool_col from functional.alltypestiny where id between 0 and 10");
        this.AnalyzesOk("create table t primary key(year) stored as kudu as with tmp as (select a.timestamp_col, a.year from functional.alltypes a left join functional.alltypes b on b.timestamp_col between a.timestamp_col and a.timestamp_col) select a.timestamp_col, a.year from tmp a");
        this.AnalyzesOk("create table t primary key (id) partition by hash partitions 3 stored as kudu as select c1 as id from functional.decimal_tiny");
        this.AnalyzesOk("create table t primary key (vc) partition by hash partitions 3 stored as kudu as select vc from functional.chars_tiny");
        this.AnalysisError("create external table t stored as kudu tblproperties('kudu.table_name'='t') as select id, int_col from functional.alltypestiny", "CREATE TABLE AS SELECT is not supported for external Kudu tables.");
        this.AnalysisError("create table t primary key (cs) partition by hash partitions 3 stored as kudu as select cs from functional.chars_tiny", "Cannot create table 't': Type CHAR(5) is not supported in Kudu");
        this.AnalysisError("create table t primary key (id) partition by hash partitions 3 stored as kudu as select id, m from functional.complextypes_fileformat", "Cannot create table 't': Type MAP<STRING,BIGINT> is not supported in Kudu");
        this.AnalysisError("create table t primary key (id) partition by hash partitions 3 stored as kudu as select id, a from functional.complextypes_fileformat", "Cannot create table 't': Type ARRAY<INT> is not supported in Kudu");
        this.AnalyzesOk("create table part_kudu_tbl primary key(INT_COL, SMALLINT_COL, ID) partition by hash(INT_COL, SMALLINT_COL, ID) PARTITIONS 2 stored as kudu as SELECT INT_COL, SMALLINT_COL, ID, BIGINT_COL, DATE_STRING_COL, STRING_COL, TIMESTAMP_COL, YEAR, MONTH FROM  functional.alltypes");
        this.AnalyzesOk("create table part_kudu_tbl non unique primary key(INT_COL, SMALLINT_COL, ID) partition by hash(INT_COL, SMALLINT_COL, ID) PARTITIONS 2 stored as kudu as SELECT INT_COL, SMALLINT_COL, ID, BIGINT_COL, DATE_STRING_COL, STRING_COL, TIMESTAMP_COL, YEAR, MONTH FROM functional.alltypes");
        this.AnalyzesOk("create table part_kudu_tbl non unique primary key(INT_COL, SMALLINT_COL, ID, BIGINT_COL, DATE_STRING_COL, STRING_COL, TIMESTAMP_COL, YEAR, MONTH) partition by hash(INT_COL, SMALLINT_COL, ID) PARTITIONS 2 stored as kudu as SELECT INT_COL, SMALLINT_COL, ID, BIGINT_COL, DATE_STRING_COL, STRING_COL, TIMESTAMP_COL, YEAR, MONTH FROM functional.alltypes");
        this.AnalyzesOk("create table no_part_kudu_tbl non unique primary key(INT_COL, SMALLINT_COL, ID) stored as kudu as SELECT INT_COL, SMALLINT_COL, ID, BIGINT_COL, DATE_STRING_COL, STRING_COL, TIMESTAMP_COL, YEAR, MONTH FROM functional.alltypes");
        this.AnalysisError("create table t stored as JDBC as select id, bool_col, tinyint_col from functional.alltypestiny", "CREATE TABLE AS SELECT does not support the (JDBC) file format. Supported formats are: (PARQUET, TEXTFILE, KUDU, ICEBERG)");
        this.AnalyzesOk("create table t as select cast(null as int) as new_col");
        this.AnalyzesOk("create table t as select cast(null as int) as null_col, 1 as one_col");
        this.AnalysisError("create table t as select null as new_col", "Unable to infer the column type for column 'new_col'. Use cast() to explicitly specify the column type for column 'new_col'.");
        this.AnalyzesOk("create table t primary key (id)  stored by kudu as select id, bool_col, tinyint_col, smallint_col, int_col, bigint_col, float_col, double_col, date_string_col, string_col from functional.alltypestiny");
        this.AnalyzesOk("create table t primary key (id) not enforced stored by iceberg as select id, bool_col, int_col, float_col, double_col, date_string_col, string_col from functional.alltypestiny");
        String[] fileFormats = new String[]{"TEXTFILE", "PARQUET", "ICEBERG"};
        for (int i = 0; i < fileFormats.length; ++i) {
            String format = fileFormats[i];
            for (String rowFormat : ImmutableList.of((Object)"FIELDS TERMINATED BY ','", (Object)"LINES TERMINATED BY ','", (Object)"ESCAPED BY ','")) {
                String stmt = String.format("create table new_table row format delimited %s stored as %s as select * from functional.child_table", rowFormat, format);
                if (i == 0) {
                    this.AnalyzesOkWithoutWarnings(stmt);
                    continue;
                }
                this.AnalyzesOk(stmt, "'ROW FORMAT DELIMITED " + rowFormat + "' is ignored.");
            }
        }
    }

    @Test
    public void TestCreateTableAsSelectWithHints() throws AnalysisException {
        for (String[] hintStyle : this.hintStyles_) {
            String prefix = hintStyle[0];
            String suffix = hintStyle[1];
            this.AnalyzesOk(String.format("create %sshuffle%s table t partitioned by (year, month) as select * from functional.alltypes", prefix, suffix));
            this.AnalyzesOk(String.format("create %sbadhint%s table t partitioned by (year, month) as select * from functional.alltypes", prefix, suffix), "INSERT hint not recognized: badhint");
            this.AnalysisError(String.format("create %sshuffle,noshuffle%s table t partitioned by (year, month) as select * from functional.alltypes", prefix, suffix), "Conflicting INSERT hints: shuffle and noshuffle");
        }
        AnalysisContext insertCtx = this.createAnalysisCtx();
        insertCtx.getQueryOptions().setDefault_hints_insert_statement("SHUFFLE");
        this.AnalyzesOk("create table t partitioned by (year, month) as select * from functional.alltypes", insertCtx);
        insertCtx.getQueryOptions().setDefault_hints_insert_statement("badhint");
        this.AnalyzesOk("create table t partitioned by (year, month) as select * from functional.alltypes", insertCtx, "INSERT hint not recognized: badhint");
        insertCtx.getQueryOptions().setDefault_hints_insert_statement("shuffle:noshuFFLe");
        this.AnalysisError("create table t partitioned by (year, month) as select * from functional.alltypes", insertCtx, "Conflicting INSERT hints: shuffle and noshuffle");
    }

    @Test
    public void TestCreateTableLike() throws AnalysisException {
        this.AnalyzesOk("create table if not exists functional.new_tbl like functional.alltypes");
        this.AnalyzesOk("create table functional.like_view like functional.view_view");
        this.AnalyzesOk("create table if not exists functional.alltypes like functional.alltypes");
        this.AnalysisError("create table functional.alltypes like functional.alltypes", "Table already exists: functional.alltypes");
        this.AnalysisError("create table functional.new_table like functional.tbl_does_not_exist", "Table does not exist: functional.tbl_does_not_exist");
        this.AnalysisError("create table functional.new_table like db_does_not_exist.alltypes", "Database does not exist: db_does_not_exist");
        this.AnalysisError("create table `???`.new_table like functional.alltypes", "Invalid database name: ???");
        this.AnalysisError("create table functional.`^&*` like functional.alltypes", "Invalid table/view name: ^&*");
        this.AnalysisError("create table functional.foo like `???`.alltypes", "Database does not exist: ???");
        this.AnalysisError("create table functional.foo like functional.`%^&`", "Table does not exist: functional.%^&");
        this.AnalyzesOk("create table tbl like functional.alltypes location '/test-warehouse/new_table'");
        this.AnalyzesOk("create table tbl like functional.alltypes location 'hdfs://localhost:20500/test-warehouse/new_table'");
        this.AnalyzesOk("create table tbl like functional.alltypes location 'file:///test-warehouse/new_table'");
        this.AnalyzesOk("create table tbl like functional.alltypes location 'file://test-warehouse/new_table'");
        this.AnalyzesOk("create table tbl like functional.alltypes location 'file:/test-warehouse/new_table'");
        this.AnalyzesOk("create table tbl like functional.alltypes location 's3a://bucket/test-warehouse/new_table'");
        this.AnalysisError("create table tbl like functional.alltypes location 'foofs://test-warehouse/new_table'", "No FileSystem for scheme: foofs");
        this.AnalysisError("create table functional.baz like functional.alltypes location '  '", "URI path cannot be empty.");
        this.AnalysisError("create table kudu_tbl like functional.alltypestiny stored as kudu", "functional.alltypestiny cannot be cloned into a KUDU table: CREATE TABLE LIKE is not supported between Kudu tables and non-Kudu tables.");
        this.AnalysisError("create table kudu_to_parquet like functional_kudu.alltypes stored as parquet", "functional_kudu.alltypes cannot be cloned into a PARQUET table: CREATE TABLE LIKE is not supported between Kudu tables and non-Kudu tables.");
        this.AnalysisError("create table kudu_decimal_tbl_clone sort by (d1, d2) like functional_kudu.decimal_tbl", "functional_kudu.decimal_tbl cannot be cloned because SORT BY is not supported for Kudu tables.");
        this.AnalysisError("create table alltypestiny_clone sort by (d1, d2) like functional.alltypestiny stored as kudu", "functional.alltypestiny cannot be cloned into a KUDU table: CREATE TABLE LIKE is not supported between Kudu tables and non-Kudu tables.");
        this.AnalysisError("create table kudu_jointbl_clone like functional_kudu.jointbl", "CREATE TABLE LIKE is not supported for Kudu tables having range partitions.");
        this.AnalysisError("create table jdbc_tbl like functional.alltypestiny stored as JDBC", "CREATE TABLE LIKE is not supported for JDBC tables.");
        this.AnalyzesOk("create table tbl sort by (int_col,id) like functional.alltypes");
        this.AnalysisError("create table tbl sort by (int_col,foo) like functional.alltypes", "Could not find SORT BY column 'foo' in table.");
        this.AnalyzesOk("create table tbl sort by zorder (int_col,id) like functional.alltypes");
        this.AnalyzesOk("create table tbl sort by zorder (float_col,id) like functional.alltypes");
        this.AnalyzesOk("create table tbl sort by zorder (double_col,id) like functional.alltypes");
        this.AnalyzesOk("create table tbl sort by zorder (string_col,timestamp_col) like functional.alltypes");
        this.AnalysisError("create table tbl sort by zorder (int_col,foo) like functional.alltypes", "Could not find SORT BY column 'foo' in table.");
    }

    @Test
    public void TestCreateTable() throws AnalysisException {
        this.AnalyzesOk("create table functional.new_table (i int)");
        this.AnalyzesOk("create table if not exists functional.alltypes (i int)");
        this.AnalysisError("create table functional.alltypes", "Table already exists: functional.alltypes");
        this.AnalysisError("create table functional.alltypes (i int)", "Table already exists: functional.alltypes");
        this.AnalyzesOk("create table functional.new_table (i int) row format delimited fields terminated by '|'");
        this.AnalyzesOk("create table new_table (i int) PARTITIONED BY (d decimal)");
        this.AnalyzesOk("create table new_table (i int) PARTITIONED BY (d decimal(3,1))");
        this.AnalyzesOk("create table new_table(d1 decimal, d2 decimal(10), d3 decimal(5, 2))");
        this.AnalysisError("create table new_table (i int) PARTITIONED BY (d decimal(40,1))", "Decimal precision must be <= 38: 40");
        this.AnalyzesOk("create table new_table(s1 varchar(1), s2 varchar(32672), s3 varchar(65535))");
        this.AnalysisError("create table new_table(s1 varchar(0))", "Varchar size must be > 0: 0");
        this.AnalysisError("create table new_table(s1 varchar(65536))", "Varchar size must be <= 65535: 65536");
        this.AnalysisError("create table new_table(s1 char(0))", "Char size must be > 0: 0");
        this.AnalysisError("create table new_table(s1 Char(256))", "Char size must be <= 255: 256");
        this.AnalyzesOk("create table new_table (i int) PARTITIONED BY (s varchar(3))");
        this.AnalyzesOk("create table functional.new_table (c char(250))");
        this.AnalyzesOk("create table new_table (i int) PARTITIONED BY (c char(3))");
        this.AnalyzesOk("create table foo(id int, year int, primary key (id))");
        this.AnalyzesOk("create table foo(id int, year int, primary key (id, year))");
        this.AnalyzesOk("create table foo(id int, year int, primary key (id, year) disable novalidate rely)");
        this.AnalysisError("create table foo(id int, year int, primary key (id, year) enable novalidate rely)", "ENABLE feature is not supported yet.");
        this.AnalysisError("create table foo(id int, year int, primary key (id, year) disable validate rely)", "VALIDATE feature is not supported yet.");
        this.AnalysisError("create table pk(id int, primary key(year))", "PRIMARY KEY column 'year' does not exist in the table");
        this.addTestDb("test_pk_fk", "Test DB for PK/FK tests");
        AnalysisContext ctx = this.createAnalysisCtx("test_pk_fk");
        this.AnalysisError("create table foo(seq int, id int, year int, a int, foreign key (id, year) references functional.parent_table(id, year) enable novalidate rely)", ctx, "ENABLE feature is not supported yet.");
        this.AnalysisError("create table foo(seq int, id int, year int, a int, foreign key (id, year) references functional.parent_table(id, year) disable validate rely)", ctx, "VALIDATE feature is not supported yet.");
        this.AnalyzesOk("create table foo(seq int, id int, year int, a int, foreign key(id, year) references functional.parent_table(id, year) DISABLE NOVALIDATE RELY)", ctx);
        this.AnalyzesOk("create table foo(seq int, id int, year int, a int, foreign key(id, year) references functional.parent_table(id, year) disable novalidate rely)", ctx);
        this.AnalyzesOk("create table foo(seq int, id int, year int, a int, foreign key(id, year) references functional.parent_table(id, year))", ctx);
        this.AnalysisError("create table fk(id int, year string, foreign key(year) references pk2(year))", ctx, "Parent table not found: test_pk_fk.pk2");
        this.AnalyzesOk("create table fk(id int, year string, foreign key(id, year) references functional.parent_table(id, year))", ctx);
        this.AnalysisError("create table fk(id int, year string, foreign key(id, year) references pk(year))", ctx, "The number of foreign key columns should be same as the number of parent key columns.");
        this.AnalysisError("create table fk(id int, foreign key(id) references functional.parent_table(foo))", ctx, "Parent column not found: foo");
        this.AnalysisError("create table fk(id int, foreign key(id) references functional.alltypes(int_col))", ctx, "Parent column int_col is not part of primary key.");
        String long_property_key = "";
        for (int i = 0; i < 256; ++i) {
            long_property_key = long_property_key + 'k';
        }
        String long_property_value = "";
        for (int i = 0; i < 4000; ++i) {
            long_property_value = long_property_value + 'v';
        }
        this.AnalyzesOk("create table new_table (i int) with serdeproperties ('" + long_property_key + "'='" + long_property_value + "') tblproperties ('" + long_property_key + "'='" + long_property_value + "')");
        long_property_key = long_property_key + 'X';
        long_property_value = long_property_value + 'X';
        this.AnalysisError("create table new_table (i int) tblproperties ('" + long_property_key + "'='value')", "Property key length must be <= 256: 257");
        this.AnalysisError("create table new_table (i int) tblproperties ('key'='" + long_property_value + "')", "Property value length must be <= 4000: 4001");
        this.AnalysisError("create table new_table (i int) with serdeproperties ('" + long_property_key + "'='value')", "Serde property key length must be <= 256: 257");
        this.AnalysisError("create table new_table (i int) with serdeproperties ('key'='" + long_property_value + "')", "Serde property value length must be <= 4000: 4001");
        UnmodifiableIterator fileFormats = new UnmodifiableIterator[]{"TEXTFILE", "SEQUENCEFILE", "PARQUET", "PARQUETFILE", "RCFILE", "JSONFILE"};
        String[] fileFormatsStr = new String[]{"TEXT", "SEQUENCE_FILE", "PARQUET", "PARQUET", "RC_FILE", "JSON"};
        int formatIndx = 0;
        for (String format : fileFormats) {
            for (String create : ImmutableList.of((Object)"create table", (Object)"create external table")) {
                this.AnalyzesOk(String.format("%s new_table (i int) partitioned by (d decimal) comment 'c' stored as %s", create, format));
                this.AnalysisError(String.format("%s new_table partitioned by (d decimal) comment 'c' stored as %s", create, format), "Table requires at least 1 column");
            }
            this.AnalysisError(String.format("create table t (i int primary key) stored as %s", format), String.format("Unsupported column options for file format '%s': 'i INT PRIMARY KEY'", fileFormatsStr[formatIndx]));
            ++formatIndx;
        }
        for (formatIndx = 0; formatIndx < ((String[])fileFormats).length; ++formatIndx) {
            for (String rowFormat : ImmutableList.of((Object)"FIELDS TERMINATED BY ','", (Object)"LINES TERMINATED BY ','", (Object)"ESCAPED BY ','")) {
                String stmt = String.format("create table new_table (i int) row format delimited %s stored as %s", rowFormat, fileFormats[formatIndx]);
                if (formatIndx < 2) {
                    this.AnalyzesOkWithoutWarnings(stmt);
                    continue;
                }
                this.AnalyzesOk(stmt, "'ROW FORMAT DELIMITED " + rowFormat + "' is ignored");
            }
        }
        this.AnalyzesOk("create table functional.new_table (i int) row format delimited fields terminated by '\\t' escaped by '\\\\' lines terminated by '\\n'");
        this.AnalyzesOk("create table functional.new_table (i int) row format delimited fields terminated by '\\001' escaped by '\\002' lines terminated by '\\n'");
        this.AnalyzesOk("create table functional.new_table (i int) row format delimited fields terminated by '-2' escaped by '-3' lines terminated by '\\n'");
        this.AnalyzesOk("create table functional.new_table (i int) row format delimited fields terminated by '-128' escaped by '127' lines terminated by '40'");
        this.AnalysisError("create table functional.new_table (i int) row format delimited fields terminated by '-2' escaped by '128' lines terminated by '\\n'", "ESCAPED BY values and LINE/FIELD terminators must be specified as a single character or as a decimal value in the range [-128:127]: 128");
        this.AnalysisError("create table functional.new_table (i int) row format delimited fields terminated by '-2' escaped by '127' lines terminated by '255'", "ESCAPED BY values and LINE/FIELD terminators must be specified as a single character or as a decimal value in the range [-128:127]: 255");
        this.AnalysisError("create table functional.new_table (i int) row format delimited fields terminated by '-129' escaped by '127' lines terminated by '\\n'", "ESCAPED BY values and LINE/FIELD terminators must be specified as a single character or as a decimal value in the range [-128:127]: -129");
        this.AnalysisError("create table functional.new_table (i int) row format delimited fields terminated by '||' escaped by '\\\\' lines terminated by '\\n'", "ESCAPED BY values and LINE/FIELD terminators must be specified as a single character or as a decimal value in the range [-128:127]: ||");
        this.AnalysisError("create table functional.broken_text_table (c int) row format delimited fields terminated by '\u0001' lines terminated by '\u0001'", "Field delimiter and line delimiter have same value: byte 1");
        this.AnalysisError("create table functional.broken_text_table (c int) row format delimited lines terminated by '\u0001'", "Field delimiter and line delimiter have same value: byte 1");
        this.AnalysisError("create table functional.broken_text_table (c int) row format delimited fields terminated by '\n'", "Field delimiter and line delimiter have same value: byte 10");
        this.AnalyzesOk("create table functional.broken_text_table (c int) row format delimited escaped by '\u0001'", "Field delimiter and escape character have same value: byte 1. Escape character will be ignored");
        this.AnalyzesOk("create table functional.broken_text_table (c int) row format delimited escaped by 'x' lines terminated by 'x'", "Line delimiter and escape character have same value: byte 120. Escape character will be ignored");
        this.AnalysisError("create table db_does_not_exist.new_table (i int)", "Database does not exist: db_does_not_exist");
        this.AnalysisError("create table new_table (i int, I string)", "Duplicate column name: i");
        this.AnalysisError("create table new_table (c1 double, col2 int, c1 double, c4 string)", "Duplicate column name: c1");
        this.AnalysisError("create table new_table (i int, s string) PARTITIONED BY (i int)", "Duplicate column name: i");
        this.AnalysisError("create table new_table (i int) PARTITIONED BY (C int, c2 int, c int)", "Duplicate column name: c");
        this.AnalysisError("create table new_table (i int) PARTITIONED BY (t timestamp)", "Type 'TIMESTAMP' is not supported as partition-column type in column: t");
        this.AnalysisError("create table new_table (i int) PARTITIONED BY (t binary)", "Type 'BINARY' is not supported as partition-column type in column: t");
        this.AnalyzesOk("create table cached_tbl(i int) partitioned by(j int) cached in 'testPool'");
        this.AnalyzesOk("create table cached_tbl(i int) partitioned by(j int) uncached");
        this.AnalyzesOk("create table cached_tbl(i int) partitioned by(j int) location '/test-warehouse/' cached in 'testPool'");
        this.AnalyzesOk("create table cached_tbl(i int) partitioned by(j int) location '/test-warehouse/' uncached");
        this.AnalysisError("create table cached_tbl(i int) location 'file:///test-warehouse/cache_tbl' cached in 'testPool'", "Location 'file:/test-warehouse/cache_tbl' cannot be cached. Please retry without caching: CREATE TABLE ... UNCACHED");
        this.AnalysisError("create table `???`.new_table (x int) PARTITIONED BY (y int)", "Invalid database name: ???");
        this.AnalysisError("create table functional.`^&*` (x int) PARTITIONED BY (y int)", "Invalid table/view name: ^&*");
        this.AnalyzesOk("create table new_table (`???` int) PARTITIONED BY (i int)");
        this.AnalyzesOk("create table new_table (i int) PARTITIONED BY (`^&*` int)");
        this.AnalyzesOk(String.format("create table t (i int comment '%s')", StringUtils.repeat((String)"c", (int)256)));
        this.AnalysisError(String.format("create table t (i int comment '%s')", StringUtils.repeat((String)"c", (int)257)), "Comment of column 'i' exceeds maximum length of 256 characters:");
        this.AnalyzesOk("create table tbl (i int) location '/test-warehouse/new_table'");
        this.AnalyzesOk("create table tbl (i int) location 'hdfs://localhost:20500/test-warehouse/new_table'");
        this.AnalyzesOk("create table tbl (i int) location 'file:///test-warehouse/new_table'");
        this.AnalyzesOk("create table tbl (i int) location 's3a://bucket/test-warehouse/new_table'");
        this.AnalyzesOk("ALTER TABLE functional_seq_snap.alltypes SET LOCATION 'file://test-warehouse/new_table'");
        this.AnalysisError("create table functional.foo (x int) location 'foofs://test-warehouse/new_table'", "No FileSystem for scheme: foofs");
        this.AnalysisError("create table functional.foo (x int) location '  '", "URI path cannot be empty.");
        this.AnalysisError("ALTER TABLE functional_seq_snap.alltypes SET LOCATION 'foofs://test-warehouse/new_table'", "No FileSystem for scheme: foofs");
        this.AnalysisError("ALTER TABLE functional_seq_snap.alltypes SET LOCATION '  '", "URI path cannot be empty.");
        this.AnalyzesOk("CREATE EXTERNAL TABLE Foo (i int) STORED BY JDBC TBLPROPERTIES ('database.type'='a', 'jdbc.url'='b', 'jdbc.driver'='c', 'driver.url'='d', 'dbcp.username'='e', 'dbcp.password'='f', 'table'='g')");
        this.AnalysisError("CREATE TABLE Foo (i int) STORED BY JDBC TBLPROPERTIES ('database.type'='a', 'jdbc.url'='b', 'jdbc.driver'='c', 'driver.url'='d', 'dbcp.username'='e', 'dbcp.password'='f', 'table'='g')", "JDBC table must be created as external table");
        this.AnalysisError("CREATE EXTERNAL TABLE Foo STORED BY JDBC TBLPROPERTIES ('database.type'='a', 'jdbc.url'='b', 'jdbc.driver'='c', 'driver.url'='d', 'dbcp.username'='e', 'dbcp.password'='f', 'table'='g')", "Table requires at least 1 column");
        this.AnalysisError("CREATE EXTERNAL TABLE Foo (i int) STORED BY JDBC TBLPROPERTIES ('a'='b')", "Cannot create table 'Foo': Required JDBC config 'database.type' is not present in table properties.");
        this.AnalysisError("CREATE EXTERNAL TABLE Foo (i int) STORED BY JDBC CACHED IN 'testPool'", "A JDBC table cannot be cached in HDFS.");
        this.AnalysisError("CREATE EXTERNAL TABLE Foo (i int) STORED BY JDBC LOCATION '/test-warehouse/new_table'", "LOCATION cannot be specified for a JDBC table.");
        this.AnalysisError("CREATE EXTERNAL TABLE Foo (i int) PARTITIONED BY (d decimal) STORED BY JDBC ", "PARTITIONED BY cannot be used in a JDBC table.");
        this.AnalyzesOk("CREATE TABLE IF NOT EXISTS foo (user_id BIGINT, item_id BIGINT, behavior STRING) STORED AS PAIMON");
        this.AnalyzesOk("CREATE TABLE IF NOT EXISTS foo (user_id BIGINT, item_id BIGINT, behavior STRING) PARTITIONED BY (dt STRING, hh STRING) STORED AS PAIMON");
        this.AnalyzesOk("CREATE TABLE foo (user_id BIGINT, item_id BIGINT, behavior STRING) PARTITIONED BY (dt STRING, hh STRING) STORED AS PAIMON TBLPROPERTIES ('primary-key'='user_id')");
        this.AnalyzesOk("CREATE TABLE foo (user_id BIGINT, item_id BIGINT, behavior STRING, PRIMARY KEY(user_id)) PARTITIONED BY (dt STRING, hh STRING) STORED AS PAIMON");
        this.AnalyzesOk("CREATE TABLE foo (user_id BIGINT, item_id BIGINT, behavior STRING) STORED AS PAIMON TBLPROPERTIES ('bucket' = '4', 'bucket-key'='behavior')");
        this.AnalyzesOk("CREATE TABLE foo (user_id BIGINT, item_id BIGINT, behavior STRING, PRIMARY KEY(user_id)) PARTITIONED BY (dt STRING, hh STRING) STORED AS PAIMON LOCATION 'hdfs:///test-warehouse/test_create_managed_location_paimon_table'");
        this.AnalyzesOk("CREATE TABLE foo (`USER_ID` BIGINT, `ITEM_ID` BIGINT, BEHAVIOR STRING, PRIMARY KEY(`USER_ID`)) PARTITIONED BY (`DT` STRING, `HH` STRING) STORED AS PAIMON");
        this.AnalyzesOk("CREATE EXTERNAL TABLE foo STORED AS PAIMON LOCATION 'hdfs:///test-warehouse/paimon_test/paimon_catalog/warehouse/functional.db/paimon_non_partitioned'");
        this.AnalyzesOk("CREATE EXTERNAL TABLE foo STORED AS PAIMON LOCATION 'hdfs:///test-warehouse/paimon_test/paimon_catalog/warehouse/functional.db/paimon_partitioned'");
        this.AnalyzesOk("CREATE EXTERNAL TABLE foo STORED AS PAIMON TBLPROPERTIES('paimon.catalog'='hadoop', 'paimon.catalog_location'='hdfs:///test-warehouse/paimon_test/paimon_catalog/warehouse', 'paimon.table_identifier'='functional.paimon_non_partitioned')");
        this.AnalyzesOk("CREATE EXTERNAL TABLE foo STORED AS PAIMON TBLPROPERTIES('paimon.catalog'='hadoop', 'paimon.catalog_location'='hdfs:///test-warehouse/paimon_test/paimon_catalog/warehouse', 'paimon.table_identifier'='functional.paimon_partitioned')");
        this.AnalyzesOk("CREATE TABLE foo (col_boolean BOOLEAN, col_tinyint TINYINT, col_smallint SMALLINT, col_int INT, col_integer INTEGER, col_bigint BIGINT, col_float FLOAT, col_double DOUBLE, col_decimal DECIMAL(10,2), col_string STRING, col_char CHAR(20), col_varchar VARCHAR(100), col_timestamp TIMESTAMP, col_date DATE, col_binary BINARY) STORED AS PAIMON");
        this.AnalysisError("CREATE TABLE impala_paimon_complex_types_array (col_array_string ARRAY<STRING>) STORED AS PAIMON;", "Tables stored by Paimon do not support the column col_array_string type: ARRAY<STRING>");
        this.AnalysisError("CREATE TABLE impala_paimon_complex_types_map (col_map_string MAP<STRING,STRING>) STORED AS PAIMON;", "Tables stored by Paimon do not support the column col_map_string type: MAP<STRING,STRING>");
        this.AnalysisError("CREATE TABLE impala_paimon_complex_types_struct (col_struct_string STRUCT<f1:STRING, f2:STRING>) STORED AS PAIMON;", "Tables stored by Paimon do not support the column col_struct_string type: STRUCT<f1:STRING,f2:STRING>");
        String DATA_SOURCE_NAME = "TestDataSource1";
        catalog_.addDataSource(new DataSource("TestDataSource1", "/foo.jar", "foo.Bar", "V1"));
        this.AnalyzesOk("CREATE TABLE DataSrcTable1 (x int) PRODUCED BY DATA SOURCE TestDataSource1");
        this.AnalyzesOk("CREATE TABLE DataSrcTable1 (x int) PRODUCED BY DATA SOURCE " + "TestDataSource1".toLowerCase());
        this.AnalyzesOk("CREATE TABLE DataSrcTable1 (x int) PRODUCED BY DATA SOURCE TestDataSource1(\"\")");
        this.AnalyzesOk("CREATE TABLE DataSrcTable1 (a tinyint, b smallint, c int, d bigint, e float, f double, g boolean, h string) PRODUCED BY DATA SOURCE TestDataSource1");
        this.AnalysisError("CREATE TABLE DataSrcTable1 (x int) PRODUCED BY DATA SOURCE not_a_data_src(\"\")", "Data source does not exist");
        for (Type t : Type.getSupportedTypes()) {
            PrimitiveType type = t.getPrimitiveType();
            if (DataSourceTable.isSupportedPrimitiveType((PrimitiveType)type) || t.isNull()) continue;
            String typeSpec = type.name();
            if (type == PrimitiveType.CHAR || type == PrimitiveType.DECIMAL || type == PrimitiveType.VARCHAR) {
                typeSpec = typeSpec + "(10)";
            }
            this.AnalysisError("CREATE TABLE DataSrcTable1 (x " + typeSpec + ") PRODUCED BY DATA SOURCE " + "TestDataSource1", "Tables produced by an external data source do not support the column type: " + type.name());
        }
        this.AnalyzesOk("create table functional.new_table (i int, j int) sort by (i)");
        this.AnalyzesOk("create table functional.new_table (i int, j int) sort by (i, j)");
        this.AnalyzesOk("create table functional.new_table (i int, j int) sort by (j, i)");
        this.AnalysisError("create table functional.new_table (i int, j int) sort by zorder (i)", "SORT BY ZORDER with 1 column is equivalent to SORT BY. Please, use the latter, if that was your intention.");
        this.AnalyzesOk("create table functional.new_table (i int, j int) sort by zorder (i, j)");
        this.AnalyzesOk("create table functional.new_table (i int, j int) sort by zorder (j, i)");
        this.AnalysisError("create table Foo (i int) sort by (i) tblproperties ('sort.columns'='i')", "Table definition must not contain the sort.columns table property. Use SORT BY (...) instead.");
        this.AnalysisError("create table Foo (i int, j int) sort by zorder (i, j) tblproperties ('sort.order'='ZORDER')", "Table definition must not contain the sort.order table property. Use SORT BY ZORDER (...) instead.");
        this.AnalysisError("create table functional.new_table (i int) sort by (j)", "Could not find SORT BY column 'j' in table.");
        this.AnalysisError("create table functional.new_table (i int) sort by zorder (j)", "Could not find SORT BY column 'j' in table.");
        this.AnalyzesOk("create table functional.new_table (i int) PARTITIONED BY (d decimal)SORT BY (i)");
        this.AnalyzesOk("create table functional.new_table (i int, j int) PARTITIONED BY (d decimal) sort by zorder (i, j)");
        this.AnalysisError("create table functional.new_table (i int) PARTITIONED BY (d decimal)SORT BY (d)", "SORT BY column list must not contain partition column: 'd'");
        this.AnalysisError("create table functional.new_table (i int) PARTITIONED BY (d decimal)sort by zorder (i, d)", "SORT BY column list must not contain partition column: 'd'");
    }

    @Test
    public void TestCreateBucketedTable() throws AnalysisException {
        this.AnalyzesOk("CREATE TABLE functional.bucket (i int COMMENT 'hello', s string) CLUSTERED BY(i) INTO 24 BUCKETS");
        this.AnalyzesOk("CREATE TABLE functional.bucket (i int COMMENT 'hello', s string) CLUSTERED BY(i) SORT BY (s) INTO 24 BUCKETS");
        this.AnalysisError("CREATE TABLE functional.bucket (i int COMMENT 'hello', s string) CLUSTERED BY (i) INTO 24 BUCKETS STORED BY KUDU", "CLUSTERED BY not support fileformat: 'KUDU'");
        this.AnalysisError("CREATE TABLE functional.bucket (i int COMMENT 'hello', s string) CLUSTERED BY (i) INTO 24 BUCKETS STORED BY ICEBERG", "CLUSTERED BY not support fileformat: 'ICEBERG'");
        this.AnalysisError("CREATE TABLE functional.bucket (i int COMMENT 'hello', s string) CLUSTERED BY (i) INTO 24 BUCKETS STORED BY JDBC", "CLUSTERED BY not support fileformat: 'JDBC'");
        this.AnalysisError("CREATE TABLE functional.bucket (i int COMMENT 'hello', s string) CLUSTERED BY (i) INTO 24 BUCKETS STORED BY PAIMON", "CLUSTERED BY clause is not support by PAIMON now, use property bucket-key instead.");
        this.AnalysisError("CREATE TABLE functional.bucket (i int COMMENT 'hello', s string) PARTITIONED BY(dt string) CLUSTERED BY (dt) INTO 24 BUCKETS", "CLUSTERED BY column list must not contain partition column: 'dt'");
        this.AnalysisError("CREATE TABLE functional.bucket (i int COMMENT 'hello', s string) CLUSTERED BY (i, i) INTO 24 BUCKETS", "Duplicate column in CLUSTERED BY list: i");
        this.AnalysisError("CREATE TABLE functional.bucket (i int COMMENT 'hello', s string) CLUSTERED BY (a) INTO 24 BUCKETS", "Could not find CLUSTERED BY column 'a' in table.");
        this.AnalysisError("CREATE TABLE functional.bucket (i int COMMENT 'hello', s string) CLUSTERED BY (i) INTO 0 BUCKETS", "Bucket's number must be greater than 0.");
        this.AnalysisError("CREATE TABLE functional.bucket (i int COMMENT 'hello', s string) CLUSTERED BY () INTO 12 BUCKETS", "Bucket columns must be not null.");
    }

    @Test
    public void TestCreateAvroTest() {
        String alltypesSchemaLoc = "hdfs:///test-warehouse/avro_schemas/functional/alltypes.json";
        this.AnalyzesOk(String.format("create table foo_avro (id int, bool_col boolean, tinyint_col int, smallint_col int, int_col int, bigint_col bigint, float_col float,double_col double, date_string_col string, string_col string, timestamp_col timestamp) with serdeproperties ('avro.schema.url'='%s')stored as avro", alltypesSchemaLoc));
        this.AnalyzesOk(String.format("create table foo_avro (id int, bool_col boolean, tinyint_col int, smallint_col int, int_col int, bigint_col bigint, float_col float,double_col double, date_string_col string, string_col string, timestamp_col timestamp) stored as avro tblproperties ('avro.schema.url'='%s')", alltypesSchemaLoc));
        this.AnalyzesOk("create table foo_avro (string1 string) stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\": \"string1\", \"type\": \"string\"}]}')");
        this.AnalyzesOk(String.format("create table foo_avro with serdeproperties ('avro.schema.url'='%s')stored as avro", alltypesSchemaLoc));
        this.AnalyzesOk(String.format("create table foo_avro stored as avro tblproperties ('avro.schema.url'='%s')", alltypesSchemaLoc));
        this.AnalyzesOk("create table foo_avro stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\": \"string1\", \"type\": \"string\"}]}')");
        this.AnalyzesOk(String.format("create table foo_avro (id int) with serdeproperties ('avro.schema.url'='%s')stored as avro", alltypesSchemaLoc), "Ignoring column definitions in favor of Avro schema.\nThe Avro schema has 11 column(s) but 1 column definition(s) were given.");
        this.AnalyzesOk(String.format("create table foo_avro (bool_col boolean, string_col string) stored as avro tblproperties ('avro.schema.url'='%s')", alltypesSchemaLoc), "Ignoring column definitions in favor of Avro schema.\nThe Avro schema has 11 column(s) but 2 column definition(s) were given.");
        this.AnalyzesOk("create table foo_avro (string1 string) stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\": \"string1\", \"type\": \"string\"},{\"name\": \"string2\", \"type\": \"string\"}]}')", "Ignoring column definitions in favor of Avro schema.\nThe Avro schema has 2 column(s) but 1 column definition(s) were given.");
        this.AnalyzesOk(String.format("create table foo_avro (id int, bool_col boolean, tinyint_col int, smallint_col int, bad_int_col int, bigint_col bigint, float_col float,double_col double, date_string_col string, string_col string, timestamp_col timestamp) with serdeproperties ('avro.schema.url'='%s')stored as avro", alltypesSchemaLoc), "Resolved the following name and/or type inconsistencies between the column definitions and the Avro schema.\nColumn definition at position 4:  bad_int_col INT\nAvro schema column at position 4: int_col INT\nResolution at position 4: int_col INT\nColumn definition at position 10:  timestamp_col TIMESTAMP\nAvro schema column at position 10: timestamp_col STRING\nResolution at position 10: timestamp_col STRING");
        this.AnalyzesOk(String.format("create table foo_avro (id int, bool_col boolean, tinyint_col int, smallint_col int, int_col int, bigint_col bigint, float_col float,double_col bigint, date_string_col string, string_col string, timestamp_col timestamp) stored as avro tblproperties ('avro.schema.url'='%s')", alltypesSchemaLoc), "Resolved the following name and/or type inconsistencies between the column definitions and the Avro schema.\nColumn definition at position 7:  double_col BIGINT\nAvro schema column at position 7: double_col DOUBLE\nResolution at position 7: double_col DOUBLE\nColumn definition at position 10:  timestamp_col TIMESTAMP\nAvro schema column at position 10: timestamp_col STRING\nResolution at position 10: timestamp_col STRING");
        this.AnalyzesOk("create table foo_avro (c1 tinyint, c2 smallint, c3 int, c4 bigint, c5 float, c6 double, c7 timestamp, c8 string, c9 char(10), c10 varchar(20),c11 decimal(10, 5), c12 struct<f1:int,f2:string>, c13 array<int>,c14 map<string,string>) stored as avro");
        this.AnalyzesOk("create table foo_avro (c1 tinyint, c2 smallint, c3 int, c4 bigint, c5 float, c6 double, c7 timestamp, c8 string, c9 char(10), c10 varchar(20),c11 decimal(10, 5), c12 struct<f1:int,f2:string>, c13 array<int>,c14 map<string,string>) partitioned by (year int, month int) stored as avro");
        this.AnalysisError("create table foo_avro stored as avro tblproperties ('a'='b')", "An Avro table requires column definitions or an Avro schema.");
        this.AnalysisError("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.url'='')", "Invalid avro.schema.url: . Can not create a Path from an empty string");
        this.AnalysisError("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.url'='schema.avsc')", "Invalid avro.schema.url: schema.avsc. Path does not exist.");
        this.AnalysisError("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.url'='hdfs://invalid*host/schema.avsc')", "Failed to read Avro schema at: hdfs://invalid*host/schema.avsc. Incomplete HDFS URI, no host: hdfs://invalid*host/schema.avsc");
        this.AnalysisError("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.url'='foo://bar/schema.avsc')", "Failed to read Avro schema at: foo://bar/schema.avsc. No FileSystem for scheme: foo");
        this.AnalyzesOk("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\":\"value\",\"type\":{\"type\":\"bytes\", \"logicalType\":\"decimal\",\"precision\":5,\"scale\":2}}]}')");
        this.AnalyzesOk("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\":\"value\",\"type\":{\"type\":\"bytes\", \"logicalType\":\"decimal\",\"precision\":5}}]}')");
        this.AnalysisError("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\":\"value\",\"type\":{\"type\":\"bytes\", \"logicalType\":\"decimal\",\"scale\":5}}]}')", "Error parsing Avro schema for table 'default.foo_avro': No 'precision' property specified for 'decimal' logicalType");
        this.AnalysisError("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\":\"value\",\"type\":{\"type\":\"bytes\", \"logicalType\":\"decimal\",\"scale\":5, \"precision\":-20}}]}')", "Error parsing Avro schema for table 'default.foo_avro': Invalid decimal 'precision' property value: -20");
        this.AnalysisError("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\":\"value\",\"type\":{\"type\":\"bytes\", \"logicalType\":\"decimal\",\"scale\":-1, \"precision\":20}}]}')", "Error parsing Avro schema for table 'default.foo_avro': Invalid decimal 'scale' property value: -1");
        this.AnalysisError("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": {\"name\": \"string1\", \"type\": \"string\"}]}')", "Error parsing Avro schema for table 'default.foo_avro': com.fasterxml.jackson.core.JsonParseException: Unexpected close marker ']': expected '}'");
        this.AnalyzesOk("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\": \"string1\", \"type\": \"string\"},{\"name\": \"list1\", \"type\": {\"type\":\"array\", \"items\": \"int\"}}]}')");
        this.AnalyzesOk("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\": \"string1\", \"type\": \"string\"},{\"name\": \"map1\", \"type\": {\"type\":\"map\", \"values\": \"int\"}}]}')");
        this.AnalysisError("create table foo_avro (i int) stored as avro tblproperties ('avro.schema.literal'='{\"name\": \"my_record\", \"type\": \"record\", \"fields\": [{\"name\": \"string1\", \"type\": \"string\"},{\"name\": \"union1\", \"type\": [\"float\", \"boolean\"]}]}')", "Unsupported type 'union' of column 'union1'");
        this.AnalyzesOk("create table functional.new_table (a struct<f1: int, f2: string, f3: timestamp, f4: boolean>, b struct<f1: struct<f11: int>, f2: struct<f21: struct<f22: string>>>, c struct<f1: map<int, string>, f2: array<bigint>>,d struct<f1: struct<f11: map<int, string>, f12: array<bigint>>>)");
        this.AnalyzesOk("create table functional.new_table (a array<int>, b array<timestamp>, c array<string>, d array<boolean>, e array<array<int>>, f array<array<array<string>>>, g array<struct<f1: int, f2: string>>, h array<map<string,int>>)");
        this.AnalyzesOk("create table functional.new_table (a map<string, int>, b map<timestamp, boolean>, c map<bigint, float>, d array<array<int>>, e array<array<array<string>>>, f array<struct<f1: int, f2: string>>,g array<map<string,int>>)");
        this.AnalysisError("create table functional.new_table (i int) partitioned by (x array<int>)", "Type 'ARRAY<INT>' is not supported as partition-column type in column: x");
        this.AnalysisError("create table functional.new_table (i int) partitioned by (x map<int,int>)", "Type 'MAP<INT,INT>' is not supported as partition-column type in column: x");
        this.AnalysisError("create table functional.new_table (i int) partitioned by (x struct<f1:int>)", "Type 'STRUCT<f1:INT>' is not supported as partition-column type in column: x");
        this.AnalysisError("create table functional.new_table (i int) partition by hash(i) partitions 3 stored as avro", "Only Kudu tables can use the PARTITION BY clause.");
        this.AnalysisError("create table functional.new_table (i int primary key) stored as avro", "Unsupported column options for file format 'AVRO': 'i INT PRIMARY KEY'");
    }

    @Test
    public void TestCreateView() throws AnalysisException {
        this.AnalyzesOk("create view foo_new as select int_col, string_col from functional.alltypes");
        this.AnalyzesOk("create view functional.foo as select * from functional.alltypes");
        this.AnalyzesOk("create view if not exists foo as select * from functional.alltypes");
        this.AnalyzesOk("create view foo (a, b) as select int_col, string_col from functional.alltypes");
        this.AnalyzesOk("create view functional.foo (a, b) as select int_col x, double_col y from functional.alltypes");
        this.AnalyzesOk("create view foo as select * from functional.alltypes_view");
        this.AnalyzesOk("create view foo (aaa, bbb) as select * from functional.complex_view");
        this.AnalyzesOk("create view foo as select trim('abc'), 17 * 7");
        this.AnalyzesOk("create view foo as select * from functional_hbase.alltypesagg");
        this.AnalyzesOk("create view foo (cnt) as select count(distinct x.int_col) from functional.alltypessmall x inner join functional.alltypessmall y on (x.id = y.id) group by x.bigint_col");
        this.AnalyzesOk("create view foo (a, b) as values(1, 'a'), (2, 'b')");
        this.AnalyzesOk("create view foo (a, b) as select 1, 'a' union all select 2, 'b'");
        this.AnalyzesOk("create view test_view_with_subquery as select * from functional.alltypestiny t where exists (select * from functional.alltypessmall s where s.id = t.id)");
        this.AnalysisError("create view foo (a) as select int_col, string_col from functional.alltypes", "Column-definition list has fewer columns (1) than the view-definition query statement returns (2).");
        this.AnalysisError("create view foo (a, b, c) as select int_col from functional.alltypes", "Column-definition list has more columns (3) than the view-definition query statement returns (1).");
        this.AnalysisError("create view foo as select * from functional.alltypessmall a inner join functional.alltypessmall b on a.id = b.id", "Duplicate column name: id");
        this.AnalysisError("create view foo (a, b, a) as select int_col, int_col, int_col from functional.alltypes", "Duplicate column name: a");
        this.AnalysisError("create view `???`.new_view as select 1, 2, 3", "Invalid database name: ???");
        this.AnalysisError("create view `^%&` as select 1, 2, 3", "Invalid table/view name: ^%&");
        this.AnalyzesOk("create view foo as select 1 as `???`");
        this.AnalyzesOk("create view foo(`%^&`) as select 1");
        this.AnalysisError("create view functional.alltypes as select * from functional.alltypessmall ", "View already exists: functional.alltypes");
        this.AnalysisError("create view wrongdb.test as select * from functional.alltypessmall ", "Database does not exist: wrongdb");
        this.AnalysisError("create view foo as select * from wrongdb.alltypessmall ", "Could not resolve table reference: 'wrongdb.alltypessmall'");
        this.AnalysisError("create view foo as select * from wrongdb.alltypessmall ", "Could not resolve table reference: 'wrongdb.alltypessmall'");
        this.AnalysisError("create view foo as select int_col from functional.alltypessmall union all select string_col from functional.alltypes", "Incompatible return types 'INT' and 'STRING' of exprs 'int_col' and 'string_col'.");
        this.AnalyzesOk("create view functional.foo (a) as select int_array_col from functional.allcomplextypes");
        this.AnalyzesOk("create view functional.foo (a) as select int_map_col from functional.allcomplextypes");
        AnalysisContext ctx = this.createAnalysisCtx();
        this.AnalyzesOk("create view functional.foo (a) as select tiny_struct from functional_orc_def.complextypes_structs", ctx);
        this.AnalyzesOk("create view v as select cast(null as int) as new_col");
        this.AnalyzesOk("create view v as select cast(null as int) as null_col, 1 as one_col");
        this.AnalysisError("create view v as select null as new_col", "Unable to infer the column type for column 'new_col'. Use cast() to explicitly specify the column type for column 'new_col'.");
        this.AnalyzesOk("create view v_tblproperties TBLPROPERTIES ('a' = 'a')as select cast(null as int) as new_col");
        this.AnalyzesOk("create view v_tblproperties TBLPROPERTIES ('a' = 'a', 'b' = 'b')as select cast(null as int) as new_col");
        this.AnalysisError("create view functional.view_view TBLPROPERTIES ('a' = 'a')as select cast(null as int) as new_col", "View already exists: functional.view_view");
    }

    @Test
    public void TestUdf() throws AnalysisException {
        String symbol = "'_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'";
        String udfSuffix = " LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'";
        String udfSuffixIr = " LOCATION '/test-warehouse/test-udfs.ll' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'";
        String hdfsPath = "hdfs://localhost:20500/test-warehouse/libTestUdfs.so";
        String javaFnSuffix = " LOCATION '/test-warehouse/impala-hive-udfs.jar' SYMBOL='org.apache.impala.TestUdf'";
        this.AnalyzesOk("create function foo() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function foo(int, int, string) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function foo LOCATION '/test-warehouse/impala-hive-udfs.jar' SYMBOL='org.apache.impala.TestUdf'");
        this.AnalyzesOk("create function foo(INT) returns INT LOCATION '/test-warehouse/impala-hive-udfs.jar' SYMBOL='org.apache.impala.TestUdf'");
        this.AnalyzesOk("create function functional.B() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function functional.B1() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function functional.`B1C`() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function A_B() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function foo() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalysisError("create function foo() RETURNS int LOCATION '/test-warehouse/libTestUdfs.ll' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Could not load binary: /test-warehouse/libTestUdfs.ll");
        this.AnalyzesOk("create function foo() RETURNS int LOCATION '/test-warehouse/test-udfs.ll' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function foo(int) RETURNS int LOCATION '/test-warehouse/test-udfs.ll' SYMBOL='Identity'");
        this.AnalyzesOk("create function foo() RETURNS int LOCATION '/test-warehouse/libTestUdfs.SO' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function foo() RETURNS int LOCATION '/test-warehouse/hive-exec.jar' SYMBOL='a'");
        this.AnalysisError("create function foo() RETURNS timestamp LOCATION '/test-warehouse/hive-exec.jar' SYMBOL='a'", "Type TIMESTAMP is not supported for Java UDFs.");
        this.AnalysisError("create function foo(timestamp) RETURNS int LOCATION '/a.jar'", "Type TIMESTAMP is not supported for Java UDFs.");
        this.AnalysisError("create function foo() RETURNS date LOCATION '/test-warehouse/hive-exec.jar' SYMBOL='a'", "Type DATE is not supported for Java UDFs.");
        this.AnalysisError("create function foo(date) RETURNS int LOCATION '/a.jar'", "Type DATE is not supported for Java UDFs.");
        this.AnalysisError("create function foo() RETURNS decimal LOCATION '/a.jar'", "Type DECIMAL(9,0) is not supported for Java UDFs.");
        this.AnalysisError("create function foo(Decimal) RETURNS int LOCATION '/a.jar'", "Type DECIMAL(9,0) is not supported for Java UDFs.");
        this.AnalysisError("create function foo(char(5)) RETURNS int LOCATION '/a.jar'", "Type CHAR(5) is not supported for Java UDFs.");
        this.AnalysisError("create function foo(varchar(5)) RETURNS int LOCATION '/a.jar'", "Type VARCHAR(5) is not supported for Java UDFs.");
        this.AnalysisError("create function foo() RETURNS CHAR(5) LOCATION '/a.jar'", "Type CHAR(5) is not supported for Java UDFs.");
        this.AnalysisError("create function foo() RETURNS VARCHAR(5) LOCATION '/a.jar'", "Type VARCHAR(5) is not supported for Java UDFs.");
        this.AnalysisError("create function foo() RETURNS CHAR(5) LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "UDFs that use CHAR are not yet supported.");
        this.AnalysisError("create function foo() RETURNS VARCHAR(5) LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "UDFs that use VARCHAR are not yet supported.");
        this.AnalysisError("create function foo(CHAR(5)) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "UDFs that use CHAR are not yet supported.");
        this.AnalysisError("create function foo(VARCHAR(5)) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "UDFs that use VARCHAR are not yet supported.");
        this.AnalyzesOk("create function foo() RETURNS decimal LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function foo() RETURNS decimal(38,10) LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function foo(Decimal, decimal(10, 2)) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalysisError("create function foo() RETURNS decimal(100) LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Decimal precision must be <= 38: 100");
        this.AnalysisError("create function foo(Decimal(2, 3)) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Decimal scale (3) must be <= precision (2)");
        this.AnalyzesOk("create function foo(INT...) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function foo() returns int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE' prepare_fn='ValidateOpenPrepare' close_fn='ValidateOpenClose'");
        this.AnalyzesOk("create function foo() returns int LOCATION '/test-warehouse/test-udfs.ll' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE' prepare_fn='ValidateOpenPrepare' close_fn='ValidateOpenClose'");
        this.AnalyzesOk("create function foo() returns int LOCATION '/test-warehouse/test-udfs.ll' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE' prepare_fn='_Z19ValidateOpenPreparePN10impala_udf15FunctionContextENS0_18FunctionStateScopeE' close_fn='_Z17ValidateOpenClosePN10impala_udf15FunctionContextENS0_18FunctionStateScopeE'");
        this.AnalysisError("create function foo() returns int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE' prepare_fn=''", "Could not find symbol ''");
        this.AnalysisError("create function foo() returns int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE' close_fn=''", "Could not find symbol ''");
        this.AnalysisError("create function foo() returns int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE' prepare_fn='FakePrepare'", "Could not find function FakePrepare(impala_udf::FunctionContext*, impala_udf::FunctionContext::FunctionStateScope) in: ");
        this.AnalyzesOk("create function sin(double) RETURNS double LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function sin() RETURNS double LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalysisError("create function _impala_builtins.sin(double) returns double LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Cannot modify system database.");
        this.AnalysisError("create function sin(double) returns double LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", this.createAnalysisCtx("_impala_builtins"), "Cannot modify system database.");
        this.AnalysisError("create function _impala_builtins.f(double) returns double LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Cannot modify system database.");
        this.addTestFunction("sin", Lists.newArrayList((Object[])new ScalarType[]{Type.DOUBLE}), false);
        this.AnalyzesOk("drop function sin(double)");
        this.AnalysisError("drop function cos(double)", "Function does not exist: cos(DOUBLE)");
        this.AnalysisError("drop function _impala_builtins.sin(double)", "Cannot modify system database.");
        this.AnalyzesOk("select sin(1)");
        this.AnalyzesOk("select _impala_builtins.sin(1)");
        this.AnalyzesOk("select default.sin(1)");
        this.AnalysisError("select functional.sin(1)", "functional.sin() unknown");
        this.AnalysisError("create function foo() RETURNS int LOCATION 'bad-location' SYMBOL='c'", "URI path must be absolute: bad-location");
        this.AnalysisError("create function foo LOCATION 'bad-location' SYMBOL='c'", "URI path must be absolute: bad-location");
        this.AnalysisError("create function foo() RETURNS int LOCATION 'blah://localhost:50200/bad-location' SYMBOL='c'", "No FileSystem for scheme: blah");
        this.AnalysisError("create function foo LOCATION 'blah://localhost:50200/bad-location' SYMBOL='c'", "No FileSystem for scheme: blah");
        this.AnalysisError("create function foo() RETURNS int LOCATION 'file:///foo.jar' SYMBOL='c'", "Could not load binary: file:///foo.jar");
        this.AnalysisError("create function foo LOCATION 'file:///foo.jar' SYMBOL='c'", "Could not load binary: file:///foo.jar");
        this.AnalysisError("create function foo() RETURNS int LOCATION '/binary' SYMBOL='a'", "Unknown binary type: '/binary'. Binary must end in .jar, .so or .ll");
        this.AnalysisError("create function foo() RETURNS int LOCATION '/binary.a' SYMBOL='a'", "Unknown binary type: '/binary.a'. Binary must end in .jar, .so or .ll");
        this.AnalysisError("create function foo() RETURNS int LOCATION '/binary.so.' SYMBOL='a'", "Unknown binary type: '/binary.so.'. Binary must end in .jar, .so or .ll");
        this.AnalysisError("create function foo() RETURNS int LOCATION '/binary.so'", "Argument 'SYMBOL' must be set.");
        this.AnalysisError("create function foo() RETURNS int LOCATION '/blah.so' SYMBOL='ab'", "Could not load binary: /blah.so");
        this.AnalysisError("create function foo() RETURNS int LOCATION '/binary.JAR' SYMBOL='a'", "Could not load binary: /binary.JAR");
        this.AnalysisError("create function foo LOCATION '/binary.JAR' SYMBOL='a'", "Could not load binary: /binary.JAR");
        this.AnalysisError("create function foo() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='b'", "Could not find function b() in: hdfs://localhost:20500/test-warehouse/libTestUdfs.so");
        this.AnalysisError("create function foo() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL=''", "Could not find symbol ''");
        this.AnalysisError("create function foo() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_ZAB'", "Could not find symbol '_ZAB' in: hdfs://localhost:20500/test-warehouse/libTestUdfs.so");
        this.AnalyzesOk("create function foo() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='NoArgs'");
        this.AnalyzesOk("create function foo() RETURNS double LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='NoArgs'");
        this.AnalysisError("create function foo() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='noArgs'", "Could not find function noArgs() in: hdfs://localhost:20500/test-warehouse/libTestUdfs.so");
        this.AnalysisError("create function foo(int) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='NoArgs'", "Could not find function NoArgs(INT) in: hdfs://localhost:20500/test-warehouse/libTestUdfs.so");
        this.AnalyzesOk("create function identity(boolean) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='Identity'");
        this.AnalyzesOk("create function identity(tinyint) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='Identity'");
        this.AnalyzesOk("create function identity(smallint) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='Identity'");
        this.AnalyzesOk("create function identity(int) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='Identity'");
        this.AnalyzesOk("create function identity(bigint) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='Identity'");
        this.AnalyzesOk("create function identity(float) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='Identity'");
        this.AnalyzesOk("create function identity(double) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='Identity'");
        this.AnalyzesOk("create function identity(string) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='Identity'");
        this.AnalyzesOk("create function all_types_fn(string, boolean, tinyint, smallint, int, bigint, float, double, decimal, date, binary) returns int location '/test-warehouse/libTestUdfs.so' symbol='AllTypes'");
        this.AnalysisError("create function 123A() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Function cannot start with a digit: 123a");
        this.AnalysisError("create function A.`1A`() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Function cannot start with a digit: 1a");
        this.AnalysisError("create function A.`ABC-D`() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Function names must be all alphanumeric or underscore. Invalid name: abc-d");
        this.AnalysisError("create function baddb.f() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Database does not exist: baddb");
        this.AnalysisError("create function a.b.c() RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Invalid function name: 'a.b.c'. Expected [dbname].funcname.");
        this.AnalysisError("create function a.b.c.d(smallint) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Invalid function name: 'a.b.c.d'. Expected [dbname].funcname.");
        this.AnalysisError("create function f() RETURNS array<int> LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Type 'ARRAY<INT>' is not supported in UDFs/UDAs.");
        this.AnalysisError("create function f(map<string,int>) RETURNS int LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Type 'MAP<STRING,INT>' is not supported in UDFs/UDAs.");
        this.AnalysisError("create function f() RETURNS struct<f:int> LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Type 'STRUCT<f:INT>' is not supported in UDFs/UDAs.");
        this.AnalyzesOk("drop function if exists foo()");
        this.AnalysisError("drop function foo()", "Function does not exist: foo()");
        this.AnalyzesOk("drop function if exists a.foo()");
        this.AnalysisError("drop function a.foo()", "Database does not exist: a");
        this.AnalyzesOk("drop function if exists foo()");
        this.AnalyzesOk("drop function if exists foo");
        this.AnalyzesOk("drop function if exists foo(int...)");
        this.AnalyzesOk("drop function if exists foo(double, int...)");
        this.addTestFunction("TestFn", new ArrayList<ScalarType>(), false);
        this.addTestFunction("TestFn", Lists.newArrayList((Object[])new ScalarType[]{Type.DOUBLE}), false);
        this.addTestFunction("TestFn", Lists.newArrayList((Object[])new ScalarType[]{Type.STRING}), true);
        this.AnalysisError("create function TestFn() RETURNS INT  LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Function already exists: testfn()");
        this.AnalysisError("create function TestFn(double) RETURNS INT  LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Function already exists: testfn(DOUBLE)");
        this.AnalysisError("create function TestFn LOCATION '/test-warehouse/impala-hive-udfs.jar' SYMBOL='org.apache.impala.TestUdf'", "Function already exists: testfn()");
        this.AnalyzesOk("create function if not exists TestFn LOCATION '/test-warehouse/impala-hive-udfs.jar' SYMBOL='org.apache.impala.TestUdf'");
        this.AnalysisError("create function TestFn(double...) RETURNS INT LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Function already exists: testfn(DOUBLE)");
        this.AnalysisError("create function TestFn(double) RETURNS INT LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Function already exists: testfn(DOUBLE)");
        this.addTestFunction("TestFn", Lists.newArrayList((Object[])new ScalarType[]{Type.INT, Type.INT}), false);
        this.AnalyzesOk("drop function TestFn(int, int)");
        this.AnalysisError("drop function TestFn(int, int, int)", "Function does not exist: testfn(INT, INT, INT)");
        this.AnalysisError("create function TestFn(String) RETURNS INT LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Function already exists: testfn(STRING...)");
        this.AnalysisError("create function TestFn(String...) RETURNS INT LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Function already exists: testfn(STRING...)");
        this.AnalysisError("create function TestFn(String, String) RETURNS INT LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'", "Function already exists: testfn(STRING...)");
        this.AnalyzesOk("create function TestFn(String, String, Int) RETURNS INT LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function TestFn(int) RETURNS INT  LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("create function functional.TestFn() RETURNS INT  LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'");
        this.AnalyzesOk("drop function TestFn()");
        this.AnalyzesOk("drop function TestFn(double)");
        this.AnalyzesOk("drop function TestFn(string...)");
        this.AnalyzesOk("drop function if exists functional.TestFn");
        this.AnalysisError("drop function TestFn(double...)", "Function does not exist: testfn(DOUBLE...)");
        this.AnalysisError("drop function TestFn(int)", "Function does not exist: testfn(INT)");
        this.AnalysisError("drop function functional.TestFn()", "Function does not exist: testfn()");
        this.AnalysisError("drop function functional.TestFn", "Function does not exist: testfn");
        this.AnalysisError("create function f() returns int  LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'init_fn='a'", "Optional argument 'INIT_FN' should not be set");
        this.AnalysisError("create function f() returns int  LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'serialize_fn='a'", "Optional argument 'SERIALIZE_FN' should not be set");
        this.AnalysisError("create function f() returns int  LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'merge_fn='a'", "Optional argument 'MERGE_FN' should not be set");
        this.AnalysisError("create function f() returns int  LOCATION '/test-warehouse/libTestUdfs.so' SYMBOL='_Z8IdentityPN10impala_udf15FunctionContextERKNS_10BooleanValE'finalize_fn='a'", "Optional argument 'FINALIZE_FN' should not be set");
    }

    @Test
    public void TestUda() throws AnalysisException {
        String loc = " LOCATION '/test-warehouse/libTestUdas.so' ";
        String hdfsLoc = "hdfs://localhost:20500/test-warehouse/libTestUdas.so";
        this.AnalyzesOk("create aggregate function foo(int) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate'");
        this.AnalyzesOk("create aggregate function foo(int) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate' INIT_FN='AggInit'");
        this.AnalyzesOk("create aggregate function foo(int) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate' INIT_FN='AggInit' MERGE_FN='AggMerge'");
        this.AnalysisError("create aggregate function foo(int) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate' INIT_FN='AGgInit'", "Could not find function AGgInit() returns INT in: hdfs://localhost:20500/test-warehouse/libTestUdas.so");
        this.AnalyzesOk("create aggregate function foo(int, int) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate'");
        this.AnalyzesOk("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate'");
        this.AnalysisError("create aggregate function foo(int...) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' ", "UDAs with varargs are not yet supported.");
        this.AnalysisError("create aggregate function foo(int, int, int, int, int, int, int , int, int) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' ", "UDAs with more than 8 arguments are not yet supported.");
        String symbols = " UPDATE_FN='_Z9AggUpdatePN10impala_udf15FunctionContextERKNS_6IntValEPS2_' INIT_FN='_Z7AggInitPN10impala_udf15FunctionContextEPNS_6IntValE' MERGE_FN='_Z8AggMergePN10impala_udf15FunctionContextERKNS_6IntValEPS2_'";
        this.AnalysisError("create aggregate function foo(CHAR(5)) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' " + symbols, "UDAs with CHAR arguments are not yet supported.");
        this.AnalysisError("create aggregate function foo(VARCHAR(5)) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' " + symbols, "UDAs with VARCHAR arguments are not yet supported.");
        this.AnalysisError("create aggregate function foo(int) RETURNS CHAR(5) LOCATION '/test-warehouse/libTestUdas.so' " + symbols, "UDAs with CHAR return type are not yet supported.");
        this.AnalysisError("create aggregate function foo(int) RETURNS VARCHAR(5) LOCATION '/test-warehouse/libTestUdas.so' " + symbols, "UDAs with VARCHAR return type are not yet supported.");
        this.AnalysisError("create aggregate function foo(int) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='_Z9AggUpdatePN10impala_udf15FunctionContextERKNS_6IntValEPS2_'", "Could not infer symbol for init() function.");
        this.AnalysisError("create aggregate function foo(int) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='_Z9AggUpdatePN10impala_udf15FunctionContextERKNS_6IntValEPS2_' INIT_FN='_Z7AggInitPN10impala_udf15FunctionContextEPNS_6IntValE'", "Could not infer symbol for merge() function.");
        this.AnalyzesOk("create aggregate function foo(int) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='_Z9AggUpdatePN10impala_udf15FunctionContextERKNS_6IntValEPS2_' INIT_FN='_Z7AggInitPN10impala_udf15FunctionContextEPNS_6IntValE' MERGE_FN='_Z8AggMergePN10impala_udf15FunctionContextERKNS_6IntValEPS2_'");
        this.AnalyzesOk("create aggregate function foo(int) RETURNS int INTERMEDIATE int LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate'");
        this.AnalyzesOk("create aggregate function foo(int) RETURNS int INTERMEDIATE CHAR(10) LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggIntermediateUpdate'");
        this.AnalysisError("create aggregate function foo(int) RETURNS int INTERMEDIATE CHAR(10) LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggIntermediate' INIT_FN='AggIntermediateInit' MERGE_FN='AggIntermediateMerge'", "Finalize() is required for this UDA.");
        this.AnalyzesOk("create aggregate function foo(int) RETURNS int INTERMEDIATE CHAR(10) LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggIntermediate' INIT_FN='AggIntermediateInit' MERGE_FN='AggIntermediateMerge' FINALIZE_FN='AggIntermediateFinalize'");
        this.AnalysisError("create aggregate function foo(int) RETURNS int LOCATION '/test-warehouse/libTestUdas.so' SYMBOL='Bad'", "Optional argument 'SYMBOL' should not be set.");
        this.AnalysisError("create aggregate function foo(int) RETURNS int INTERMEDIATE CHAR(0) LOCATION '/foo.so' UPDATE_FN='b'", "Char size must be > 0: 0");
        this.AnalysisError("create aggregate function foo() RETURNS int LOCATION '/test-warehouse/libTestUdas.so' ", "UDAs must take at least one argument.");
        this.AnalysisError("create aggregate function foo(int) RETURNS int LOCATION '/foo.jar' UPDATE_FN='b'", "Java UDAs are not supported.");
        this.AnalysisError("create aggregate function foo(string, double) RETURNS array<int>  LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate'", "Type 'ARRAY<INT>' is not supported in UDFs/UDAs.");
        this.AnalysisError("create aggregate function foo(map<string,int>) RETURNS int  LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate'", "Type 'MAP<STRING,INT>' is not supported in UDFs/UDAs.");
        this.AnalysisError("create aggregate function foo(int) RETURNS struct<f:int>  LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate'", "Type 'STRUCT<f:INT>' is not supported in UDFs/UDAs.");
        this.AnalysisError("create aggregate function foo(int) RETURNS int INTERMEDIATE fixed_uda_intermediate(10)  LOCATION '/test-warehouse/libTestUdas.so'  UPDATE_FN='foo'", "Syntax error in line 1");
        this.AnalysisError("create aggregate function foo(int) RETURNS int LOCATION '/foo.ll' UPDATE_FN='Fn'", "IR UDAs are not yet supported.");
        this.AnalysisError("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='Agg'", "Could not infer symbol for init() function.");
        this.AnalysisError("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='Agg' INIT_FN='AggInit'", "Could not infer symbol for merge() function.");
        this.AnalyzesOk("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='Agg' INIT_FN='AggInit' MERGE_FN='AggMerge'");
        this.AnalyzesOk("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='Agg' INIT_FN='AggInit' MERGE_FN='AggMerge' SERIALIZE_FN='AggSerialize'");
        this.AnalyzesOk("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='Agg' INIT_FN='AggInit' MERGE_FN='AggMerge' SERIALIZE_FN='AggSerialize' FINALIZE_FN='AggFinalize'");
        this.AnalyzesOk("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate' SERIALIZE_FN='AggSerialize' FINALIZE_FN='AggSerialize'");
        this.AnalyzesOk("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate' SERIALIZE_FN='AggFinalize' FINALIZE_FN='AggFinalize'");
        this.AnalysisError("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate' INIT_FN='AggSerialize'", "Could not find function AggSerialize() returns STRING in: hdfs://localhost:20500/test-warehouse/libTestUdas.so");
        this.AnalyzesOk("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate' INIT_FN='_Z12AggSerializePN10impala_udf15FunctionContextERKNS_6IntValE'");
        this.AnalysisError("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='AggUpdate' INIT_FN='_ZAggSerialize'", "Could not find symbol '_ZAggSerialize' in: hdfs://localhost:20500/test-warehouse/libTestUdas.so");
        this.AnalysisError("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='Agg2Update'", "Could not find function Agg2Init() returns STRING in: hdfs://localhost:20500/test-warehouse/libTestUdas.so");
        this.AnalysisError("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='Agg2Update' INIT_FN='AggInit'", "Could not find function Agg2Merge(STRING) returns STRING in: hdfs://localhost:20500/test-warehouse/libTestUdas.so");
        this.AnalyzesOk("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='Agg2Update' INIT_FN='AggInit' MERGE_FN='AggMerge'");
        this.AnalysisError("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='Agg2Update' INIT_FN='AggInit' MERGE_FN='BadFn'", "Could not find function BadFn(STRING) returns STRING in: hdfs://localhost:20500/test-warehouse/libTestUdas.so");
        this.AnalysisError("create aggregate function foo(string, double) RETURNS string LOCATION '/test-warehouse/libTestUdas.so' UPDATE_FN='Agg2Update' INIT_FN='AggInit' MERGE_FN='AggMerge' FINALIZE_FN='not there'", "Could not find function not there(STRING) in: hdfs://localhost:20500/test-warehouse/libTestUdas.so");
    }

    private void TypeDefsAnalyzeOk(String ... typeDefs) {
        for (String typeDefStr : typeDefs) {
            ParseNode stmt = this.AnalyzesOk(String.format("CREATE TABLE t (i %s)", typeDefStr));
            this.AnalyzesOk(String.format("CREATE TABLE t (i ARRAY<%s>)", typeDefStr));
            this.AnalyzesOk(String.format("CREATE TABLE t (i STRUCT<f:%s>)", typeDefStr));
            Preconditions.checkState((boolean)(stmt instanceof CreateTableStmt));
            CreateTableStmt createTableStmt = (CreateTableStmt)stmt;
            Type t = ((ColumnDef)createTableStmt.getColumnDefs().get(0)).getType();
            if (t.isComplexType()) {
                this.AnalyzesOk(String.format("CREATE TABLE t (i MAP<int, %s>)", typeDefStr, typeDefStr));
                continue;
            }
            this.AnalyzesOk(String.format("CREATE TABLE t (i MAP<%s, %s>)", typeDefStr, typeDefStr));
        }
    }

    private Type TypeDefAnalyzeOk(String typeDef) {
        ParseNode stmt = this.AnalyzesOk(String.format("CREATE TABLE t (i %s)", typeDef));
        CreateTableStmt createTableStmt = (CreateTableStmt)stmt;
        return ((ColumnDef)createTableStmt.getColumnDefs().get(0)).getType();
    }

    private void TypeDefAnalysisError(String typeDef, String expectedError) {
        this.AnalysisError(String.format("CREATE TABLE t (i %s)", typeDef), expectedError);
    }

    @Test
    public void TestTypes() {
        this.TypeDefsAnalyzeOk("BOOLEAN");
        this.TypeDefsAnalyzeOk("TINYINT");
        this.TypeDefsAnalyzeOk("SMALLINT");
        this.TypeDefsAnalyzeOk("INT", "INTEGER");
        this.TypeDefsAnalyzeOk("BIGINT");
        this.TypeDefsAnalyzeOk("FLOAT");
        this.TypeDefsAnalyzeOk("DOUBLE", "REAL");
        this.TypeDefsAnalyzeOk("STRING");
        this.TypeDefsAnalyzeOk("CHAR(1)", "CHAR(20)");
        this.TypeDefsAnalyzeOk("DECIMAL");
        this.TypeDefsAnalyzeOk("TIMESTAMP");
        this.TypeDefsAnalyzeOk("DATE");
        this.TypeDefsAnalyzeOk("BINARY");
        this.TypeDefsAnalyzeOk("DECIMAL");
        this.TypeDefsAnalyzeOk("DECIMAL(1)");
        this.TypeDefsAnalyzeOk("DECIMAL(12, 7)");
        this.TypeDefsAnalyzeOk("DECIMAL(38)");
        this.TypeDefsAnalyzeOk("DECIMAL(38, 1)");
        this.TypeDefsAnalyzeOk("DECIMAL(38, 38)");
        this.TypeDefAnalysisError("DECIMAL(1, 10)", "Decimal scale (10) must be <= precision (1)");
        this.TypeDefAnalysisError("DECIMAL(0, 0)", "Decimal precision must be > 0: 0");
        this.TypeDefAnalysisError("DECIMAL(39, 0)", "Decimal precision must be <= 38");
        for (ScalarType t : Type.getUnsupportedTypes()) {
            this.TypeDefAnalysisError(t.toSql(), String.format("Unsupported data type: %s", t.toSql()));
        }
        this.TypeDefsAnalyzeOk("ARRAY<BIGINT>");
        this.TypeDefsAnalyzeOk("MAP<TINYINT, DOUBLE>");
        this.TypeDefsAnalyzeOk("STRUCT<f:TINYINT>");
        this.TypeDefsAnalyzeOk("STRUCT<a:TINYINT, b:BIGINT, c:DOUBLE>");
        this.TypeDefsAnalyzeOk("STRUCT<a:TINYINT COMMENT 'x', b:BIGINT, c:DOUBLE COMMENT 'y'>");
        this.TypeDefAnalysisError("map<array<int>, int>", "Map type cannot have a complex-typed key: MAP<ARRAY<INT>,INT>");
        this.TypeDefAnalysisError("STRUCT<f1: int, f2: string, f1: float>", "Duplicate field name 'f1' in struct 'STRUCT<f1:INT,f2:STRING,f1:FLOAT>'");
        this.TypeDefAnalysisError("STRUCT<`???`: int>", "Invalid struct field name: ???");
        for (String prefix : Arrays.asList("struct<f1:int,f2:", "array<", "map<string,")) {
            String middle = "int";
            String suffix = ">";
            String maxTypeDef = this.genTypeSql(Type.MAX_NESTING_DEPTH, prefix, middle, suffix);
            Type maxType = this.TypeDefAnalyzeOk(maxTypeDef);
            Assert.assertFalse((boolean)maxType.exceedsMaxNestingDepth());
            String oneAboveMaxDef = this.genTypeSql(Type.MAX_NESTING_DEPTH + 1, prefix, middle, suffix);
            this.TypeDefAnalysisError(oneAboveMaxDef, "Type exceeds the maximum nesting depth");
            String veryDeepDef = this.genTypeSql(Type.MAX_NESTING_DEPTH * 100, prefix, middle, suffix);
            this.TypeDefAnalysisError(veryDeepDef, "Type exceeds the maximum nesting depth");
        }
    }

    private String genTypeSql(int depth, String prefix, String middle, String suffix) {
        return StringUtils.repeat((String)prefix, (int)(depth - 1)) + middle + StringUtils.repeat((String)suffix, (int)(depth - 1));
    }

    @Test
    public void TestUseDb() throws AnalysisException {
        this.AnalyzesOk("use functional");
        this.AnalysisError("use db_does_not_exist", "Database does not exist: db_does_not_exist");
    }

    @Test
    public void TestUseStatement() {
        Assert.assertTrue((boolean)(this.AnalyzesOk("USE functional") instanceof UseStmt));
    }

    @Test
    public void TestDescribeDb() throws AnalysisException {
        this.addTestDb("test_analyse_desc_db", null);
        this.AnalyzesOk("describe database test_analyse_desc_db");
        this.AnalyzesOk("describe database extended test_analyse_desc_db");
        this.AnalyzesOk("describe database formatted test_analyse_desc_db");
        this.AnalysisError("describe database db_does_not_exist", "Database does not exist: db_does_not_exist");
        this.AnalysisError("describe database extended db_does_not_exist", "Database does not exist: db_does_not_exist");
        this.AnalysisError("describe database formatted db_does_not_exist", "Database does not exist: db_does_not_exist");
    }

    @Test
    public void TestDescribe() throws AnalysisException {
        this.AnalyzesOk("describe formatted functional.alltypes");
        this.AnalyzesOk("describe functional.alltypes");
        this.AnalysisError("describe formatted nodb.alltypes", "Could not resolve path: 'nodb.alltypes'");
        this.AnalysisError("describe functional.notbl", "Could not resolve path: 'functional.notbl'");
        this.AnalyzesOk("describe functional_parquet.allcomplextypes.int_array_col");
        this.AnalyzesOk("describe functional_parquet.allcomplextypes.map_array_col");
        this.AnalyzesOk("describe functional_parquet.allcomplextypes.map_map_col");
        this.AnalyzesOk("describe functional_parquet.allcomplextypes.map_map_col.value");
        this.AnalyzesOk("describe functional_parquet.allcomplextypes.complex_struct_col");
        this.AnalyzesOk("describe functional_parquet.allcomplextypes.complex_struct_col.f3");
        this.AnalysisError("describe formatted functional_parquet.allcomplextypes.int_array_col", "DESCRIBE FORMATTED|EXTENDED must refer to a table");
        this.AnalysisError("describe functional_parquet.allcomplextypes.id", "Cannot describe path 'functional_parquet.allcomplextypes.id' targeting scalar type: INT");
        this.AnalysisError("describe functional_parquet.allcomplextypes.nonexistent", "Could not resolve path: 'functional_parquet.allcomplextypes.nonexistent'");
        this.addTestDb("ambig", null);
        this.addTestTable("create table ambig.ambig (ambig struct<ambig:array<int>>)");
        DescribeTableStmt describe = (DescribeTableStmt)this.AnalyzesOk("describe ambig", this.createAnalysisCtx("ambig"));
        TDescribeTableParams tdesc = describe.toThrift();
        Assert.assertTrue((boolean)tdesc.isSetTable_name());
        Assert.assertEquals((Object)"ambig", (Object)tdesc.table_name.getDb_name());
        Assert.assertEquals((String)"ambig", (Object)tdesc.table_name.getTable_name(), (Object)"ambig");
        Assert.assertFalse((boolean)tdesc.isSetResult_struct());
        this.AnalysisError("describe ambig.ambig", this.createAnalysisCtx("ambig"), "Path is ambiguous: 'ambig.ambig'");
        this.AnalysisError("describe ambig.ambig.ambig", this.createAnalysisCtx("ambig"), "Path is ambiguous: 'ambig.ambig.ambig'");
        describe = (DescribeTableStmt)this.AnalyzesOk("describe ambig.ambig.ambig.ambig", this.createAnalysisCtx("ambig"));
        tdesc = describe.toThrift();
        StructType expectedType = Path.getTypeAsStruct((Type)new ArrayType((Type)Type.INT));
        Assert.assertTrue((boolean)tdesc.isSetResult_struct());
        Assert.assertEquals((Object)expectedType, (Object)Type.fromThrift((TColumnType)tdesc.getResult_struct()));
    }

    @Test
    public void TestShow() throws AnalysisException {
        this.AnalyzesOk("show databases");
        this.AnalyzesOk("show databases like '*pattern'");
        this.AnalyzesOk("show data sources");
        this.AnalyzesOk("show data sources like '*pattern'");
        this.AnalyzesOk("show tables");
        this.AnalyzesOk("show tables like '*pattern'");
        this.AnalyzesOk("show tables in functional");
        this.AnalyzesOk("show tables in functional like '*pattern'");
        this.AnalyzesOk("show metadata tables in functional_parquet.iceberg_query_metadata");
        this.AnalyzesOk("show metadata tables in functional_parquet.iceberg_query_metadata like 'e*|f*'");
        this.AnalysisError("show metadata tables in functional_parquet.alltypes", "The SHOW METADATA TABLES statement is only valid for Iceberg tables: 'functional_parquet.alltypes' is not an Iceberg table.");
        for (String fnType : new String[]{"", "aggregate", "analytic"}) {
            this.AnalyzesOk(String.format("show %s functions", fnType));
            this.AnalyzesOk(String.format("show %s functions like '*pattern'", fnType));
            this.AnalyzesOk(String.format("show %s functions in functional", fnType));
            this.AnalyzesOk(String.format("show %s functions in functional like '*pattern'", fnType));
        }
        this.AnalysisError("show functions in baddb", "Database does not exist: baddb");
        this.AnalysisError("show functions in baddb like '*pattern'", "Database does not exist: baddb");
    }

    @Test
    public void TestShowFiles() throws AnalysisException {
        String[] partitions;
        this.AnalyzesOk(String.format("show files in functional.emptytable", new Object[0]));
        for (String partition : partitions = new String[]{"", "partition(month=10, year=2010)", "partition(month>10, year<2011, year>2008)"}) {
            this.AnalyzesOk(String.format("show files in functional.alltypes %s", partition));
            this.AnalysisError(String.format("show files in baddb.alltypes %s", partition), "Could not resolve table reference: 'baddb.alltypes'");
            this.AnalysisError(String.format("show files in functional.badtbl %s", partition), "Could not resolve table reference: 'functional.badtbl'");
            this.AnalysisError(String.format("show files in functional.alltypes_view %s", partition), "SHOW FILES not applicable to a non hdfs table: functional.alltypes_view");
            this.AnalysisError(String.format("show files in allcomplextypes.int_array_col %s", partition), this.createAnalysisCtx("functional"), "SHOW FILES not applicable to a non hdfs table: allcomplextypes.int_array_col");
        }
        this.AnalysisError("show files in functional.alltypes partition(year=2010,int_col=1)", "Partition exprs cannot contain non-partition column(s): int_col = 1.");
        this.AnalysisError("show files in functional.alltypes partition(year=2010,day=1)", "Could not resolve column/field reference: 'day'");
        this.AnalysisError("show files in functional.tinyinttable partition(int_col=1)", "Table is not partitioned: functional.tinyinttable");
        this.AnalysisError("show files in functional.alltypes partition(year=2010,month=NULL)", "No matching partition(s) found.");
    }

    @Test
    public void TestShowStats() throws AnalysisException {
        String[] statsQuals;
        for (String qual : statsQuals = new String[]{"table", "column"}) {
            this.AnalyzesOk(String.format("show %s stats functional.alltypes", qual));
            this.AnalysisError(String.format("show %s stats baddb.alltypes", qual), "Database does not exist: baddb");
            this.AnalysisError(String.format("show %s stats functional.badtbl", qual), "Table does not exist: functional.badtbl");
            this.AnalysisError(String.format("show %s stats functional.alltypes_view", qual), String.format("SHOW %s STATS not applicable to a view: functional.alltypes_view", qual.toUpperCase()));
        }
    }

    @Test
    public void TestShowPartitions() throws AnalysisException {
        this.AnalyzesOk("show partitions functional.alltypes");
        this.AnalysisError("show partitions baddb.alltypes", "Database does not exist: baddb");
        this.AnalysisError("show partitions functional.badtbl", "Table does not exist: functional.badtbl");
        this.AnalysisError("show partitions functional.alltypesnopart", "Table is not partitioned: functional.alltypesnopart");
        this.AnalysisError("show partitions functional.view_view", "SHOW PARTITIONS not applicable to a view: functional.view_view");
        this.AnalysisError("show partitions functional_hbase.alltypes", "SHOW PARTITIONS must target an HDFS or Kudu table: functional_hbase.alltypes");
    }

    @Test
    public void TestShowRangePartitions() throws AnalysisException {
        this.AnalyzesOk("show range partitions functional_kudu.dimtbl");
        this.AnalysisError("show range partitions baddb.alltypes", "Database does not exist: baddb");
        this.AnalysisError("show range partitions functional.badtbl", "Table does not exist: functional.badtbl");
        this.AnalysisError("show range partitions functional.alltypes", "SHOW RANGE PARTITIONS must target a Kudu table: functional.alltypes");
        this.AnalysisError("show range partitions functional.alltypesnopart", "SHOW RANGE PARTITIONS must target a Kudu table: functional.alltypes");
        this.AnalysisError("show range partitions functional_kudu.alltypes", "SHOW RANGE PARTITIONS requested but table does not have range partitions: functional_kudu.alltypes");
        this.AnalysisError("show range partitions functional.view_view", "SHOW RANGE PARTITIONS not applicable to a view: functional.view_view");
        this.AnalysisError("show range partitions functional_hbase.alltypes", "SHOW RANGE PARTITIONS must target a Kudu table: functional_hbase.alltypes");
    }

    @Test
    public void TestShowCreateFunction() throws AnalysisException {
        this.addTestFunction("TestFn", Lists.newArrayList((Object[])new ScalarType[]{Type.INT, Type.INT}), false);
        this.AnalyzesOk("show create function TestFn");
        this.addTestUda("AggFn", (Type)Type.INT, new Type[]{Type.INT});
        this.AnalyzesOk("show create aggregate function AggFn");
        this.AnalysisError("show create aggregate function default.TestFn", "Function testfn() does not exist in database default");
        this.AnalysisError("show create function default.AggFn", "Function aggfn() does not exist in database default");
        this.AnalysisError("show create function default.foobar", "Function foobar() does not exist in database default");
        this.AnalysisError("show create function foobar.fn", "Database does not exist: foobar");
    }

    @Test
    public void TestPermissionValidation() throws AnalysisException {
        String location = "/test-warehouse/.tmp_" + UUID.randomUUID().toString();
        org.apache.hadoop.fs.Path parentPath = FileSystemUtil.createFullyQualifiedPath((org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(location));
        FileSystem fs = null;
        try {
            fs = parentPath.getFileSystem(FileSystemUtil.getConfiguration());
            this.AnalyzesOk(String.format("create table new_table (col INT) location '%s/new_table'", location), String.format("Path '%s' cannot be reached: Path does not exist.", parentPath));
            this.AnalyzesOk(String.format("create table new_table (col INT) location '%s/new_table/'", location), String.format("Path '%s' cannot be reached: Path does not exist.", parentPath));
            this.AnalyzesOk(String.format("create table new_table location '%s/new_table' as select 1, 1", location), String.format("Path '%s' cannot be reached: Path does not exist.", parentPath));
            this.AnalyzesOk(String.format("create table new_table like functional.alltypes location '%s/new_table'", location), String.format("Path '%s' cannot be reached: Path does not exist.", parentPath));
            this.AnalyzesOk(String.format("create database new_db location '%s/new_db'", location), String.format("Path '%s' cannot be reached: Path does not exist.", parentPath));
            fs.mkdirs(parentPath);
            FSDataOutputStream out = fs.create(new org.apache.hadoop.fs.Path(parentPath, "test_loaddata/testdata.txt"));
            out.close();
            fs.setPermission(parentPath, new FsPermission(FsAction.NONE, FsAction.NONE, FsAction.NONE));
            this.AnalyzesOk(String.format("create data Source serverlog location '%s/foo.jar' class 'foo.Bar' API_VERSION 'V1'", location), String.format("Impala does not have READ access to path '%s'", parentPath));
            this.AnalyzesOk(String.format("create external table new_table (col INT) location '%s/new_table'", location), String.format("Impala does not have READ_WRITE access to path '%s'", parentPath));
            this.AnalyzesOk(String.format("alter table functional.insert_string_partitioned add partition (s2='hello') location '%s/new_partition'", location), String.format("Impala does not have READ_WRITE access to path '%s'", parentPath));
            this.AnalyzesOk(String.format("alter table functional.stringpartitionkey partition(string_col = 'partition1') set location '%s/new_part_loc'", location), String.format("Impala does not have READ_WRITE access to path '%s'", parentPath));
            fs.setPermission(parentPath, new FsPermission(FsAction.READ_WRITE, FsAction.NONE, FsAction.NONE));
            this.AnalyzesOk(String.format("create external table new_table (col INT) location '%s/new_table'", location));
        }
        catch (IOException e) {
            throw new AnalysisException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fs != null && fs.exists(parentPath)) {
                    fs.delete(parentPath, true);
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Test
    public void TestCommentOnDatabase() {
        this.AnalyzesOk("comment on database functional is 'comment'");
        this.AnalyzesOk("comment on database functional is ''");
        this.AnalyzesOk("comment on database functional is null");
        this.AnalysisError("comment on database doesntexist is 'comment'", "Database does not exist: doesntexist");
        this.AnalysisError(String.format("comment on database functional is '%s'", AnalyzeDDLTest.buildLongComment()), "Comment exceeds maximum length of 256 characters. The given comment has 261 characters.");
    }

    @Test
    public void TestCommentOnTable() {
        for (Pair pair : new Pair[]{new Pair((Object)"functional.alltypes", (Object)this.createAnalysisCtx()), new Pair((Object)"alltypes", (Object)this.createAnalysisCtx("functional"))}) {
            this.AnalyzesOk(String.format("comment on table %s is 'comment'", pair.first), (AnalysisContext)pair.second);
            this.AnalyzesOk(String.format("comment on table %s is ''", pair.first), (AnalysisContext)pair.second);
            this.AnalyzesOk(String.format("comment on table %s is null", pair.first), (AnalysisContext)pair.second);
        }
        this.AnalysisError("comment on table doesntexist is 'comment'", "Could not resolve table reference: 'default.doesntexist'");
        this.AnalysisError("comment on table functional.alltypes_view is 'comment'", "COMMENT ON TABLE not allowed on a view: functional.alltypes_view");
        this.AnalysisError(String.format("comment on table functional.alltypes is '%s'", AnalyzeDDLTest.buildLongComment()), "Comment exceeds maximum length of 256 characters. The given comment has 261 characters.");
    }

    @Test
    public void TestCommentOnView() {
        for (Pair pair : new Pair[]{new Pair((Object)"functional.alltypes_view", (Object)this.createAnalysisCtx()), new Pair((Object)"alltypes_view", (Object)this.createAnalysisCtx("functional"))}) {
            this.AnalyzesOk(String.format("comment on view %s is 'comment'", pair.first), (AnalysisContext)pair.second);
            this.AnalyzesOk(String.format("comment on view %s is ''", pair.first), (AnalysisContext)pair.second);
            this.AnalyzesOk(String.format("comment on view %s is null", pair.first), (AnalysisContext)pair.second);
        }
        this.AnalysisError("comment on view doesntexist is 'comment'", "Could not resolve table reference: 'default.doesntexist'");
        this.AnalysisError("comment on view functional.alltypes is 'comment'", "COMMENT ON VIEW not allowed on a table: functional.alltypes");
        this.AnalysisError(String.format("comment on view functional.alltypes_view is '%s'", AnalyzeDDLTest.buildLongComment()), "Comment exceeds maximum length of 256 characters. The given comment has 261 characters.");
    }

    @Test
    public void TestCommentOnColumn() {
        for (Pair pair : new Pair[]{new Pair((Object)"functional.alltypes.id", (Object)this.createAnalysisCtx()), new Pair((Object)"alltypes.id", (Object)this.createAnalysisCtx("functional")), new Pair((Object)"functional.alltypes_view.id", (Object)this.createAnalysisCtx()), new Pair((Object)"alltypes_view.id", (Object)this.createAnalysisCtx("functional")), new Pair((Object)"functional_kudu.alltypes.id", (Object)this.createAnalysisCtx())}) {
            this.AnalyzesOk(String.format("comment on column %s is 'comment'", pair.first), (AnalysisContext)pair.second);
            this.AnalyzesOk(String.format("comment on column %s is ''", pair.first), (AnalysisContext)pair.second);
            this.AnalyzesOk(String.format("comment on column %s is null", pair.first), (AnalysisContext)pair.second);
        }
        this.AnalysisError("comment on column functional.alltypes.doesntexist is 'comment'", "Column 'doesntexist' does not exist in table: functional.alltypes");
        this.AnalysisError(String.format("comment on column functional.alltypes.id is '%s'", AnalyzeDDLTest.buildLongComment()), "Comment exceeds maximum length of 256 characters. The given comment has 261 characters.");
    }

    private static String buildLongComment() {
        StringBuilder comment = new StringBuilder();
        for (int i = 0; i < 261; ++i) {
            comment.append("a");
        }
        return comment.toString();
    }

    @Test
    public void TestAlterDatabaseSetOwner() {
        String[] ownerTypes;
        for (String ownerType : ownerTypes = new String[]{"user", "role"}) {
            this.AnalyzesOk(String.format("alter database functional set owner %s foo", ownerType));
            this.AnalysisError(String.format("alter database doesntexist set owner %s foo", ownerType), "Database does not exist: doesntexist");
            this.AnalysisError(String.format("alter database functional set owner %s %s", ownerType, AnalyzeDDLTest.buildLongOwnerName()), "Owner name exceeds maximum length of 128 characters. The given owner name has 133 characters.");
        }
    }

    @Test
    public void TestAlterTableSetOwner() {
        String[] ownerTypes;
        for (String ownerType : ownerTypes = new String[]{"user", "role"}) {
            this.AnalyzesOk(String.format("alter table functional.alltypes set owner %s foo", ownerType));
            this.AnalysisError(String.format("alter table nodb.alltypes set owner %s foo", ownerType), "Could not resolve table reference: 'nodb.alltypes'");
            this.AnalysisError(String.format("alter table functional.notbl set owner %s foo", ownerType), "Could not resolve table reference: 'functional.notbl'");
            this.AnalysisError(String.format("alter table functional.alltypes set owner %s %s", ownerType, AnalyzeDDLTest.buildLongOwnerName()), "Owner name exceeds maximum length of 128 characters. The given owner name has 133 characters.");
            this.AnalysisError(String.format("alter table functional.alltypes_view set owner %s foo", ownerType), "ALTER TABLE not allowed on a view: functional.alltypes_view");
        }
    }

    @Test
    public void TestAlterViewSetOwner() {
        String[] ownerTypes;
        for (String ownerType : ownerTypes = new String[]{"user", "role"}) {
            this.AnalyzesOk(String.format("alter view functional.alltypes_view set owner %s foo", ownerType));
            this.AnalysisError(String.format("alter view nodb.alltypes set owner %s foo", ownerType), "Could not resolve table reference: 'nodb.alltypes'");
            this.AnalysisError(String.format("alter view functional.notbl set owner %s foo", ownerType), "Could not resolve table reference: 'functional.notbl'");
            this.AnalysisError(String.format("alter view functional.alltypes_view set owner %s %s", ownerType, AnalyzeDDLTest.buildLongOwnerName()), "Owner name exceeds maximum length of 128 characters. The given owner name has 133 characters.");
            this.AnalysisError(String.format("alter view functional.alltypes set owner %s foo", ownerType), "ALTER VIEW not allowed on a table: functional.alltypes");
        }
    }

    @Test
    public void TestAlterExecuteExpireSnapshots() {
        this.AnalyzesOk("alter table functional_parquet.iceberg_partitioned execute expire_snapshots(now() - interval 20 years);");
        this.AnalyzesOk("alter table functional_parquet.iceberg_partitioned execute expire_snapshots('2022-01-04 10:00:00');");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute unsupported_operation(123456789);", "'unsupported_operation' is not supported by ALTER TABLE <table> EXECUTE. Supported operations are: EXPIRE_SNAPSHOTS(<expression>), ROLLBACK(<expression>)");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute expire_snapshots(now(), 3);", "EXPIRE_SNAPSHOTS(<expression>) must have one parameter: expire_snapshots(now(), 3)");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute expire_snapshots(id);", "EXPIRE_SNAPSHOTS(<expression>) must be a constant expression: expire_snapshots(id)");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute expire_snapshots(42);", "EXPIRE_SNAPSHOTS(<expression>) must be a timestamp type but is 'TINYINT': 42");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute expire_snapshots('2021-02-32 15:52:45');", "Invalid TIMESTAMP expression has been given to EXPIRE_SNAPSHOTS(<expression>)");
    }

    @Test
    public void TestAlterExecuteRollback() {
        this.AnalyzesOk("alter table functional_parquet.iceberg_partitioned execute rollback('2022-01-04 10:00:00');");
        this.AnalyzesOk("alter table functional_parquet.iceberg_partitioned execute rollback(123456);");
        this.AnalyzesOk("alter table functional_parquet.iceberg_partitioned execute rollback(cast('2021-08-09 15:52:45' as timestamp) - interval 2 days + interval 3 hours);");
        this.AnalysisError("alter table nodb.alltypes execute rollback('2022-01-04 10:00:00');", "Could not resolve table reference: 'nodb.alltypes'");
        this.AnalysisError("alter table functional.alltypes execute rollback('2022-01-04 10:00:00');", "ALTER TABLE EXECUTE ROLLBACK is only supported for Iceberg tables: functional.alltypes");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute rollback(id);", "EXECUTE ROLLBACK(<expression>): <expression> must be a constant expression: rollback(id)");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute rollback(3.14);", "EXECUTE ROLLBACK(<expression>): <expression> must be an integer type or a timestamp, but is 'DECIMAL(3,2)': rollback(3.14)");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute rollback('2021-02-32 15:52:45');", "An invalid TIMESTAMP expression has been given to EXECUTE ROLLBACK(<expression>): the expression '2021-02-32 15:52:45' cannot be converted to a TIMESTAMP");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute rollback('the beginning');", "An invalid TIMESTAMP expression has been given to EXECUTE ROLLBACK(<expression>): the expression 'the beginning' cannot be converted to a TIMESTAMP");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute rollback(1111,2222);", "EXECUTE ROLLBACK(<expression>): must have one parameter");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute rollback('1111');", "An invalid TIMESTAMP expression has been given to EXECUTE ROLLBACK(<expression>): the expression '1111' cannot be converted to a TIMESTAMP");
    }

    @Test
    public void TestAlterExecuteRemoveOrphanFilesSnapshots() {
        this.AnalyzesOk("alter table functional_parquet.iceberg_partitioned execute remove_orphan_files(now());");
        this.AnalyzesOk("alter table functional_parquet.iceberg_partitioned execute remove_orphan_files(now() - interval 20 years);");
        this.AnalyzesOk("alter table functional_parquet.iceberg_partitioned execute remove_orphan_files('2022-01-04 10:00:00');");
        this.AnalysisError("alter table nodb.alltypes execute remove_orphan_files('2022-01-04 10:00:00');", "Could not resolve table reference: 'nodb.alltypes'");
        this.AnalysisError("alter table functional.alltypes execute remove_orphan_files('2022-01-04 10:00:00');", "ALTER TABLE EXECUTE REMOVE_ORPHAN_FILES is only supported for Iceberg tables: functional.alltypes");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute remove_orphan_files();", "EXECUTE REMOVE_ORPHAN_FILES(<expression>): must have one parameter");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute remove_orphan_files(id);", "EXECUTE REMOVE_ORPHAN_FILES(<expression>): <expression> must be a constant expression: remove_orphan_files(id)");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute remove_orphan_files(3.14);", "EXECUTE REMOVE_ORPHAN_FILES(<expression>): <expression> must be a timestamp, but is 'DECIMAL(3,2)': remove_orphan_files(3.14)");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute remove_orphan_files('2021-02-32 15:52:45');", "An invalid TIMESTAMP expression has been given to EXECUTE REMOVE_ORPHAN_FILES(<expression>): the expression '2021-02-32 15:52:45' cannot be converted to a TIMESTAMP");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute remove_orphan_files('the beginning');", "An invalid TIMESTAMP expression has been given to EXECUTE REMOVE_ORPHAN_FILES(<expression>): the expression 'the beginning' cannot be converted to a TIMESTAMP");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute remove_orphan_files(1111,2222);", "EXECUTE REMOVE_ORPHAN_FILES(<expression>): must have one parameter");
        this.AnalysisError("alter table functional_parquet.iceberg_partitioned execute remove_orphan_files('1111');", "An invalid TIMESTAMP expression has been given to EXECUTE REMOVE_ORPHAN_FILES(<expression>): the expression '1111' cannot be converted to a TIMESTAMP");
    }

    private static String buildLongOwnerName() {
        StringBuilder comment = new StringBuilder();
        for (int i = 0; i < 133; ++i) {
            comment.append("a");
        }
        return comment.toString();
    }
}

