/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.thrift.TExtractFromZipParams;
import org.apache.thrift.protocol.TBinaryProtocol;

public class ZipUtil {
    private static final TBinaryProtocol.Factory protocolFactory_ = new TBinaryProtocol.Factory();

    public static void extractFiles(byte[] serializedParams) throws ImpalaException {
        TExtractFromZipParams params = new TExtractFromZipParams();
        JniUtil.deserializeThrift(protocolFactory_, params, serializedParams);
        ZipUtil.extractFiles(params.archive_file, params.destination_dir);
    }

    public static void extractFiles(String archiveFilePath, String destDirPath) throws ImpalaException {
        try (ZipFile zip = new ZipFile(archiveFilePath);){
            File destDir = new File(destDirPath);
            String canonicalDestDirPath = destDir.getCanonicalPath();
            Enumeration<? extends ZipEntry> enumEntries = zip.entries();
            while (enumEntries.hasMoreElements()) {
                ZipEntry entry = enumEntries.nextElement();
                File destFile = new File(destDir, entry.getName());
                String canonicalDestFilePath = destFile.getCanonicalPath();
                if (!canonicalDestFilePath.startsWith(canonicalDestDirPath + File.separator)) {
                    throw new IllegalStateException("Invalid destination path in the archive:" + canonicalDestFilePath);
                }
                if (entry.isDirectory()) {
                    if (destFile.exists() || destFile.mkdirs()) continue;
                    throw new IllegalStateException("Couldn't create dir: " + destFile);
                }
                File parent = destFile.getParentFile();
                if (parent != null && !parent.exists() && !parent.mkdirs()) {
                    throw new IllegalStateException("Couldn't create dir: " + parent);
                }
                InputStream is = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream fos = new FileOutputStream(destFile);
                    Throwable throwable2 = null;
                    try {
                        while (is.available() > 0) {
                            fos.write(is.read());
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable2 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Exception e) {
            throw new InternalException(e.getMessage());
        }
    }
}

