/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public final class TopNCache<T, R extends Long> {
    private final Function<T, R> function_;
    private final int maxCapacity_;
    private final PriorityQueue<T> heap_;
    private final boolean alwaysEvictAtCapacity_;

    private int compareRanks(T t1, T t2) {
        return ((Long)this.function_.apply(t1)).compareTo((Long)this.function_.apply(t2));
    }

    public TopNCache(Function<T, R> f, int maxCapacity, boolean evictAtCapacity) {
        Preconditions.checkNotNull(f);
        Preconditions.checkState((maxCapacity > 0 ? 1 : 0) != 0);
        this.function_ = f;
        this.maxCapacity_ = maxCapacity;
        this.heap_ = new PriorityQueue(this.maxCapacity_, new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                return TopNCache.this.compareRanks(t1, t2);
            }
        });
        this.alwaysEvictAtCapacity_ = evictAtCapacity;
    }

    public synchronized void putOrUpdate(T item) {
        if (!this.heap_.remove(item) && this.heap_.size() == this.maxCapacity_) {
            if (!this.alwaysEvictAtCapacity_ && this.compareRanks(item, this.heap_.peek()) <= 0) {
                return;
            }
            this.heap_.poll();
        }
        this.heap_.add(item);
    }

    public synchronized void remove(T item) {
        this.heap_.remove(item);
    }

    @VisibleForTesting
    public synchronized void removeAll() {
        this.heap_.clear();
    }

    public synchronized List<T> listEntries() {
        return ImmutableList.copyOf(this.heap_);
    }
}

