/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.thrift.TColumnValue;

public class TColumnValueUtil {
    public static double getNumericVal(TColumnValue val) {
        if (val.isSetByte_val()) {
            return val.byte_val;
        }
        if (val.isSetShort_val()) {
            return val.short_val;
        }
        if (val.isSetInt_val()) {
            return val.int_val;
        }
        if (val.isSetLong_val()) {
            return val.long_val;
        }
        if (val.isSetDouble_val()) {
            return val.double_val;
        }
        if (val.isSetString_val()) {
            try {
                return Double.valueOf(val.string_val);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public static boolean isFieldSet(Type type, TColumnValue val) {
        if (!type.isScalarType() || val == null) {
            return false;
        }
        switch (((ScalarType)type).getPrimitiveType()) {
            case BOOLEAN: {
                return val.isSetBool_val();
            }
            case TINYINT: {
                return val.isSetByte_val();
            }
            case SMALLINT: {
                return val.isSetShort_val();
            }
            case INT: {
                return val.isSetInt_val();
            }
            case BIGINT: {
                return val.isSetLong_val();
            }
            case FLOAT: {
                return val.isSetDouble_val();
            }
            case DOUBLE: {
                return val.isSetDouble_val();
            }
            case DATE: {
                return val.isSetDate_val();
            }
            case STRING: {
                return val.isSetString_val();
            }
            case TIMESTAMP: {
                return val.isSetTimestamp_val();
            }
            case DECIMAL: {
                return val.isSetDecimal_val();
            }
            case BINARY: {
                return val.isSetBinary_val();
            }
        }
        return false;
    }
}

