/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternMatcher
implements Predicate<String> {
    private List<Pattern> patterns_;
    public static final PatternMatcher MATCHER_MATCH_ALL = new MatchAllPatternMatcher();
    public static final PatternMatcher MATCHER_MATCH_NONE = new MatchNonePatternMatcher();

    public boolean matches(String candidate) {
        if (this.patterns_ == null) {
            return true;
        }
        if (this.patterns_.isEmpty()) {
            return false;
        }
        for (Pattern pattern : this.patterns_) {
            if (!pattern.matcher(candidate).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean apply(String input) {
        return this.matches(input);
    }

    public static PatternMatcher createHivePatternMatcher(String hivePattern) {
        if (hivePattern == null) {
            return MATCHER_MATCH_ALL;
        }
        if (hivePattern.isEmpty()) {
            return MATCHER_MATCH_NONE;
        }
        PatternMatcher result = new PatternMatcher();
        result.patterns_ = Lists.newArrayList();
        String metaCharacters = "+?.^()]\\/{}";
        Pattern regex = Pattern.compile("([" + Pattern.quote("+?.^()]\\/{}") + "])");
        for (String pattern : Arrays.asList(hivePattern.split("\\|"))) {
            Matcher matcher = regex.matcher(pattern);
            pattern = matcher.replaceAll("\\\\$1").replace("*", ".*");
            result.patterns_.add(Pattern.compile(pattern));
        }
        return result;
    }

    public static PatternMatcher createJdbcPatternMatcher(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return MATCHER_MATCH_ALL;
        }
        String wildcardPattern = ".*";
        String result = pattern.replaceAll("([^\\\\])%", "$1" + wildcardPattern).replaceAll("\\\\%", "%").replaceAll("^%", wildcardPattern).replaceAll("([^\\\\])_", "$1.").replaceAll("\\\\_", "_").replaceAll("^_", ".");
        PatternMatcher matcher = new PatternMatcher();
        matcher.patterns_ = Lists.newArrayList();
        matcher.patterns_.add(Pattern.compile(result));
        return matcher;
    }

    private static final class MatchNonePatternMatcher
    extends PatternMatcher {
        MatchNonePatternMatcher() {
        }

        @Override
        public boolean matches(String candidate) {
            return false;
        }
    }

    private static final class MatchAllPatternMatcher
    extends PatternMatcher {
        MatchAllPatternMatcher() {
        }

        @Override
        public boolean matches(String candidate) {
            return true;
        }
    }
}

