/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import org.apache.impala.planner.DataSourceScanNode;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.util.Visitor;

public class MaxRowsProcessedVisitor
implements Visitor<PlanNode> {
    private boolean valid_ = true;
    private long maxRowsProcessed_ = 0L;
    private long maxRowsProcessedPerNode_ = 0L;

    @Override
    public void visit(PlanNode caller) {
        int numNodes;
        if (!this.valid_) {
            return;
        }
        PlanFragment fragment = caller.getFragment();
        int n = numNodes = fragment == null ? 1 : fragment.getNumNodes();
        if (caller instanceof DataSourceScanNode) {
            if (fragment == null) {
                numNodes = ((DataSourceScanNode)caller).getNumNodes();
            }
            Preconditions.checkState((numNodes == 1 ? 1 : 0) != 0);
            if (numNodes != 1) {
                this.valid_ = false;
                return;
            }
        } else if (caller instanceof ScanNode) {
            boolean missingStats;
            long numRows = caller.getInputCardinality();
            ScanNode scan = (ScanNode)caller;
            boolean bl = missingStats = scan.isTableMissingStats() || scan.hasCorruptTableStats();
            if (scan.isAccessingCollectionType() || missingStats && !scan.hasSimpleLimit()) {
                this.valid_ = false;
                return;
            }
            Preconditions.checkState((numRows > -1L ? 1 : 0) != 0);
            this.maxRowsProcessed_ = Math.max(this.maxRowsProcessed_, numRows);
            this.maxRowsProcessedPerNode_ = Math.max(this.maxRowsProcessedPerNode_, (long)Math.ceil((double)numRows / (double)numNodes));
        } else {
            long in = caller.getInputCardinality();
            long out = caller.getCardinality();
            if (in == -1L || out == -1L) {
                this.valid_ = false;
                return;
            }
            long numRows = Math.max(in, out);
            this.maxRowsProcessed_ = Math.max(this.maxRowsProcessed_, numRows);
            this.maxRowsProcessedPerNode_ = Math.max(this.maxRowsProcessedPerNode_, (long)Math.ceil((double)numRows / (double)numNodes));
        }
        Preconditions.checkState((this.maxRowsProcessed_ >= 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.maxRowsProcessedPerNode_ >= 0L ? 1 : 0) != 0);
    }

    public boolean valid() {
        return this.valid_;
    }

    public long getMaxRowsProcessed() {
        Preconditions.checkState((boolean)this.valid_);
        return this.maxRowsProcessed_;
    }

    public long getMaxRowsProcessedPerNode() {
        Preconditions.checkState((boolean)this.valid_);
        return this.maxRowsProcessedPerNode_;
    }
}

