/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ListMap<T> {
    private List<T> list_ = Collections.synchronizedList(new ArrayList());
    private final ConcurrentHashMap<T, Integer> map_ = new ConcurrentHashMap();

    public List<T> getList() {
        return ImmutableList.copyOf(this.list_);
    }

    public int size() {
        return this.list_.size();
    }

    public T getEntry(int index) {
        return this.list_.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrAddIndex(T t) {
        Integer index = this.map_.get(t);
        if (index != null) {
            return index;
        }
        ListMap listMap = this;
        synchronized (listMap) {
            index = this.map_.get(t);
            if (index != null) {
                return index;
            }
            this.list_.add(t);
            index = this.list_.size() - 1;
            this.map_.put(t, index);
        }
        return index;
    }

    public synchronized void populate(List<T> list) {
        Preconditions.checkState((this.list_.isEmpty() && this.map_.isEmpty() ? 1 : 0) != 0);
        this.list_ = Collections.synchronizedList(list);
        for (int i = 0; i < this.list_.size(); ++i) {
            this.map_.put(this.list_.get(i), i);
        }
    }
}

