/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.InsertStmt;
import org.apache.impala.analysis.KuduPartitionExpr;
import org.apache.impala.analysis.LiteralExpr;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.Pair;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TColumnEncoding;
import org.apache.impala.thrift.TExpr;
import org.apache.impala.thrift.TExprNode;
import org.apache.impala.thrift.TExprNodeType;
import org.apache.impala.thrift.THdfsCompression;
import org.apache.impala.util.EventSequence;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RangePartitionBound;

public class KuduUtil {
    private static final String KUDU_TABLE_NAME_PREFIX = "impala::";
    private static int KUDU_CLIENT_WORKER_THREAD_COUNT = 5;
    private static Map<String, KuduClient> kuduClients_ = new ConcurrentHashMap<String, KuduClient>();

    public static KuduClient getKuduClient(String kuduMasters) {
        KuduClient client = kuduClients_.computeIfAbsent(kuduMasters, k -> {
            KuduClient.KuduClientBuilder b = new KuduClient.KuduClientBuilder(kuduMasters);
            b.defaultAdminOperationTimeoutMs((long)BackendConfig.INSTANCE.getKuduClientTimeoutMs());
            b.defaultOperationTimeoutMs((long)BackendConfig.INSTANCE.getKuduClientTimeoutMs());
            b.workerCount(KUDU_CLIENT_WORKER_THREAD_COUNT);
            b.saslProtocolName(BackendConfig.INSTANCE.getKuduSaslProtocolName());
            return b.build();
        });
        return client;
    }

    public static KuduClient getKuduClient(String masterHosts, EventSequence catalogTimeline) {
        KuduClient kudu = KuduUtil.getKuduClient(masterHosts);
        catalogTimeline.markEvent("Got Kudu client");
        return kudu;
    }

    private static PartialRow parseRangePartitionBoundaryValues(Schema schema, List<String> rangePartitionColumns, List<TExpr> boundaryValues) throws ImpalaRuntimeException {
        Preconditions.checkState((rangePartitionColumns.size() == boundaryValues.size() ? 1 : 0) != 0);
        PartialRow bound = new PartialRow(schema);
        for (int i = 0; i < boundaryValues.size(); ++i) {
            String colName = rangePartitionColumns.get(i);
            ColumnSchema col = schema.getColumn(colName);
            Preconditions.checkNotNull((Object)col);
            KuduUtil.setKey(col, boundaryValues.get(i), schema.getColumnIndex(colName), bound);
        }
        return bound;
    }

    public static Pair<PartialRow, RangePartitionBound> buildRangePartitionBound(Schema schema, List<String> rangePartitionColumns, List<TExpr> boundaryValues, boolean isInclusiveBound) throws ImpalaRuntimeException {
        if (boundaryValues == null || boundaryValues.isEmpty()) {
            return new Pair<PartialRow, RangePartitionBound>(new PartialRow(schema), RangePartitionBound.INCLUSIVE_BOUND);
        }
        PartialRow bound = KuduUtil.parseRangePartitionBoundaryValues(schema, rangePartitionColumns, boundaryValues);
        RangePartitionBound boundType = null;
        boundType = isInclusiveBound ? RangePartitionBound.INCLUSIVE_BOUND : RangePartitionBound.EXCLUSIVE_BOUND;
        return new Pair<PartialRow, RangePartitionBound>(bound, boundType);
    }

    private static void setKey(ColumnSchema col, TExpr boundaryVal, int pos, PartialRow key) throws ImpalaRuntimeException {
        Preconditions.checkState((boundaryVal.getNodes().size() == 1 ? 1 : 0) != 0);
        TExprNode literal = boundaryVal.getNodes().get(0);
        String colName = col.getName();
        org.apache.kudu.Type type = col.getType();
        switch (type) {
            case INT8: {
                KuduUtil.checkCorrectType(literal.isSetInt_literal(), type, colName, literal);
                key.addByte(pos, (byte)literal.getInt_literal().getValue());
                break;
            }
            case INT16: {
                KuduUtil.checkCorrectType(literal.isSetInt_literal(), type, colName, literal);
                key.addShort(pos, (short)literal.getInt_literal().getValue());
                break;
            }
            case INT32: {
                KuduUtil.checkCorrectType(literal.isSetInt_literal(), type, colName, literal);
                key.addInt(pos, (int)literal.getInt_literal().getValue());
                break;
            }
            case INT64: {
                KuduUtil.checkCorrectType(literal.isSetInt_literal(), type, colName, literal);
                key.addLong(pos, literal.getInt_literal().getValue());
                break;
            }
            case VARCHAR: {
                KuduUtil.checkCorrectType(literal.isSetString_literal(), type, colName, literal);
                key.addVarchar(pos, literal.getString_literal().getValue());
                break;
            }
            case STRING: {
                KuduUtil.checkCorrectType(literal.isSetString_literal(), type, colName, literal);
                key.addString(pos, literal.getString_literal().getValue());
                break;
            }
            case UNIXTIME_MICROS: {
                KuduUtil.checkCorrectType(literal.isSetInt_literal(), type, colName, literal);
                key.addLong(pos, literal.getInt_literal().getValue());
                break;
            }
            case DATE: {
                KuduUtil.checkCorrectType(literal.isSetDate_literal(), type, colName, literal);
                key.addDate(pos, Date.valueOf(LocalDate.ofEpochDay(literal.getDate_literal().getDays_since_epoch())));
                break;
            }
            case DECIMAL: {
                KuduUtil.checkCorrectType(literal.isSetDecimal_literal(), type, colName, literal);
                BigInteger unscaledVal = new BigInteger(literal.getDecimal_literal().getValue());
                int scale = col.getTypeAttributes().getScale();
                key.addDecimal(pos, new BigDecimal(unscaledVal, scale));
                break;
            }
            default: {
                throw new ImpalaRuntimeException("Key columns not supported for type: " + type.toString());
            }
        }
    }

    public static Object getKuduDefaultValue(TExpr defaultValue, Type impalaType, String colName) throws ImpalaRuntimeException {
        Preconditions.checkState((defaultValue.getNodes().size() == 1 ? 1 : 0) != 0);
        TExprNode literal = defaultValue.getNodes().get(0);
        if (literal.getNode_type() == TExprNodeType.NULL_LITERAL) {
            return null;
        }
        org.apache.kudu.Type type = KuduUtil.fromImpalaType(impalaType);
        switch (type) {
            case INT8: {
                KuduUtil.checkCorrectType(literal.isSetInt_literal(), type, colName, literal);
                return (byte)literal.getInt_literal().getValue();
            }
            case INT16: {
                KuduUtil.checkCorrectType(literal.isSetInt_literal(), type, colName, literal);
                return (short)literal.getInt_literal().getValue();
            }
            case INT32: {
                KuduUtil.checkCorrectType(literal.isSetInt_literal(), type, colName, literal);
                return (int)literal.getInt_literal().getValue();
            }
            case INT64: {
                KuduUtil.checkCorrectType(literal.isSetInt_literal(), type, colName, literal);
                return literal.getInt_literal().getValue();
            }
            case FLOAT: {
                KuduUtil.checkCorrectType(literal.isSetFloat_literal(), type, colName, literal);
                return Float.valueOf((float)literal.getFloat_literal().getValue());
            }
            case DOUBLE: {
                KuduUtil.checkCorrectType(literal.isSetFloat_literal(), type, colName, literal);
                return literal.getFloat_literal().getValue();
            }
            case VARCHAR: 
            case STRING: {
                KuduUtil.checkCorrectType(literal.isSetString_literal(), type, colName, literal);
                return literal.getString_literal().getValue();
            }
            case BOOL: {
                KuduUtil.checkCorrectType(literal.isSetBool_literal(), type, colName, literal);
                return literal.getBool_literal().isValue();
            }
            case UNIXTIME_MICROS: {
                KuduUtil.checkCorrectType(literal.isSetInt_literal(), type, colName, literal);
                return literal.getInt_literal().getValue();
            }
            case DATE: {
                KuduUtil.checkCorrectType(literal.isSetDate_literal(), type, colName, literal);
                return Date.valueOf(LocalDate.ofEpochDay(literal.getDate_literal().getDays_since_epoch()));
            }
            case DECIMAL: {
                KuduUtil.checkCorrectType(literal.isSetDecimal_literal(), type, colName, literal);
                BigInteger unscaledVal = new BigInteger(literal.getDecimal_literal().getValue());
                return new BigDecimal(unscaledVal, impalaType.getDecimalDigits());
            }
        }
        throw new ImpalaRuntimeException("Unsupported value for column type: " + type.toString());
    }

    public static ColumnSchema.Encoding fromThrift(TColumnEncoding encoding) throws ImpalaRuntimeException {
        switch (encoding) {
            case AUTO: {
                return ColumnSchema.Encoding.AUTO_ENCODING;
            }
            case PLAIN: {
                return ColumnSchema.Encoding.PLAIN_ENCODING;
            }
            case PREFIX: {
                return ColumnSchema.Encoding.PREFIX_ENCODING;
            }
            case GROUP_VARINT: {
                return ColumnSchema.Encoding.GROUP_VARINT;
            }
            case RLE: {
                return ColumnSchema.Encoding.RLE;
            }
            case DICTIONARY: {
                return ColumnSchema.Encoding.DICT_ENCODING;
            }
            case BIT_SHUFFLE: {
                return ColumnSchema.Encoding.BIT_SHUFFLE;
            }
        }
        throw new ImpalaRuntimeException("Unsupported encoding: " + encoding.toString());
    }

    public static TColumnEncoding toThrift(ColumnSchema.Encoding encoding) throws ImpalaRuntimeException {
        switch (encoding) {
            case AUTO_ENCODING: {
                return TColumnEncoding.AUTO;
            }
            case PLAIN_ENCODING: {
                return TColumnEncoding.PLAIN;
            }
            case PREFIX_ENCODING: {
                return TColumnEncoding.PREFIX;
            }
            case GROUP_VARINT: {
                return TColumnEncoding.GROUP_VARINT;
            }
            case RLE: {
                return TColumnEncoding.RLE;
            }
            case DICT_ENCODING: {
                return TColumnEncoding.DICTIONARY;
            }
            case BIT_SHUFFLE: {
                return TColumnEncoding.BIT_SHUFFLE;
            }
        }
        throw new ImpalaRuntimeException("Unsupported encoding: " + encoding.toString());
    }

    public static ColumnSchema.CompressionAlgorithm fromThrift(THdfsCompression compression) throws ImpalaRuntimeException {
        switch (compression) {
            case DEFAULT: {
                return ColumnSchema.CompressionAlgorithm.DEFAULT_COMPRESSION;
            }
            case NONE: {
                return ColumnSchema.CompressionAlgorithm.NO_COMPRESSION;
            }
            case SNAPPY: {
                return ColumnSchema.CompressionAlgorithm.SNAPPY;
            }
            case LZ4: {
                return ColumnSchema.CompressionAlgorithm.LZ4;
            }
            case ZLIB: {
                return ColumnSchema.CompressionAlgorithm.ZLIB;
            }
        }
        throw new ImpalaRuntimeException("Unsupported compression algorithm: " + compression.toString());
    }

    public static THdfsCompression toThrift(ColumnSchema.CompressionAlgorithm compression) throws ImpalaRuntimeException {
        switch (compression) {
            case NO_COMPRESSION: {
                return THdfsCompression.NONE;
            }
            case DEFAULT_COMPRESSION: {
                return THdfsCompression.DEFAULT;
            }
            case SNAPPY: {
                return THdfsCompression.SNAPPY;
            }
            case LZ4: {
                return THdfsCompression.LZ4;
            }
            case ZLIB: {
                return THdfsCompression.ZLIB;
            }
        }
        throw new ImpalaRuntimeException("Unsupported compression algorithm: " + compression.toString());
    }

    public static TColumn setColumnOptions(TColumn column, boolean isKey, boolean isPrimaryKeyUnique, Boolean isNullable, boolean isAutoIncrementing, ColumnSchema.Encoding encoding, ColumnSchema.CompressionAlgorithm compression, Expr defaultValue, Integer blockSize, String kuduName) {
        column.setIs_key(isKey);
        column.setIs_primary_key_unique(isPrimaryKeyUnique);
        if (isNullable != null) {
            column.setIs_nullable(isNullable);
        }
        column.setIs_auto_incrementing(isAutoIncrementing);
        try {
            if (encoding != null) {
                column.setEncoding(KuduUtil.toThrift(encoding));
            }
            if (compression != null) {
                column.setCompression(KuduUtil.toThrift(compression));
            }
        }
        catch (ImpalaRuntimeException e) {
            throw new IllegalStateException(String.format("Error parsing encoding/compression values for Kudu column '%s': %s", column.getColumnName(), e.getMessage()));
        }
        if (defaultValue != null) {
            Preconditions.checkState((boolean)(defaultValue instanceof LiteralExpr));
            column.setDefault_value(defaultValue.treeToThrift());
        }
        if (blockSize != null) {
            column.setBlock_size(blockSize);
        }
        Preconditions.checkNotNull((Object)kuduName);
        column.setKudu_column_name(kuduName);
        return column;
    }

    private static void checkCorrectType(boolean correctType, org.apache.kudu.Type t, String colName, TExprNode boundaryVal) throws ImpalaRuntimeException {
        if (correctType) {
            return;
        }
        throw new ImpalaRuntimeException(String.format("Expected '%s' literal for column '%s' got '%s'", t.getName(), colName, Type.fromThrift(boundaryVal.getType()).toSql()));
    }

    public static boolean isSupportedKeyType(Type type) {
        return type.isIntegerType() || type.isStringType() || type.isTimestamp() || type.isDate();
    }

    public static String getDefaultKuduTableName(String metastoreDbName, String metastoreTableName, boolean isHMSIntegrationEnabled) {
        return isHMSIntegrationEnabled ? metastoreDbName + "." + metastoreTableName : KUDU_TABLE_NAME_PREFIX + metastoreDbName + "." + metastoreTableName;
    }

    public static boolean isDefaultKuduTableName(String name, String metastoreDbName, String metastoreTableName) {
        return KuduUtil.getDefaultKuduTableName(metastoreDbName, metastoreTableName, true).equals(name) || KuduUtil.getDefaultKuduTableName(metastoreDbName, metastoreTableName, false).equals(name);
    }

    public static org.apache.kudu.Type fromImpalaType(Type t) throws ImpalaRuntimeException {
        if (!t.isScalarType()) {
            throw new ImpalaRuntimeException(String.format("Type %s is not supported in Kudu", t.toSql()));
        }
        ScalarType s = (ScalarType)t;
        switch (s.getPrimitiveType()) {
            case TINYINT: {
                return org.apache.kudu.Type.INT8;
            }
            case SMALLINT: {
                return org.apache.kudu.Type.INT16;
            }
            case INT: {
                return org.apache.kudu.Type.INT32;
            }
            case BIGINT: {
                return org.apache.kudu.Type.INT64;
            }
            case BOOLEAN: {
                return org.apache.kudu.Type.BOOL;
            }
            case STRING: {
                return org.apache.kudu.Type.STRING;
            }
            case DOUBLE: {
                return org.apache.kudu.Type.DOUBLE;
            }
            case FLOAT: {
                return org.apache.kudu.Type.FLOAT;
            }
            case TIMESTAMP: {
                return org.apache.kudu.Type.UNIXTIME_MICROS;
            }
            case DECIMAL: {
                return org.apache.kudu.Type.DECIMAL;
            }
            case DATE: {
                return org.apache.kudu.Type.DATE;
            }
            case VARCHAR: {
                return org.apache.kudu.Type.VARCHAR;
            }
            case BINARY: {
                return org.apache.kudu.Type.BINARY;
            }
        }
        throw new ImpalaRuntimeException(String.format("Type %s is not supported in Kudu", s.toSql()));
    }

    public static Type toImpalaType(org.apache.kudu.Type t, ColumnTypeAttributes typeAttributes) throws ImpalaRuntimeException {
        switch (t) {
            case BOOL: {
                return Type.BOOLEAN;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case FLOAT: {
                return Type.FLOAT;
            }
            case INT8: {
                return Type.TINYINT;
            }
            case INT16: {
                return Type.SMALLINT;
            }
            case INT32: {
                return Type.INT;
            }
            case INT64: {
                return Type.BIGINT;
            }
            case STRING: {
                return Type.STRING;
            }
            case UNIXTIME_MICROS: {
                return Type.TIMESTAMP;
            }
            case DATE: {
                return Type.DATE;
            }
            case DECIMAL: {
                return ScalarType.createDecimalType(typeAttributes.getPrecision(), typeAttributes.getScale());
            }
            case VARCHAR: {
                return ScalarType.createVarcharType(typeAttributes.getLength());
            }
            case BINARY: {
                return Type.BINARY;
            }
        }
        throw new ImpalaRuntimeException(String.format("Kudu type '%s' is not supported in Impala", t.getName()));
    }

    public static Expr createPartitionExpr(InsertStmt insertStmt, Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((boolean)(insertStmt.getTargetTable() instanceof FeKuduTable));
        KuduPartitionExpr kuduPartitionExpr = new KuduPartitionExpr(0, (FeKuduTable)insertStmt.getTargetTable(), Lists.newArrayList(insertStmt.getPartitionKeyExprs()), insertStmt.getPartitionColPos());
        kuduPartitionExpr.analyze(analyzer);
        return kuduPartitionExpr;
    }

    public static int getkuduClientsSize() {
        return kuduClients_.size();
    }

    public static String getPrimaryKeyString(boolean isPrimaryKeyUnique) {
        StringBuilder sb = new StringBuilder();
        if (!isPrimaryKeyUnique) {
            sb.append("NON UNIQUE ");
        }
        sb.append("PRIMARY KEY");
        return sb.toString();
    }

    public static String getAutoIncrementingColumnName() {
        return Schema.getAutoIncrementingColumnName();
    }
}

