/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class JvmPauseMonitor {
    private static final Logger LOG = Logger.getLogger(JvmPauseMonitor.class);
    private static final long SLEEP_INTERVAL_MS = 500L;
    private long deadlockCheckIntervalS_ = 0L;
    private long warnThresholdMs_;
    private static final long WARN_THRESHOLD_MS = 10000L;
    private long infoThresholdMs_;
    private static final long INFO_THRESHOLD_MS = 1000L;
    private volatile long numGcWarnThresholdExceeded = 0L;
    private volatile long numGcInfoThresholdExceeded = 0L;
    private volatile long totalGcExtraSleepTime = 0L;
    private Thread monitorThread_;
    private volatile boolean shouldRun = true;
    public static JvmPauseMonitor INSTANCE = new JvmPauseMonitor();

    public static void initPauseMonitor(long deadlockCheckIntervalS) {
        if (INSTANCE.isStarted()) {
            return;
        }
        INSTANCE.init(deadlockCheckIntervalS);
    }

    private JvmPauseMonitor() {
        this(1000L, 10000L);
    }

    private JvmPauseMonitor(long infoThresholdMs, long warnThresholdMs) {
        this.infoThresholdMs_ = infoThresholdMs;
        this.warnThresholdMs_ = warnThresholdMs;
    }

    protected void init(long deadlockCheckIntervalS) {
        this.deadlockCheckIntervalS_ = deadlockCheckIntervalS;
        this.monitorThread_ = new Thread((Runnable)new Monitor(), "JVM pause monitor");
        this.monitorThread_.setDaemon(true);
        this.monitorThread_.start();
    }

    public boolean isStarted() {
        return this.monitorThread_ != null;
    }

    public long getNumGcWarnThresholdExceeded() {
        return this.numGcWarnThresholdExceeded;
    }

    public long getNumGcInfoThresholdExceeded() {
        return this.numGcInfoThresholdExceeded;
    }

    public long getTotalGcExtraSleepTime() {
        return this.totalGcExtraSleepTime;
    }

    private String formatMessage(long extraSleepTime, Map<String, GcTimes> gcTimesAfterSleep, Map<String, GcTimes> gcTimesBeforeSleep) {
        Sets.SetView gcBeanNames = Sets.intersection(gcTimesAfterSleep.keySet(), gcTimesBeforeSleep.keySet());
        ArrayList gcDiffs = Lists.newArrayList();
        for (String name : gcBeanNames) {
            GcTimes diff = gcTimesAfterSleep.get(name).subtract(gcTimesBeforeSleep.get(name));
            if (diff.gcCount == 0L) continue;
            gcDiffs.add("GC pool '" + name + "' had collection(s): " + diff.toString());
        }
        String ret = "Detected pause in JVM or host machine (eg GC): pause of approximately " + extraSleepTime + "ms\n";
        ret = gcDiffs.isEmpty() ? ret + "No GCs detected" : ret + Joiner.on((String)"\n").join((Iterable)gcDiffs);
        return ret;
    }

    private Map<String, GcTimes> getGcTimes() {
        HashMap map = Maps.newHashMap();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            map.put(gcBean.getName(), new GcTimes(gcBean));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void causeDeadlock() {
        final Object obj1 = new Object();
        final Object obj2 = new Object();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Object object = obj2;
                    synchronized (object) {
                        Object object2 = obj1;
                        synchronized (object2) {
                            System.err.println("Thread 1 got locks");
                        }
                    }
                }
            }
        }).start();
        while (true) {
            Object object = obj1;
            synchronized (object) {
                Object object2 = obj2;
                synchronized (object2) {
                    System.err.println("Thread 2 got locks");
                }
            }
        }
    }

    private static void allocateMemory() {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        while (true) {
            list.add(String.valueOf(i++));
        }
    }

    public static void main(String[] args) throws Exception {
        JvmPauseMonitor monitor = new JvmPauseMonitor();
        monitor.init(60L);
        if (args[0].equals("gc")) {
            JvmPauseMonitor.allocateMemory();
        } else if (args[0].equals("deadlock")) {
            JvmPauseMonitor.causeDeadlock();
        } else {
            System.err.println("Unknown mode");
        }
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        @Override
        public void run() {
            Stopwatch sw = Stopwatch.createUnstarted();
            Stopwatch timeSinceDeadlockCheck = Stopwatch.createStarted();
            Map gcTimesBeforeSleep = JvmPauseMonitor.this.getGcTimes();
            LOG.info((Object)"Starting JVM pause monitor");
            while (JvmPauseMonitor.this.shouldRun) {
                sw.reset().start();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    LOG.error((Object)"JVM pause monitor interrupted", (Throwable)ie);
                    return;
                }
                sw.stop();
                long extraSleepTime = sw.elapsed(TimeUnit.MILLISECONDS) - 500L;
                Map gcTimesAfterSleep = JvmPauseMonitor.this.getGcTimes();
                if (extraSleepTime > JvmPauseMonitor.this.warnThresholdMs_) {
                    ++JvmPauseMonitor.this.numGcWarnThresholdExceeded;
                    LOG.warn((Object)JvmPauseMonitor.this.formatMessage(extraSleepTime, gcTimesAfterSleep, gcTimesBeforeSleep));
                } else if (extraSleepTime > JvmPauseMonitor.this.infoThresholdMs_) {
                    ++JvmPauseMonitor.this.numGcInfoThresholdExceeded;
                    LOG.info((Object)JvmPauseMonitor.this.formatMessage(extraSleepTime, gcTimesAfterSleep, gcTimesBeforeSleep));
                }
                JvmPauseMonitor.this.totalGcExtraSleepTime = JvmPauseMonitor.this.totalGcExtraSleepTime + extraSleepTime;
                gcTimesBeforeSleep = gcTimesAfterSleep;
                if (JvmPauseMonitor.this.deadlockCheckIntervalS_ <= 0L || timeSinceDeadlockCheck.elapsed(TimeUnit.SECONDS) < JvmPauseMonitor.this.deadlockCheckIntervalS_) continue;
                this.checkForDeadlocks();
                timeSinceDeadlockCheck.reset().start();
            }
        }

        private void checkForDeadlocks() {
            ThreadMXBean threadMx = ManagementFactory.getThreadMXBean();
            long[] deadlockedTids = threadMx.findDeadlockedThreads();
            if (deadlockedTids != null) {
                ThreadInfo[] deadlockedThreads = threadMx.getThreadInfo(deadlockedTids, true, true);
                LOG.error((Object)("Found " + deadlockedThreads.length + " threads in deadlock: "));
                for (ThreadInfo thread : deadlockedThreads) {
                    if (thread == null) continue;
                    LOG.error((Object)thread.toString());
                }
                LOG.error((Object)"All threads:");
                for (ThreadInfo thread : threadMx.dumpAllThreads(true, true)) {
                    LOG.error((Object)thread.toString());
                }
                LOG.fatal((Object)"Aborting because of deadlocked threads in JVM.");
                System.exit(1);
            }
        }
    }

    private static class GcTimes {
        private long gcCount;
        private long gcTimeMillis;

        private GcTimes(GarbageCollectorMXBean gcBean) {
            this.gcCount = gcBean.getCollectionCount();
            this.gcTimeMillis = gcBean.getCollectionTime();
        }

        private GcTimes(long count, long time) {
            this.gcCount = count;
            this.gcTimeMillis = time;
        }

        private GcTimes subtract(GcTimes other) {
            return new GcTimes(this.gcCount - other.gcCount, this.gcTimeMillis - other.gcTimeMillis);
        }

        public String toString() {
            return "count=" + this.gcCount + " time=" + this.gcTimeMillis + "ms";
        }
    }
}

