/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.apache.impala.common.ImpalaRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtil.class);

    public static Map<String, String> convertJSONToPropertyMap(String propertyString) throws ImpalaRuntimeException {
        Map propertyMap = null;
        if (!Strings.isNullOrEmpty((String)propertyString)) {
            try {
                TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
                propertyMap = (Map)new ObjectMapper().readValue(propertyString, (TypeReference)typeRef);
            }
            catch (JsonProcessingException e) {
                String errorMessage = String.format("Invalid JSON string for property: '%s'", propertyString);
                LOG.error(errorMessage, (Throwable)e);
                throw new ImpalaRuntimeException(errorMessage);
            }
        }
        return propertyMap;
    }

    public static String convertPropertyMapToJSON(Map<String, String> propertyMap) throws ImpalaRuntimeException {
        if (propertyMap != null && propertyMap.size() > 0) {
            try {
                return new ObjectMapper().writeValueAsString(propertyMap);
            }
            catch (JsonProcessingException e) {
                String errorMessage = String.format("Failed to convert property map to JSON string: %s", e.getMessage());
                LOG.error(errorMessage);
                throw new ImpalaRuntimeException(errorMessage);
            }
        }
        return new String("");
    }
}

