/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.thrift.TPoolConfig;
import org.apache.impala.thrift.TPoolConfigParams;
import org.apache.impala.thrift.TResolveRequestPoolParams;
import org.apache.impala.thrift.TResolveRequestPoolResult;
import org.apache.impala.util.RequestPoolService;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniRequestPoolService {
    static final Logger LOG = LoggerFactory.getLogger(JniRequestPoolService.class);
    private static final TBinaryProtocol.Factory protocolFactory_ = new TBinaryProtocol.Factory();
    private final RequestPoolService requestPoolService_;

    JniRequestPoolService(String fsAllocationPath, String sitePath, boolean isBackendTest) {
        Preconditions.checkNotNull((Object)fsAllocationPath);
        this.requestPoolService_ = RequestPoolService.getInstance(fsAllocationPath, sitePath, isBackendTest);
    }

    public void start() {
        this.requestPoolService_.start();
    }

    public byte[] resolveRequestPool(byte[] thriftResolvePoolParams) throws ImpalaException {
        TResolveRequestPoolParams resolvePoolParams = new TResolveRequestPoolParams();
        JniUtil.deserializeThrift(protocolFactory_, resolvePoolParams, thriftResolvePoolParams);
        TResolveRequestPoolResult result = this.requestPoolService_.resolveRequestPool(resolvePoolParams);
        try {
            return new TSerializer((TProtocolFactory)protocolFactory_).serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }

    public byte[] getPoolConfig(byte[] thriftPoolConfigParams) throws ImpalaException {
        TPoolConfigParams poolConfigParams = new TPoolConfigParams();
        JniUtil.deserializeThrift(protocolFactory_, poolConfigParams, thriftPoolConfigParams);
        TPoolConfig result = this.requestPoolService_.getPoolConfig(poolConfigParams.getPool());
        try {
            return new TSerializer((TProtocolFactory)protocolFactory_).serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }
}

