/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;

public class JMXJsonUtil {
    protected static transient MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
    private static final Logger LOG = Logger.getLogger(JMXJsonUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJMXJson() {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator jg = null;
            try {
                JsonFactory jsonFactory = new JsonFactory();
                jg = jsonFactory.createJsonGenerator((Writer)writer);
                jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                jg.writeStartObject();
                if (mBeanServer == null) {
                    jg.writeStringField("result", "ERROR");
                    jg.writeStringField("message", "No MBeanServer could be found");
                    jg.close();
                    LOG.error((Object)"No MBeanServer could be found.");
                    String string = writer.toString();
                    return string;
                }
                JMXJsonUtil.listBeans(jg);
                return writer.toString();
            }
            finally {
                if (jg != null) {
                    jg.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Caught an exception while processing JMX request", (Throwable)e);
        }
        return writer.toString();
    }

    private static void listBeans(JsonGenerator jg) throws IOException {
        Set<ObjectName> names = mBeanServer.queryNames(null, null);
        jg.writeArrayFieldStart("beans");
        for (ObjectName oname : names) {
            MBeanInfo minfo;
            String code = "";
            Object attributeinfo = null;
            try {
                minfo = mBeanServer.getMBeanInfo(oname);
                code = minfo.getClassName();
                String prs = "";
                try {
                    if ("org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                        prs = "modelerType";
                        code = (String)mBeanServer.getAttribute(oname, prs);
                    }
                }
                catch (AttributeNotFoundException e) {
                    LOG.error((Object)("getting attribute " + prs + " of " + oname + " threw an exception"), (Throwable)e);
                }
                catch (MBeanException e) {
                    LOG.error((Object)("getting attribute " + prs + " of " + oname + " threw an exception"), (Throwable)e);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("getting attribute " + prs + " of " + oname + " threw an exception"), (Throwable)e);
                }
                catch (ReflectionException e) {
                    LOG.error((Object)("getting attribute " + prs + " of " + oname + " threw an exception"), (Throwable)e);
                }
            }
            catch (InstanceNotFoundException e) {
                continue;
            }
            catch (IntrospectionException | ReflectionException e) {
                LOG.error((Object)("Problem while trying to process JMX query with MBean " + oname), (Throwable)e);
                continue;
            }
            jg.writeStartObject();
            jg.writeStringField("name", oname.toString());
            jg.writeStringField("modelerType", code);
            MBeanAttributeInfo[] attrs = minfo.getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                JMXJsonUtil.writeAttribute(jg, oname, attrs[i]);
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    private static void writeAttribute(JsonGenerator jg, ObjectName oname, MBeanAttributeInfo attr) throws IOException {
        if (!attr.isReadable()) {
            return;
        }
        String attName = attr.getName();
        if ("modelerType".equals(attName)) {
            return;
        }
        if (attName.indexOf("=") >= 0 || attName.indexOf(":") >= 0 || attName.indexOf(" ") >= 0) {
            return;
        }
        Object value = null;
        try {
            value = mBeanServer.getAttribute(oname, attName);
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                LOG.trace((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            } else {
                LOG.error((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            }
            return;
        }
        catch (RuntimeErrorException e) {
            LOG.debug((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            return;
        }
        catch (AttributeNotFoundException e) {
            return;
        }
        catch (MBeanException e) {
            LOG.error((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            return;
        }
        catch (RuntimeException e) {
            LOG.error((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            return;
        }
        catch (ReflectionException e) {
            LOG.error((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            return;
        }
        catch (InstanceNotFoundException e) {
            return;
        }
        JMXJsonUtil.writeAttribute(jg, attName, value);
    }

    private static void writeAttribute(JsonGenerator jg, String attName, Object value) throws IOException {
        jg.writeFieldName(attName);
        JMXJsonUtil.writeObject(jg, value);
    }

    private static void writeObject(JsonGenerator jg, Object value) throws IOException {
        if (value == null) {
            jg.writeNull();
        } else {
            Class<?> c = value.getClass();
            if (c.isArray()) {
                jg.writeStartArray();
                int len = Array.getLength(value);
                for (int j = 0; j < len; ++j) {
                    Object item = Array.get(value, j);
                    JMXJsonUtil.writeObject(jg, item);
                }
                jg.writeEndArray();
            } else if (value instanceof Number) {
                Number n = (Number)value;
                jg.writeNumber(n.toString());
            } else if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                jg.writeBoolean(b.booleanValue());
            } else if (value instanceof CompositeData) {
                CompositeData cds = (CompositeData)value;
                CompositeType comp = cds.getCompositeType();
                Set<String> keys = comp.keySet();
                jg.writeStartObject();
                for (String key : keys) {
                    JMXJsonUtil.writeAttribute(jg, key, cds.get(key));
                }
                jg.writeEndObject();
            } else if (value instanceof TabularData) {
                TabularData tds = (TabularData)value;
                jg.writeStartArray();
                for (Object entry : tds.values()) {
                    JMXJsonUtil.writeObject(jg, entry);
                }
                jg.writeEndArray();
            } else {
                jg.writeString(value.toString());
            }
        }
    }
}

