/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import org.apache.impala.util.IntIterator;

public class IntArrayList {
    private int[] data_;
    private int size_;

    public IntArrayList() {
        this(0);
    }

    public IntArrayList(int capacity) {
        this.data_ = new int[capacity];
        this.size_ = 0;
    }

    public int[] data() {
        return this.data_;
    }

    private void ensureCapacity(int capacity) {
        if (capacity > this.data_.length) {
            int[] newData = new int[Math.max(this.data_.length * 2, capacity)];
            System.arraycopy(this.data_, 0, newData, 0, this.data_.length);
            this.data_ = newData;
        }
    }

    public void add(int value) {
        this.ensureCapacity(this.size_ + 1);
        this.data_[this.size_++] = value;
    }

    public void removeLast(int numRemove) {
        if (numRemove < 0 || numRemove > this.size_) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.size_ -= numRemove;
    }

    public void clear() {
        this.size_ = 0;
    }

    public int size() {
        return this.size_;
    }

    public void set(int index, int value) {
        if (index >= this.size_) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.data_[index] = value;
    }

    public int get(int index) {
        if (index >= this.size_) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data_[index];
    }

    public IntIterator iterator() {
        return new IntIterator(){
            private int pos_ = 0;

            @Override
            public boolean hasNext() {
                return this.pos_ < IntArrayList.this.size();
            }

            @Override
            public int next() {
                return IntArrayList.this.get(this.pos_++);
            }

            @Override
            public int peek() {
                return IntArrayList.this.get(this.pos_);
            }
        };
    }
}

