/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.impala.catalog.FeIcebergTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergMetadataScanner {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergMetadataScanner.class);
    private final Table metadataTable_;
    private final FeIcebergTable iceTbl_;
    private final String metadataTableName_;
    private CloseableIterator<FileScanTask> fileScanTaskIterator_;
    private CloseableIterator<StructLike> dataRowsIterator_;

    public IcebergMetadataScanner(FeIcebergTable iceTbl, String metadataTableName) {
        Preconditions.checkNotNull((Object)iceTbl);
        this.iceTbl_ = iceTbl;
        this.metadataTableName_ = metadataTableName;
        this.metadataTable_ = MetadataTableUtils.createMetadataTableInstance((Table)this.iceTbl_.getIcebergApiTable(), (MetadataTableType)MetadataTableType.valueOf((String)this.metadataTableName_));
    }

    public void ScanMetadataTable() {
        LOG.trace("Metadata table schema: " + this.metadataTable_.schema().toString());
        TableScan scan = this.metadataTable_.newScan();
        this.fileScanTaskIterator_ = scan.planFiles().iterator();
        this.FindFileScanTaskWithRows();
    }

    private boolean FindFileScanTaskWithRows() {
        while (this.fileScanTaskIterator_.hasNext()) {
            DataTask dataTask = (DataTask)this.fileScanTaskIterator_.next();
            this.dataRowsIterator_ = dataTask.rows().iterator();
            if (!this.dataRowsIterator_.hasNext()) continue;
            return true;
        }
        return false;
    }

    public StructLike GetNext() {
        if (this.dataRowsIterator_ != null && this.dataRowsIterator_.hasNext()) {
            return (StructLike)this.dataRowsIterator_.next();
        }
        if (this.FindFileScanTaskWithRows()) {
            return (StructLike)this.dataRowsIterator_.next();
        }
        return null;
    }

    public Object GetValueByFieldId(StructLike structLike, int fieldId) {
        Accessor accessor = this.metadataTable_.schema().accessorForField(fieldId);
        return accessor.get((Object)structLike);
    }

    public <T> T GetValueByPosition(StructLike structLike, int pos, Class<T> javaClass) {
        return (T)structLike.get(pos, javaClass);
    }

    public byte[] ByteBufferToByteArray(ByteBuffer buffer) {
        int length = buffer.remaining();
        byte[] res = new byte[length];
        buffer.get(res);
        return res;
    }

    public static class CollectionScanner<T> {
        private Iterator<T> iterator_;

        private CollectionScanner(Iterator<T> iterator) {
            Preconditions.checkNotNull(iterator);
            this.iterator_ = iterator;
        }

        public static <G> CollectionScanner<G> fromArray(List<G> array) {
            CollectionScanner<G> res = new CollectionScanner<G>(array.iterator());
            LOG.trace("Created metadata table array scanner, array size: " + array.size());
            return res;
        }

        public static <K, V> CollectionScanner<Map.Entry<K, V>> fromMap(Map<K, V> map) {
            CollectionScanner<Map.Entry<K, V>> res = new CollectionScanner<Map.Entry<K, V>>(map.entrySet().iterator());
            LOG.trace("Created metadata table map scanner, map size: " + map.size());
            return res;
        }

        public T GetNextCollectionItem() {
            if (this.iterator_.hasNext()) {
                return this.iterator_.next();
            }
            return null;
        }
    }
}

