/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.HoodieROTablePathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HudiUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HudiUtil.class);

    public static List<FileStatus> filterFilesForHudiROPath(List<FileStatus> stats) {
        ArrayList<FileStatus> validStats = new ArrayList<FileStatus>(stats);
        HoodieROTablePathFilter hudiFilter = new HoodieROTablePathFilter();
        validStats.removeIf(f -> {
            try {
                return !hudiFilter.accept(f.getPath());
            }
            catch (HoodieException e) {
                LOG.debug("Unable to check Hudi path {}", (Object)f.getPath(), (Object)e);
                return false;
            }
        });
        return validStats;
    }
}

