/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.impala.catalog.DataSourceTable;
import org.apache.impala.catalog.IcebergTable;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.compat.MetastoreShim;

public class HiveMetadataFormatUtils {
    public static final String FIELD_DELIM = "\t";
    public static final String LINE_DELIM = "\n";
    static final int DEFAULT_STRINGBUILDER_SIZE = 2048;
    private static final int ALIGNMENT = 20;
    private static final String schema = "col_name,data_type,comment#string:string:string";
    private static final String colStatsSchema = "col_name,data_type,min,max,num_nulls,distinct_count,avg_col_len,max_col_len,num_trues,num_falses,comment#string:string:string:string:string:string:string:string:string:string:string";
    private static final String partitionTransformSchema = "col_name,transform_type#string:string";
    private static final CharSequenceTranslator ESCAPE_JAVA = new LookupTranslator((CharSequence[][])new String[][]{{"\"", "\\\""}, {"\\", "\\\\"}}).with(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE())});
    private static final String NUM_ERASURE_CODED_FILES = "numFilesErasureCoded";

    public static String getAllColumnsInformation(List<FieldSchema> cols, List<FieldSchema> partCols, boolean printHeader, boolean isOutputPadded, boolean showPartColsSep) {
        StringBuilder columnInformation = new StringBuilder(2048);
        if (printHeader) {
            HiveMetadataFormatUtils.formatColumnsHeader(columnInformation, null);
        }
        HiveMetadataFormatUtils.formatAllFields(columnInformation, cols, isOutputPadded, null);
        if (partCols != null && !partCols.isEmpty() && showPartColsSep) {
            columnInformation.append(LINE_DELIM).append("# Partition Information").append(LINE_DELIM);
            HiveMetadataFormatUtils.formatColumnsHeader(columnInformation, null);
            HiveMetadataFormatUtils.formatAllFields(columnInformation, partCols, isOutputPadded, null);
        }
        return columnInformation.toString();
    }

    public static String getPartitionTransformInformation(List<FieldSchema> partCols) {
        StringBuilder info = new StringBuilder(2048);
        if (partCols == null || partCols.isEmpty()) {
            return info.toString();
        }
        info.append(LINE_DELIM).append("# Partition Transform Information").append(LINE_DELIM);
        HiveMetadataFormatUtils.formatPartitionTransformColumnsHeader(info);
        HiveMetadataFormatUtils.formatAllFields(info, partCols, false, null);
        return info.toString();
    }

    private static void formatColumnsHeader(StringBuilder columnInformation, List<ColumnStatisticsObj> colStats) {
        columnInformation.append("# ");
        HiveMetadataFormatUtils.formatOutput(HiveMetadataFormatUtils.getColumnsHeader(colStats), columnInformation, false, true);
        columnInformation.append(LINE_DELIM);
    }

    private static void formatPartitionTransformColumnsHeader(StringBuilder columnInformation) {
        columnInformation.append("# ");
        HiveMetadataFormatUtils.formatOutput(HiveMetadataFormatUtils.getPartitionTransformColumnsHeader(), columnInformation, false, true);
        columnInformation.append(LINE_DELIM);
    }

    private static void formatOutput(String[] fields, StringBuilder tableInfo, boolean isLastLinePadded, boolean isFormatted) {
        if (!isFormatted) {
            for (int i = 0; i < fields.length; ++i) {
                String value = StringEscapeUtils.escapeJava((String)fields[i]);
                if (value != null) {
                    tableInfo.append((Object)value);
                }
                tableInfo.append(i == fields.length - 1 ? LINE_DELIM : FIELD_DELIM);
            }
        } else {
            int[] paddings = new int[fields.length - 1];
            if (fields.length > 1) {
                for (int i = 0; i < fields.length - 1; ++i) {
                    if (fields[i] == null) {
                        tableInfo.append(FIELD_DELIM);
                        continue;
                    }
                    tableInfo.append(String.format("%-20s", fields[i])).append(FIELD_DELIM);
                    paddings[i] = 20 > fields[i].length() ? 20 : fields[i].length();
                }
            }
            if (fields.length > 0) {
                String value = fields[fields.length - 1];
                String unescapedValue = isLastLinePadded && value != null ? value.replaceAll("\\\\n|\\\\r|\\\\r\\\\n", LINE_DELIM) : value;
                HiveMetadataFormatUtils.indentMultilineValue(unescapedValue, tableInfo, paddings, false);
            } else {
                tableInfo.append(LINE_DELIM);
            }
        }
    }

    public static String[] getColumnsHeader(List<ColumnStatisticsObj> colStats) {
        String colSchema = schema;
        if (colStats != null) {
            colSchema = colStatsSchema;
        }
        return colSchema.split("#")[0].split(",");
    }

    public static String[] getPartitionTransformColumnsHeader() {
        return partitionTransformSchema.split("#")[0].split(",");
    }

    private static void formatAllFields(StringBuilder tableInfo, List<FieldSchema> cols, boolean isOutputPadded, List<ColumnStatisticsObj> colStats) {
        for (FieldSchema col : cols) {
            if (isOutputPadded) {
                HiveMetadataFormatUtils.formatWithIndentation(col.getName(), col.getType(), HiveMetadataFormatUtils.getComment(col), tableInfo, colStats);
                continue;
            }
            HiveMetadataFormatUtils.formatWithoutIndentation(col.getName(), col.getType(), col.getComment(), tableInfo, colStats);
        }
    }

    private static void formatWithoutIndentation(String name, String type, String comment, StringBuilder colBuffer, List<ColumnStatisticsObj> colStats) {
        colBuffer.append(name);
        colBuffer.append(FIELD_DELIM);
        colBuffer.append(type);
        colBuffer.append(FIELD_DELIM);
        if (colStats != null) {
            ColumnStatisticsObj cso = HiveMetadataFormatUtils.getColumnStatisticsObject(name, type, colStats);
            if (cso != null) {
                ColumnStatisticsData csd = cso.getStatsData();
                if (csd.isSetBinaryStats()) {
                    BinaryColumnStatsData bcsd = csd.getBinaryStats();
                    HiveMetadataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", bcsd.getNumNulls(), "", bcsd.getAvgColLen(), bcsd.getMaxColLen(), "", "");
                } else if (csd.isSetStringStats()) {
                    StringColumnStatsData scsd = csd.getStringStats();
                    HiveMetadataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", scsd.getNumNulls(), scsd.getNumDVs(), scsd.getAvgColLen(), scsd.getMaxColLen(), "", "");
                } else if (csd.isSetBooleanStats()) {
                    BooleanColumnStatsData bcsd = csd.getBooleanStats();
                    HiveMetadataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", bcsd.getNumNulls(), "", "", "", bcsd.getNumTrues(), bcsd.getNumFalses());
                } else if (csd.isSetDecimalStats()) {
                    DecimalColumnStatsData dcsd = csd.getDecimalStats();
                    HiveMetadataFormatUtils.appendColumnStatsNoFormatting(colBuffer, HiveMetadataFormatUtils.convertToString(dcsd.getLowValue()), HiveMetadataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDoubleStats()) {
                    DoubleColumnStatsData dcsd = csd.getDoubleStats();
                    HiveMetadataFormatUtils.appendColumnStatsNoFormatting(colBuffer, dcsd.getLowValue(), dcsd.getHighValue(), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetLongStats()) {
                    LongColumnStatsData lcsd = csd.getLongStats();
                    HiveMetadataFormatUtils.appendColumnStatsNoFormatting(colBuffer, lcsd.getLowValue(), lcsd.getHighValue(), lcsd.getNumNulls(), lcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDateStats()) {
                    DateColumnStatsData dcsd = csd.getDateStats();
                    HiveMetadataFormatUtils.appendColumnStatsNoFormatting(colBuffer, HiveMetadataFormatUtils.convertToString(dcsd.getLowValue()), HiveMetadataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                }
            } else {
                HiveMetadataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", "", "", "", "", "", "");
            }
        }
        colBuffer.append(comment == null ? "" : ESCAPE_JAVA.translate((CharSequence)comment));
        colBuffer.append(LINE_DELIM);
    }

    private static void appendColumnStatsNoFormatting(StringBuilder sb, Object min, Object max, Object numNulls, Object ndv, Object avgColLen, Object maxColLen, Object numTrues, Object numFalses) {
        sb.append(min).append(FIELD_DELIM);
        sb.append(max).append(FIELD_DELIM);
        sb.append(numNulls).append(FIELD_DELIM);
        sb.append(ndv).append(FIELD_DELIM);
        sb.append(avgColLen).append(FIELD_DELIM);
        sb.append(maxColLen).append(FIELD_DELIM);
        sb.append(numTrues).append(FIELD_DELIM);
        sb.append(numFalses).append(FIELD_DELIM);
    }

    static String getComment(FieldSchema col) {
        return col.getComment() != null ? col.getComment() : "";
    }

    private static void formatWithIndentation(String colName, String colType, String colComment, StringBuilder tableInfo, List<ColumnStatisticsObj> colStats) {
        tableInfo.append(String.format("%-20s", colName)).append(FIELD_DELIM);
        tableInfo.append(String.format("%-20s", colType)).append(FIELD_DELIM);
        if (colStats != null) {
            ColumnStatisticsObj cso = HiveMetadataFormatUtils.getColumnStatisticsObject(colName, colType, colStats);
            if (cso != null) {
                ColumnStatisticsData csd = cso.getStatsData();
                if (csd.isSetBinaryStats()) {
                    BinaryColumnStatsData bcsd = csd.getBinaryStats();
                    HiveMetadataFormatUtils.appendColumnStats(tableInfo, "", "", bcsd.getNumNulls(), "", bcsd.getAvgColLen(), bcsd.getMaxColLen(), "", "");
                } else if (csd.isSetStringStats()) {
                    StringColumnStatsData scsd = csd.getStringStats();
                    HiveMetadataFormatUtils.appendColumnStats(tableInfo, "", "", scsd.getNumNulls(), scsd.getNumDVs(), scsd.getAvgColLen(), scsd.getMaxColLen(), "", "");
                } else if (csd.isSetBooleanStats()) {
                    BooleanColumnStatsData bcsd = csd.getBooleanStats();
                    HiveMetadataFormatUtils.appendColumnStats(tableInfo, "", "", bcsd.getNumNulls(), "", "", "", bcsd.getNumTrues(), bcsd.getNumFalses());
                } else if (csd.isSetDecimalStats()) {
                    DecimalColumnStatsData dcsd = csd.getDecimalStats();
                    HiveMetadataFormatUtils.appendColumnStats(tableInfo, HiveMetadataFormatUtils.convertToString(dcsd.getLowValue()), HiveMetadataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDoubleStats()) {
                    DoubleColumnStatsData dcsd = csd.getDoubleStats();
                    HiveMetadataFormatUtils.appendColumnStats(tableInfo, dcsd.getLowValue(), dcsd.getHighValue(), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetLongStats()) {
                    LongColumnStatsData lcsd = csd.getLongStats();
                    HiveMetadataFormatUtils.appendColumnStats(tableInfo, lcsd.getLowValue(), lcsd.getHighValue(), lcsd.getNumNulls(), lcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDateStats()) {
                    DateColumnStatsData dcsd = csd.getDateStats();
                    HiveMetadataFormatUtils.appendColumnStats(tableInfo, HiveMetadataFormatUtils.convertToString(dcsd.getLowValue()), HiveMetadataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                }
            } else {
                HiveMetadataFormatUtils.appendColumnStats(tableInfo, "", "", "", "", "", "", "", "");
            }
        }
        int colNameLength = 20 > colName.length() ? 20 : colName.length();
        int colTypeLength = 20 > colType.length() ? 20 : colType.length();
        HiveMetadataFormatUtils.indentMultilineValue(colComment, tableInfo, new int[]{colNameLength, colTypeLength}, false);
    }

    private static void indentMultilineValue(String value, StringBuilder tableInfo, int[] columnWidths, boolean printNull) {
        if (value == null) {
            if (printNull) {
                tableInfo.append(String.format("%-20s", value));
            }
            tableInfo.append(LINE_DELIM);
        } else {
            String[] valueSegments = value.split("\n|\r|\r\n");
            tableInfo.append(String.format("%-20s", valueSegments[0])).append(LINE_DELIM);
            for (int i = 1; i < valueSegments.length; ++i) {
                HiveMetadataFormatUtils.printPadding(tableInfo, columnWidths);
                tableInfo.append(String.format("%-20s", valueSegments[i])).append(LINE_DELIM);
            }
        }
    }

    private static void printPadding(StringBuilder tableInfo, int[] columnWidths) {
        for (int columnWidth : columnWidths) {
            if (columnWidth == 0) {
                tableInfo.append(FIELD_DELIM);
                continue;
            }
            tableInfo.append(String.format("%" + columnWidth + "s" + FIELD_DELIM, ""));
        }
    }

    private static String convertToString(Decimal val) {
        if (val == null) {
            return "";
        }
        HiveDecimal result = HiveDecimal.create((BigInteger)new BigInteger(val.getUnscaled()), (int)val.getScale());
        if (result != null) {
            return result.toString();
        }
        return "";
    }

    private static String convertToString(Date val) {
        if (val == null) {
            return "";
        }
        DateWritable writableValue = new DateWritable((int)val.getDaysSinceEpoch());
        return writableValue.toString();
    }

    private static void appendColumnStats(StringBuilder sb, Object min, Object max, Object numNulls, Object ndv, Object avgColLen, Object maxColLen, Object numTrues, Object numFalses) {
        sb.append(String.format("%-20s", min)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", max)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", numNulls)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", ndv)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", avgColLen)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", maxColLen)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", numTrues)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", numFalses)).append(FIELD_DELIM);
    }

    private static ColumnStatisticsObj getColumnStatisticsObject(String colName, String colType, List<ColumnStatisticsObj> colStats) {
        if (colStats != null && !colStats.isEmpty()) {
            for (ColumnStatisticsObj cso : colStats) {
                if (!cso.getColName().equalsIgnoreCase(colName) || !cso.getColType().equalsIgnoreCase(colType)) continue;
                return cso;
            }
        }
        return null;
    }

    public static String getConstraintsInformation(PrimaryKeyInfo pkInfo, ForeignKeyInfo fkInfo) {
        StringBuilder constraintsInfo = new StringBuilder(2048);
        constraintsInfo.append(LINE_DELIM).append("# Constraints").append(LINE_DELIM);
        if (HiveMetadataFormatUtils.isPrimaryKeyInfoNotEmpty(pkInfo)) {
            constraintsInfo.append(LINE_DELIM).append("# Primary Key").append(LINE_DELIM);
            HiveMetadataFormatUtils.getPrimaryKeyInformation(constraintsInfo, pkInfo);
        }
        if (HiveMetadataFormatUtils.isForeignKeyInfoNotEmpty(fkInfo)) {
            constraintsInfo.append(LINE_DELIM).append("# Foreign Keys").append(LINE_DELIM);
            HiveMetadataFormatUtils.getForeignKeysInformation(constraintsInfo, fkInfo);
        }
        return constraintsInfo.toString();
    }

    private static boolean isPrimaryKeyInfoNotEmpty(PrimaryKeyInfo info) {
        return info != null && !info.getColNames().isEmpty();
    }

    private static boolean isForeignKeyInfoNotEmpty(ForeignKeyInfo info) {
        return info != null && !info.getForeignKeys().isEmpty();
    }

    private static void getPrimaryKeyInformation(StringBuilder constraintsInfo, PrimaryKeyInfo pkInfo) {
        HiveMetadataFormatUtils.formatOutput("Table:", pkInfo.getDatabaseName() + "." + pkInfo.getTableName(), constraintsInfo);
        HiveMetadataFormatUtils.formatOutput("Constraint Name:", pkInfo.getConstraintName(), constraintsInfo);
        Map colNames = pkInfo.getColNames();
        String title = "Column Name:".intern();
        for (String colName : colNames.values()) {
            constraintsInfo.append(String.format("%-20s", title)).append(FIELD_DELIM);
            HiveMetadataFormatUtils.formatOutput(new String[]{colName}, constraintsInfo);
        }
    }

    private static void getForeignKeyColInformation(StringBuilder constraintsInfo, ForeignKeyInfo.ForeignKeyCol fkCol) {
        String[] fkcFields = new String[]{"Parent Column Name:" + fkCol.parentDatabaseName + "." + fkCol.parentTableName + "." + fkCol.parentColName, "Column Name:" + fkCol.childColName, "Key Sequence:" + fkCol.position};
        HiveMetadataFormatUtils.formatOutput(fkcFields, constraintsInfo);
    }

    private static void getForeignKeyRelInformation(StringBuilder constraintsInfo, String constraintName, List<ForeignKeyInfo.ForeignKeyCol> fkRel) {
        HiveMetadataFormatUtils.formatOutput("Constraint Name:", constraintName, constraintsInfo);
        if (fkRel != null && fkRel.size() > 0) {
            for (ForeignKeyInfo.ForeignKeyCol fkc : fkRel) {
                HiveMetadataFormatUtils.getForeignKeyColInformation(constraintsInfo, fkc);
            }
        }
        constraintsInfo.append(LINE_DELIM);
    }

    private static void getForeignKeysInformation(StringBuilder constraintsInfo, ForeignKeyInfo fkInfo) {
        HiveMetadataFormatUtils.formatOutput("Table:", fkInfo.getChildDatabaseName() + "." + fkInfo.getChildTableName(), constraintsInfo);
        Map foreignKeys = fkInfo.getForeignKeys();
        if (foreignKeys != null && foreignKeys.size() > 0) {
            for (Map.Entry me : foreignKeys.entrySet()) {
                HiveMetadataFormatUtils.getForeignKeyRelInformation(constraintsInfo, (String)me.getKey(), (List)me.getValue());
            }
        }
    }

    public static String getTableInformation(Table table, boolean isOutputPadded) {
        StringBuilder tableInfo = new StringBuilder(2048);
        tableInfo.append(LINE_DELIM).append("# Detailed Table Information").append(LINE_DELIM);
        HiveMetadataFormatUtils.getTableMetaDataInformation(tableInfo, table, isOutputPadded);
        tableInfo.append(LINE_DELIM).append("# Storage Information").append(LINE_DELIM);
        HiveMetadataFormatUtils.getStorageDescriptorInfo(tableInfo, table);
        if (TableType.VIRTUAL_VIEW.equals((Object)TableType.valueOf((String)table.getTableType()))) {
            tableInfo.append(LINE_DELIM).append("# View Information").append(LINE_DELIM);
            HiveMetadataFormatUtils.getViewInfo(tableInfo, table);
        } else if (TableType.MATERIALIZED_VIEW.equals((Object)TableType.valueOf((String)table.getTableType()))) {
            tableInfo.append(LINE_DELIM).append("# Materialized View Information").append(LINE_DELIM);
            MetastoreShim.getMaterializedViewInfo(tableInfo, table, isOutputPadded);
        }
        return tableInfo.toString();
    }

    private static void getViewInfo(StringBuilder tableInfo, Table tbl) {
        HiveMetadataFormatUtils.formatOutput("View Original Text:", tbl.getViewOriginalText(), tableInfo);
        HiveMetadataFormatUtils.formatOutput("View Expanded Text:", tbl.getViewExpandedText(), tableInfo);
    }

    private static void getTableMetaDataInformation(StringBuilder tableInfo, Table tbl, boolean isOutputPadded) {
        HiveMetadataFormatUtils.formatOutput("Database:", tbl.getDbName(), tableInfo);
        HiveMetadataFormatUtils.formatOutput("OwnerType:", tbl.getOwnerType() != null ? tbl.getOwnerType().name() : "null", tableInfo);
        HiveMetadataFormatUtils.formatOutput("Owner:", tbl.getOwner(), tableInfo);
        HiveMetadataFormatUtils.formatOutput("CreateTime:", HiveMetadataFormatUtils.formatDate(tbl.getCreateTime()), tableInfo);
        HiveMetadataFormatUtils.formatOutput("LastAccessTime:", HiveMetadataFormatUtils.formatDate(tbl.getLastAccessTime()), tableInfo);
        HiveMetadataFormatUtils.formatOutput("Retention:", Integer.toString(tbl.getRetention()), tableInfo);
        if (!TableType.VIRTUAL_VIEW.toString().equals(tbl.getTableType())) {
            String location = tbl.getSd().getLocation();
            HiveMetadataFormatUtils.formatOutput("Location:", location, tableInfo);
            String ecPolicy = FileSystemUtil.getErasureCodingPolicy(new Path(location));
            HiveMetadataFormatUtils.formatOutput("Erasure Coding Policy:", ecPolicy, tableInfo);
        }
        HiveMetadataFormatUtils.formatOutput("Table Type:", tbl.getTableType(), tableInfo);
        if (tbl.getParameters().size() > 0) {
            tableInfo.append("Table Parameters:").append(LINE_DELIM);
            Set<String> keysToBeMasked = null;
            if (DataSourceTable.isDataSourceTable(tbl)) {
                keysToBeMasked = DataSourceTable.getJdbcTblPropertyMaskKeys();
            }
            HiveMetadataFormatUtils.displayAllParameters(tbl.getParameters(), tableInfo, false, isOutputPadded, keysToBeMasked);
        }
    }

    private static void displayAllParameters(Map<String, String> params, StringBuilder tableInfo, boolean escapeUnicode, boolean isOutputPadded, Set<String> keysToBeMasked) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String value = params.get(key);
            if (key.equals(NUM_ERASURE_CODED_FILES)) {
                if ("0".equals(value)) {
                    continue;
                }
            } else if (keysToBeMasked != null && keysToBeMasked.contains(key.toLowerCase())) {
                value = "******";
            }
            tableInfo.append(FIELD_DELIM);
            HiveMetadataFormatUtils.formatOutput(key, escapeUnicode ? StringEscapeUtils.escapeJava((String)value) : ESCAPE_JAVA.translate((CharSequence)value), tableInfo, isOutputPadded);
        }
    }

    private static void formatOutput(String[] fields, StringBuilder tableInfo) {
        HiveMetadataFormatUtils.formatOutput(fields, tableInfo, false, true);
    }

    protected static void formatOutput(String name, String value, StringBuilder tableInfo, boolean isOutputPadded) {
        String unescapedValue = isOutputPadded && value != null ? value.replaceAll("\\\\n|\\\\r|\\\\r\\\\n", LINE_DELIM) : value;
        HiveMetadataFormatUtils.formatOutput(name, unescapedValue, tableInfo);
    }

    public static void formatOutput(String name, String value, StringBuilder tableInfo) {
        tableInfo.append(String.format("%-20s", name)).append(FIELD_DELIM);
        int colNameLength = 20 > name.length() ? 20 : name.length();
        HiveMetadataFormatUtils.indentMultilineValue(value, tableInfo, new int[]{0, colNameLength}, true);
    }

    private static String formatDate(long timeInSeconds) {
        if (timeInSeconds != 0L) {
            java.util.Date date = new java.util.Date(timeInSeconds * 1000L);
            return date.toString();
        }
        return "UNKNOWN";
    }

    private static void getStorageDescriptorInfo(StringBuilder tableInfo, Table table) {
        StorageDescriptor storageDesc = table.getSd();
        HiveMetadataFormatUtils.formatOutput("SerDe Library:", storageDesc.getSerdeInfo().getSerializationLib(), tableInfo);
        HiveMetadataFormatUtils.formatOutput("InputFormat:", storageDesc.getInputFormat(), tableInfo);
        HiveMetadataFormatUtils.formatOutput("OutputFormat:", storageDesc.getOutputFormat(), tableInfo);
        HiveMetadataFormatUtils.formatOutput("Compressed:", storageDesc.isCompressed() ? "Yes" : "No", tableInfo);
        if (!IcebergTable.isIcebergTable(table)) {
            HiveMetadataFormatUtils.formatOutput("Num Buckets:", String.valueOf(storageDesc.getNumBuckets()), tableInfo);
            HiveMetadataFormatUtils.formatOutput("Bucket Columns:", storageDesc.getBucketCols().toString(), tableInfo);
        }
        HiveMetadataFormatUtils.formatOutput("Sort Columns:", storageDesc.getSortCols().toString(), tableInfo);
        if (storageDesc.isStoredAsSubDirectories()) {
            HiveMetadataFormatUtils.formatOutput("Stored As SubDirectories:", "Yes", tableInfo);
        }
        if (null != storageDesc.getSkewedInfo()) {
            List skewedColValues;
            List skewedColNames = HiveMetadataFormatUtils.sortedList(storageDesc.getSkewedInfo().getSkewedColNames());
            if (skewedColNames != null && skewedColNames.size() > 0) {
                HiveMetadataFormatUtils.formatOutput("Skewed Columns:", skewedColNames.toString(), tableInfo);
            }
            if ((skewedColValues = HiveMetadataFormatUtils.sortedList(storageDesc.getSkewedInfo().getSkewedColValues(), new VectorComparator())) != null && skewedColValues.size() > 0) {
                HiveMetadataFormatUtils.formatOutput("Skewed Values:", skewedColValues.toString(), tableInfo);
            }
            TreeMap skewedColMap = new TreeMap(new VectorComparator());
            skewedColMap.putAll(storageDesc.getSkewedInfo().getSkewedColValueLocationMaps());
            if (skewedColMap != null && skewedColMap.size() > 0) {
                HiveMetadataFormatUtils.formatOutput("Skewed Value to Path:", ((Object)skewedColMap).toString(), tableInfo);
                TreeMap truncatedSkewedColMap = new TreeMap(new VectorComparator());
                Set entries = skewedColMap.entrySet();
                for (Map.Entry entry : entries) {
                    truncatedSkewedColMap.put(entry.getKey(), entry.getValue());
                }
                HiveMetadataFormatUtils.formatOutput("Skewed Value to Truncated Path:", ((Object)truncatedSkewedColMap).toString(), tableInfo);
            }
        }
        if (storageDesc.getSerdeInfo().getParametersSize() > 0) {
            tableInfo.append("Storage Desc Params:").append(LINE_DELIM);
            HiveMetadataFormatUtils.displayAllParameters(storageDesc.getSerdeInfo().getParameters(), tableInfo, true, false, null);
        }
    }

    static <T> List<T> sortedList(List<T> list, Comparator<T> comp) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(list);
        Collections.sort(ret, comp);
        return ret;
    }

    static <T extends Comparable<T>> List<T> sortedList(List<T> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(list);
        Collections.sort(ret);
        return ret;
    }

    private static class VectorComparator<T extends Comparable<T>>
    implements Comparator<List<T>> {
        private VectorComparator() {
        }

        @Override
        public int compare(List<T> listA, List<T> listB) {
            for (int i = 0; i < listA.size() && i < listB.size(); ++i) {
                Comparable valA = (Comparable)listA.get(i);
                Comparable valB = (Comparable)listB.get(i);
                if (valA != null) {
                    int ret = valA.compareTo(valB);
                    if (ret == 0) continue;
                    return ret;
                }
                if (valB == null) continue;
                return -1;
            }
            return Integer.compare(listA.size(), listB.size());
        }
    }
}

