/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsPermissionChecker {
    private static final Logger LOG = LoggerFactory.getLogger(FsPermissionChecker.class);
    private static final FsPermissionChecker instance_;
    private static final Configuration CONF;
    protected final String user_;
    private final Set<String> groups_ = new HashSet<String>();
    private final String supergroup_;
    private static List<AclEntryType> ACL_TYPE_PRIORITY;

    private FsPermissionChecker() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.groups_.addAll(Arrays.asList(ugi.getGroupNames()));
        this.supergroup_ = CONF.get("dfs.permissions.superusergroup", "supergroup");
        this.user_ = ugi.getShortUserName();
    }

    private boolean isSuperUser() {
        return this.groups_.contains(this.supergroup_);
    }

    public Permissions getPermissions(FileSystem fs, Path path) throws IOException {
        Preconditions.checkNotNull((Object)fs);
        Preconditions.checkNotNull((Object)path);
        return this.getPermissions(fs, fs.getFileStatus(path));
    }

    public Permissions getPermissions(FileSystem fs, FileStatus fileStatus) throws IOException {
        AclStatus aclStatus;
        block5: {
            aclStatus = null;
            if (fileStatus.getPermission().getAclBit()) {
                try {
                    aclStatus = fs.getAclStatus(fileStatus.getPath());
                }
                catch (AclException ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("No ACLs retrieved, skipping ACLs check (HDFS will enforce ACLs)", (Throwable)ex);
                    }
                }
                catch (UnsupportedOperationException ex) {
                    if (!LOG.isTraceEnabled()) break block5;
                    LOG.trace("No ACLs retrieved, unsupported", (Throwable)ex);
                }
            }
        }
        return new Permissions(fileStatus, aclStatus);
    }

    public boolean checkAccess(Path path, FileSystem fs, FsAction action, boolean isAuthzEnabled) throws IOException {
        if (isAuthzEnabled) {
            try {
                fs.access(path, action);
            }
            catch (AccessControlException e) {
                LOG.warn(e.getMessage());
                return false;
            }
            return true;
        }
        return this.getPermissions(fs, path).checkPermissions(action);
    }

    public static FsPermissionChecker getInstance() {
        return instance_;
    }

    static {
        CONF = new Configuration();
        try {
            instance_ = new FsPermissionChecker();
        }
        catch (IOException e) {
            throw new RuntimeException("Error initializing FsPermissionChecker: " + e.getMessage(), e);
        }
        ACL_TYPE_PRIORITY = ImmutableList.of((Object)AclEntryType.USER, (Object)AclEntryType.GROUP, (Object)AclEntryType.OTHER);
    }

    public class Permissions {
        private final FileStatus fileStatus_;
        private final FsPermission permissions_;
        private final AclStatus aclStatus_;
        private Map<AclEntryType, List<AclEntry>> entriesByTypes_ = Maps.newHashMap();
        private AclEntry mask_;

        protected Permissions(FileStatus fileStatus, AclStatus aclStatus) {
            Preconditions.checkNotNull((Object)fileStatus);
            this.fileStatus_ = fileStatus;
            this.permissions_ = fileStatus.getPermission();
            this.aclStatus_ = aclStatus;
            if (this.aclStatus_ == null) {
                return;
            }
            for (AclEntryType t : ACL_TYPE_PRIORITY) {
                this.entriesByTypes_.put(t, Lists.newArrayList());
            }
            List<AclEntry> fullAclList = this.getAclFromPermAndEntries(this.permissions_, this.aclStatus_.getEntries());
            for (AclEntry e : fullAclList) {
                if (e.getType() == AclEntryType.MASK && e.getScope() != AclEntryScope.DEFAULT) {
                    this.mask_ = e;
                    continue;
                }
                if (!this.isApplicableAcl(e)) continue;
                this.entriesByTypes_.get(e.getType()).add(e);
            }
        }

        private boolean shouldApplyMask(AclEntry acl) {
            if (this.mask_ == null) {
                return false;
            }
            switch (acl.getType()) {
                case USER: {
                    return acl.getName() != null;
                }
                case GROUP: {
                    return true;
                }
            }
            return false;
        }

        private boolean isApplicableAcl(AclEntry e) {
            if (e.getScope() == AclEntryScope.DEFAULT) {
                return false;
            }
            switch (e.getType()) {
                case USER: {
                    String aclUser = e.getName() == null ? this.aclStatus_.getOwner() : e.getName();
                    return FsPermissionChecker.this.user_.equals(aclUser);
                }
                case GROUP: {
                    String aclGroup = e.getName() == null ? this.aclStatus_.getGroup() : e.getName();
                    return FsPermissionChecker.this.groups_.contains(aclGroup);
                }
                case OTHER: {
                    return true;
                }
                case MASK: {
                    return false;
                }
            }
            LOG.warn("Unknown Acl type: " + e.getType());
            return false;
        }

        private Boolean checkAcls(FsAction action) {
            if (this.aclStatus_ == null) {
                return null;
            }
            boolean foundMatch = false;
            for (AclEntryType t : ACL_TYPE_PRIORITY) {
                for (AclEntry e : this.entriesByTypes_.get(t)) {
                    if (t == AclEntryType.OTHER) {
                        return foundMatch ? false : e.getPermission().implies(action);
                    }
                    if (e.getPermission().implies(action)) {
                        if (this.shouldApplyMask(e)) {
                            if (this.mask_.getPermission().implies(action)) {
                                return true;
                            }
                        } else {
                            return true;
                        }
                    }
                    if (t == AclEntryType.USER) {
                        return false;
                    }
                    foundMatch = true;
                }
            }
            return false;
        }

        public boolean checkPermissions(FsAction action) {
            if (FsPermissionChecker.this.isSuperUser()) {
                return true;
            }
            Boolean aclPerms = this.checkAcls(action);
            if (aclPerms != null) {
                return aclPerms;
            }
            if (FsPermissionChecker.this.user_.equals(this.fileStatus_.getOwner())) {
                return this.permissions_.getUserAction().implies(action);
            }
            if (FsPermissionChecker.this.groups_.contains(this.fileStatus_.getGroup())) {
                return this.permissions_.getGroupAction().implies(action);
            }
            return this.permissions_.getOtherAction().implies(action);
        }

        public boolean canRead() {
            return this.checkPermissions(FsAction.READ);
        }

        public boolean canWrite() {
            return this.checkPermissions(FsAction.WRITE);
        }

        public boolean canReadAndWrite() {
            return this.canRead() && this.canWrite();
        }

        private List<AclEntry> getAclFromPermAndEntries(FsPermission perm, List<AclEntry> entries) {
            ArrayList aclEntries = Lists.newArrayListWithCapacity((int)(entries.size() + 3));
            aclEntries.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.USER).setPermission(perm.getUserAction()).build());
            boolean hasAccessAcl = false;
            for (AclEntry entry : entries) {
                if (entry.getScope() == AclEntryScope.DEFAULT) break;
                hasAccessAcl = true;
                aclEntries.add(entry);
            }
            aclEntries.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(hasAccessAcl ? AclEntryType.MASK : AclEntryType.GROUP).setPermission(perm.getGroupAction()).build());
            aclEntries.add(new AclEntry.Builder().setScope(AclEntryScope.ACCESS).setType(AclEntryType.OTHER).setPermission(perm.getOtherAction()).build());
            return aclEntries;
        }
    }
}

