/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;

public class FileAnalysisUtil {
    public static void CheckIfFile(Path pathToFile) throws AnalysisException {
        try {
            if (!FileSystemUtil.isFile(pathToFile)) {
                throw new AnalysisException("Cannot infer schema, path is not a file: " + pathToFile);
            }
        }
        catch (FileNotFoundException e) {
            throw new AnalysisException("Cannot infer schema, path does not exist: " + pathToFile);
        }
        catch (IOException e) {
            throw new AnalysisException("Failed to connect to filesystem:" + e);
        }
        catch (IllegalArgumentException e) {
            throw new AnalysisException(e.getMessage());
        }
    }
}

