/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.impala.analysis.Analyzer;
import org.apache.impala.analysis.BoolLiteral;
import org.apache.impala.analysis.Expr;
import org.apache.impala.analysis.FunctionCallExpr;
import org.apache.impala.analysis.SelectListItem;
import org.apache.impala.analysis.StringLiteral;
import org.apache.impala.catalog.Type;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.InternalException;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.FeSupport;
import org.apache.impala.thrift.TColumnValue;

public class ExprUtil {
    public static long utcTimestampToUnixTimeMicros(Analyzer analyzer, Expr timestampExpr) throws AnalysisException, InternalException {
        Preconditions.checkArgument((boolean)timestampExpr.isAnalyzed());
        Preconditions.checkArgument((boolean)timestampExpr.isConstant());
        Preconditions.checkArgument((timestampExpr.getType() == Type.TIMESTAMP ? 1 : 0) != 0);
        FunctionCallExpr toUnixTimeExpr = new FunctionCallExpr("utc_to_unix_micros", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{timestampExpr}));
        toUnixTimeExpr.analyze(analyzer);
        TColumnValue result = FeSupport.EvalExprWithoutRow(toUnixTimeExpr, analyzer.getQueryCtx());
        if (!result.isSetLong_val()) {
            throw new InternalException("Error converting timestamp expression: " + timestampExpr.debugString());
        }
        return result.getLong_val();
    }

    public static String utcTimestampToSpecifiedTimeZoneTimestamp(Analyzer analyzer, Expr timestampExpr) throws AnalysisException, InternalException {
        Preconditions.checkArgument((boolean)timestampExpr.isAnalyzed());
        Preconditions.checkArgument((boolean)timestampExpr.isConstant());
        Preconditions.checkArgument((timestampExpr.getType() == Type.TIMESTAMP ? 1 : 0) != 0);
        FunctionCallExpr fromUtcTimestampExpr = new FunctionCallExpr("from_utc_timestamp", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{timestampExpr, new StringLiteral(analyzer.getQueryCtx().getLocal_time_zone())}));
        fromUtcTimestampExpr.analyze(analyzer);
        TColumnValue result = FeSupport.EvalExprWithoutRow(fromUtcTimestampExpr, analyzer.getQueryCtx());
        if (!result.isSetString_val()) {
            throw new InternalException("Error converting timestamp expression: " + timestampExpr.debugString());
        }
        return result.getString_val();
    }

    public static long localTimestampToUnixTimeMicros(Analyzer analyzer, Expr timestampExpr) throws AnalysisException, InternalException {
        Preconditions.checkArgument((boolean)timestampExpr.isConstant());
        return ExprUtil.utcTimestampToUnixTimeMicros(analyzer, ExprUtil.toUtcTimestampExpr(analyzer, timestampExpr, null));
    }

    public static Long localTimestampToUnixTimeMicros(Analyzer analyzer, Expr timestampExpr, Boolean expectPreIfNonUnique) throws AnalysisException, InternalException {
        Preconditions.checkArgument((boolean)timestampExpr.isConstant());
        Expr toUtcTimestampExpr = ExprUtil.toUtcTimestampExpr(analyzer, timestampExpr, expectPreIfNonUnique);
        FunctionCallExpr toUnixTimeExpr = new FunctionCallExpr("utc_to_unix_micros", (List<Expr>)Lists.newArrayList((Object[])new Expr[]{toUtcTimestampExpr}));
        toUnixTimeExpr.analyze(analyzer);
        TColumnValue result = FeSupport.EvalExprWithoutRow(toUnixTimeExpr, analyzer.getQueryCtx());
        if (!result.isSetLong_val()) {
            return null;
        }
        return result.getLong_val();
    }

    public static String localTimestampToString(Analyzer analyzer, Expr timestampExpr) throws AnalysisException, InternalException {
        Preconditions.checkArgument((boolean)timestampExpr.isConstant());
        return ExprUtil.utcTimestampToSpecifiedTimeZoneTimestamp(analyzer, ExprUtil.toUtcTimestampExpr(analyzer, timestampExpr, null));
    }

    public static Expr toUtcTimestampExpr(Analyzer analyzer, Expr timestampExpr, Boolean expectPreIfNonUnique) throws AnalysisException {
        Preconditions.checkArgument((boolean)timestampExpr.isAnalyzed());
        Preconditions.checkArgument((timestampExpr.getType() == Type.TIMESTAMP ? 1 : 0) != 0);
        ArrayList params = Lists.newArrayList((Object[])new Expr[]{timestampExpr, new StringLiteral(analyzer.getQueryCtx().getLocal_time_zone())});
        if (expectPreIfNonUnique != null) {
            params.add(new BoolLiteral(expectPreIfNonUnique));
        }
        FunctionCallExpr toUtcTimestamp = new FunctionCallExpr("to_utc_timestamp", (List<Expr>)params);
        toUtcTimestamp.setIsInternalFnCall(true);
        toUtcTimestamp.analyze(analyzer);
        return toUtcTimestamp;
    }

    public static float computeExprsTotalCost(List<? extends Expr> exprs) {
        if (exprs == null) {
            return 0.0f;
        }
        if (BackendConfig.INSTANCE.isProcessingCostUseEqualExprWeight()) {
            return exprs.size();
        }
        float totalCost = 0.0f;
        for (Expr expr : exprs) {
            totalCost += expr.hasCost() ? expr.getCost() : 1.0f;
        }
        return totalCost;
    }

    public static float computeExprCost(Expr e) {
        if (e == null) {
            return 0.0f;
        }
        if (BackendConfig.INSTANCE.isProcessingCostUseEqualExprWeight()) {
            return 1.0f;
        }
        return e.hasCost() ? e.getCost() : 1.0f;
    }

    public static List<SelectListItem> exprsAsSelectList(List<Expr> exprs) {
        return exprs.stream().map(e -> new SelectListItem((Expr)e, null)).collect(Collectors.toList());
    }
}

