/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.impala.thrift.TExecutorGroupSet;
import org.apache.impala.thrift.TNetworkAddress;
import org.apache.impala.thrift.TUpdateExecutorMembershipRequest;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;

public class ExecutorMembershipSnapshot {
    private static AtomicReference<ExecutorMembershipSnapshot> cluster_ = new AtomicReference<ExecutorMembershipSnapshot>(new ExecutorMembershipSnapshot());
    private final Set<String> hostnames_;
    private final Set<String> ipAddresses_;
    private final int numExecutors_;
    private final List<TExecutorGroupSet> exec_group_sets_;

    private ExecutorMembershipSnapshot() {
        this.hostnames_ = Sets.newHashSet();
        this.ipAddresses_ = Sets.newHashSet();
        this.exec_group_sets_ = new ArrayList<TExecutorGroupSet>();
        this.numExecutors_ = 0;
    }

    private ExecutorMembershipSnapshot(TUpdateExecutorMembershipRequest request) {
        this.hostnames_ = request.getHostnames();
        this.ipAddresses_ = request.getIp_addresses();
        this.exec_group_sets_ = request.getExec_group_sets();
        Preconditions.checkState((!this.exec_group_sets_.isEmpty() ? 1 : 0) != 0, (Object)"Atleast one executor group set should have been specified in the membership update.");
        this.numExecutors_ = this.exec_group_sets_.get((int)0).curr_num_executors;
    }

    public boolean contains(TNetworkAddress address) {
        String host = address.getHostname();
        return this.ipAddresses_.contains(host) || this.hostnames_.contains(host);
    }

    public int numExecutors() {
        if (this.numExecutors_ == 0 && !this.exec_group_sets_.isEmpty()) {
            return this.exec_group_sets_.get((int)0).expected_num_executors;
        }
        return this.numExecutors_;
    }

    public static void update(TUpdateExecutorMembershipRequest request) {
        cluster_.set(new ExecutorMembershipSnapshot(request));
    }

    public static ExecutorMembershipSnapshot getCluster() {
        return cluster_.get();
    }

    public static List<TExecutorGroupSet> getAllExecutorGroupSets() {
        return ExecutorMembershipSnapshot.cluster_.get().exec_group_sets_;
    }
}

