/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DisjointSet<T> {
    private final Map<T, Set<T>> itemSets_ = Maps.newHashMap();
    private final IdentityHashMap<Set<T>, Object> uniqueSets_ = new IdentityHashMap();
    private static final Object DUMMY_VALUE = new Object();

    public Set<T> get(T item) {
        return this.itemSets_.get(item);
    }

    public Set<Set<T>> getSets() {
        return this.uniqueSets_.keySet();
    }

    public Set<T> makeSet(T item) {
        if (this.itemSets_.containsKey(item)) {
            throw new IllegalStateException("Item set for item already exists: " + item.toString());
        }
        HashSet s = Sets.newHashSet((Object[])new Object[]{item});
        this.itemSets_.put(item, s);
        this.uniqueSets_.put(s, DUMMY_VALUE);
        return s;
    }

    public boolean union(T a, T b) {
        Set<T> aItems = this.itemSets_.get(a);
        Set<T> bItems = this.itemSets_.get(b);
        if (aItems != null && bItems != null && aItems == bItems) {
            return false;
        }
        if (a.equals(b) && aItems == null) {
            this.makeSet(a);
            return true;
        }
        if (aItems == null) {
            aItems = this.makeSet(a);
        }
        if (bItems == null) {
            bItems = this.makeSet(b);
        }
        Set<T> mergedItems = aItems;
        Set<T> updateItems = bItems;
        if (bItems.size() > aItems.size()) {
            mergedItems = bItems;
            updateItems = aItems;
        }
        for (T item : updateItems) {
            mergedItems.add(item);
            this.itemSets_.put(item, mergedItems);
        }
        Object removedValue = this.uniqueSets_.remove(updateItems);
        Preconditions.checkState((removedValue == DUMMY_VALUE ? 1 : 0) != 0);
        return true;
    }

    public boolean bulkUnion(Collection<T> items) {
        if (items.isEmpty()) {
            return false;
        }
        Iterator<T> it = items.iterator();
        T head = it.next();
        if (!it.hasNext()) {
            if (this.get(head) != null) {
                return false;
            }
            this.makeSet(head);
            return true;
        }
        boolean result = false;
        while (it.hasNext()) {
            boolean changed = this.union(head, it.next());
            result = result || changed;
        }
        return result;
    }

    public void checkConsistency() {
        HashSet validatedSets = Sets.newHashSet();
        for (Set<T> itemSet : this.itemSets_.values()) {
            if (validatedSets.contains(itemSet)) continue;
            for (T item : itemSet) {
                if (itemSet == this.itemSets_.get(item)) continue;
                throw new IllegalStateException("DisjointSet is in an inconsistent state. Failed item set validation.");
            }
            validatedSets.add(itemSet);
        }
        HashSet seenItems = Sets.newHashSet();
        for (Set<T> itemSet : this.uniqueSets_.keySet()) {
            for (T item : itemSet) {
                if (seenItems.add(item)) continue;
                throw new IllegalStateException("DisjointSet is in an inconsistent state. Failed unique set validation.");
            }
        }
    }
}

