/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Random;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DebugUtils.class);
    private static final Random random = new Random();
    public static final String REFRESH_HDFS_LISTING_DELAY = "catalogd_refresh_hdfs_listing_delay";
    public static final String REFRESH_PAUSE_AFTER_HDFS_REMOTE_ITERATOR_CREATION = "catalogd_pause_after_hdfs_remote_iterator_creation";
    public static final String RECOVER_PARTITIONS_DELAY = "catalogd_table_recover_delay";
    public static final String UPDATE_STATS_DELAY = "catalogd_update_stats_delay";
    public static final String INSERT_FINISH_DELAY = "catalogd_insert_finish_delay";
    public static final String ICEBERG_COMMIT = "catalogd_iceberg_commit";
    public static final String ICEBERG_CREATE = "catalogd_iceberg_create";
    public static final String LOAD_FILE_METADATA_THROW_EXCEPTION = "catalogd_load_file_metadata_throw_exception";
    public static final String UPDATE_CATALOG_ABORT_INSERT_TXN = "catalogd_update_catalog_abort_txn";
    public static final String GET_FILTERED_EVENTS_DELAY = "catalogd_get_filtered_events_delay";
    public static final String EVENT_PROCESSING_DELAY = "catalogd_event_processing_delay";
    public static final String LOAD_METADATA_DELAY = "catalogd_load_metadata_delay";
    public static final String LOAD_TABLES_DELAY = "impalad_load_tables_delay";
    public static final String ENABLE_EVENT_PROCESSOR = "enable_event_processor";
    public static final String WAIT_SYNC_DDL_VER_DELAY = "catalogd_wait_sync_ddl_version_delay";

    public static boolean hasDebugAction(String debugActions, String label) {
        if (Strings.isNullOrEmpty((String)debugActions)) {
            return false;
        }
        List actions2 = Splitter.on((char)'|').splitToList((CharSequence)debugActions);
        for (String action : actions2) {
            List components = Splitter.on((char)':').splitToList((CharSequence)action);
            if (components.isEmpty() || !((String)components.get(0)).equalsIgnoreCase(label)) continue;
            return true;
        }
        return false;
    }

    public static void executeDebugAction(String debugActions, String label) {
        if (Strings.isNullOrEmpty((String)debugActions)) {
            return;
        }
        List actions2 = Splitter.on((char)'|').splitToList((CharSequence)debugActions);
        block24: for (String action : actions2) {
            List components = Splitter.on((char)':').splitToList((CharSequence)action);
            if (components.isEmpty() || !((String)components.get(0)).equalsIgnoreCase(label)) continue;
            Preconditions.checkState((components.size() > 1 ? 1 : 0) != 0, (Object)("Invalid debug action " + action));
            List actionParams = Splitter.on((char)'@').splitToList((CharSequence)components.get(1));
            Preconditions.checkState((actionParams.size() > 1 ? 1 : 0) != 0, (Object)("Illegal debug action format found in " + debugActions + " for label " + label));
            switch ((String)actionParams.get(0)) {
                case "SLEEP": {
                    Preconditions.checkState((actionParams.size() == 2 ? 1 : 0) != 0);
                    try {
                        int timeToSleepMs = Integer.parseInt(((String)actionParams.get(1)).trim());
                        LOG.trace("Sleeping for {} msec to execute debug action {}", (Object)timeToSleepMs, (Object)label);
                        Thread.sleep(timeToSleepMs);
                    }
                    catch (NumberFormatException ex) {
                        LOG.error("Invalid number format in debug action {}", (Object)action);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Sleep interrupted for the debug action {}", (Object)label);
                    }
                    continue block24;
                }
                case "JITTER": {
                    Preconditions.checkState((actionParams.size() <= 3 ? 1 : 0) != 0);
                    try {
                        int maxTimeToSleepMs = Integer.parseInt(((String)actionParams.get(1)).trim());
                        boolean shouldExecute = true;
                        if (actionParams.size() == 3) {
                            shouldExecute = DebugUtils.parseProbability((String)actionParams.get(2));
                        }
                        if (!shouldExecute) continue block24;
                        long timeToSleepMs = random.nextInt(maxTimeToSleepMs);
                        LOG.trace("Sleeping for {} msec to execute debug action {}", (Object)timeToSleepMs, (Object)action);
                        Thread.sleep(timeToSleepMs);
                    }
                    catch (NumberFormatException ex) {
                        LOG.error("Invalid number format in debug action {}", (Object)action);
                    }
                    catch (InterruptedException ex) {
                        LOG.warn("Sleep interrupted for the debug action {}", (Object)label);
                    }
                    continue block24;
                }
                case "EXCEPTION": {
                    Preconditions.checkState((actionParams.size() == 3 ? 1 : 0) != 0, (Object)"EXCEPTION debug action needs 3 action params");
                    String exceptionClazz = (String)actionParams.get(1);
                    String param = (String)actionParams.get(2);
                    CommitFailedException exceptionToThrow = null;
                    switch (exceptionClazz.toLowerCase()) {
                        case "commitfailedexception": {
                            exceptionToThrow = new CommitFailedException(param, new Object[0]);
                            break;
                        }
                        case "icebergalreadyexistsexception": {
                            exceptionToThrow = new AlreadyExistsException("Table already exists", new Object[0]);
                            break;
                        }
                        default: {
                            LOG.error("Debug action exception class {} is not implemented", (Object)exceptionClazz);
                        }
                    }
                    if (exceptionToThrow == null) continue block24;
                    LOG.info("Throwing DebugAction exception of class {}", (Object)exceptionClazz);
                    throw exceptionToThrow;
                }
            }
            LOG.error("Debug action {} is not implemented", actionParams.get(0));
        }
    }

    private static boolean parseProbability(String probability) {
        double p = Double.parseDouble(probability.trim());
        if (p <= 0.0 || p > 1.0) {
            return false;
        }
        return random.nextDouble() < p;
    }
}

