/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionUtil.class);

    public static byte[] deflateCompress(byte[] input) {
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        DeflaterOutputStream stream = new DeflaterOutputStream((OutputStream)bos, new Deflater(1)){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    this.def.end();
                }
            }
        };
        try {
            stream.write(input);
            stream.close();
        }
        catch (IOException e) {
            LOG.error("Error compressing input bytes.", (Throwable)e);
            return null;
        }
        return bos.toByteArray();
    }

    public static byte[] deflateDecompress(byte[] input) {
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)new InflaterInputStream(new ByteArrayInputStream(input)), (OutputStream)out);
        }
        catch (IOException e) {
            LOG.error("Error decompressing input bytes.", (Throwable)e);
            return null;
        }
        return out.toByteArray();
    }
}

