/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.impala.thrift.TCompressionCodec;
import org.apache.impala.thrift.TIcebergContentFileStore;
import org.apache.impala.thrift.TIcebergPartitionSpec;
import org.apache.impala.thrift.TIcebergPartitionStats;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TIcebergTable
implements TBase<TIcebergTable, _Fields>,
Serializable,
Cloneable,
Comparable<TIcebergTable> {
    private static final TStruct STRUCT_DESC = new TStruct("TIcebergTable");
    private static final TField TABLE_LOCATION_FIELD_DESC = new TField("table_location", 11, 1);
    private static final TField PARTITION_SPEC_FIELD_DESC = new TField("partition_spec", 15, 2);
    private static final TField DEFAULT_PARTITION_SPEC_ID_FIELD_DESC = new TField("default_partition_spec_id", 8, 3);
    private static final TField CONTENT_FILES_FIELD_DESC = new TField("content_files", 12, 4);
    private static final TField CATALOG_SNAPSHOT_ID_FIELD_DESC = new TField("catalog_snapshot_id", 10, 5);
    private static final TField PARQUET_COMPRESSION_CODEC_FIELD_DESC = new TField("parquet_compression_codec", 12, 6);
    private static final TField PARQUET_ROW_GROUP_SIZE_FIELD_DESC = new TField("parquet_row_group_size", 10, 7);
    private static final TField PARQUET_PLAIN_PAGE_SIZE_FIELD_DESC = new TField("parquet_plain_page_size", 10, 8);
    private static final TField PARQUET_DICT_PAGE_SIZE_FIELD_DESC = new TField("parquet_dict_page_size", 10, 9);
    private static final TField PARTITION_STATS_FIELD_DESC = new TField("partition_stats", 13, 10);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TIcebergTableStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TIcebergTableTupleSchemeFactory();
    public String table_location;
    public List<TIcebergPartitionSpec> partition_spec;
    public int default_partition_spec_id;
    public TIcebergContentFileStore content_files;
    public long catalog_snapshot_id;
    public TCompressionCodec parquet_compression_codec;
    public long parquet_row_group_size;
    public long parquet_plain_page_size;
    public long parquet_dict_page_size;
    public Map<String, TIcebergPartitionStats> partition_stats;
    private static final int __DEFAULT_PARTITION_SPEC_ID_ISSET_ID = 0;
    private static final int __CATALOG_SNAPSHOT_ID_ISSET_ID = 1;
    private static final int __PARQUET_ROW_GROUP_SIZE_ISSET_ID = 2;
    private static final int __PARQUET_PLAIN_PAGE_SIZE_ISSET_ID = 3;
    private static final int __PARQUET_DICT_PAGE_SIZE_ISSET_ID = 4;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.CONTENT_FILES, _Fields.CATALOG_SNAPSHOT_ID, _Fields.PARQUET_COMPRESSION_CODEC, _Fields.PARQUET_ROW_GROUP_SIZE, _Fields.PARQUET_PLAIN_PAGE_SIZE, _Fields.PARQUET_DICT_PAGE_SIZE, _Fields.PARTITION_STATS};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TIcebergTable() {
    }

    public TIcebergTable(String table_location, List<TIcebergPartitionSpec> partition_spec, int default_partition_spec_id) {
        this();
        this.table_location = table_location;
        this.partition_spec = partition_spec;
        this.default_partition_spec_id = default_partition_spec_id;
        this.setDefault_partition_spec_idIsSet(true);
    }

    public TIcebergTable(TIcebergTable other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetTable_location()) {
            this.table_location = other.table_location;
        }
        if (other.isSetPartition_spec()) {
            ArrayList<TIcebergPartitionSpec> __this__partition_spec = new ArrayList<TIcebergPartitionSpec>(other.partition_spec.size());
            for (TIcebergPartitionSpec tIcebergPartitionSpec : other.partition_spec) {
                __this__partition_spec.add(new TIcebergPartitionSpec(tIcebergPartitionSpec));
            }
            this.partition_spec = __this__partition_spec;
        }
        this.default_partition_spec_id = other.default_partition_spec_id;
        if (other.isSetContent_files()) {
            this.content_files = new TIcebergContentFileStore(other.content_files);
        }
        this.catalog_snapshot_id = other.catalog_snapshot_id;
        if (other.isSetParquet_compression_codec()) {
            this.parquet_compression_codec = new TCompressionCodec(other.parquet_compression_codec);
        }
        this.parquet_row_group_size = other.parquet_row_group_size;
        this.parquet_plain_page_size = other.parquet_plain_page_size;
        this.parquet_dict_page_size = other.parquet_dict_page_size;
        if (other.isSetPartition_stats()) {
            HashMap<String, TIcebergPartitionStats> __this__partition_stats = new HashMap<String, TIcebergPartitionStats>(other.partition_stats.size());
            for (Map.Entry entry : other.partition_stats.entrySet()) {
                String other_element_key = (String)entry.getKey();
                TIcebergPartitionStats other_element_value = (TIcebergPartitionStats)entry.getValue();
                String __this__partition_stats_copy_key = other_element_key;
                TIcebergPartitionStats __this__partition_stats_copy_value = new TIcebergPartitionStats(other_element_value);
                __this__partition_stats.put(__this__partition_stats_copy_key, __this__partition_stats_copy_value);
            }
            this.partition_stats = __this__partition_stats;
        }
    }

    public TIcebergTable deepCopy() {
        return new TIcebergTable(this);
    }

    public void clear() {
        this.table_location = null;
        this.partition_spec = null;
        this.setDefault_partition_spec_idIsSet(false);
        this.default_partition_spec_id = 0;
        this.content_files = null;
        this.setCatalog_snapshot_idIsSet(false);
        this.catalog_snapshot_id = 0L;
        this.parquet_compression_codec = null;
        this.setParquet_row_group_sizeIsSet(false);
        this.parquet_row_group_size = 0L;
        this.setParquet_plain_page_sizeIsSet(false);
        this.parquet_plain_page_size = 0L;
        this.setParquet_dict_page_sizeIsSet(false);
        this.parquet_dict_page_size = 0L;
        this.partition_stats = null;
    }

    public String getTable_location() {
        return this.table_location;
    }

    public TIcebergTable setTable_location(String table_location) {
        this.table_location = table_location;
        return this;
    }

    public void unsetTable_location() {
        this.table_location = null;
    }

    public boolean isSetTable_location() {
        return this.table_location != null;
    }

    public void setTable_locationIsSet(boolean value) {
        if (!value) {
            this.table_location = null;
        }
    }

    public int getPartition_specSize() {
        return this.partition_spec == null ? 0 : this.partition_spec.size();
    }

    public Iterator<TIcebergPartitionSpec> getPartition_specIterator() {
        return this.partition_spec == null ? null : this.partition_spec.iterator();
    }

    public void addToPartition_spec(TIcebergPartitionSpec elem) {
        if (this.partition_spec == null) {
            this.partition_spec = new ArrayList<TIcebergPartitionSpec>();
        }
        this.partition_spec.add(elem);
    }

    public List<TIcebergPartitionSpec> getPartition_spec() {
        return this.partition_spec;
    }

    public TIcebergTable setPartition_spec(List<TIcebergPartitionSpec> partition_spec) {
        this.partition_spec = partition_spec;
        return this;
    }

    public void unsetPartition_spec() {
        this.partition_spec = null;
    }

    public boolean isSetPartition_spec() {
        return this.partition_spec != null;
    }

    public void setPartition_specIsSet(boolean value) {
        if (!value) {
            this.partition_spec = null;
        }
    }

    public int getDefault_partition_spec_id() {
        return this.default_partition_spec_id;
    }

    public TIcebergTable setDefault_partition_spec_id(int default_partition_spec_id) {
        this.default_partition_spec_id = default_partition_spec_id;
        this.setDefault_partition_spec_idIsSet(true);
        return this;
    }

    public void unsetDefault_partition_spec_id() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetDefault_partition_spec_id() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setDefault_partition_spec_idIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public TIcebergContentFileStore getContent_files() {
        return this.content_files;
    }

    public TIcebergTable setContent_files(TIcebergContentFileStore content_files) {
        this.content_files = content_files;
        return this;
    }

    public void unsetContent_files() {
        this.content_files = null;
    }

    public boolean isSetContent_files() {
        return this.content_files != null;
    }

    public void setContent_filesIsSet(boolean value) {
        if (!value) {
            this.content_files = null;
        }
    }

    public long getCatalog_snapshot_id() {
        return this.catalog_snapshot_id;
    }

    public TIcebergTable setCatalog_snapshot_id(long catalog_snapshot_id) {
        this.catalog_snapshot_id = catalog_snapshot_id;
        this.setCatalog_snapshot_idIsSet(true);
        return this;
    }

    public void unsetCatalog_snapshot_id() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetCatalog_snapshot_id() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setCatalog_snapshot_idIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public TCompressionCodec getParquet_compression_codec() {
        return this.parquet_compression_codec;
    }

    public TIcebergTable setParquet_compression_codec(TCompressionCodec parquet_compression_codec) {
        this.parquet_compression_codec = parquet_compression_codec;
        return this;
    }

    public void unsetParquet_compression_codec() {
        this.parquet_compression_codec = null;
    }

    public boolean isSetParquet_compression_codec() {
        return this.parquet_compression_codec != null;
    }

    public void setParquet_compression_codecIsSet(boolean value) {
        if (!value) {
            this.parquet_compression_codec = null;
        }
    }

    public long getParquet_row_group_size() {
        return this.parquet_row_group_size;
    }

    public TIcebergTable setParquet_row_group_size(long parquet_row_group_size) {
        this.parquet_row_group_size = parquet_row_group_size;
        this.setParquet_row_group_sizeIsSet(true);
        return this;
    }

    public void unsetParquet_row_group_size() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetParquet_row_group_size() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setParquet_row_group_sizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public long getParquet_plain_page_size() {
        return this.parquet_plain_page_size;
    }

    public TIcebergTable setParquet_plain_page_size(long parquet_plain_page_size) {
        this.parquet_plain_page_size = parquet_plain_page_size;
        this.setParquet_plain_page_sizeIsSet(true);
        return this;
    }

    public void unsetParquet_plain_page_size() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetParquet_plain_page_size() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setParquet_plain_page_sizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public long getParquet_dict_page_size() {
        return this.parquet_dict_page_size;
    }

    public TIcebergTable setParquet_dict_page_size(long parquet_dict_page_size) {
        this.parquet_dict_page_size = parquet_dict_page_size;
        this.setParquet_dict_page_sizeIsSet(true);
        return this;
    }

    public void unsetParquet_dict_page_size() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetParquet_dict_page_size() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setParquet_dict_page_sizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public int getPartition_statsSize() {
        return this.partition_stats == null ? 0 : this.partition_stats.size();
    }

    public void putToPartition_stats(String key, TIcebergPartitionStats val) {
        if (this.partition_stats == null) {
            this.partition_stats = new HashMap<String, TIcebergPartitionStats>();
        }
        this.partition_stats.put(key, val);
    }

    public Map<String, TIcebergPartitionStats> getPartition_stats() {
        return this.partition_stats;
    }

    public TIcebergTable setPartition_stats(Map<String, TIcebergPartitionStats> partition_stats) {
        this.partition_stats = partition_stats;
        return this;
    }

    public void unsetPartition_stats() {
        this.partition_stats = null;
    }

    public boolean isSetPartition_stats() {
        return this.partition_stats != null;
    }

    public void setPartition_statsIsSet(boolean value) {
        if (!value) {
            this.partition_stats = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TABLE_LOCATION: {
                if (value == null) {
                    this.unsetTable_location();
                    break;
                }
                this.setTable_location((String)value);
                break;
            }
            case PARTITION_SPEC: {
                if (value == null) {
                    this.unsetPartition_spec();
                    break;
                }
                this.setPartition_spec((List)value);
                break;
            }
            case DEFAULT_PARTITION_SPEC_ID: {
                if (value == null) {
                    this.unsetDefault_partition_spec_id();
                    break;
                }
                this.setDefault_partition_spec_id((Integer)value);
                break;
            }
            case CONTENT_FILES: {
                if (value == null) {
                    this.unsetContent_files();
                    break;
                }
                this.setContent_files((TIcebergContentFileStore)value);
                break;
            }
            case CATALOG_SNAPSHOT_ID: {
                if (value == null) {
                    this.unsetCatalog_snapshot_id();
                    break;
                }
                this.setCatalog_snapshot_id((Long)value);
                break;
            }
            case PARQUET_COMPRESSION_CODEC: {
                if (value == null) {
                    this.unsetParquet_compression_codec();
                    break;
                }
                this.setParquet_compression_codec((TCompressionCodec)value);
                break;
            }
            case PARQUET_ROW_GROUP_SIZE: {
                if (value == null) {
                    this.unsetParquet_row_group_size();
                    break;
                }
                this.setParquet_row_group_size((Long)value);
                break;
            }
            case PARQUET_PLAIN_PAGE_SIZE: {
                if (value == null) {
                    this.unsetParquet_plain_page_size();
                    break;
                }
                this.setParquet_plain_page_size((Long)value);
                break;
            }
            case PARQUET_DICT_PAGE_SIZE: {
                if (value == null) {
                    this.unsetParquet_dict_page_size();
                    break;
                }
                this.setParquet_dict_page_size((Long)value);
                break;
            }
            case PARTITION_STATS: {
                if (value == null) {
                    this.unsetPartition_stats();
                    break;
                }
                this.setPartition_stats((Map)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLE_LOCATION: {
                return this.getTable_location();
            }
            case PARTITION_SPEC: {
                return this.getPartition_spec();
            }
            case DEFAULT_PARTITION_SPEC_ID: {
                return this.getDefault_partition_spec_id();
            }
            case CONTENT_FILES: {
                return this.getContent_files();
            }
            case CATALOG_SNAPSHOT_ID: {
                return this.getCatalog_snapshot_id();
            }
            case PARQUET_COMPRESSION_CODEC: {
                return this.getParquet_compression_codec();
            }
            case PARQUET_ROW_GROUP_SIZE: {
                return this.getParquet_row_group_size();
            }
            case PARQUET_PLAIN_PAGE_SIZE: {
                return this.getParquet_plain_page_size();
            }
            case PARQUET_DICT_PAGE_SIZE: {
                return this.getParquet_dict_page_size();
            }
            case PARTITION_STATS: {
                return this.getPartition_stats();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLE_LOCATION: {
                return this.isSetTable_location();
            }
            case PARTITION_SPEC: {
                return this.isSetPartition_spec();
            }
            case DEFAULT_PARTITION_SPEC_ID: {
                return this.isSetDefault_partition_spec_id();
            }
            case CONTENT_FILES: {
                return this.isSetContent_files();
            }
            case CATALOG_SNAPSHOT_ID: {
                return this.isSetCatalog_snapshot_id();
            }
            case PARQUET_COMPRESSION_CODEC: {
                return this.isSetParquet_compression_codec();
            }
            case PARQUET_ROW_GROUP_SIZE: {
                return this.isSetParquet_row_group_size();
            }
            case PARQUET_PLAIN_PAGE_SIZE: {
                return this.isSetParquet_plain_page_size();
            }
            case PARQUET_DICT_PAGE_SIZE: {
                return this.isSetParquet_dict_page_size();
            }
            case PARTITION_STATS: {
                return this.isSetPartition_stats();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TIcebergTable) {
            return this.equals((TIcebergTable)that);
        }
        return false;
    }

    public boolean equals(TIcebergTable that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_table_location = this.isSetTable_location();
        boolean that_present_table_location = that.isSetTable_location();
        if (this_present_table_location || that_present_table_location) {
            if (!this_present_table_location || !that_present_table_location) {
                return false;
            }
            if (!this.table_location.equals(that.table_location)) {
                return false;
            }
        }
        boolean this_present_partition_spec = this.isSetPartition_spec();
        boolean that_present_partition_spec = that.isSetPartition_spec();
        if (this_present_partition_spec || that_present_partition_spec) {
            if (!this_present_partition_spec || !that_present_partition_spec) {
                return false;
            }
            if (!this.partition_spec.equals(that.partition_spec)) {
                return false;
            }
        }
        boolean this_present_default_partition_spec_id = true;
        boolean that_present_default_partition_spec_id = true;
        if (this_present_default_partition_spec_id || that_present_default_partition_spec_id) {
            if (!this_present_default_partition_spec_id || !that_present_default_partition_spec_id) {
                return false;
            }
            if (this.default_partition_spec_id != that.default_partition_spec_id) {
                return false;
            }
        }
        boolean this_present_content_files = this.isSetContent_files();
        boolean that_present_content_files = that.isSetContent_files();
        if (this_present_content_files || that_present_content_files) {
            if (!this_present_content_files || !that_present_content_files) {
                return false;
            }
            if (!this.content_files.equals(that.content_files)) {
                return false;
            }
        }
        boolean this_present_catalog_snapshot_id = this.isSetCatalog_snapshot_id();
        boolean that_present_catalog_snapshot_id = that.isSetCatalog_snapshot_id();
        if (this_present_catalog_snapshot_id || that_present_catalog_snapshot_id) {
            if (!this_present_catalog_snapshot_id || !that_present_catalog_snapshot_id) {
                return false;
            }
            if (this.catalog_snapshot_id != that.catalog_snapshot_id) {
                return false;
            }
        }
        boolean this_present_parquet_compression_codec = this.isSetParquet_compression_codec();
        boolean that_present_parquet_compression_codec = that.isSetParquet_compression_codec();
        if (this_present_parquet_compression_codec || that_present_parquet_compression_codec) {
            if (!this_present_parquet_compression_codec || !that_present_parquet_compression_codec) {
                return false;
            }
            if (!this.parquet_compression_codec.equals(that.parquet_compression_codec)) {
                return false;
            }
        }
        boolean this_present_parquet_row_group_size = this.isSetParquet_row_group_size();
        boolean that_present_parquet_row_group_size = that.isSetParquet_row_group_size();
        if (this_present_parquet_row_group_size || that_present_parquet_row_group_size) {
            if (!this_present_parquet_row_group_size || !that_present_parquet_row_group_size) {
                return false;
            }
            if (this.parquet_row_group_size != that.parquet_row_group_size) {
                return false;
            }
        }
        boolean this_present_parquet_plain_page_size = this.isSetParquet_plain_page_size();
        boolean that_present_parquet_plain_page_size = that.isSetParquet_plain_page_size();
        if (this_present_parquet_plain_page_size || that_present_parquet_plain_page_size) {
            if (!this_present_parquet_plain_page_size || !that_present_parquet_plain_page_size) {
                return false;
            }
            if (this.parquet_plain_page_size != that.parquet_plain_page_size) {
                return false;
            }
        }
        boolean this_present_parquet_dict_page_size = this.isSetParquet_dict_page_size();
        boolean that_present_parquet_dict_page_size = that.isSetParquet_dict_page_size();
        if (this_present_parquet_dict_page_size || that_present_parquet_dict_page_size) {
            if (!this_present_parquet_dict_page_size || !that_present_parquet_dict_page_size) {
                return false;
            }
            if (this.parquet_dict_page_size != that.parquet_dict_page_size) {
                return false;
            }
        }
        boolean this_present_partition_stats = this.isSetPartition_stats();
        boolean that_present_partition_stats = that.isSetPartition_stats();
        if (this_present_partition_stats || that_present_partition_stats) {
            if (!this_present_partition_stats || !that_present_partition_stats) {
                return false;
            }
            if (!this.partition_stats.equals(that.partition_stats)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetTable_location() ? 131071 : 524287);
        if (this.isSetTable_location()) {
            hashCode = hashCode * 8191 + this.table_location.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPartition_spec() ? 131071 : 524287);
        if (this.isSetPartition_spec()) {
            hashCode = hashCode * 8191 + this.partition_spec.hashCode();
        }
        hashCode = hashCode * 8191 + this.default_partition_spec_id;
        hashCode = hashCode * 8191 + (this.isSetContent_files() ? 131071 : 524287);
        if (this.isSetContent_files()) {
            hashCode = hashCode * 8191 + this.content_files.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCatalog_snapshot_id() ? 131071 : 524287);
        if (this.isSetCatalog_snapshot_id()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.catalog_snapshot_id);
        }
        hashCode = hashCode * 8191 + (this.isSetParquet_compression_codec() ? 131071 : 524287);
        if (this.isSetParquet_compression_codec()) {
            hashCode = hashCode * 8191 + this.parquet_compression_codec.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetParquet_row_group_size() ? 131071 : 524287);
        if (this.isSetParquet_row_group_size()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.parquet_row_group_size);
        }
        hashCode = hashCode * 8191 + (this.isSetParquet_plain_page_size() ? 131071 : 524287);
        if (this.isSetParquet_plain_page_size()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.parquet_plain_page_size);
        }
        hashCode = hashCode * 8191 + (this.isSetParquet_dict_page_size() ? 131071 : 524287);
        if (this.isSetParquet_dict_page_size()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.parquet_dict_page_size);
        }
        hashCode = hashCode * 8191 + (this.isSetPartition_stats() ? 131071 : 524287);
        if (this.isSetPartition_stats()) {
            hashCode = hashCode * 8191 + this.partition_stats.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TIcebergTable other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetTable_location()).compareTo(other.isSetTable_location());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTable_location() && (lastComparison = TBaseHelper.compareTo((String)this.table_location, (String)other.table_location)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPartition_spec()).compareTo(other.isSetPartition_spec());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartition_spec() && (lastComparison = TBaseHelper.compareTo(this.partition_spec, other.partition_spec)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDefault_partition_spec_id()).compareTo(other.isSetDefault_partition_spec_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefault_partition_spec_id() && (lastComparison = TBaseHelper.compareTo((int)this.default_partition_spec_id, (int)other.default_partition_spec_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetContent_files()).compareTo(other.isSetContent_files());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetContent_files() && (lastComparison = TBaseHelper.compareTo((Comparable)this.content_files, (Comparable)other.content_files)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCatalog_snapshot_id()).compareTo(other.isSetCatalog_snapshot_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCatalog_snapshot_id() && (lastComparison = TBaseHelper.compareTo((long)this.catalog_snapshot_id, (long)other.catalog_snapshot_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParquet_compression_codec()).compareTo(other.isSetParquet_compression_codec());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParquet_compression_codec() && (lastComparison = TBaseHelper.compareTo((Comparable)this.parquet_compression_codec, (Comparable)other.parquet_compression_codec)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParquet_row_group_size()).compareTo(other.isSetParquet_row_group_size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParquet_row_group_size() && (lastComparison = TBaseHelper.compareTo((long)this.parquet_row_group_size, (long)other.parquet_row_group_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParquet_plain_page_size()).compareTo(other.isSetParquet_plain_page_size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParquet_plain_page_size() && (lastComparison = TBaseHelper.compareTo((long)this.parquet_plain_page_size, (long)other.parquet_plain_page_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParquet_dict_page_size()).compareTo(other.isSetParquet_dict_page_size());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParquet_dict_page_size() && (lastComparison = TBaseHelper.compareTo((long)this.parquet_dict_page_size, (long)other.parquet_dict_page_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPartition_stats()).compareTo(other.isSetPartition_stats());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartition_stats() && (lastComparison = TBaseHelper.compareTo(this.partition_stats, other.partition_stats)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TIcebergTable.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TIcebergTable.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TIcebergTable(");
        boolean first = true;
        sb.append("table_location:");
        if (this.table_location == null) {
            sb.append("null");
        } else {
            sb.append(this.table_location);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("partition_spec:");
        if (this.partition_spec == null) {
            sb.append("null");
        } else {
            sb.append(this.partition_spec);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("default_partition_spec_id:");
        sb.append(this.default_partition_spec_id);
        first = false;
        if (this.isSetContent_files()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("content_files:");
            if (this.content_files == null) {
                sb.append("null");
            } else {
                sb.append(this.content_files);
            }
            first = false;
        }
        if (this.isSetCatalog_snapshot_id()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("catalog_snapshot_id:");
            sb.append(this.catalog_snapshot_id);
            first = false;
        }
        if (this.isSetParquet_compression_codec()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("parquet_compression_codec:");
            if (this.parquet_compression_codec == null) {
                sb.append("null");
            } else {
                sb.append(this.parquet_compression_codec);
            }
            first = false;
        }
        if (this.isSetParquet_row_group_size()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("parquet_row_group_size:");
            sb.append(this.parquet_row_group_size);
            first = false;
        }
        if (this.isSetParquet_plain_page_size()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("parquet_plain_page_size:");
            sb.append(this.parquet_plain_page_size);
            first = false;
        }
        if (this.isSetParquet_dict_page_size()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("parquet_dict_page_size:");
            sb.append(this.parquet_dict_page_size);
            first = false;
        }
        if (this.isSetPartition_stats()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("partition_stats:");
            if (this.partition_stats == null) {
                sb.append("null");
            } else {
                sb.append(this.partition_stats);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.table_location == null) {
            throw new TProtocolException("Required field 'table_location' was not present! Struct: " + this.toString());
        }
        if (this.partition_spec == null) {
            throw new TProtocolException("Required field 'partition_spec' was not present! Struct: " + this.toString());
        }
        if (this.content_files != null) {
            this.content_files.validate();
        }
        if (this.parquet_compression_codec != null) {
            this.parquet_compression_codec.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLE_LOCATION, new FieldMetaData("table_location", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PARTITION_SPEC, new FieldMetaData("partition_spec", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TIcebergPartitionSpec.class))));
        tmpMap.put(_Fields.DEFAULT_PARTITION_SPEC_ID, new FieldMetaData("default_partition_spec_id", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.CONTENT_FILES, new FieldMetaData("content_files", 2, (FieldValueMetaData)new StructMetaData(12, TIcebergContentFileStore.class)));
        tmpMap.put(_Fields.CATALOG_SNAPSHOT_ID, new FieldMetaData("catalog_snapshot_id", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.PARQUET_COMPRESSION_CODEC, new FieldMetaData("parquet_compression_codec", 2, (FieldValueMetaData)new StructMetaData(12, TCompressionCodec.class)));
        tmpMap.put(_Fields.PARQUET_ROW_GROUP_SIZE, new FieldMetaData("parquet_row_group_size", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.PARQUET_PLAIN_PAGE_SIZE, new FieldMetaData("parquet_plain_page_size", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.PARQUET_DICT_PAGE_SIZE, new FieldMetaData("parquet_dict_page_size", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.PARTITION_STATS, new FieldMetaData("partition_stats", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), (FieldValueMetaData)new StructMetaData(12, TIcebergPartitionStats.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TIcebergTable.class, metaDataMap);
    }

    private static class TIcebergTableTupleScheme
    extends TupleScheme<TIcebergTable> {
        private TIcebergTableTupleScheme() {
        }

        public void write(TProtocol prot, TIcebergTable struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.table_location);
            oprot.writeI32(struct.partition_spec.size());
            for (TIcebergPartitionSpec _iter279 : struct.partition_spec) {
                _iter279.write((TProtocol)oprot);
            }
            oprot.writeI32(struct.default_partition_spec_id);
            BitSet optionals = new BitSet();
            if (struct.isSetContent_files()) {
                optionals.set(0);
            }
            if (struct.isSetCatalog_snapshot_id()) {
                optionals.set(1);
            }
            if (struct.isSetParquet_compression_codec()) {
                optionals.set(2);
            }
            if (struct.isSetParquet_row_group_size()) {
                optionals.set(3);
            }
            if (struct.isSetParquet_plain_page_size()) {
                optionals.set(4);
            }
            if (struct.isSetParquet_dict_page_size()) {
                optionals.set(5);
            }
            if (struct.isSetPartition_stats()) {
                optionals.set(6);
            }
            oprot.writeBitSet(optionals, 7);
            if (struct.isSetContent_files()) {
                struct.content_files.write((TProtocol)oprot);
            }
            if (struct.isSetCatalog_snapshot_id()) {
                oprot.writeI64(struct.catalog_snapshot_id);
            }
            if (struct.isSetParquet_compression_codec()) {
                struct.parquet_compression_codec.write((TProtocol)oprot);
            }
            if (struct.isSetParquet_row_group_size()) {
                oprot.writeI64(struct.parquet_row_group_size);
            }
            if (struct.isSetParquet_plain_page_size()) {
                oprot.writeI64(struct.parquet_plain_page_size);
            }
            if (struct.isSetParquet_dict_page_size()) {
                oprot.writeI64(struct.parquet_dict_page_size);
            }
            if (struct.isSetPartition_stats()) {
                oprot.writeI32(struct.partition_stats.size());
                for (Map.Entry<String, TIcebergPartitionStats> _iter280 : struct.partition_stats.entrySet()) {
                    oprot.writeString(_iter280.getKey());
                    _iter280.getValue().write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, TIcebergTable struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.table_location = iprot.readString();
            struct.setTable_locationIsSet(true);
            TList _list281 = new TList(12, iprot.readI32());
            struct.partition_spec = new ArrayList<TIcebergPartitionSpec>(_list281.size);
            for (int _i283 = 0; _i283 < _list281.size; ++_i283) {
                TIcebergPartitionSpec _elem282 = new TIcebergPartitionSpec();
                _elem282.read((TProtocol)iprot);
                struct.partition_spec.add(_elem282);
            }
            struct.setPartition_specIsSet(true);
            struct.default_partition_spec_id = iprot.readI32();
            struct.setDefault_partition_spec_idIsSet(true);
            BitSet incoming = iprot.readBitSet(7);
            if (incoming.get(0)) {
                struct.content_files = new TIcebergContentFileStore();
                struct.content_files.read((TProtocol)iprot);
                struct.setContent_filesIsSet(true);
            }
            if (incoming.get(1)) {
                struct.catalog_snapshot_id = iprot.readI64();
                struct.setCatalog_snapshot_idIsSet(true);
            }
            if (incoming.get(2)) {
                struct.parquet_compression_codec = new TCompressionCodec();
                struct.parquet_compression_codec.read((TProtocol)iprot);
                struct.setParquet_compression_codecIsSet(true);
            }
            if (incoming.get(3)) {
                struct.parquet_row_group_size = iprot.readI64();
                struct.setParquet_row_group_sizeIsSet(true);
            }
            if (incoming.get(4)) {
                struct.parquet_plain_page_size = iprot.readI64();
                struct.setParquet_plain_page_sizeIsSet(true);
            }
            if (incoming.get(5)) {
                struct.parquet_dict_page_size = iprot.readI64();
                struct.setParquet_dict_page_sizeIsSet(true);
            }
            if (incoming.get(6)) {
                TMap _map284 = new TMap(11, 12, iprot.readI32());
                struct.partition_stats = new HashMap<String, TIcebergPartitionStats>(2 * _map284.size);
                for (int _i287 = 0; _i287 < _map284.size; ++_i287) {
                    String _key285 = iprot.readString();
                    TIcebergPartitionStats _val286 = new TIcebergPartitionStats();
                    _val286.read((TProtocol)iprot);
                    struct.partition_stats.put(_key285, _val286);
                }
                struct.setPartition_statsIsSet(true);
            }
        }
    }

    private static class TIcebergTableTupleSchemeFactory
    implements SchemeFactory {
        private TIcebergTableTupleSchemeFactory() {
        }

        public TIcebergTableTupleScheme getScheme() {
            return new TIcebergTableTupleScheme();
        }
    }

    private static class TIcebergTableStandardScheme
    extends StandardScheme<TIcebergTable> {
        private TIcebergTableStandardScheme() {
        }

        public void read(TProtocol iprot, TIcebergTable struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.table_location = iprot.readString();
                            struct.setTable_locationIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list270 = iprot.readListBegin();
                            struct.partition_spec = new ArrayList<TIcebergPartitionSpec>(_list270.size);
                            for (int _i272 = 0; _i272 < _list270.size; ++_i272) {
                                TIcebergPartitionSpec _elem271 = new TIcebergPartitionSpec();
                                _elem271.read(iprot);
                                struct.partition_spec.add(_elem271);
                            }
                            iprot.readListEnd();
                            struct.setPartition_specIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.default_partition_spec_id = iprot.readI32();
                            struct.setDefault_partition_spec_idIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.content_files = new TIcebergContentFileStore();
                            struct.content_files.read(iprot);
                            struct.setContent_filesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.catalog_snapshot_id = iprot.readI64();
                            struct.setCatalog_snapshot_idIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 12) {
                            struct.parquet_compression_codec = new TCompressionCodec();
                            struct.parquet_compression_codec.read(iprot);
                            struct.setParquet_compression_codecIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 10) {
                            struct.parquet_row_group_size = iprot.readI64();
                            struct.setParquet_row_group_sizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.parquet_plain_page_size = iprot.readI64();
                            struct.setParquet_plain_page_sizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.parquet_dict_page_size = iprot.readI64();
                            struct.setParquet_dict_page_sizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 13) {
                            TMap _map273 = iprot.readMapBegin();
                            struct.partition_stats = new HashMap<String, TIcebergPartitionStats>(2 * _map273.size);
                            for (int _i276 = 0; _i276 < _map273.size; ++_i276) {
                                String _key274 = iprot.readString();
                                TIcebergPartitionStats _val275 = new TIcebergPartitionStats();
                                _val275.read(iprot);
                                struct.partition_stats.put(_key274, _val275);
                            }
                            iprot.readMapEnd();
                            struct.setPartition_statsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetDefault_partition_spec_id()) {
                throw new TProtocolException("Required field 'default_partition_spec_id' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TIcebergTable struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.table_location != null) {
                oprot.writeFieldBegin(TABLE_LOCATION_FIELD_DESC);
                oprot.writeString(struct.table_location);
                oprot.writeFieldEnd();
            }
            if (struct.partition_spec != null) {
                oprot.writeFieldBegin(PARTITION_SPEC_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.partition_spec.size()));
                for (TIcebergPartitionSpec tIcebergPartitionSpec : struct.partition_spec) {
                    tIcebergPartitionSpec.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(DEFAULT_PARTITION_SPEC_ID_FIELD_DESC);
            oprot.writeI32(struct.default_partition_spec_id);
            oprot.writeFieldEnd();
            if (struct.content_files != null && struct.isSetContent_files()) {
                oprot.writeFieldBegin(CONTENT_FILES_FIELD_DESC);
                struct.content_files.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetCatalog_snapshot_id()) {
                oprot.writeFieldBegin(CATALOG_SNAPSHOT_ID_FIELD_DESC);
                oprot.writeI64(struct.catalog_snapshot_id);
                oprot.writeFieldEnd();
            }
            if (struct.parquet_compression_codec != null && struct.isSetParquet_compression_codec()) {
                oprot.writeFieldBegin(PARQUET_COMPRESSION_CODEC_FIELD_DESC);
                struct.parquet_compression_codec.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetParquet_row_group_size()) {
                oprot.writeFieldBegin(PARQUET_ROW_GROUP_SIZE_FIELD_DESC);
                oprot.writeI64(struct.parquet_row_group_size);
                oprot.writeFieldEnd();
            }
            if (struct.isSetParquet_plain_page_size()) {
                oprot.writeFieldBegin(PARQUET_PLAIN_PAGE_SIZE_FIELD_DESC);
                oprot.writeI64(struct.parquet_plain_page_size);
                oprot.writeFieldEnd();
            }
            if (struct.isSetParquet_dict_page_size()) {
                oprot.writeFieldBegin(PARQUET_DICT_PAGE_SIZE_FIELD_DESC);
                oprot.writeI64(struct.parquet_dict_page_size);
                oprot.writeFieldEnd();
            }
            if (struct.partition_stats != null && struct.isSetPartition_stats()) {
                oprot.writeFieldBegin(PARTITION_STATS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 12, struct.partition_stats.size()));
                for (Map.Entry entry : struct.partition_stats.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    ((TIcebergPartitionStats)entry.getValue()).write(oprot);
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TIcebergTableStandardSchemeFactory
    implements SchemeFactory {
        private TIcebergTableStandardSchemeFactory() {
        }

        public TIcebergTableStandardScheme getScheme() {
            return new TIcebergTableStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLE_LOCATION(1, "table_location"),
        PARTITION_SPEC(2, "partition_spec"),
        DEFAULT_PARTITION_SPEC_ID(3, "default_partition_spec_id"),
        CONTENT_FILES(4, "content_files"),
        CATALOG_SNAPSHOT_ID(5, "catalog_snapshot_id"),
        PARQUET_COMPRESSION_CODEC(6, "parquet_compression_codec"),
        PARQUET_ROW_GROUP_SIZE(7, "parquet_row_group_size"),
        PARQUET_PLAIN_PAGE_SIZE(8, "parquet_plain_page_size"),
        PARQUET_DICT_PAGE_SIZE(9, "parquet_dict_page_size"),
        PARTITION_STATS(10, "partition_stats");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLE_LOCATION;
                }
                case 2: {
                    return PARTITION_SPEC;
                }
                case 3: {
                    return DEFAULT_PARTITION_SPEC_ID;
                }
                case 4: {
                    return CONTENT_FILES;
                }
                case 5: {
                    return CATALOG_SNAPSHOT_ID;
                }
                case 6: {
                    return PARQUET_COMPRESSION_CODEC;
                }
                case 7: {
                    return PARQUET_ROW_GROUP_SIZE;
                }
                case 8: {
                    return PARQUET_PLAIN_PAGE_SIZE;
                }
                case 9: {
                    return PARQUET_DICT_PAGE_SIZE;
                }
                case 10: {
                    return PARTITION_STATS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

