/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.thrift;

import org.apache.thrift.TEnum;

public enum TExprNodeType implements TEnum
{
    NULL_LITERAL(0),
    BOOL_LITERAL(1),
    INT_LITERAL(2),
    FLOAT_LITERAL(3),
    STRING_LITERAL(4),
    DECIMAL_LITERAL(5),
    TIMESTAMP_LITERAL(6),
    CASE_EXPR(7),
    COMPOUND_PRED(8),
    IN_PRED(9),
    IS_NULL_PRED(10),
    LIKE_PRED(11),
    SLOT_REF(12),
    TUPLE_IS_NULL_PRED(13),
    FUNCTION_CALL(14),
    AGGREGATE_EXPR(15),
    IS_NOT_EMPTY_PRED(16),
    KUDU_PARTITION_EXPR(17),
    VALID_TUPLE_ID_EXPR(18),
    DATE_LITERAL(19);

    private final int value;

    private TExprNodeType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static TExprNodeType findByValue(int value) {
        switch (value) {
            case 0: {
                return NULL_LITERAL;
            }
            case 1: {
                return BOOL_LITERAL;
            }
            case 2: {
                return INT_LITERAL;
            }
            case 3: {
                return FLOAT_LITERAL;
            }
            case 4: {
                return STRING_LITERAL;
            }
            case 5: {
                return DECIMAL_LITERAL;
            }
            case 6: {
                return TIMESTAMP_LITERAL;
            }
            case 7: {
                return CASE_EXPR;
            }
            case 8: {
                return COMPOUND_PRED;
            }
            case 9: {
                return IN_PRED;
            }
            case 10: {
                return IS_NULL_PRED;
            }
            case 11: {
                return LIKE_PRED;
            }
            case 12: {
                return SLOT_REF;
            }
            case 13: {
                return TUPLE_IS_NULL_PRED;
            }
            case 14: {
                return FUNCTION_CALL;
            }
            case 15: {
                return AGGREGATE_EXPR;
            }
            case 16: {
                return IS_NOT_EMPTY_PRED;
            }
            case 17: {
                return KUDU_PARTITION_EXPR;
            }
            case 18: {
                return VALID_TUPLE_ID_EXPR;
            }
            case 19: {
                return DATE_LITERAL;
            }
        }
        return null;
    }
}

