/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.thrift;

import org.apache.thrift.TEnum;

public enum CatalogLookupStatus implements TEnum
{
    OK(0),
    DB_NOT_FOUND(1),
    TABLE_NOT_FOUND(2),
    TABLE_NOT_LOADED(3),
    FUNCTION_NOT_FOUND(4),
    PARTITION_NOT_FOUND(5),
    DATA_SOURCE_NOT_FOUND(6),
    VERSION_MISMATCH(7);

    private final int value;

    private CatalogLookupStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static CatalogLookupStatus findByValue(int value) {
        switch (value) {
            case 0: {
                return OK;
            }
            case 1: {
                return DB_NOT_FOUND;
            }
            case 2: {
                return TABLE_NOT_FOUND;
            }
            case 3: {
                return TABLE_NOT_LOADED;
            }
            case 4: {
                return FUNCTION_NOT_FOUND;
            }
            case 5: {
                return PARTITION_NOT_FOUND;
            }
            case 6: {
                return DATA_SOURCE_NOT_FOUND;
            }
            case 7: {
                return VERSION_MISMATCH;
            }
        }
        return null;
    }
}

