/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.service.rpc.thrift.TGetCrossReferenceReq;
import org.apache.hive.service.rpc.thrift.TGetPrimaryKeysReq;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.ArrayType;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeIncompleteTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.MapType;
import org.apache.impala.catalog.PrimitiveType;
import org.apache.impala.catalog.ScalarType;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.local.InconsistentMetadataFetchException;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.service.Frontend;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TMetadataOpRequest;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TTypeNodeType;
import org.apache.impala.util.PatternMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataOp {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataOp.class);
    private static final TColumnValue NULL_COL_VAL = new TColumnValue();
    private static final TColumnValue EMPTY_COL_VAL = MetadataOp.createTColumnValue("");
    private static final String TABLE_COMMENT_KEY = "comment";
    private static final TResultSetMetadata GET_CATALOGS_MD = new TResultSetMetadata();
    private static final TResultSetMetadata GET_COLUMNS_MD = new TResultSetMetadata();
    private static final TResultSetMetadata GET_SCHEMAS_MD = new TResultSetMetadata();
    private static final TResultSetMetadata GET_TABLES_MD = new TResultSetMetadata();
    private static final TResultSetMetadata GET_TYPEINFO_MD = new TResultSetMetadata();
    private static final TResultSetMetadata GET_TABLE_TYPES_MD = new TResultSetMetadata();
    private static final TResultSetMetadata GET_FUNCTIONS_MD = new TResultSetMetadata();
    private static final TResultSetMetadata GET_PRIMARY_KEYS_MD = new TResultSetMetadata();
    private static final TResultSetMetadata GET_CROSS_REFERENCE_MD = new TResultSetMetadata();
    private static final List<TResultRow> GET_TYPEINFO_RESULTS = Lists.newArrayList();
    private static final List<TResultRow> GET_TABLE_TYPES_RESULTS = Lists.newArrayList();

    private static void initialzeResultSetSchemas() {
        GET_CATALOGS_MD.addToColumns(new TColumn("TABLE_CAT", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("TABLE_CAT", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("TABLE_MD", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("TABLE_NAME", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("COLUMN_NAME", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("DATA_TYPE", Type.INT.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("TYPE_NAME", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("COLUMN_SIZE", Type.INT.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("BUFFER_LENGTH", Type.INT.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("DECIMAL_DIGITS", Type.INT.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("NUM_PREC_RADIX", Type.INT.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("NULLABLE", Type.INT.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("REMARKS", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("COLUMN_DEF", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("SQL_DATA_TYPE", Type.INT.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("SQL_DATETIME_SUB", Type.INT.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("CHAR_OCTET_LENGTH", Type.INT.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("ORDINAL_POSITION", Type.INT.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("IS_NULLABLE", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("SCOPE_CATALOG", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("SCOPE_SCHEMA", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("SCOPE_TABLE", Type.STRING.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("SOURCE_DATA_TYPE", Type.SMALLINT.toThrift()));
        GET_COLUMNS_MD.addToColumns(new TColumn("IS_AUTO_INCREMENT", Type.STRING.toThrift()));
        GET_SCHEMAS_MD.addToColumns(new TColumn("TABLE_SCHEM", Type.STRING.toThrift()));
        GET_SCHEMAS_MD.addToColumns(new TColumn("TABLE_CATALOG", Type.STRING.toThrift()));
        GET_TABLES_MD.addToColumns(new TColumn("TABLE_CAT", Type.STRING.toThrift()));
        GET_TABLES_MD.addToColumns(new TColumn("TABLE_SCHEM", Type.STRING.toThrift()));
        GET_TABLES_MD.addToColumns(new TColumn("TABLE_NAME", Type.STRING.toThrift()));
        GET_TABLES_MD.addToColumns(new TColumn("TABLE_TYPE", Type.STRING.toThrift()));
        GET_TABLES_MD.addToColumns(new TColumn("REMARKS", Type.STRING.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("TYPE_NAME", Type.STRING.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("DATA_TYPE", Type.INT.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("PRECISION", Type.INT.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("LITERAL_PREFIX", Type.STRING.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("LITERAL_SUFFIX", Type.STRING.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("CREATE_PARAMS", Type.STRING.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("NULLABLE", Type.INT.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("CASE_SENSITIVE", Type.BOOLEAN.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("SEARCHABLE", Type.SMALLINT.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("UNSIGNED_ATTRIBUTE", Type.BOOLEAN.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("FIXED_PREC_SCALE", Type.BOOLEAN.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("AUTO_INCREMENT", Type.BOOLEAN.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("LOCAL_TYPE_NAME", Type.STRING.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("MINIMUM_SCALE", Type.SMALLINT.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("MAXIMUM_SCALE", Type.SMALLINT.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("SQL_DATA_TYPE", Type.INT.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("SQL_DATETIME_SUB", Type.INT.toThrift()));
        GET_TYPEINFO_MD.addToColumns(new TColumn("NUM_PREC_RADIX", Type.INT.toThrift()));
        GET_TABLE_TYPES_MD.addToColumns(new TColumn("TABLE_TYPE", Type.STRING.toThrift()));
        GET_FUNCTIONS_MD.addToColumns(new TColumn("FUNCTION_CAT", Type.STRING.toThrift()));
        GET_FUNCTIONS_MD.addToColumns(new TColumn("FUNCTION_SCHEM", Type.STRING.toThrift()));
        GET_FUNCTIONS_MD.addToColumns(new TColumn("FUNCTION_NAME", Type.STRING.toThrift()));
        GET_FUNCTIONS_MD.addToColumns(new TColumn("REMARKS", Type.STRING.toThrift()));
        GET_FUNCTIONS_MD.addToColumns(new TColumn("FUNCTION_TYPE", Type.INT.toThrift()));
        GET_FUNCTIONS_MD.addToColumns(new TColumn("SPECIFIC_NAME", Type.STRING.toThrift()));
        GET_PRIMARY_KEYS_MD.addToColumns(new TColumn("TABLE_CAT", Type.STRING.toThrift()));
        GET_PRIMARY_KEYS_MD.addToColumns(new TColumn("TABLE_SCHEM", Type.STRING.toThrift()));
        GET_PRIMARY_KEYS_MD.addToColumns(new TColumn("TABLE_NAME", Type.STRING.toThrift()));
        GET_PRIMARY_KEYS_MD.addToColumns(new TColumn("COLUMN_NAME", Type.STRING.toThrift()));
        GET_PRIMARY_KEYS_MD.addToColumns(new TColumn("KEQ_SEQ", Type.INT.toThrift()));
        GET_PRIMARY_KEYS_MD.addToColumns(new TColumn("PK_NAME", Type.STRING.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("PKTABLE_CAT", Type.STRING.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("PKTABLE_SCHEM", Type.STRING.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("PKTABLE_NAME", Type.STRING.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("PKCOLUMN_NAME", Type.STRING.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("FKTABLE_CAT", Type.STRING.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("FKTABLE_SCHEM", Type.STRING.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("FKTABLE_NAME", Type.STRING.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("FKCOLUMN_NAME", Type.STRING.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("KEQ_SEQ", Type.INT.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("UPDATE_RULE", Type.INT.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("DELETE_RULE", Type.INT.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("FK_NAME", Type.STRING.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("PK_NAME", Type.STRING.toThrift()));
        GET_CROSS_REFERENCE_MD.addToColumns(new TColumn("DEFERRABILITY", Type.INT.toThrift()));
    }

    private static DbsMetadata getDbsMetadata(Frontend fe, String catalogName, PatternMatcher schemaPatternMatcher, PatternMatcher tablePatternMatcher, PatternMatcher columnPatternMatcher, PatternMatcher fnPatternMatcher, User user) throws ImpalaException {
        Frontend.RetryTracker retries = new Frontend.RetryTracker(String.format("fetching metadata for user %s", user.getName()));
        while (true) {
            try {
                return MetadataOp.doGetDbsMetadata(fe, catalogName, schemaPatternMatcher, tablePatternMatcher, columnPatternMatcher, fnPatternMatcher, user);
            }
            catch (InconsistentMetadataFetchException e) {
                retries.handleRetryOrThrow(e);
                continue;
            }
            break;
        }
    }

    private static DbsMetadata doGetDbsMetadata(Frontend fe, String catalogName, PatternMatcher schemaPatternMatcher, PatternMatcher tablePatternMatcher, PatternMatcher columnPatternMatcher, PatternMatcher fnPatternMatcher, User user) throws ImpalaException {
        DbsMetadata result = new DbsMetadata();
        if (!MetadataOp.isEmptyPattern(catalogName)) {
            return result;
        }
        FeCatalog catalog = fe.getCatalog();
        for (FeDb feDb : fe.getDbs(schemaPatternMatcher, user)) {
            if (fnPatternMatcher != PatternMatcher.MATCHER_MATCH_NONE) {
                List<Function> fns = feDb.getFunctions(null, fnPatternMatcher);
                result.functions.add(fns);
                continue;
            }
            if (tablePatternMatcher == PatternMatcher.MATCHER_MATCH_NONE && columnPatternMatcher == PatternMatcher.MATCHER_MATCH_NONE) {
                result.dbs.add(feDb.getName());
                continue;
            }
            ArrayList tableList = Lists.newArrayList();
            ArrayList tablesColumnsList = Lists.newArrayList();
            ArrayList tableComments = Lists.newArrayList();
            ArrayList tableTypes = Lists.newArrayList();
            ArrayList primaryKeysList = Lists.newArrayList();
            ArrayList foreignKeysList = Lists.newArrayList();
            for (String tabName : fe.getTableNames(feDb.getName(), tablePatternMatcher, user)) {
                FeTable table = columnPatternMatcher == PatternMatcher.MATCHER_MATCH_NONE ? catalog.getTableIfCachedNoThrow(feDb.getName(), tabName) : catalog.getTableNoThrow(feDb.getName(), tabName);
                if (table == null) {
                    result.missingTbls.add(new TableName(feDb.getName(), tabName));
                    continue;
                }
                String comment = table.getTableComment();
                String tableType = MetadataOp.getTableTypeString(table);
                ArrayList columns = Lists.newArrayList();
                ArrayList primaryKeys = Lists.newArrayList();
                ArrayList foreignKeys = Lists.newArrayList();
                if (!table.isLoaded() || table instanceof FeIncompleteTable) {
                    result.missingTbls.add(new TableName(feDb.getName(), tabName));
                } else {
                    columns.addAll(fe.getColumns(table, columnPatternMatcher, user));
                    if (columnPatternMatcher != PatternMatcher.MATCHER_MATCH_NONE) {
                        primaryKeys.addAll(fe.getPrimaryKeys(table, user));
                        foreignKeys.addAll(fe.getForeignKeys(table, user));
                    }
                }
                tableList.add(tabName);
                tablesColumnsList.add(columns);
                primaryKeysList.add(primaryKeys);
                foreignKeysList.add(foreignKeys);
                tableComments.add(Strings.nullToEmpty((String)comment));
                tableTypes.add(tableType);
            }
            result.dbs.add(feDb.getName());
            result.tableNames.add(tableList);
            result.comments.add(tableComments);
            result.columns.add(tablesColumnsList);
            result.primaryKeys.add(primaryKeysList);
            result.foreignKeys.add(foreignKeysList);
            result.tableTypes.add(tableTypes);
        }
        return result;
    }

    public static String getTableTypeString(FeTable table) {
        if (table instanceof FeIncompleteTable) {
            return table.getTableType().name();
        }
        Table msTbl = table.getMetaStoreTable();
        String msTableType = msTbl == null ? null : msTbl.getTableType();
        return MetadataOp.getImpalaTableType(msTableType).name();
    }

    public static TImpalaTableType getImpalaTableType(@Nullable String msTableType) {
        if (msTableType != null) {
            msTableType = msTableType.toUpperCase();
        }
        return (TImpalaTableType)((Object)MetastoreShim.HMS_TO_IMPALA_TYPE.getOrDefault((Object)msTableType, (Object)TImpalaTableType.TABLE));
    }

    @Nullable
    public static String getTableComment(Table msTbl) {
        return msTbl == null ? null : (String)msTbl.getParameters().get(TABLE_COMMENT_KEY);
    }

    public static TResultSet getCatalogs() {
        return MetadataOp.createEmptyResultSet(GET_CATALOGS_MD);
    }

    public static TResultSet getColumns(Frontend fe, String catalogName, String schemaName, String tableName, String columnName, User user) throws ImpalaException {
        PatternMatcher schemaMatcher = PatternMatcher.createJdbcPatternMatcher(schemaName);
        PatternMatcher tableMatcher = PatternMatcher.createJdbcPatternMatcher(tableName);
        PatternMatcher columnMatcher = PatternMatcher.createJdbcPatternMatcher(columnName);
        DbsMetadata dbsMetadata = MetadataOp.getDbsMetadata(fe, catalogName, schemaMatcher, tableMatcher, columnMatcher, PatternMatcher.MATCHER_MATCH_NONE, user);
        if (!dbsMetadata.missingTbls.isEmpty()) {
            StmtMetadataLoader mdLoader = new StmtMetadataLoader(fe, "default", null);
            mdLoader.loadTables(dbsMetadata.missingTbls);
            dbsMetadata = MetadataOp.getDbsMetadata(fe, catalogName, schemaMatcher, tableMatcher, columnMatcher, PatternMatcher.MATCHER_MATCH_NONE, user);
        }
        TResultSet result = MetadataOp.createEmptyResultSet(GET_COLUMNS_MD);
        for (int i = 0; i < dbsMetadata.dbs.size(); ++i) {
            String dbName = dbsMetadata.dbs.get(i);
            for (int j = 0; j < dbsMetadata.tableNames.get(i).size(); ++j) {
                String tabName = dbsMetadata.tableNames.get(i).get(j);
                for (int k = 0; k < dbsMetadata.columns.get(i).get(j).size(); ++k) {
                    Column column = dbsMetadata.columns.get(i).get(j).get(k);
                    Type colType = column.getType();
                    String colTypeName = MetadataOp.getHs2MetadataTypeName(colType);
                    TResultRow row = new TResultRow();
                    row.colVals = Lists.newArrayList();
                    row.colVals.add(NULL_COL_VAL);
                    row.colVals.add(MetadataOp.createTColumnValue(dbName));
                    row.colVals.add(MetadataOp.createTColumnValue(tabName));
                    row.colVals.add(MetadataOp.createTColumnValue(column.getName()));
                    row.colVals.add(MetadataOp.createTColumnValue(colType.getJavaSqlType()));
                    row.colVals.add(MetadataOp.createTColumnValue(colTypeName));
                    row.colVals.add(MetadataOp.createTColumnValue(colType.getColumnSize()));
                    row.colVals.add(NULL_COL_VAL);
                    row.colVals.add(MetadataOp.createTColumnValue(colType.getDecimalDigits()));
                    row.colVals.add(MetadataOp.createTColumnValue(colType.getNumPrecRadix()));
                    row.colVals.add(MetadataOp.createTColumnValue(1));
                    row.colVals.add(MetadataOp.createTColumnValue(column.getComment()));
                    row.colVals.add(NULL_COL_VAL);
                    row.colVals.add(NULL_COL_VAL);
                    row.colVals.add(NULL_COL_VAL);
                    row.colVals.add(NULL_COL_VAL);
                    row.colVals.add(MetadataOp.createTColumnValue(column.getPosition() + 1));
                    row.colVals.add(MetadataOp.createTColumnValue("YES"));
                    row.colVals.add(NULL_COL_VAL);
                    row.colVals.add(NULL_COL_VAL);
                    row.colVals.add(NULL_COL_VAL);
                    row.colVals.add(NULL_COL_VAL);
                    row.colVals.add(MetadataOp.createTColumnValue("NO"));
                    result.rows.add(row);
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Returning " + result.rows.size() + " table columns");
        }
        return result;
    }

    private static String getHs2MetadataTypeName(Type colType) {
        if (colType.isScalarType()) {
            return colType.getPrimitiveType().toString();
        }
        return colType.toSql();
    }

    public static TResultSet getSchemas(Frontend fe, String catalogName, String schemaName, User user) throws ImpalaException {
        TResultSet result = MetadataOp.createEmptyResultSet(GET_SCHEMAS_MD);
        DbsMetadata dbsMetadata = MetadataOp.getDbsMetadata(fe, catalogName, PatternMatcher.createJdbcPatternMatcher(schemaName), PatternMatcher.MATCHER_MATCH_NONE, PatternMatcher.MATCHER_MATCH_NONE, PatternMatcher.MATCHER_MATCH_NONE, user);
        for (int i = 0; i < dbsMetadata.dbs.size(); ++i) {
            String dbName = dbsMetadata.dbs.get(i);
            TResultRow row = new TResultRow();
            row.colVals = Lists.newArrayList();
            row.colVals.add(MetadataOp.createTColumnValue(dbName));
            row.colVals.add(EMPTY_COL_VAL);
            result.rows.add(row);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Returning " + result.rows.size() + " schemas");
        }
        return result;
    }

    public static TResultSet getTables(Frontend fe, String catalogName, String schemaName, String tableName, List<String> tableTypes, User user) throws ImpalaException {
        TResultSet result = MetadataOp.createEmptyResultSet(GET_TABLES_MD);
        ArrayList upperCaseTableTypes = null;
        if (tableTypes != null && !tableTypes.isEmpty()) {
            boolean hasValidTableType = false;
            upperCaseTableTypes = Lists.newArrayList();
            for (String tableType : tableTypes) {
                tableType = tableType.toUpperCase();
                upperCaseTableTypes.add(tableType);
                if (tableType.equals(TImpalaTableType.TABLE.name())) {
                    hasValidTableType = true;
                }
                if (!tableType.equals(TImpalaTableType.VIEW.name())) continue;
                hasValidTableType = true;
            }
            if (!hasValidTableType) {
                return result;
            }
        }
        DbsMetadata dbsMetadata = MetadataOp.getDbsMetadata(fe, catalogName, PatternMatcher.createJdbcPatternMatcher(schemaName), PatternMatcher.createJdbcPatternMatcher(tableName), PatternMatcher.MATCHER_MATCH_NONE, PatternMatcher.MATCHER_MATCH_NONE, user);
        for (int i = 0; i < dbsMetadata.dbs.size(); ++i) {
            String dbName = dbsMetadata.dbs.get(i);
            for (int j = 0; j < dbsMetadata.tableNames.get(i).size(); ++j) {
                String tabName = dbsMetadata.tableNames.get(i).get(j);
                String tableType = dbsMetadata.tableTypes.get(i).get(j);
                if (upperCaseTableTypes != null && !upperCaseTableTypes.contains(tableType)) continue;
                TResultRow row = new TResultRow();
                row.colVals = Lists.newArrayList();
                row.colVals.add(EMPTY_COL_VAL);
                row.colVals.add(MetadataOp.createTColumnValue(dbName));
                row.colVals.add(MetadataOp.createTColumnValue(tabName));
                row.colVals.add(MetadataOp.createTColumnValue(tableType));
                row.colVals.add(MetadataOp.createTColumnValue(dbsMetadata.comments.get(i).get(j)));
                result.rows.add(row);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Returning " + result.rows.size() + " tables");
        }
        return result;
    }

    public static TResultSet getPrimaryKeys(Frontend fe, TMetadataOpRequest request, User user) throws ImpalaException {
        TGetPrimaryKeysReq req = request.getGet_primary_keys_req();
        String catalogName = req.getCatalogName();
        String schemaName = req.getSchemaName();
        String tableName = req.getTableName();
        TResultSet result = MetadataOp.createEmptyResultSet(GET_PRIMARY_KEYS_MD);
        PatternMatcher schemaMatcher = PatternMatcher.createJdbcPatternMatcher(schemaName);
        PatternMatcher tableMatcher = PatternMatcher.createJdbcPatternMatcher(tableName);
        DbsMetadata dbsMetadata = MetadataOp.getDbsMetadata(fe, catalogName, schemaMatcher, tableMatcher, PatternMatcher.MATCHER_MATCH_ALL, PatternMatcher.MATCHER_MATCH_NONE, user);
        if (!dbsMetadata.missingTbls.isEmpty()) {
            StmtMetadataLoader mdLoader = new StmtMetadataLoader(fe, "default", null);
            mdLoader.loadTables(dbsMetadata.missingTbls);
            dbsMetadata = MetadataOp.getDbsMetadata(fe, catalogName, schemaMatcher, tableMatcher, PatternMatcher.MATCHER_MATCH_ALL, PatternMatcher.MATCHER_MATCH_NONE, user);
        }
        for (int i = 0; i < dbsMetadata.dbs.size(); ++i) {
            for (int j = 0; j < dbsMetadata.tableNames.get(i).size(); ++j) {
                for (SQLPrimaryKey pk : dbsMetadata.primaryKeys.get(i).get(j)) {
                    TResultRow row = new TResultRow();
                    row.colVals = Lists.newArrayList();
                    row.colVals.add(EMPTY_COL_VAL);
                    row.colVals.add(MetadataOp.createTColumnValue(pk.getTable_db()));
                    row.colVals.add(MetadataOp.createTColumnValue(pk.getTable_name()));
                    row.colVals.add(MetadataOp.createTColumnValue(pk.getColumn_name()));
                    row.colVals.add(MetadataOp.createTColumnValue(pk.getKey_seq()));
                    row.colVals.add(MetadataOp.createTColumnValue(pk.getPk_name()));
                    result.rows.add(row);
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Returning {} primary keys for table {}.", (Object)result.rows.size(), (Object)tableName);
        }
        return result;
    }

    public static TResultSet getCrossReference(Frontend fe, TMetadataOpRequest request, User user) throws ImpalaException {
        TGetCrossReferenceReq req = request.getGet_cross_reference_req();
        String foreignCatalogName = req.getForeignCatalogName();
        String foreignSchemaName = req.getForeignSchemaName();
        String foreignTableName = req.getForeignTableName();
        String parentSchemaName = req.getParentSchemaName();
        String parentTableName = req.getParentTableName();
        TResultSet result = MetadataOp.createEmptyResultSet(GET_CROSS_REFERENCE_MD);
        PatternMatcher schemaMatcher = PatternMatcher.createJdbcPatternMatcher(foreignSchemaName);
        PatternMatcher tableMatcher = PatternMatcher.createJdbcPatternMatcher(foreignTableName);
        DbsMetadata dbsMetadata = MetadataOp.getDbsMetadata(fe, foreignCatalogName, schemaMatcher, tableMatcher, PatternMatcher.MATCHER_MATCH_ALL, PatternMatcher.MATCHER_MATCH_NONE, user);
        if (!dbsMetadata.missingTbls.isEmpty()) {
            StmtMetadataLoader mdLoader = new StmtMetadataLoader(fe, "default", null);
            mdLoader.loadTables(dbsMetadata.missingTbls);
            dbsMetadata = MetadataOp.getDbsMetadata(fe, foreignCatalogName, schemaMatcher, tableMatcher, PatternMatcher.MATCHER_MATCH_ALL, PatternMatcher.MATCHER_MATCH_NONE, user);
        }
        for (int i = 0; i < dbsMetadata.dbs.size(); ++i) {
            for (int j = 0; j < dbsMetadata.tableNames.get(i).size(); ++j) {
                List<SQLForeignKey> filteredForeignKeys = MetadataOp.filterForeignKeys(dbsMetadata.foreignKeys.get(i).get(j), parentSchemaName, parentTableName);
                for (SQLForeignKey fk : filteredForeignKeys) {
                    TResultRow row = new TResultRow();
                    row.colVals = Lists.newArrayList();
                    row.colVals.add(EMPTY_COL_VAL);
                    row.colVals.add(MetadataOp.createTColumnValue(fk.getPktable_db()));
                    row.colVals.add(MetadataOp.createTColumnValue(fk.getPktable_name()));
                    row.colVals.add(MetadataOp.createTColumnValue(fk.getPkcolumn_name()));
                    row.colVals.add(EMPTY_COL_VAL);
                    row.colVals.add(MetadataOp.createTColumnValue(fk.getFktable_db()));
                    row.colVals.add(MetadataOp.createTColumnValue(fk.getFktable_name()));
                    row.colVals.add(MetadataOp.createTColumnValue(fk.getFkcolumn_name()));
                    row.colVals.add(MetadataOp.createTColumnValue(fk.getKey_seq()));
                    row.colVals.add(MetadataOp.createTColumnValue(fk.getUpdate_rule()));
                    row.colVals.add(MetadataOp.createTColumnValue(fk.getDelete_rule()));
                    row.colVals.add(MetadataOp.createTColumnValue(fk.getFk_name()));
                    row.colVals.add(MetadataOp.createTColumnValue(fk.getPk_name()));
                    row.colVals.add(EMPTY_COL_VAL);
                    result.rows.add(row);
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Returning {} foreign keys for table {}.", (Object)result.rows.size(), (Object)foreignTableName);
        }
        return result;
    }

    private static List<SQLForeignKey> filterForeignKeys(List<SQLForeignKey> dbForeignKeys, String pkSchemaName, String pkTableName) {
        if (pkSchemaName == null || pkTableName == null) {
            return new ArrayList<SQLForeignKey>(dbForeignKeys);
        }
        ArrayList<SQLForeignKey> foreignKeys = new ArrayList<SQLForeignKey>();
        for (SQLForeignKey fk : dbForeignKeys) {
            if (!fk.getPktable_db().equals(pkSchemaName) || !fk.getPktable_name().equals(pkTableName)) continue;
            foreignKeys.add(fk);
        }
        return foreignKeys;
    }

    public static TResultSet getTypeInfo() {
        TResultSet result = MetadataOp.createEmptyResultSet(GET_TYPEINFO_MD);
        result.rows = GET_TYPEINFO_RESULTS;
        return result;
    }

    public static TResultSet getTableTypes() {
        TResultSet result = MetadataOp.createEmptyResultSet(GET_TABLE_TYPES_MD);
        result.rows = GET_TABLE_TYPES_RESULTS;
        return result;
    }

    private static TResultRow createFunctionResultRow(Function fn) {
        TResultRow row = new TResultRow();
        row.colVals = Lists.newArrayList();
        row.colVals.add(NULL_COL_VAL);
        row.colVals.add(MetadataOp.createTColumnValue(fn.dbName()));
        row.colVals.add(MetadataOp.createTColumnValue(fn.functionName()));
        row.colVals.add(EMPTY_COL_VAL);
        row.colVals.add(MetadataOp.createTColumnValue(1));
        row.colVals.add(MetadataOp.createTColumnValue(fn.signatureString()));
        return row;
    }

    public static TResultSet getFunctions(Frontend fe, String catalogName, String schemaName, String functionName, User user) throws ImpalaException {
        TResultSet result = MetadataOp.createEmptyResultSet(GET_FUNCTIONS_MD);
        if (!MetadataOp.isEmptyPattern(catalogName) || !MetadataOp.isEmptyPattern(schemaName)) {
            return result;
        }
        DbsMetadata dbsMetadata = MetadataOp.getDbsMetadata(fe, catalogName, PatternMatcher.createJdbcPatternMatcher(schemaName), PatternMatcher.MATCHER_MATCH_NONE, PatternMatcher.MATCHER_MATCH_NONE, PatternMatcher.createJdbcPatternMatcher(functionName), user);
        for (List<Function> fns : dbsMetadata.functions) {
            for (Function fn : fns) {
                result.rows.add(MetadataOp.createFunctionResultRow(fn));
            }
        }
        return result;
    }

    private static TResultRow createGetTypeInfoResult(String typeName, Type type) {
        TResultRow row = new TResultRow();
        row.colVals = Lists.newArrayList();
        row.colVals.add(MetadataOp.createTColumnValue(typeName));
        row.colVals.add(MetadataOp.createTColumnValue(type.getJavaSqlType()));
        row.colVals.add(MetadataOp.createTColumnValue(type.getPrecision()));
        row.colVals.add(NULL_COL_VAL);
        row.colVals.add(NULL_COL_VAL);
        row.colVals.add(NULL_COL_VAL);
        row.colVals.add(MetadataOp.createTColumnValue(1));
        row.colVals.add(MetadataOp.createTColumnValue(type.isStringType()));
        row.colVals.add(MetadataOp.createTColumnValue(3));
        row.colVals.add(MetadataOp.createTColumnValue(!type.isNumericType()));
        row.colVals.add(MetadataOp.createTColumnValue(false));
        row.colVals.add(MetadataOp.createTColumnValue(false));
        row.colVals.add(NULL_COL_VAL);
        row.colVals.add(MetadataOp.createTColumnValue(0));
        row.colVals.add(MetadataOp.createTColumnValue(0));
        row.colVals.add(NULL_COL_VAL);
        row.colVals.add(NULL_COL_VAL);
        row.colVals.add(MetadataOp.createTColumnValue(type.getNumPrecRadix()));
        return row;
    }

    private static void createGetPrimitiveTypeInfoResults() {
        for (PrimitiveType ptype : PrimitiveType.values()) {
            ScalarType type = Type.getDefaultScalarType(ptype);
            if (type.isInternalType() || !type.isSupported()) continue;
            TResultRow row = MetadataOp.createGetTypeInfoResult(ptype.name(), type);
            GET_TYPEINFO_RESULTS.add(row);
        }
    }

    private static void createGetTypeInfoResults() {
        for (TTypeNodeType nodeType : TTypeNodeType.values()) {
            Type type = null;
            if (nodeType == TTypeNodeType.SCALAR) {
                MetadataOp.createGetPrimitiveTypeInfoResults();
                continue;
            }
            if (nodeType == TTypeNodeType.ARRAY) {
                type = new ArrayType(ScalarType.createType(PrimitiveType.INT));
            } else if (nodeType == TTypeNodeType.MAP) {
                type = new MapType(ScalarType.createType(PrimitiveType.INT), ScalarType.createType(PrimitiveType.INT));
            } else if (nodeType == TTypeNodeType.STRUCT) {
                type = new StructType();
            }
            if (!type.isSupported()) continue;
            TResultRow row = MetadataOp.createGetTypeInfoResult(nodeType.name(), type);
            GET_TYPEINFO_RESULTS.add(row);
        }
    }

    private static void createGetTableTypesResults() {
        TResultRow row = new TResultRow();
        row.colVals = Lists.newArrayList();
        row.colVals.add(MetadataOp.createTColumnValue(TImpalaTableType.TABLE.name()));
        GET_TABLE_TYPES_RESULTS.add(row);
        row = new TResultRow();
        row.colVals = Lists.newArrayList();
        row.colVals.add(MetadataOp.createTColumnValue(TImpalaTableType.VIEW.name()));
        GET_TABLE_TYPES_RESULTS.add(row);
    }

    private static TResultSet createEmptyResultSet(TResultSetMetadata metadata) {
        TResultSet result = new TResultSet();
        result.rows = Lists.newArrayList();
        result.schema = metadata;
        return result;
    }

    public static TColumnValue createTColumnValue(String val) {
        TColumnValue colVal = new TColumnValue();
        if (val != null) {
            colVal.setString_val(val);
        }
        return colVal;
    }

    public static TColumnValue createTColumnValue(Integer val) {
        TColumnValue colVal = new TColumnValue();
        if (val != null) {
            colVal.setInt_val(val);
        }
        return colVal;
    }

    public static TColumnValue createTColumnValue(Boolean val) {
        TColumnValue colVal = new TColumnValue();
        if (val != null) {
            colVal.setBool_val(val);
        }
        return colVal;
    }

    public static boolean isEmptyPattern(String pattern) {
        return pattern == null || pattern.isEmpty() || pattern.length() == 1 && pattern.equals("%");
    }

    static {
        MetadataOp.initialzeResultSetSchemas();
        MetadataOp.createGetTypeInfoResults();
        MetadataOp.createGetTableTypesResults();
    }

    private static class DbsMetadata {
        public List<String> dbs = Lists.newArrayList();
        public List<List<String>> tableNames = Lists.newArrayList();
        public List<List<String>> tableTypes = Lists.newArrayList();
        public List<List<String>> comments = Lists.newArrayList();
        public List<List<List<Column>>> columns = Lists.newArrayList();
        public List<List<Function>> functions = Lists.newArrayList();
        public List<List<List<SQLPrimaryKey>>> primaryKeys = Lists.newArrayList();
        public List<List<List<SQLForeignKey>>> foreignKeys = Lists.newArrayList();
        public Set<TableName> missingTbls = new HashSet<TableName>();

        private DbsMetadata() {
        }
    }
}

