/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.impala.analysis.TableName;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.AuthorizationManager;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.CatalogServiceCatalog;
import org.apache.impala.catalog.Db;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FileMetadataLoader;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.ParallelFileMetadataLoader;
import org.apache.impala.catalog.Table;
import org.apache.impala.catalog.events.ExternalEventsProcessor;
import org.apache.impala.catalog.events.MetastoreEvents;
import org.apache.impala.catalog.events.MetastoreEventsProcessor;
import org.apache.impala.catalog.events.NoOpEventProcessor;
import org.apache.impala.catalog.metastore.ICatalogMetastoreServer;
import org.apache.impala.catalog.metastore.NoOpCatalogMetastoreServer;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.JniUtil;
import org.apache.impala.common.Pair;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.hive.executor.HiveJavaFunctionFactoryImpl;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.CatalogOpExecutor;
import org.apache.impala.service.JniCatalogOp;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TCatalogObject;
import org.apache.impala.thrift.TDdlExecRequest;
import org.apache.impala.thrift.TErrorCode;
import org.apache.impala.thrift.TFunction;
import org.apache.impala.thrift.TGetAllHadoopConfigsResponse;
import org.apache.impala.thrift.TGetCatalogDeltaRequest;
import org.apache.impala.thrift.TGetCatalogDeltaResponse;
import org.apache.impala.thrift.TGetCatalogServerMetricsResponse;
import org.apache.impala.thrift.TGetDbsParams;
import org.apache.impala.thrift.TGetDbsResult;
import org.apache.impala.thrift.TGetFunctionsRequest;
import org.apache.impala.thrift.TGetFunctionsResponse;
import org.apache.impala.thrift.TGetLatestCompactionsRequest;
import org.apache.impala.thrift.TGetLatestCompactionsResponse;
import org.apache.impala.thrift.TGetNullPartitionNameResponse;
import org.apache.impala.thrift.TGetPartialCatalogObjectRequest;
import org.apache.impala.thrift.TGetPartitionStatsRequest;
import org.apache.impala.thrift.TGetPartitionStatsResponse;
import org.apache.impala.thrift.TGetTableMetricsParams;
import org.apache.impala.thrift.TGetTablesParams;
import org.apache.impala.thrift.TGetTablesResult;
import org.apache.impala.thrift.TLogLevel;
import org.apache.impala.thrift.TPrioritizeLoadRequest;
import org.apache.impala.thrift.TResetMetadataRequest;
import org.apache.impala.thrift.TStatus;
import org.apache.impala.thrift.TTableUsage;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.thrift.TUpdateCatalogRequest;
import org.apache.impala.thrift.TUpdateTableUsageRequest;
import org.apache.impala.util.AuthorizationUtil;
import org.apache.impala.util.CatalogOpUtil;
import org.apache.impala.util.GlogAppender;
import org.apache.impala.util.MetaStoreUtil;
import org.apache.impala.util.NoOpEventSequence;
import org.apache.impala.util.PatternMatcher;
import org.apache.impala.util.TUniqueIdUtil;
import org.apache.impala.util.ThreadNameAnnotator;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.protocol.TSimpleJSONProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JniCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(JniCatalog.class);
    private static final TBinaryProtocol.Factory protocolFactory_ = new TBinaryProtocol.Factory();
    private final CatalogServiceCatalog catalog_;
    private final CatalogOpExecutor catalogOpExecutor_;
    private final ICatalogMetastoreServer catalogMetastoreServer_;
    private final AuthorizationManager authzManager_;
    private static TUniqueId catalogServiceId_ = JniCatalog.generateId();
    private static final ReentrantReadWriteLock catalogServiceIdLock_ = new ReentrantReadWriteLock(true);
    private static final HiveConf HIVE_CONF = new HiveConf();

    private static TUniqueId generateId() {
        UUID uuid = UUID.randomUUID();
        return new TUniqueId(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public JniCatalog(byte[] thriftBackendConfig) throws ImpalaException {
        TBackendGflags cfg = new TBackendGflags();
        JniUtil.deserializeThrift(protocolFactory_, cfg, thriftBackendConfig);
        BackendConfig.create(cfg);
        Preconditions.checkArgument((cfg.num_metadata_loading_threads > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((cfg.max_hdfs_partitions_parallel_load > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((cfg.max_nonhdfs_partitions_parallel_load > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((cfg.initial_hms_cnxn_timeout_s > 0 ? 1 : 0) != 0);
        GlogAppender.Install(TLogLevel.values()[cfg.impala_log_lvl], TLogLevel.values()[cfg.non_impala_java_vlog]);
        AuthorizationFactory authzFactory = AuthorizationUtil.authzFactoryFrom(BackendConfig.INSTANCE);
        LOG.info(JniUtil.getJavaVersion());
        AuthorizationConfig authzConfig = authzFactory.getAuthorizationConfig();
        if (MetastoreShim.getMajorVersion() > 2L) {
            MetastoreShim.setHiveClientCapabilities();
        }
        MetaStoreClientPool metaStoreClientPool = new MetaStoreClientPool(10, cfg.initial_hms_cnxn_timeout_s);
        this.catalog_ = new CatalogServiceCatalog(cfg.load_catalog_in_background, cfg.num_metadata_loading_threads, cfg.local_library_path, metaStoreClientPool);
        this.authzManager_ = authzFactory.newAuthorizationManager(this.catalog_);
        this.catalog_.setAuthzManager(this.authzManager_);
        this.catalogOpExecutor_ = new CatalogOpExecutor(this.catalog_, authzConfig, this.authzManager_, new HiveJavaFunctionFactoryImpl(BackendConfig.INSTANCE.getBackendCfg().local_library_path));
        MetastoreEvents.EventFactoryForSyncToLatestEvent eventFactory = new MetastoreEvents.EventFactoryForSyncToLatestEvent(this.catalogOpExecutor_);
        this.catalog_.setEventFactoryForSyncToLatestEvent(eventFactory);
        ExternalEventsProcessor eventsProcessor = this.getEventsProcessor(metaStoreClientPool, this.catalogOpExecutor_);
        this.catalog_.setMetastoreEventProcessor(eventsProcessor);
        this.catalog_.startEventsProcessor();
        this.catalogMetastoreServer_ = this.getCatalogMetastoreServer(this.catalogOpExecutor_);
        this.catalog_.setCatalogMetastoreServer(this.catalogMetastoreServer_);
        this.catalogMetastoreServer_.start();
        try {
            this.catalog_.reset(NoOpEventSequence.INSTANCE);
        }
        catch (CatalogException e) {
            LOG.error("Error initializing Catalog. Please run 'invalidate metadata'", (Throwable)e);
        }
    }

    @VisibleForTesting
    private ICatalogMetastoreServer getCatalogMetastoreServer(CatalogOpExecutor catalogOpExecutor) {
        if (!BackendConfig.INSTANCE.startHmsServer()) {
            return NoOpCatalogMetastoreServer.INSTANCE;
        }
        return MetastoreShim.getCatalogMetastoreServer(catalogOpExecutor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExternalEventsProcessor getEventsProcessor(MetaStoreClientPool metaStoreClientPool, CatalogOpExecutor catalogOpExecutor) throws ImpalaException {
        long eventPollingInterval = BackendConfig.INSTANCE.getHMSPollingIntervalInSeconds();
        if (eventPollingInterval <= 0L) {
            LOG.info("Metastore event processing is disabled. Event polling interval is {}", (Object)eventPollingInterval);
            return NoOpEventProcessor.getInstance();
        }
        try (MetaStoreClientPool.MetaStoreClient metaStoreClient = metaStoreClientPool.getClient();){
            CurrentNotificationEventId currentNotificationId = metaStoreClient.getHiveClient().getCurrentNotificationEventId();
            ExternalEventsProcessor externalEventsProcessor = MetastoreEventsProcessor.getInstance(catalogOpExecutor, currentNotificationId.getEventId(), eventPollingInterval);
            return externalEventsProcessor;
        }
        catch (TException e) {
            LOG.error("Unable to fetch the current notification event id from metastore.", (Throwable)e);
            throw new CatalogException("Fatal error while initializing metastore event processor", e);
        }
    }

    private <RESULT, PARAMETER extends TBase<?, ?>> RESULT execOp(String methodName, String shortDescription, JniCatalogOp.JniCatalogOpCallable<Pair<RESULT, Long>> operand, PARAMETER requestParameter) throws ImpalaException, TException {
        return JniCatalogOp.execOp(methodName, shortDescription, operand, requestParameter);
    }

    private byte[] execAndSerialize(String methodName, String shortDescription, JniCatalogOp.JniCatalogOpCallable<TBase<?, ?>> operand, Runnable finalClause) throws ImpalaException, TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
        return JniCatalogOp.execAndSerialize(methodName, shortDescription, operand, serializer, finalClause);
    }

    private byte[] execAndSerializeSilentStartAndFinish(String methodName, String shortDescription, JniCatalogOp.JniCatalogOpCallable<TBase<?, ?>> operand) throws ImpalaException, TException {
        TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
        return JniCatalogOp.execAndSerializeSilentStartAndFinish(methodName, shortDescription, operand, serializer, () -> {});
    }

    private byte[] execAndSerialize(String methodName, String shortDescription, JniCatalogOp.JniCatalogOpCallable<TBase<?, ?>> operand) throws ImpalaException, TException {
        return this.execAndSerialize(methodName, shortDescription, operand, () -> {});
    }

    private String fullyQualifiedTableName(String databaseName, String tableName) {
        return databaseName + "." + tableName;
    }

    public static TUniqueId getServiceId() {
        catalogServiceIdLock_.readLock().lock();
        try {
            TUniqueId tUniqueId = catalogServiceId_;
            return tUniqueId;
        }
        finally {
            catalogServiceIdLock_.readLock().unlock();
        }
    }

    public void regenerateServiceId() {
        catalogServiceIdLock_.writeLock().lock();
        try {
            TUniqueId oldCatalogServiceId = catalogServiceId_;
            catalogServiceId_ = JniCatalog.generateId();
            LOG.info("Old Catalog Service ID " + TUniqueIdUtil.PrintId(oldCatalogServiceId) + ", Regenerate Catalog Service ID " + TUniqueIdUtil.PrintId(catalogServiceId_));
        }
        finally {
            catalogServiceIdLock_.writeLock().unlock();
        }
    }

    public long getCatalogVersion() {
        return this.catalog_.getCatalogVersion();
    }

    public byte[] getCatalogDelta(byte[] thriftGetCatalogDeltaReq) throws ImpalaException, TException {
        TGetCatalogDeltaRequest params = new TGetCatalogDeltaRequest();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftGetCatalogDeltaReq);
        String shortDesc = "Getting catalog delta from version " + params.getFrom_version();
        return this.execAndSerialize("getCatalogDelta", shortDesc, () -> {
            long catalogDelta = this.catalog_.getCatalogDelta(params.getNative_catalog_server_ptr(), params.getFrom_version());
            return new TGetCatalogDeltaResponse(catalogDelta);
        });
    }

    public byte[] execDdl(byte[] thriftDdlExecReq) throws ImpalaException, TException {
        TDdlExecRequest params = new TDdlExecRequest();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftDdlExecReq);
        String shortDesc = CatalogOpUtil.getShortDescForExecDdl(params);
        return this.execAndSerialize("execDdl", shortDesc, () -> this.catalogOpExecutor_.execDdlRequest(params));
    }

    public byte[] resetMetadata(byte[] thriftResetMetadataReq) throws ImpalaException, TException {
        TResetMetadataRequest req = new TResetMetadataRequest();
        JniUtil.deserializeThrift(protocolFactory_, req, thriftResetMetadataReq);
        String shortDesc = CatalogOpUtil.getShortDescForReset(req);
        return this.execAndSerialize("resetMetadata", shortDesc, () -> this.catalogOpExecutor_.execResetMetadata(req));
    }

    public byte[] getDbs(byte[] thriftGetTablesParams) throws ImpalaException, TException {
        TGetDbsParams params = new TGetDbsParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftGetTablesParams);
        TGetDbsResult result = new TGetDbsResult();
        String shortDesc = "Getting databases with pattern: " + params.getPattern();
        return this.execAndSerialize("getDbs", shortDesc, () -> {
            List<Db> dbs = this.catalog_.getDbs(PatternMatcher.MATCHER_MATCH_ALL);
            ArrayList tDbs = Lists.newArrayListWithCapacity((int)dbs.size());
            for (FeDb feDb : dbs) {
                tDbs.add(feDb.toThrift());
            }
            result.setDbs(tDbs);
            return result;
        });
    }

    public byte[] getTableNames(byte[] thriftGetTablesParams) throws ImpalaException, TException {
        TGetTablesParams params = new TGetTablesParams();
        JniUtil.deserializeThrift(protocolFactory_, params, thriftGetTablesParams);
        TGetTablesResult result = new TGetTablesResult();
        String shortDesc = String.format("Getting table names with parameters: database: %s, pattern: %s ", params.getDb(), params.getPattern());
        return this.execAndSerialize("getTableNames", shortDesc, () -> {
            List<String> tables = this.catalog_.getTableNames(params.getDb(), PatternMatcher.createHivePatternMatcher(params.getPattern()));
            result.setTables(tables);
            return result;
        });
    }

    public String getTableMetrics(byte[] getTableMetricsParams) throws ImpalaException, TException {
        TGetTableMetricsParams params = new TGetTableMetricsParams();
        JniUtil.deserializeThrift(protocolFactory_, params, getTableMetricsParams);
        String shortDesc = "Getting table metrics for " + params.getTable_name();
        return (String)this.execOp("getTableMetrics", shortDesc, () -> {
            String res = this.catalog_.getTableMetrics(params.table_name);
            return Pair.create(res, Long.valueOf(res.length()));
        }, params);
    }

    public byte[] getCatalogObject(byte[] thriftParams) throws ImpalaException, TException {
        TCatalogObject objectDesc = new TCatalogObject();
        JniUtil.deserializeThrift(protocolFactory_, objectDesc, thriftParams);
        String shortDesc = "Getting thrift catalog object of " + Catalog.toCatalogObjectKey(objectDesc);
        return this.execAndSerialize("getCatalogObject", shortDesc, () -> this.catalog_.getTCatalogObject(objectDesc));
    }

    public String getJsonCatalogObject(byte[] thriftParams) throws ImpalaException, TException {
        TCatalogObject objectDesc = new TCatalogObject();
        JniUtil.deserializeThrift(protocolFactory_, objectDesc, thriftParams);
        TSerializer jsonSerializer = new TSerializer((TProtocolFactory)new TSimpleJSONProtocol.Factory());
        String shortDesc = "Getting JSON catalog object of " + Catalog.toCatalogObjectKey(objectDesc);
        return (String)this.execOp("getJsonCatalogObject", shortDesc, () -> {
            String res = jsonSerializer.toString((TBase)this.catalog_.getTCatalogObject(objectDesc, true));
            return Pair.create(res, Long.valueOf(res.length()));
        }, objectDesc);
    }

    public byte[] getPartialCatalogObject(byte[] thriftParams) throws ImpalaException, TException {
        TGetPartialCatalogObjectRequest req = new TGetPartialCatalogObjectRequest();
        JniUtil.deserializeThrift(protocolFactory_, req, thriftParams);
        String shortDesc = "Getting partial catalog object of " + Catalog.toCatalogObjectKey(req.getObject_desc());
        return this.execAndSerializeSilentStartAndFinish("getPartialCatalogObject", shortDesc, () -> this.catalog_.getPartialCatalogObject(req));
    }

    public byte[] getFunctions(byte[] thriftParams) throws ImpalaException, TException {
        TGetFunctionsRequest request = new TGetFunctionsRequest();
        JniUtil.deserializeThrift(protocolFactory_, request, thriftParams);
        TGetFunctionsResponse response = new TGetFunctionsResponse();
        if (!request.isSetDb_name()) {
            throw new InternalException("Database name must be set in call to getFunctions()");
        }
        String shortDesc = "Getting functions for " + request.getDb_name();
        return this.execAndSerialize("getFunctions", shortDesc, () -> {
            List<Function> fns = this.catalog_.getFunctions(request.getDb_name());
            response.setFunctions(new ArrayList<TFunction>(fns.size()));
            for (Function fn : fns) {
                response.addToFunctions(fn.toThrift());
            }
            return response;
        });
    }

    public void prioritizeLoad(byte[] thriftLoadReq) throws ImpalaException, TException {
        TPrioritizeLoadRequest request = new TPrioritizeLoadRequest();
        JniUtil.deserializeThrift(protocolFactory_, request, thriftLoadReq);
        String shortDesc = "Prioritize load on table(s): " + request.getObject_descs().stream().map(TCatalogObject::getTable).map(t -> this.fullyQualifiedTableName(t.getDb_name(), t.getTbl_name())).collect(Collectors.joining(", "));
        this.execOp("prioritizeLoad", shortDesc, () -> {
            this.catalog_.prioritizeLoad(request.getObject_descs());
            return Pair.create(null, null);
        }, request);
    }

    public byte[] getPartitionStats(byte[] thriftParams) throws ImpalaException, TException {
        TGetPartitionStatsRequest request = new TGetPartitionStatsRequest();
        JniUtil.deserializeThrift(protocolFactory_, request, thriftParams);
        TGetPartitionStatsResponse response = new TGetPartitionStatsResponse();
        String shortDescGet = "Getting partition stats of " + request.getTable_name();
        String shortDescSer = "Serializing partition stats of " + request.getTable_name();
        return this.execAndSerialize("getPartitionStats", shortDescSer, () -> {
            try (ThreadNameAnnotator ignored = new ThreadNameAnnotator(shortDescGet);){
                response.setPartition_stats(this.catalog_.getPartitionStats(request));
            }
            catch (CatalogException e) {
                response.setStatus(new TStatus(TErrorCode.INTERNAL_ERROR, (List<String>)ImmutableList.of((Object)e.getMessage())));
            }
            return response;
        });
    }

    public byte[] updateCatalog(byte[] thriftUpdateCatalog) throws ImpalaException, TException {
        TUpdateCatalogRequest request = new TUpdateCatalogRequest();
        JniUtil.deserializeThrift(protocolFactory_, request, thriftUpdateCatalog);
        String shortDesc = "Update catalog for " + this.fullyQualifiedTableName(request.getDb_name(), request.getTarget_table());
        return this.execAndSerialize("updateCatalog", shortDesc, () -> this.catalogOpExecutor_.updateCatalog(request));
    }

    public byte[] getCatalogUsage() throws ImpalaException, TException {
        String shortDesc = "Getting catalog usage";
        return this.execAndSerialize("getCatalogUsage", shortDesc, this.catalog_::getCatalogUsage);
    }

    public byte[] getOperationUsage() throws ImpalaException, TException {
        String shortDesc = "Getting operation usage";
        return this.execAndSerialize("getOperationUsage", shortDesc, this.catalog_::getOperationUsage);
    }

    public byte[] getEventProcessorSummary() throws ImpalaException, TException {
        String shortDesc = "Getting event processor summary";
        return this.execAndSerialize("getEventProcessorSummary", shortDesc, this.catalog_::getEventProcessorSummary);
    }

    public void updateTableUsage(byte[] req) throws ImpalaException, TException {
        TUpdateTableUsageRequest thriftReq = new TUpdateTableUsageRequest();
        JniUtil.deserializeThrift(protocolFactory_, thriftReq, req);
        String shortDesc = "Update table usage(s):" + thriftReq.getUsages().stream().map(TTableUsage::getTable_name).map(TableName::thriftToString).collect(Collectors.joining(", "));
        this.execOp("updateTableUsage", shortDesc, () -> {
            this.catalog_.updateTableUsage(thriftReq);
            return Pair.create(null, null);
        }, thriftReq);
    }

    public byte[] getCatalogServerMetrics() throws ImpalaException, TException {
        TGetCatalogServerMetricsResponse response = new TGetCatalogServerMetricsResponse();
        String shortDesc = "Get catalog server metrics";
        return this.execAndSerializeSilentStartAndFinish("getCatalogServerMetrics", shortDesc, () -> {
            response.setCatalog_partial_fetch_rpc_queue_len(this.catalog_.getPartialFetchRpcQueueLength());
            response.setCatalog_num_file_metadata_loading_threads(ParallelFileMetadataLoader.TOTAL_THREADS.get());
            response.setCatalog_num_tables_loading_file_metadata(ParallelFileMetadataLoader.TOTAL_TABLES.get());
            response.setCatalog_num_file_metadata_loading_tasks(FileMetadataLoader.TOTAL_TASKS.get());
            response.setCatalog_num_tables_loading_metadata(Table.LOADING_TABLES.get());
            response.setCatalog_num_tables_async_loading_metadata(this.catalog_.getNumAsyncLoadingTables());
            response.setCatalog_num_tables_waiting_for_async_loading(this.catalog_.getNumAsyncWaitingTables());
            response.setCatalog_num_dbs(this.catalog_.getNumDatabases());
            response.setCatalog_num_tables(this.catalog_.getNumTables());
            response.setCatalog_num_functions(this.catalog_.getNumFunctions());
            response.setCatalog_num_hms_clients_idle(this.catalog_.getNumHmsClientsIdle());
            response.setCatalog_num_hms_clients_in_use(this.catalog_.getNumHmsClientsInUse());
            response.setEvent_metrics(this.catalog_.getEventProcessorMetrics());
            return response;
        });
    }

    public void refreshDataSources() throws TException {
        this.catalog_.refreshDataSources();
    }

    public byte[] getNullPartitionName() throws ImpalaException, TException {
        return this.execAndSerialize("getNullPartitionName", "Getting null partition name", () -> {
            TGetNullPartitionNameResponse response = new TGetNullPartitionNameResponse();
            try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient();){
                response.setPartition_value(MetaStoreUtil.getNullPartitionKeyValue(msClient.getHiveClient()));
                response.setStatus(new TStatus(TErrorCode.OK, Lists.newArrayList()));
            }
            return response;
        });
    }

    public byte[] getLatestCompactions(byte[] thriftParams) throws ImpalaException, TException {
        TGetLatestCompactionsRequest request = new TGetLatestCompactionsRequest();
        JniUtil.deserializeThrift(protocolFactory_, request, thriftParams);
        return this.execAndSerialize("getLatestCompactions", "Getting latest compactions", () -> {
            TGetLatestCompactionsResponse response = new TGetLatestCompactionsResponse();
            try (MetaStoreClientPool.MetaStoreClient msClient = this.catalog_.getMetaStoreClient();){
                response.setPartition_to_compaction_id(MetastoreShim.getLatestCompactions(msClient, request.db_name, request.table_name, request.partition_names, request.non_parition_name, request.last_compaction_id));
                response.setStatus(new TStatus(TErrorCode.OK, Lists.newArrayList()));
            }
            return response;
        });
    }

    public byte[] getAllHadoopConfigs() throws ImpalaException {
        HashMap configs = Maps.newHashMap();
        for (Map.Entry e : HIVE_CONF) {
            configs.put(e.getKey(), e.getValue());
        }
        TGetAllHadoopConfigsResponse result = new TGetAllHadoopConfigsResponse();
        result.setConfigs(configs);
        try {
            TSerializer serializer = new TSerializer((TProtocolFactory)protocolFactory_);
            return serializer.serialize((TBase)result);
        }
        catch (TException e) {
            throw new InternalException(e.getMessage());
        }
    }
}

