/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.impala.thrift.TCounter;
import org.apache.impala.thrift.TRuntimeProfileNode;
import org.apache.impala.thrift.TUnit;

@ThreadSafe
public class FrontendProfile {
    private static final String ROOT_COUNTER_NAME = "";
    private static ThreadLocal<FrontendProfile> THREAD_LOCAL = new ThreadLocal();
    @GuardedBy(value="this")
    private TRuntimeProfileNode profile_;
    @GuardedBy(value="this")
    private final Map<String, TCounter> countersByName_ = new HashMap<String, TCounter>();
    @GuardedBy(value="this")
    private Map<String, TRuntimeProfileNode> childrenProfiles_ = new TreeMap<String, TRuntimeProfileNode>();

    FrontendProfile() {
        this.profile_ = new TRuntimeProfileNode("Frontend", 0, new ArrayList<TCounter>(), -1L, false, new HashMap<String, String>(), new ArrayList<String>(), (Map<String, Set<String>>)ImmutableMap.of((Object)ROOT_COUNTER_NAME, new HashSet()));
    }

    public static Scope createNewWithScope() {
        return new Scope(new FrontendProfile());
    }

    @Nonnull
    public static FrontendProfile getCurrent() {
        FrontendProfile prof = THREAD_LOCAL.get();
        Preconditions.checkState((prof != null ? 1 : 0) != 0, (Object)"no profile in scope");
        return prof;
    }

    @Nullable
    public static FrontendProfile getCurrentOrNull() {
        return THREAD_LOCAL.get();
    }

    public synchronized TRuntimeProfileNode emitAsThrift() {
        Preconditions.checkState((this.profile_ != null ? 1 : 0) != 0, (Object)"already emitted profile");
        TRuntimeProfileNode ret = this.profile_;
        this.profile_ = null;
        return ret;
    }

    public synchronized List<TRuntimeProfileNode> emitChildrenAsThrift() {
        Preconditions.checkState((this.profile_ == null ? 1 : 0) != 0, (Object)"emitAsThrift() must be called first");
        Preconditions.checkState((this.childrenProfiles_ != null ? 1 : 0) != 0, (Object)"already emitted profile");
        ArrayList ret = Lists.newArrayList(this.childrenProfiles_.values());
        this.childrenProfiles_ = null;
        return ret;
    }

    public synchronized void addInfoString(String key, String val) {
        Preconditions.checkState((this.profile_ != null ? 1 : 0) != 0, (Object)"already emitted profile");
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)val);
        if (this.profile_.getInfo_strings().put(key, val) == null) {
            this.profile_.getInfo_strings_display_order().add(key);
        }
    }

    public synchronized void appendInfoString(String key, String val) {
        Preconditions.checkState((this.profile_ != null ? 1 : 0) != 0, (Object)"already emitted profile");
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)val);
        Map<String, String> info_strings = this.profile_.getInfo_strings();
        if (info_strings.containsKey(key)) {
            info_strings.put(key, info_strings.get(key) + ", " + val);
        } else {
            info_strings.put(key, val);
            this.profile_.getInfo_strings_display_order().add(key);
        }
    }

    public synchronized String getInfoString(String key) {
        Preconditions.checkState((this.profile_ != null ? 1 : 0) != 0, (Object)"already emitted profile");
        Preconditions.checkNotNull((Object)key);
        return this.profile_.getInfo_strings().getOrDefault(key, ROOT_COUNTER_NAME);
    }

    public synchronized void addChildrenProfile(TRuntimeProfileNode child) {
        Preconditions.checkState((this.profile_ != null ? 1 : 0) != 0, (Object)"already emitted profile");
        Preconditions.checkState((this.childrenProfiles_ != null ? 1 : 0) != 0, (Object)"already emitted profile");
        Preconditions.checkNotNull((Object)child.getName());
        Preconditions.checkArgument((!this.childrenProfiles_.containsKey(child.getName()) ? 1 : 0) != 0);
        this.childrenProfiles_.put(child.getName(), child);
    }

    private TCounter getOrCreateCounter(String name, TUnit unit) {
        TCounter counter = this.countersByName_.get(Preconditions.checkNotNull((Object)name));
        if (counter == null) {
            counter = new TCounter(name, unit, 0L);
            this.countersByName_.put(name, counter);
            this.profile_.counters.add(counter);
            this.profile_.child_counters_map.get(ROOT_COUNTER_NAME).add(name);
        }
        return counter;
    }

    public synchronized void addToCounter(String name, TUnit unit, long delta) {
        Preconditions.checkState((this.profile_ != null ? 1 : 0) != 0, (Object)"already emitted profile");
        TCounter counter = this.getOrCreateCounter(name, unit);
        counter.value += delta;
    }

    public synchronized void setToCounter(String name, TUnit unit, long value) {
        Preconditions.checkState((this.profile_ != null ? 1 : 0) != 0, (Object)"already emitted profile");
        TCounter counter = this.getOrCreateCounter(name, unit);
        counter.value = value;
    }

    public static class Scope
    implements AutoCloseable {
        private final FrontendProfile oldThreadLocalValue_ = (FrontendProfile)FrontendProfile.access$100().get();

        private Scope(FrontendProfile profile) {
            Preconditions.checkState((this.oldThreadLocalValue_ == null ? 1 : 0) != 0);
            THREAD_LOCAL.set(profile);
        }

        @Override
        public void close() {
            THREAD_LOCAL.set(this.oldThreadLocalValue_);
        }
    }
}

