/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.impala.analysis.AlterDbStmt;
import org.apache.impala.analysis.AnalysisContext;
import org.apache.impala.analysis.CommentOnStmt;
import org.apache.impala.analysis.CopyTestCaseStmt;
import org.apache.impala.analysis.CreateDataSrcStmt;
import org.apache.impala.analysis.CreateDropRoleStmt;
import org.apache.impala.analysis.CreateFunctionStmtBase;
import org.apache.impala.analysis.CreateUdaStmt;
import org.apache.impala.analysis.CreateUdfStmt;
import org.apache.impala.analysis.DescribeTableStmt;
import org.apache.impala.analysis.DmlStatementBase;
import org.apache.impala.analysis.DropDataSrcStmt;
import org.apache.impala.analysis.DropFunctionStmt;
import org.apache.impala.analysis.DropStatsStmt;
import org.apache.impala.analysis.DropTableOrViewStmt;
import org.apache.impala.analysis.GrantRevokePrivStmt;
import org.apache.impala.analysis.GrantRevokeRoleStmt;
import org.apache.impala.analysis.InsertStmt;
import org.apache.impala.analysis.Parser;
import org.apache.impala.analysis.QueryStmt;
import org.apache.impala.analysis.ResetMetadataStmt;
import org.apache.impala.analysis.ShowFunctionsStmt;
import org.apache.impala.analysis.ShowGrantPrincipalStmt;
import org.apache.impala.analysis.ShowRolesStmt;
import org.apache.impala.analysis.StatementBase;
import org.apache.impala.analysis.StmtMetadataLoader;
import org.apache.impala.analysis.TableName;
import org.apache.impala.analysis.TruncateStmt;
import org.apache.impala.authentication.saml.ImpalaSamlClient;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.authorization.AuthorizationConfig;
import org.apache.impala.authorization.AuthorizationFactory;
import org.apache.impala.authorization.AuthorizationManager;
import org.apache.impala.authorization.ImpalaInternalAdminUser;
import org.apache.impala.authorization.Privilege;
import org.apache.impala.authorization.PrivilegeRequest;
import org.apache.impala.authorization.PrivilegeRequestBuilder;
import org.apache.impala.authorization.User;
import org.apache.impala.catalog.Catalog;
import org.apache.impala.catalog.Column;
import org.apache.impala.catalog.DatabaseNotFoundException;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.FeCatalogUtils;
import org.apache.impala.catalog.FeDataSource;
import org.apache.impala.catalog.FeDataSourceTable;
import org.apache.impala.catalog.FeDb;
import org.apache.impala.catalog.FeFsPartition;
import org.apache.impala.catalog.FeFsTable;
import org.apache.impala.catalog.FeHBaseTable;
import org.apache.impala.catalog.FeIcebergTable;
import org.apache.impala.catalog.FeKuduTable;
import org.apache.impala.catalog.FeSystemTable;
import org.apache.impala.catalog.FeTable;
import org.apache.impala.catalog.Function;
import org.apache.impala.catalog.IcebergPositionDeleteTable;
import org.apache.impala.catalog.ImpaladTableUsageTracker;
import org.apache.impala.catalog.MaterializedViewHdfsTable;
import org.apache.impala.catalog.MetaStoreClientPool;
import org.apache.impala.catalog.StructType;
import org.apache.impala.catalog.TableLoadingException;
import org.apache.impala.catalog.Type;
import org.apache.impala.catalog.iceberg.IcebergMetadataTable;
import org.apache.impala.catalog.local.InconsistentMetadataFetchException;
import org.apache.impala.common.AnalysisException;
import org.apache.impala.common.FileSystemUtil;
import org.apache.impala.common.ImpalaException;
import org.apache.impala.common.ImpalaRuntimeException;
import org.apache.impala.common.InternalException;
import org.apache.impala.common.KuduTransactionManager;
import org.apache.impala.common.NotImplementedException;
import org.apache.impala.common.PrintUtils;
import org.apache.impala.common.RuntimeEnv;
import org.apache.impala.common.TransactionException;
import org.apache.impala.common.TransactionKeepalive;
import org.apache.impala.compat.MetastoreShim;
import org.apache.impala.hooks.QueryCompleteContext;
import org.apache.impala.hooks.QueryEventHook;
import org.apache.impala.hooks.QueryEventHookManager;
import org.apache.impala.planner.HdfsScanNode;
import org.apache.impala.planner.PlanFragment;
import org.apache.impala.planner.PlanNode;
import org.apache.impala.planner.Planner;
import org.apache.impala.planner.ScanNode;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.service.DescribeResultFactory;
import org.apache.impala.service.FeCatalogManager;
import org.apache.impala.service.FrontendProfile;
import org.apache.impala.service.MetadataOp;
import org.apache.impala.thrift.CatalogLookupStatus;
import org.apache.impala.thrift.TAlterDbParams;
import org.apache.impala.thrift.TBackendGflags;
import org.apache.impala.thrift.TCatalogOpRequest;
import org.apache.impala.thrift.TCatalogOpType;
import org.apache.impala.thrift.TCatalogServiceRequestHeader;
import org.apache.impala.thrift.TClientRequest;
import org.apache.impala.thrift.TColumn;
import org.apache.impala.thrift.TColumnValue;
import org.apache.impala.thrift.TCommentOnParams;
import org.apache.impala.thrift.TConvertTableRequest;
import org.apache.impala.thrift.TCopyTestCaseReq;
import org.apache.impala.thrift.TCounter;
import org.apache.impala.thrift.TCreateDropRoleParams;
import org.apache.impala.thrift.TDdlExecRequest;
import org.apache.impala.thrift.TDdlQueryOptions;
import org.apache.impala.thrift.TDdlType;
import org.apache.impala.thrift.TDescribeHistoryParams;
import org.apache.impala.thrift.TDescribeOutputStyle;
import org.apache.impala.thrift.TDescribeResult;
import org.apache.impala.thrift.TDescribeTableParams;
import org.apache.impala.thrift.TExecRequest;
import org.apache.impala.thrift.TExecutorGroupSet;
import org.apache.impala.thrift.TExplainResult;
import org.apache.impala.thrift.TFinalizeParams;
import org.apache.impala.thrift.TFunctionCategory;
import org.apache.impala.thrift.TGetCatalogMetricsResult;
import org.apache.impala.thrift.TGetTableHistoryResult;
import org.apache.impala.thrift.TGetTableHistoryResultItem;
import org.apache.impala.thrift.TGrantRevokePrivParams;
import org.apache.impala.thrift.TGrantRevokeRoleParams;
import org.apache.impala.thrift.TIcebergDmlFinalizeParams;
import org.apache.impala.thrift.TIcebergOperation;
import org.apache.impala.thrift.TImpalaQueryOptions;
import org.apache.impala.thrift.TImpalaTableType;
import org.apache.impala.thrift.TLineageGraph;
import org.apache.impala.thrift.TLoadDataReq;
import org.apache.impala.thrift.TLoadDataResp;
import org.apache.impala.thrift.TMetadataOpRequest;
import org.apache.impala.thrift.TPlanExecInfo;
import org.apache.impala.thrift.TPlanFragment;
import org.apache.impala.thrift.TPoolConfig;
import org.apache.impala.thrift.TQueryCtx;
import org.apache.impala.thrift.TQueryExecRequest;
import org.apache.impala.thrift.TQueryOptions;
import org.apache.impala.thrift.TResetMetadataRequest;
import org.apache.impala.thrift.TResultRow;
import org.apache.impala.thrift.TResultSet;
import org.apache.impala.thrift.TResultSetMetadata;
import org.apache.impala.thrift.TRuntimeProfileNode;
import org.apache.impala.thrift.TShowFilesParams;
import org.apache.impala.thrift.TShowStatsOp;
import org.apache.impala.thrift.TSlotCountStrategy;
import org.apache.impala.thrift.TStmtType;
import org.apache.impala.thrift.TTableName;
import org.apache.impala.thrift.TTruncateParams;
import org.apache.impala.thrift.TUniqueId;
import org.apache.impala.thrift.TUnit;
import org.apache.impala.thrift.TUpdateCatalogCacheRequest;
import org.apache.impala.thrift.TUpdateCatalogCacheResponse;
import org.apache.impala.util.AcidUtils;
import org.apache.impala.util.DebugUtils;
import org.apache.impala.util.EventSequence;
import org.apache.impala.util.ExecutorMembershipSnapshot;
import org.apache.impala.util.IcebergUtil;
import org.apache.impala.util.KuduUtil;
import org.apache.impala.util.MigrateTableUtil;
import org.apache.impala.util.PatternMatcher;
import org.apache.impala.util.RequestPoolService;
import org.apache.impala.util.TResultRowBuilder;
import org.apache.impala.util.TSessionStateUtil;
import org.apache.impala.util.TUniqueIdUtil;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduTransaction;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Frontend {
    private static final Logger LOG = LoggerFactory.getLogger(Frontend.class);
    public static final long MAX_CATALOG_UPDATE_WAIT_TIME_MS = 2000L;
    private static final int AUTHORIZATION_POLICY_RELOAD_INTERVAL_SECS = 300;
    private static final int INCONSISTENT_METADATA_NUM_RETRIES = BackendConfig.INSTANCE != null ? BackendConfig.INSTANCE.getLocalCatalogMaxFetchRetries() : 0;
    private static final int MAX_CHECK_AUTHORIZATION_POOL_SIZE = 128;
    private static final String DEFAULT_POOL_NAME = "default-pool";
    private static final String EXECUTOR_GROUPS_CONSIDERED = "ExecutorGroupsConsidered";
    private static final String CPU_COUNT_DIVISOR = "CpuCountDivisor";
    private static final String EFFECTIVE_PARALLELISM = "EffectiveParallelism";
    private static final String MAX_PARALLELISM = "MaxParallelism";
    private static final String VERDICT = "Verdict";
    private static final String MEMORY_MAX = "MemoryMax";
    private static final String MEMORY_ASK = "MemoryAsk";
    private static final String CPU_MAX = "CpuMax";
    private static final String CPU_ASK = "CpuAsk";
    private static final String CPU_ASK_BOUNDED = "CpuAskBounded";
    private static final String AVG_ADMISSION_SLOTS_PER_EXECUTOR = "AvgAdmissionSlotsPerExecutor";
    public static final String PLANNER_PROFILE = "PlannerInfo";
    public static final String PLANNER_TYPE = "PlannerType";
    private static final String PLANNER = "OriginalPlanner";
    private final FeCatalogManager catalogManager_;
    private final AuthorizationFactory authzFactory_;
    private final AuthorizationManager authzManager_;
    private final EnumSet<Privilege> minPrivilegeSetForShowStmts_;
    private final AtomicReference<AuthorizationChecker> authzChecker_ = new AtomicReference();
    private final ImpaladTableUsageTracker impaladTableUsageTracker_;
    private final QueryEventHookManager queryHookManager_;
    private final MetaStoreClientPool metaStoreClientPool_;
    private final TransactionKeepalive transactionKeepalive_;
    private static ExecutorService checkAuthorizationPool_;
    private final ImpalaSamlClient saml2Client_;
    private final KuduTransactionManager kuduTxnManager_;

    public Frontend(AuthorizationFactory authzFactory, boolean isBackendTest) throws ImpalaException {
        this(authzFactory, FeCatalogManager.createFromBackendConfig(), isBackendTest);
    }

    @VisibleForTesting
    public Frontend(AuthorizationFactory authzFactory, FeCatalog testCatalog) throws ImpalaException {
        this(authzFactory, FeCatalogManager.createForTests(testCatalog), false);
    }

    private Frontend(AuthorizationFactory authzFactory, FeCatalogManager catalogManager, boolean isBackendTest) throws ImpalaException {
        this.catalogManager_ = catalogManager;
        this.authzFactory_ = authzFactory;
        AuthorizationConfig authzConfig = authzFactory.getAuthorizationConfig();
        if (authzConfig.isEnabled()) {
            this.authzChecker_.set(authzFactory.newAuthorizationChecker(this.getCatalog().getAuthPolicy()));
            int numThreads = BackendConfig.INSTANCE.getNumCheckAuthorizationThreads();
            Preconditions.checkState((numThreads > 0 && numThreads <= 128 ? 1 : 0) != 0);
            if (numThreads == 1) {
                checkAuthorizationPool_ = MoreExecutors.newDirectExecutorService();
            } else {
                LOG.info("Using a thread pool of size {} for authorization", (Object)numThreads);
                checkAuthorizationPool_ = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat("AuthorizationCheckerThread-%d").build());
            }
        } else {
            this.authzChecker_.set(authzFactory.newAuthorizationChecker());
        }
        this.catalogManager_.setAuthzChecker(this.authzChecker_);
        this.authzManager_ = authzFactory.newAuthorizationManager(this.catalogManager_, this.authzChecker_::get);
        this.minPrivilegeSetForShowStmts_ = this.getMinPrivilegeSetForShowStmts();
        this.impaladTableUsageTracker_ = ImpaladTableUsageTracker.createFromConfig(BackendConfig.INSTANCE);
        this.queryHookManager_ = QueryEventHookManager.createFromConfig(BackendConfig.INSTANCE);
        if (!isBackendTest) {
            TBackendGflags cfg = BackendConfig.INSTANCE.getBackendCfg();
            this.metaStoreClientPool_ = new MetaStoreClientPool(1, cfg.initial_hms_cnxn_timeout_s);
            this.transactionKeepalive_ = MetastoreShim.getMajorVersion() > 2L ? new TransactionKeepalive(this.metaStoreClientPool_) : null;
        } else {
            this.metaStoreClientPool_ = null;
            this.transactionKeepalive_ = null;
        }
        this.saml2Client_ = !BackendConfig.INSTANCE.getSaml2IdpMetadata().isEmpty() ? ImpalaSamlClient.get() : null;
        this.kuduTxnManager_ = new KuduTransactionManager();
    }

    private EnumSet<Privilege> getMinPrivilegeSetForShowStmts() throws InternalException {
        String configStr = BackendConfig.INSTANCE.getMinPrivilegeSetForShowStmts();
        if (Strings.isNullOrEmpty((String)configStr)) {
            return EnumSet.of(Privilege.ANY);
        }
        EnumSet<Privilege> privileges = EnumSet.noneOf(Privilege.class);
        for (String pStr : configStr.toUpperCase().split(",")) {
            try {
                privileges.add(Privilege.valueOf(pStr.trim()));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Illegal privilege name '{}'", (Object)pStr, (Object)e);
                throw new InternalException("Failed to parse privileges: " + configStr, e);
            }
        }
        return privileges.isEmpty() ? EnumSet.of(Privilege.ANY) : privileges;
    }

    public FeCatalog getCatalog() {
        return this.catalogManager_.getOrCreateCatalog();
    }

    public AuthorizationFactory getAuthzFactory() {
        return this.authzFactory_;
    }

    public AuthorizationChecker getAuthzChecker() {
        return this.authzChecker_.get();
    }

    public AuthorizationManager getAuthzManager() {
        return this.authzManager_;
    }

    public ImpaladTableUsageTracker getImpaladTableUsageTracker() {
        return this.impaladTableUsageTracker_;
    }

    public ImpalaSamlClient getSaml2Client() {
        return this.saml2Client_;
    }

    public TUpdateCatalogCacheResponse updateCatalogCache(TUpdateCatalogCacheRequest req) throws ImpalaException, TException {
        TUpdateCatalogCacheResponse resp = this.catalogManager_.updateCatalogCache(req);
        if (!req.is_delta) {
            this.authzChecker_.set(this.authzFactory_.newAuthorizationChecker(this.getCatalog().getAuthPolicy()));
        }
        return resp;
    }

    private void createCatalogOpRequest(AnalysisContext.AnalysisResult analysis, TExecRequest result) throws InternalException {
        TDdlExecRequest req;
        Comparable<TCreateDropRoleParams> params;
        StatementBase stmt;
        Comparable<TDdlExecRequest> req2;
        TDdlExecRequest req3;
        StatementBase stmt2;
        TCatalogOpRequest ddl = new TCatalogOpRequest();
        TResultSetMetadata metadata = new TResultSetMetadata();
        if (analysis.isUseStmt()) {
            ddl.op_type = TCatalogOpType.USE;
            ddl.setUse_db_params(analysis.getUseStmt().toThrift());
            metadata.setColumns(Collections.emptyList());
        } else if (analysis.isShowTablesStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_TABLES;
            ddl.setShow_tables_params(analysis.getShowTablesStmt().toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("name", Type.STRING.toThrift())));
        } else if (analysis.isShowMetadataTablesStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_METADATA_TABLES;
            ddl.setShow_tables_params(analysis.getShowMetadataTablesStmt().toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("name", Type.STRING.toThrift())));
        } else if (analysis.isShowViewsStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_VIEWS;
            ddl.setShow_tables_params(analysis.getShowViewsStmt().toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("name", Type.STRING.toThrift())));
        } else if (analysis.isShowDbsStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_DBS;
            ddl.setShow_dbs_params(analysis.getShowDbsStmt().toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("name", Type.STRING.toThrift()), new TColumn("comment", Type.STRING.toThrift())));
        } else if (analysis.isShowDataSrcsStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_DATA_SRCS;
            ddl.setShow_data_srcs_params(analysis.getShowDataSrcsStmt().toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("name", Type.STRING.toThrift()), new TColumn("location", Type.STRING.toThrift()), new TColumn("class name", Type.STRING.toThrift()), new TColumn("api version", Type.STRING.toThrift())));
        } else if (analysis.isShowStatsStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_STATS;
            ddl.setShow_stats_params(analysis.getShowStatsStmt().toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("name", Type.STRING.toThrift())));
        } else if (analysis.isShowFunctionsStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_FUNCTIONS;
            stmt2 = (ShowFunctionsStmt)analysis.getStmt();
            ddl.setShow_fns_params(((ShowFunctionsStmt)stmt2).toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("return type", Type.STRING.toThrift()), new TColumn("signature", Type.STRING.toThrift()), new TColumn("binary type", Type.STRING.toThrift()), new TColumn("is persistent", Type.STRING.toThrift())));
        } else if (analysis.isShowCreateTableStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_CREATE_TABLE;
            ddl.setShow_create_table_params(analysis.getShowCreateTableStmt().toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("result", Type.STRING.toThrift())));
        } else if (analysis.isShowCreateFunctionStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_CREATE_FUNCTION;
            ddl.setShow_create_function_params(analysis.getShowCreateFunctionStmt().toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("result", Type.STRING.toThrift())));
        } else if (analysis.isShowFilesStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_FILES;
            ddl.setShow_files_params(analysis.getShowFilesStmt().toThrift());
            metadata.setColumns(Collections.emptyList());
        } else if (analysis.isDescribeHistoryStmt()) {
            ddl.op_type = TCatalogOpType.DESCRIBE_HISTORY;
            ddl.setDescribe_history_params(analysis.getDescribeHistoryStmt().toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("creation_time", Type.STRING.toThrift()), new TColumn("snapshot_id", Type.STRING.toThrift()), new TColumn("parent_id", Type.STRING.toThrift()), new TColumn("is_current_ancestor", Type.STRING.toThrift())));
        } else if (analysis.isDescribeDbStmt()) {
            ddl.op_type = TCatalogOpType.DESCRIBE_DB;
            ddl.setDescribe_db_params(analysis.getDescribeDbStmt().toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("name", Type.STRING.toThrift()), new TColumn("location", Type.STRING.toThrift()), new TColumn("comment", Type.STRING.toThrift())));
        } else if (analysis.isDescribeTableStmt()) {
            ddl.op_type = TCatalogOpType.DESCRIBE_TABLE;
            DescribeTableStmt descStmt = analysis.getDescribeTableStmt();
            ddl.setDescribe_table_params(descStmt.toThrift());
            ArrayList columns = Lists.newArrayList((Object[])new TColumn[]{new TColumn("name", Type.STRING.toThrift()), new TColumn("type", Type.STRING.toThrift()), new TColumn("comment", Type.STRING.toThrift())});
            if (descStmt.targetsTable() && descStmt.getOutputStyle() == TDescribeOutputStyle.MINIMAL) {
                if (descStmt.getTable() instanceof FeKuduTable) {
                    columns.add(new TColumn("primary_key", Type.STRING.toThrift()));
                    columns.add(new TColumn("key_unique", Type.STRING.toThrift()));
                    columns.add(new TColumn("nullable", Type.STRING.toThrift()));
                    columns.add(new TColumn("default_value", Type.STRING.toThrift()));
                    columns.add(new TColumn("encoding", Type.STRING.toThrift()));
                    columns.add(new TColumn("compression", Type.STRING.toThrift()));
                    columns.add(new TColumn("block_size", Type.STRING.toThrift()));
                } else if (descStmt.getTable() instanceof FeIcebergTable || descStmt.getTable() instanceof IcebergMetadataTable) {
                    columns.add(new TColumn("nullable", Type.STRING.toThrift()));
                }
            }
            metadata.setColumns(columns);
        } else if (analysis.isAlterTableStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.ALTER_TABLE);
            req3.setAlter_table_params(analysis.getAlterTableStmt().toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isAlterViewStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.ALTER_VIEW);
            req3.setAlter_view_params(analysis.getAlterViewStmt().toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isCreateTableStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.CREATE_TABLE);
            req3.setCreate_table_params(analysis.getCreateTableStmt().toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isCreateTableAsSelectStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.CREATE_TABLE_AS_SELECT);
            req3.setCreate_table_params(analysis.getCreateTableAsSelectStmt().getCreateStmt().toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isCreateTableLikeStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.CREATE_TABLE_LIKE);
            req3.setCreate_table_like_params(analysis.getCreateTableLikeStmt().toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isCreateViewStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.CREATE_VIEW);
            req3.setCreate_view_params(analysis.getCreateViewStmt().toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isCreateDbStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.CREATE_DATABASE);
            req3.setCreate_db_params(analysis.getCreateDbStmt().toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isCreateUdfStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            stmt2 = (CreateUdfStmt)analysis.getStmt();
            req2 = new TDdlExecRequest();
            req2.setDdl_type(TDdlType.CREATE_FUNCTION);
            req2.setCreate_fn_params(((CreateFunctionStmtBase)stmt2).toThrift());
            ddl.setDdl_params((TDdlExecRequest)req2);
        } else if (analysis.isCreateUdaStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.CREATE_FUNCTION);
            stmt = (CreateUdaStmt)analysis.getStmt();
            req3.setCreate_fn_params(((CreateFunctionStmtBase)stmt).toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isCreateDataSrcStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.CREATE_DATA_SOURCE);
            stmt = (CreateDataSrcStmt)analysis.getStmt();
            req3.setCreate_data_source_params(((CreateDataSrcStmt)stmt).toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isComputeStatsStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.COMPUTE_STATS);
            req3.setCompute_stats_params(analysis.getComputeStatsStmt().toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isDropDbStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.DROP_DATABASE);
            req3.setDrop_db_params(analysis.getDropDbStmt().toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isDropTableOrViewStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            stmt = analysis.getDropTableOrViewStmt();
            req3.setDdl_type(((DropTableOrViewStmt)stmt).isDropTable() ? TDdlType.DROP_TABLE : TDdlType.DROP_VIEW);
            req3.setDrop_table_or_view_params(((DropTableOrViewStmt)stmt).toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isTruncateStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            stmt = analysis.getTruncateStmt();
            req3.setDdl_type(TDdlType.TRUNCATE_TABLE);
            TTruncateParams truncateParams = ((TruncateStmt)stmt).toThrift();
            TQueryOptions queryOptions = result.getQuery_options();
            if (!queryOptions.isDelete_stats_in_truncate()) {
                truncateParams.setDelete_stats(false);
            }
            req3.setTruncate_params(truncateParams);
            ddl.setDdl_params(req3);
        } else if (analysis.isDropFunctionStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.DROP_FUNCTION);
            stmt = (DropFunctionStmt)analysis.getStmt();
            req3.setDrop_fn_params(((DropFunctionStmt)stmt).toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isDropDataSrcStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.DROP_DATA_SOURCE);
            stmt = (DropDataSrcStmt)analysis.getStmt();
            req3.setDrop_data_source_params(((DropDataSrcStmt)stmt).toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isDropStatsStmt()) {
            ddl.op_type = TCatalogOpType.DDL;
            req3 = new TDdlExecRequest();
            req3.setDdl_type(TDdlType.DROP_STATS);
            stmt = (DropStatsStmt)analysis.getStmt();
            req3.setDrop_stats_params(((DropStatsStmt)stmt).toThrift());
            ddl.setDdl_params(req3);
        } else if (analysis.isResetMetadataStmt()) {
            ddl.op_type = TCatalogOpType.RESET_METADATA;
            ResetMetadataStmt resetMetadataStmt = (ResetMetadataStmt)analysis.getStmt();
            req2 = resetMetadataStmt.toThrift();
            ddl.setReset_metadata_params((TResetMetadataRequest)req2);
            metadata.setColumns(Collections.emptyList());
        } else if (analysis.isShowRolesStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_ROLES;
            ShowRolesStmt showRolesStmt = (ShowRolesStmt)analysis.getStmt();
            ddl.setShow_roles_params(showRolesStmt.toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("role_name", Type.STRING.toThrift())));
        } else if (analysis.isShowGrantPrincipalStmt()) {
            ddl.op_type = TCatalogOpType.SHOW_GRANT_PRINCIPAL;
            ShowGrantPrincipalStmt showGrantPrincipalStmt = (ShowGrantPrincipalStmt)analysis.getStmt();
            ddl.setShow_grant_principal_params(showGrantPrincipalStmt.toThrift());
            metadata.setColumns(Arrays.asList(new TColumn("name", Type.STRING.toThrift())));
        } else if (analysis.isCreateDropRoleStmt()) {
            CreateDropRoleStmt createDropRoleStmt = (CreateDropRoleStmt)analysis.getStmt();
            params = createDropRoleStmt.toThrift();
            req = new TDdlExecRequest();
            req.setDdl_type(((TCreateDropRoleParams)params).isIs_drop() ? TDdlType.DROP_ROLE : TDdlType.CREATE_ROLE);
            req.setCreate_drop_role_params((TCreateDropRoleParams)params);
            ddl.op_type = TCatalogOpType.DDL;
            ddl.setDdl_params(req);
        } else if (analysis.isGrantRevokeRoleStmt()) {
            GrantRevokeRoleStmt grantRoleStmt = (GrantRevokeRoleStmt)analysis.getStmt();
            params = grantRoleStmt.toThrift();
            req = new TDdlExecRequest();
            req.setDdl_type(((TGrantRevokeRoleParams)params).isIs_grant() ? TDdlType.GRANT_ROLE : TDdlType.REVOKE_ROLE);
            req.setGrant_revoke_role_params((TGrantRevokeRoleParams)params);
            ddl.op_type = TCatalogOpType.DDL;
            ddl.setDdl_params(req);
        } else if (analysis.isGrantRevokePrivStmt()) {
            GrantRevokePrivStmt grantRevokePrivStmt = (GrantRevokePrivStmt)analysis.getStmt();
            params = grantRevokePrivStmt.toThrift();
            req = new TDdlExecRequest();
            req.setDdl_type(((TGrantRevokePrivParams)params).isIs_grant() ? TDdlType.GRANT_PRIVILEGE : TDdlType.REVOKE_PRIVILEGE);
            req.setGrant_revoke_priv_params((TGrantRevokePrivParams)params);
            ddl.op_type = TCatalogOpType.DDL;
            ddl.setDdl_params(req);
        } else if (analysis.isCommentOnStmt()) {
            CommentOnStmt commentOnStmt = analysis.getCommentOnStmt();
            params = commentOnStmt.toThrift();
            req = new TDdlExecRequest();
            req.setDdl_type(TDdlType.COMMENT_ON);
            req.setComment_on_params((TCommentOnParams)params);
            ddl.op_type = TCatalogOpType.DDL;
            ddl.setDdl_params(req);
        } else if (analysis.isAlterDbStmt()) {
            AlterDbStmt alterDbStmt = analysis.getAlterDbStmt();
            params = alterDbStmt.toThrift();
            req = new TDdlExecRequest();
            req.setDdl_type(TDdlType.ALTER_DATABASE);
            req.setAlter_db_params((TAlterDbParams)params);
            ddl.op_type = TCatalogOpType.DDL;
            ddl.setDdl_params(req);
        } else if (analysis.isTestCaseStmt()) {
            stmt2 = (CopyTestCaseStmt)analysis.getStmt();
            req2 = new TCopyTestCaseReq(((CopyTestCaseStmt)stmt2).getHdfsPath());
            TDdlExecRequest ddlReq = new TDdlExecRequest();
            ddlReq.setCopy_test_case_params((TCopyTestCaseReq)req2);
            ddlReq.setDdl_type(TDdlType.COPY_TESTCASE);
            ddl.op_type = TCatalogOpType.DDL;
            ddl.setDdl_params(ddlReq);
        } else {
            throw new IllegalStateException("Unexpected CatalogOp statement type.");
        }
        if (ddl.op_type == TCatalogOpType.DDL) {
            metadata.setColumns(Arrays.asList(new TColumn("summary", Type.STRING.toThrift())));
        }
        result.setResult_set_metadata(metadata);
        ddl.setSync_ddl(result.getQuery_options().isSync_ddl());
        result.setCatalog_op_request(ddl);
        if (ddl.getOp_type() == TCatalogOpType.DDL) {
            TCatalogServiceRequestHeader header = new TCatalogServiceRequestHeader();
            header.setRequesting_user(analysis.getAnalyzer().getUser().getName());
            TQueryCtx queryCtx = analysis.getAnalyzer().getQueryCtx();
            header.setQuery_id(queryCtx.query_id);
            header.setClient_ip(queryCtx.getSession().getNetwork_address().getHostname());
            TClientRequest clientRequest = queryCtx.getClient_request();
            header.setRedacted_sql_stmt(clientRequest.isSetRedacted_stmt() ? clientRequest.getRedacted_stmt() : clientRequest.getStmt());
            header.setWant_minimal_response(BackendConfig.INSTANCE.getBackendCfg().use_local_catalog);
            header.setCoordinator_hostname(BackendConfig.INSTANCE.getHostname());
            ddl.getDdl_params().setHeader(header);
            TDdlQueryOptions ddlQueryOpts = new TDdlQueryOptions();
            ddlQueryOpts.setSync_ddl(result.getQuery_options().isSync_ddl());
            if (result.getQuery_options().isSetDebug_action()) {
                ddlQueryOpts.setDebug_action(result.getQuery_options().getDebug_action());
            }
            ddlQueryOpts.setLock_max_wait_time_s(result.getQuery_options().lock_max_wait_time_s);
            ddlQueryOpts.setKudu_table_reserve_seconds(result.getQuery_options().kudu_table_reserve_seconds);
            ddl.getDdl_params().setQuery_options(ddlQueryOpts);
        } else if (ddl.getOp_type() == TCatalogOpType.RESET_METADATA) {
            ddl.getReset_metadata_params().setSync_ddl(ddl.isSync_ddl());
            ddl.getReset_metadata_params().setRefresh_updated_hms_partitions(result.getQuery_options().isRefresh_updated_hms_partitions());
            ddl.getReset_metadata_params().getHeader().setWant_minimal_response(BackendConfig.INSTANCE.getBackendCfg().use_local_catalog);
            if (result.getQuery_options().isSetDebug_action()) {
                ddl.getReset_metadata_params().setDebug_action(result.getQuery_options().getDebug_action());
            }
        }
    }

    public TLoadDataResp loadTableData(TLoadDataReq request) throws ImpalaException, IOException {
        TTableName tableName = request.getTable_name();
        RetryTracker retries = new RetryTracker(String.format("load table data %s.%s", tableName.db_name, tableName.table_name));
        while (true) {
            try {
                if (!request.iceberg_tbl) {
                    return this.doLoadTableData(request);
                }
                return this.doLoadIcebergTableData(request);
            }
            catch (InconsistentMetadataFetchException e) {
                retries.handleRetryOrThrow(e);
                continue;
            }
            break;
        }
    }

    public void convertTable(TExecRequest execRequest) throws DatabaseNotFoundException, ImpalaRuntimeException, InternalException {
        Preconditions.checkState((boolean)execRequest.isSetConvert_table_request());
        TQueryOptions queryOptions = execRequest.query_options;
        TConvertTableRequest convertTableRequest = execRequest.convert_table_request;
        TTableName tableName = convertTableRequest.getHdfs_table_name();
        FeTable table = this.getCatalog().getTable(tableName.getDb_name(), tableName.getTable_name());
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkState((boolean)(table instanceof FeFsTable));
        try (MetaStoreClientPool.MetaStoreClient client = this.metaStoreClientPool_.getClient();){
            MigrateTableUtil.migrateToIcebergTable(client.getHiveClient(), convertTableRequest, (FeFsTable)table, queryOptions);
        }
    }

    private TLoadDataResp doLoadTableData(TLoadDataReq request) throws ImpalaException, IOException {
        TableName tableName = TableName.fromThrift(request.getTable_name());
        String destPathString = null;
        String partitionName = null;
        FeCatalog catalog = this.getCatalog();
        if (request.isSetPartition_spec()) {
            FeFsPartition partition = catalog.getHdfsPartition(tableName.getDb(), tableName.getTbl(), request.getPartition_spec());
            destPathString = partition.getLocation();
            partitionName = partition.getPartitionName();
        } else {
            destPathString = catalog.getTable(tableName.getDb(), tableName.getTbl()).getMetaStoreTable().getSd().getLocation();
        }
        Path destPath = new Path(destPathString);
        Path sourcePath = new Path(request.source_path);
        FileSystem destFs = destPath.getFileSystem(FileSystemUtil.getConfiguration());
        FileSystem sourceFs = sourcePath.getFileSystem(FileSystemUtil.getConfiguration());
        Path tmpDestPath = FileSystemUtil.makeTmpSubdirectory(destPath);
        int numFilesLoaded = 0;
        if (sourceFs.isDirectory(sourcePath)) {
            numFilesLoaded = FileSystemUtil.relocateAllVisibleFiles(sourcePath, tmpDestPath);
        } else {
            FileSystemUtil.relocateFile(sourcePath, tmpDestPath, true);
            numFilesLoaded = 1;
        }
        if (request.isOverwrite()) {
            FileSystemUtil.deleteAllVisibleFiles(destPath);
        }
        ArrayList<Path> filesLoaded = new ArrayList<Path>();
        FileSystemUtil.relocateAllVisibleFiles(tmpDestPath, destPath, filesLoaded);
        destFs.delete(tmpDestPath, true);
        TLoadDataResp response = new TLoadDataResp();
        TColumnValue col = new TColumnValue();
        String loadMsg = String.format("Loaded %d file(s). Total files in destination location: %d", numFilesLoaded, FileSystemUtil.getTotalNumVisibleFiles(destPath));
        col.setString_val(loadMsg);
        response.setLoad_summary(new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{col})));
        response.setLoaded_files(filesLoaded.stream().map(Path::toString).collect(Collectors.toList()));
        if (partitionName != null && !partitionName.isEmpty()) {
            response.setPartition_name(partitionName);
        }
        return response;
    }

    private TLoadDataResp doLoadIcebergTableData(TLoadDataReq request) throws ImpalaException, IOException {
        String destFile;
        TLoadDataResp response = new TLoadDataResp();
        TableName tableName = TableName.fromThrift(request.getTable_name());
        FeCatalog catalog = this.getCatalog();
        String destPathString = catalog.getTable(tableName.getDb(), tableName.getTbl()).getMetaStoreTable().getSd().getLocation();
        Path destPath = new Path(destPathString);
        Path sourcePath = new Path(request.source_path);
        FileSystem sourceFs = sourcePath.getFileSystem(FileSystemUtil.getConfiguration());
        Path tmpDestPath = FileSystemUtil.makeTmpSubdirectory(destPath);
        int numFilesLoaded = 0;
        ArrayList<Path> filesLoaded = new ArrayList<Path>();
        if (sourceFs.isDirectory(sourcePath)) {
            numFilesLoaded = FileSystemUtil.relocateAllVisibleFiles(sourcePath, tmpDestPath, filesLoaded);
            destFile = ((Path)filesLoaded.get(0)).toString();
        } else {
            Path destFilePath = FileSystemUtil.relocateFile(sourcePath, tmpDestPath, true);
            filesLoaded.add(new Path(tmpDestPath.toString() + "/" + sourcePath.getName()));
            numFilesLoaded = 1;
            destFile = destFilePath.toString();
        }
        String createTmpTblQuery = String.format(request.create_tmp_tbl_query_template, destFile, tmpDestPath.toString());
        TColumnValue col = new TColumnValue();
        String loadMsg = String.format("Loaded %d file(s).", numFilesLoaded);
        col.setString_val(loadMsg);
        response.setLoaded_files(filesLoaded.stream().map(Path::toString).collect(Collectors.toList()));
        response.setLoad_summary(new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{col})));
        response.setCreate_tmp_tbl_query(createTmpTblQuery);
        response.setCreate_location(tmpDestPath.toString());
        return response;
    }

    public String getExplainString(TQueryCtx queryCtx) throws ImpalaException {
        PlanCtx planCtx = new PlanCtx(queryCtx);
        this.createExecRequest(planCtx);
        return planCtx.getExplainString();
    }

    public TGetCatalogMetricsResult getCatalogMetrics() {
        TGetCatalogMetricsResult resp = new TGetCatalogMetricsResult();
        if (BackendConfig.INSTANCE.getBackendCfg().use_local_catalog) {
            resp.num_dbs = -1;
            resp.num_tables = -1;
            FeCatalogUtils.populateCacheMetrics(this.getCatalog(), resp);
        } else {
            for (FeDb feDb : this.getCatalog().getDbs(PatternMatcher.MATCHER_MATCH_ALL)) {
                ++resp.num_dbs;
                resp.num_tables += feDb.getAllTableNames().size();
            }
        }
        return resp;
    }

    public List<String> getTableNames(String dbName, PatternMatcher matcher, User user) throws ImpalaException {
        return this.getTableNames(dbName, matcher, user, Collections.emptySet());
    }

    public List<String> getTableNames(String dbName, PatternMatcher matcher, User user, Set<TImpalaTableType> tableTypes) throws ImpalaException {
        RetryTracker retries = new RetryTracker(String.format("fetching %s table names", dbName));
        while (true) {
            try {
                FeCatalog catalog = this.getCatalog();
                List<String> tblNames = catalog.getTableNames(dbName, matcher, tableTypes);
                this.filterTablesIfAuthNeeded(dbName, user, tblNames);
                return tblNames;
            }
            catch (InconsistentMetadataFetchException e) {
                retries.handleRetryOrThrow(e);
                continue;
            }
            catch (DatabaseNotFoundException e) {
                LOG.warn("Database {} no longer exists", (Object)dbName, (Object)e);
                return Collections.emptyList();
            }
            break;
        }
    }

    public List<String> getMetadataTableNames(String dbName, String tblName, PatternMatcher matcher, User user) throws ImpalaException {
        RetryTracker retries = new RetryTracker(String.format("fetching %s table names to query metadata table list", dbName));
        while (true) {
            try {
                return this.doGetMetadataTableNames(dbName, tblName, matcher, user);
            }
            catch (InconsistentMetadataFetchException e) {
                retries.handleRetryOrThrow(e);
                continue;
            }
            break;
        }
    }

    private void filterUnaccessibleElements(List<Future<Boolean>> pendingCheckTasks, List<?> checkList) throws InternalException {
        int failedCheckTasks = 0;
        int index = 0;
        Iterator<?> iter = checkList.iterator();
        Preconditions.checkState((checkList.size() == pendingCheckTasks.size() ? 1 : 0) != 0);
        while (iter.hasNext()) {
            iter.next();
            try {
                if (!pendingCheckTasks.get(index).get().booleanValue()) {
                    iter.remove();
                }
                ++index;
            }
            catch (InterruptedException | ExecutionException e) {
                ++failedCheckTasks;
                LOG.error("Encountered an error checking access", (Throwable)e);
                break;
            }
        }
        if (failedCheckTasks > 0) {
            throw new InternalException("Failed to check access.Check the server log for more details.");
        }
    }

    private void filterTablesIfAuthNeeded(String dbName, User user, List<String> tblNames) throws ImpalaException {
        boolean needsAuthChecks;
        boolean bl = needsAuthChecks = this.authzFactory_.getAuthorizationConfig().isEnabled() && !this.userHasAccessForWholeDb(user, dbName);
        if (needsAuthChecks) {
            ArrayList pendingCheckTasks = Lists.newArrayList();
            for (String tblName : tblNames) {
                FeTable table = this.getCatalog().getTableIfCached(dbName, tblName);
                if (table == null) {
                    LOG.warn("Table {}.{} no longer exists", (Object)dbName, (Object)tblName);
                    continue;
                }
                pendingCheckTasks.add(checkAuthorizationPool_.submit(new CheckTableAuthorization(table, user)));
            }
            this.filterUnaccessibleElements(pendingCheckTasks, tblNames);
        }
    }

    private List<String> doGetMetadataTableNames(String dbName, String catalogTblName, PatternMatcher matcher, User user) throws ImpalaException {
        FeTable catalogTbl = this.getCatalog().getTable(dbName, catalogTblName);
        Preconditions.checkState((boolean)(catalogTbl instanceof FeIcebergTable));
        ArrayList<String> listToFilter = new ArrayList<String>();
        listToFilter.add(catalogTblName);
        this.filterTablesIfAuthNeeded(dbName, user, listToFilter);
        if (listToFilter.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> metadataTblNames = Arrays.stream(MetadataTableType.values()).map(tblType -> tblType.toString().toLowerCase()).collect(Collectors.toList());
        List<String> filteredMetadataTblNames = Catalog.filterStringsByPattern(metadataTblNames, matcher);
        return filteredMetadataTblNames;
    }

    public List<Column> getColumns(FeTable table, PatternMatcher matcher, User user) throws InternalException {
        Preconditions.checkNotNull((Object)table);
        Preconditions.checkNotNull((Object)matcher);
        ArrayList columns = Lists.newArrayList();
        for (Column column : table.getColumnsInHiveOrder()) {
            String colName = column.getName();
            if (!matcher.matches(colName)) continue;
            if (this.authzFactory_.getAuthorizationConfig().isEnabled()) {
                PrivilegeRequest privilegeRequest = new PrivilegeRequestBuilder(this.authzFactory_.getAuthorizableFactory()).any().onColumn(table.getTableName().getDb(), table.getTableName().getTbl(), colName, table.getOwnerUser()).build();
                if (!this.authzChecker_.get().hasAccess(user, privilegeRequest)) continue;
            }
            columns.add(column);
        }
        return columns;
    }

    public List<SQLPrimaryKey> getPrimaryKeys(FeTable table, User user) throws InternalException {
        Preconditions.checkNotNull((Object)table);
        List<SQLPrimaryKey> pkList = table.getSqlConstraints().getPrimaryKeys();
        Preconditions.checkNotNull(pkList);
        for (SQLPrimaryKey pk : pkList) {
            if (!this.authzFactory_.getAuthorizationConfig().isEnabled()) continue;
            PrivilegeRequest privilegeRequest = new PrivilegeRequestBuilder(this.authzFactory_.getAuthorizableFactory()).any().onColumn(table.getTableName().getDb(), table.getTableName().getTbl(), pk.getColumn_name(), table.getOwnerUser()).build();
            if (this.authzChecker_.get().hasAccess(user, privilegeRequest)) continue;
            return new ArrayList<SQLPrimaryKey>();
        }
        return pkList;
    }

    public List<SQLForeignKey> getForeignKeys(FeTable table, User user) throws InternalException {
        Preconditions.checkNotNull((Object)table);
        HashSet<String> omitList = new HashSet<String>();
        ArrayList<SQLForeignKey> fkList = new ArrayList<SQLForeignKey>();
        List<SQLForeignKey> foreignKeys = table.getSqlConstraints().getForeignKeys();
        Preconditions.checkNotNull(foreignKeys);
        for (SQLForeignKey fk : foreignKeys) {
            String fkName = fk.getFk_name();
            if (omitList.contains(fkName) || !this.authzFactory_.getAuthorizationConfig().isEnabled()) continue;
            PrivilegeRequest fkPrivilegeRequest = new PrivilegeRequestBuilder(this.authzFactory_.getAuthorizableFactory()).any().onColumn(table.getTableName().getDb(), table.getTableName().getTbl(), fk.getFkcolumn_name(), table.getOwnerUser()).build();
            FeTable pkTable = this.getCatalog().getTableNoThrow(fk.getPktable_db(), fk.getPktable_name());
            PrivilegeRequest pkPrivilegeRequest = new PrivilegeRequestBuilder(this.authzFactory_.getAuthorizableFactory()).any().onColumn(pkTable.getTableName().getDb(), pkTable.getTableName().getTbl(), fk.getPkcolumn_name(), pkTable.getOwnerUser()).build();
            if (this.authzChecker_.get().hasAccess(user, fkPrivilegeRequest) && this.authzChecker_.get().hasAccess(user, pkPrivilegeRequest)) continue;
            omitList.add(fkName);
        }
        for (SQLForeignKey fk : foreignKeys) {
            if (omitList.contains(fk.getFk_name())) continue;
            fkList.add(fk);
        }
        return fkList;
    }

    public List<? extends FeDb> getDbs(PatternMatcher matcher, User user) throws InternalException {
        boolean needsAuthChecks;
        List<? extends FeDb> dbs = this.getCatalog().getDbs(matcher);
        boolean bl = needsAuthChecks = this.authzFactory_.getAuthorizationConfig().isEnabled() && !this.userHasAccessForWholeServer(user);
        if (needsAuthChecks) {
            Iterator<? extends FeDb> iter = dbs.iterator();
            ArrayList pendingCheckTasks = Lists.newArrayList();
            while (iter.hasNext()) {
                FeDb db = iter.next();
                pendingCheckTasks.add(checkAuthorizationPool_.submit(new CheckDbAuthorization(db, user)));
            }
            this.filterUnaccessibleElements(pendingCheckTasks, dbs);
        }
        return dbs;
    }

    public TGetTableHistoryResult getTableHistory(TDescribeHistoryParams params) throws DatabaseNotFoundException, TableLoadingException {
        FeTable feTable = this.getCatalog().getTable(params.getTable_name().db_name, params.getTable_name().table_name);
        FeIcebergTable feIcebergTable = (FeIcebergTable)feTable;
        Table table = feIcebergTable.getIcebergApiTable();
        HashSet ancestorIds = Sets.newHashSet(IcebergUtil.currentAncestorIds(table));
        TGetTableHistoryResult historyResult = new TGetTableHistoryResult();
        List filteredHistoryEntries = table.history();
        if (params.isSetFrom_time()) {
            filteredHistoryEntries = table.history().stream().filter(c -> c.timestampMillis() >= params.from_time).collect(Collectors.toList());
        } else if (params.isSetBetween_start_time() && params.isSetBetween_end_time()) {
            filteredHistoryEntries = table.history().stream().filter(x -> x.timestampMillis() >= params.between_start_time && x.timestampMillis() <= params.between_end_time).collect(Collectors.toList());
        }
        ArrayList result = Lists.newArrayList();
        for (HistoryEntry historyEntry : filteredHistoryEntries) {
            TGetTableHistoryResultItem resultItem = new TGetTableHistoryResultItem();
            long snapshotId = historyEntry.snapshotId();
            resultItem.setCreation_time(historyEntry.timestampMillis());
            resultItem.setSnapshot_id(snapshotId);
            Snapshot snapshot = table.snapshot(snapshotId);
            if (snapshot != null && snapshot.parentId() != null) {
                resultItem.setParent_id(snapshot.parentId());
            }
            resultItem.setIs_current_ancestor(ancestorIds.contains(snapshotId));
            result.add(resultItem);
        }
        historyResult.setResult(result);
        return historyResult;
    }

    private boolean isAccessibleToUser(String dbName, String tblName, String owner, User user) throws InternalException {
        Preconditions.checkNotNull((Object)dbName);
        if (tblName == null && dbName.equalsIgnoreCase("default")) {
            return true;
        }
        PrivilegeRequestBuilder builder = new PrivilegeRequestBuilder(this.authzFactory_.getAuthorizableFactory()).anyOf(this.minPrivilegeSetForShowStmts_);
        builder = tblName == null ? builder.onAnyColumn(dbName, owner) : builder.onAnyColumn(dbName, tblName, owner);
        return this.authzChecker_.get().hasAnyAccess(user, builder.buildSet());
    }

    private boolean userHasAccessForWholeServer(User user) throws InternalException {
        if (this.authEngineSupportsDenyRules()) {
            return false;
        }
        PrivilegeRequestBuilder builder = new PrivilegeRequestBuilder(this.authzFactory_.getAuthorizableFactory()).anyOf(this.minPrivilegeSetForShowStmts_).onServer(this.authzFactory_.getAuthorizationConfig().getServerName());
        return this.authzChecker_.get().hasAnyAccess(user, builder.buildSet());
    }

    private boolean userHasAccessForWholeDb(User user, String dbName) throws InternalException, DatabaseNotFoundException {
        if (this.authEngineSupportsDenyRules()) {
            return false;
        }
        FeDb db = this.getCatalog().getDb(dbName);
        if (db == null) {
            throw new DatabaseNotFoundException("Database '" + dbName + "' not found");
        }
        PrivilegeRequestBuilder builder = new PrivilegeRequestBuilder(this.authzFactory_.getAuthorizableFactory()).anyOf(this.minPrivilegeSetForShowStmts_).onDb(db);
        return this.authzChecker_.get().hasAnyAccess(user, builder.buildSet());
    }

    private boolean authEngineSupportsDenyRules() {
        return true;
    }

    public List<? extends FeDataSource> getDataSrcs(String pattern) {
        return this.getCatalog().getDataSources(PatternMatcher.createHivePatternMatcher(pattern));
    }

    public TResultSet getColumnStats(String dbName, String tableName, boolean showMinMax) throws ImpalaException {
        RetryTracker retries = new RetryTracker(String.format("fetching column stats from %s.%s", dbName, tableName));
        while (true) {
            try {
                return this.doGetColumnStats(dbName, tableName, showMinMax);
            }
            catch (InconsistentMetadataFetchException e) {
                retries.handleRetryOrThrow(e);
                continue;
            }
            break;
        }
    }

    private TResultSet doGetColumnStats(String dbName, String tableName, boolean showMinMax) throws ImpalaException {
        FeTable table = this.getCatalog().getTable(dbName, tableName);
        TResultSet result = new TResultSet();
        TResultSetMetadata resultSchema = new TResultSetMetadata();
        result.setSchema(resultSchema);
        resultSchema.addToColumns(new TColumn("Column", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("Type", Type.STRING.toThrift()));
        resultSchema.addToColumns(new TColumn("#Distinct Values", Type.BIGINT.toThrift()));
        resultSchema.addToColumns(new TColumn("#Nulls", Type.BIGINT.toThrift()));
        resultSchema.addToColumns(new TColumn("Max Size", Type.BIGINT.toThrift()));
        resultSchema.addToColumns(new TColumn("Avg Size", Type.DOUBLE.toThrift()));
        resultSchema.addToColumns(new TColumn("#Trues", Type.BIGINT.toThrift()));
        resultSchema.addToColumns(new TColumn("#Falses", Type.BIGINT.toThrift()));
        if (showMinMax) {
            resultSchema.addToColumns(new TColumn("Min", Type.STRING.toThrift()));
            resultSchema.addToColumns(new TColumn("Max", Type.STRING.toThrift()));
        }
        for (Column c : table.getColumnsInHiveOrder()) {
            TResultRowBuilder rowBuilder = new TResultRowBuilder();
            if (showMinMax) {
                rowBuilder.add(c.getName()).add(c.getType().toSql()).add(c.getStats().getNumDistinctValues()).add(c.getStats().getNumNulls()).add(c.getStats().getMaxSize()).add(c.getStats().getAvgSize()).add(c.getStats().getNumTrues()).add(c.getStats().getNumFalses()).add(c.getStats().getLowValueAsString()).add(c.getStats().getHighValueAsString());
            } else {
                rowBuilder.add(c.getName()).add(c.getType().toSql()).add(c.getStats().getNumDistinctValues()).add(c.getStats().getNumNulls()).add(c.getStats().getMaxSize()).add(c.getStats().getAvgSize()).add(c.getStats().getNumTrues()).add(c.getStats().getNumFalses());
            }
            result.addToRows(rowBuilder.get());
        }
        return result;
    }

    public TResultSet getTableStats(String dbName, String tableName, TShowStatsOp op) throws ImpalaException {
        RetryTracker retries = new RetryTracker(String.format("fetching table stats from %s.%s", dbName, tableName));
        while (true) {
            try {
                return this.doGetTableStats(dbName, tableName, op);
            }
            catch (InconsistentMetadataFetchException e) {
                retries.handleRetryOrThrow(e);
                continue;
            }
            break;
        }
    }

    private TResultSet doGetTableStats(String dbName, String tableName, TShowStatsOp op) throws ImpalaException {
        FeTable table = this.getCatalog().getTable(dbName, tableName);
        if (table instanceof FeFsTable) {
            if (table instanceof FeIcebergTable && op == TShowStatsOp.PARTITIONS) {
                return FeIcebergTable.Utils.getPartitionStats((FeIcebergTable)table);
            }
            if (table instanceof FeIcebergTable && op == TShowStatsOp.TABLE_STATS) {
                return FeIcebergTable.Utils.getTableStats((FeIcebergTable)table);
            }
            return ((FeFsTable)table).getTableStats();
        }
        if (table instanceof FeHBaseTable) {
            return ((FeHBaseTable)table).getTableStats();
        }
        if (table instanceof FeDataSourceTable) {
            return ((FeDataSourceTable)table).getTableStats();
        }
        if (table instanceof FeKuduTable) {
            if (op == TShowStatsOp.RANGE_PARTITIONS) {
                return FeKuduTable.Utils.getRangePartitions((FeKuduTable)table, false);
            }
            if (op == TShowStatsOp.HASH_SCHEMA) {
                return FeKuduTable.Utils.getRangePartitions((FeKuduTable)table, true);
            }
            if (op == TShowStatsOp.PARTITIONS) {
                return FeKuduTable.Utils.getPartitions((FeKuduTable)table);
            }
            Preconditions.checkState((op == TShowStatsOp.TABLE_STATS ? 1 : 0) != 0);
            return FeKuduTable.Utils.getTableStats((FeKuduTable)table);
        }
        if (table instanceof MaterializedViewHdfsTable) {
            return ((MaterializedViewHdfsTable)table).getTableStats();
        }
        if (table instanceof FeSystemTable) {
            return ((FeSystemTable)table).getTableStats();
        }
        throw new InternalException("Invalid table class: " + table.getClass());
    }

    public List<Function> getFunctions(TFunctionCategory category, String dbName, String fnPattern, boolean exactMatch) throws DatabaseNotFoundException {
        RetryTracker retries = new RetryTracker(String.format("fetching functions from %s", dbName));
        while (true) {
            try {
                return this.doGetFunctions(category, dbName, fnPattern, exactMatch);
            }
            catch (InconsistentMetadataFetchException e) {
                retries.handleRetryOrThrow(e);
                continue;
            }
            break;
        }
    }

    private List<Function> doGetFunctions(TFunctionCategory category, String dbName, String fnPattern, boolean exactMatch) throws DatabaseNotFoundException {
        List<Function> fns;
        FeDb db = this.getCatalog().getDb(dbName);
        if (db == null) {
            throw new DatabaseNotFoundException("Database '" + dbName + "' not found");
        }
        if (exactMatch) {
            Preconditions.checkNotNull((Object)fnPattern, (Object)"Invalid function name");
            fns = db.getFunctions(category, fnPattern);
        } else {
            fns = db.getFunctions(category, PatternMatcher.createHivePatternMatcher(fnPattern));
        }
        Collections.sort(fns, new Comparator<Function>(){

            @Override
            public int compare(Function f1, Function f2) {
                return f1.signatureString().compareTo(f2.signatureString());
            }
        });
        return fns;
    }

    public TDescribeResult describeDb(String dbName, TDescribeOutputStyle outputStyle) throws ImpalaException {
        FeDb db = this.getCatalog().getDb(dbName);
        return DescribeResultFactory.buildDescribeDbResult(db, outputStyle);
    }

    public TDescribeResult describeTable(TDescribeTableParams params, User user) throws ImpalaException {
        if (params.isSetTable_name()) {
            RetryTracker retries = new RetryTracker(String.format("fetching table %s.%s", params.table_name.db_name, params.table_name.table_name));
            while (true) {
                try {
                    return this.doDescribeTable(params.table_name, params.output_style, user, params.metadata_table_name);
                }
                catch (InconsistentMetadataFetchException e) {
                    retries.handleRetryOrThrow(e);
                    continue;
                }
                break;
            }
        }
        Preconditions.checkState((params.output_style == TDescribeOutputStyle.MINIMAL ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)params.result_struct);
        StructType structType = (StructType)Type.fromThrift(params.result_struct);
        return DescribeResultFactory.buildDescribeMinimalResult(structType);
    }

    private List<Column> filterAuthorizedColumnsForDescribeTable(FeTable table, User user) throws InternalException {
        List<Column> authFilteredColumns;
        if (this.authzFactory_.getAuthorizationConfig().isEnabled()) {
            PrivilegeRequest privilegeRequest = new PrivilegeRequestBuilder(this.authzFactory_.getAuthorizableFactory()).allOf(Privilege.VIEW_METADATA).onTable(table).build();
            if (!this.authzChecker_.get().hasAccess(user, privilegeRequest)) {
                authFilteredColumns = new ArrayList<Column>();
                for (Column col : table.getColumnsInHiveOrder()) {
                    String colName = col.getName();
                    privilegeRequest = new PrivilegeRequestBuilder(this.authzFactory_.getAuthorizableFactory()).allOf(Privilege.VIEW_METADATA).onColumn(table.getDb().getName(), table.getName(), colName, table.getOwnerUser()).build();
                    if (!this.authzChecker_.get().hasAccess(user, privilegeRequest)) continue;
                    authFilteredColumns.add(col);
                }
            } else {
                authFilteredColumns = table.getColumnsInHiveOrder();
            }
        } else {
            authFilteredColumns = table.getColumnsInHiveOrder();
        }
        return authFilteredColumns;
    }

    private TDescribeResult doDescribeTable(TTableName tableName, TDescribeOutputStyle outputStyle, User user, String vTableName) throws ImpalaException {
        FeTable table = this.getCatalog().getTable(tableName.db_name, tableName.table_name);
        List<Column> filteredColumns = this.filterAuthorizedColumnsForDescribeTable(table, user);
        if (outputStyle == TDescribeOutputStyle.MINIMAL) {
            if (table instanceof FeKuduTable) {
                return DescribeResultFactory.buildKuduDescribeMinimalResult(filteredColumns);
            }
            if (table instanceof FeIcebergTable) {
                if (vTableName == null) {
                    return DescribeResultFactory.buildIcebergDescribeMinimalResult(filteredColumns);
                }
                Preconditions.checkArgument((vTableName != null ? 1 : 0) != 0);
                return DescribeResultFactory.buildIcebergMetadataDescribeMinimalResult((FeIcebergTable)table, vTableName);
            }
            return DescribeResultFactory.buildDescribeMinimalResult(Column.columnsToStruct(filteredColumns));
        }
        Preconditions.checkArgument((outputStyle == TDescribeOutputStyle.FORMATTED || outputStyle == TDescribeOutputStyle.EXTENDED ? 1 : 0) != 0);
        Preconditions.checkArgument((vTableName == null ? 1 : 0) != 0);
        TDescribeResult result = DescribeResultFactory.buildDescribeFormattedResult(table, filteredColumns);
        if (this.authzFactory_.getAuthorizationConfig().isEnabled()) {
            PrivilegeRequest privilegeRequest = new PrivilegeRequestBuilder(this.authzFactory_.getAuthorizableFactory()).allOf(Privilege.VIEW_METADATA).onTable(table).build();
            if (!this.authzChecker_.get().hasAccess(user, privilegeRequest)) {
                ArrayList<TResultRow> results = new ArrayList<TResultRow>();
                for (TResultRow row : result.getResults()) {
                    String stringVal = row.getColVals().get(0).getString_val();
                    if (stringVal.contains("Location")) continue;
                    results.add(row);
                }
                result.setResults(results);
            }
        }
        return result;
    }

    public void waitForCatalog() {
        LOG.info("Waiting for first catalog update from the statestore.");
        int numTries = 0;
        long startTimeMs = System.currentTimeMillis();
        while (true) {
            FeCatalog catalog;
            if ((catalog = this.getCatalog()).isReady()) {
                LOG.info("Local catalog initialized after: " + (System.currentTimeMillis() - startTimeMs) + " ms.");
                return;
            }
            LOG.info("Waiting for local catalog to be initialized, attempt: " + numTries);
            catalog.waitForCatalogUpdate(2000L);
            ++numTries;
        }
    }

    public static TPlanExecInfo createPlanExecInfo(PlanFragment planRoot, TQueryCtx queryCtx) {
        TPlanExecInfo result = new TPlanExecInfo();
        List<PlanFragment> fragments = planRoot.getFragmentsInPlanPreorder();
        ArrayList scanNodes = Lists.newArrayList();
        for (PlanFragment fragment : fragments) {
            fragment.collectPlanNodes((Predicate<? super PlanNode>)Predicates.instanceOf(ScanNode.class), scanNodes);
        }
        LOG.trace("get scan range locations");
        TreeSet tablesMissingStats = Sets.newTreeSet();
        TreeSet tablesWithCorruptStats = Sets.newTreeSet();
        TreeSet tablesWithMissingDiskIds = Sets.newTreeSet();
        for (ScanNode scanNode : scanNodes) {
            result.putToPer_node_scan_ranges(scanNode.getId().asInt(), scanNode.getScanRangeSpecs());
            TTableName tableName = scanNode.getTupleDesc().getTableName().toThrift();
            if (scanNode.isTableMissingStats()) {
                tablesMissingStats.add(tableName);
            }
            if (scanNode.hasCorruptTableStats()) {
                tablesWithCorruptStats.add(tableName);
            }
            if (!(scanNode instanceof HdfsScanNode) || !((HdfsScanNode)scanNode).hasMissingDiskIds()) continue;
            tablesWithMissingDiskIds.add(tableName);
        }
        queryCtx.unsetTables_missing_stats();
        queryCtx.unsetTables_with_corrupt_stats();
        for (TTableName tableName : tablesMissingStats) {
            queryCtx.addToTables_missing_stats(tableName);
        }
        for (TTableName tableName : tablesWithCorruptStats) {
            queryCtx.addToTables_with_corrupt_stats(tableName);
        }
        for (TTableName tableName : tablesWithMissingDiskIds) {
            queryCtx.addToTables_missing_diskids(tableName);
        }
        for (PlanFragment fragment : fragments) {
            TPlanFragment thriftFragment = fragment.toThrift();
            result.addToFragments(thriftFragment);
        }
        return result;
    }

    private TQueryExecRequest createExecRequest(Planner planner, PlanCtx planCtx) throws ImpalaException {
        TQueryCtx queryCtx = planner.getQueryCtx();
        List<PlanFragment> planRoots = planner.createPlans();
        if (planCtx.planCaptureRequested()) {
            planCtx.plan_ = planRoots;
        }
        TQueryExecRequest result = new TQueryExecRequest();
        Planner.reduceCardinalityByRuntimeFilter(planRoots, planner.getPlannerCtx());
        Planner.computeProcessingCost(planRoots, result, planner.getPlannerCtx());
        Planner.computeResourceReqs(planRoots, queryCtx, result, planner.getPlannerCtx(), planner.getAnalysisResult().isQueryStmt());
        for (PlanFragment planRoot : planRoots) {
            result.addToPlan_exec_info(Frontend.createPlanExecInfo(planRoot, queryCtx));
        }
        boolean disableSpilling = queryCtx.client_request.query_options.isDisable_unsafe_spills() && queryCtx.isSetTables_missing_stats() && !queryCtx.tables_missing_stats.isEmpty() && !planner.getAnalysisResult().getAnalyzer().hasPlanHints();
        queryCtx.setDisable_spilling(disableSpilling);
        if (planner.getAnalysisResult().getAnalyzer().includeAllCoordinatorsInScheduling()) {
            result.setInclude_all_coordinators(true);
        }
        int idx = 0;
        for (TPlanExecInfo planExecInfo : result.plan_exec_info) {
            for (TPlanFragment fragment : planExecInfo.fragments) {
                fragment.setIdx(idx++);
            }
        }
        result.setQuery_ctx(queryCtx);
        List<PlanFragment> allFragments = planRoots.get(0).getNodesPreOrder();
        planCtx.explainBuf_.append(planner.getExplainString(allFragments, result));
        result.setQuery_plan(planCtx.getExplainString());
        planCtx.compilationState_.copyTQueryExecRequestFieldsForExplain(result);
        return result;
    }

    public TExecRequest createExecRequest(PlanCtx planCtx) throws ImpalaException {
        try (FrontendProfile.Scope scope = FrontendProfile.createNewWithScope();){
            EventSequence timeline = new EventSequence("Query Compilation");
            TExecRequest result = this.getTExecRequest(planCtx, timeline);
            timeline.markEvent("Planning finished");
            result.setTimeline(timeline.toThrift());
            result.setProfile(FrontendProfile.getCurrent().emitAsThrift());
            result.setProfile_children(FrontendProfile.getCurrent().emitChildrenAsThrift());
            TExecRequest tExecRequest = result;
            return tExecRequest;
        }
    }

    private void markTimelineRetries(int numRetries, String msg, EventSequence timeline) {
        if (numRetries == 0) {
            return;
        }
        timeline.markEvent(String.format("Retried query planning due to inconsistent metadata %s of %s times: ", numRetries, INCONSISTENT_METADATA_NUM_RETRIES) + msg);
    }

    public static List<TExecutorGroupSet> setupThresholdsForExecutorGroupSets(List<TExecutorGroupSet> executorGroupSets, String request_pool, boolean default_executor_group, boolean test_replan) throws ImpalaException {
        RequestPoolService poolService = RequestPoolService.getInstance();
        ArrayList result = Lists.newArrayList();
        if (default_executor_group) {
            TExecutorGroupSet e = executorGroupSets.get(0);
            if (e.getCurr_num_executors() == 0) {
                result.add(new TExecutorGroupSet(e));
                ((TExecutorGroupSet)result.get(0)).setCurr_num_executors(e.getExpected_num_executors());
                ((TExecutorGroupSet)result.get(0)).setMax_mem_limit(Long.MAX_VALUE);
                ((TExecutorGroupSet)result.get(0)).setNum_cores_per_executor(Integer.MAX_VALUE);
            } else if (test_replan) {
                String currentName;
                ExecutorMembershipSnapshot cluster = ExecutorMembershipSnapshot.getCluster();
                int num_nodes = cluster.numExecutors();
                Preconditions.checkState((e.getCurr_num_executors() == num_nodes ? 1 : 0) != 0);
                TExecutorGroupSet s = new TExecutorGroupSet(e);
                s.setExec_group_name_prefix("small");
                s.setMax_mem_limit(0x4000000L);
                s.setNum_cores_per_executor(8);
                result.add(s);
                TExecutorGroupSet l = new TExecutorGroupSet(e);
                String newName = "large";
                if (e.isSetExec_group_name_prefix() && (currentName = e.getExec_group_name_prefix()).length() > 0) {
                    newName = currentName;
                }
                l.setExec_group_name_prefix(newName);
                l.setMax_mem_limit(Long.MAX_VALUE);
                l.setNum_cores_per_executor(Integer.MAX_VALUE);
                result.add(l);
            } else {
                result.add(new TExecutorGroupSet(e));
                ((TExecutorGroupSet)result.get(0)).setMax_mem_limit(Long.MAX_VALUE);
                ((TExecutorGroupSet)result.get(0)).setNum_cores_per_executor(Integer.MAX_VALUE);
            }
            return result;
        }
        if (executorGroupSets.size() == 0) {
            result.add(new TExecutorGroupSet(1, 20, DEFAULT_POOL_NAME));
            ((TExecutorGroupSet)result.get(0)).setMax_mem_limit(Long.MAX_VALUE);
            ((TExecutorGroupSet)result.get(0)).setNum_cores_per_executor(Integer.MAX_VALUE);
            return result;
        }
        for (TExecutorGroupSet e : executorGroupSets) {
            if (StringUtils.isNotEmpty((String)request_pool) && !e.getExec_group_name_prefix().endsWith(request_pool)) continue;
            TExecutorGroupSet new_entry = new TExecutorGroupSet(e);
            if (poolService != null) {
                TPoolConfig poolConfig = poolService.getPoolConfig(e.getExec_group_name_prefix());
                Preconditions.checkNotNull((Object)poolConfig);
                new_entry.setMax_mem_limit(poolConfig.getMax_query_mem_limit() > 0L ? poolConfig.getMax_query_mem_limit() : Long.MAX_VALUE);
                new_entry.setNum_cores_per_executor(poolConfig.getMax_query_cpu_core_per_node_limit() > 0L ? (int)poolConfig.getMax_query_cpu_core_per_node_limit() : Integer.MAX_VALUE);
            } else {
                new_entry.setMax_mem_limit(Long.MAX_VALUE);
                new_entry.setNum_cores_per_executor(Integer.MAX_VALUE);
            }
            result.add(new_entry);
        }
        if (executorGroupSets.size() > 0 && result.size() == 0 && StringUtils.isNotEmpty((String)request_pool)) {
            throw new AnalysisException("Request pool: " + request_pool + " does not map to any known executor group set.");
        }
        Collections.sort(result, new Comparator<TExecutorGroupSet>(){

            @Override
            public int compare(TExecutorGroupSet e1, TExecutorGroupSet e2) {
                int i = Long.compare(e1.getMax_mem_limit(), e2.getMax_mem_limit());
                if (i == 0 && (i = Long.compare(Frontend.expectedTotalCores(e1), Frontend.expectedTotalCores(e2))) == 0) {
                    i = e1.getExec_group_name_prefix().compareTo(e2.getExec_group_name_prefix());
                }
                return i;
            }
        });
        return result;
    }

    public static boolean canStmtBeAutoScaled(TExecRequest req) {
        return req.stmt_type == TStmtType.EXPLAIN || req.stmt_type == TStmtType.QUERY || req.stmt_type == TStmtType.DML || req.stmt_type == TStmtType.DDL && req.query_exec_request != null && req.query_exec_request.stmt_type == TStmtType.DML;
    }

    private static int expectedNumExecutor(TExecutorGroupSet execGroupSet) {
        return execGroupSet.getCurr_num_executors() > 0 ? execGroupSet.getCurr_num_executors() : execGroupSet.getExpected_num_executors();
    }

    private static int expectedTotalCores(TExecutorGroupSet execGroupSet) {
        return IntMath.saturatedMultiply((int)Frontend.expectedNumExecutor(execGroupSet), (int)execGroupSet.getNum_cores_per_executor());
    }

    private TExecRequest getTExecRequest(PlanCtx planCtx, EventSequence timeline) throws ImpalaException {
        List<TExecutorGroupSet> executorGroupSetsToUse;
        int numExecutorGroupSets;
        TQueryCtx queryCtx = planCtx.getQueryContext();
        Frontend.addPlannerToProfile(PLANNER);
        LOG.info("Analyzing query: " + queryCtx.client_request.stmt + " db: " + queryCtx.session.database);
        TQueryOptions queryOptions = queryCtx.client_request.getQuery_options();
        boolean enable_replan = queryOptions.isEnable_replan();
        boolean clientSetRequestPool = queryOptions.isSetRequest_pool();
        Preconditions.checkState((!clientSetRequestPool || !queryOptions.getRequest_pool().isEmpty() ? 1 : 0) != 0);
        List<TExecutorGroupSet> originalExecutorGroupSets = ExecutorMembershipSnapshot.getAllExecutorGroupSets();
        LOG.info("The original executor group sets from executor membership snapshot: " + originalExecutorGroupSets);
        boolean default_executor_group = false;
        if (originalExecutorGroupSets.size() == 1) {
            TExecutorGroupSet e = originalExecutorGroupSets.get(0);
            default_executor_group = e.getExec_group_name_prefix() == null || e.getExec_group_name_prefix().isEmpty();
        }
        if ((numExecutorGroupSets = (executorGroupSetsToUse = Frontend.setupThresholdsForExecutorGroupSets(originalExecutorGroupSets, queryOptions.getRequest_pool(), default_executor_group, enable_replan && (RuntimeEnv.INSTANCE.isTestEnv() || queryOptions.isTest_replan()))).size()) == 0) {
            throw new AnalysisException("No suitable executor group sets can be identified and used.");
        }
        LOG.info("A total of {} executor group sets to be considered for auto-scaling: " + executorGroupSetsToUse, (Object)numExecutorGroupSets);
        TExecRequest req = null;
        planCtx.compilationState_.captureState();
        boolean isComputeCost = queryOptions.isCompute_processing_cost();
        double cpuCountRootFactor = BackendConfig.INSTANCE.getQueryCpuRootFactor();
        double cpuCountDivisor = BackendConfig.INSTANCE.getQueryCpuCountDivisor();
        if (isComputeCost) {
            if (queryOptions.isSetQuery_cpu_count_divisor()) {
                cpuCountDivisor = queryOptions.getQuery_cpu_count_divisor();
            }
            FrontendProfile.getCurrent().setToCounter(CPU_COUNT_DIVISOR, TUnit.DOUBLE_VALUE, Double.doubleToLongBits(cpuCountDivisor));
        }
        TExecutorGroupSet group_set = null;
        String reason = "Unknown";
        int attempt = 0;
        int firstExecutorGroupTotalCores = Frontend.expectedTotalCores(executorGroupSetsToUse.get(0));
        int lastExecutorGroupTotalCores = Frontend.expectedTotalCores(executorGroupSetsToUse.get(numExecutorGroupSets - 1));
        for (int i = 0; i < numExecutorGroupSets; ++i) {
            String verdict;
            boolean isLastEG = i == numExecutorGroupSets - 1;
            boolean skipResourceCheckingAtLastEG = isLastEG && BackendConfig.INSTANCE.isSkipResourceCheckingOnLastExecutorGroupSet();
            group_set = executorGroupSetsToUse.get(i);
            planCtx.compilationState_.setGroupSet(group_set);
            if (isComputeCost) {
                planCtx.compilationState_.setAvailableCoresPerNode(Math.max(queryOptions.getProcessing_cost_min_threads(), lastExecutorGroupTotalCores / Frontend.expectedNumExecutor(group_set)));
            } else {
                planCtx.compilationState_.setAvailableCoresPerNode(queryOptions.getMt_dop());
            }
            LOG.info("Consider executor group set: " + group_set + " with assumption of " + planCtx.compilationState_.getAvailableCoresPerNode() + " cores per node.");
            String retryMsg = "";
            while (true) {
                try {
                    req = this.doCreateExecRequest(planCtx, timeline);
                    this.markTimelineRetries(attempt, retryMsg, timeline);
                }
                catch (InconsistentMetadataFetchException e) {
                    if (attempt++ == INCONSISTENT_METADATA_NUM_RETRIES) {
                        this.markTimelineRetries(attempt, e.getMessage(), timeline);
                        throw e;
                    }
                    planCtx.compilationState_.disableStmtCacheAndReauthorize();
                    if (attempt > 1) {
                        Uninterruptibles.sleepUninterruptibly((long)(200 * attempt), (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    retryMsg = e.getMessage();
                    LOG.warn("Retrying plan of query {}: {} (retry #{} of {})", new Object[]{queryCtx.client_request.stmt, retryMsg, attempt, INCONSISTENT_METADATA_NUM_RETRIES});
                    continue;
                }
                break;
            }
            int availableCores = Frontend.expectedTotalCores(group_set);
            String profileName = "Executor group " + (i + 1);
            if (group_set.isSetExec_group_name_prefix() && !group_set.getExec_group_name_prefix().isEmpty()) {
                profileName = profileName + " (" + group_set.getExec_group_name_prefix() + ")";
            }
            TRuntimeProfileNode groupSetProfile = Frontend.createTRuntimeProfileNode(profileName);
            Frontend.addCounter(groupSetProfile, new TCounter(MEMORY_MAX, TUnit.BYTES, LongMath.saturatedMultiply((long)Frontend.expectedNumExecutor(group_set), (long)group_set.getMax_mem_limit())));
            if (isComputeCost) {
                Frontend.addCounter(groupSetProfile, new TCounter(CPU_MAX, TUnit.UNIT, availableCores));
            }
            boolean notScalable = false;
            if (queryOptions.num_nodes == 1) {
                reason = "the number of nodes is 1";
                notScalable = true;
            } else if (!enable_replan) {
                reason = "query option ENABLE_REPLAN=false";
                notScalable = true;
            } else if (!Frontend.canStmtBeAutoScaled(req)) {
                reason = "query is not auto-scalable";
                notScalable = true;
            }
            if (notScalable) {
                Frontend.setGroupNamePrefix(default_executor_group, clientSetRequestPool, req, group_set);
                Frontend.addInfoString(groupSetProfile, VERDICT, "Assign to first group because " + reason);
                FrontendProfile.getCurrent().addChildrenProfile(groupSetProfile);
                break;
            }
            long perHostMemEstimate = -1L;
            int cpuAskBounded = -1;
            int cpuAskUnbounded = -1;
            if (req.query_exec_request != null) {
                perHostMemEstimate = req.query_exec_request.per_host_mem_estimate;
                cpuAskBounded = req.query_exec_request.getCores_required();
                cpuAskUnbounded = req.query_exec_request.getCores_required_unbounded();
            } else {
                perHostMemEstimate = planCtx.compilationState_.getEstimatedMemoryPerHost();
                cpuAskBounded = planCtx.compilationState_.getCoresRequired();
                cpuAskUnbounded = planCtx.compilationState_.getCoresRequiredUnbounded();
            }
            Preconditions.checkState((perHostMemEstimate >= 0L ? 1 : 0) != 0);
            boolean memReqSatisfied = perHostMemEstimate <= group_set.getMax_mem_limit();
            Frontend.addCounter(groupSetProfile, new TCounter(MEMORY_ASK, TUnit.BYTES, LongMath.saturatedMultiply((long)Frontend.expectedNumExecutor(group_set), (long)perHostMemEstimate)));
            boolean cpuReqSatisfied = true;
            int scaledCpuAskBounded = -1;
            int scaledCpuAskUnbounded = -1;
            if (isComputeCost) {
                Preconditions.checkState((cpuAskBounded > 0 ? 1 : 0) != 0);
                Preconditions.checkState((cpuAskUnbounded > 0 ? 1 : 0) != 0);
                if (queryOptions.getProcessing_cost_min_threads() > queryOptions.getMax_fragment_instances_per_node()) {
                    throw new AnalysisException(TImpalaQueryOptions.PROCESSING_COST_MIN_THREADS.name() + " (" + queryOptions.getProcessing_cost_min_threads() + ") can not be larger than " + TImpalaQueryOptions.MAX_FRAGMENT_INSTANCES_PER_NODE.name() + " (" + queryOptions.getMax_fragment_instances_per_node() + ").");
                }
                Frontend.addCounter(groupSetProfile, new TCounter(MAX_PARALLELISM, TUnit.UNIT, cpuAskUnbounded));
                Frontend.addCounter(groupSetProfile, new TCounter(EFFECTIVE_PARALLELISM, TUnit.UNIT, cpuAskBounded));
                cpuAskUnbounded = Frontend.scaleDownCpuSublinear(cpuCountRootFactor, firstExecutorGroupTotalCores, cpuAskBounded, cpuAskUnbounded);
                scaledCpuAskBounded = Frontend.scaleDownCpuLinear(cpuCountDivisor, cpuAskBounded);
                scaledCpuAskUnbounded = Frontend.scaleDownCpuLinear(cpuCountDivisor, cpuAskUnbounded);
                Preconditions.checkState((scaledCpuAskBounded <= scaledCpuAskUnbounded ? 1 : 0) != 0);
                cpuReqSatisfied = scaledCpuAskUnbounded <= availableCores;
                Frontend.addCounter(groupSetProfile, new TCounter(CPU_ASK, TUnit.UNIT, scaledCpuAskUnbounded));
                Frontend.addCounter(groupSetProfile, new TCounter(CPU_ASK_BOUNDED, TUnit.UNIT, scaledCpuAskBounded));
            }
            boolean matchFound = false;
            if (clientSetRequestPool) {
                if (!default_executor_group) {
                    Preconditions.checkState((boolean)group_set.getExec_group_name_prefix().endsWith(queryOptions.getRequest_pool()));
                }
                reason = "query option REQUEST_POOL=" + queryOptions.getRequest_pool() + " is set. Memory and cpu limit checking is skipped.";
                Frontend.addInfoString(groupSetProfile, VERDICT, reason);
                matchFound = true;
            } else if (memReqSatisfied && cpuReqSatisfied) {
                reason = "suitable group found. " + MoreObjects.toStringHelper((String)"requirement").add(MEMORY_ASK, (Object)PrintUtils.printBytes(perHostMemEstimate)).add(CPU_ASK, scaledCpuAskUnbounded).add(CPU_ASK_BOUNDED, scaledCpuAskBounded).add(EFFECTIVE_PARALLELISM, cpuAskBounded).toString();
                Frontend.addInfoString(groupSetProfile, VERDICT, "Match");
                matchFound = true;
            }
            if (!matchFound && skipResourceCheckingAtLastEG) {
                reason = "no executor group set fit. Admit to last executor group set.";
                Frontend.addInfoString(groupSetProfile, VERDICT, reason);
                matchFound = true;
            }
            FrontendProfile.getCurrent().addChildrenProfile(groupSetProfile);
            if (matchFound) {
                Frontend.setGroupNamePrefix(default_executor_group, clientSetRequestPool, req, group_set);
                if (!isComputeCost || req.query_exec_request == null || queryOptions.slot_count_strategy != TSlotCountStrategy.PLANNER_CPU_ASK) break;
                int avgSlotsUsePerBackend = Frontend.getAvgSlotsUsePerBackend(req, cpuAskBounded, group_set);
                FrontendProfile.getCurrent().setToCounter(AVG_ADMISSION_SLOTS_PER_EXECUTOR, TUnit.UNIT, avgSlotsUsePerBackend);
                req.query_exec_request.setMax_slot_per_executor(group_set.getNum_cores_per_executor());
                break;
            }
            ArrayList verdicts = Lists.newArrayListWithCapacity((int)2);
            ArrayList reasons = Lists.newArrayListWithCapacity((int)2);
            if (!memReqSatisfied) {
                verdict = "not enough per-host memory";
                verdicts.add(verdict);
                reasons.add(verdict + " (require=" + perHostMemEstimate + ", max=" + group_set.getMax_mem_limit() + ")");
            }
            if (!cpuReqSatisfied) {
                verdict = "not enough cpu cores";
                verdicts.add(verdict);
                reasons.add(verdict + " (require=" + scaledCpuAskUnbounded + ", max=" + availableCores + ")");
            }
            reason = String.join((CharSequence)", ", reasons);
            Frontend.addInfoString(groupSetProfile, VERDICT, String.join((CharSequence)", ", verdicts));
            group_set = null;
            planCtx.compilationState_.restoreState();
            FrontendProfile.getCurrent().addToCounter(EXECUTOR_GROUPS_CONSIDERED, TUnit.UNIT, 1L);
        }
        if (group_set == null) {
            if (reason.equals("Unknown")) {
                throw new AnalysisException("The query does not fit any executor group sets.");
            }
            throw new AnalysisException("The query does not fit largest executor group sets. Reason: " + reason + ".");
        }
        FrontendProfile.getCurrent().addToCounter(EXECUTOR_GROUPS_CONSIDERED, TUnit.UNIT, 1L);
        LOG.info("Selected executor group: " + group_set + ", reason: " + reason);
        req.setUser_has_profile_access(planCtx.compilationState_.userHasProfileAccess());
        return req;
    }

    private static int getAvgSlotsUsePerBackend(TExecRequest req, int cpuAskBounded, TExecutorGroupSet groupSet) {
        int numExecutors = Frontend.expectedNumExecutor(groupSet);
        Preconditions.checkState((cpuAskBounded > 0 ? 1 : 0) != 0);
        Preconditions.checkState((numExecutors > 0 ? 1 : 0) != 0);
        int idealSlot = (int)Math.ceil((double)cpuAskBounded / (double)numExecutors);
        return Math.max(1, Math.min(idealSlot, groupSet.getNum_cores_per_executor()));
    }

    private static int scaleDownCpuSublinear(double cpuCountRootFactor, int smallestEGTotalCores, int cpuAskBounded, int cpuAskUnbounded) {
        double exponent = 1.0 / cpuCountRootFactor;
        double nthRootSmallestEGTotalCores = Math.pow(smallestEGTotalCores, exponent);
        double scaledCpuAskUnbounded = Math.pow(cpuAskUnbounded, exponent) / nthRootSmallestEGTotalCores * (double)smallestEGTotalCores;
        return Math.max(cpuAskBounded, (int)Math.round(scaledCpuAskUnbounded));
    }

    private static int scaleDownCpuLinear(double cpuCountDivisor, int cpuAsk) {
        return Math.min(Integer.MAX_VALUE, (int)Math.ceil((double)cpuAsk / cpuCountDivisor));
    }

    private static void setGroupNamePrefix(boolean default_executor_group, boolean clientSetRequestPool, TExecRequest req, TExecutorGroupSet group_set) {
        if (!default_executor_group) {
            String namePrefix = group_set.getExec_group_name_prefix();
            req.query_options.setRequest_pool(namePrefix);
            req.setRequest_pool_set_by_frontend(!clientSetRequestPool);
            if (req.query_exec_request != null) {
                req.query_exec_request.query_ctx.setRequest_pool(namePrefix);
            }
        }
    }

    public static TRuntimeProfileNode createTRuntimeProfileNode(String childrenProfileName) {
        return new TRuntimeProfileNode(childrenProfileName, 0, new ArrayList<TCounter>(), -1L, true, new HashMap<String, String>(), new ArrayList<String>(), (Map<String, Set<String>>)ImmutableMap.of((Object)"", new HashSet()));
    }

    private static void addCounter(TRuntimeProfileNode node, TCounter counter) {
        Preconditions.checkNotNull(node.child_counters_map.get(""));
        node.addToCounters(counter);
        node.child_counters_map.get("").add(counter.getName());
    }

    private static void addInfoString(TRuntimeProfileNode node, String key, String value) {
        if (node.getInfo_strings().put(key, value) == null) {
            node.getInfo_strings_display_order().add(key);
        }
    }

    public static void addPlannerToProfile(String planner) {
        TRuntimeProfileNode profile = Frontend.createTRuntimeProfileNode(PLANNER_PROFILE);
        Frontend.addInfoString(profile, PLANNER_TYPE, planner);
        FrontendProfile.getCurrent().addChildrenProfile(profile);
    }

    private TExecRequest doCreateExecRequest(PlanCtx planCtx, EventSequence timeline) throws ImpalaException {
        TQueryCtx queryCtx = planCtx.getQueryContext();
        StatementBase stmt = Parser.parse(queryCtx.client_request.stmt, queryCtx.client_request.query_options);
        User user = new User(TSessionStateUtil.getEffectiveUser(queryCtx.session));
        StmtMetadataLoader metadataLoader = new StmtMetadataLoader(this, queryCtx.session.database, timeline, user, queryCtx.getQuery_id());
        StmtMetadataLoader.StmtTableCache stmtTableCache = metadataLoader.loadTables(stmt);
        if (queryCtx.client_request.query_options.isSetDebug_action()) {
            DebugUtils.executeDebugAction(queryCtx.client_request.query_options.getDebug_action(), "impalad_load_tables_delay");
        }
        FrontendProfile.getCurrent().addInfoString("Referenced Tables", stmtTableCache.tables.keySet().stream().map(TableName::toString).collect(Collectors.joining(", ")));
        AnalysisContext analysisCtx = new AnalysisContext(queryCtx, this.authzFactory_, timeline);
        AnalysisContext.AnalysisResult analysisResult = analysisCtx.analyzeAndAuthorize(stmt, stmtTableCache, this.authzChecker_.get(), planCtx.compilationState_.disableAuthorization());
        if (!planCtx.compilationState_.disableAuthorization()) {
            LOG.info("Analysis and authorization finished.");
            planCtx.compilationState_.setUserHasProfileAccess(analysisResult.userHasProfileAccess());
        } else {
            LOG.info("Analysis finished.");
        }
        Preconditions.checkNotNull((Object)analysisResult.getStmt());
        TExecRequest result = Frontend.createBaseExecRequest(queryCtx, analysisResult);
        for (TableName table : stmtTableCache.tables.keySet()) {
            result.addToTables(table.toThrift());
        }
        analysisResult.getAnalyzer().setNumExecutorsForPlanning(Frontend.expectedNumExecutor(planCtx.compilationState_.getGroupSet()));
        analysisResult.getAnalyzer().setAvailableCoresPerNode(Math.max(1, planCtx.compilationState_.getAvailableCoresPerNode()));
        try {
            TQueryOptions queryOptions = queryCtx.client_request.query_options;
            if (analysisResult.isCatalogOp()) {
                result.stmt_type = TStmtType.DDL;
                this.createCatalogOpRequest(analysisResult, result);
                TLineageGraph thriftLineageGraph = analysisResult.getThriftLineageGraph();
                if (thriftLineageGraph != null && thriftLineageGraph.isSetQuery_text()) {
                    result.catalog_op_request.setLineage_graph(thriftLineageGraph);
                }
                Frontend.setMtDopForCatalogOp(analysisResult, queryOptions);
                if (!analysisResult.isCreateTableAsSelectStmt()) {
                    return result;
                }
            }
            if (!analysisResult.isExplainStmt() && (analysisResult.isInsertStmt() || analysisResult.isCreateTableAsSelectStmt())) {
                InsertStmt insertStmt = analysisResult.getInsertStmt();
                FeTable targetTable = insertStmt.getTargetTable();
                if (AcidUtils.isTransactionalTable(targetTable.getMetaStoreTable().getParameters())) {
                    if (planCtx.compilationState_.getWriteId() == -1L) {
                        long txnId = this.openTransaction(queryCtx);
                        timeline.markEvent("Transaction opened (" + String.valueOf(txnId) + ")");
                        Collection<FeTable> tables = stmtTableCache.tables.values();
                        String staticPartitionTarget = null;
                        if (insertStmt.isStaticPartitionTarget()) {
                            staticPartitionTarget = FeCatalogUtils.getPartitionName(insertStmt.getPartitionKeyValues());
                        }
                        long writeId = this.allocateWriteId(queryCtx, targetTable);
                        insertStmt.setWriteId(writeId);
                        this.createLockForInsert(txnId, tables, targetTable, insertStmt.isOverwrite(), staticPartitionTarget, queryOptions);
                        planCtx.compilationState_.setWriteId(writeId);
                    } else {
                        insertStmt.setWriteId(planCtx.compilationState_.getWriteId());
                    }
                }
            } else {
                if (analysisResult.isLoadDataStmt()) {
                    result.stmt_type = TStmtType.LOAD;
                    result.setResult_set_metadata(new TResultSetMetadata(Collections.singletonList(new TColumn("summary", Type.STRING.toThrift()))));
                    result.setLoad_data_request(analysisResult.getLoadDataStmt().toThrift());
                    return result;
                }
                if (analysisResult.isSetStmt()) {
                    result.stmt_type = TStmtType.SET;
                    result.setResult_set_metadata(new TResultSetMetadata(Arrays.asList(new TColumn("option", Type.STRING.toThrift()), new TColumn("value", Type.STRING.toThrift()), new TColumn("level", Type.STRING.toThrift()))));
                    result.setSet_query_option_request(analysisResult.getSetStmt().toThrift());
                    return result;
                }
                if (analysisResult.isAdminFnStmt()) {
                    result.stmt_type = TStmtType.ADMIN_FN;
                    result.setResult_set_metadata(new TResultSetMetadata(Arrays.asList(new TColumn("summary", Type.STRING.toThrift()))));
                    result.setAdmin_request(analysisResult.getAdminFnStmt().toThrift());
                    return result;
                }
                if (analysisResult.isConvertTableToIcebergStmt()) {
                    result.stmt_type = TStmtType.CONVERT;
                    result.setResult_set_metadata(new TResultSetMetadata(Collections.singletonList(new TColumn("summary", Type.STRING.toThrift()))));
                    result.setConvert_table_request(analysisResult.getConvertTableToIcebergStmt().toThrift());
                    return result;
                }
                if (analysisResult.isTestCaseStmt()) {
                    CopyTestCaseStmt testCaseStmt = (CopyTestCaseStmt)stmt;
                    if (testCaseStmt.isTestCaseExport()) {
                        result.setStmt_type(TStmtType.TESTCASE);
                        result.setResult_set_metadata(new TResultSetMetadata(Arrays.asList(new TColumn("Test case data output path", Type.STRING.toThrift()))));
                        result.setTestcase_data_path(testCaseStmt.writeTestCaseData());
                    } else {
                        result.setStmt_type(TStmtType.DDL);
                        this.createCatalogOpRequest(analysisResult, result);
                    }
                    return result;
                }
            }
            if (!analysisResult.isExplainStmt() && queryOptions.isEnable_kudu_transaction()) {
                if ((analysisResult.isInsertStmt() || analysisResult.isCreateTableAsSelectStmt()) && analysisResult.getInsertStmt().isTargetTableKuduTable()) {
                    this.openOrContinueKuduTransaction(planCtx, queryCtx, analysisResult, analysisResult.getInsertStmt().getTargetTable(), timeline);
                } else if (analysisResult.isUpdateStmt() && analysisResult.getUpdateStmt().isTargetTableKuduTable()) {
                    this.openOrContinueKuduTransaction(planCtx, queryCtx, analysisResult, analysisResult.getUpdateStmt().getTargetTable(), timeline);
                } else if (analysisResult.isDeleteStmt() && analysisResult.getDeleteStmt().isTargetTableKuduTable()) {
                    this.openOrContinueKuduTransaction(planCtx, queryCtx, analysisResult, analysisResult.getDeleteStmt().getTargetTable(), timeline);
                }
            }
            if (!queryOptions.isSetMt_dop()) {
                queryOptions.setMt_dop(0);
            }
            TQueryExecRequest queryExecRequest = this.getPlannedExecRequest(planCtx, analysisResult, timeline);
            TLineageGraph thriftLineageGraph = analysisResult.getThriftLineageGraph();
            if (thriftLineageGraph != null && thriftLineageGraph.isSetQuery_text()) {
                queryExecRequest.setLineage_graph(thriftLineageGraph);
            }
            this.checkAndOverrideMemEstimate(queryExecRequest, queryOptions);
            if (analysisResult.isExplainStmt()) {
                this.createExplainRequest(planCtx.getExplainString(), result);
                return result;
            }
            result.setQuery_exec_request(queryExecRequest);
            if (analysisResult.isQueryStmt()) {
                result.query_exec_request.stmt_type = result.stmt_type = TStmtType.QUERY;
                result.setResult_set_metadata(Frontend.createQueryResultSetMetadata(analysisResult));
            } else if (analysisResult.isInsertStmt() || analysisResult.isCreateTableAsSelectStmt()) {
                result.stmt_type = analysisResult.isCreateTableAsSelectStmt() ? TStmtType.DDL : TStmtType.DML;
                result.query_exec_request.stmt_type = TStmtType.DML;
                Frontend.addFinalizationParamsForInsert(queryCtx, queryExecRequest, analysisResult.getInsertStmt());
            } else {
                Preconditions.checkState((analysisResult.isUpdateStmt() || analysisResult.isDeleteStmt() || analysisResult.isOptimizeStmt() ? 1 : 0) != 0);
                result.stmt_type = TStmtType.DML;
                result.query_exec_request.stmt_type = TStmtType.DML;
                if (analysisResult.isDeleteStmt()) {
                    Frontend.addFinalizationParamsForIcebergModify(queryCtx, queryExecRequest, analysisResult.getDeleteStmt(), TIcebergOperation.DELETE);
                } else if (analysisResult.isUpdateStmt()) {
                    Frontend.addFinalizationParamsForIcebergModify(queryCtx, queryExecRequest, analysisResult.getUpdateStmt(), TIcebergOperation.UPDATE);
                } else if (analysisResult.isOptimizeStmt()) {
                    Frontend.addFinalizationParamsForIcebergModify(queryCtx, queryExecRequest, analysisResult.getOptimizeStmt(), TIcebergOperation.OPTIMIZE);
                }
            }
            return result;
        }
        catch (Exception e) {
            if (queryCtx.isSetTransaction_id()) {
                try {
                    planCtx.compilationState_.setWriteId(-1L);
                    this.abortTransaction(queryCtx.getTransaction_id());
                    timeline.markEvent("Transaction aborted");
                }
                catch (TransactionException te) {
                    LOG.error("Could not abort transaction because: " + te.getMessage());
                }
            } else if (queryCtx.isIs_kudu_transactional()) {
                try {
                    planCtx.compilationState_.setKuduTransactionToken(null);
                    this.abortKuduTransaction(queryCtx.getQuery_id());
                    timeline.markEvent("Kudu transaction aborted: " + TUniqueIdUtil.PrintId(queryCtx.getQuery_id()));
                }
                catch (TransactionException te) {
                    LOG.error("Could not abort transaction because: " + te.getMessage());
                }
            }
            throw e;
        }
    }

    private static void setMtDopForCatalogOp(AnalysisContext.AnalysisResult analysisResult, TQueryOptions queryOptions) {
        if (!queryOptions.isSetMt_dop() && analysisResult.isComputeStatsStmt()) {
            queryOptions.setMt_dop(4);
        }
        if (!queryOptions.isSetMt_dop()) {
            queryOptions.setMt_dop(0);
        }
    }

    private static TExecRequest createBaseExecRequest(TQueryCtx queryCtx, AnalysisContext.AnalysisResult analysisResult) {
        TExecRequest result = new TExecRequest();
        result.setQuery_options(queryCtx.client_request.getQuery_options());
        result.setAccess_events(Lists.newArrayList(analysisResult.getAccessEvents()));
        result.analysis_warnings = analysisResult.getAnalyzer().getWarnings();
        result.setUser_has_profile_access(analysisResult.userHasProfileAccess());
        return result;
    }

    private static void addFinalizationParamsForInsert(TQueryCtx queryCtx, TQueryExecRequest queryExecRequest, InsertStmt insertStmt) {
        FeTable targetTable = insertStmt.getTargetTable();
        Frontend.addFinalizationParamsForInsert(queryCtx, queryExecRequest, targetTable, insertStmt.getWriteId(), insertStmt.isOverwrite());
    }

    private static void addFinalizationParamsForIcebergModify(TQueryCtx queryCtx, TQueryExecRequest queryExecRequest, DmlStatementBase dmlStmt, TIcebergOperation iceOperation) {
        Preconditions.checkState((!(dmlStmt instanceof InsertStmt) ? 1 : 0) != 0);
        FeTable targetTable = dmlStmt.getTargetTable();
        if (!(targetTable instanceof FeIcebergTable)) {
            return;
        }
        if (iceOperation == TIcebergOperation.DELETE) {
            Preconditions.checkState((boolean)(targetTable instanceof IcebergPositionDeleteTable));
            targetTable = ((IcebergPositionDeleteTable)targetTable).getBaseTable();
        }
        TFinalizeParams finalizeParams = Frontend.addFinalizationParamsForDml(queryCtx, targetTable, false);
        TIcebergDmlFinalizeParams iceFinalizeParams = Frontend.addFinalizationParamsForIcebergDml((FeIcebergTable)targetTable, iceOperation);
        finalizeParams.setIceberg_params(iceFinalizeParams);
        queryExecRequest.setFinalize_params(finalizeParams);
    }

    private static TIcebergDmlFinalizeParams addFinalizationParamsForIcebergDml(FeIcebergTable iceTable, TIcebergOperation iceOperation) {
        TIcebergDmlFinalizeParams iceFinalizeParams = new TIcebergDmlFinalizeParams();
        iceFinalizeParams.operation = iceOperation;
        iceFinalizeParams.setSpec_id(iceTable.getDefaultPartitionSpecId());
        iceFinalizeParams.setInitial_snapshot_id(iceTable.snapshotId());
        return iceFinalizeParams;
    }

    public static void addFinalizationParamsForInsert(TQueryCtx queryCtx, TQueryExecRequest queryExecRequest, FeTable targetTable, long writeId, boolean isOverwrite) {
        TFinalizeParams finalizeParams = Frontend.addFinalizationParamsForDml(queryCtx, targetTable, isOverwrite);
        if (targetTable instanceof FeFsTable) {
            if (writeId != -1L) {
                Preconditions.checkState((boolean)queryCtx.isSetTransaction_id());
                finalizeParams.setTransaction_id(queryCtx.getTransaction_id());
                finalizeParams.setWrite_id(writeId);
            } else if (targetTable instanceof FeIcebergTable) {
                FeIcebergTable iceTable = (FeIcebergTable)targetTable;
                TIcebergDmlFinalizeParams iceFinalizeParams = Frontend.addFinalizationParamsForIcebergDml(iceTable, TIcebergOperation.INSERT);
                finalizeParams.setIceberg_params(iceFinalizeParams);
            } else {
                FeFsTable hdfsTable = (FeFsTable)targetTable;
                finalizeParams.setStaging_dir(hdfsTable.getHdfsBaseDir() + "/_impala_insert_staging");
            }
            queryExecRequest.setFinalize_params(finalizeParams);
        }
    }

    private static TFinalizeParams addFinalizationParamsForDml(TQueryCtx queryCtx, FeTable targetTable, boolean isOverwrite) {
        TFinalizeParams finalizeParams = new TFinalizeParams();
        if (targetTable instanceof FeFsTable) {
            finalizeParams.setIs_overwrite(isOverwrite);
            finalizeParams.setTable_name(targetTable.getTableName().getTbl());
            finalizeParams.setTable_id(0L);
            String db = targetTable.getTableName().getDb();
            finalizeParams.setTable_db(db == null ? queryCtx.session.database : db);
            FeFsTable hdfsTable = (FeFsTable)targetTable;
            finalizeParams.setHdfs_base_dir(hdfsTable.getHdfsBaseDir());
        }
        return finalizeParams;
    }

    private static TResultSetMetadata createQueryResultSetMetadata(AnalysisContext.AnalysisResult analysisResult) {
        LOG.trace("create result set metadata");
        TResultSetMetadata metadata = new TResultSetMetadata();
        QueryStmt queryStmt = analysisResult.getQueryStmt();
        int colCnt = queryStmt.getColLabels().size();
        for (int i = 0; i < colCnt; ++i) {
            TColumn colDesc = new TColumn();
            colDesc.columnName = queryStmt.getColLabels().get(i);
            colDesc.columnType = queryStmt.getResultExprs().get(i).getType().toThrift();
            metadata.addToColumns(colDesc);
        }
        return metadata;
    }

    private TQueryExecRequest getPlannedExecRequest(PlanCtx planCtx, AnalysisContext.AnalysisResult analysisResult, EventSequence timeline) throws ImpalaException {
        Preconditions.checkState((analysisResult.isQueryStmt() || analysisResult.isDmlStmt() || analysisResult.isCreateTableAsSelectStmt() ? 1 : 0) != 0);
        TQueryCtx queryCtx = planCtx.getQueryContext();
        Planner planner = new Planner(analysisResult, queryCtx, timeline);
        TQueryExecRequest queryExecRequest = this.createExecRequest(planner, planCtx);
        if (planCtx.serializeDescTbl()) {
            queryCtx.setDesc_tbl_serialized(planner.getAnalysisResult().getAnalyzer().getDescTbl().toSerializedThrift());
        } else {
            queryCtx.setDesc_tbl_testonly(planner.getAnalysisResult().getAnalyzer().getDescTbl().toThrift());
        }
        queryExecRequest.setQuery_ctx(queryCtx);
        queryExecRequest.setHost_list(analysisResult.getAnalyzer().getHostIndex().getList());
        return queryExecRequest;
    }

    private void checkAndOverrideMemEstimate(TQueryExecRequest queryExecRequest, TQueryOptions queryOptions) {
        if (queryOptions.isSetMax_mem_estimate_for_admission() && queryOptions.getMax_mem_estimate_for_admission() > 0L) {
            long effectivePerHostMemEstimate = Math.min(queryExecRequest.getPer_host_mem_estimate(), queryOptions.getMax_mem_estimate_for_admission());
            queryExecRequest.setPer_host_mem_estimate(effectivePerHostMemEstimate);
            long effectiveCoordinatorMemEstimate = Math.min(queryExecRequest.getDedicated_coord_mem_estimate(), queryOptions.getMax_mem_estimate_for_admission());
            queryExecRequest.setDedicated_coord_mem_estimate(effectiveCoordinatorMemEstimate);
        }
    }

    private void createExplainRequest(String explainString, TExecRequest result) {
        TColumn colDesc = new TColumn("Explain String", Type.STRING.toThrift());
        TResultSetMetadata metadata = new TResultSetMetadata(Lists.newArrayList((Object[])new TColumn[]{colDesc}));
        result.setResult_set_metadata(metadata);
        String[] explainStringArray = explainString.split("\n");
        TExplainResult explainResult = new TExplainResult();
        explainResult.results = Lists.newArrayList();
        for (int i = 0; i < explainStringArray.length; ++i) {
            TColumnValue col = new TColumnValue();
            col.setString_val(explainStringArray[i]);
            TResultRow row = new TResultRow(Lists.newArrayList((Object[])new TColumnValue[]{col}));
            explainResult.results.add(row);
        }
        result.setExplain_result(explainResult);
        result.stmt_type = TStmtType.EXPLAIN;
    }

    public TResultSet execHiveServer2MetadataOp(TMetadataOpRequest request) throws ImpalaException {
        User user = request.isSetSession() ? new User(TSessionStateUtil.getEffectiveUser(request.session)) : ImpalaInternalAdminUser.getInstance();
        switch (request.opcode) {
            case GET_TYPE_INFO: {
                return MetadataOp.getTypeInfo();
            }
            case GET_SCHEMAS: {
                return MetastoreShim.execGetSchemas(this, request, user);
            }
            case GET_TABLES: {
                return MetastoreShim.execGetTables(this, request, user);
            }
            case GET_COLUMNS: {
                return MetastoreShim.execGetColumns(this, request, user);
            }
            case GET_CATALOGS: {
                return MetadataOp.getCatalogs();
            }
            case GET_TABLE_TYPES: {
                return MetadataOp.getTableTypes();
            }
            case GET_FUNCTIONS: {
                return MetastoreShim.execGetFunctions(this, request, user);
            }
            case GET_PRIMARY_KEYS: {
                return MetadataOp.getPrimaryKeys(this, request, user);
            }
            case GET_CROSS_REFERENCE: {
                return MetadataOp.getCrossReference(this, request, user);
            }
        }
        throw new NotImplementedException((Object)((Object)request.opcode) + " has not been implemented.");
    }

    public TResultSet getTableFiles(TShowFilesParams request) throws ImpalaException {
        TTableName tableName = request.getTable_name();
        RetryTracker retries = new RetryTracker(String.format("getting table files %s.%s", tableName.db_name, tableName.table_name));
        while (true) {
            try {
                return this.doGetTableFiles(request);
            }
            catch (InconsistentMetadataFetchException e) {
                retries.handleRetryOrThrow(e);
                continue;
            }
            break;
        }
    }

    private TResultSet doGetTableFiles(TShowFilesParams request) throws ImpalaException {
        FeTable table = this.getCatalog().getTable(request.getTable_name().getDb_name(), request.getTable_name().getTable_name());
        if (table instanceof FeFsTable) {
            return FeFsTable.Utils.getFiles((FeFsTable)table, request.getPartition_set());
        }
        throw new InternalException("SHOW FILES only supports Hdfs table. Unsupported table class: " + table.getClass());
    }

    public void callQueryCompleteHooks(QueryCompleteContext context) {
        List<Future<QueryEventHook>> futures = this.queryHookManager_.executeQueryCompleteHooks(context);
    }

    public void addTransaction(TQueryCtx queryCtx) throws TransactionException {
        Preconditions.checkState((boolean)queryCtx.isSetTransaction_id());
        long transactionId = queryCtx.getTransaction_id();
        TransactionKeepalive.HeartbeatContext ctx = new TransactionKeepalive.HeartbeatContext(queryCtx, System.nanoTime());
        this.transactionKeepalive_.addTransaction(transactionId, ctx);
        LOG.info("Opened transaction: " + Long.toString(transactionId));
    }

    private long openTransaction(TQueryCtx queryCtx) throws TransactionException {
        try (MetaStoreClientPool.MetaStoreClient client = this.metaStoreClientPool_.getClient();){
            IMetaStoreClient hmsClient = client.getHiveClient();
            queryCtx.setTransaction_id(MetastoreShim.openTransaction(hmsClient));
            this.addTransaction(queryCtx);
        }
        return queryCtx.getTransaction_id();
    }

    public void abortTransaction(long txnId) throws TransactionException {
        LOG.error("Aborting transaction: " + Long.toString(txnId));
        try (MetaStoreClientPool.MetaStoreClient client = this.metaStoreClientPool_.getClient();){
            IMetaStoreClient hmsClient = client.getHiveClient();
            this.transactionKeepalive_.deleteTransaction(txnId);
            MetastoreShim.abortTransaction(hmsClient, txnId);
        }
    }

    public void unregisterTransaction(long txnId) {
        LOG.info("Unregistering already committed transaction: " + Long.toString(txnId));
        this.transactionKeepalive_.deleteTransaction(txnId);
    }

    private long allocateWriteId(TQueryCtx queryCtx, FeTable table) throws TransactionException {
        Preconditions.checkState((boolean)queryCtx.isSetTransaction_id());
        Preconditions.checkState((boolean)(table instanceof FeFsTable));
        Preconditions.checkState((boolean)AcidUtils.isTransactionalTable(table.getMetaStoreTable().getParameters()));
        try (MetaStoreClientPool.MetaStoreClient client = this.metaStoreClientPool_.getClient();){
            IMetaStoreClient hmsClient = client.getHiveClient();
            long txnId = queryCtx.getTransaction_id();
            long l = MetastoreShim.allocateTableWriteId(hmsClient, txnId, table.getDb().getName(), table.getName());
            return l;
        }
    }

    private void createLockForInsert(Long txnId, Collection<FeTable> tables, FeTable targetTable, boolean isOverwrite, String staticPartitionTarget, TQueryOptions queryOptions) throws TransactionException {
        Preconditions.checkState((boolean)AcidUtils.isTransactionalTable(targetTable.getMetaStoreTable().getParameters()));
        ArrayList<LockComponent> lockComponents = new ArrayList<LockComponent>(tables.size());
        ArrayList<FeTable> lockTables = new ArrayList<FeTable>(tables);
        if (!lockTables.contains(targetTable)) {
            lockTables.add(targetTable);
        }
        for (FeTable table : lockTables) {
            if (!AcidUtils.isTransactionalTable(table.getMetaStoreTable().getParameters())) continue;
            LockComponent lockComponent = new LockComponent();
            lockComponent.setDbname(table.getDb().getName());
            lockComponent.setTablename(table.getName());
            if (table == targetTable) {
                if (isOverwrite) {
                    lockComponent.setType(LockType.EXCLUSIVE);
                } else {
                    lockComponent.setType(LockType.SHARED_READ);
                }
                lockComponent.setOperationType(DataOperationType.INSERT);
                if (staticPartitionTarget != null) {
                    lockComponent.setLevel(LockLevel.PARTITION);
                    lockComponent.setPartitionname(staticPartitionTarget);
                } else {
                    lockComponent.setLevel(LockLevel.TABLE);
                }
            } else {
                lockComponent.setLevel(LockLevel.TABLE);
                lockComponent.setType(LockType.SHARED_READ);
                lockComponent.setOperationType(DataOperationType.SELECT);
            }
            lockComponents.add(lockComponent);
        }
        try (MetaStoreClientPool.MetaStoreClient client = this.metaStoreClientPool_.getClient();){
            IMetaStoreClient hmsClient = client.getHiveClient();
            MetastoreShim.acquireLock(hmsClient, txnId, lockComponents, queryOptions.lock_max_wait_time_s);
        }
    }

    private void openOrContinueKuduTransaction(PlanCtx planCtx, TQueryCtx queryCtx, AnalysisContext.AnalysisResult analysisResult, FeTable targetTable, EventSequence timeline) throws TransactionException {
        byte[] token = planCtx.compilationState_.getKuduTransactionToken();
        if (token != null) {
            if (analysisResult.isUpdateStmt()) {
                analysisResult.getUpdateStmt().setKuduTransactionToken(token);
            } else if (analysisResult.isDeleteStmt()) {
                analysisResult.getDeleteStmt().setKuduTransactionToken(token);
            } else {
                analysisResult.getInsertStmt().setKuduTransactionToken(token);
            }
            return;
        }
        FeKuduTable kuduTable = (FeKuduTable)targetTable;
        KuduClient client = KuduUtil.getKuduClient(kuduTable.getKuduMasterHosts());
        KuduTransaction txn = null;
        try {
            LOG.info("Open Kudu transaction: {}", (Object)TUniqueIdUtil.PrintId(queryCtx.getQuery_id()));
            txn = client.newTransaction();
            timeline.markEvent("Kudu transaction opened with query id: " + TUniqueIdUtil.PrintId(queryCtx.getQuery_id()));
            token = txn.serialize();
            if (analysisResult.isUpdateStmt()) {
                analysisResult.getUpdateStmt().setKuduTransactionToken(token);
            } else if (analysisResult.isDeleteStmt()) {
                analysisResult.getDeleteStmt().setKuduTransactionToken(token);
            } else {
                analysisResult.getInsertStmt().setKuduTransactionToken(token);
            }
            this.kuduTxnManager_.addTransaction(queryCtx.getQuery_id(), txn);
            queryCtx.setIs_kudu_transactional(true);
            planCtx.compilationState_.setKuduTransactionToken(token);
        }
        catch (IOException e) {
            if (txn != null) {
                txn.close();
            }
            throw new TransactionException(e.getMessage());
        }
    }

    public void abortKuduTransaction(TUniqueId queryId) throws TransactionException {
        LOG.info("Abort Kudu transaction: {}", (Object)TUniqueIdUtil.PrintId(queryId));
        KuduTransaction txn = this.kuduTxnManager_.deleteTransaction(queryId);
        Preconditions.checkNotNull((Object)txn);
        if (txn != null) {
            try {
                txn.rollback();
            }
            catch (KuduException e) {
                throw new TransactionException(e.getMessage());
            }
            finally {
                txn.close();
            }
        }
    }

    public void commitKuduTransaction(TUniqueId queryId) throws TransactionException {
        LOG.info("Commit Kudu transaction: {}", (Object)TUniqueIdUtil.PrintId(queryId));
        KuduTransaction txn = this.kuduTxnManager_.deleteTransaction(queryId);
        Preconditions.checkNotNull((Object)txn);
        if (txn != null) {
            try {
                txn.commit();
            }
            catch (KuduException e) {
                throw new TransactionException(e.getMessage());
            }
            finally {
                txn.close();
            }
        }
    }

    private class CheckTableAuthorization
    extends CheckAuthorization {
        private final FeTable table_;

        public CheckTableAuthorization(FeTable table, User user) {
            super(user);
            Preconditions.checkNotNull((Object)table);
            this.table_ = table;
        }

        @Override
        public boolean checkAuthorization() throws Exception {
            String tableOwner = this.table_.getOwnerUser();
            if (tableOwner == null) {
                LOG.info("Table {} not yet loaded, ignoring it in table listing.", (Object)this.table_.getFullName());
            }
            return Frontend.this.isAccessibleToUser(this.table_.getDb().getName(), this.table_.getName(), tableOwner, this.user_);
        }
    }

    private class CheckDbAuthorization
    extends CheckAuthorization {
        private final FeDb db_;

        public CheckDbAuthorization(FeDb db, User user) {
            super(user);
            Preconditions.checkNotNull((Object)db);
            this.db_ = db;
        }

        @Override
        public boolean checkAuthorization() throws Exception {
            try {
                return Frontend.this.isAccessibleToUser(this.db_.getName(), null, this.db_.getOwnerUser(), this.user_);
            }
            catch (InconsistentMetadataFetchException e) {
                Preconditions.checkState((e.getReason() == CatalogLookupStatus.DB_NOT_FOUND ? 1 : 0) != 0, (String)"Unexpected failure of InconsistentMetadataFetchException: %s", (Object)((Object)e.getReason()));
                LOG.warn("Database {} no longer exists", (Object)this.db_.getName(), (Object)e);
                return false;
            }
        }
    }

    private abstract class CheckAuthorization
    implements Callable<Boolean> {
        protected final User user_;

        public CheckAuthorization(User user) {
            Preconditions.checkNotNull((Object)user);
            this.user_ = user;
        }

        public abstract boolean checkAuthorization() throws Exception;

        @Override
        public Boolean call() throws Exception {
            return this.checkAuthorization();
        }
    }

    public static class RetryTracker {
        private int attempt_ = 0;
        private final String msg_;

        public RetryTracker(String msg) {
            this.msg_ = msg;
        }

        public void handleRetryOrThrow(InconsistentMetadataFetchException exception) {
            if (this.attempt_++ >= INCONSISTENT_METADATA_NUM_RETRIES) {
                throw exception;
            }
            if (this.attempt_ > 1) {
                Uninterruptibles.sleepUninterruptibly((long)(200 * this.attempt_), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            LOG.warn(String.format("Retried %s: (retry #%s of %s)", this.msg_, this.attempt_, INCONSISTENT_METADATA_NUM_RETRIES), (Throwable)exception);
        }
    }

    public static class PlanCtx {
        protected final TQueryCtx queryCtx_;
        protected final StringBuilder explainBuf_;
        protected boolean capturePlan_;
        protected boolean serializeDescTbl_ = true;
        protected List<PlanFragment> plan_;
        public AutoScalingCompilationState compilationState_;

        public PlanCtx(TQueryCtx qCtx) {
            this.queryCtx_ = qCtx;
            this.explainBuf_ = new StringBuilder();
            this.compilationState_ = new AutoScalingCompilationState();
        }

        public PlanCtx(TQueryCtx qCtx, StringBuilder describe) {
            this.queryCtx_ = qCtx;
            this.explainBuf_ = describe;
            this.compilationState_ = new AutoScalingCompilationState();
        }

        public void requestPlanCapture() {
            this.capturePlan_ = true;
        }

        public boolean planCaptureRequested() {
            return this.capturePlan_;
        }

        public void disableDescTblSerialization() {
            this.serializeDescTbl_ = false;
        }

        public boolean serializeDescTbl() {
            return this.serializeDescTbl_;
        }

        public TQueryCtx getQueryContext() {
            return this.queryCtx_;
        }

        @VisibleForTesting
        public List<PlanFragment> getPlan() {
            return this.plan_;
        }

        public String getExplainString() {
            return this.explainBuf_.toString();
        }

        final class AutoScalingCompilationState {
            protected boolean disableAuthorization_ = false;
            protected long estimated_memory_per_host_ = -1L;
            protected int coresRequired_ = 1;
            protected int coresRequiredUnbounded_ = 1;
            protected int initialExplainBufLen_ = -1;
            protected TQueryOptions initialQueryOptions_ = null;
            protected long writeId_ = -1L;
            protected byte[] kuduTransactionToken_ = null;
            protected boolean user_has_profile_access_ = false;
            protected TExecutorGroupSet group_set_ = null;
            protected int availableCoresPerNode_ = -1;

            AutoScalingCompilationState() {
            }

            public boolean disableAuthorization() {
                return this.disableAuthorization_;
            }

            public void copyTQueryExecRequestFieldsForExplain(TQueryExecRequest req) {
                this.estimated_memory_per_host_ = req.getPer_host_mem_estimate();
                this.coresRequired_ = req.getCores_required();
                this.coresRequiredUnbounded_ = req.getCores_required_unbounded();
            }

            public long getEstimatedMemoryPerHost() {
                return this.estimated_memory_per_host_;
            }

            public int getCoresRequired() {
                return this.coresRequired_;
            }

            public int getCoresRequiredUnbounded() {
                return this.coresRequiredUnbounded_;
            }

            public int getAvailableCoresPerNode() {
                Preconditions.checkState((this.availableCoresPerNode_ >= 0 ? 1 : 0) != 0);
                return this.availableCoresPerNode_;
            }

            public void setAvailableCoresPerNode(int x) {
                this.availableCoresPerNode_ = x;
            }

            public void captureState() {
                this.disableAuthorization_ = false;
                this.estimated_memory_per_host_ = -1L;
                this.initialExplainBufLen_ = PlanCtx.this.explainBuf_.length();
                this.initialQueryOptions_ = new TQueryOptions(PlanCtx.this.getQueryContext().client_request.getQuery_options());
                this.writeId_ = -1L;
                this.kuduTransactionToken_ = null;
            }

            public void restoreState() {
                this.disableAuthorization_ = true;
                this.estimated_memory_per_host_ = -1L;
                PlanCtx.this.explainBuf_.delete(this.initialExplainBufLen_, PlanCtx.this.explainBuf_.length());
                PlanCtx.this.getQueryContext().client_request.setQuery_options(new TQueryOptions(this.initialQueryOptions_));
                PlanCtx.this.queryCtx_.setDesc_tbl_testonlyIsSet(false);
            }

            public void disableStmtCacheAndReauthorize() {
                this.restoreState();
                this.disableAuthorization_ = false;
            }

            long getWriteId() {
                return this.writeId_;
            }

            void setWriteId(long x) {
                this.writeId_ = x;
            }

            byte[] getKuduTransactionToken() {
                return this.kuduTransactionToken_;
            }

            void setKuduTransactionToken(byte[] token) {
                this.kuduTransactionToken_ = token == null ? null : (byte[])token.clone();
            }

            boolean userHasProfileAccess() {
                return this.user_has_profile_access_;
            }

            void setUserHasProfileAccess(boolean x) {
                this.user_has_profile_access_ = x;
            }

            TExecutorGroupSet getGroupSet() {
                return this.group_set_;
            }

            void setGroupSet(TExecutorGroupSet x) {
                this.group_set_ = x;
            }
        }
    }
}

