/*
 * Decompiled with CFR 0.152.
 */
package org.apache.impala.service;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.impala.authorization.AuthorizationChecker;
import org.apache.impala.catalog.CatalogException;
import org.apache.impala.catalog.FeCatalog;
import org.apache.impala.catalog.ImpaladCatalog;
import org.apache.impala.catalog.local.CatalogdMetaProvider;
import org.apache.impala.catalog.local.LocalCatalog;
import org.apache.impala.service.BackendConfig;
import org.apache.impala.thrift.TUpdateCatalogCacheRequest;
import org.apache.impala.thrift.TUpdateCatalogCacheResponse;
import org.apache.thrift.TException;

public abstract class FeCatalogManager {
    private static String DEFAULT_KUDU_MASTER_HOSTS = BackendConfig.INSTANCE.getBackendCfg().kudu_master_hosts;
    protected AtomicReference<? extends AuthorizationChecker> authzChecker_;

    public static FeCatalogManager createFromBackendConfig() {
        if (BackendConfig.INSTANCE.getBackendCfg().use_local_catalog) {
            return new LocalImpl();
        }
        return new CatalogdImpl();
    }

    public static FeCatalogManager createForTests(FeCatalog testCatalog) {
        return new TestImpl(testCatalog);
    }

    public void setAuthzChecker(AtomicReference<? extends AuthorizationChecker> authzChecker) {
        this.authzChecker_ = (AtomicReference)Preconditions.checkNotNull(authzChecker);
    }

    public abstract FeCatalog getOrCreateCatalog();

    abstract TUpdateCatalogCacheResponse updateCatalogCache(TUpdateCatalogCacheRequest var1) throws CatalogException, TException;

    private static class TestImpl
    extends FeCatalogManager {
        private final FeCatalog catalog_;

        TestImpl(FeCatalog catalog) {
            this.catalog_ = catalog;
        }

        @Override
        public FeCatalog getOrCreateCatalog() {
            return this.catalog_;
        }

        @Override
        TUpdateCatalogCacheResponse updateCatalogCache(TUpdateCatalogCacheRequest req) {
            throw new IllegalStateException("Unexpected call to updateCatalogCache() with a test catalog instance");
        }
    }

    private static class LocalImpl
    extends FeCatalogManager {
        private static CatalogdMetaProvider PROVIDER = new CatalogdMetaProvider(BackendConfig.INSTANCE.getBackendCfg());

        private LocalImpl() {
        }

        @Override
        public FeCatalog getOrCreateCatalog() {
            PROVIDER.setAuthzChecker(this.authzChecker_);
            return new LocalCatalog(PROVIDER, DEFAULT_KUDU_MASTER_HOSTS);
        }

        @Override
        TUpdateCatalogCacheResponse updateCatalogCache(TUpdateCatalogCacheRequest req) {
            return PROVIDER.updateCatalogCache(req);
        }
    }

    private static class CatalogdImpl
    extends FeCatalogManager {
        private final AtomicReference<ImpaladCatalog> catalog_ = new AtomicReference();

        private CatalogdImpl() {
            this.catalog_.set(this.createNewCatalog());
        }

        @Override
        public FeCatalog getOrCreateCatalog() {
            return this.catalog_.get();
        }

        @Override
        TUpdateCatalogCacheResponse updateCatalogCache(TUpdateCatalogCacheRequest req) throws CatalogException, TException {
            ImpaladCatalog catalog = this.catalog_.get();
            if (req.is_delta) {
                return catalog.updateCatalog(req);
            }
            ImpaladCatalog oldCatalog = catalog;
            catalog = this.createNewCatalog();
            TUpdateCatalogCacheResponse response = catalog.updateCatalog(req);
            this.catalog_.set(catalog);
            if (oldCatalog != null) {
                oldCatalog.release();
            }
            return response;
        }

        private ImpaladCatalog createNewCatalog() {
            return new ImpaladCatalog(DEFAULT_KUDU_MASTER_HOSTS, this.authzChecker_);
        }
    }
}

